/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleBusDrop;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PlacementGridSupport {
    public void renderToPlacementGrid(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Set skipLinks, OverlayStateOracle oso, String overID) {
        LinkPathInfo paths = this.getBusPath(genome, layout, lp, frc, null, null, skipLinks, oso);
        if (paths == null) {
            return;
        }
        Set allForSource = genome.getOutboundLinks(lp.getSourceTag());
        if (skipLinks != null) {
            allForSource.removeAll(skipLinks);
        }
        grid.drawLink(lp.getSourceTag(), paths.path, lp, allForSource);
    }

    public void multiRenderToPlacementGrid(NetModuleLinkageProperties lp, LinkPlacementGrid grid, Map multiLinkData) {
        MultiRenderLinkPathInfo paths = this.getMultiBusPaths(lp, multiLinkData);
        if (paths == null) {
            return;
        }
        Iterator mldit = paths.srcToPaths.keySet().iterator();
        while (mldit.hasNext()) {
            String mid = (String)mldit.next();
            LinkPlacementGrid.DecoratedPath dp = (LinkPlacementGrid.DecoratedPath)paths.srcToPaths.get(mid);
            grid.drawLinkWithUserData(mid, dp, lp, new HashSet(lp.getLinkageList()));
        }
    }

    public boolean canRenderToPlacementGrid(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Set dropSet, OverlayStateOracle oso, String overID) {
        HashMap targMap = new HashMap();
        HashMap tupMap = overID == null && genome instanceof GenomeInstance ? new HashMap() : null;
        Map allSegsMap = this.fillMaps(genome, lp, layout, frc, targMap, tupMap, dropSet, oso);
        return grid.canDrawLink(lp.getSourceTag(), lp, allSegsMap, targMap, tupMap);
    }

    public Map getPointPairMap(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, OverlayStateOracle oso, String overID) {
        HashMap dummy = new HashMap();
        HashMap tupMap = overID == null && genome instanceof GenomeInstance ? new HashMap() : null;
        return this.fillMaps(genome, lp, layout, frc, dummy, tupMap, null, oso);
    }

    private Map fillMaps(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, Map targMap, Map tupMap, Set dropSet, OverlayStateOracle oso) {
        HashMap linkMap = new HashMap();
        LinkPlacementGrid.PointPair rootPair = null;
        rootPair = new LinkPlacementGrid.PointPair();
        this.getBusPath(genome, layout, lp, frc, linkMap, rootPair, null, oso);
        Map retval = lp.buildSegmentToLinksMap();
        this.mergeLinkMaps(genome, lp, retval, linkMap, targMap, tupMap, rootPair, dropSet);
        return retval;
    }

    private void mergeLinkMaps(Genome genome, LinkProperties lp, Map allSegsMap, Map linkMap, Map targMap, Map tupMap, LinkPlacementGrid.PointPair rootPair, Set dropSet) {
        if (!(rootPair == null || dropSet != null && dropSet.contains(rootPair))) {
            Iterator vit = linkMap.values().iterator();
            ArrayList<String> rootList = new ArrayList<String>();
            while (vit.hasNext()) {
                String lid = (String)vit.next();
                rootList.add(lid);
            }
            allSegsMap.put(rootPair, rootList);
        }
        Iterator lmkit = linkMap.keySet().iterator();
        while (lmkit.hasNext()) {
            LinkPlacementGrid.PointPair pair = (LinkPlacementGrid.PointPair)lmkit.next();
            if (dropSet != null && dropSet.contains(pair)) continue;
            ArrayList<String> asList = (ArrayList<String>)allSegsMap.get(pair);
            if (asList == null) {
                asList = new ArrayList<String>();
                allSegsMap.put(pair, asList);
            }
            String linkID = (String)linkMap.get(pair);
            asList.add(linkID);
            targMap.put(linkID, lp.getLinkTarget(genome, linkID));
            if (tupMap == null) continue;
            tupMap.put(linkID, ((GenomeInstance)genome).getRegionTuple(linkID));
        }
    }

    private LinkPathInfo getBusPath(Genome genome, Layout layout, LinkProperties bp, FontRenderContext frc, Map linkMap, LinkPlacementGrid.PointPair rootPair, Set skipLinks, OverlayStateOracle oso) {
        GeneralPath usePath = new GeneralPath();
        LinkPathInfo retval = new LinkPathInfo();
        retval.path = usePath;
        retval.segSet = new HashSet();
        if (bp.isDirect()) {
            LinkBusDrop endDrop = bp.getTargetDrop();
            String busID = endDrop.getTargetRef();
            if (!bp.linkIsInModel(genome, oso, busID)) {
                return null;
            }
            if (skipLinks == null || !skipLinks.contains(busID)) {
                LinkSegment fakeDirect = bp.getDirectLinkPath(genome, layout, frc);
                this.processDropSegmentIntoPaths(fakeDirect, endDrop, retval, bp, linkMap, rootPair, busID, true);
            }
        } else {
            boolean haveOneLink = false;
            LinkSegment rootSeg = null;
            LinkBusDrop rootDrop = null;
            Iterator dit = bp.getDrops();
            while (dit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)dit.next();
                String busID = drop.getTargetRef();
                int dropType = drop.getDropType();
                if (dropType != 0) {
                    if (!bp.linkIsInModel(genome, oso, busID) || skipLinks != null && skipLinks.contains(busID)) continue;
                    haveOneLink = true;
                } else {
                    rootDrop = drop;
                }
                LinkSegmentID segID = LinkSegmentID.buildIDForDrop(busID);
                LinkSegment fakeSeg = bp.getSegmentGeometryForID(segID, genome, layout, frc, true);
                if (dropType == 0) {
                    rootSeg = fakeSeg;
                    continue;
                }
                this.processDropSegmentIntoPaths(fakeSeg, drop, retval, bp, linkMap, rootPair, busID, false);
            }
            if (haveOneLink) {
                this.processDropSegmentIntoPaths(rootSeg, rootDrop, retval, bp, linkMap, rootPair, null, false);
            }
        }
        Iterator sit = retval.segSet.iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            Point2D strt = seg.getStart();
            Point2D end = seg.getEnd();
            if (end == null) continue;
            usePath.moveTo((float)strt.getX(), (float)strt.getY());
            usePath.lineTo((float)end.getX(), (float)end.getY());
        }
        return retval;
    }

    private String multiBusID(NetModuleLinkageProperties bp, String src) {
        return src + "@" + bp.getID();
    }

    private MultiRenderLinkPathInfo getMultiBusPaths(NetModuleLinkageProperties bp, Map multiLinkData) {
        MultiRenderLinkPathInfo retval = new MultiRenderLinkPathInfo();
        retval.segSet = new HashSet();
        retval.srcToPaths = new HashMap();
        Iterator mldit = multiLinkData.keySet().iterator();
        while (mldit.hasNext()) {
            Point2D pt = (Point2D)mldit.next();
            Map forPt = (Map)multiLinkData.get(pt);
            Iterator fpit = forPt.keySet().iterator();
            while (fpit.hasNext()) {
                String src = (String)fpit.next();
                String mid = this.multiBusID(bp, src);
                retval.srcToPaths.put(mid, new LinkPlacementGrid.DecoratedPath());
            }
        }
        if (bp.isDirect()) {
            NetModuleBusDrop endDrop = (NetModuleBusDrop)bp.getTargetDrop();
            NetModuleBusDrop startDrop = (NetModuleBusDrop)bp.getRootDrop();
            LinkSegment fakeDirect = bp.getDirectLinkPath(null, null, null);
            Point2D dLoc = startDrop.getEnd(0.0);
            fakeDirect.setStart(dLoc);
            dLoc = endDrop.getEnd(0.0);
            fakeDirect.setEnd(dLoc);
            this.processDropSegmentIntoMultiPaths(fakeDirect, LinkSegmentID.buildIDForDirect(bp.getSingleLinkage()), endDrop, retval, bp, multiLinkData);
        } else {
            boolean haveOneLink = false;
            LinkSegment rootSeg = null;
            NetModuleBusDrop rootDrop = null;
            Iterator dit = bp.getDrops();
            while (dit.hasNext()) {
                NetModuleBusDrop drop = (NetModuleBusDrop)dit.next();
                String busID = drop.getTargetRef();
                int dropType = drop.getDropType();
                if (dropType != 0) {
                    haveOneLink = true;
                } else {
                    rootDrop = drop;
                }
                LinkSegmentID segID = LinkSegmentID.buildIDForDrop(busID);
                LinkSegment fakeSeg = bp.getSegmentGeometryForID(segID, null, null, null, true);
                Point2D dLoc = drop.getEnd(0.0);
                if (dropType == 0) {
                    rootSeg = fakeSeg;
                    rootSeg.setStart(dLoc);
                    continue;
                }
                fakeSeg.setEnd(dLoc);
                this.processDropSegmentIntoMultiPaths(fakeSeg, segID, drop, retval, bp, multiLinkData);
            }
            if (haveOneLink) {
                this.processDropSegmentIntoMultiPaths(rootSeg, LinkSegmentID.buildIDForStartDrop(), rootDrop, retval, bp, multiLinkData);
            }
        }
        Iterator sit = retval.segSet.iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            this.segToMultiSeg(bp, seg, LinkSegmentID.buildIDForSegment(seg.getID()), retval, multiLinkData);
        }
        return retval;
    }

    private void processDropSegmentIntoPaths(LinkSegment seg, LinkBusDrop drop, LinkPathInfo retval, LinkProperties bp, Map linkMap, LinkPlacementGrid.PointPair rootPair, String busID, boolean isDirect) {
        if (seg == null) {
            return;
        }
        Point2D strt = seg.getStart();
        retval.path.moveTo((float)strt.getX(), (float)strt.getY());
        Point2D end = seg.getEnd();
        retval.path.lineTo((float)end.getX(), (float)end.getY());
        if (linkMap != null) {
            if (busID != null && !isDirect) {
                linkMap.put(new LinkPlacementGrid.PointPair(strt, end), busID);
            } else {
                rootPair.start = strt;
                rootPair.end = end;
            }
        }
        retval.segSet.addAll(bp.getSegmentsToRoot(drop));
    }

    private void processDropSegmentIntoMultiPaths(LinkSegment seg, LinkSegmentID truID, LinkBusDrop drop, MultiRenderLinkPathInfo retval, NetModuleLinkageProperties bp, Map multiLinkData) {
        if (seg == null) {
            return;
        }
        this.segToMultiSeg(bp, seg, truID, retval, multiLinkData);
        retval.segSet.addAll(bp.getSegmentsToRoot(drop));
    }

    private void segToMultiSeg(NetModuleLinkageProperties bp, LinkSegment seg, LinkSegmentID truID, MultiRenderLinkPathInfo retval, Map multiLinkData) {
        String src;
        if (seg == null) {
            return;
        }
        Point2D strt = seg.getStart();
        Point2D end = seg.getEnd();
        if (end == null) {
            return;
        }
        UiUtil.forceToGrid(strt, 10.0);
        UiUtil.forceToGrid(end, 10.0);
        Map forStartPt = (Map)multiLinkData.get(strt);
        Map forEndPt = (Map)multiLinkData.get(end);
        if (forStartPt == null || forEndPt == null) {
            System.err.println("Unexpected lack of point map: " + strt + " and/or " + end + " keys " + multiLinkData.keySet());
            return;
        }
        int myNormCanon = seg.getNormal().canonicalDir();
        boolean xVaries = myNormCanon == 1 || myNormCanon == 3;
        MinMax traceRange = new MinMax();
        traceRange.init();
        Iterator fpit = forStartPt.keySet().iterator();
        while (fpit.hasNext()) {
            src = (String)fpit.next();
            Point offsetForSrc = (Point)forStartPt.get(src);
            int useVal = xVaries ? offsetForSrc.x : offsetForSrc.y;
            traceRange.update(useVal);
        }
        fpit = forStartPt.keySet().iterator();
        while (fpit.hasNext()) {
            src = (String)fpit.next();
            String mid = this.multiBusID(bp, src);
            LinkPlacementGrid.DecoratedPath decoPath = (LinkPlacementGrid.DecoratedPath)retval.srcToPaths.get(mid);
            GeneralPath pathForSrc = decoPath.getPath();
            Point offsetForSrc = (Point)forStartPt.get(src);
            Point offsetForEnd = (Point)forEndPt.get(src);
            if (offsetForSrc == null || offsetForEnd == null) continue;
            double useX = strt.getX() + offsetForSrc.getX() * 10.0;
            double useY = strt.getY() + offsetForSrc.getY() * 10.0;
            pathForSrc.moveTo((float)useX, (float)useY);
            LinkPlacementGrid.DecoInfo di = new LinkPlacementGrid.DecoInfo(bp.getID(), truID, src, strt, myNormCanon, offsetForSrc, traceRange);
            decoPath.decorate(new Point2D.Double(useX, useY), di);
            useX = end.getX() + offsetForEnd.getX() * 10.0;
            useY = end.getY() + offsetForEnd.getY() * 10.0;
            pathForSrc.lineTo((float)useX, (float)useY);
        }
    }

    private class MultiRenderLinkPathInfo {
        Map srcToPaths;
        HashSet segSet;

        private MultiRenderLinkPathInfo() {
        }
    }

    private class LinkPathInfo {
        GeneralPath path;
        HashSet segSet;

        private LinkPathInfo() {
        }
    }
}

