/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NodeRenderBase;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class SlashFree
extends NodeRenderBase {
    private static final float SLASH_HALF_HEIGHT_ = 8.0f;
    private static final float SLASH_HALF_LENGTH_ = 3.0f;
    private static final float SLASH_HALF_OFFSET_ = 4.0f;
    private static final double INTERSECT_SQ_ = 144.0;
    private static final double INTERSECT_ = 12.0;
    private static final double TEXT_PAD_ = 10.0;
    private static final float PAD_WIDTH_ = 10.0f;
    private static final double APPROX_DIAM_ = 20.0;

    public Vector2D getDepartureDirection(int padNum, GenomeItem item, Layout layout) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        if (orient == 2 || orient == 0) {
            return padNum == 0 ? new Vector2D(1.0, 0.0) : new Vector2D(-1.0, 0.0);
        }
        if (orient == 3) {
            return padNum == 0 ? new Vector2D(0.0, -1.0) : new Vector2D(0.0, 1.0);
        }
        if (orient == 1) {
            return padNum == 0 ? new Vector2D(-1.0, 0.0) : new Vector2D(1.0, 0.0);
        }
        if (orient == 4) {
            return padNum == 0 ? new Vector2D(0.0, 1.0) : new Vector2D(0.0, -1.0);
        }
        throw new IllegalStateException();
    }

    public Vector2D getArrivalDirection(int padNum, GenomeItem item, Layout layout) {
        Vector2D depDir = this.getDepartureDirection(padNum, item, layout);
        depDir.scale(-1.0);
        return depDir;
    }

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
        Point2D origin = np.getLocation();
        float x = (float)origin.getX();
        float y = (float)origin.getY();
        int orient = np.getOrientation();
        AffineTransform trans = new AffineTransform();
        AffineTransform saveTrans = g2.getTransform();
        double radians = 0.0;
        if (orient == 2 || orient == 0) {
            radians = 0.0;
        } else if (orient == 3) {
            radians = -1.5707963267948966;
        } else if (orient == 1) {
            radians = Math.PI;
        } else if (orient == 4) {
            radians = 1.5707963267948966;
        }
        trans.rotate(radians, x, y);
        g2.transform(trans);
        boolean textGhosted = isGhosted;
        if (item instanceof NodeInstance) {
            int activityLevel = ((NodeInstance)item).getActivity();
            isGhosted = isGhosted || activityLevel == 3 || activityLevel == 1;
            textGhosted = isGhosted && activityLevel != 3;
        }
        Color vac = this.getVariableActivityColor(item, np.getColor(), false, dopt);
        Color col = isGhosted ? Color.LIGHT_GRAY : vac;
        Color textCol = this.getVariableActivityColor(item, Color.BLACK, true, dopt);
        this.roundSelectionSupport(g2, selected, origin.getX(), origin.getY(), 12.0);
        g2.setPaint(col);
        g2.setStroke(new BasicStroke(3.0f, 1, 0));
        GeneralPath path = new GeneralPath();
        path.moveTo(x - 3.0f - 4.0f, y + 8.0f);
        path.lineTo(x + 3.0f - 4.0f, y - 8.0f);
        g2.draw(path);
        path.reset();
        path.moveTo(x + 3.0f + 4.0f, y - 8.0f);
        path.lineTo(x - 3.0f + 4.0f, y + 8.0f);
        g2.draw(path);
        g2.setTransform(saveTrans);
        FontRenderContext frc = g2.getFontRenderContext();
        if (showBubbles) {
            this.renderPads(g2, isGhosted ? Color.LIGHT_GRAY : Color.BLACK, item, layout, frc);
        }
        String name = item.getName();
        g2.setPaint(textGhosted ? Color.LIGHT_GRAY : textCol);
        Point2D textEnd = this.renderText(g2, (float)((double)x + 10.0), (float)((double)y - 10.0), name, np.getHideName(), mFont, np.getLineBreakDef());
        Point2D.Double pieCenter = new Point2D.Double(textEnd.getX() + 15.0, textEnd.getY());
        this.drawVariableActivityPie(g2, item, col, pieCenter, dopt);
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double x = origin.getX();
        double y = origin.getY();
        double dx = x - pt.getX();
        double dy = y - pt.getY();
        double distsq = dx * dx + dy * dy;
        String name = item.getName();
        if (name != null && !name.trim().equals("") && this.isTextCandidate(frc, 1, np.getFontOverride(), name, 10.0, dx, distsq, np.getLineBreakDef(), false, np.getHideName()) && this.intersectTextLabel(frc, (float)(x + 10.0), (float)(y - 10.0), name, pt, np.getHideName(), 1, np.getFontOverride(), np.getLineBreakDef())) {
            return new Intersection(item.getID(), null, 0.0);
        }
        if (distsq <= 144.0) {
            List pads = this.calcPadIntersects(item, layout, frc, pt);
            if (pads != null) {
                return new Intersection(item.getID(), pads);
            }
            return new Intersection(item.getID(), null, Math.sqrt(distsq));
        }
        return null;
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        double cY;
        Rectangle2D.Double inbounds = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double cX = origin.getX();
        Rectangle2D.Double myBounds = new Rectangle2D.Double(cX - 12.0, (cY = origin.getY()) - 12.0, 24.0, 24.0);
        if (inbounds.contains(myBounds)) {
            return new Intersection(item.getID(), null, 0.0);
        }
        return null;
    }

    public Vector2D getLaunchPadOffset(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        return this.getLaunchPadOffsetGuts(padNum, orient);
    }

    private Vector2D getLaunchPadOffsetGuts(int padNum, int orient) {
        if (orient == 2 || orient == 0) {
            return padNum == 0 ? new Vector2D(4.0, 0.0) : new Vector2D(-4.0, 0.0);
        }
        if (orient == 3) {
            return padNum == 0 ? new Vector2D(0.0, -4.0) : new Vector2D(0.0, 4.0);
        }
        if (orient == 1) {
            return padNum == 0 ? new Vector2D(-4.0, 0.0) : new Vector2D(4.0, 0.0);
        }
        if (orient == 4) {
            return padNum == 0 ? new Vector2D(0.0, 4.0) : new Vector2D(0.0, -4.0);
        }
        throw new IllegalStateException();
    }

    public Vector2D getLandingPadOffset(int padNum, GenomeItem item, int sign, Layout layout, FontRenderContext frc) {
        return this.getLaunchPadOffset(padNum, item, layout, frc);
    }

    public double getLandingPadWidth(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 8.0;
    }

    public int getFixedLaunchPadMax() {
        return 2;
    }

    public int getFixedLandingPadMax() {
        return 2;
    }

    public NodeInsertionDirective getInsertionDirective(Vector2D travel, Point2D insertion) {
        if (travel.getX() == 0.0) {
            if (travel.getY() < 0.0) {
                return new NodeInsertionDirective(1, 0, 3);
            }
            return new NodeInsertionDirective(1, 0, 4);
        }
        if (travel.getY() == 0.0) {
            if (travel.getX() < 0.0) {
                return new NodeInsertionDirective(1, 0, 1);
            }
            return new NodeInsertionDirective(1, 0, 2);
        }
        if (Math.abs(travel.getX()) >= Math.abs(travel.getY())) {
            if (travel.getX() > 0.0) {
                return new NodeInsertionDirective(1, 0, 2);
            }
            return new NodeInsertionDirective(1, 0, 1);
        }
        if (travel.getY() > 0.0) {
            return new NodeInsertionDirective(1, 0, 4);
        }
        return new NodeInsertionDirective(1, 0, 3);
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        int x = (int)origin.getX();
        int y = (int)origin.getY();
        int half = 10;
        return new Rectangle(x - half, y - half, 20, 20);
    }

    public Rectangle2D getBoundsForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, int orientation, boolean labelToo, Integer topPadCount) {
        if (topPadCount != null && topPadCount > 1) {
            throw new IllegalArgumentException();
        }
        NodeProperties np = layout.getNodeProperties(item.getID());
        int half = 10;
        Rectangle basic = new Rectangle(-half, -half, 20, 20);
        if (labelToo && !np.getHideName()) {
            Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
            String breakDef = np.getLineBreakDef();
            Rectangle2D textRect = this.getTextBounds(frc, 10.0f, 10.0f, item.getName(), false, mFont, breakDef);
            Rectangle fullRect = UiUtil.rectFromRect2D(textRect);
            return fullRect.union(basic);
        }
        return basic;
    }

    public Vector2D getLaunchPadOffsetForLayout(GenomeItem item, Layout layout, FontRenderContext frc, int orientation, Integer topPadCount) {
        return this.getLaunchPadOffsetGuts(0, orientation);
    }

    public int topPadCount(int fullPadCount) {
        return 1;
    }

    public double getGlyphHeightForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 20.0;
    }

    public double getWidth(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 20.0;
    }

    private void renderPads(Graphics2D g2, Color col, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        g2.setPaint(col);
        g2.setStroke(new BasicStroke(1.0f));
        Vector2D lpo = this.getLaunchPadOffset(0, item, layout, frc);
        double x = origin.getX() + lpo.getX();
        double y = origin.getY() + lpo.getY();
        double padRadius = 4.0;
        Ellipse2D.Double circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
        g2.draw(circ);
        lpo = this.getLaunchPadOffset(1, item, layout, frc);
        x = origin.getX() + lpo.getX();
        y = origin.getY() + lpo.getY();
        circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
        g2.draw(circ);
    }

    private List calcPadIntersects(GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt) {
        ArrayList<Intersection.PadVal> retval = new ArrayList<Intersection.PadVal>();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        Vector2D clickVec = new Vector2D(origin, pt);
        for (int i = 0; i < 2; ++i) {
            Vector2D lpo = this.getLaunchPadOffset(i, item, layout, frc);
            double dot = lpo.dot(clickVec);
            if (!(dot >= 0.0)) continue;
            double x = origin.getX() + lpo.getX();
            double y = origin.getY() + lpo.getY();
            double px = pt.getX();
            double py = pt.getY();
            double distSq = (px - x) * (px - x) + (py - y) * (py - y);
            Intersection.PadVal retpad = new Intersection.PadVal();
            retpad.okEnd = true;
            retpad.okStart = true;
            retpad.padNum = i;
            retpad.distance = Math.sqrt(distSq);
            retval.add(retpad);
        }
        return retval.isEmpty() ? null : retval;
    }
}

