/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;

public class ClusterBattery {
    TreeMap clustersByName = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    Set inputs = new HashSet();

    ClusterBattery() {
    }

    void setSources(Set srcs) {
        this.inputs.clear();
        this.inputs.addAll(srcs);
    }

    int getSize() {
        return this.clustersByName.size();
    }

    Dimension getLayout() {
        int size = this.getSize();
        double squareSize = Math.ceil(Math.sqrt(size));
        return new Dimension((int)squareSize, (int)squareSize);
    }

    void addCluster(GeneAndSatelliteCluster cluster, Genome genome) {
        if (!cluster.inputSetMatches(this.inputs)) {
            throw new IllegalArgumentException();
        }
        Node cTarg = genome.getNode(cluster.getCoreID());
        String targName = cTarg.getName();
        this.clustersByName.put(targName, cluster);
    }

    static Map findBatteries(Collection clusters, Genome genome, boolean dropSingletons) {
        HashMap<Set, ClusterBattery> retval = new HashMap<Set, ClusterBattery>();
        Iterator cit = clusters.iterator();
        while (cit.hasNext()) {
            GeneAndSatelliteCluster cluster = (GeneAndSatelliteCluster)cit.next();
            Set cinputs = cluster.getInputs();
            ClusterBattery cbat = (ClusterBattery)retval.get(cinputs);
            if (cbat == null) {
                cbat = new ClusterBattery();
                cbat.setSources(cinputs);
                retval.put(cinputs, cbat);
            }
            cbat.addCluster(cluster, genome);
        }
        if (dropSingletons) {
            HashSet retKeys = new HashSet(retval.keySet());
            Iterator rkit = retKeys.iterator();
            while (rkit.hasNext()) {
                Object key = rkit.next();
                ClusterBattery battery = (ClusterBattery)retval.get(key);
                if (battery.getSize() >= 2) continue;
                retval.remove(key);
            }
        }
        return retval;
    }
}

