/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.LinkAnnotatedSuper;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SuperSourceCluster;
import org.systemsbiology.biotapestry.ui.layouts.SuperSrcRouterPointSource;
import org.systemsbiology.biotapestry.util.Bounds;

public class ClusterSeries {
    private static final double MIN_CLUSTER_SEPARATION_ = 100.0;
    private static final double FEED_PAD_ = 80.0;
    private Point2D basePos_;
    private HashSet preSources_;
    private HashSet postTargets_;
    private TreeMap superClusters_ = new TreeMap();
    private HashMap srcToTrack_ = new HashMap();
    private TreeMap trackToSrc_ = new TreeMap();
    private HashMap baseForCluster_;
    private HashMap trackToY_ = new HashMap();
    private HashMap isOnTop_;
    private HashMap srcToCol_;
    private HashMap srcToFeedbackY_;
    private HashMap deferredStackSrcToY_;
    private TreeMap topFeedOrder_;
    private TreeMap botFeedOrder_;
    private double noTracksMinY_;
    private boolean isStacked_;
    private double traceOffset_;

    public ClusterSeries(boolean isStacked, int traceMult) {
        this.baseForCluster_ = new HashMap();
        this.topFeedOrder_ = new TreeMap();
        this.botFeedOrder_ = new TreeMap();
        this.srcToFeedbackY_ = new HashMap();
        this.deferredStackSrcToY_ = new HashMap();
        this.isOnTop_ = new HashMap();
        this.srcToCol_ = new HashMap();
        this.isStacked_ = isStacked;
        this.preSources_ = new HashSet();
        this.postTargets_ = new HashSet();
        this.traceOffset_ = 10.0 * (double)traceMult;
    }

    public double getTraceOffset() {
        return this.traceOffset_;
    }

    public void addPreAndPost(GenomeSubset subset) {
        if (this.isStacked_) {
            throw new IllegalStateException();
        }
        this.preSources_.addAll(subset.externalSourceOnly);
        this.preSources_.addAll(subset.externalBothSrcTarget);
        this.postTargets_.addAll(subset.externalTargetOnly);
        this.postTargets_.addAll(subset.externalBothSrcTarget);
    }

    public Set justSourcesOfInterest() {
        HashSet retval = new HashSet();
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            retval.addAll(las.ssc.getAllSources());
            retval.addAll(las.ssc.getAllInputs());
        }
        return retval;
    }

    public void addSourceCluster(int index, GeneAndSatelliteCluster newClust) {
        Integer key = new Integer(index);
        LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(key);
        if (las == null) {
            SuperSourceCluster ssc = new SuperSourceCluster(this.isStacked_, this.traceOffset_);
            las = new LinkAnnotatedSuper(ssc);
            this.superClusters_.put(key, las);
        }
        las.ssc.addSourceCluster(newClust);
    }

    public Map getDeferredSrcToTraceY() {
        return this.isStacked_ ? this.deferredStackSrcToY_ : this.srcToFeedbackY_;
    }

    public void prepForStackPass1(Genome genome, Layout lo, FontRenderContext frc, Map targets, Map sources, Map order, int myRow) {
        this.annotateLASForStack(genome, targets, sources, order, myRow);
        this.assignCenterlineLocalOnly();
        this.finishClusterPrep(genome, lo, frc);
    }

    public void prepForStackPass2(Genome genome, Layout lo, FontRenderContext frc, Map targets, Map sources, Map order, int myRow, GlobalTrackAssignment gta) {
        this.srcToTrack_ = new HashMap();
        this.trackToSrc_ = new TreeMap();
        TreeMap<Integer, String> minimizedTracks = new TreeMap<Integer, String>();
        Set soi = this.justSourcesOfInterest();
        Iterator sit = soi.iterator();
        while (sit.hasNext()) {
            String src = (String)sit.next();
            Integer track = (Integer)gta.globalSrcToTrack.get(src);
            minimizedTracks.put(track, src);
        }
        int count = 0;
        Iterator mtrit = minimizedTracks.values().iterator();
        while (mtrit.hasNext()) {
            String src = (String)mtrit.next();
            Integer trackNum = new Integer(count++);
            this.srcToTrack_.put(src, trackNum);
            this.trackToSrc_.put(trackNum, src);
        }
        int currMaxTrack = this.trackToSrc_.isEmpty() ? 0 : (Integer)this.trackToSrc_.lastKey();
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            this.baseForCluster_.put(clustNum, new Integer(currMaxTrack));
        }
        this.prepCommon(genome, currMaxTrack);
    }

    public void prepForSingle(GenomeSubset subset, Layout lo, FontRenderContext frc) {
        Genome baseGenome = subset.getBaseGenome();
        HashMap targets = new HashMap();
        HashMap sources = new HashMap();
        HashMap order = new HashMap();
        this.preprocessForAnnotate(subset, targets, sources, order, 0);
        this.annotateLASForStack(baseGenome, targets, sources, order, 0);
        this.assignCenterlineLocalOnly();
        this.finishClusterPrep(baseGenome, lo, frc);
        int currMaxTrack = this.assignTrackNumbersLocalOnly(baseGenome);
        this.prepCommon(baseGenome, currMaxTrack);
    }

    private void prepCommon(Genome genome, int currMaxTrack) {
        Integer clustNum;
        if (this.isStacked_) {
            Iterator bit = this.baseForCluster_.keySet().iterator();
            Integer cmt = new Integer(currMaxTrack);
            while (bit.hasNext()) {
                clustNum = (Integer)bit.next();
                this.baseForCluster_.put(clustNum, cmt);
            }
        }
        boolean addBottom = this.isStacked_;
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.ssc.orderFeedbackTraces(genome, addBottom, this.topFeedOrder_, this.botFeedOrder_, las);
            if (this.isStacked_) continue;
            addBottom = !addBottom;
        }
        addBottom = this.isStacked_;
        LinkAnnotatedSuper lastLas = null;
        scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum2 = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum2);
            las.ssc.orderInboundTraces(genome, addBottom, las, this.topFeedOrder_, this.botFeedOrder_, this.srcToTrack_, lastLas);
            if (this.isStacked_) continue;
            lastLas = las;
            addBottom = !addBottom;
        }
    }

    private void assignCenterlineLocalOnly() {
        boolean onBottom = this.isStacked_;
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer currClustNum = (Integer)scit.next();
            LinkAnnotatedSuper currLas = (LinkAnnotatedSuper)this.superClusters_.get(currClustNum);
            Set allSources = currLas.ssc.getAllSources();
            Iterator asit = allSources.iterator();
            Boolean onTopObj = new Boolean(!onBottom);
            while (asit.hasNext()) {
                String srcID = (String)asit.next();
                this.isOnTop_.put(srcID, onTopObj);
                this.srcToCol_.put(srcID, currClustNum);
            }
            if (this.isStacked_) continue;
            onBottom = !onBottom;
        }
    }

    private int assignTrackNumbersLocalOnly(Genome genome) {
        GlobalTrackAssignment gta = new GlobalTrackAssignment();
        this.srcToTrack_ = gta.globalSrcToTrack;
        this.trackToSrc_ = gta.globalTrackToSrc;
        return this.buildGlobalTrackNumbers(genome, false, true, gta);
    }

    private int buildGlobalTrackNumbers(Genome genome, boolean reverse, boolean trackBase, GlobalTrackAssignment gta) {
        boolean addBottom;
        boolean bl = addBottom = this.isStacked_;
        if (!this.isStacked_) {
            int externalTrack = 0;
            Iterator oit = this.preSources_.iterator();
            while (oit.hasNext()) {
                String srcID = (String)oit.next();
                Integer track = new Integer(externalTrack++);
                gta.globalSrcToTrack.put(srcID, track);
                gta.globalTrackToSrc.put(track, srcID);
                ++gta.currMaxTrack;
            }
        }
        TreeSet revSC = !reverse ? new TreeSet() : new TreeSet(Collections.reverseOrder());
        revSC.addAll(this.superClusters_.keySet());
        Iterator scit = revSC.iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            if (trackBase) {
                int base = addBottom ? gta.currMaxTrack : gta.currMinTrack;
                this.baseForCluster_.put(clustNum, new Integer(base));
            }
            this.assignForSet(las.immediateOutputs, genome, las, addBottom, gta.currMaxTrack, gta.currMinTrack, gta.globalSrcToTrack, gta.globalTrackToSrc);
            this.assignForSet(las.forwardOutputs, genome, las, addBottom, gta.currMaxTrack, gta.currMinTrack, gta.globalSrcToTrack, gta.globalTrackToSrc);
            this.assignForSet(las.afterRowTargets, genome, las, addBottom, gta.currMaxTrack, gta.currMinTrack, gta.globalSrcToTrack, gta.globalTrackToSrc);
            int orderMax = las.ssc.getOutboundLinkOrderMax();
            if (this.isStacked_) {
                this.assignBackwardsForSetToMain(las.backwardOutputs, genome, las, addBottom, gta.currMaxTrack, gta.currMinTrack, orderMax, gta.globalSrcToTrack, gta.globalTrackToSrc);
                this.assignBackwardsForSetToMain(las.beforeRowTargets, genome, las, addBottom, gta.currMaxTrack, gta.currMinTrack, orderMax, gta.globalSrcToTrack, gta.globalTrackToSrc);
                this.assignBackwardsForSetToMain(las.afterRowTargets, genome, las, addBottom, gta.currMaxTrack, gta.currMinTrack, orderMax, gta.globalSrcToTrack, gta.globalTrackToSrc);
            }
            if (addBottom) {
                gta.currMaxTrack += orderMax;
                addBottom = this.isStacked_;
                continue;
            }
            gta.currMinTrack -= orderMax;
            addBottom = true;
        }
        return gta.currMaxTrack;
    }

    public int calcGlobalTrackNumbers(Genome genome, GlobalTrackAssignment gta) {
        return this.buildGlobalTrackNumbers(genome, true, false, gta);
    }

    private void assignBackwardsForSetToMain(Set linkSet, Genome genome, LinkAnnotatedSuper las, boolean addBottom, int currMaxTrack, int currMinTrack, int orderMax, Map srcToTrack, Map trackToSrc) {
        Iterator oit = linkSet.iterator();
        while (oit.hasNext()) {
            String linkID = (String)oit.next();
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            if (!las.pureBackwardOutputSources.contains(srcID)) continue;
            int outOrder = las.ssc.getOutboundLinkOrder(link);
            if (this.isStacked_) {
                outOrder = orderMax - outOrder;
            }
            int newTrack = addBottom ? currMaxTrack + outOrder : currMinTrack - orderMax + outOrder;
            Integer track = new Integer(newTrack);
            srcToTrack.put(srcID, track);
            trackToSrc.put(track, srcID);
        }
    }

    private void assignForSet(Set linkSet, Genome genome, LinkAnnotatedSuper las, boolean addBottom, int currMaxTrack, int currMinTrack, Map srcToTrack, Map trackToSrc) {
        int orderMax = las.ssc.getOutboundLinkOrderMax();
        Iterator oit = linkSet.iterator();
        while (oit.hasNext()) {
            String linkID = (String)oit.next();
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            int outOrder = las.ssc.getOutboundLinkOrder(link);
            if (this.isStacked_) {
                outOrder = orderMax - outOrder;
            }
            int newTrack = addBottom ? currMaxTrack + outOrder : currMinTrack - orderMax + outOrder;
            Integer track = new Integer(newTrack);
            srcToTrack.put(srcID, track);
            trackToSrc.put(track, srcID);
        }
    }

    public void preprocessForAnnotate(GenomeSubset subset, Map targets, Map sources, Map order, int myRow) {
        Genome baseGenome = subset.getBaseGenome();
        int count = 0;
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.ssc.prep(subset);
            order.put(new Point(clustNum, myRow), new Integer(count++));
        }
        Iterator lit = subset.getLinkageSuperSetIterator();
        block1: while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            scit = this.superClusters_.keySet().iterator();
            while (scit.hasNext()) {
                Integer clustNum = (Integer)scit.next();
                LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
                if (las.ssc.linkIsInternal(link)) continue block1;
                int myNum = clustNum;
                if (las.ssc.linkIsInbound(link)) {
                    las.allInputs.add(linkID);
                    targets.put(linkID, new Point(myNum, myRow));
                }
                if (!las.ssc.linkIsOutbound(link)) continue;
                las.allOutputs.add(linkID);
                sources.put(linkID, new Point(myNum, myRow));
            }
        }
    }

    public void annotateLASForStack(Genome genome, Map targets, Map sources, Map order, int myRow) {
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            String linkID;
            Integer clustNum = (Integer)scit.next();
            Point clustPt = new Point(clustNum, myRow);
            int currClust = (Integer)order.get(clustPt);
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.srcRow = myRow;
            las.srcCol = currClust;
            HashSet allInputs = las.allInputs;
            HashSet allOutputs = las.allOutputs;
            las.allInputs = null;
            las.allOutputs = null;
            Iterator aiit = allInputs.iterator();
            while (aiit.hasNext()) {
                String linkID2 = (String)aiit.next();
                Point ptObj = (Point)sources.get(linkID2);
                if (ptObj == null) {
                    las.beforeRowSources.add(linkID2);
                    continue;
                }
                int srcNum = (Integer)order.get(ptObj);
                if (ptObj.y < myRow) {
                    las.beforeRowSources.add(linkID2);
                    continue;
                }
                if (ptObj.y > myRow) {
                    las.afterRowSources.add(linkID2);
                    continue;
                }
                if (srcNum == currClust - 1) {
                    las.immediateInputs.add(linkID2);
                    continue;
                }
                if (srcNum < currClust) {
                    las.pastInputs.add(linkID2);
                    continue;
                }
                if (srcNum >= currClust) {
                    las.backwardInputs.add(linkID2);
                    Linkage link = genome.getLinkage(linkID2);
                    las.backwardSources.add(link.getSource());
                    continue;
                }
                throw new IllegalStateException();
            }
            Iterator aoit = allOutputs.iterator();
            while (aoit.hasNext()) {
                linkID = (String)aoit.next();
                Linkage link = genome.getLinkage(linkID);
                las.pureBackwardOutputSources.add(link.getSource());
            }
            aoit = allOutputs.iterator();
            while (aoit.hasNext()) {
                linkID = (String)aoit.next();
                Linkage link = genome.getLinkage(linkID);
                Point ptObj = (Point)targets.get(linkID);
                if (ptObj == null) {
                    las.afterRowTargets.add(linkID);
                    continue;
                }
                int trgNum = (Integer)order.get(ptObj);
                if (ptObj.y < myRow) {
                    las.beforeRowTargets.add(linkID);
                    continue;
                }
                if (ptObj.y > myRow) {
                    las.afterRowTargets.add(linkID);
                    continue;
                }
                if (trgNum == currClust + 1) {
                    las.immediateOutputs.add(linkID);
                    las.pureBackwardOutputSources.remove(link.getSource());
                    continue;
                }
                if (trgNum > currClust) {
                    las.forwardOutputs.add(linkID);
                    las.pureBackwardOutputSources.remove(link.getSource());
                    continue;
                }
                if (trgNum <= currClust) {
                    las.backwardOutputs.add(linkID);
                    continue;
                }
                throw new IllegalStateException();
            }
        }
    }

    public double getMaximumHeight(Genome genome, Layout lo, FontRenderContext frc) {
        double maxHeight = Double.NEGATIVE_INFINITY;
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer nextClustNum = (Integer)scit.next();
            LinkAnnotatedSuper currLas = (LinkAnnotatedSuper)this.superClusters_.get(nextClustNum);
            double height = currLas.ssc.getHeight(genome, lo, frc, this.traceOffset_);
            if (!(height > maxHeight)) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    public Rectangle getNodeOnlyBounds(Map placement, Genome genome, Layout lo, FontRenderContext frc) {
        Rectangle retval = null;
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer nextClustNum = (Integer)scit.next();
            LinkAnnotatedSuper currLas = (LinkAnnotatedSuper)this.superClusters_.get(nextClustNum);
            Rectangle nsBounds = currLas.ssc.getNodeOnlyBounds(placement, genome, lo, frc);
            if (retval == null) {
                retval = (Rectangle)nsBounds.clone();
                continue;
            }
            if (nsBounds == null) continue;
            Bounds.tweakBounds(retval, nsBounds);
        }
        return retval;
    }

    public Point2D getBasePos() {
        return this.basePos_;
    }

    public Point2D locate(Point2D basePos, Map positions, Genome genome, Layout lo, FontRenderContext frc, Double matchMax) {
        Integer currClustNum;
        this.basePos_ = (Point2D)basePos.clone();
        double baseX = basePos.getX();
        double baseY = basePos.getY();
        boolean addBottom = this.isStacked_;
        double currX = baseX;
        double minYVal = baseY;
        double maxYVal = baseY;
        Map lastOutboundTraces = null;
        Iterator scit = this.superClusters_.keySet().iterator();
        Integer n = currClustNum = scit.hasNext() ? (Integer)scit.next() : null;
        while (currClustNum != null) {
            double useForMin;
            LinkAnnotatedSuper useForNext;
            Point2D.Double pos;
            double sign;
            Integer nextClustNum = scit.hasNext() ? (Integer)scit.next() : null;
            LinkAnnotatedSuper currLas = (LinkAnnotatedSuper)this.superClusters_.get(currClustNum);
            LinkAnnotatedSuper nextLas = nextClustNum != null ? (LinkAnnotatedSuper)this.superClusters_.get(nextClustNum) : null;
            Integer baseObj = (Integer)this.baseForCluster_.get(currClustNum);
            int baseVal = baseObj;
            double d = sign = baseVal < 0 ? -1.0 : 1.0;
            if (this.isStacked_) {
                pos = new Point2D.Double(currX, baseY);
                useForNext = null;
                useForMin = 0.0;
            } else {
                pos = new Point2D.Double(currX, baseY + (double)baseVal * this.traceOffset_ + sign * 100.0);
                useForNext = nextLas;
                useForMin = 100.0;
            }
            Point2D right = currLas.ssc.locate(pos, positions, genome, lo, frc, addBottom, this.isOnTop_, this.traceOffset_, currLas, lastOutboundTraces, useForNext, useForMin, matchMax);
            if (addBottom) {
                if (right.getY() > maxYVal) {
                    maxYVal = right.getY();
                }
            } else if (right.getY() < minYVal) {
                minYVal = right.getY();
            }
            currX = right.getX();
            if (!this.isStacked_) {
                addBottom = !addBottom;
                lastOutboundTraces = currLas.ssc.getOutboundTraces();
            }
            currClustNum = nextClustNum;
        }
        if (!this.isStacked_) {
            this.setTrackPlacementCore(baseY, minYVal, maxYVal, 80.0);
        }
        return new Point2D.Double(currX, baseY);
    }

    public double setTrackPlacementForStacked(double baseY) {
        Double trackY;
        Integer trackNum;
        if (!this.isStacked_) {
            throw new IllegalStateException();
        }
        double maxTrackY = Double.NEGATIVE_INFINITY;
        Iterator trit = this.trackToSrc_.keySet().iterator();
        while (trit.hasNext()) {
            Integer trackNum2 = (Integer)trit.next();
            int trackNumVal = trackNum2;
            double trackY2 = baseY + (double)trackNumVal * this.traceOffset_;
            this.trackToY_.put(trackNum2, new Double(trackY2));
            if (!(trackY2 > maxTrackY)) continue;
            maxTrackY = trackY2;
        }
        if (this.trackToY_.isEmpty()) {
            this.noTracksMinY_ = baseY;
        }
        Iterator bfkit = this.botFeedOrder_.keySet().iterator();
        while (bfkit.hasNext()) {
            Integer pos = (Integer)bfkit.next();
            String srcID = (String)this.botFeedOrder_.get(pos);
            trackNum = (Integer)this.srcToTrack_.get(srcID);
            trackY = (Double)this.trackToY_.get(trackNum);
            this.deferredStackSrcToY_.put(srcID, trackY);
        }
        Iterator stit = this.srcToTrack_.keySet().iterator();
        while (stit.hasNext()) {
            String srcID = (String)stit.next();
            trackNum = (Integer)this.srcToTrack_.get(srcID);
            trackY = (Double)this.trackToY_.get(trackNum);
            this.deferredStackSrcToY_.put(srcID, trackY);
        }
        return maxTrackY == Double.NEGATIVE_INFINITY ? baseY : maxTrackY;
    }

    private double setTrackPlacementCore(double baseY, double minYVal, double maxYVal, double pad) {
        if (this.isStacked_) {
            throw new IllegalStateException();
        }
        double maxTrackY = Double.NEGATIVE_INFINITY;
        Iterator trit = this.trackToSrc_.keySet().iterator();
        while (trit.hasNext()) {
            Integer trackNum = (Integer)trit.next();
            int trackNumVal = trackNum;
            double trackY = baseY + (double)trackNumVal * this.traceOffset_;
            this.trackToY_.put(trackNum, new Double(trackY));
            if (!(trackY > maxTrackY)) continue;
            maxTrackY = trackY;
        }
        if (this.trackToY_.isEmpty()) {
            this.noTracksMinY_ = minYVal;
        }
        double veryTop = minYVal - pad;
        double veryBottom = maxYVal + pad;
        Iterator tfkit = this.topFeedOrder_.keySet().iterator();
        while (tfkit.hasNext()) {
            Integer pos = (Integer)tfkit.next();
            String srcID = (String)this.topFeedOrder_.get(pos);
            double feedY = veryTop + pos.doubleValue() * this.traceOffset_;
            this.srcToFeedbackY_.put(srcID, new Double(feedY));
        }
        Iterator bfkit = this.botFeedOrder_.keySet().iterator();
        while (bfkit.hasNext()) {
            Integer pos = (Integer)bfkit.next();
            String srcID = (String)this.botFeedOrder_.get(pos);
            double feedY = veryBottom + pos.doubleValue() * this.traceOffset_;
            this.srcToFeedbackY_.put(srcID, new Double(feedY));
        }
        return maxTrackY;
    }

    public void finishClusterPrep(Genome genome, Layout lo, FontRenderContext frc) {
        boolean baseAtTop = this.isStacked_;
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.ssc.finishClusterPrep(genome, lo, frc, baseAtTop, this.isOnTop_, this.srcToCol_, clustNum);
            if (!scit.hasNext() || this.isStacked_) continue;
            baseAtTop = !baseAtTop;
        }
    }

    public void routeLinks(GenomeSubset subset, Map padChanges, Map lengthChanges, Map extraGrowthChanges, Layout lo, FontRenderContext frc, Map placement, SpecialtyInstructions si, Map traceDefs) {
        if (this.isStacked_) {
            throw new IllegalStateException();
        }
        Genome baseGenome = subset.getBaseGenome();
        Iterator asit = subset.getSourcesHeadedIn().iterator();
        while (asit.hasNext()) {
            String srcID = (String)asit.next();
            SuperSrcRouterPointSource corners = new SuperSrcRouterPointSource(srcID, false, false);
            traceDefs.put(srcID, corners);
            Integer tracknum = (Integer)this.srcToTrack_.get(srcID);
            Double trackVal = new Double(this.basePos_.getX() - tracknum.doubleValue() * this.traceOffset_);
            Double trackY = (Double)this.trackToY_.get(tracknum);
            corners.initForExternal(trackVal, trackY, null, 0);
        }
        boolean addBottom = false;
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.deferredTerminalPaths = new HashMap();
            las.ssc.routeInboundLinks(subset, padChanges, lengthChanges, extraGrowthChanges, lo, frc, placement, si, traceDefs, las.deferredTerminalPaths, addBottom, this.isOnTop_, this.getDeferredSrcToTraceY(), 0, null);
            las.ssc.startOutboundLinks(baseGenome, padChanges, lo, frc, placement, si, this.trackToY_, this.srcToTrack_, this.getDeferredSrcToTraceY(), addBottom, traceDefs, las, false);
            if (!scit.hasNext()) continue;
            addBottom = !addBottom;
        }
        ArrayList revList = new ArrayList(this.superClusters_.keySet());
        Collections.reverse(revList);
        scit = revList.iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.ssc.finishInboundDeferredLinks(baseGenome, si, las.deferredTerminalPaths, traceDefs, this.traceOffset_, addBottom, las, placement, padChanges, lo, frc, 0, null, 0);
            addBottom = !addBottom;
        }
    }

    public void routeLinksForStackPass1(GenomeSubset subset, Map padChanges, Map lengthChanges, Map extraGrowthChanges, Layout lo, FontRenderContext frc, Map placement, SpecialtyInstructions si, Map traceDefs, int stackRow, Map globalTraceFrame, Map sourceToStack, Set rowSources, GlobalTrackAssignment gta) {
        if (!this.isStacked_) {
            throw new IllegalStateException();
        }
        Genome baseGenome = subset.getBaseGenome();
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.deferredTerminalPaths = new HashMap();
            las.ssc.routeInboundLinks(subset, padChanges, lengthChanges, extraGrowthChanges, lo, frc, placement, si, traceDefs, las.deferredTerminalPaths, true, this.isOnTop_, this.getDeferredSrcToTraceY(), stackRow, sourceToStack);
            las.ssc.startOutboundLinks(baseGenome, padChanges, lo, frc, placement, si, this.trackToY_, this.srcToTrack_, this.getDeferredSrcToTraceY(), true, traceDefs, las, true);
        }
        Iterator asit = rowSources.iterator();
        while (asit.hasNext()) {
            String srcID = (String)asit.next();
            SuperSrcRouterPointSource corners = (SuperSrcRouterPointSource)traceDefs.get(srcID);
            corners.setStackOriginRow(stackRow, globalTraceFrame);
            corners.setCurrStackRow(stackRow);
        }
        scit = this.superClusters_.keySet().iterator();
        HashSet onlySrcs = new HashSet();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            las.ssc.finishInboundDeferredLinks(baseGenome, si, las.deferredTerminalPaths, traceDefs, this.traceOffset_, true, las, placement, padChanges, lo, frc, stackRow, onlySrcs, 1);
            onlySrcs.addAll(las.forwardSources(baseGenome));
        }
    }

    public void routeLinksForStackPass2(Genome genome, Map padChanges, Map lengthChanges, Map extraGrowthChanges, Layout lo, FontRenderContext frc, Map placement, SpecialtyInstructions si, Map traceDefs, int ourRow, int sourceRow, Set sourceRowSources) {
        if (!this.isStacked_) {
            throw new IllegalStateException();
        }
        ArrayList keyList = new ArrayList(this.superClusters_.keySet());
        if (ourRow == sourceRow) {
            Collections.reverse(keyList);
        }
        HashSet onlySrcs = ourRow == sourceRow ? new HashSet() : new HashSet(sourceRowSources);
        Iterator scit = keyList.iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            if (ourRow == sourceRow) {
                onlySrcs.addAll(las.backwardSources(genome));
            }
            las.ssc.finishInboundDeferredLinks(genome, si, las.deferredTerminalPaths, traceDefs, this.traceOffset_, true, las, placement, padChanges, lo, frc, ourRow, onlySrcs, 2);
        }
    }

    public boolean hasTrackForSource(String srcID) {
        return this.srcToTrack_.get(srcID) != null;
    }

    public int getTrackForSource(String srcID) {
        Integer val = (Integer)this.srcToTrack_.get(srcID);
        if (val == null) {
            throw new IllegalArgumentException();
        }
        return val;
    }

    public int getTrackIndexForSource(String srcID) {
        List stOrder = this.getSourceTrackOrder();
        return stOrder.indexOf(srcID);
    }

    public List getSourceTrackOrder() {
        return new ArrayList(this.trackToSrc_.values());
    }

    public int trackCount() {
        return this.srcToTrack_.size();
    }

    public Double getTrackY(Integer trackNum) {
        return (Double)this.trackToY_.get(trackNum);
    }

    public double getLowestTraceY() {
        double retval = Double.NEGATIVE_INFINITY;
        Iterator ttyit = this.trackToY_.values().iterator();
        while (ttyit.hasNext()) {
            Double ty = (Double)ttyit.next();
            double tyval = ty;
            if (!(tyval > retval)) continue;
            retval = tyval;
        }
        if (retval == Double.NEGATIVE_INFINITY) {
            retval = this.noTracksMinY_;
        }
        return retval;
    }

    public int getRightmostOutboundLinkOrderMax() {
        if (this.superClusters_.keySet().isEmpty()) {
            return 0;
        }
        Integer rightClustNum = (Integer)this.superClusters_.lastKey();
        LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(rightClustNum);
        return las.ssc.getOutboundLinkOrderMax();
    }

    public Set getAllSources() {
        if (this.isStacked_) {
            throw new IllegalStateException();
        }
        HashSet allSources = new HashSet();
        Iterator scit = this.superClusters_.keySet().iterator();
        while (scit.hasNext()) {
            Integer clustNum = (Integer)scit.next();
            LinkAnnotatedSuper las = (LinkAnnotatedSuper)this.superClusters_.get(clustNum);
            allSources.addAll(las.ssc.getAllSources());
        }
        allSources.addAll(this.preSources_);
        return allSources;
    }

    public static double trackXVal(double baseX, Integer trackNum, GlobalTrackAssignment gta, double traceOffset) {
        return baseX - ((double)gta.currMaxTrack - (double)trackNum.intValue() + 1.0) * traceOffset;
    }

    public static class GlobalTrackAssignment {
        public int currMaxTrack = 0;
        public int currMinTrack = -1;
        public HashMap globalSrcToTrack = new HashMap();
        public TreeMap globalTrackToSrc = new TreeMap();
    }
}

