/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;

public class FanBuilder {
    public Set buildFanIn(Genome genome, String targetID, Map sources, Set okTypes) {
        HashSet<String> candidates = new HashSet<String>();
        HashMap<String, HashSet<String>> targets = new HashMap<String, HashSet<String>>();
        candidates.add(targetID);
        Iterator anit = genome.getAllNodeIterator();
        while (anit.hasNext()) {
            Node node = (Node)anit.next();
            Integer typeObj = new Integer(node.getNodeType());
            if (!okTypes.contains(typeObj)) continue;
            candidates.add(node.getID());
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            HashSet<String> targsForSrc = (HashSet<String>)targets.get(src);
            if (targsForSrc == null) {
                targsForSrc = new HashSet<String>();
                targets.put(src, targsForSrc);
            }
            targsForSrc.add(trg);
            HashSet<String> srcsForTarg = (HashSet<String>)sources.get(trg);
            if (srcsForTarg == null) {
                srcsForTarg = new HashSet<String>();
                sources.put(trg, srcsForTarg);
            }
            srcsForTarg.add(src);
        }
        int lastSize = candidates.size();
        int currSize = 0;
        while (lastSize != currSize) {
            HashSet<String> newCands = new HashSet<String>();
            HashSet testSet = new HashSet();
            Iterator cit = candidates.iterator();
            while (cit.hasNext()) {
                String cand = (String)cit.next();
                if (cand.equals(targetID)) {
                    newCands.add(cand);
                    continue;
                }
                HashSet candTargs = (HashSet)targets.get(cand);
                if (candTargs == null || candTargs.isEmpty()) continue;
                testSet.clear();
                testSet.addAll(candTargs);
                testSet.removeAll(candidates);
                if (!testSet.isEmpty()) continue;
                newCands.add(cand);
            }
            lastSize = candidates.size();
            candidates = newCands;
            currSize = candidates.size();
        }
        ArrayList<String> queue = new ArrayList<String>();
        HashSet emptySet = new HashSet();
        HashSet testSet = new HashSet();
        HashSet testSet2 = new HashSet();
        HashSet<String> survivors = new HashSet<String>();
        queue.add(targetID);
        survivors.add(targetID);
        while (!queue.isEmpty()) {
            String cand = (String)queue.remove(0);
            HashSet candSrcs = (HashSet)sources.get(cand);
            testSet.clear();
            testSet.addAll(candSrcs == null ? emptySet : candSrcs);
            testSet.retainAll(candidates);
            testSet2.clear();
            testSet2.addAll(testSet);
            testSet2.removeAll(survivors);
            queue.addAll(testSet2);
            survivors.addAll(testSet);
        }
        return survivors;
    }
}

