/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.analysis.NodeGrouper;
import org.systemsbiology.biotapestry.cmd.DialogBuiltGeneralMotif;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.Grid;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.RectangularTreeEngine;
import org.systemsbiology.biotapestry.ui.layouts.FanBuilder;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.GridLinkRouter;
import org.systemsbiology.biotapestry.ui.layouts.MetaClusterPointSource;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.SuperSrcRouterPointSource;
import org.systemsbiology.biotapestry.ui.layouts.TrackedGrid;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.TaggedComparableInteger;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class GeneAndSatelliteCluster {
    private static final double LINK_ROOT_X_OFFSET_ = 40.0;
    private static final double STACK_X_OFFSET_ = 80.0;
    private static final double STACK_Y_DELTA_ = 50.0;
    private static final int BUBBLE_PAD_INCR_ = 3;
    private static final int BUBBLE_VERTICAL_INCR_ = 6;
    private static final int FIRST_BUBBLE_OFFSET_ = 12;
    private static final int PEN_TOP_DROP_Y_OFFSET_ = -3;
    private static final int PEN_DROP_OFFSET_ = -3;
    private static final double COMPLEX_FANOUT_WIDTH_HACK_ = 20.0;
    private static final double FAN_GRID_PAD_ = 10.0;
    private static final int NO_FAN_IN_ = 0;
    private static final int SIMPLE_FAN_IN_ = 1;
    private static final int COMPLEX_FAN_IN_ = 2;
    private static final int IS_CORE_ = 0;
    private static final int IS_FAN_IN_ = 1;
    private static final int IS_FAN_OUT_ = 2;
    private HashSet feedbacks_;
    private HashSet outputNodes_;
    private HashSet internalLinks_;
    private HashSet fanInNodes_;
    private HashSet fanOutNodes_;
    private HashSet outboundLinks_;
    private HashSet inboundLinks_;
    private boolean hasDirect_;
    private String coreID_;
    private Map penultimate_;
    private Set inputs_;
    private SortedMap penOrder_;
    private HashMap toCoreFromPen_;
    private TrackedGrid fanOutTrackedGrid_;
    private TrackedGrid fanInTrackedGrid_;
    private int fanInType_;
    private HashMap fanInPadPlans_;
    private Map fanInLinkPlans_;
    private Map inboundLinkPlans_;
    private GridLinkRouter fanInGlr_;
    private HashMap fanOutPadPlans_;
    private Map fanOutLinkPlans_;
    private Map outboundLinkPlans_;
    private Map feedbackLinkPlans_;
    private GridLinkRouter fanOutGlr_;
    private Map fanOutInboundLinkPlans_;
    private HashMap coreJumpers_;
    private HashSet coreJumpersAlsoToCore_;
    private ArrayList srcOrder_;
    private ArrayList fanInTraceOrder_;
    private HashMap padMap_;
    private DropDirectionOracle ddo_;
    private int numFOT_;
    private boolean coreLinkIsFanned_;
    private boolean isStacked_;
    private ClusterDims clusterDims_;
    private double traceOffset_;
    private boolean isTarget_;
    private HashMap multiInCoreEstimates_;
    private boolean textToo_;

    public GeneAndSatelliteCluster(String coreID, boolean isStacked, double traceOffset, boolean isTarget, boolean textToo) {
        this.coreID_ = coreID;
        this.penultimate_ = new HashMap();
        this.toCoreFromPen_ = new HashMap();
        this.inputs_ = new HashSet();
        this.penOrder_ = new TreeMap();
        this.feedbacks_ = new HashSet();
        this.outputNodes_ = new HashSet();
        this.internalLinks_ = new HashSet();
        this.outboundLinks_ = new HashSet();
        this.inboundLinks_ = new HashSet();
        this.fanInNodes_ = new HashSet();
        this.fanOutNodes_ = new HashSet();
        this.fanInType_ = 0;
        this.padMap_ = new HashMap();
        this.isStacked_ = isStacked;
        this.clusterDims_ = null;
        this.traceOffset_ = traceOffset;
        this.isTarget_ = isTarget;
        this.textToo_ = textToo;
    }

    public Rectangle getNodeOnlyBounds(Map placement, Genome genome, Layout lo, FontRenderContext frc) {
        Rectangle2D useRect = TrackedGrid.layoutBounds(genome, lo, frc, this.coreID_, this.textToo_);
        Rectangle retval = UiUtil.rectFromRect2D(useRect);
        Point2D place = (Point2D)placement.get(this.coreID_);
        retval.setLocation((int)place.getX(), (int)place.getY());
        Iterator fiit = this.fanInNodes_.iterator();
        this.collectFanBounds(fiit, placement, genome, lo, frc, retval);
        Iterator foit = this.fanOutNodes_.iterator();
        this.collectFanBounds(foit, placement, genome, lo, frc, retval);
        return retval;
    }

    private void collectFanBounds(Iterator foit, Map placement, Genome genome, Layout lo, FontRenderContext frc, Rectangle retval) {
        while (foit.hasNext()) {
            String key = (String)foit.next();
            Rectangle2D useRect = TrackedGrid.layoutBounds(genome, lo, frc, key, this.textToo_);
            Rectangle tgb = UiUtil.rectFromRect2D(useRect);
            Point2D place = (Point2D)placement.get(key);
            tgb.setLocation((int)place.getX(), (int)place.getY());
            Bounds.tweakBounds(retval, tgb);
        }
    }

    public Set allNodesInCluster() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.coreID_);
        retval.addAll(this.fanInNodes_);
        retval.addAll(this.fanOutNodes_);
        return retval;
    }

    public boolean isInCluster(String nodeID) {
        if (this.coreID_.equals(nodeID)) {
            return true;
        }
        if (this.fanInNodes_.contains(nodeID)) {
            return true;
        }
        return this.fanOutNodes_.contains(nodeID);
    }

    public String getCoreID() {
        return this.coreID_;
    }

    public boolean useLeftDropsForStackedCore() {
        return this.fanInType_ == 1;
    }

    private boolean needsHorizontalTracesToFanInOrCore(Genome genome) {
        if (this.isTarget_) {
            return this.fanInType_ == 2;
        }
        if (this.isStacked_) {
            return this.fanInType_ == 2;
        }
        return this.fanInType_ != 1 || this.coreJumpers_ != null && !this.coreJumpers_.isEmpty() || this.fanInType_ == 1 && this.hasInboundLinksToFanOut(genome);
    }

    private boolean needsHorizontalTracesToFanOut(Genome genome) {
        if (this.isTarget_) {
            return false;
        }
        if (this.isStacked_) {
            return false;
        }
        return this.fanInType_ != 1 || this.coreJumpers_ != null && !this.coreJumpers_.isEmpty() || this.fanInType_ == 1 && this.hasInboundLinksToFanOut(genome);
    }

    public boolean hasInboundLinksToFanOut(Genome genome) {
        if (this.fanOutNodes_ == null || this.fanOutNodes_.isEmpty()) {
            return false;
        }
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            if (!this.linkToFanOut(linkID, genome)) continue;
            return true;
        }
        return false;
    }

    public Set getInboundLinks() {
        return this.inboundLinks_;
    }

    public void orderByTraceOrder(List orderedSources, Genome genome) {
        int numSrc = orderedSources.size();
        for (int i = 0; i < numSrc; ++i) {
            String srcID = (String)orderedSources.get(i);
            Set pens = this.pensAsTargets(srcID);
            Iterator pit = pens.iterator();
            while (pit.hasNext()) {
                String pen = (String)pit.next();
                this.orderPenultimate(pen, genome);
            }
        }
    }

    public void locateAsTarget(Point2D basePos, Map positions, Genome genome, Layout lo, FontRenderContext frc, Double maxHeight) {
        Point2D srcPt;
        ClusterDims oh = this.getClusterDims(genome, lo, frc);
        double useHorzTrace = oh.horizTraceAddition;
        double nextHeight = oh.height + useHorzTrace;
        double extraBump = 0.0;
        if (maxHeight != null && maxHeight > nextHeight) {
            extraBump = maxHeight - nextHeight;
        }
        Rectangle2D useRect = TrackedGrid.layoutBounds(genome, lo, frc, this.coreID_, this.textToo_);
        double extra = -useRect.getX();
        if (this.fanInType_ != 2) {
            Vector2D extraOffset = new Vector2D(extra, useHorzTrace + oh.offsetToGascPlacement + extraBump);
            if (this.fanInType_ == 1) {
                this.orderFanInOrphans(genome);
                srcPt = extraOffset.add(basePos);
                this.locateSimpleFanIns(srcPt, positions, genome, lo, frc);
            } else {
                srcPt = extraOffset.add(basePos);
            }
        } else {
            Point2D.Double fanPos = new Point2D.Double(basePos.getX(), basePos.getY() + useHorzTrace + oh.offsetToFanInTop + extraBump);
            this.placeFan(this.fanInTrackedGrid_, fanPos, positions, lo);
            Vector2D extraOffset = new Vector2D(extra + this.fanInTrackedGrid_.getWidth(), useHorzTrace + oh.offsetToGascPlacement + extraBump);
            srcPt = extraOffset.add(basePos);
        }
        UiUtil.forceToGrid(srcPt, 10.0);
        positions.put(this.coreID_, srcPt);
    }

    public double spaceForPenNodes(Genome genome) {
        int penNum = this.penOrder_.size();
        if (penNum == 0) {
            return 0.0;
        }
        Set toCore = this.linksToCore(genome);
        int dirCount = toCore.size();
        int firstBub = (dirCount += 2) > 12 ? dirCount : 12;
        double bubY = UiUtil.forceToGridValue((double)firstBub * 10.0 + (double)(penNum - 1) * 60.0, 10.0);
        return bubY;
    }

    private Point2D simpleFanPosCalc(int orderNum, String penID, Point2D basePos, Genome genome, Layout lo, FontRenderContext frc) {
        int padNum = this.penIDToPadnum(genome, penID);
        Vector2D offset = this.landingPadToOffset(padNum, genome, lo, frc, this.coreID_);
        Point2D padPoint = offset.add(basePos);
        Set toCore = this.linksToCore(genome);
        int dirCount = toCore.size();
        int firstBub = (dirCount += 2) > 12 ? dirCount : 12;
        double bubY = UiUtil.forceToGridValue(padPoint.getY() - (double)firstBub * 10.0 - (double)orderNum * 60.0, 10.0);
        padPoint.setLocation(padPoint.getX(), bubY);
        return padPoint;
    }

    public void colorTheCluster(Genome genome, Map nodeColors, Map linkColors) {
        Set penKeys = this.penultimate_.keySet();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String lsource = link.getSource();
            if (!penKeys.contains(lsource)) continue;
            nodeColors.put(lsource, "white");
            linkColors.put(link.getID(), "black");
        }
        nodeColors.put(this.coreID_, "black");
    }

    public void calcPadChanges(GenomeSubset subset, List traceOrder, Map padChanges, Map nodeLengthChanges, Map extraGrowthChanges) {
        Gene gene;
        int currPads;
        Gene gene2;
        Genome baseGenome = subset.getBaseGenome();
        Node node = baseGenome.getNode(this.coreID_);
        boolean isGeneCore = node.getNodeType() == 4;
        boolean doCorePads = true;
        if (isGeneCore && (gene2 = baseGenome.getGene(this.coreID_)).getNumRegions() != 0) {
            doCorePads = false;
        }
        int currPad = 0;
        if (this.fanInType_ == 2) {
            this.mergePrecalcPads(this.fanInNodes_, this.fanInPadPlans_, baseGenome, padChanges);
        }
        if (isGeneCore) {
            if (doCorePads) {
                currPad = this.calcPadChangesForCore(subset, traceOrder, padChanges);
            } else if (!this.fanInNodes_.isEmpty() && this.fanInType_ == 2) {
                currPad = this.changeFanToCorePads(this.fanInNodes_, baseGenome, padChanges, currPad, this.fanInPadPlans_, true);
            }
        } else {
            this.calcPadChangesForNonGeneCore(subset, this.fanInTrackedGrid_, traceOrder, padChanges);
        }
        if (this.fanInType_ == 1 && !doCorePads) {
            currPad = this.simpleFanInPadChangesForFan(subset, traceOrder, padChanges, null, currPad);
        }
        if (!this.fanOutNodes_.isEmpty()) {
            this.mergePrecalcPads(this.fanOutNodes_, this.fanOutPadPlans_, baseGenome, padChanges);
        }
        this.changeOutboundPads(baseGenome, padChanges, isGeneCore);
        if (isGeneCore && doCorePads && currPad < 0 && 7 - (currPads = (gene = baseGenome.getGene(this.coreID_)).getPadCount()) > currPad) {
            nodeLengthChanges.put(this.coreID_, new Integer(7 - currPad));
        }
        Iterator pmkit = this.padMap_.keySet().iterator();
        while (pmkit.hasNext()) {
            int nodeType;
            int padInc;
            String key = (String)pmkit.next();
            Node fNode = baseGenome.getNode(key);
            Set usedPads = (Set)this.padMap_.get(key);
            int minUsed = Integer.MAX_VALUE;
            Iterator upit = usedPads.iterator();
            while (upit.hasNext()) {
                Integer usedPad = (Integer)upit.next();
                int upVal = usedPad;
                if (upVal >= minUsed) continue;
                minUsed = upVal;
            }
            if (minUsed >= 0 || (padInc = DBNode.getPadIncrement(nodeType = fNode.getNodeType())) == 0) continue;
            minUsed = -((int)UiUtil.forceToGridValueMax(-minUsed, padInc));
            int currPads2 = fNode.getPadCount();
            int defPad = DBNode.getDefaultPadCount(nodeType);
            int needed = defPad - minUsed;
            if (needed <= currPads2) continue;
            nodeLengthChanges.put(key, new Integer(needed));
        }
        Iterator fiit = this.fanInNodes_.iterator();
        while (fiit.hasNext()) {
            String key = (String)fiit.next();
            this.needExtraGrowthChange(key, baseGenome, nodeLengthChanges, extraGrowthChanges, true);
        }
        Iterator foit = this.fanOutNodes_.iterator();
        while (foit.hasNext()) {
            String key = (String)foit.next();
            this.needExtraGrowthChange(key, baseGenome, nodeLengthChanges, extraGrowthChanges, false);
        }
        this.needExtraGrowthChange(this.coreID_, baseGenome, nodeLengthChanges, extraGrowthChanges, false);
    }

    public void needExtraGrowthChange(String key, Genome genome, Map nodeLengthChanges, Map extraGrowthChanges, boolean isFanIn) {
        int defaultPads;
        Node fNode = genome.getNode(key);
        int nodeType = fNode.getNodeType();
        int currPads = fNode.getPadCount();
        Integer newPads = (Integer)nodeLengthChanges.get(key);
        int needPads = newPads == null ? currPads : newPads;
        if (needPads <= (defaultPads = DBNode.getDefaultPadCount(nodeType)) || !NodeProperties.usesGrowth(nodeType)) {
            return;
        }
        int growthType = 1;
        if (this.fanInType_ == 1 && isFanIn) {
            growthType = 2;
        }
        extraGrowthChanges.put(key, new Integer(growthType));
    }

    public void finalLinkRouting(String srcID, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, MetaClusterPointSource mcps, SpecialtyLayoutLinkData specIn, LinkPlacementState lps) {
        List linksPerClust = this.linkIDsPerClusterOldStyle(srcID, genome);
        List dropPts = null;
        TreeMap<Double, ArrayList<String>> sortByX = new TreeMap<Double, ArrayList<String>>();
        HashMap<String, List> holdDrops = new HashMap<String, List>();
        Set linksToCore = this.linksToCore(genome);
        int numlpc = linksPerClust.size();
        for (int j = 0; j < numlpc; ++j) {
            String linkID = (String)linksPerClust.get(j);
            dropPts = linksToCore.contains(linkID) ? this.directLinkDropPoints(linkID, genome, padChanges, mcps, lo, frc, placement) : this.doLinkToDropPoints(linkID, genome, padChanges, mcps, lo, frc, placement);
            double firstX = ((Point2D)dropPts.get(0)).getX();
            Double firstXKey = new Double(firstX);
            ArrayList<String> linksPerX = (ArrayList<String>)sortByX.get(firstXKey);
            if (linksPerX == null) {
                linksPerX = new ArrayList<String>();
                sortByX.put(firstXKey, linksPerX);
            }
            linksPerX.add(linkID);
            holdDrops.put(linkID, dropPts);
        }
        boolean firstDrop = true;
        Iterator sbxit = sortByX.keySet().iterator();
        while (sbxit.hasNext()) {
            Double xVal = (Double)sbxit.next();
            List linksPerX = (List)sortByX.get(xVal);
            int numLinks = linksPerX.size();
            for (int i = 0; i < numLinks; ++i) {
                String linkID = (String)linksPerX.get(i);
                specIn.startNewLink(linkID);
                dropPts = (List)holdDrops.get(linkID);
                if (!firstDrop) {
                    specIn.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(lps.lastAttach));
                    specIn.addPositionListToLink(linkID, SpecialtyLayoutLinkData.TrackPos.convertPointList(dropPts));
                    lps.lastAttach = (Point2D)dropPts.get(0);
                    continue;
                }
                firstDrop = false;
                if (lps.isRoot) {
                    lps.isRoot = false;
                    specIn.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(lps.runPt));
                    lps.lastRun = lps.runPt;
                } else if (lps.isRunStart) {
                    lps.isRunStart = false;
                    specIn.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(lps.lastRun));
                    specIn.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(lps.runPt));
                    lps.lastRun = lps.runPt;
                } else {
                    specIn.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(lps.lastAttach));
                }
                specIn.addPositionListToLink(linkID, SpecialtyLayoutLinkData.TrackPos.convertPointList(dropPts));
                lps.lastAttach = (Point2D)dropPts.get(0);
            }
        }
        List lastLinkList = (List)sortByX.get(sortByX.lastKey());
        String lastLink = (String)lastLinkList.get(lastLinkList.size() - 1);
        dropPts = (List)holdDrops.get(lastLink);
        lps.lastAttach = (Point2D)dropPts.get(0);
    }

    public Map internalLinkRoutingForTarget(Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges) {
        if (this.fanInType_ == 2) {
            Point2D upperLeftFanInPt = this.getClusterDims(genome, lo, frc).getFanInCorner(placement);
            return this.fanInGlr_.convertInternalLinks(this.fanInLinkPlans_, upperLeftFanInPt, placement, padChanges, genome, lo, frc, this.coreID_);
        }
        return new HashMap();
    }

    public void inboundLinkRouting(String srcID, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, SpecialtyLayoutLinkData sin, MetaClusterPointSource lps, boolean topGASC) {
        boolean linkFromTop;
        List linksPerClust = this.linkIDsPerCluster(srcID, genome);
        if (linksPerClust == null || linksPerClust.isEmpty()) {
            return;
        }
        boolean bl = linkFromTop = this.ddo_ == null ? true : this.ddo_.comingFromTop(srcID, this);
        if (this.fanInType_ != 2) {
            if (lps.needsTraceYUpdate()) {
                Map inbound = this.getInboundSourceOrder(genome, padChanges);
                double cdropY = this.inboundTraceY(srcID, false, inbound, placement, genome, lo, frc);
                lps.setTargetTraceY(cdropY);
            }
            this.simpleFanInInboundLinkRouting(linksPerClust, srcID, genome, lo, frc, placement, padChanges, sin, lps, linkFromTop, topGASC);
        } else {
            boolean fanOutDone = false;
            if (linkFromTop) {
                this.fanOutInboundLinkRouting(srcID, genome, lo, frc, placement, padChanges, sin, lps, topGASC);
                fanOutDone = true;
            }
            this.complexFanInInboundLinkRouting(srcID, genome, lo, frc, placement, padChanges, sin, lps, true);
            if (!fanOutDone) {
                this.fanOutInboundLinkRouting(srcID, genome, lo, frc, placement, padChanges, sin, lps, topGASC);
            }
        }
    }

    public void calcOrientChanges(Genome genome, Layout lo, Map orientChanges) {
        HashSet<String> allNodes = new HashSet<String>();
        allNodes.add(this.coreID_);
        allNodes.addAll(this.fanInNodes_);
        allNodes.addAll(this.fanOutNodes_);
        Iterator finit = allNodes.iterator();
        while (finit.hasNext()) {
            String nodeID = (String)finit.next();
            NodeProperties np = lo.getNodeProperties(nodeID);
            Node node = genome.getNode(nodeID);
            int orient = np.getOrientation();
            if (NodeProperties.getOrientTypeCount(node.getNodeType()) == 0) continue;
            if (this.fanInType_ == 1 && this.fanInNodes_.contains(nodeID)) {
                if (orient == 4) continue;
                orientChanges.put(nodeID, new Integer(4));
                continue;
            }
            if (orient == 2) continue;
            orientChanges.put(nodeID, new Integer(2));
        }
    }

    public Iterator getAllSourceIterator() {
        return this.outputNodes_.iterator();
    }

    public Set srcsToCore(Genome genome) {
        return this.srcsForLinks(genome, this.linksToCore(genome));
    }

    public Set linksToCore(Genome genome) {
        HashSet<String> linksToCore = new HashSet<String>();
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String targetID = link.getTarget();
            if (!targetID.equals(this.coreID_)) continue;
            linksToCore.add(linkID);
        }
        return linksToCore;
    }

    public Set multiSrcsToCore(Genome genome) {
        HashMap<String, Integer> srcToCount = new HashMap<String, Integer>();
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String targetID = link.getTarget();
            if (!targetID.equals(this.coreID_)) continue;
            String srcID = link.getSource();
            Integer count = (Integer)srcToCount.get(srcID);
            count = count == null ? new Integer(1) : new Integer(count + 1);
            srcToCount.put(srcID, count);
        }
        HashSet<String> retval = new HashSet<String>();
        Iterator s2ckit = srcToCount.keySet().iterator();
        while (s2ckit.hasNext()) {
            String srcID = (String)s2ckit.next();
            Integer count = (Integer)srcToCount.get(srcID);
            if (count <= 1) continue;
            retval.add(srcID);
        }
        return retval;
    }

    public Set srcsToFanin(Genome genome) {
        return this.srcsForLinks(genome, this.linksToFanin(genome));
    }

    private Set srcsForLinks(Genome genome, Set links) {
        HashSet<String> retval = new HashSet<String>();
        Iterator ilit = links.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String linkSrcID = link.getSource();
            retval.add(linkSrcID);
        }
        return retval;
    }

    public Set linksToFanin(Genome genome) {
        HashSet<String> srcsToFanin = new HashSet<String>();
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String targetID = link.getTarget();
            if (!this.fanInNodes_.contains(targetID)) continue;
            srcsToFanin.add(linkID);
        }
        return srcsToFanin;
    }

    private Set srcsToFanout(Genome genome) {
        HashSet<String> srcsToFanout = new HashSet<String>();
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String targetID = link.getTarget();
            String linkSrcID = link.getSource();
            if (!this.fanOutNodes_.contains(targetID)) continue;
            srcsToFanout.add(linkSrcID);
        }
        return srcsToFanout;
    }

    public ClusterDims getClusterDims(Genome genome, Layout lo, FontRenderContext frc) {
        double traceTopOut;
        double traceTopIn;
        double traceTop;
        double topToPlacement;
        if (this.clusterDims_ != null) {
            return this.clusterDims_;
        }
        Node node = genome.getNode(this.coreID_);
        NodeProperties np = lo.getNodeProperties(this.coreID_);
        INodeRenderer rend = np.getRenderer();
        double coreHeight = rend.getGlyphHeightForLayout(genome, node, lo, frc);
        if (node.getNodeType() == 4) {
            if (((Gene)node).getNumRegions() != 0 && node.getName().length() > 3) {
                coreHeight += 40.0;
            }
            topToPlacement = 0.0;
        } else {
            topToPlacement = coreHeight / 2.0;
            topToPlacement = UiUtil.forceToGridValueMax(topToPlacement, 10.0);
        }
        double inTraces = 0.0;
        if (this.needsHorizontalTracesToFanInOrCore(genome)) {
            if (this.fanInType_ == 2) {
                Set l2fi = this.linksToFanin(genome);
                Set l2c = this.linksToCore(genome);
                HashSet all = new HashSet(l2fi);
                all.addAll(l2c);
                Set canChopLinks = this.srcsForLinks(genome, this.canChop(genome, new ArrayList(all), null));
                int gottaHopIn = this.fanInGlr_.getTopReservations();
                inTraces = 10.0 * (double)(gottaHopIn -= canChopLinks.size());
            } else {
                int gottaHopIn = this.srcsToCore(genome).size();
                inTraces = this.traceOffset_ * (double)gottaHopIn;
            }
            inTraces += this.traceOffset_;
        }
        double outTraces = 0.0;
        if (!this.fanOutNodes_.isEmpty()) {
            int gottaHopOut = this.fanOutGlr_.getTopReservations();
            outTraces = 10.0 * (double)gottaHopOut;
            if (this.needsHorizontalTracesToFanOut(genome)) {
                int gottaHopOver = this.srcsToFanout(genome).size();
                outTraces += this.traceOffset_ * (double)gottaHopOver;
                outTraces += inTraces;
                inTraces += this.traceOffset_ * (double)gottaHopOver;
            }
        }
        int launchPad = TrackedGrid.launchForGrid(this.coreID_, genome);
        Vector2D gridLaunchPadOffset = TrackedGrid.launchPadToOffset(launchPad, genome, lo, frc, this.coreID_);
        boolean needFeedMin = false;
        Iterator ilit = this.internalLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            String trg = link.getTarget();
            if (!src.equals(this.coreID_) || !src.equals(trg)) continue;
            needFeedMin = true;
            break;
        }
        double fanIn = 0.0;
        double multiLink = 0.0;
        if (this.fanInType_ == 1) {
            this.orderFanInOrphans(genome);
            fanIn = this.spaceForPenNodes(genome);
        } else if (!this.fanInNodes_.isEmpty()) {
            fanIn = this.fanInTrackedGrid_.getHeight();
        } else {
            Set ms2c;
            int multiSrcs;
            if (node.getNodeType() != 4) {
                fanIn = 20.0;
            }
            if (this.isStacked_ && this.fanOutNodes_.isEmpty() && (multiSrcs = (ms2c = this.multiSrcsToCore(genome)).size()) != 0) {
                multiLink = (double)multiSrcs * 10.0;
            }
        }
        double fanOut = 0.0;
        double vOffset = 0.0;
        if (!this.fanOutNodes_.isEmpty()) {
            fanOut = this.fanOutTrackedGrid_.getHeight();
            vOffset = this.fanOutTrackedGrid_.getExactVerticalOffset(genome, lo, frc, this.coreID_);
        }
        double fanInTop = 0.0;
        double bottomOfFanIn = fanInTop + fanIn;
        double corePlacement = bottomOfFanIn + topToPlacement;
        double bottomOfCore = corePlacement - topToPlacement + coreHeight;
        double coreLaunch = corePlacement + gridLaunchPadOffset.getY();
        double fanOutTop = coreLaunch - vOffset;
        double fanOutBottom = fanOutTop + fanOut;
        double feedTop = needFeedMin ? coreLaunch - 50.0 : coreLaunch;
        feedTop -= multiLink;
        double downshift = 0.0;
        if (fanOutTop < fanInTop) {
            downshift = fanInTop - fanOutTop;
        }
        if (feedTop < fanInTop && feedTop < fanOutTop) {
            downshift = fanInTop - feedTop;
        }
        if (downshift > 0.0) {
            feedTop += downshift;
            fanInTop += downshift;
            bottomOfFanIn += downshift;
            corePlacement += downshift;
            bottomOfCore += downshift;
            coreLaunch += downshift;
            fanOutTop += downshift;
            fanOutBottom += downshift;
        }
        double d = traceTop = (traceTopIn = fanInTop - inTraces) < (traceTopOut = fanOutTop - outTraces) ? traceTopIn : traceTopOut;
        if (feedTop < traceTop) {
            traceTop = feedTop;
        }
        double tracesY = -traceTop;
        double result = bottomOfCore > fanOutBottom ? bottomOfCore : fanOutBottom;
        result = UiUtil.forceToGridValueMax(result, 10.0);
        Vector2D upperLeftFanInOffset = this.fanInTrackedGrid_ == null ? null : new Vector2D(-this.fanInTrackedGrid_.getWidth(), -this.fanInTrackedGrid_.getHeight());
        int numRow = this.fanOutTrackedGrid_ == null ? 0 : this.fanOutTrackedGrid_.getNumRows();
        double multiRowShift = 10.0 * ((double)this.numFOT_ + (this.coreLinkIsFanned_ ? 1.0 : 0.0));
        Vector2D targOffset = new Vector2D(80.0, -vOffset);
        Vector2D fullOffset = targOffset.add(gridLaunchPadOffset);
        Vector2D linkShiftOffset = new Vector2D(numRow > 1 ? multiRowShift : 0.0, 0.0);
        Rectangle2D useRect = TrackedGrid.layoutBounds(genome, lo, frc, this.coreID_, this.textToo_);
        double width = UiUtil.forceToGridValueMax(useRect.getWidth(), 10.0);
        if (!this.fanOutNodes_.isEmpty()) {
            width += this.fanOutTrackedGrid_.getWidth() + 20.0;
        }
        if (!this.fanInNodes_.isEmpty() && this.fanInType_ == 2) {
            width += this.fanInTrackedGrid_.getWidth() + 10.0;
        }
        width += linkShiftOffset.getX();
        width = UiUtil.forceToGridValueMax(width, 10.0);
        this.clusterDims_ = new ClusterDims(result, fanInTop, fanOutTop, corePlacement, tracesY, gridLaunchPadOffset, upperLeftFanInOffset, fullOffset, linkShiftOffset, vOffset, width);
        return this.clusterDims_;
    }

    public int getInboundLinkCount(Genome genome) {
        int retval = 0;
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!this.linkIsInbound(link)) continue;
            ++retval;
        }
        return retval;
    }

    public List getLinkOrder(Genome genome, Map padChanges, String srcID) {
        ArrayList<String> retval = new ArrayList<String>();
        List linkOrder = this.getInboundLinkOrder(genome, padChanges);
        int numl = linkOrder.size();
        for (int i = 0; i < numl; ++i) {
            String linkID = (String)linkOrder.get(i);
            Linkage link = genome.getLinkage(linkID);
            String currSrcID = link.getSource();
            if (srcID != null && !srcID.equals(currSrcID)) continue;
            retval.add(linkID);
        }
        return retval;
    }

    public Set getInputs() {
        return this.inputs_;
    }

    public boolean inputSetMatches(Set inputs) {
        return ((Object)this.inputs_).equals(inputs);
    }

    public boolean isATarget(String srcID) {
        return this.inputs_.contains(srcID);
    }

    public boolean linkIsInbound(Linkage link) {
        return this.inboundLinks_.contains(link.getID());
    }

    public boolean linkIsOutbound(Linkage link) {
        return this.outboundLinks_.contains(link.getID());
    }

    public boolean linkIsInternal(Linkage link) {
        return this.internalLinks_.contains(link.getID());
    }

    public List getOutboundSourceOrder() {
        if (this.srcOrder_.isEmpty()) {
            ArrayList<String> retval = new ArrayList<String>();
            retval.add(this.coreID_);
            return retval;
        }
        ArrayList<String> retval = new ArrayList<String>();
        int numSo = this.srcOrder_.size();
        for (int i = 0; i < numSo; ++i) {
            retval.add(((GridLinkRouter.RCRowCompare)this.srcOrder_.get(i)).getSrc());
        }
        return retval;
    }

    public List getAllSources() {
        return new ArrayList(this.outputNodes_);
    }

    public int getOutboundLinkOrderMax() {
        if (this.srcOrder_.isEmpty()) {
            return this.hasDirect_ ? 1 : 0;
        }
        return this.srcOrder_.size();
    }

    public int getOutboundLinkOrder(Linkage link) {
        if (this.srcOrder_.isEmpty()) {
            return 0;
        }
        String lsource = link.getSource();
        List ordered = this.getOutboundSourceOrder();
        int numo = ordered.size();
        for (int i = 0; i < numo; ++i) {
            String srcID = (String)ordered.get(i);
            if (!srcID.equals(lsource)) continue;
            return i;
        }
        System.err.println("no outbound order " + lsource + " " + ordered);
        throw new IllegalArgumentException();
    }

    public void prepFromGroupsPhaseOne(Genome genome, Map groups) {
        HashSet<String> potentialFanIns = new HashSet<String>();
        HashSet<String> potentialFanOuts = new HashSet<String>();
        Iterator gkit = groups.keySet().iterator();
        block4: while (gkit.hasNext()) {
            String nodeID = (String)gkit.next();
            if (nodeID.equals(this.coreID_)) continue;
            NodeGrouper.GroupElement nodeInfo = (NodeGrouper.GroupElement)groups.get(nodeID);
            if (!nodeInfo.group.equals(this.coreID_)) continue;
            switch (nodeInfo.side) {
                case 0: {
                    potentialFanIns.add(nodeID);
                    continue block4;
                }
                case 1: {
                    potentialFanOuts.add(nodeID);
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
        Set fodes = this.fanOutDeadEnds(potentialFanOuts, groups);
        potentialFanIns.addAll(fodes);
        potentialFanOuts.removeAll(fodes);
        Set foet = this.fanOutExclusiveTargets(potentialFanIns, potentialFanOuts, groups);
        potentialFanIns.removeAll(foet);
        potentialFanOuts.addAll(foet);
        Iterator fiit = potentialFanIns.iterator();
        while (fiit.hasNext()) {
            String nodeID = (String)fiit.next();
            NodeGrouper.GroupElement nodeInfo = (NodeGrouper.GroupElement)groups.get(nodeID);
            genome.getNodeSources(nodeInfo.nodeID);
            this.addPenultimate(nodeInfo.nodeID, genome.getNodeSources(nodeInfo.nodeID));
        }
        Iterator foit = potentialFanOuts.iterator();
        while (foit.hasNext()) {
            String nodeID = (String)foit.next();
            this.fanOutNodes_.add(nodeID);
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            String lsource = link.getSource();
            String ltarg = link.getTarget();
            if (this.makeLinkInbound(link)) {
                this.inboundLinks_.add(linkID);
                this.inputs_.add(lsource);
            } else if (this.makeLinkOutbound(link)) {
                this.outboundLinks_.add(linkID);
                if (lsource.equals(this.coreID_)) {
                    this.hasDirect_ = true;
                }
                this.outputNodes_.add(lsource);
                if (this.isLargeScaleFeedback(link)) {
                    this.inboundLinks_.add(linkID);
                    this.inputs_.add(lsource);
                }
            } else if (this.makeLinkInternal(link)) {
                this.internalLinks_.add(linkID);
            }
            if (!lsource.equals(this.coreID_) || !ltarg.equals(this.coreID_)) continue;
            this.feedbacks_.add(linkID);
        }
        this.multiInCoreEstimates_ = new HashMap();
        this.multiInputCorePadOrdering(genome, this.multiInCoreEstimates_);
    }

    public void prepFromRemaindersPhaseOne(GenomeSubset subset, String node) {
        Genome baseGenome = subset.getBaseGenome();
        Iterator lit = subset.getLinkageSuperSetIterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String lsource = link.getSource();
            String ltarg = link.getTarget();
            if (this.makeLinkInbound(link)) {
                this.inboundLinks_.add(linkID);
                this.inputs_.add(lsource);
            } else if (this.makeLinkOutbound(link)) {
                this.outboundLinks_.add(linkID);
                if (lsource.equals(this.coreID_)) {
                    this.hasDirect_ = true;
                }
                this.outputNodes_.add(lsource);
                if (this.isLargeScaleFeedback(link)) {
                    this.inboundLinks_.add(linkID);
                    this.inputs_.add(lsource);
                }
            } else if (this.makeLinkInternal(link)) {
                this.internalLinks_.add(linkID);
            }
            if (!lsource.equals(this.coreID_) || !ltarg.equals(this.coreID_)) continue;
            this.feedbacks_.add(linkID);
        }
        this.multiInCoreEstimates_ = new HashMap();
        this.multiInputCorePadOrdering(baseGenome, this.multiInCoreEstimates_);
    }

    public DropDirectionOracle getDDOracle() {
        return this.ddo_;
    }

    public void prepPhaseTwo(Genome genome, Layout lo, FontRenderContext frc, DropDirectionOracle ddo) {
        this.fanOutTrackedGrid_ = new TrackedGrid(this.gridFanOuts(genome), genome, lo, frc, this.coreID_, this.textToo_);
        this.fanInTrackedGrid_ = new TrackedGrid(this.gridFanIns(genome), genome, lo, frc, this.coreID_, this.textToo_);
        this.ddo_ = ddo;
        this.normalizeSources();
        this.fanInType_ = this.classifyFanIn(genome);
        this.fanInPadPlans_ = new HashMap();
        this.changeInternalFanPads(this.fanInTrackedGrid_, this.fanInNodes_, genome, this.fanInPadPlans_);
        if (!this.fanOutNodes_.isEmpty()) {
            this.fanOutPadPlans_ = new HashMap();
            this.changeInternalFanPads(this.fanOutTrackedGrid_, this.fanOutNodes_, genome, this.fanOutPadPlans_);
        }
        GenomeItemInstance.DBAndInstanceConsistentComparator cc = new GenomeItemInstance.DBAndInstanceConsistentComparator();
        TreeMap internalsWithFanInSrcs = new TreeMap(cc);
        TreeMap internalsWithFanOutSrcs = new TreeMap(cc);
        this.classifyInternalLinks(genome, internalsWithFanInSrcs, internalsWithFanOutSrcs);
        TreeMap inboundsWithFanInTargs = new TreeMap(cc);
        TreeMap inboundsWithFanOutTargs = new TreeMap(cc);
        this.classifyInboundLinks(genome, inboundsWithFanInTargs, inboundsWithFanOutTargs);
        this.numFOT_ = inboundsWithFanOutTargs.size();
        HashMap fanInPointSources = new HashMap();
        this.fanInTraceOrder_ = new ArrayList();
        if (this.fanInType_ == 2) {
            this.fanInGlr_ = new GridLinkRouter(this.fanInTrackedGrid_, this);
            this.fanInLinkPlans_ = new HashMap();
            this.fanInGlr_.layoutInternalLinks(internalsWithFanInSrcs, genome, this.fanInPadPlans_, lo, frc, fanInPointSources, this.fanInTraceOrder_, null, 0, this.fanInLinkPlans_);
            this.changeInboundPadsForFan(this.fanInNodes_, this.fanInTrackedGrid_, genome, this.fanInPadPlans_, null, ddo != null);
            this.inboundLinkPlans_ = this.fanInGlr_.layoutInboundLinks(inboundsWithFanInTargs, genome, this.fanInPadPlans_, lo, frc, fanInPointSources, null, null, null, null, true);
            Collections.sort(this.fanInTraceOrder_);
        }
        this.coreJumpers_ = new HashMap();
        this.coreJumpersAlsoToCore_ = new HashSet();
        this.srcOrder_ = new ArrayList();
        ArrayList<String> jumperLinks = new ArrayList<String>();
        if (!this.fanOutNodes_.isEmpty()) {
            Iterator ifiskit = internalsWithFanInSrcs.keySet().iterator();
            while (ifiskit.hasNext()) {
                String srcID = (String)ifiskit.next();
                ArrayList perSrc = (ArrayList)internalsWithFanInSrcs.get(srcID);
                int numPS = perSrc.size();
                for (int i = 0; i < numPS; ++i) {
                    GridLinkRouter.ClassifiedLink cLink = (GridLinkRouter.ClassifiedLink)perSrc.get(i);
                    if (cLink.type == 5) {
                        ArrayList<Object> coreJumpPerSrc = (ArrayList<Object>)this.coreJumpers_.get(srcID);
                        if (coreJumpPerSrc == null) {
                            coreJumpPerSrc = new ArrayList<Object>();
                            this.coreJumpers_.put(srcID, coreJumpPerSrc);
                        }
                        coreJumpPerSrc.add(cLink.clone());
                        jumperLinks.add(cLink.linkID);
                    }
                    if (cLink.type != 4) continue;
                    this.coreJumpersAlsoToCore_.add(srcID);
                }
            }
            Set cjSet = this.coreJumpers_.keySet();
            this.coreJumpersAlsoToCore_.retainAll(cjSet);
            inboundsWithFanOutTargs.putAll(this.coreJumpers_);
            int numCJ = cjSet.size();
            HashMap pointSources = new HashMap();
            this.fanOutGlr_ = new GridLinkRouter(this.fanOutTrackedGrid_, this);
            this.fanOutLinkPlans_ = new HashMap();
            this.coreLinkIsFanned_ = this.fanOutGlr_.layoutInternalLinks(internalsWithFanOutSrcs, genome, this.fanOutPadPlans_, lo, frc, pointSources, new ArrayList(), this.coreID_, numCJ, this.fanOutLinkPlans_);
            this.changeInboundPadsForFan(this.fanOutNodes_, this.fanOutTrackedGrid_, genome, this.fanOutPadPlans_, null, true);
            this.changePadsForFanForJumperLinks(jumperLinks, this.fanOutNodes_, this.fanOutTrackedGrid_, genome, this.fanOutPadPlans_, null, true);
            this.fanOutInboundLinkPlans_ = this.fanOutGlr_.layoutInboundLinks(inboundsWithFanOutTargs, genome, this.fanOutPadPlans_, lo, frc, pointSources, this.fanInGlr_, fanInPointSources, cjSet, this.coreJumpersAlsoToCore_, false);
            this.outboundLinkPlans_ = this.fanOutGlr_.layoutOutboundLinks(this.outboundLinks_, this.coreID_, genome, this.fanOutPadPlans_, lo, frc, pointSources, this.srcOrder_);
            this.feedbackLinkPlans_ = this.fanOutGlr_.feedbackRoutingForFanout(this.feedbacks_, genome, this.fanOutPadPlans_, lo, frc, pointSources, this.coreID_);
            Collections.sort(this.srcOrder_);
        } else {
            this.outboundLinkPlans_ = new HashMap();
        }
    }

    public void locateAsSource(Point2D basePos, Map positions, Genome genome, Layout lo, FontRenderContext frc) {
        this.locateAsTarget(basePos, positions, genome, lo, frc, null);
        Point2D upperLeft = this.getClusterDims(genome, lo, frc).getFanOutCorner(positions, true);
        if (upperLeft != null) {
            this.placeFan(this.fanOutTrackedGrid_, upperLeft, positions, lo);
        }
    }

    public Point2D linkTreeRoot(Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges) {
        int launch = 0;
        Iterator olit = this.outboundLinks_.iterator();
        while (olit.hasNext()) {
            String linkID = (String)olit.next();
            Linkage link = genome.getLinkage(linkID);
            if (!link.getSource().equals(this.coreID_)) continue;
            launch = this.getCurrentLaunchPad(link, padChanges);
            break;
        }
        Vector2D offset = this.launchPadToOffset(launch, genome, lo, frc, this.coreID_);
        Point2D basePos = (Point2D)placement.get(this.coreID_);
        Point2D launchPt = offset.add(basePos);
        UiUtil.forceToGrid(launchPt, 10.0);
        Vector2D rootOff = new Vector2D(40.0, 0.0);
        return rootOff.add(launchPt);
    }

    public void routeOutboundLinks(Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map placement, Map internalTraces, Map outboundTraces, Map traceDefs, boolean baseAtTop, Map srcToTrack, Map trackToY, Map srcToFeedbackY, boolean forStackedClusters) {
        Iterator asit = this.getAllSourceIterator();
        while (asit.hasNext()) {
            String srcID = (String)asit.next();
            if (traceDefs.get(srcID) != null) continue;
            SuperSrcRouterPointSource corners = new SuperSrcRouterPointSource(srcID, baseAtTop, forStackedClusters);
            traceDefs.put(srcID, corners);
            Double traceX = (Double)internalTraces.get(srcID);
            Double track = (Double)outboundTraces.get(srcID);
            SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)this.outboundLinkPlans_.get(srcID);
            corners.init(this, genome, lo, frc, placement, traceX, track, padChanges, srcToTrack, trackToY, srcToFeedbackY, sin, this.fanOutTrackedGrid_);
        }
    }

    public Map routeInternalLinks(Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map placement) {
        Map<String, SpecialtyLayoutLinkData> retval = new HashMap();
        if (this.fanInType_ == 2) {
            Point2D upperLeftFanInPt = this.getClusterDims(genome, lo, frc).getFanInCorner(placement);
            retval = this.fanInGlr_.convertInternalLinks(this.fanInLinkPlans_, upperLeftFanInPt, placement, padChanges, genome, lo, frc, this.coreID_);
        }
        if (this.fanOutLinkPlans_ != null) {
            Point2D upperLeftFanOutPt = this.getClusterDims(genome, lo, frc).getFanOutCorner(placement, true);
            Map fanOutConv = this.fanOutGlr_.convertInternalLinks(this.fanOutLinkPlans_, upperLeftFanOutPt, placement, padChanges, genome, lo, frc, this.coreID_);
            retval.putAll(fanOutConv);
            Map feedbackConv = this.fanOutGlr_.convertInternalLinks(this.feedbackLinkPlans_, upperLeftFanOutPt, placement, padChanges, genome, lo, frc, this.coreID_);
            SpecialtyLayoutLinkData.mergeMaps(retval, feedbackConv);
            Map jumpConv = this.fanOutConvertCoreJumpers(genome, lo, frc, placement, padChanges);
            SpecialtyLayoutLinkData.mergeMaps(retval, jumpConv);
        }
        if (this.fanOutNodes_.isEmpty()) {
            SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)retval.get(this.coreID_);
            if (sin == null) {
                sin = new SpecialtyLayoutLinkData(this.coreID_);
                retval.put(this.coreID_, sin);
            }
            this.simpleFeedbackRouting(sin, placement, padChanges, genome, lo, frc);
        }
        return retval;
    }

    public List convertDeparturePath(List pointList, Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map placement) {
        Point2D upperLeftFanOutPt = this.getClusterDims(genome, lo, frc).getFanOutCorner(placement, true);
        return this.fanOutGlr_.convertPositionListToPoints(pointList, upperLeftFanOutPt, placement, padChanges, genome, lo, frc, this.coreID_);
    }

    public Point2D convertDeparturePoint(TrackedGrid.TrackPosRC tprc, Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map placement) {
        Point2D upperLeftFanOutPt = this.getClusterDims(genome, lo, frc).getFanOutCorner(placement, true);
        return this.fanOutGlr_.convertPositionToPoint(tprc, upperLeftFanOutPt, placement, padChanges, genome, lo, frc, this.coreID_);
    }

    public static List findTerminalTargets(GenomeSubset subset, boolean omitNonGenesWithInputs, double traceOffset, boolean textToo) {
        ArrayList<GeneAndSatelliteCluster> retval = new ArrayList<GeneAndSatelliteCluster>();
        Iterator nit = subset.getNodeIterator();
        while (nit.hasNext()) {
            int nodeType;
            String nodeID = (String)nit.next();
            int tc = subset.getTargetCount(nodeID);
            if (tc != 0 || (nodeType = subset.getBaseGenome().getNode(nodeID).getNodeType()) != 4 && omitNonGenesWithInputs && !subset.getNodeSources(nodeID).isEmpty()) continue;
            retval.add(new GeneAndSatelliteCluster(nodeID, false, traceOffset, true, textToo));
        }
        return retval;
    }

    public static void fillTargetClusters(Genome genome, List clusters, Layout lo, FontRenderContext frc) {
        int num = clusters.size();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)clusters.get(i);
            clust.fillTargetClusterGreedy(genome, lo, frc);
        }
    }

    public static List fillTargetClustersByGroups(Genome genome, List clusters, Map groups, Layout lo, FontRenderContext frc, double traceOffset, boolean doPhaseTwo, boolean textToo) {
        GeneAndSatelliteCluster clust;
        int i;
        ArrayList<GeneAndSatelliteCluster> retval = new ArrayList<GeneAndSatelliteCluster>();
        int num = clusters.size();
        for (i = 0; i < num; ++i) {
            clust = new GeneAndSatelliteCluster((String)clusters.get(i), false, traceOffset, true, textToo);
            retval.add(clust);
            clust.prepFromGroupsPhaseOne(genome, groups);
        }
        if (doPhaseTwo) {
            for (i = 0; i < num; ++i) {
                clust = (GeneAndSatelliteCluster)retval.get(i);
                clust.prepPhaseTwo(genome, lo, frc, null);
            }
        }
        return retval;
    }

    private void simpleFanInFinalLinkRoutingLinkCreation(SpecialtyLayoutLinkData sin, MetaClusterPointSource lps, SortedMap sortByCoord, Map holdDrops, String srcID, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, boolean noFan) {
        boolean entryFromTop = this.ddo_ == null ? true : this.ddo_.comingFromTop(srcID, this);
        boolean deferred = lps.isForDeferredOnly();
        List perClust = deferred ? lps.initInboundsPerSrcForDeferred(this.coreID_, srcID) : null;
        boolean isFirst = true;
        SpecialtyLayoutLinkData.TrackPos lastForSrc = null;
        Iterator sbxit = sortByCoord.keySet().iterator();
        while (sbxit.hasNext()) {
            Double cVal = (Double)sbxit.next();
            List linksPerC = (List)sortByCoord.get(cVal);
            int numLinks = linksPerC.size();
            for (int i = 0; i < numLinks; ++i) {
                String linkID = (String)linksPerC.get(i);
                if (deferred) {
                    InboundCorners ic = new InboundCorners(linkID);
                    perClust.add(ic);
                    boolean isToPen = false;
                    if (!noFan) {
                        String targNode = genome.getLinkage(linkID).getTarget();
                        isToPen = this.penultimate_.keySet().contains(targNode);
                    }
                    List dropPts = (List)holdDrops.get(linkID);
                    List convertedDrops = SpecialtyLayoutLinkData.TrackPos.convertPointList(dropPts);
                    SpecialtyLayoutLinkData.TrackPos finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
                    if (isFirst || isToPen) {
                        ic.needDrop = true;
                        ic.dropY = finalForClust.getPoint().getY();
                    } else {
                        ic.needDrop = false;
                        ic.prevPoint = lastForSrc;
                    }
                    ic.finalPath.addAll(convertedDrops);
                    int whichIndex = isToPen ? 0 : convertedDrops.size() - 1;
                    lastForSrc = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(whichIndex);
                    lastForSrc = (SpecialtyLayoutLinkData.TrackPos)lastForSrc.clone();
                } else {
                    if (!sin.haveLink(linkID)) {
                        sin.startNewLink(linkID);
                    }
                    List dropPts = (List)holdDrops.get(linkID);
                    List convertedDrops = SpecialtyLayoutLinkData.TrackPos.convertPointList(dropPts);
                    SpecialtyLayoutLinkData.TrackPos finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
                    Point2D finalForClustPt = finalForClust.getPoint();
                    boolean extendingVertically = !noFan;
                    lps.buildPrePath(sin, linkID, finalForClustPt, isFirst, positions, padChanges, genome, lo, frc, extendingVertically, isFirst && entryFromTop);
                    sin.addPositionListToLink(linkID, convertedDrops);
                }
                isFirst = false;
            }
        }
    }

    private void classifyInboundLinks(Genome genome, Map fanInTargs, Map fanOutTargs) {
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            Map workingMap;
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            String trg = link.getTarget();
            int trgMember = this.nodeFanMembership(trg);
            int linkType = this.getInboundLinkType(trgMember);
            switch (trgMember) {
                case 2: {
                    workingMap = fanOutTargs;
                    break;
                }
                case 0: 
                case 1: {
                    workingMap = fanInTargs;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ArrayList<GridLinkRouter.ClassifiedLink> perSrc = (ArrayList<GridLinkRouter.ClassifiedLink>)workingMap.get(src);
            if (perSrc == null) {
                perSrc = new ArrayList<GridLinkRouter.ClassifiedLink>();
                workingMap.put(src, perSrc);
            }
            GridLinkRouter.ClassifiedLink cLink = new GridLinkRouter.ClassifiedLink(linkID, linkType);
            perSrc.add(cLink);
        }
    }

    private void classifyInternalLinks(Genome genome, Map fanInSrcs, Map fanOutSrcs) {
        Iterator ilit = this.internalLinks_.iterator();
        while (ilit.hasNext()) {
            Map workingMap;
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            String trg = link.getTarget();
            int srcMember = this.nodeFanMembership(src);
            int trgMember = this.nodeFanMembership(trg);
            int linkType = this.getInternalLinkType(srcMember, trgMember);
            switch (srcMember) {
                case 0: 
                case 2: {
                    workingMap = fanOutSrcs;
                    break;
                }
                case 1: {
                    workingMap = fanInSrcs;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ArrayList<GridLinkRouter.ClassifiedLink> perSrc = (ArrayList<GridLinkRouter.ClassifiedLink>)workingMap.get(src);
            if (perSrc == null) {
                perSrc = new ArrayList<GridLinkRouter.ClassifiedLink>();
                workingMap.put(src, perSrc);
            }
            GridLinkRouter.ClassifiedLink cLink = new GridLinkRouter.ClassifiedLink(linkID, linkType);
            perSrc.add(cLink);
        }
    }

    private void addSources(Set srcs) {
        this.inputs_.addAll(srcs);
    }

    private void addPenultimate(String penID, Set sources) {
        if (sources == null) {
            sources = new HashSet();
        }
        this.penultimate_.put(penID, sources);
        this.inputs_.addAll(sources);
        this.fanInNodes_.add(penID);
    }

    private void normalizeSources() {
        Set kset = this.penultimate_.keySet();
        this.inputs_.removeAll(kset);
    }

    private List directLinkDropPoints(String linkID, Genome genome, Map padChanges, MetaClusterPointSource lps, Layout lo, FontRenderContext frc, Map placement) {
        ArrayList<Point2D.Double> retval = new ArrayList<Point2D.Double>();
        Point2D targLoc = (Point2D)placement.get(this.coreID_);
        int landing = this.getCurrentLandingPad(genome.getLinkage(linkID), padChanges, false);
        Vector2D padOffset = this.landingPadToOffset(landing, genome, lo, frc, this.coreID_);
        double traceY = lps.getTargetTraceY();
        if (this.fanInType_ != 1) {
            retval.add(new Point2D.Double(targLoc.getX() + padOffset.getX(), traceY));
            return retval;
        }
        Vector2D leftmostPenOffset = this.landingPadToOffset(this.leftmostPen(genome), genome, lo, frc, this.coreID_);
        double whichOffset = leftmostPenOffset.getX() - padOffset.getX();
        int whichDirect = (int)(whichOffset / 10.0);
        String pen0 = (String)this.penOrder_.get(new Integer(0));
        Point2D penLoc = (Point2D)placement.get(pen0);
        if (lps.busFeedIsHorizontal()) {
            int dropTrack = this.orderToSideDropTrack(genome, 0);
            dropTrack = genome.getNode(this.coreID_).getNodeType() == 4 ? (dropTrack -= whichDirect) : 0;
            Vector2D dropOffset = this.landingPadToOffset(dropTrack, genome, lo, frc, this.coreID_);
            retval.add(new Point2D.Double(targLoc.getX() + dropOffset.getX(), traceY));
            retval.add(new Point2D.Double(targLoc.getX() + dropOffset.getX(), penLoc.getY() + (double)whichDirect * 10.0));
        } else {
            double horizontalX = lps.getVerticalDropX(placement, padChanges, genome, lo, frc);
            retval.add(new Point2D.Double(horizontalX, penLoc.getY() + (double)whichDirect * 10.0));
        }
        retval.add(new Point2D.Double(targLoc.getX() + padOffset.getX(), penLoc.getY() + (double)whichDirect * 10.0));
        return retval;
    }

    private List doLinkToDropPoints(String linkID, Genome genome, Map padChanges, MetaClusterPointSource lps, Layout lo, FontRenderContext frc, Map placement) {
        Linkage link = genome.getLinkage(linkID);
        int landing = this.getCurrentLandingPad(link, padChanges, false);
        String ltrg = link.getTarget();
        Node fanNode = genome.getNode(ltrg);
        int fanType = fanNode.getNodeType();
        Point2D penLoc = (Point2D)placement.get(ltrg);
        if (this.fanInType_ != 2) {
            Point2D targLoc = (Point2D)placement.get(this.coreID_);
            int order = this.penToOrder(ltrg);
            if (landing == 0 || fanType == 6) {
                return this.linkToTopDropPoints(order, lps, genome, lo, frc, penLoc, targLoc, placement, padChanges);
            }
            return this.linkToSideDropPoints(order, lps, genome, lo, frc, penLoc, targLoc, placement, padChanges);
        }
        Grid.RowAndColumn rac = this.fanInTrackedGrid_.findPositionRandC(ltrg);
        return this.linkToComplexFanInDropPoints(rac.row, lps, genome, lo, frc, penLoc);
    }

    private Set pensAsTargets(String srcID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator kit = this.penultimate_.keySet().iterator();
        while (kit.hasNext()) {
            String pen = (String)kit.next();
            Set pSrc = (Set)this.penultimate_.get(pen);
            if (!pSrc.contains(srcID)) continue;
            retval.add(pen);
        }
        return retval;
    }

    private void orderParentPens(String penID) {
        Set pSrcs = (Set)this.penultimate_.get(penID);
        Set penKeys = this.penultimate_.keySet();
        HashSet penParents = new HashSet(penKeys);
        penParents.retainAll(pSrcs);
        if (this.penOrder_.values().contains(penID)) {
            return;
        }
        this.bumpPenOrder(penID);
        Iterator ppit = penParents.iterator();
        while (ppit.hasNext()) {
            String penParent = (String)ppit.next();
            this.orderParentPens(penParent);
        }
    }

    private boolean linkToFanOut(String linkID, Genome genome) {
        Linkage link = genome.getLinkage(linkID);
        String ltrg = link.getTarget();
        return this.fanOutNodes_.contains(ltrg);
    }

    private void orderPenultimate(String penID, Genome genome) {
        if (!this.toCoreFromPen_.containsKey(penID)) {
            Set allLinks = this.getAllLinksForNodePair(genome, penID, this.coreID_);
            this.toCoreFromPen_.put(penID, allLinks);
        }
        if (this.penOrder_.values().contains(penID)) {
            return;
        }
        this.orderParentPens(penID);
    }

    private void bumpPenOrder(String penID) {
        if (this.penOrder_.isEmpty()) {
            this.penOrder_.put(new Integer(0), penID);
        } else {
            Integer last = (Integer)this.penOrder_.lastKey();
            this.penOrder_.put(new Integer(last + 1), penID);
        }
    }

    private int penIDToPadnumNonGene(Genome genome, String penID) {
        Node node = genome.getNode(this.coreID_);
        int needed = genome.getInboundLinkCount(this.coreID_);
        int nodeType = node.getNodeType();
        INodeRenderer rend = NodeProperties.chooseRenderer(nodeType, 2);
        TreeSet usedPads = new TreeSet();
        int inbounds = this.inboundLinks_.size();
        for (int i = 0; i < inbounds; ++i) {
            rend.getBestTopPad(node, usedPads, 1, needed, true);
        }
        ArrayList revKeys = new ArrayList(this.penOrder_.keySet());
        Collections.sort(revKeys, Collections.reverseOrder());
        Iterator pit = revKeys.iterator();
        while (pit.hasNext()) {
            Integer order = (Integer)pit.next();
            String currPenID = (String)this.penOrder_.get(order);
            Set allLinks = (Set)this.toCoreFromPen_.get(currPenID);
            int numLinks = allLinks.size();
            int lastTop = 0;
            for (int i = 0; i < numLinks; ++i) {
                lastTop = rend.getBestTopPad(node, usedPads, 1, needed, true);
            }
            if (!currPenID.equals(penID)) continue;
            return lastTop;
        }
        throw new IllegalArgumentException();
    }

    private int penIDToPadnum(Genome genome, String penID) {
        Node node = genome.getNode(this.coreID_);
        if (node.getNodeType() != 4) {
            return this.penIDToPadnumNonGene(genome, penID);
        }
        int currPad = 5 - this.feedbacks_.size();
        Iterator pit = this.penOrder_.keySet().iterator();
        while (pit.hasNext()) {
            Integer order = (Integer)pit.next();
            String currPenID = (String)this.penOrder_.get(order);
            Set allLinks = (Set)this.toCoreFromPen_.get(currPenID);
            int numLinks = allLinks.size();
            if (currPenID.equals(penID)) {
                return currPad;
            }
            currPad -= numLinks < 3 ? 3 : numLinks;
        }
        throw new IllegalArgumentException();
    }

    private int penToOrder(String penID) {
        Iterator pit = this.penOrder_.keySet().iterator();
        while (pit.hasNext()) {
            Integer order = (Integer)pit.next();
            String chkPenID = (String)this.penOrder_.get(order);
            if (!chkPenID.equals(penID)) continue;
            return order;
        }
        throw new IllegalStateException();
    }

    private int leftmostPen(Genome genome) {
        Integer lastKey = (Integer)this.penOrder_.lastKey();
        String lastPenID = (String)this.penOrder_.get(lastKey);
        return this.penIDToPadnum(genome, lastPenID);
    }

    private int orderToTopDropTrack(Genome genome, int order) {
        int leftmost = this.leftmostPen(genome);
        int maxPen = this.penOrder_.size() - 1;
        if (order == maxPen) {
            return leftmost;
        }
        return leftmost + -3 + 1 - 2 * (maxPen - order);
    }

    private int orderToSideDropTrack(Genome genome, int order) {
        int leftmost = this.leftmostPen(genome);
        int maxPen = this.penOrder_.size() - 1;
        return leftmost + -3 - 2 * (maxPen - order);
    }

    private List linkToTopDropPoints(int order, MetaClusterPointSource lps, Genome genome, Layout lo, FontRenderContext frc, Point2D penLoc, Point2D targLoc, Map positions, Map padChanges) {
        double nextToFinalX;
        ArrayList<Point2D.Double> retval = new ArrayList<Point2D.Double>();
        if (lps.busFeedIsHorizontal()) {
            int dropTrack = this.orderToTopDropTrack(genome, order);
            Vector2D offset = this.landingPadToOffset(dropTrack, genome, lo, frc, this.coreID_);
            retval.add(new Point2D.Double(targLoc.getX() + offset.getX(), lps.getTargetTraceY()));
            if (dropTrack == this.leftmostPen(genome)) {
                return retval;
            }
            nextToFinalX = targLoc.getX() + offset.getX();
        } else {
            nextToFinalX = lps.getVerticalDropX(positions, padChanges, genome, lo, frc);
        }
        retval.add(new Point2D.Double(nextToFinalX, penLoc.getY() + -30.0));
        retval.add(new Point2D.Double(penLoc.getX(), penLoc.getY() + -30.0));
        return retval;
    }

    private List linkToSideDropPoints(int order, MetaClusterPointSource lps, Genome genome, Layout lo, FontRenderContext frc, Point2D penLoc, Point2D targLoc, Map positions, Map padChanges) {
        double finalX;
        ArrayList<Point2D.Double> retval = new ArrayList<Point2D.Double>();
        if (lps.busFeedIsHorizontal()) {
            int dropTrack = this.orderToSideDropTrack(genome, order);
            Vector2D offset = this.landingPadToOffset(dropTrack, genome, lo, frc, this.coreID_);
            retval.add(new Point2D.Double(targLoc.getX() + offset.getX(), lps.getTargetTraceY()));
            finalX = targLoc.getX() + offset.getX();
        } else {
            finalX = lps.getVerticalDropX(positions, padChanges, genome, lo, frc);
        }
        retval.add(new Point2D.Double(finalX, penLoc.getY()));
        return retval;
    }

    private List linkToComplexFanInDropPoints(int order, MetaClusterPointSource lps, Genome genome, Layout lo, FontRenderContext frc, Point2D penLoc) {
        ArrayList<Point2D.Double> retval = new ArrayList<Point2D.Double>();
        double offset = (double)order * 10.0;
        retval.add(new Point2D.Double(penLoc.getX() - offset, lps.getTargetTraceY()));
        retval.add(new Point2D.Double(penLoc.getX() - offset, penLoc.getY()));
        return retval;
    }

    private List linkIDsPerClusterOldStyle(String srcID, Genome genome) {
        if (!this.inputs_.contains(srcID)) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>();
        Set penKeys = this.penultimate_.keySet();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String targID;
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(srcID) || !this.coreID_.equals(targID = link.getTarget()) && (!penKeys.contains(targID) || penKeys.contains(srcID))) continue;
            retval.add(link.getID());
        }
        return retval;
    }

    public List linkIDsPerCluster(String srcID, Genome genome) {
        ArrayList<String> retval = new ArrayList<String>();
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            if (!link.getSource().equals(srcID)) continue;
            retval.add(linkID);
        }
        return retval;
    }

    private List getInboundLinkOrder(Genome genome, Map padChanges) {
        Linkage link;
        TreeMap<Integer, ArrayList<String>> linksForCore = new TreeMap<Integer, ArrayList<String>>();
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link2 = genome.getLinkage(linkID);
            if (!link2.getTarget().equals(this.coreID_)) continue;
            int targPad = this.getCurrentLandingPad(link2, padChanges, false);
            Integer targPadObj = new Integer(targPad);
            ArrayList<String> linksForPad = (ArrayList<String>)linksForCore.get(targPadObj);
            if (linksForPad == null) {
                linksForPad = new ArrayList<String>();
                linksForCore.put(targPadObj, linksForPad);
            }
            linksForPad.add(linkID);
        }
        TreeMap<FanOrdering, ArrayList<String>> fanOutLinks = new TreeMap<FanOrdering, ArrayList<String>>();
        ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link3 = genome.getLinkage(linkID);
            String targID = link3.getTarget();
            if (!this.fanOutNodes_.contains(targID)) continue;
            int targPad = this.getCurrentLandingPad(link3, padChanges, false);
            Grid.RowAndColumn randc = this.fanOutTrackedGrid_.findPositionRandC(targID);
            FanOrdering fi = new FanOrdering(randc, targPad);
            ArrayList<String> linksForPad = (ArrayList<String>)fanOutLinks.get(fi);
            if (linksForPad == null) {
                linksForPad = new ArrayList<String>();
                fanOutLinks.put(fi, linksForPad);
            }
            linksForPad.add(linkID);
        }
        TreeMap<Comparable<Integer>, ArrayList<String>> fanInLinks = new TreeMap<Comparable<Integer>, ArrayList<String>>();
        if (this.fanInType_ == 1) {
            ilit = this.inboundLinks_.iterator();
            while (ilit.hasNext()) {
                String linkID = (String)ilit.next();
                link = genome.getLinkage(linkID);
                String targID = link.getTarget();
                if (!this.fanInNodes_.contains(targID)) continue;
                ArrayList<String> linksForPad = (ArrayList<String>)fanInLinks.get(new Integer(7));
                if (linksForPad == null) {
                    linksForPad = new ArrayList<String>();
                    fanInLinks.put(new Integer(7), linksForPad);
                }
                linksForPad.add(linkID);
            }
        } else if (this.fanInType_ == 2) {
            ilit = this.inboundLinks_.iterator();
            while (ilit.hasNext()) {
                String linkID = (String)ilit.next();
                link = genome.getLinkage(linkID);
                String targID = link.getTarget();
                if (!this.fanInNodes_.contains(targID)) continue;
                if (!this.fanInTrackedGrid_.contains(targID)) {
                    System.err.println("what happened to " + targID);
                    continue;
                }
                int targPad = this.getCurrentLandingPad(link, padChanges, false);
                Grid.RowAndColumn randc = this.fanInTrackedGrid_.findPositionRandC(targID);
                FanOrdering fi = new FanOrdering(randc, targPad);
                ArrayList<String> linksForPad = (ArrayList<String>)fanInLinks.get(fi);
                if (linksForPad == null) {
                    linksForPad = new ArrayList<String>();
                    fanInLinks.put(fi, linksForPad);
                }
                linksForPad.add(linkID);
            }
        }
        ArrayList retval = new ArrayList();
        Iterator filit = fanInLinks.values().iterator();
        while (filit.hasNext()) {
            ArrayList links = (ArrayList)filit.next();
            retval.addAll(links);
        }
        Iterator lfcit = linksForCore.values().iterator();
        while (lfcit.hasNext()) {
            ArrayList links = (ArrayList)lfcit.next();
            retval.addAll(links);
        }
        Iterator folit = fanOutLinks.values().iterator();
        while (folit.hasNext()) {
            ArrayList links = (ArrayList)folit.next();
            retval.addAll(links);
        }
        return retval;
    }

    private Vector2D launchPadToOffset(int padNum, Genome genome, Layout lo, FontRenderContext frc, String nodeID) {
        return TrackedGrid.launchPadToOffset(padNum, genome, lo, frc, nodeID);
    }

    private Vector2D landingPadToOffset(int padNum, Genome genome, Layout lo, FontRenderContext frc, String nodeID) {
        return TrackedGrid.landingPadToOffset(padNum, genome, lo, frc, nodeID, 1);
    }

    private double calcExtraGeneLength(Genome genome) {
        int numFeeds;
        int currFeed;
        Node node = genome.getNode(this.coreID_);
        if (node.getNodeType() != 4) {
            return 0.0;
        }
        ArrayList<Linkage> linksToOrder = new ArrayList<Linkage>();
        ArrayList<Linkage> feedbacks = new ArrayList<Linkage>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String lsource = link.getSource();
            String ltrg = link.getTarget();
            if (!ltrg.equals(this.coreID_)) continue;
            if (lsource.equals(this.coreID_)) {
                feedbacks.add(link);
                continue;
            }
            linksToOrder.add(link);
        }
        int numLinks = linksToOrder.size();
        if (this.fanInType_ == 1) {
            numLinks += 2 * this.fanInNodes_.size();
        }
        int currPad = numLinks < (currFeed = 5 - (numFeeds = feedbacks.size())) ? numLinks - 1 : currFeed;
        int minPad = currPad - numLinks + 1;
        Gene gene = (Gene)node;
        int currPads = gene.getPadCount();
        int minExistingPad = 7 - currPads;
        if (minExistingPad > 0) {
            minExistingPad = 0;
        }
        int retpad = minPad < minExistingPad ? minPad : minExistingPad;
        return 10.0 * -((double)retpad);
    }

    private void fillTargetClusterGreedy(Genome genome, Layout lo, FontRenderContext frc) {
        FanBuilder builder = new FanBuilder();
        HashMap sources = new HashMap();
        HashSet<Integer> okTypes = new HashSet<Integer>();
        okTypes.add(new Integer(3));
        Set survivors = builder.buildFanIn(genome, this.coreID_, sources, okTypes);
        HashSet emptySet = new HashSet();
        Iterator sit = survivors.iterator();
        while (sit.hasNext()) {
            String survivor = (String)sit.next();
            HashSet surviveSrcs = (HashSet)sources.get(survivor);
            this.addSources(surviveSrcs == null ? emptySet : surviveSrcs);
            if (survivor.equals(this.coreID_)) continue;
            this.addPenultimate(survivor, surviveSrcs);
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            String lsource = link.getSource();
            if (this.makeLinkInbound(link)) {
                this.inboundLinks_.add(linkID);
                this.inputs_.add(lsource);
                continue;
            }
            if (this.makeLinkOutbound(link)) {
                this.outboundLinks_.add(linkID);
                continue;
            }
            if (!this.makeLinkInternal(link)) continue;
            this.internalLinks_.add(linkID);
        }
        this.normalizeSources();
        this.fanInType_ = this.classifyFanIn(genome);
        if (this.fanInType_ == 2 && lo != null && frc != null) {
            this.fanInPadPlans_ = new HashMap();
            this.fanInTrackedGrid_ = new TrackedGrid(this.gridFanIns(genome), genome, lo, frc, this.coreID_, this.textToo_);
            this.changeInternalFanPads(this.fanInTrackedGrid_, this.fanInNodes_, genome, this.fanInPadPlans_);
        }
    }

    public boolean okForHalo(Genome genome) {
        return this.fanInNodes_.isEmpty() || this.classifyFanIn(genome) != 2;
    }

    private int classifyFanIn(Genome genome) {
        if (this.fanInNodes_.isEmpty()) {
            return 0;
        }
        HashSet<String> seenNodes = new HashSet<String>();
        Iterator ilit = this.internalLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String ltarg = link.getTarget();
            String lsrc = link.getSource();
            if (!this.fanInNodes_.contains(lsrc)) continue;
            if (!ltarg.equals(this.coreID_)) {
                return 2;
            }
            if (seenNodes.contains(lsrc)) continue;
            seenNodes.add(lsrc);
            Node fanNode = genome.getNode(lsrc);
            int fanType = fanNode.getNodeType();
            if (fanType != 3 && fanType != 6 && fanType != 5) {
                return 2;
            }
            if (fanNode.getPadCount() > DBNode.getDefaultPadCount(fanType)) {
                return 2;
            }
            int intoNode = genome.getInboundLinkCount(lsrc);
            if (intoNode > (fanType == 6 ? 1 : 2)) {
                return 2;
            }
            int outOfNode = genome.getOutboundLinkCount(lsrc);
            if (outOfNode > 1) {
                return 2;
            }
            if (intoNode <= genome.getSourceCount(lsrc)) continue;
            return 2;
        }
        return 1;
    }

    private boolean makeLinkInbound(Linkage link) {
        String ltarg = link.getTarget();
        String lsrc = link.getSource();
        boolean ownSource = this.fanInNodes_.contains(lsrc) || this.fanOutNodes_.contains(lsrc) || lsrc.equals(this.coreID_);
        boolean ownTarg = this.fanInNodes_.contains(ltarg) || this.fanOutNodes_.contains(ltarg) || ltarg.equals(this.coreID_);
        return ownTarg && !ownSource;
    }

    private boolean makeLinkOutbound(Linkage link) {
        boolean ownTarg;
        String ltarg = link.getTarget();
        String lsrc = link.getSource();
        boolean ownSourceFanInOrCore = this.fanInNodes_.contains(lsrc) || lsrc.equals(this.coreID_);
        boolean ownSource = ownSourceFanInOrCore || this.fanOutNodes_.contains(lsrc);
        boolean ownTargFanInOrCore = this.fanInNodes_.contains(ltarg) || ltarg.equals(this.coreID_);
        boolean bl = ownTarg = ownTargFanInOrCore || this.fanOutNodes_.contains(ltarg);
        if (!ownSource) {
            return false;
        }
        if (!ownTarg) {
            return true;
        }
        if (ltarg.equals(this.coreID_) && lsrc.equals(this.coreID_)) {
            return false;
        }
        return ownTargFanInOrCore && !ownSourceFanInOrCore;
    }

    private boolean isLargeScaleFeedback(Linkage link) {
        if (!this.makeLinkOutbound(link)) {
            return false;
        }
        String ltarg = link.getTarget();
        boolean ownTarg = this.fanInNodes_.contains(ltarg) || ltarg.equals(this.coreID_);
        return ownTarg;
    }

    private boolean makeLinkInternal(Linkage link) {
        String ltarg = link.getTarget();
        String lsrc = link.getSource();
        boolean ownSourceFanInOrCore = this.fanInNodes_.contains(lsrc) || lsrc.equals(this.coreID_);
        boolean ownSource = ownSourceFanInOrCore || this.fanOutNodes_.contains(lsrc);
        boolean ownTargFanInOrCore = this.fanInNodes_.contains(ltarg) || ltarg.equals(this.coreID_);
        boolean ownTarg = ownTargFanInOrCore || this.fanOutNodes_.contains(ltarg);
        return ownSource && ownTarg && !this.makeLinkOutbound(link);
    }

    private void orderFanInOrphans(Genome genome) {
        Iterator pit = this.penultimate_.keySet().iterator();
        while (pit.hasNext()) {
            String penID = (String)pit.next();
            if (!this.penOrder_.values().contains(penID)) {
                this.bumpPenOrder(penID);
            }
            if (this.toCoreFromPen_.containsKey(penID)) continue;
            Set allLinks = this.getAllLinksForNodePair(genome, penID, this.coreID_);
            this.toCoreFromPen_.put(penID, allLinks);
        }
    }

    private void locateSimpleFanIns(Point2D basePos, Map positions, Genome genome, Layout lo, FontRenderContext frc) {
        Iterator poit = this.penOrder_.keySet().iterator();
        while (poit.hasNext()) {
            Integer order = (Integer)poit.next();
            String penID = (String)this.penOrder_.get(order);
            int orderNum = order;
            Point2D pos = this.simpleFanPosCalc(orderNum, penID, basePos, genome, lo, frc);
            UiUtil.forceToGrid(pos, 10.0);
            positions.put(penID, pos);
        }
    }

    private Grid gridFanIns(Genome genome) {
        HashSet<String> allNodes = new HashSet<String>();
        HashSet<Link> allLinks = new HashSet<Link>();
        HashSet<String> nodesToPlace = new HashSet<String>();
        ArrayList<DialogBuiltGeneralMotif> motifList = new ArrayList<DialogBuiltGeneralMotif>();
        int count = 0;
        Iterator ilit = this.internalLinks_.iterator();
        while (ilit.hasNext()) {
            Link sLink;
            DialogBuiltGeneralMotif dbm;
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            String trg = link.getTarget();
            if (!this.fanInNodes_.contains(src)) continue;
            if (this.fanOutNodes_.contains(trg)) {
                dbm = new DialogBuiltGeneralMotif(src, src, Integer.toString(count++));
                motifList.add(dbm);
                nodesToPlace.add(src);
                allNodes.add(src);
                sLink = new Link(src, src);
                allLinks.add(sLink);
                continue;
            }
            dbm = new DialogBuiltGeneralMotif(src, trg, Integer.toString(count++));
            motifList.add(dbm);
            nodesToPlace.add(src);
            nodesToPlace.add(trg);
            allNodes.add(src);
            allNodes.add(trg);
            sLink = new Link(src, trg);
            allLinks.add(sLink);
        }
        RectangularTreeEngine rte = new RectangularTreeEngine();
        LayoutOptions options = new LayoutOptions();
        Grid grid = rte.layoutFanInOutHier(allNodes, allLinks, nodesToPlace, motifList, options, null, false);
        if (grid.contains(this.coreID_)) {
            Grid.RowAndColumn rAndC = grid.getRowAndColumn(grid.findPosition(this.coreID_));
            grid.setCellValue(rAndC.row, rAndC.col, null);
            if (grid.rowIsEmpty(rAndC.row)) {
                grid.dropRow(rAndC.row);
            }
        }
        return grid;
    }

    private Grid gridFanOuts(Genome genome) {
        HashSet<String> allNodes = new HashSet<String>();
        HashSet<Link> allLinks = new HashSet<Link>();
        HashSet<String> nodesToPlace = new HashSet<String>();
        ArrayList<DialogBuiltGeneralMotif> motifList = new ArrayList<DialogBuiltGeneralMotif>();
        int count = 0;
        Iterator ilit = this.internalLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            if (!this.fanOutNodes_.contains(src) && !src.equals(this.coreID_)) continue;
            String trg = link.getTarget();
            DialogBuiltGeneralMotif dbm = new DialogBuiltGeneralMotif(src, trg, Integer.toString(count++));
            motifList.add(dbm);
            nodesToPlace.add(src);
            nodesToPlace.add(trg);
            allNodes.add(src);
            allNodes.add(trg);
            Link sLink = new Link(src, trg);
            allLinks.add(sLink);
        }
        LayoutOptions options = new LayoutOptions();
        RectangularTreeEngine rte = new RectangularTreeEngine();
        Grid grid = rte.layoutFanInOutHier(allNodes, allLinks, nodesToPlace, motifList, options, this.coreID_, true);
        return grid;
    }

    private void placeFan(TrackedGrid grid, Point2D upperLeft, Map positions, Layout lo) {
        grid.placeGrid(upperLeft, positions, lo, this.coreID_);
    }

    private void mergePrecalcPads(Set nodes, Map preCalcPadChanges, Genome genome, Map padChanges) {
        Iterator kit = preCalcPadChanges.keySet().iterator();
        while (kit.hasNext()) {
            String linkID = (String)kit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            String trg = link.getTarget();
            PadCalculatorToo.PadResult prePres = (PadCalculatorToo.PadResult)preCalcPadChanges.get(linkID);
            PadCalculatorToo.PadResult newPres = (PadCalculatorToo.PadResult)padChanges.get(linkID);
            if (newPres == null) {
                if (nodes.contains(src)) {
                    padChanges.put(linkID, prePres);
                    continue;
                }
                int preAssigned = this.newLaunchPadForSource(src, genome, padChanges);
                if (preAssigned != Integer.MAX_VALUE) {
                    padChanges.put(linkID, new PadCalculatorToo.PadResult(preAssigned, prePres.landing));
                    continue;
                }
                padChanges.put(linkID, prePres);
                continue;
            }
            int newLaunch = nodes.contains(src) ? prePres.launch : newPres.launch;
            int newLand = nodes.contains(trg) ? prePres.landing : newPres.landing;
            padChanges.put(linkID, new PadCalculatorToo.PadResult(newLaunch, newLand));
        }
    }

    private int newLaunchPadForSource(String srcID, Genome genome, Map padChanges) {
        Iterator kit = padChanges.keySet().iterator();
        while (kit.hasNext()) {
            String linkID = (String)kit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            if (!src.equals(srcID)) continue;
            PadCalculatorToo.PadResult newPres = (PadCalculatorToo.PadResult)padChanges.get(linkID);
            return newPres.launch;
        }
        return Integer.MAX_VALUE;
    }

    private void changeInternalFanPads(TrackedGrid grid, Set fanElements, Genome genome, Map padChanges) {
        Iterator ltpit = this.internalLinks_.iterator();
        List secondPass = this.changeInternalFanPadsOnePass(ltpit, grid, fanElements, genome, padChanges, true);
        Iterator tpit = secondPass.iterator();
        this.changeInternalFanPadsOnePass(tpit, grid, fanElements, genome, padChanges, false);
    }

    private List changeInternalFanPadsOnePass(Iterator linkit, TrackedGrid grid, Set fanElements, Genome genome, Map padChanges, boolean leftEnterOnly) {
        ArrayList<String> retval = new ArrayList<String>();
        while (linkit.hasNext()) {
            String ltrg;
            String linkID = (String)linkit.next();
            boolean coreSrc = false;
            boolean coreTrg = false;
            Linkage link = genome.getLinkage(linkID);
            String lsrc = link.getSource();
            if (!fanElements.contains(lsrc)) {
                if (!lsrc.equals(this.coreID_)) continue;
                coreSrc = true;
            }
            if (!fanElements.contains(ltrg = link.getTarget())) {
                if (!ltrg.equals(this.coreID_)) continue;
                coreTrg = true;
            }
            if (this.changeInternalFanPadsGuts(grid, genome, padChanges, linkID, lsrc, ltrg, coreSrc, coreTrg, leftEnterOnly)) continue;
            retval.add(linkID);
        }
        return retval;
    }

    private boolean changeInternalFanPadsGuts(TrackedGrid grid, Genome genome, Map padChanges, String linkID, String lsrc, String ltrg, boolean coreSrc, boolean coreTrg, boolean leftEnterOnly) {
        int landing;
        int launch;
        GridLinkRouter checker = new GridLinkRouter(grid, this);
        if (coreTrg) {
            return false;
        }
        if (coreSrc) {
            launch = TrackedGrid.launchForGrid(lsrc, genome);
            boolean canGoLeft = grid.canEnterOnLeft(lsrc, ltrg, genome);
            if (leftEnterOnly && !canGoLeft) {
                return false;
            }
            HashSet usedPads = (HashSet)this.padMap_.get(ltrg);
            if (usedPads == null) {
                usedPads = new HashSet();
                this.padMap_.put(ltrg, usedPads);
            }
            landing = checker.landForThisGrid(ltrg, genome, usedPads, 0, canGoLeft, false);
        } else {
            Grid.RowAndColumn srcRC = grid.findPositionRandC(lsrc);
            Grid.RowAndColumn trgRC = grid.findPositionRandC(ltrg);
            int linkDirection = checker.calcGridLinkType(srcRC, trgRC, genome, lsrc, ltrg);
            launch = TrackedGrid.launchForGrid(lsrc, genome);
            boolean canGoLeft = grid.canEnterOnLeft(lsrc, ltrg, genome);
            if (leftEnterOnly && (!canGoLeft || linkDirection != 0)) {
                return false;
            }
            HashSet usedPads = (HashSet)this.padMap_.get(ltrg);
            if (usedPads == null) {
                usedPads = new HashSet();
                this.padMap_.put(ltrg, usedPads);
            }
            landing = checker.landForThisGrid(ltrg, genome, usedPads, linkDirection, canGoLeft, false);
        }
        this.doPadChange(linkID, padChanges, launch, landing);
        return true;
    }

    private int changeFanToCorePads(Set fanElements, Genome genome, Map padChanges, int coreMin, Map oldPadPlans, boolean skipCore) {
        int landing;
        Iterator ltpit = this.internalLinks_.iterator();
        HashMap<String, Integer> totalFromSources = new HashMap<String, Integer>();
        HashMap origLinkOrdering = new HashMap();
        while (ltpit.hasNext()) {
            String linkID = (String)ltpit.next();
            Linkage link = genome.getLinkage(linkID);
            String lsrc = link.getSource();
            String ltrg = link.getTarget();
            if (!fanElements.contains(lsrc) || !ltrg.equals(this.coreID_)) continue;
            Integer fromSrc = (Integer)totalFromSources.get(lsrc);
            if (fromSrc == null) {
                totalFromSources.put(lsrc, new Integer(1));
            } else {
                totalFromSources.put(lsrc, new Integer(fromSrc + 1));
            }
            TreeMap<TaggedComparableInteger, String> orderForSrc = (TreeMap<TaggedComparableInteger, String>)origLinkOrdering.get(lsrc);
            if (orderForSrc == null) {
                orderForSrc = new TreeMap<TaggedComparableInteger, String>();
                origLinkOrdering.put(lsrc, orderForSrc);
            }
            landing = this.getCurrentLandingPad(link, oldPadPlans, false);
            orderForSrc.put(new TaggedComparableInteger(new Integer(landing), linkID), linkID);
        }
        ltpit = this.internalLinks_.iterator();
        int newCoreMin = coreMin;
        while (ltpit.hasNext()) {
            String ltrg;
            String linkID = (String)ltpit.next();
            Linkage link = genome.getLinkage(linkID);
            String lsrc = link.getSource();
            if (!fanElements.contains(lsrc) || !(ltrg = link.getTarget()).equals(this.coreID_)) continue;
            int launch = TrackedGrid.launchForGrid(lsrc, genome);
            landing = skipCore ? this.getCurrentLandingPad(link, oldPadPlans, false) : this.getFanToCorePad(link, coreMin, totalFromSources, origLinkOrdering);
            this.doPadChange(linkID, padChanges, launch, landing);
            if (landing >= newCoreMin) continue;
            newCoreMin = landing;
        }
        return newCoreMin;
    }

    public int getCurrentLandingPad(Linkage link, Map padChanges, boolean useCoreEstimates) {
        Integer coreEst;
        PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)padChanges.get(link.getID());
        if (pres != null) {
            return pres.landing;
        }
        if (useCoreEstimates && this.multiInCoreEstimates_ != null && (coreEst = (Integer)this.multiInCoreEstimates_.get(link.getID())) != null) {
            return coreEst;
        }
        return link.getLandingPad();
    }

    public int getCurrentLaunchPad(Linkage link, Map padChanges) {
        PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)padChanges.get(link.getID());
        return pres == null ? link.getLaunchPad() : pres.launch;
    }

    private void doPadChange(String linkID, Map padChanges, int launch, int landing) {
        PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)padChanges.get(linkID);
        if (pres != null) {
            pres.launch = launch;
            pres.landing = landing;
        } else {
            pres = new PadCalculatorToo.PadResult(launch, landing);
            padChanges.put(linkID, pres);
        }
    }

    private void changeOutboundPads(Genome genome, Map padChanges, boolean isGeneCore) {
        Iterator olit = this.outboundLinks_.iterator();
        while (olit.hasNext()) {
            String linkID = (String)olit.next();
            Linkage link = genome.getLinkage(linkID);
            String lsrc = link.getSource();
            if (isGeneCore && lsrc.equals(this.coreID_)) continue;
            int launch = TrackedGrid.launchForGrid(lsrc, genome);
            int landing = this.getCurrentLandingPad(link, padChanges, false);
            this.doPadChange(linkID, padChanges, launch, landing);
        }
    }

    private void changeInboundPadsForFan(Set fanNodes, TrackedGrid fanGrid, Genome genome, Map padChanges, List sourceOrder, boolean forceTop) {
        HashMap<String, HashSet<String>> targs = new HashMap<String, HashSet<String>>();
        Iterator ilit = this.inboundLinks_.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String ltrg = link.getTarget();
            if (ltrg.equals(this.coreID_) || !fanNodes.contains(ltrg)) continue;
            HashSet<String> linksForTarg = (HashSet<String>)targs.get(ltrg);
            if (linksForTarg == null) {
                linksForTarg = new HashSet<String>();
                targs.put(ltrg, linksForTarg);
            }
            linksForTarg.add(linkID);
        }
        Iterator trit = targs.keySet().iterator();
        while (trit.hasNext()) {
            String ltrg = (String)trit.next();
            HashSet linksForTarg = (HashSet)targs.get(ltrg);
            if (fanNodes.contains(ltrg)) {
                this.inboundLandingForGrid(ltrg, fanGrid, linksForTarg, genome, sourceOrder, padChanges, forceTop);
                continue;
            }
            System.err.println("Where is " + ltrg);
        }
    }

    private void changePadsForFanForJumperLinks(List links, Set fanNodes, TrackedGrid fanGrid, Genome genome, Map padChanges, List sourceOrder, boolean forceTop) {
        HashMap<String, HashSet<String>> targs = new HashMap<String, HashSet<String>>();
        Iterator ilit = links.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            Linkage link = genome.getLinkage(linkID);
            String ltrg = link.getTarget();
            HashSet<String> linksForTarg = (HashSet<String>)targs.get(ltrg);
            if (linksForTarg == null) {
                linksForTarg = new HashSet<String>();
                targs.put(ltrg, linksForTarg);
            }
            linksForTarg.add(linkID);
        }
        Iterator trit = targs.keySet().iterator();
        while (trit.hasNext()) {
            String ltrg = (String)trit.next();
            HashSet linksForTarg = (HashSet)targs.get(ltrg);
            if (fanNodes.contains(ltrg)) {
                this.inboundLandingForGrid(ltrg, fanGrid, linksForTarg, genome, sourceOrder, padChanges, forceTop);
                continue;
            }
            System.err.println("Where is " + ltrg);
        }
    }

    private void inboundLandingForGrid(String targID, TrackedGrid grid, Set linksToTarg, Genome genome, List sourceOrder, Map padChanges, boolean forceTop) {
        if (!grid.contains(targID)) {
            return;
        }
        GridLinkRouter checker = new GridLinkRouter(grid, this);
        boolean isFirst = grid.firstOnLeft(targID, null);
        HashSet usedPads = (HashSet)this.padMap_.get(targID);
        if (usedPads == null) {
            usedPads = new HashSet();
            this.padMap_.put(targID, usedPads);
        }
        HashSet<String> srcSet = new HashSet<String>();
        Iterator ltit = linksToTarg.iterator();
        while (ltit.hasNext()) {
            String linkID = (String)ltit.next();
            Linkage link = genome.getLinkage(linkID);
            String lsrc = link.getSource();
            srcSet.add(lsrc);
        }
        if (sourceOrder == null) {
            GenomeItemInstance.DBAndInstanceConsistentComparator cc = new GenomeItemInstance.DBAndInstanceConsistentComparator();
            TreeSet<String> bogusSource = new TreeSet<String>(cc);
            bogusSource.addAll(srcSet);
            sourceOrder = new ArrayList(bogusSource);
        }
        int numSrc = sourceOrder.size();
        for (int i = 0; i < numSrc; ++i) {
            String srcID = (String)sourceOrder.get(i);
            if (!srcSet.contains(srcID)) continue;
            ltit = linksToTarg.iterator();
            while (ltit.hasNext()) {
                int landing;
                String linkID = (String)ltit.next();
                Linkage link = genome.getLinkage(linkID);
                String lsrc = link.getSource();
                if (!lsrc.equals(srcID)) continue;
                if (isFirst) {
                    landing = checker.landForThisGrid(targID, genome, usedPads, 0, true, forceTop);
                    isFirst = false;
                } else {
                    landing = checker.landForThisGrid(targID, genome, usedPads, 3, false, false);
                }
                int launch = this.getCurrentLaunchPad(link, padChanges);
                this.doPadChange(linkID, padChanges, launch, landing);
            }
        }
    }

    private int launchForSimpleGrid(String nodeID, Genome genome) {
        int type = genome.getNode(nodeID).getNodeType();
        if (type == 3) {
            return 2;
        }
        return 0;
    }

    private int landForSimpleGrid(String nodeID, Genome genome) {
        int type = genome.getNode(nodeID).getNodeType();
        if (type == 3) {
            return 3;
        }
        if (type == 6) {
            return 1;
        }
        return 0;
    }

    private int landForSimpleGridFromOutside(String nodeID, Genome genome, boolean highest) {
        int type = genome.getNode(nodeID).getNodeType();
        if (type == 3) {
            return highest ? 0 : 3;
        }
        if (type == 6) {
            return 1;
        }
        return 0;
    }

    private int nodeFanMembership(String nodeID) {
        if (nodeID.equals(this.coreID_)) {
            return 0;
        }
        if (this.fanInNodes_.contains(nodeID)) {
            return 1;
        }
        if (this.fanOutNodes_.contains(nodeID)) {
            return 2;
        }
        throw new IllegalStateException();
    }

    private int getInternalLinkType(int srcMember, int trgMember) {
        int linkType = -1;
        if (srcMember == 0) {
            if (trgMember == 0) {
                linkType = 0;
            } else if (trgMember == 1) {
                linkType = 1;
            } else if (trgMember == 2) {
                linkType = 2;
            }
        } else if (srcMember == 1) {
            if (trgMember == 0) {
                linkType = 4;
            } else if (trgMember == 1) {
                linkType = 3;
            } else if (trgMember == 2) {
                linkType = 5;
            }
        } else if (srcMember == 2) {
            if (trgMember == 0) {
                linkType = 6;
            } else if (trgMember == 1) {
                linkType = 7;
            } else if (trgMember == 2) {
                linkType = 8;
            }
        }
        if (linkType == -1) {
            throw new IllegalStateException();
        }
        return linkType;
    }

    private int getInboundLinkType(int trgMember) {
        int linkType = -1;
        if (trgMember == 0) {
            linkType = 10;
        } else if (trgMember == 1) {
            linkType = 9;
        } else if (trgMember == 2) {
            linkType = 11;
        }
        if (linkType == -1) {
            throw new IllegalStateException();
        }
        return linkType;
    }

    private void simpleFanInInboundLinkRouting(List linksPerClust, String srcID, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, SpecialtyLayoutLinkData sin, MetaClusterPointSource lps, boolean linkFromTop, boolean topGASC) {
        if (this.fanInType_ == 2) {
            throw new IllegalStateException();
        }
        TreeMap<Double, ArrayList<String>> sortByCoord = new TreeMap<Double, ArrayList<String>>();
        HashMap<String, List> holdDrops = new HashMap<String, List>();
        boolean useXCoord = lps.busFeedIsHorizontal() || this.fanInType_ == 0;
        double sortSign = !linkFromTop && !useXCoord ? -1.0 : 1.0;
        Set linksToCore = this.linksToCore(genome);
        int numlpc = linksPerClust.size();
        for (int j = 0; j < numlpc; ++j) {
            List dropPts;
            String linkID = (String)linksPerClust.get(j);
            if (linksToCore.contains(linkID)) {
                dropPts = this.directLinkDropPoints(linkID, genome, padChanges, lps, lo, frc, placement);
            } else {
                if (this.linkToFanOut(linkID, genome)) continue;
                dropPts = this.doLinkToDropPoints(linkID, genome, padChanges, lps, lo, frc, placement);
            }
            Point2D firstPt = (Point2D)dropPts.get(0);
            double firstCoord = useXCoord ? firstPt.getX() : firstPt.getY();
            Double firstCoordKey = new Double(sortSign * firstCoord);
            ArrayList<String> linksPerCoord = (ArrayList<String>)sortByCoord.get(firstCoordKey);
            if (linksPerCoord == null) {
                linksPerCoord = new ArrayList<String>();
                sortByCoord.put(firstCoordKey, linksPerCoord);
            }
            linksPerCoord.add(linkID);
            holdDrops.put(linkID, dropPts);
        }
        boolean fanOutDone = false;
        if (linkFromTop) {
            this.fanOutInboundLinkRouting(srcID, genome, lo, frc, placement, padChanges, sin, lps, topGASC);
            fanOutDone = true;
        }
        this.simpleFanInFinalLinkRoutingLinkCreation(sin, lps, sortByCoord, holdDrops, srcID, placement, padChanges, genome, lo, frc, this.fanInType_ == 0);
        if (!fanOutDone) {
            this.fanOutInboundLinkRouting(srcID, genome, lo, frc, placement, padChanges, sin, lps, topGASC);
        }
        lps.closeOutCluster();
    }

    public boolean hasFanOut() {
        return !this.fanOutNodes_.isEmpty();
    }

    private void complexFanInInboundLinkRouting(String srcID, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, SpecialtyLayoutLinkData sin, MetaClusterPointSource lps, boolean closeOut) {
        List links;
        SpecialtyLayoutLinkData converted;
        if (this.fanInType_ != 2) {
            throw new IllegalStateException();
        }
        boolean entryFromTop = this.ddo_ == null ? true : this.ddo_.comingFromTop(srcID, this);
        boolean isDeferred = lps.isForDeferredOnly();
        List perClust = isDeferred ? lps.initInboundsPerSrcForDeferred(this.coreID_, srcID) : null;
        Point2D upperLeftFanInPt = this.getClusterDims(genome, lo, frc).getFanInCorner(placement);
        SpecialtyLayoutLinkData dummySin = new SpecialtyLayoutLinkData(srcID);
        String dummyLink = "dummyLink";
        dummySin.startNewLink(dummyLink);
        SpecialtyLayoutLinkData.TrackPos gluePos = null;
        double fixedX = 0.0;
        SpecialtyLayoutLinkData.TrackPos finalForClust = null;
        if (lps.getType() == 0) {
            converted = this.fanInGlr_.convertInboundLinks(srcID, this.inboundLinkPlans_, upperLeftFanInPt, placement, padChanges, genome, lo, frc, this.coreID_);
            if (converted == null) {
                return;
            }
            links = converted.getLinkList();
            String linkID = (String)links.get(0);
            List convertedDrops = converted.getPositionList(linkID);
            finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
            Point2D finalPt = finalForClust.getPoint();
            if (!isDeferred) {
                lps.fanBlockBuildPrePath(dummySin, dummyLink, finalPt, placement, padChanges, genome, lo, frc);
            }
            Point2D interfacePt = lps.getComplexInterfacePoint();
            Point2D.Double gluePt = new Point2D.Double(finalPt.getX(), interfacePt.getY());
            gluePos = new SpecialtyLayoutLinkData.TrackPos(gluePt);
            if (!isDeferred) {
                dummySin.addPositionToLink(dummyLink, gluePos);
            }
        } else {
            fixedX = lps.getVerticalDropX(placement, padChanges, genome, lo, frc);
            converted = this.fanInGlr_.convertAndFixInboundLinks(srcID, this.inboundLinkPlans_, upperLeftFanInPt, placement, padChanges, genome, lo, frc, this.coreID_, fixedX);
            if (converted == null || converted.getLinkList().size() == 0) {
                return;
            }
            links = converted.getLinkList();
            Set canChopLinks = this.canChop(genome, links, srcID);
            if (!canChopLinks.isEmpty()) {
                Iterator lit = links.iterator();
                boolean first = true;
                while (lit.hasNext()) {
                    int numPts;
                    String linkID = (String)lit.next();
                    if (!canChopLinks.contains(linkID)) continue;
                    List convertedDrops = converted.getPositionList(linkID);
                    if (first) {
                        first = false;
                        numPts = convertedDrops.size();
                        for (int j = 0; j < numPts - 1; ++j) {
                            convertedDrops.remove(0);
                        }
                        finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
                        continue;
                    }
                    numPts = convertedDrops.size();
                    if (numPts == 2) continue;
                    throw new IllegalStateException();
                }
            }
            if (lps.needsTraceYUpdate()) {
                String linkID = (String)links.get(0);
                List convertedDrops = converted.getPositionList(linkID);
                finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
                if (!isDeferred) {
                    lps.setTargetTraceY(finalForClust.getPoint().getY());
                }
            }
            if (!isDeferred) {
                lps.fanBlockBuildPrePath(dummySin, dummyLink, new Point2D.Double(fixedX, 0.0), placement, padChanges, genome, lo, frc);
            }
        }
        links = converted.getLinkList();
        Point2D furthestNewDrop = null;
        Point2D rightmostTopDrop = null;
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            Point2D nextPtForLink;
            SpecialtyLayoutLinkData.TrackPos nextForLink;
            int j;
            int numPts;
            String linkID = (String)links.get(i);
            InboundCorners ic = null;
            if (isDeferred) {
                ic = new InboundCorners(linkID);
                perClust.add(ic);
            } else if (!sin.haveLink(linkID)) {
                sin.startNewLink(linkID);
            }
            List convertedDrops = converted.getPositionList(linkID);
            if (i == 0) {
                if (isDeferred) {
                    ic.needDrop = true;
                    ic.dropY = finalForClust.getPoint().getY();
                    ic.finalPath.addAll(convertedDrops);
                } else {
                    sin.addPositionListToLink(linkID, dummySin.getPositionList(dummyLink));
                    sin.addPositionListToLink(linkID, convertedDrops);
                }
                numPts = convertedDrops.size();
                for (j = 0; j < numPts; ++j) {
                    nextForLink = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(j);
                    nextPtForLink = nextForLink.getPoint();
                    if (rightmostTopDrop == null) {
                        rightmostTopDrop = (Point2D)nextPtForLink.clone();
                        continue;
                    }
                    if (nextPtForLink.getY() != rightmostTopDrop.getY() || !(nextPtForLink.getX() > rightmostTopDrop.getX())) continue;
                    rightmostTopDrop = (Point2D)nextPtForLink.clone();
                }
                finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
                if (finalForClust.getPoint().getX() == fixedX) {
                    furthestNewDrop = (Point2D)finalForClust.getPoint().clone();
                }
                if (!closeOut) continue;
                lps.closeOutComplexCluster(gluePos);
                continue;
            }
            if (isDeferred) {
                ic.finalPath.addAll(convertedDrops);
                finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
                if (finalForClust.getPoint().getX() == fixedX && !this.isStacked_) {
                    ic.needDrop = true;
                    if (convertedDrops.size() > 1) {
                        finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(1);
                        ic.finalPath.remove(0);
                    }
                    ic.dropY = finalForClust.getPoint().getY();
                } else {
                    ic.needDrop = false;
                    ic.prevPoint = null;
                }
            } else {
                sin.addPositionListToLink(linkID, convertedDrops);
            }
            numPts = convertedDrops.size();
            for (j = 0; j < numPts; ++j) {
                nextForLink = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(j);
                nextPtForLink = nextForLink.getPoint();
                if (furthestNewDrop != null) {
                    boolean replaceY;
                    double yDiff = nextPtForLink.getY() - furthestNewDrop.getY();
                    boolean bl = entryFromTop ? yDiff > 0.0 : (replaceY = yDiff < 0.0);
                    if (nextPtForLink.getX() == furthestNewDrop.getX() && replaceY) {
                        furthestNewDrop = (Point2D)nextPtForLink.clone();
                    }
                }
                if (nextPtForLink.getY() != rightmostTopDrop.getY() || !(nextPtForLink.getX() > rightmostTopDrop.getX())) continue;
                rightmostTopDrop = (Point2D)nextPtForLink.clone();
            }
        }
        if (lps.getType() != 0) {
            if (furthestNewDrop != null) {
                lps.updateDropPoint(furthestNewDrop);
            }
            if (rightmostTopDrop != null) {
                lps.updateRightmostDropPoint(rightmostTopDrop);
            }
        }
    }

    private Set canChop(Genome genome, List links, String onlyForSrcID) {
        HashSet retval = new HashSet();
        if (this.fanInType_ != 2) {
            return retval;
        }
        if (this.isStacked_) {
            HashMap<String, String> maybeRetval = new HashMap<String, String>();
            HashSet<String> seenSrcs = new HashSet<String>();
            int numLinks = links.size();
            for (int i = 0; i < numLinks; ++i) {
                String linkID = (String)links.get(i);
                Linkage link = genome.getLinkage(linkID);
                String target = link.getTarget();
                String src = link.getSource();
                if (onlyForSrcID != null && !src.equals(onlyForSrcID)) continue;
                if (seenSrcs.contains(src)) {
                    if (maybeRetval.get(src) == null) continue;
                    maybeRetval.remove(src);
                    continue;
                }
                seenSrcs.add(src);
                if (target.equals(this.coreID_)) {
                    maybeRetval.put(src, linkID);
                    continue;
                }
                if (!this.fanInNodes_.contains(target) || this.fanInTrackedGrid_.getNumRows() != 1) continue;
                Grid.RowAndColumn grac = this.fanInTrackedGrid_.findPositionRandC(target);
                if (grac.row != 0) {
                    throw new IllegalStateException();
                }
                maybeRetval.put(src, linkID);
            }
            retval.addAll(maybeRetval.values());
        }
        return retval;
    }

    private Map fanOutConvertCoreJumpers(Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges) {
        HashMap<String, SpecialtyLayoutLinkData> retval = new HashMap<String, SpecialtyLayoutLinkData>();
        if (this.coreJumpers_ == null) {
            return retval;
        }
        Iterator cjsit = this.coreJumpers_.keySet().iterator();
        while (cjsit.hasNext()) {
            String srcID = (String)cjsit.next();
            SpecialtyLayoutLinkData sin = new SpecialtyLayoutLinkData(srcID);
            this.fanOutConvertAJumper(srcID, genome, lo, frc, placement, padChanges, sin);
            retval.put(srcID, sin);
        }
        return retval;
    }

    private void fanOutConvertAJumper(String srcID, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, SpecialtyLayoutLinkData sin) {
        Point2D upperLeftFanOutPt = this.getClusterDims(genome, lo, frc).getFanOutCorner(placement, false);
        if (upperLeftFanOutPt == null) {
            return;
        }
        Point2D upperLeftFanInPt = this.getClusterDims(genome, lo, frc).getFanInCorner(placement);
        SpecialtyLayoutLinkData converted = this.fanInGlr_.convertInboundLinks(srcID, this.fanOutInboundLinkPlans_, upperLeftFanInPt, placement, padChanges, genome, lo, frc, this.coreID_);
        if (converted == null || converted.getLinkList().isEmpty()) {
            return;
        }
        HashMap<String, SpecialtyLayoutLinkData> hackMap = new HashMap<String, SpecialtyLayoutLinkData>();
        hackMap.put(srcID, converted);
        Point2D lastConvert = this.fanInGlr_.getLastConvertedPoint(converted);
        double lastConvertY = lastConvert == null ? upperLeftFanOutPt.getY() : lastConvert.getY();
        converted = this.fanOutGlr_.convertAndFixInboundLinks(srcID, hackMap, upperLeftFanOutPt, placement, padChanges, genome, lo, frc, this.coreID_, lastConvertY);
        if (converted == null || converted.getLinkList().isEmpty()) {
            return;
        }
        List links = converted.getLinkList();
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            String linkID = (String)links.get(i);
            if (!sin.haveLink(linkID)) {
                sin.startNewLink(linkID);
            }
            List convertedDrops = converted.getPositionList(linkID);
            sin.addPositionListToLink(linkID, convertedDrops);
        }
    }

    private void fanOutInboundLinkRouting(String srcID, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, SpecialtyLayoutLinkData sin, MetaClusterPointSource lps, boolean topGASC) {
        double yOverCore;
        Map inbound;
        if (this.fanOutGlr_ == null) {
            return;
        }
        boolean isDeferred = lps.isForDeferredOnly();
        List perClust = isDeferred ? lps.initInboundsPerSrcForDeferred(this.coreID_, srcID) : null;
        Point2D upperLeftFanOutPt = this.getClusterDims(genome, lo, frc).getFanOutCorner(placement, false);
        if (upperLeftFanOutPt == null) {
            return;
        }
        SpecialtyLayoutLinkData converted = this.fanOutGlr_.convertInboundLinks(srcID, this.fanOutInboundLinkPlans_, upperLeftFanOutPt, placement, padChanges, genome, lo, frc, this.coreID_);
        if (converted == null || converted.getLinkList().isEmpty()) {
            return;
        }
        List links = converted.getLinkList();
        String firstLinkID = (String)links.get(0);
        List convertedDrops = converted.getPositionList(firstLinkID);
        SpecialtyLayoutLinkData.TrackPos finalForClust = (SpecialtyLayoutLinkData.TrackPos)convertedDrops.get(0);
        double yAtFanOut = finalForClust.getPoint().getY();
        if (topGASC && lps.hasInboundTraces()) {
            boolean isBaseAtTop;
            inbound = lps.getInboundTraces();
            boolean bl = isBaseAtTop = this.ddo_ == null ? true : this.ddo_.isBaseAtTop();
            if (!isBaseAtTop) {
                inbound = DataUtil.negateMapToIntegers(inbound);
            }
        } else {
            inbound = this.getInboundSourceOrder(genome, padChanges);
        }
        if (this.isStacked_) {
            yOverCore = yAtFanOut;
        } else {
            yOverCore = this.inboundTraceY(srcID, true, inbound, placement, genome, lo, frc);
            if (lps.needsTraceYUpdate()) {
                lps.setTargetTraceY(yOverCore);
            }
        }
        if (this.isStacked_) {
            yOverCore = yAtFanOut;
        }
        SpecialtyLayoutLinkData dummySin = new SpecialtyLayoutLinkData(srcID);
        String dummyLink = "dummyLink";
        dummySin.startNewLink(dummyLink);
        Point2D hopOverPt = null;
        SpecialtyLayoutLinkData.TrackPos hopOver = null;
        if (yOverCore != yAtFanOut) {
            hopOverPt = new Point2D.Double(finalForClust.getPoint().getX(), yOverCore);
            hopOver = new SpecialtyLayoutLinkData.TrackPos(hopOverPt);
        } else {
            hopOverPt = finalForClust.getPoint();
        }
        InboundCorners preCalcIc = null;
        if (!isDeferred) {
            lps.fanBlockBuildPrePath(dummySin, dummyLink, hopOverPt, placement, padChanges, genome, lo, frc);
        } else {
            preCalcIc = new InboundCorners(firstLinkID);
            preCalcIc.needDrop = true;
            preCalcIc.dropY = yOverCore;
            preCalcIc.prevPoint = null;
            if (hopOver != null) {
                preCalcIc.finalPath.add(hopOver);
            }
        }
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            String linkID = (String)links.get(i);
            InboundCorners ic = null;
            if (isDeferred) {
                ic = new InboundCorners(linkID);
                perClust.add(ic);
            } else if (!sin.haveLink(linkID)) {
                sin.startNewLink(linkID);
            }
            convertedDrops = converted.getPositionList(linkID);
            if (i == 0) {
                if (isDeferred) {
                    ic.needDrop = preCalcIc.needDrop;
                    ic.dropY = preCalcIc.dropY;
                    ic.prevPoint = preCalcIc.prevPoint;
                    ic.finalPath.addAll(preCalcIc.finalPath);
                    ic.finalPath.addAll(convertedDrops);
                } else {
                    sin.addPositionListToLink(linkID, dummySin.getPositionList(dummyLink));
                    if (hopOver != null) {
                        sin.addPositionToLink(linkID, hopOver);
                    }
                    sin.addPositionListToLink(linkID, convertedDrops);
                }
                lps.closeOutComplexCluster(finalForClust);
                continue;
            }
            if (isDeferred) {
                ic.needDrop = false;
                ic.prevPoint = null;
                ic.finalPath.addAll(convertedDrops);
                continue;
            }
            sin.addPositionListToLink(linkID, convertedDrops);
        }
    }

    private void multiInputCorePadOrdering(Genome genome, Map existing) {
        Gene gene;
        Node node = genome.getNode(this.coreID_);
        if (node.getNodeType() == 4 && (gene = (Gene)node).getNumRegions() != 0) {
            return;
        }
        TreeSet<String> orderThem = new TreeSet<String>(new MultiPadOrdering(genome));
        HashMap<String, String> firstForSrc = new HashMap<String, String>();
        HashSet<String> processing = new HashSet<String>();
        Set coreLinks = this.linksToCore(genome);
        Iterator tsit = coreLinks.iterator();
        while (tsit.hasNext()) {
            String linkID = (String)tsit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            if (processing.contains(src)) {
                orderThem.add(linkID);
                continue;
            }
            if (firstForSrc.containsKey(src)) {
                String prev = (String)firstForSrc.get(src);
                orderThem.add(prev);
                orderThem.add(linkID);
                processing.add(src);
                continue;
            }
            firstForSrc.put(src, linkID);
        }
        int count = 0;
        Iterator otit = orderThem.iterator();
        while (otit.hasNext()) {
            String linkID = (String)otit.next();
            existing.put(linkID, new Integer(count++));
        }
    }

    private int calcPadChangesForCore(GenomeSubset subset, List traceOrder, Map padChanges) {
        Genome baseGenome = subset.getBaseGenome();
        int currPad = 5;
        Iterator feedIt = this.feedbacks_.iterator();
        while (feedIt.hasNext()) {
            int landing;
            String linkID = (String)feedIt.next();
            Linkage feedLink = baseGenome.getLinkage(linkID);
            int launch = this.getCurrentLaunchPad(feedLink, padChanges);
            --currPad;
            this.doPadChange(linkID, padChanges, launch, landing);
        }
        if (this.fanInType_ == 1) {
            HashMap pendingForCore = new HashMap();
            currPad = this.simpleFanInPadChangesForFan(subset, traceOrder, padChanges, pendingForCore, currPad);
            Iterator pit = pendingForCore.keySet().iterator();
            while (pit.hasNext()) {
                String linkID = (String)pit.next();
                Integer pad = (Integer)pendingForCore.get(linkID);
                Linkage link = baseGenome.getLinkage(linkID);
                int launch = this.getCurrentLaunchPad(link, padChanges);
                int landing = pad;
                this.doPadChange(linkID, padChanges, launch, landing);
            }
        }
        int remainingLinks = 0;
        TreeMap<Integer, String> traceToSrc = new TreeMap<Integer, String>();
        HashMap srcToLinks = new HashMap();
        int numTrace = traceOrder.size();
        for (int i = 0; i < numTrace; ++i) {
            String toSrc = (String)traceOrder.get(i);
            traceToSrc.put(new Integer(i), toSrc);
            ArrayList links = new ArrayList();
            srcToLinks.put(toSrc, links);
        }
        Iterator ibit = this.inboundLinks_.iterator();
        while (ibit.hasNext()) {
            String src;
            ArrayList links;
            String linkID = (String)ibit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String trg = link.getTarget();
            if (!trg.equals(this.coreID_) || (links = (ArrayList)srcToLinks.get(src = link.getSource())) == null) continue;
            links.add(linkID);
            ++remainingLinks;
        }
        if (!this.fanInNodes_.isEmpty() && this.fanInType_ == 2) {
            Iterator ltpit = this.internalLinks_.iterator();
            while (ltpit.hasNext()) {
                String linkID = (String)ltpit.next();
                Linkage link = baseGenome.getLinkage(linkID);
                String lsrc = link.getSource();
                String ltrg = link.getTarget();
                if (!this.fanInNodes_.contains(lsrc) || !ltrg.equals(this.coreID_)) continue;
                ++remainingLinks;
            }
        }
        if (this.fanInType_ != 1 && currPad > remainingLinks) {
            currPad = remainingLinks;
        }
        Iterator tsit = traceToSrc.keySet().iterator();
        while (tsit.hasNext()) {
            Integer tNum = (Integer)tsit.next();
            String srcID = (String)traceToSrc.get(tNum);
            List links = (List)srcToLinks.get(srcID);
            int numLink = links.size();
            if (numLink > 1) {
                TreeSet orderThem = new TreeSet(new MultiPadOrdering(baseGenome));
                orderThem.addAll(links);
                links.clear();
                links.addAll(orderThem);
                Collections.reverse(links);
            }
            for (int i = 0; i < numLink; ++i) {
                int landing;
                String linkID = (String)links.get(i);
                Linkage link = baseGenome.getLinkage(linkID);
                int launch = this.getCurrentLaunchPad(link, padChanges);
                --currPad;
                this.doPadChange(linkID, padChanges, launch, landing);
            }
        }
        if (!this.fanInNodes_.isEmpty() && this.fanInType_ == 2) {
            currPad = this.changeFanToCorePads(this.fanInNodes_, baseGenome, padChanges, currPad, this.fanInPadPlans_, false);
        }
        return currPad;
    }

    private int simpleFanInPadChangesForFan(GenomeSubset subset, List traceOrder, Map padChanges, Map pendingForCore, int startPad) {
        int retval;
        if (this.fanInType_ != 1) {
            throw new IllegalStateException();
        }
        Genome baseGenome = subset.getBaseGenome();
        if (pendingForCore != null) {
            Iterator pit = this.penOrder_.keySet().iterator();
            int currPad = startPad;
            while (pit.hasNext()) {
                Integer order = (Integer)pit.next();
                String penID = (String)this.penOrder_.get(order);
                currPad = this.penIDToPadnum(baseGenome, penID);
                Set allLinks = (Set)this.toCoreFromPen_.get(penID);
                Iterator alit = allLinks.iterator();
                while (alit.hasNext()) {
                    String linkID = (String)alit.next();
                    pendingForCore.put(linkID, new Integer(currPad--));
                }
            }
            retval = currPad;
        } else {
            retval = startPad;
        }
        Set penKeys = this.penultimate_.keySet();
        int numTrace = traceOrder.size();
        HashMap<String, String> highestPerPen = new HashMap<String, String>();
        Iterator penkit = this.penultimate_.keySet().iterator();
        while (penkit.hasNext()) {
            String penID = (String)penkit.next();
            Set pensrcs = (Set)this.penultimate_.get(penID);
            String maxSrc = null;
            Iterator sit = pensrcs.iterator();
            while (sit.hasNext()) {
                String srcID = (String)sit.next();
                for (int i = 0; i < numTrace; ++i) {
                    String toSrc = (String)traceOrder.get(i);
                    if (!toSrc.equals(srcID)) continue;
                    maxSrc = toSrc;
                }
            }
            if (maxSrc == null) continue;
            highestPerPen.put(penID, maxSrc);
        }
        Iterator lit = subset.getLinkageSuperSetIterator();
        while (lit.hasNext()) {
            int launch;
            String linkID = (String)lit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String lsource = link.getSource();
            String ltarg = link.getTarget();
            if (penKeys.contains(lsource)) {
                launch = this.launchForSimpleGrid(lsource, baseGenome);
                if (ltarg.equals(this.coreID_)) {
                    int landing = this.getCurrentLandingPad(link, padChanges, false);
                    this.doPadChange(linkID, padChanges, launch, landing);
                    continue;
                }
                if (!penKeys.contains(ltarg)) continue;
                int landing = this.landForSimpleGrid(ltarg, baseGenome);
                this.doPadChange(linkID, padChanges, launch, landing);
                continue;
            }
            if (!penKeys.contains(ltarg)) continue;
            launch = this.getCurrentLaunchPad(link, padChanges);
            String highSrc = (String)highestPerPen.get(ltarg);
            boolean isHighest = highSrc.equals(lsource);
            int landing = this.landForSimpleGridFromOutside(ltarg, baseGenome, isHighest);
            this.doPadChange(linkID, padChanges, launch, landing);
        }
        return retval;
    }

    private Set getAllLinksForNodePair(Genome genome, String srcID, String trgID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String lsource = link.getSource();
            String ltrg = link.getTarget();
            if (!lsource.equals(srcID) || !ltrg.equals(trgID)) continue;
            retval.add(link.getID());
        }
        return retval;
    }

    private void calcPadChangesForNonGeneCore(GenomeSubset subset, TrackedGrid grid, List sourceOrder, Map padChanges) {
        int launch;
        Genome baseGenome = subset.getBaseGenome();
        ArrayList<Linkage> linksToOrder = new ArrayList<Linkage>();
        ArrayList<Linkage> feedbacks = new ArrayList<Linkage>();
        Iterator lit = subset.getLinkageSuperSetIterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String lsource = link.getSource();
            String ltrg = link.getTarget();
            if (!ltrg.equals(this.coreID_)) continue;
            if (lsource.equals(this.coreID_)) {
                feedbacks.add(link);
                continue;
            }
            linksToOrder.add(link);
        }
        HashSet<Integer> usedPads = (HashSet<Integer>)this.padMap_.get(this.coreID_);
        if (usedPads == null) {
            usedPads = new HashSet<Integer>();
            this.padMap_.put(this.coreID_, usedPads);
        }
        int numLinks = linksToOrder.size();
        int numS = sourceOrder.size();
        int currLanding = Integer.MAX_VALUE;
        for (int i = 0; i < numS; ++i) {
            String srcID = (String)sourceOrder.get(i);
            for (int j = 0; j < numLinks; ++j) {
                Linkage link = (Linkage)linksToOrder.get(j);
                String lsource = link.getSource();
                if (!lsource.equals(srcID)) continue;
                currLanding = GridLinkRouter.landForAGrid(null, this.coreID_, baseGenome, usedPads, 3, false, false);
                launch = this.getCurrentLaunchPad(link, padChanges);
                this.doPadChange(link.getID(), padChanges, launch, currLanding);
            }
        }
        if (this.fanInType_ == 1) {
            HashMap pendingForCore = new HashMap();
            this.simpleFanInPadChangesForFan(subset, sourceOrder, padChanges, pendingForCore, 0);
            Iterator pit = pendingForCore.keySet().iterator();
            while (pit.hasNext()) {
                String linkID = (String)pit.next();
                Integer pad = (Integer)pendingForCore.get(linkID);
                Linkage link = baseGenome.getLinkage(linkID);
                launch = this.getCurrentLaunchPad(link, padChanges);
                int landing = pad;
                this.doPadChange(linkID, padChanges, launch, landing);
                usedPads.add(new Integer(landing));
            }
        }
        ArrayList revFeed = new ArrayList(this.feedbacks_);
        int fSize = revFeed.size();
        for (int i = fSize - 1; i >= 0; --i) {
            String linkID = (String)revFeed.get(i);
            Linkage feedLink = baseGenome.getLinkage(linkID);
            int landing = GridLinkRouter.landForAGrid(null, this.coreID_, baseGenome, usedPads, 3, false, false);
            int launch2 = this.getCurrentLaunchPad(feedLink, padChanges);
            this.doPadChange(linkID, padChanges, launch2, landing);
        }
    }

    private double inboundTraceY(String srcID, boolean toFanout, Map inboundOrder, Map placement, Genome genome, Layout lo, FontRenderContext frc) {
        Set multiSrc;
        Point2D targLoc = (Point2D)placement.get(this.coreID_);
        if (targLoc == null) {
            throw new IllegalStateException();
        }
        ClusterDims oh = this.getClusterDims(genome, lo, frc);
        double dropY = targLoc.getY() - oh.offsetToGascPlacement;
        if (this.needsHorizontalTracesToFanInOrCore(genome)) {
            int gottaHop = this.fanInGlr_ == null ? 0 : this.fanInGlr_.getTopReservations();
            dropY -= 10.0 * (double)(gottaHop + 1);
        }
        if (!toFanout && this.isStacked_ && this.fanOutNodes_.isEmpty() && this.fanInNodes_.isEmpty() && (multiSrc = this.multiSrcsToCore(genome)).contains(srcID)) {
            GenomeItemInstance.DBAndInstanceConsistentComparator cc = new GenomeItemInstance.DBAndInstanceConsistentComparator();
            TreeSet bogusSource = new TreeSet(cc);
            bogusSource.addAll(multiSrc);
            ArrayList sourceOrder = new ArrayList(bogusSource);
            int offset = sourceOrder.indexOf(srcID);
            return dropY + (double)offset * 10.0;
        }
        if (this.fanOutNodes_.isEmpty()) {
            Integer order = (Integer)inboundOrder.get(srcID);
            if (order == null) {
                throw new IllegalStateException();
            }
            dropY -= order.doubleValue() * this.traceOffset_;
            dropY = UiUtil.forceToGridValue(dropY, 10.0);
            return dropY;
        }
        Set srcsToCore = this.srcsToCore(genome);
        Set srcsToFanout = this.srcsToFanout(genome);
        Set srcsToFanin = this.srcsToFanin(genome);
        if (srcsToFanout.isEmpty()) {
            Integer order = (Integer)inboundOrder.get(srcID);
            if (order == null) {
                throw new IllegalStateException();
            }
            dropY -= order.doubleValue() * this.traceOffset_;
            dropY = UiUtil.forceToGridValue(dropY, 10.0);
            return dropY;
        }
        TreeMap<Integer, String> invMap = new TreeMap<Integer, String>();
        Iterator ioit = inboundOrder.keySet().iterator();
        while (ioit.hasNext()) {
            String chkSrc = (String)ioit.next();
            Integer chkOrder = (Integer)inboundOrder.get(chkSrc);
            invMap.put(chkOrder, chkSrc);
        }
        int finalTrace = 0;
        if (!toFanout) {
            if (this.needsHorizontalTracesToFanInOrCore(genome)) {
                int coreCount = 0;
                Iterator ivit = invMap.values().iterator();
                while (ivit.hasNext()) {
                    String chkSrc = (String)ivit.next();
                    if (chkSrc.equals(srcID)) {
                        finalTrace = coreCount;
                        break;
                    }
                    if (!srcsToCore.contains(chkSrc)) continue;
                    ++coreCount;
                }
            }
        } else if (this.needsHorizontalTracesToFanOut(genome)) {
            int coreCount = 0;
            if (this.fanInType_ != 2) {
                Iterator ivit = invMap.values().iterator();
                while (ivit.hasNext()) {
                    String chkSrc = (String)ivit.next();
                    if (srcsToCore.contains(chkSrc)) {
                        ++coreCount;
                        continue;
                    }
                    if (!srcsToFanin.contains(chkSrc)) continue;
                    ++coreCount;
                }
            } else {
                ++coreCount;
            }
            int fanCount = 0;
            Iterator ivit = invMap.values().iterator();
            while (ivit.hasNext()) {
                String chkSrc = (String)ivit.next();
                if (chkSrc.equals(srcID)) {
                    finalTrace = fanCount + coreCount;
                    break;
                }
                if (!srcsToFanout.contains(chkSrc)) continue;
                ++fanCount;
            }
        }
        dropY -= (double)finalTrace * this.traceOffset_;
        dropY = UiUtil.forceToGridValue(dropY, 10.0);
        return dropY;
    }

    private Map getInboundSourceOrder(Genome genome, Map padChanges) {
        HashSet<String> seenSrcs = new HashSet<String>();
        HashMap<String, Integer> normalized = new HashMap<String, Integer>();
        List linkOrder = this.getInboundLinkOrder(genome, padChanges);
        int numl = linkOrder.size();
        int count = 0;
        for (int i = 0; i < numl; ++i) {
            String linkID = (String)linkOrder.get(i);
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            if (seenSrcs.contains(srcID)) continue;
            seenSrcs.add(srcID);
            normalized.put(srcID, new Integer(count++));
        }
        return normalized;
    }

    private boolean canReachFromCore(String nodeID, Map groups, Set seenNodes) {
        NodeGrouper.GroupElement nodeInfo = (NodeGrouper.GroupElement)groups.get(nodeID);
        HashSet sources = nodeInfo.sources;
        Iterator sit = sources.iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            if (srcID.equals(this.coreID_)) {
                return true;
            }
            if (seenNodes.contains(srcID)) continue;
            seenNodes.add(srcID);
            nodeInfo = (NodeGrouper.GroupElement)groups.get(srcID);
            if (nodeInfo == null || !nodeInfo.group.equals(this.coreID_) || !this.canReachFromCore(srcID, groups, seenNodes)) continue;
            return true;
        }
        return false;
    }

    private Set fanOutDeadEnds(Set fanOuts, Map groups) {
        HashSet seenNodes;
        HashSet<String> noTargs = new HashSet<String>();
        HashSet<String> remainingFO = new HashSet<String>();
        Iterator foit = fanOuts.iterator();
        while (foit.hasNext()) {
            String nodeID = (String)foit.next();
            NodeGrouper.GroupElement nodeInfo = (NodeGrouper.GroupElement)groups.get(nodeID);
            int targSize = nodeInfo.targets.size();
            if (targSize == 0) {
                HashSet seenNodes2 = new HashSet();
                if (!this.canReachFromCore(nodeID, groups, seenNodes2)) {
                    noTargs.add(nodeID);
                    continue;
                }
                remainingFO.add(nodeID);
                continue;
            }
            if (targSize == 1) {
                String targID = (String)nodeInfo.targets.iterator().next();
                seenNodes = new HashSet();
                if (targID.equals(nodeID) && !this.canReachFromCore(nodeID, groups, seenNodes)) {
                    noTargs.add(nodeID);
                    continue;
                }
                remainingFO.add(nodeID);
                continue;
            }
            remainingFO.add(nodeID);
        }
        if (noTargs.isEmpty()) {
            return noTargs;
        }
        int lastNumNT = -1;
        int numNT = noTargs.size();
        while (numNT != lastNumNT) {
            Iterator lit = remainingFO.iterator();
            while (lit.hasNext()) {
                String nodeID = (String)lit.next();
                if (this.canReachFromCore(nodeID, groups, seenNodes = new HashSet())) continue;
                NodeGrouper.GroupElement nodeInfo = (NodeGrouper.GroupElement)groups.get(nodeID);
                HashSet testSet = new HashSet(nodeInfo.targets);
                testSet.remove(nodeID);
                testSet.remove(noTargs);
                if (!testSet.isEmpty()) continue;
                noTargs.add(nodeID);
            }
            lastNumNT = numNT;
            numNT = noTargs.size();
        }
        return noTargs;
    }

    private Set fanOutExclusiveTargets(Set fanIns, Set fanOuts, Map groups) {
        HashSet<String> shiftToFanOut = new HashSet<String>();
        int lastNumSTFO = -1;
        int numSTFO = shiftToFanOut.size();
        while (numSTFO != lastNumSTFO) {
            Iterator lit = fanIns.iterator();
            while (lit.hasNext()) {
                HashSet seenNodes;
                String nodeID = (String)lit.next();
                NodeGrouper.GroupElement nodeInfo = (NodeGrouper.GroupElement)groups.get(nodeID);
                if (nodeInfo.targets.size() == 0) continue;
                HashSet testSet = new HashSet(nodeInfo.targets);
                testSet.removeAll(fanOuts);
                testSet.removeAll(shiftToFanOut);
                testSet.remove(nodeID);
                if (testSet.isEmpty()) {
                    shiftToFanOut.add(nodeID);
                }
                if (!this.canReachFromCore(nodeID, groups, seenNodes = new HashSet())) continue;
                shiftToFanOut.add(nodeID);
            }
            lastNumSTFO = numSTFO;
            numSTFO = shiftToFanOut.size();
        }
        return shiftToFanOut;
    }

    private void simpleFeedbackRouting(SpecialtyLayoutLinkData sin, Map placement, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        Point2D srcLoc = (Point2D)placement.get(this.coreID_);
        Point2D rootPt = this.linkTreeRoot(genome, lo, frc, placement, padChanges);
        double upY = rootPt.getY() - 50.0;
        boolean isFirst = true;
        Point2D.Double lastPoint = null;
        Iterator psit = new GridLinkRouter(null, this).orderedByPads(this.feedbacks_, padChanges, genome, lo, frc, true);
        while (psit.hasNext()) {
            List perPad = (List)psit.next();
            int numPP = perPad.size();
            for (int i = 0; i < numPP; ++i) {
                Point2D.Double dropPoint;
                String linkID = (String)perPad.get(i);
                sin.startNewLink(linkID);
                if (isFirst) {
                    isFirst = false;
                    sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)rootPt.clone()));
                    Point2D.Double upPoint = new Point2D.Double(rootPt.getX(), upY);
                    sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(upPoint));
                } else {
                    sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(lastPoint));
                }
                Linkage feedLink = genome.getLinkage(linkID);
                int landing = this.getCurrentLandingPad(feedLink, padChanges, false);
                Vector2D padOff = this.landingPadToOffset(landing, genome, lo, frc, this.coreID_);
                Point2D padPt = padOff.add(srcLoc);
                lastPoint = dropPoint = new Point2D.Double(padPt.getX(), upY);
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(dropPoint));
            }
        }
    }

    private List getFanToCoreSourceOrder() {
        ArrayList<String> retval = new ArrayList<String>();
        int numSo = this.fanInTraceOrder_.size();
        for (int i = 0; i < numSo; ++i) {
            retval.add(((GridLinkRouter.RCRowCompare)this.fanInTraceOrder_.get(i)).getSrc());
        }
        return retval;
    }

    private int getFanToCorePad(Linkage link, int currPad, Map totalFromSources, Map origLinkOrdering) {
        String currLinkID;
        String lsource = link.getSource();
        String linkID = link.getID();
        TreeMap orderForSrc = (TreeMap)origLinkOrdering.get(lsource);
        Iterator vit = orderForSrc.values().iterator();
        int count = 0;
        while (vit.hasNext() && !(currLinkID = (String)vit.next()).equals(linkID)) {
            ++count;
        }
        if (this.fanInTraceOrder_ == null || this.fanInTraceOrder_.isEmpty()) {
            return currPad - count;
        }
        List ordered = this.getFanToCoreSourceOrder();
        int numo = ordered.size();
        for (int i = 0; i < numo; ++i) {
            String srcID = (String)ordered.get(i);
            Integer totFromSrc = (Integer)totalFromSources.get(srcID);
            int tfs = totFromSrc;
            if (srcID.equals(lsource)) {
                return currPad - tfs + count;
            }
            currPad -= tfs;
        }
        throw new IllegalArgumentException();
    }

    private static class MultiPadOrdering
    implements Comparator {
        private Genome genome_;

        public MultiPadOrdering(Genome genome) {
            this.genome_ = genome;
        }

        public int compare(Object a, Object b) {
            int signB;
            String srcB;
            String linkIDA = (String)a;
            String linkIDB = (String)b;
            Linkage linkA = this.genome_.getLinkage(linkIDA);
            Linkage linkB = this.genome_.getLinkage(linkIDB);
            String srcA = linkA.getSource();
            if (!srcA.equals(srcB = linkB.getSource())) {
                return srcA.compareTo(srcB);
            }
            int signA = linkA.getSign();
            if (signA != (signB = linkB.getSign())) {
                return signA - signB;
            }
            return linkIDA.compareTo(linkIDB);
        }
    }

    private static class FanOrdering
    implements Comparable {
        Grid.RowAndColumn rowCol;
        int padNum;

        FanOrdering(Grid.RowAndColumn rowCol, int padNum) {
            this.rowCol = rowCol;
            this.padNum = padNum;
        }

        public int hashCode() {
            return this.rowCol.col + this.rowCol.row + this.padNum;
        }

        public String toString() {
            return "FanInbound: " + this.rowCol + " " + this.padNum;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof FanOrdering)) {
                return false;
            }
            FanOrdering otherFI = (FanOrdering)other;
            return this.rowCol.col == otherFI.rowCol.col && this.rowCol.row == otherFI.rowCol.row && this.padNum == otherFI.padNum;
        }

        public int compareTo(Object o) {
            FanOrdering other = (FanOrdering)o;
            if (this.rowCol.col > other.rowCol.col) {
                return 1;
            }
            if (this.rowCol.col < other.rowCol.col) {
                return -1;
            }
            if (this.rowCol.row > other.rowCol.row) {
                return -1;
            }
            if (this.rowCol.row < other.rowCol.row) {
                return 1;
            }
            if (this.padNum > other.padNum) {
                return -1;
            }
            if (this.padNum < other.padNum) {
                return 1;
            }
            return 0;
        }
    }

    public class ClusterDims {
        public double height;
        public double offsetToFanInTop;
        public double offsetToFanOutTop;
        public double offsetToGascPlacement;
        public double launchToFanOutTop;
        public Vector2D gridLaunchPadOffset;
        public Vector2D upperLeftFanInOffset;
        private Vector2D fullOffset_;
        private Vector2D linkShiftOffset_;
        public double horizTraceAddition;
        public double width;

        public ClusterDims(double height, double offsetToFanInTop, double offsetToFanOutTop, double offsetToGascPlacement, double horizTraceAddition, Vector2D gridLaunchPadOffset, Vector2D upperLeftFanInOffset, Vector2D fullOffset, Vector2D linkShiftOffset, double launchToFanOutTop, double width) {
            this.height = height;
            this.offsetToFanInTop = offsetToFanInTop;
            this.offsetToFanOutTop = offsetToFanOutTop;
            this.offsetToGascPlacement = offsetToGascPlacement;
            this.gridLaunchPadOffset = gridLaunchPadOffset == null ? null : (Vector2D)gridLaunchPadOffset.clone();
            this.upperLeftFanInOffset = upperLeftFanInOffset == null ? null : (Vector2D)upperLeftFanInOffset.clone();
            this.horizTraceAddition = horizTraceAddition;
            this.launchToFanOutTop = launchToFanOutTop;
            this.width = width;
            this.fullOffset_ = fullOffset == null ? null : (Vector2D)fullOffset.clone();
            this.linkShiftOffset_ = linkShiftOffset == null ? null : (Vector2D)linkShiftOffset.clone();
        }

        public double getFullHeightIncrement() {
            return this.height + this.horizTraceAddition;
        }

        public Point2D getCoreLaunch(Map positions) {
            Point2D corePt = (Point2D)positions.get(GeneAndSatelliteCluster.this.coreID_);
            Point2D coreLaunchPt = this.gridLaunchPadOffset.add(corePt);
            return coreLaunchPt;
        }

        public Point2D getFanInCorner(Map positions) {
            Point2D corePt = (Point2D)positions.get(GeneAndSatelliteCluster.this.coreID_);
            Point2D upperLeftFanInPt = this.upperLeftFanInOffset.add(corePt);
            return upperLeftFanInPt;
        }

        public Point2D getFanOutCorner(Map positions, boolean withLinkShift) {
            Point2D srcPt = (Point2D)positions.get(GeneAndSatelliteCluster.this.coreID_);
            Point2D preRetval = this.fullOffset_.add(srcPt);
            Point2D retval = withLinkShift ? this.linkShiftOffset_.add(preRetval) : preRetval;
            return retval;
        }
    }

    public static class DropDirectionOracle {
        private Map isOnTop_;
        private Map srcToCol_;
        private boolean baseAtTop_;
        private Set allMySources_;
        private int myColumn_;
        private List stackOrder_;

        public DropDirectionOracle(Map isOnTop, Map srcToCol, boolean baseAtTop, List stackOrder, Set allMySources, int myColumn) {
            this.isOnTop_ = isOnTop;
            this.srcToCol_ = srcToCol;
            this.baseAtTop_ = baseAtTop;
            this.allMySources_ = allMySources;
            this.myColumn_ = myColumn;
            this.stackOrder_ = new ArrayList(stackOrder);
        }

        public boolean isBaseAtTop() {
            return this.baseAtTop_;
        }

        public boolean comingFromTop(String srcID, GeneAndSatelliteCluster targClust) {
            boolean isFeedback;
            if (this.allMySources_.contains(srcID)) {
                boolean seenTarg = false;
                int numOrd = this.stackOrder_.size();
                for (int i = 0; i < numOrd; ++i) {
                    GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
                    Iterator sit = sc.getAllSourceIterator();
                    while (sit.hasNext()) {
                        String srcIDCheck = (String)sit.next();
                        if (!srcIDCheck.equals(srcID)) continue;
                        return seenTarg ? true : !this.baseAtTop_;
                    }
                    seenTarg = targClust != null && sc == targClust;
                }
                throw new IllegalArgumentException();
            }
            Integer srcCol = (Integer)this.srcToCol_.get(srcID);
            if (srcCol == null) {
                return true;
            }
            boolean bl = isFeedback = srcCol > this.myColumn_;
            if (!isFeedback) {
                return this.baseAtTop_;
            }
            boolean srcOnTop = (Boolean)this.isOnTop_.get(srcID);
            return srcOnTop;
        }
    }

    public static class TagAnnotatedList
    extends ArrayList {
        public String tag;

        TagAnnotatedList(String tag) {
            this.tag = tag;
        }
    }

    public static class InboundCorners {
        public String linkID;
        public boolean needDrop;
        public double dropY;
        public SpecialtyLayoutLinkData.TrackPos prevPoint;
        public List finalPath;

        public InboundCorners(String linkID) {
            this.linkID = linkID;
            this.finalPath = new ArrayList();
        }
    }

    public static class LinkPlacementState {
        public boolean isRoot;
        public Point2D runPt;
        public Point2D lastAttach;
        public Point2D lastRun;
        public boolean isRunStart;
    }
}

