/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.UiUtil;

public class GenomeSubset {
    private String baseGenomeID_;
    private HashSet nodes_;
    private HashSet internalLinks_;
    private HashSet linksIn_;
    private HashSet linksOut_;
    public HashSet externalSourceOnly;
    public HashSet externalTargetOnly;
    public HashSet externalBothSrcTarget;
    private HashSet nodeSuperSet_;
    private HashSet linkSuperSet_;
    private boolean isComplete_;
    private Point2D center_;
    private GenomeSource src_;
    private Rectangle origNodeBounds_;
    private Rectangle origModuleBounds_;
    private String moduleID_;
    private String overlayID_;
    private String groupID_;

    public GenomeSubset(String genomeID, Set selectedNodes, Point2D center) {
        this.baseGenomeID_ = genomeID;
        this.nodes_ = new HashSet(selectedNodes);
        this.internalLinks_ = new HashSet();
        this.linksIn_ = new HashSet();
        this.linksOut_ = new HashSet();
        this.externalSourceOnly = new HashSet();
        this.externalTargetOnly = new HashSet();
        this.externalBothSrcTarget = new HashSet();
        this.nodeSuperSet_ = new HashSet();
        this.linkSuperSet_ = new HashSet();
        this.isComplete_ = false;
        this.origNodeBounds_ = null;
        this.origModuleBounds_ = null;
        this.groupID_ = null;
        this.center_ = center == null ? null : (Point2D)center.clone();
        this.calculate();
    }

    public GenomeSubset(String genomeID, Point2D center) {
        this(Database.getDB().getGenome(genomeID), center);
        this.baseGenomeID_ = genomeID;
    }

    public GenomeSubset(GenomeSource src, Point2D center) {
        this(src.getGenome(), center);
        this.src_ = src;
        this.baseGenomeID_ = null;
    }

    private GenomeSubset(Genome baseGenome, Point2D center) {
        this.nodes_ = new HashSet();
        Iterator nit = baseGenome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nodeID = node.getID();
            this.nodes_.add(nodeID);
        }
        this.internalLinks_ = new HashSet();
        Iterator lit = baseGenome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            this.internalLinks_.add(linkID);
        }
        this.linksIn_ = new HashSet();
        this.linksOut_ = new HashSet();
        this.externalSourceOnly = new HashSet();
        this.externalTargetOnly = new HashSet();
        this.externalBothSrcTarget = new HashSet();
        this.nodeSuperSet_ = new HashSet();
        this.linkSuperSet_ = new HashSet();
        this.nodeSuperSet_.addAll(this.nodes_);
        this.linkSuperSet_.addAll(this.internalLinks_);
        this.isComplete_ = true;
        this.center_ = (Point2D)center.clone();
    }

    public void setOrigBounds(Layout lo, FontRenderContext frc) {
        this.origNodeBounds_ = lo.getPartialBounds(this.getBaseGenome(), frc, this.nodes_, false, false, null, null, false);
        this.center_ = new Point2D.Double(this.origNodeBounds_.getCenterX(), this.origNodeBounds_.getCenterY());
        UiUtil.forceToGrid(this.center_, 10.0);
    }

    public void setOrigBounds(Rectangle bounds) {
        this.origNodeBounds_ = (Rectangle)bounds.clone();
        this.origModuleBounds_ = (Rectangle)bounds.clone();
        this.center_ = new Point2D.Double(this.origNodeBounds_.getCenterX(), this.origNodeBounds_.getCenterY());
        UiUtil.forceToGrid(this.center_, 10.0);
    }

    public void setGroupID(String groupID) {
        this.groupID_ = groupID;
    }

    public String getGroupID() {
        return this.groupID_;
    }

    public void setModuleID(String moduleID) {
        this.moduleID_ = moduleID;
    }

    public String getModuleID() {
        return this.moduleID_;
    }

    public void setOverlayID(String overlayID) {
        this.overlayID_ = overlayID;
    }

    public String getOverlayID() {
        return this.overlayID_;
    }

    public boolean isCompleteGenome() {
        return this.isComplete_;
    }

    public Point2D getPreferredCenter() {
        return this.center_;
    }

    public Rectangle getOrigBounds() {
        return this.origNodeBounds_;
    }

    public Rectangle getOrigModuleBounds() {
        return this.origModuleBounds_;
    }

    public Iterator getNodeIterator() {
        return this.nodes_.iterator();
    }

    public Iterator getLinkageIterator() {
        return this.internalLinks_.iterator();
    }

    public Iterator getLinksInIterator() {
        return this.linksIn_.iterator();
    }

    public Iterator getLinksOutIterator() {
        return this.linksOut_.iterator();
    }

    public boolean nodeInSubset(String nodeID) {
        return this.nodes_.contains(nodeID);
    }

    public Genome getBaseGenome() {
        if (this.src_ == null) {
            Database db = Database.getDB();
            Genome baseGenome = db.getGenome(this.baseGenomeID_);
            return baseGenome;
        }
        return this.src_.getGenome();
    }

    public Genome getPseudoGenome() {
        Genome base = this.getBaseGenome();
        Genome copy = base instanceof DBGenome ? (Genome)((DBGenome)base).clone() : (Genome)((GenomeInstance)base).clone();
        Iterator bit = base.getAllNodeIterator();
        while (bit.hasNext()) {
            Node nextNode = (Node)bit.next();
            if (this.nodes_.contains(nextNode.getID())) continue;
            copy.removeNode(nextNode.getID());
        }
        return copy;
    }

    public Iterator getLinkageSuperSetIterator() {
        return this.linkSuperSet_.iterator();
    }

    public Set getNodeTargets(String nodeID) {
        if (!this.nodeSuperSet_.contains(nodeID)) {
            throw new IllegalArgumentException();
        }
        Genome baseGenome = this.getBaseGenome();
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.linkSuperSet_.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage lnk = baseGenome.getLinkage(linkID);
            if (!lnk.getSource().equals(nodeID)) continue;
            retval.add(lnk.getTarget());
        }
        return retval;
    }

    public Set getNodeSources(String nodeID) {
        if (!this.nodeSuperSet_.contains(nodeID)) {
            throw new IllegalArgumentException();
        }
        Genome baseGenome = this.getBaseGenome();
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.linkSuperSet_.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage lnk = baseGenome.getLinkage(linkID);
            if (!lnk.getTarget().equals(nodeID)) continue;
            retval.add(lnk.getSource());
        }
        return retval;
    }

    public Set getLinksHeadedOutForSource(String srcID) {
        HashSet<String> retval = new HashSet<String>();
        if (!this.nodes_.contains(srcID)) {
            return retval;
        }
        Genome baseGenome = this.getBaseGenome();
        Iterator lit = this.linksOut_.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage lnk = baseGenome.getLinkage(linkID);
            if (!srcID.equals(lnk.getSource())) continue;
            retval.add(linkID);
        }
        return retval;
    }

    public Set getSourcesHeadedOut() {
        Genome baseGenome = this.getBaseGenome();
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.linksOut_.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage lnk = baseGenome.getLinkage(linkID);
            retval.add(lnk.getSource());
        }
        return retval;
    }

    public Set getSourcesHeadedIn() {
        Genome baseGenome = this.getBaseGenome();
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.linksIn_.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage lnk = baseGenome.getLinkage(linkID);
            retval.add(lnk.getSource());
        }
        return retval;
    }

    public Set getSourcesForInternal() {
        Genome baseGenome = this.getBaseGenome();
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.internalLinks_.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage lnk = baseGenome.getLinkage(linkID);
            retval.add(lnk.getSource());
        }
        return retval;
    }

    public int getTargetCount(String nodeID) {
        Set targs = this.getNodeTargets(nodeID);
        return targs.size();
    }

    private void calculate() {
        Genome baseGenome = this.getBaseGenome();
        Iterator lit = baseGenome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String srcID = link.getSource();
            String trgID = link.getTarget();
            boolean srcIn = this.nodes_.contains(srcID);
            boolean trgIn = this.nodes_.contains(trgID);
            String linkID = link.getID();
            if (srcIn && trgIn) {
                this.internalLinks_.add(linkID);
                continue;
            }
            if (srcIn) {
                this.linksOut_.add(linkID);
                this.externalTargetOnly.add(trgID);
                continue;
            }
            if (!trgIn) continue;
            this.linksIn_.add(linkID);
            this.externalSourceOnly.add(srcID);
        }
        DataUtil.intersection(this.externalSourceOnly, this.externalTargetOnly, this.externalBothSrcTarget);
        this.externalTargetOnly.removeAll(this.externalBothSrcTarget);
        this.externalSourceOnly.removeAll(this.externalBothSrcTarget);
        this.nodeSuperSet_.addAll(this.nodes_);
        this.nodeSuperSet_.addAll(this.externalSourceOnly);
        this.nodeSuperSet_.addAll(this.externalTargetOnly);
        this.nodeSuperSet_.addAll(this.externalBothSrcTarget);
        this.linkSuperSet_.addAll(this.internalLinks_);
        this.linkSuperSet_.addAll(this.linksIn_);
        this.linkSuperSet_.addAll(this.linksOut_);
    }
}

