/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.Grid;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.GridRouterPointSource;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.TrackedGrid;
import org.systemsbiology.biotapestry.util.TaggedComparableInteger;
import org.systemsbiology.biotapestry.util.Vector2D;

public class GridLinkRouter {
    public static final int GRID_LINK_E_ADJ = 0;
    public static final int GRID_LINK_E_JUMP = 1;
    public static final int GRID_LINK_SE = 2;
    public static final int GRID_LINK_S_ADJ = 3;
    public static final int GRID_LINK_S_JUMP = 4;
    public static final int GRID_LINK_SW = 5;
    public static final int GRID_LINK_W_ADJ = 6;
    public static final int GRID_LINK_W_JUMP = 7;
    public static final int GRID_LINK_NW = 8;
    public static final int GRID_LINK_N_ADJ = 9;
    public static final int GRID_LINK_N_JUMP = 10;
    public static final int GRID_LINK_NE = 11;
    public static final int GRID_LINK_STATIC = 12;
    public static final int GRID_LINK_NE_IMMED = 13;
    public static final int NO_LINK_TYPE = -1;
    public static final int CORE_FEEDBACK = 0;
    public static final int FEEDBACK_ONTO_FAN_IN = 1;
    public static final int CORE_TO_FANOUT = 2;
    public static final int INTERNAL_FAN_IN = 3;
    public static final int FAN_IN_TO_CORE = 4;
    public static final int CORE_JUMPING = 5;
    public static final int FAN_OUT_FEEDBACK_TO_CORE = 6;
    public static final int FAN_OUT_FEEDBACK_TO_FAN_IN = 7;
    public static final int INTERNAL_FAN_OUT = 8;
    public static final int INBOUND_TO_FAN_IN = 9;
    public static final int INBOUND_TO_CORE = 10;
    public static final int INBOUND_TO_FAN_OUT = 11;
    private TrackedGrid grid_;
    private HashMap padMap_;
    private GeneAndSatelliteCluster gasc_;

    public GridLinkRouter(TrackedGrid grid, GeneAndSatelliteCluster sc) {
        this.grid_ = grid;
        this.padMap_ = new HashMap();
        this.gasc_ = sc;
    }

    public Map layoutInboundLinks(Map linksPerSource, Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map pointSources, GridLinkRouter jumperSourceGrid, Map jumperPointSources, Set firstSources, Set coreJumpersAlsoToCore, boolean useDDO) {
        SpecialtyLayoutLinkData sin;
        ArrayList perSrc;
        String src;
        HashMap<String, SpecialtyLayoutLinkData> retval = new HashMap<String, SpecialtyLayoutLinkData>();
        if (linksPerSource.size() == 0) {
            return retval;
        }
        GenomeItemInstance.DBAndInstanceConsistentComparator cc = new GenomeItemInstance.DBAndInstanceConsistentComparator();
        TreeSet olps = new TreeSet(cc);
        olps.addAll(linksPerSource.keySet());
        Iterator lpsit = olps.iterator();
        if (firstSources != null && !firstSources.isEmpty()) {
            while (lpsit.hasNext()) {
                src = (String)lpsit.next();
                if (!firstSources.contains(src)) continue;
                perSrc = (ArrayList)linksPerSource.get(src);
                sin = new SpecialtyLayoutLinkData(src);
                this.fanInboundLinksForSource(src, perSrc, genome, padChanges, sin, pointSources, jumperSourceGrid, jumperPointSources, coreJumpersAlsoToCore, useDDO);
                retval.put(src, sin);
            }
            olps = new TreeSet(cc);
            olps.addAll(linksPerSource.keySet());
            lpsit = olps.iterator();
        }
        while (lpsit.hasNext()) {
            src = (String)lpsit.next();
            if (firstSources != null && firstSources.contains(src)) continue;
            perSrc = (ArrayList)linksPerSource.get(src);
            sin = new SpecialtyLayoutLinkData(src);
            this.fanInboundLinksForSource(src, perSrc, genome, padChanges, sin, pointSources, jumperSourceGrid, jumperPointSources, coreJumpersAlsoToCore, useDDO);
            retval.put(src, sin);
        }
        return retval;
    }

    public int getTopReservations() {
        return this.grid_.getTopReservations();
    }

    public Map feedbackRoutingForFanout(Set links, Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map pointSources, String coreID) {
        HashMap<String, SpecialtyLayoutLinkData> retval = new HashMap<String, SpecialtyLayoutLinkData>();
        SpecialtyLayoutLinkData sin = new SpecialtyLayoutLinkData(coreID);
        retval.put(coreID, sin);
        Grid.RowAndColumn srcRC = this.grid_.findPositionRandC(coreID);
        TrackedGrid.TrackPosRC lastPos = null;
        TrackedGrid.RCTrack feedTrack = null;
        boolean firstLink = true;
        Iterator psit = this.orderedByPads(links, padChanges, genome, lo, frc, true);
        while (psit.hasNext()) {
            List perPad = (List)psit.next();
            int numPerLo = perPad.size();
            for (int i = 0; i < numPerLo; ++i) {
                String linkID = (String)perPad.get(i);
                Linkage link = genome.getLinkage(linkID);
                String trg = link.getTarget();
                int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
                int sign = link.getSign();
                sin.startNewLink(linkID);
                GridRouterPointSource grps = (GridRouterPointSource)pointSources.get(coreID);
                if (grps == null) {
                    int srcPad = this.gasc_.getCurrentLaunchPad(link, padChanges);
                    TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(0, coreID);
                    TrackedGrid.RCTrack rootLoc = this.grid_.buildRCTrackForRowMidline(colSpec, srcPad, coreID, linkID, false, 0, srcRC.row);
                    TrackedGrid.TrackPosRC rootPos = new TrackedGrid.TrackPosRC(rootLoc);
                    grps = new GridRouterPointSource(this.grid_, rootPos, srcRC, coreID);
                    pointSources.put(coreID, grps);
                }
                if (firstLink) {
                    GridRouterPointSource.PointAndPath pap = grps.getSimpleFeedbackPoint();
                    sin.addPositionListToLink(linkID, pap.path);
                    sin.addPositionToLink(linkID, pap.pos);
                    feedTrack = pap.pos.getRCTrack();
                    firstLink = false;
                } else {
                    sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)lastPos.clone());
                }
                TrackedGrid.RCTrack lastLoc = this.grid_.inheritRCTrackNewColMidline(feedTrack, trgPad, trg, linkID, true, sign, Integer.MIN_VALUE);
                lastPos = new TrackedGrid.TrackPosRC(lastLoc);
                sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)lastPos.clone());
            }
        }
        return retval;
    }

    public Map layoutOutboundLinks(Set outboundLinks, String coreID, Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map pointSources, List srcOrder) {
        HashMap<String, SpecialtyLayoutLinkData> retval = new HashMap<String, SpecialtyLayoutLinkData>();
        HashSet<String> seenSources = new HashSet<String>();
        Iterator olit = outboundLinks.iterator();
        while (olit.hasNext()) {
            String linkID = (String)olit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            if (seenSources.contains(src)) continue;
            seenSources.add(src);
            SpecialtyLayoutLinkData sin = new SpecialtyLayoutLinkData(src);
            retval.put(src, sin);
            boolean isCore = coreID.equals(src);
            this.fanOutboundLinksForSource(link, padChanges, sin, pointSources, srcOrder, isCore);
        }
        return retval;
    }

    public boolean layoutInternalLinks(Map linksPerSource, Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map pointSources, List traceOrder, String coreID, int srcSkip, Map plans) {
        if (linksPerSource.size() == 0) {
            return false;
        }
        boolean retval = false;
        Iterator lpsit = linksPerSource.keySet().iterator();
        while (lpsit.hasNext()) {
            String src = (String)lpsit.next();
            ArrayList perSrc = (ArrayList)linksPerSource.get(src);
            int targCount = genome.getTargetCount(src);
            SpecialtyLayoutLinkData sin = new SpecialtyLayoutLinkData(src);
            boolean coreStatus = this.fanInternalLinksForSource(src, perSrc, targCount, genome, padChanges, sin, pointSources, traceOrder, srcSkip);
            if (coreID != null && coreID.equals(src)) {
                retval = coreStatus;
            }
            plans.put(src, sin);
        }
        return retval;
    }

    public Map convertInternalLinks(Map perSrcPoints, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        HashMap<String, SpecialtyLayoutLinkData> retval = new HashMap<String, SpecialtyLayoutLinkData>();
        Iterator mit = perSrcPoints.keySet().iterator();
        while (mit.hasNext()) {
            String srcID = (String)mit.next();
            SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)perSrcPoints.get(srcID);
            SpecialtyLayoutLinkData sinCopy = (SpecialtyLayoutLinkData)sin.clone();
            this.grid_.convertToPoints(sinCopy, upperLeft, positions, padChanges, genome, lo, frc, coreID, 0.0);
            retval.put(srcID, sinCopy);
        }
        return retval;
    }

    public SpecialtyLayoutLinkData convertInboundLinks(String srcID, Map perSrcPoints, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)perSrcPoints.get(srcID);
        if (sin == null) {
            return null;
        }
        SpecialtyLayoutLinkData sinCopy = (SpecialtyLayoutLinkData)sin.clone();
        this.grid_.convertToPoints(sinCopy, upperLeft, positions, padChanges, genome, lo, frc, coreID, 0.0);
        return sinCopy;
    }

    public SpecialtyLayoutLinkData convertAndFixInboundLinks(String srcID, Map perSrcPoints, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID, double fixVal) {
        SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)perSrcPoints.get(srcID);
        if (sin == null) {
            return null;
        }
        SpecialtyLayoutLinkData sinCopy = (SpecialtyLayoutLinkData)sin.clone();
        this.grid_.convertToPoints(sinCopy, upperLeft, positions, padChanges, genome, lo, frc, coreID, fixVal);
        return sinCopy;
    }

    public Point2D getLastConvertedPoint(SpecialtyLayoutLinkData sin) {
        return this.grid_.getLastConvertedPoint(sin);
    }

    public List convertPositionListToPoints(List pointList, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        ArrayList<Object> plCopy = new ArrayList<Object>();
        int npl = pointList.size();
        for (int i = 0; i < npl; ++i) {
            SpecialtyLayoutLinkData.TrackPos tp = (SpecialtyLayoutLinkData.TrackPos)pointList.get(i);
            plCopy.add(tp.clone());
        }
        this.grid_.convertPositionListToPoints(plCopy, upperLeft, positions, padChanges, genome, lo, frc, coreID);
        return plCopy;
    }

    public Point2D convertPositionToPoint(TrackedGrid.TrackPosRC tprc, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        return this.grid_.convertPositionToPoint(tprc, upperLeft, positions, padChanges, genome, lo, frc, coreID);
    }

    public Iterator orderedByPads(Set linkIDs, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, boolean reverse) {
        int sign;
        TreeMap<Integer, ArrayList<String>> padSorted = new TreeMap<Integer, ArrayList<String>>();
        Iterator feedIt = linkIDs.iterator();
        int n = sign = reverse ? -1 : 1;
        while (feedIt.hasNext()) {
            String linkID = (String)feedIt.next();
            Linkage feedLink = genome.getLinkage(linkID);
            String targID = feedLink.getTarget();
            int landing = this.gasc_.getCurrentLandingPad(feedLink, padChanges, true);
            Vector2D padOffset = TrackedGrid.landingPadToOffset(landing, genome, lo, frc, targID, 1);
            Integer padKey = new Integer(sign * (int)(padOffset.getX() / 10.0));
            ArrayList<String> perPad = (ArrayList<String>)padSorted.get(padKey);
            if (perPad == null) {
                perPad = new ArrayList<String>();
                padSorted.put(padKey, perPad);
            }
            perPad.add(linkID);
        }
        return padSorted.values().iterator();
    }

    public int calcGridLinkType(Grid.RowAndColumn srcRC, Grid.RowAndColumn trgRC, Genome genome, String src, String trg) {
        if (srcRC.row == trgRC.row) {
            if (srcRC.col == trgRC.col) {
                return 12;
            }
            if (srcRC.col > trgRC.col) {
                if (srcRC.col == trgRC.col + 1) {
                    return 6;
                }
                return 7;
            }
            if (srcRC.col == trgRC.col - 1) {
                return 0;
            }
            return 1;
        }
        if (srcRC.row > trgRC.row) {
            if (srcRC.col == trgRC.col) {
                if (srcRC.row == trgRC.row + 1) {
                    return 9;
                }
                return 10;
            }
            if (srcRC.col > trgRC.col) {
                return 8;
            }
            if (srcRC.row == trgRC.row + 1 && srcRC.col == trgRC.col - 1) {
                String corner = this.grid_.getContents(srcRC.row, trgRC.col);
                int linkCount = genome.getLinkCount(src, trg);
                if (corner != null || linkCount > 1) {
                    return 11;
                }
                return 13;
            }
            return 11;
        }
        if (srcRC.col == trgRC.col) {
            if (srcRC.row == trgRC.row - 1) {
                return 3;
            }
            return 4;
        }
        if (srcRC.col > trgRC.col) {
            return 5;
        }
        return 2;
    }

    public static int landForAGrid(GridLinkRouter glr, String nodeID, Genome genome, Set usedPads, int landDirection, boolean canEnterLeft, boolean forceTop) {
        Integer leftObj;
        Node node = genome.getNode(nodeID);
        int type = node.getNodeType();
        if (type == 6) {
            return 1;
        }
        if (canEnterLeft && forceTop) {
            canEnterLeft = type == 5;
            int n = landDirection = type == 5 ? landDirection : 3;
        }
        if (canEnterLeft && landDirection != 13 && !usedPads.contains(leftObj = new Integer(type == 5 ? 0 : 3))) {
            usedPads.add(leftObj);
            return leftObj;
        }
        int needed = genome.getInboundLinkCount(nodeID);
        if (needed == 3 && glr != null && landDirection != 13) {
            Set srcs = genome.getNodeSources(nodeID);
            Grid.RowAndColumn trgRC = glr.grid_.findPositionRandC(nodeID);
            Iterator sit = srcs.iterator();
            while (sit.hasNext()) {
                Grid.RowAndColumn srcRC;
                int linkDirection;
                String src = (String)sit.next();
                if (!glr.grid_.contains(src) || (linkDirection = glr.calcGridLinkType(srcRC = glr.grid_.findPositionRandC(src), trgRC, genome, src, nodeID)) != 13) continue;
                needed = 2;
                break;
            }
        }
        INodeRenderer rend = NodeProperties.chooseRenderer(type, 2);
        switch (landDirection) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                return rend.getBestTopPad(node, usedPads, 1, needed, true);
            }
            case 9: 
            case 10: 
            case 11: {
                return rend.getBestTopPad(node, usedPads, 1, needed, true);
            }
            case 13: {
                int botPad = rend.getBottomPad(node);
                usedPads.add(new Integer(botPad));
                return botPad;
            }
            case 0: {
                return rend.getBestTopPad(node, usedPads, 1, needed, true);
            }
        }
        throw new IllegalArgumentException();
    }

    public int landForThisGrid(String nodeID, Genome genome, Set usedPads, int landDirection, boolean canEnterLeft, boolean forceTop) {
        return GridLinkRouter.landForAGrid(this, nodeID, genome, usedPads, landDirection, canEnterLeft, forceTop);
    }

    public static boolean landOKForDirect(String nodeID, Genome genome, int landing) {
        Node node = genome.getNode(nodeID);
        int type = node.getNodeType();
        if (type == 5) {
            return landing == 0;
        }
        if (type == 6) {
            return landing == 1;
        }
        return landing == 3;
    }

    private void fanInboundLinksForSource(String src, List perSrc, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, GridLinkRouter jumperSourceGrid, Map jumperPointSources, Set coreJumpersAlsoToCore, boolean useDDO) {
        TreeMap<Integer, ArrayList<String>> linksPerType = new TreeMap<Integer, ArrayList<String>>();
        int numPerSrc = perSrc.size();
        for (int i = 0; i < numPerSrc; ++i) {
            ClassifiedLink cLink = (ClassifiedLink)perSrc.get(i);
            Integer typeObj = new Integer(cLink.type);
            ArrayList<String> perType = (ArrayList<String>)linksPerType.get(typeObj);
            if (perType == null) {
                perType = new ArrayList<String>();
                linksPerType.put(typeObj, perType);
            }
            perType.add(cLink.linkID);
        }
        Iterator lptit = linksPerType.keySet().iterator();
        block7: while (lptit.hasNext()) {
            Integer typeObj = (Integer)lptit.next();
            ArrayList perType = (ArrayList)linksPerType.get(typeObj);
            switch (typeObj) {
                case 9: {
                    this.planInboundToFanLinks(src, perType, genome, padChanges, sin, pointSources, useDDO);
                    continue block7;
                }
                case 10: {
                    this.planInboundToCoreLinks(src, perType, genome, padChanges, sin, pointSources, useDDO);
                    continue block7;
                }
                case 11: {
                    this.planInboundToFanLinks(src, perType, genome, padChanges, sin, pointSources, useDDO);
                    continue block7;
                }
                case 5: {
                    this.planCoreJumperLinks(src, perType, genome, padChanges, sin, pointSources, jumperSourceGrid, jumperPointSources, coreJumpersAlsoToCore, useDDO);
                    continue block7;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private boolean fanInternalLinksForSource(String src, List perSrc, int targCount, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, List traceOrder, int srcSkip) {
        ArrayList<String> perType;
        Integer typeObj;
        TreeMap<Integer, ArrayList<String>> linksPerType = new TreeMap<Integer, ArrayList<String>>();
        int numPerSrc = perSrc.size();
        for (int i = 0; i < numPerSrc; ++i) {
            ClassifiedLink cLink = (ClassifiedLink)perSrc.get(i);
            typeObj = new Integer(cLink.type);
            perType = (ArrayList<String>)linksPerType.get(typeObj);
            if (perType == null) {
                perType = new ArrayList<String>();
                linksPerType.put(typeObj, perType);
            }
            perType.add(cLink.linkID);
        }
        boolean coreIsFanned = false;
        Iterator lptit = linksPerType.keySet().iterator();
        while (lptit.hasNext()) {
            typeObj = (Integer)lptit.next();
            perType = (ArrayList)linksPerType.get(typeObj);
            switch (typeObj) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    coreIsFanned = this.routeCoreToFanOutLinks(src, perType, targCount, genome, padChanges, sin, pointSources, srcSkip);
                    break;
                }
                case 4: {
                    this.routeFaninToCoreLinks(src, perType, targCount, genome, padChanges, sin, pointSources, traceOrder);
                    break;
                }
                case 3: {
                    this.routeInternalFanLinks(src, perType, targCount, genome, padChanges, sin, pointSources, false, srcSkip);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    this.routeInternalFanLinks(src, perType, targCount, genome, padChanges, sin, pointSources, false, srcSkip);
                }
            }
        }
        return coreIsFanned;
    }

    private boolean routeInternalFanLinks(String src, List links, int trgCount, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, boolean coreSrc, int srcSkip) {
        HashSet<String> directLinks = new HashSet<String>();
        HashSet<String> elbowLinks = new HashSet<String>();
        Grid.RowAndColumn srcRC = this.grid_.findPositionRandC(src);
        TreeMap<LinkLayoutOrdering, ArrayList<Linkage>> linkOrdering = new TreeMap<LinkLayoutOrdering, ArrayList<Linkage>>();
        int srcPad = 0;
        String aLink = null;
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            int trgType;
            LinkLayoutOrdering key;
            ArrayList<Linkage> linksPerOrder;
            String linkID = (String)links.get(i);
            Linkage link = genome.getLinkage(linkID);
            srcPad = this.gasc_.getCurrentLaunchPad(link, padChanges);
            aLink = linkID;
            String ltrg = link.getTarget();
            Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(ltrg);
            int linkType = this.calcGridLinkType(srcRC, trgRC, genome, src, ltrg);
            int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
            if (linkType == 0 && GridLinkRouter.landOKForDirect(ltrg, genome, trgPad)) {
                directLinks.add(linkID);
            }
            if (linkType == 13) {
                elbowLinks.add(linkID);
            }
            if ((linksPerOrder = (ArrayList<Linkage>)linkOrdering.get(key = new LinkLayoutOrdering(srcRC, trgRC, genome, ltrg, trgPad, trgType = genome.getNode(ltrg).getNodeType()))) == null) {
                linksPerOrder = new ArrayList<Linkage>();
                linkOrdering.put(key, linksPerOrder);
            }
            linksPerOrder.add(link);
        }
        if (trgCount == 1 && numLinks == 1 && directLinks.size() == 1) {
            return false;
        }
        GridRouterPointSource grps = (GridRouterPointSource)pointSources.get(src);
        if (grps == null) {
            int reserveCol = coreSrc ? srcRC.col : srcRC.col + 1;
            TrackedGrid.TrackSpec colSpec = coreSrc && srcSkip != 0 ? this.grid_.reserveSkippedColumnTrack(reserveCol, src, srcSkip) : this.grid_.reserveColumnTrack(reserveCol, src);
            TrackedGrid.RCTrack rootLoc = this.grid_.buildRCTrackForRowMidline(colSpec, srcPad, src, aLink, false, 0, srcRC.row);
            TrackedGrid.TrackPosRC rootPos = new TrackedGrid.TrackPosRC(rootLoc);
            grps = new GridRouterPointSource(this.grid_, rootPos, srcRC, src);
            pointSources.put(src, grps);
        }
        Iterator loit = linkOrdering.keySet().iterator();
        while (loit.hasNext()) {
            LinkLayoutOrdering pdKey = (LinkLayoutOrdering)loit.next();
            ArrayList linksPerOrder = (ArrayList)linkOrdering.get(pdKey);
            int numPerLo = linksPerOrder.size();
            for (int i = 0; i < numPerLo; ++i) {
                Grid.RowAndColumn trgRC;
                int sign;
                int trgPad;
                String trg;
                Linkage link = (Linkage)linksPerOrder.get(i);
                String linkID = link.getID();
                sin.startNewLink(linkID);
                if (directLinks.contains(linkID)) {
                    sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)grps.getRootPos().clone());
                    continue;
                }
                if (elbowLinks.contains(linkID)) {
                    trg = link.getTarget();
                    trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
                    sign = link.getSign();
                    trgRC = this.grid_.findPositionRandC(trg);
                    TrackedGrid.TrackPosRC pos = grps.getBottomElbowPoint(srcRC.row, trgRC.col, srcPad, trgPad, trg, linkID, sign);
                    sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)grps.getRootPos().clone());
                    sin.addPositionToLink(linkID, pos);
                    continue;
                }
                trg = link.getTarget();
                trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
                sign = link.getSign();
                trgRC = this.grid_.findPositionRandC(trg);
                boolean onLeft = coreSrc ? this.grid_.firstOnLeft(trg, null) : this.grid_.canEnterOnLeft(src, trg, genome);
                onLeft = onLeft && GridLinkRouter.landOKForDirect(trg, genome, trgPad);
                GridRouterPointSource.PointAndPath pap = grps.getLastPoint(onLeft, trgRC.row, trgRC.col, trgPad, trg, linkID, sign);
                sin.addPositionListToLink(linkID, pap.path);
                sin.addPositionToLink(linkID, pap.pos);
            }
        }
        return true;
    }

    private void routeFaninToCoreLinks(String src, List links, int trgCount, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, List traceOrder) {
        TreeMap<TaggedComparableInteger, ArrayList<Linkage>> linkOrdering = new TreeMap<TaggedComparableInteger, ArrayList<Linkage>>();
        String target = null;
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            String linkID = (String)links.get(i);
            Linkage link = genome.getLinkage(linkID);
            int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
            target = link.getTarget();
            TaggedComparableInteger key = new TaggedComparableInteger(new Integer(trgPad), linkID);
            ArrayList<Linkage> linksPerOrder = (ArrayList<Linkage>)linkOrdering.get(key);
            if (linksPerOrder == null) {
                linksPerOrder = new ArrayList<Linkage>();
                linkOrdering.put(key, linksPerOrder);
            }
            linksPerOrder.add(link);
        }
        if (!this.grid_.contains(src)) {
            return;
        }
        Grid.RowAndColumn srcRC = this.grid_.findPositionRandC(src);
        String rightmost = this.grid_.rightmostForRow(srcRC.row, target);
        boolean isDirect = rightmost.equals(src) && trgCount == 1;
        TrackedGrid.RCTrack sortTrack = null;
        boolean firstLink = true;
        boolean gotDptc = false;
        Iterator loit = linkOrdering.keySet().iterator();
        TrackedGrid.TrackPosRC lastPos = null;
        while (loit.hasNext()) {
            TaggedComparableInteger pdKey = (TaggedComparableInteger)loit.next();
            ArrayList linksPerPad = (ArrayList)linkOrdering.get(pdKey);
            int numPerLo = linksPerPad.size();
            for (int i = 0; i < numPerLo; ++i) {
                TrackedGrid.TrackPosRC rootPos;
                Linkage link = (Linkage)linksPerPad.get(i);
                String linkID = link.getID();
                String trg = link.getTarget();
                int srcPad = this.gasc_.getCurrentLaunchPad(link, padChanges);
                int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
                int sign = link.getSign();
                sin.startNewLink(linkID);
                GridRouterPointSource grps = (GridRouterPointSource)pointSources.get(src);
                if (grps == null) {
                    if (isDirect) {
                        TrackedGrid.RCTrack rootLoc = this.grid_.buildRCTrackForDualMidline(trgPad, trg, true, srcPad, src, false, sign, linkID, Integer.MIN_VALUE, srcRC.row);
                        rootPos = new TrackedGrid.TrackPosRC(rootLoc);
                    } else {
                        TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(srcRC.col + 1, src);
                        TrackedGrid.RCTrack rootLoc = this.grid_.buildRCTrackForRowMidline(colSpec, srcPad, src, linkID, false, 0, srcRC.row);
                        rootPos = new TrackedGrid.TrackPosRC(rootLoc);
                    }
                    grps = new GridRouterPointSource(this.grid_, rootPos, srcRC, src);
                    pointSources.put(src, grps);
                }
                if (firstLink) {
                    if (isDirect) {
                        rootPos = grps.getRootPos();
                        sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)rootPos.clone());
                        sortTrack = (TrackedGrid.RCTrack)rootPos.getRCTrack().clone();
                    } else {
                        GridRouterPointSource.PointAndPath pap = grps.getDepartingPointToCore(trgPad, trg, linkID, sign);
                        sin.addPositionListToLink(linkID, pap.path);
                        sin.addPositionToLink(linkID, pap.pos);
                        sortTrack = (TrackedGrid.RCTrack)pap.pos.getRCTrack().clone();
                        gotDptc = true;
                    }
                    firstLink = false;
                } else {
                    sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)lastPos.clone());
                }
                TrackedGrid.RCTrack lastLoc = this.grid_.inheritRCTrackNewColMidline(sortTrack, trgPad, trg, linkID, true, sign, Integer.MIN_VALUE);
                lastPos = new TrackedGrid.TrackPosRC(lastLoc);
                sin.addPositionToLink(linkID, lastPos);
                if (!gotDptc) continue;
                grps.updateLastDepartingPointToCore(lastPos);
            }
        }
        if (sortTrack != null) {
            RCRowCompare rcr = new RCRowCompare(sortTrack, src);
            traceOrder.add(rcr);
        }
    }

    private void fanOutboundLinksForSource(Linkage link, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, List srcOrder, boolean isCore) {
        TrackedGrid.RCTrack sortTrack;
        String src = link.getSource();
        if (!this.grid_.contains(src)) {
            return;
        }
        Grid.RowAndColumn srcRC = this.grid_.findPositionRandC(src);
        boolean isDirect = false;
        if (!isCore) {
            String rightmost = this.grid_.rightmostForRow(srcRC.row, null);
            isDirect = rightmost.equals(src);
        }
        String linkID = link.getID();
        int srcPad = this.gasc_.getCurrentLaunchPad(link, padChanges);
        sin.startNewLink(linkID);
        GridRouterPointSource grps = (GridRouterPointSource)pointSources.get(src);
        if (grps == null) {
            TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(srcRC.col + 1, src);
            TrackedGrid.RCTrack rootLoc = this.grid_.buildRCTrackForRowMidline(colSpec, srcPad, src, linkID, false, 0, srcRC.row);
            TrackedGrid.TrackPosRC rootPos = new TrackedGrid.TrackPosRC(rootLoc);
            grps = new GridRouterPointSource(this.grid_, rootPos, srcRC, src);
            pointSources.put(src, grps);
        }
        if (isDirect) {
            TrackedGrid.TrackPosRC rootPos = grps.getRootPos();
            sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)rootPos.clone());
            sortTrack = (TrackedGrid.RCTrack)rootPos.getRCTrack().clone();
        } else {
            GridRouterPointSource.PointAndPath pap = grps.getDepartingPointToOutbound();
            sin.addPositionListToLink(linkID, pap.path);
            sin.addPositionToLink(linkID, pap.pos);
            sortTrack = (TrackedGrid.RCTrack)pap.pos.getRCTrack().clone();
        }
        RCRowCompare rcr = new RCRowCompare(sortTrack, src);
        srcOrder.add(rcr);
    }

    private boolean routeCoreToFanOutLinks(String src, List links, int trgCount, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, int srcSkip) {
        return this.routeInternalFanLinks(src, links, trgCount, genome, padChanges, sin, pointSources, true, srcSkip);
    }

    private void planInboundToFanLinks(String src, List links, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, boolean useDDO) {
        boolean comingFromTop = useDDO && this.gasc_.getDDOracle() != null ? this.gasc_.getDDOracle().comingFromTop(src, this.gasc_) : true;
        TreeMap<LinkLayoutOrdering, ArrayList<Linkage>> linkOrdering = new TreeMap<LinkLayoutOrdering, ArrayList<Linkage>>();
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            int trgType;
            boolean onLeft;
            int trgPad;
            String linkID = (String)links.get(i);
            Linkage link = genome.getLinkage(linkID);
            String ltrg = link.getTarget();
            Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(ltrg);
            LinkLayoutOrdering key = new LinkLayoutOrdering(trgRC, genome, ltrg, trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true), onLeft = (onLeft = this.grid_.firstOnLeft(ltrg, null)) && GridLinkRouter.landOKForDirect(ltrg, genome, trgPad), trgType = genome.getNode(ltrg).getNodeType(), comingFromTop);
            ArrayList<Linkage> linksPerOrder = (ArrayList<Linkage>)linkOrdering.get(key);
            if (linksPerOrder == null) {
                linksPerOrder = new ArrayList<Linkage>();
                linkOrdering.put(key, linksPerOrder);
            }
            linksPerOrder.add(link);
        }
        Iterator loit = linkOrdering.keySet().iterator();
        while (loit.hasNext()) {
            LinkLayoutOrdering pdKey = (LinkLayoutOrdering)loit.next();
            ArrayList linksPerOrder = (ArrayList)linkOrdering.get(pdKey);
            int numPerLo = linksPerOrder.size();
            for (int i = 0; i < numPerLo; ++i) {
                Linkage link = (Linkage)linksPerOrder.get(i);
                String linkID = link.getID();
                String trg = link.getTarget();
                sin.startNewLink(linkID);
                GridRouterPointSource grps = (GridRouterPointSource)pointSources.get(src);
                if (grps == null) {
                    TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(0, src);
                    Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(trg);
                    TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(trgRC.row, src);
                    TrackedGrid.RCTrack inboundLoc = this.grid_.buildRCTrack(rowSpec, colSpec);
                    if (useDDO && this.gasc_.getDDOracle() != null) {
                        inboundLoc = this.grid_.buildRCTrack(inboundLoc, 4);
                    }
                    TrackedGrid.TrackPosRC rootPos = new TrackedGrid.TrackPosRC(inboundLoc);
                    grps = new GridRouterPointSource(this.grid_, rootPos, src);
                    pointSources.put(src, grps);
                }
                int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
                int sign = link.getSign();
                Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(trg);
                boolean onLeft = this.grid_.firstOnLeft(trg, null);
                onLeft = onLeft && GridLinkRouter.landOKForDirect(trg, genome, trgPad);
                GridRouterPointSource.PointAndPath pap = grps.getLastPointForInbound(onLeft, trgRC.row, trgRC.col, trgPad, trg, linkID, sign, comingFromTop);
                sin.addPositionListToLink(linkID, pap.path);
                sin.addPositionToLink(linkID, pap.pos);
            }
        }
    }

    private void planInboundToCoreLinks(String src, List links, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, boolean useDDO) {
        boolean comingFromTop = useDDO && this.gasc_.getDDOracle() != null ? this.gasc_.getDDOracle().comingFromTop(src, this.gasc_) : true;
        TreeMap<Integer, ArrayList<Linkage>> linkOrdering = new TreeMap<Integer, ArrayList<Linkage>>();
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            String linkID = (String)links.get(i);
            Linkage link = genome.getLinkage(linkID);
            int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
            Integer key = new Integer(trgPad);
            ArrayList<Linkage> linksPerOrder = (ArrayList<Linkage>)linkOrdering.get(key);
            if (linksPerOrder == null) {
                linksPerOrder = new ArrayList<Linkage>();
                linkOrdering.put(key, linksPerOrder);
            }
            linksPerOrder.add(link);
        }
        boolean isFirst = true;
        TrackedGrid.RCTrack dropTrack = null;
        TrackedGrid.TrackPosRC lastPos = null;
        Iterator loit = linkOrdering.keySet().iterator();
        while (loit.hasNext()) {
            Integer pdKey = (Integer)loit.next();
            ArrayList linksPerPad = (ArrayList)linkOrdering.get(pdKey);
            int numPerLo = linksPerPad.size();
            for (int i = 0; i < numPerLo; ++i) {
                Linkage link = (Linkage)linksPerPad.get(i);
                String linkID = link.getID();
                String trg = link.getTarget();
                int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
                int sign = link.getSign();
                sin.startNewLink(linkID);
                GridRouterPointSource grps = (GridRouterPointSource)pointSources.get(src);
                if (grps == null) {
                    TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(0, src);
                    TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(0, src);
                    TrackedGrid.RCTrack inboundLoc = this.grid_.buildRCTrack(rowSpec, colSpec);
                    TrackedGrid.TrackPosRC rootPos = new TrackedGrid.TrackPosRC(inboundLoc);
                    grps = new GridRouterPointSource(this.grid_, rootPos, src);
                    pointSources.put(src, grps);
                }
                if (isFirst) {
                    isFirst = false;
                    GridRouterPointSource.PointAndPath pap = grps.getPointForInboundDirectToCore(comingFromTop);
                    sin.addPositionListToLink(linkID, pap.path);
                    sin.addPositionToLink(linkID, pap.pos);
                    dropTrack = (TrackedGrid.RCTrack)pap.pos.getRCTrack().clone();
                } else {
                    sin.addPositionToLink(linkID, (TrackedGrid.TrackPosRC)lastPos.clone());
                }
                TrackedGrid.RCTrack lastLoc = this.grid_.inheritRCTrackNewColMidline(dropTrack, trgPad, trg, linkID, true, sign, Integer.MIN_VALUE);
                lastPos = new TrackedGrid.TrackPosRC(lastLoc);
                sin.addPositionToLink(linkID, lastPos);
            }
        }
    }

    private void planCoreJumperLinks(String src, List links, Genome genome, Map padChanges, SpecialtyLayoutLinkData sin, Map pointSources, GridLinkRouter jumperSourceGrid, Map jumperPointSources, Set coreJumpersAlsoToCore, boolean useDDO) {
        boolean comingFromTop = useDDO && this.gasc_.getDDOracle() != null ? this.gasc_.getDDOracle().comingFromTop(src, this.gasc_) : true;
        TreeMap<LinkLayoutOrdering, ArrayList<Linkage>> linkOrdering = new TreeMap<LinkLayoutOrdering, ArrayList<Linkage>>();
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            int trgType;
            boolean onLeft;
            int trgPad;
            String linkID = (String)links.get(i);
            Linkage link = genome.getLinkage(linkID);
            String ltrg = link.getTarget();
            if (!this.grid_.contains(ltrg)) continue;
            Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(ltrg);
            LinkLayoutOrdering key = new LinkLayoutOrdering(trgRC, genome, ltrg, trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true), onLeft = (onLeft = this.grid_.firstOnLeft(ltrg, null)) && GridLinkRouter.landOKForDirect(ltrg, genome, trgPad), trgType = genome.getNode(ltrg).getNodeType(), true);
            ArrayList<Linkage> linksPerOrder = (ArrayList<Linkage>)linkOrdering.get(key);
            if (linksPerOrder == null) {
                linksPerOrder = new ArrayList<Linkage>();
                linkOrdering.put(key, linksPerOrder);
            }
            linksPerOrder.add(link);
        }
        boolean isFirst = true;
        Iterator loit = linkOrdering.keySet().iterator();
        while (loit.hasNext()) {
            LinkLayoutOrdering pdKey = (LinkLayoutOrdering)loit.next();
            ArrayList linksPerOrder = (ArrayList)linkOrdering.get(pdKey);
            int numPerLo = linksPerOrder.size();
            for (int i = 0; i < numPerLo; ++i) {
                GridRouterPointSource grps;
                Linkage link = (Linkage)linksPerOrder.get(i);
                if (isFirst) {
                    jumperSourceGrid.routeCoreJumperLinksOutOfFanIn(src, link, sin, jumperPointSources, coreJumpersAlsoToCore, comingFromTop);
                }
                String linkID = link.getID();
                String trg = link.getTarget();
                if (!sin.haveLink(linkID)) {
                    sin.startNewLink(linkID);
                }
                if ((grps = (GridRouterPointSource)pointSources.get(src)) == null) {
                    TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(0, src);
                    Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(trg);
                    TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(trgRC.row, src);
                    TrackedGrid.RCTrack inboundLoc = this.grid_.buildRCTrack(rowSpec, colSpec);
                    TrackedGrid.TrackPosRC rootPos = new TrackedGrid.TrackPosRC(inboundLoc);
                    grps = new GridRouterPointSource(this.grid_, rootPos, src);
                    pointSources.put(src, grps);
                }
                int trgPad = this.gasc_.getCurrentLandingPad(link, padChanges, true);
                int sign = link.getSign();
                Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(trg);
                boolean onLeft = this.grid_.firstOnLeft(trg, null);
                onLeft = onLeft && GridLinkRouter.landOKForDirect(trg, genome, trgPad);
                GridRouterPointSource.PointAndPath pap = grps.getLastPointForInbound(onLeft, trgRC.row, trgRC.col, trgPad, trg, linkID, sign, true);
                if (isFirst) {
                    if (!pap.path.isEmpty()) {
                        TrackedGrid.TrackPosRC extraPos = (TrackedGrid.TrackPosRC)pap.path.get(0);
                        TrackedGrid.RCTrack extraLoc = this.grid_.buildRCTrack(extraPos.getRCTrack(), 3);
                        sin.addPositionToLink(linkID, new TrackedGrid.TrackPosRC(extraLoc));
                    }
                    isFirst = false;
                }
                sin.addPositionListToLink(linkID, pap.path);
                sin.addPositionToLink(linkID, pap.pos);
            }
        }
    }

    private void routeCoreJumperLinksOutOfFanIn(String src, Linkage link, SpecialtyLayoutLinkData sin, Map pointSources, Set coreJumpersAlsoToCore, boolean comingFromTop) {
        GridRouterPointSource.PointAndPath pap;
        String linkID = link.getID();
        sin.startNewLink(linkID);
        GridRouterPointSource grps = (GridRouterPointSource)pointSources.get(src);
        if (grps == null) {
            TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(0, src);
            TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(0, src);
            TrackedGrid.RCTrack inboundLoc = this.grid_.buildRCTrack(rowSpec, colSpec);
            TrackedGrid.TrackPosRC rootPos = new TrackedGrid.TrackPosRC(inboundLoc);
            grps = new GridRouterPointSource(this.grid_, rootPos, src);
            pointSources.put(src, grps);
        }
        if (coreJumpersAlsoToCore.contains(src)) {
            pap = grps.hangJumperOffDirectToCore();
            sin.addPositionListToLink(linkID, pap.path);
            sin.addPositionToLink(linkID, pap.pos);
        } else {
            pap = grps.getPointForInboundDirectToCore(comingFromTop);
            sin.addPositionListToLink(linkID, pap.path);
            sin.addPositionToLink(linkID, pap.pos);
        }
    }

    private static class LinkLayoutOrdering
    implements Comparable {
        public double deltaRow;
        public double deltaCol;
        public int padNum;
        public int targType;
        public Genome genome;
        public String targNodeID;

        LinkLayoutOrdering(Grid.RowAndColumn trgRowCol, Genome genome, String targNodeID, int padNum, boolean onLeft, int targType, boolean startOnTop) {
            double d = this.deltaRow = startOnTop ? (double)trgRowCol.row : (double)(trgRowCol.row - Integer.MAX_VALUE);
            if (onLeft) {
                this.deltaRow += 0.5;
            }
            this.deltaCol = trgRowCol.col + 1;
            this.padNum = padNum;
            this.targType = targType;
            this.genome = genome;
            this.targNodeID = targNodeID;
        }

        LinkLayoutOrdering(Grid.RowAndColumn srcRowCol, Grid.RowAndColumn trgRowCol, Genome genome, String targNodeID, int padNum, int targType) {
            this.deltaRow = trgRowCol.row - srcRowCol.row;
            this.deltaCol = trgRowCol.col - srcRowCol.col;
            this.padNum = padNum;
            this.targType = targType;
            this.genome = genome;
            this.targNodeID = targNodeID;
        }

        public int hashCode() {
            return (int)Math.round(this.deltaRow + this.deltaCol + (double)this.padNum + (double)this.targType);
        }

        public String toString() {
            return "LinkLayoutOrdering: " + this.deltaRow + " " + this.deltaCol + " " + this.padNum + " " + this.targType;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof LinkLayoutOrdering)) {
                return false;
            }
            LinkLayoutOrdering otherLLO = (LinkLayoutOrdering)other;
            return this.deltaCol == otherLLO.deltaCol && this.deltaRow == otherLLO.deltaRow && this.padNum == otherLLO.padNum && this.targType == otherLLO.targType;
        }

        private int quadrantOrder() {
            if (this.deltaRow <= 0.0) {
                return this.deltaCol > 0.0 ? 0 : 1;
            }
            return this.deltaCol > 0.0 ? 2 : 3;
        }

        private int padShift() {
            return 0;
        }

        public int compareTo(Object o) {
            int otherQuadrant;
            LinkLayoutOrdering other = (LinkLayoutOrdering)o;
            if (this.equals(other)) {
                return 0;
            }
            int myQuadrant = this.quadrantOrder();
            if (myQuadrant != (otherQuadrant = other.quadrantOrder())) {
                return myQuadrant - otherQuadrant;
            }
            if (this.deltaRow != other.deltaRow) {
                return Math.abs(this.deltaRow) > Math.abs(other.deltaRow) ? 1 : -1;
            }
            if (this.deltaCol != other.deltaCol) {
                double otherDeltaAbs;
                double myDeltaAbs;
                double nearest;
                if (myQuadrant == 2 && (nearest = Math.min(myDeltaAbs = Math.abs(this.deltaCol), otherDeltaAbs = Math.abs(other.deltaCol))) == 1.0) {
                    LinkLayoutOrdering whichLLO = myDeltaAbs == 1.0 ? this : other;
                    boolean isDirect = GridLinkRouter.landOKForDirect(whichLLO.targNodeID, whichLLO.genome, whichLLO.padNum);
                    if (isDirect) {
                        return whichLLO == this ? 1 : -1;
                    }
                }
                return Math.abs(this.deltaCol) > Math.abs(other.deltaCol) ? 1 : -1;
            }
            if (this.targType != other.targType) {
                throw new IllegalStateException();
            }
            INodeRenderer rend = NodeProperties.chooseRenderer(this.targType, 2);
            return rend.comparePads(this.padNum, other.padNum);
        }
    }

    public static class RCRowCompare
    implements Comparable {
        private TrackedGrid.RCTrack myTrack_;
        private String src_;

        public RCRowCompare(TrackedGrid.RCTrack myTrack, String src) {
            this.myTrack_ = myTrack;
            this.src_ = src;
        }

        public String getSrc() {
            return this.src_;
        }

        public int compareTo(Object o) {
            RCRowCompare other = (RCRowCompare)o;
            return this.myTrack_.rowCompare(other.myTrack_);
        }
    }

    public static class ClassifiedLink
    implements Cloneable {
        public String linkID;
        public int type;

        public ClassifiedLink(String linkID, int type) {
            this.linkID = linkID;
            this.type = type;
        }

        public Object clone() {
            try {
                return (ClassifiedLink)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }
}

