/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.ui.Grid;
import org.systemsbiology.biotapestry.ui.layouts.TrackedGrid;

public class GridRouterPointSource {
    private TrackedGrid grid_;
    private TrackedGrid.TrackPosRC rootPos_;
    private TreeMap posPerRow_;
    private HashMap rightDeparturePerRow_;
    private String srcID_;
    private int rootCol_;
    private int rootRow_;

    public GridRouterPointSource(TrackedGrid grid, TrackedGrid.TrackPosRC rootPos, Grid.RowAndColumn srcRC, String srcID) {
        this.grid_ = grid;
        this.srcID_ = srcID;
        this.rootPos_ = (TrackedGrid.TrackPosRC)rootPos.clone();
        this.rootCol_ = srcRC.col;
        this.rootRow_ = srcRC.row;
        this.posPerRow_ = new TreeMap();
        TrackedGrid.RCTrack colTrack = this.rootPos_.getRCTrack();
        TreeMap<Integer, TrackedGrid.TrackPosRC> rootPerRow = new TreeMap<Integer, TrackedGrid.TrackPosRC>();
        double offset = this.grid_.contains(srcID) ? 0.5 : 0.0;
        this.posPerRow_.put(new Double((double)this.rootRow_ + offset), rootPerRow);
        TrackedGrid.RCTrack rootTrack = this.rootPos_.getRCTrack();
        TrackedGrid.RCTrack rootRowLoc = this.grid_.buildRCTrack(rootTrack, colTrack);
        TrackedGrid.TrackPosRC posForRootRow = new TrackedGrid.TrackPosRC(rootRowLoc);
        rootPerRow.put(new Integer(this.rootCol_), posForRootRow);
        this.rightDeparturePerRow_ = new HashMap();
    }

    public GridRouterPointSource(TrackedGrid grid, TrackedGrid.TrackPosRC rootPos, String srcID) {
        this.grid_ = grid;
        this.srcID_ = srcID;
        this.rootPos_ = (TrackedGrid.TrackPosRC)rootPos.clone();
        this.posPerRow_ = new TreeMap();
        this.rightDeparturePerRow_ = new HashMap();
    }

    public TrackedGrid.TrackPosRC getRootPos() {
        return this.rootPos_;
    }

    public PointAndPath getLastPoint(boolean direct, int rowNum, int colNum, int padNum, String nodeID, String linkID, int linkSign) {
        TrackedGrid.RCTrack lastLoc;
        TrackedGrid.TrackPosRC posForRow;
        PointAndPath retval = new PointAndPath();
        double fractionalRowNum = direct ? (double)rowNum + 0.5 : (double)rowNum;
        double fractionalRoot = (double)this.rootRow_ + 0.5;
        Double rowNumObj = new Double(fractionalRowNum);
        TreeMap<Integer, Object> perRow = (TreeMap<Integer, Object>)this.posPerRow_.get(rowNumObj);
        TrackedGrid.TrackPosRC posForRowCol = null;
        TrackedGrid.RCTrack rowLoc = null;
        if (perRow == null) {
            boolean wasNoRows = this.posPerRow_.isEmpty();
            double lastRow = Double.NEGATIVE_INFINITY;
            if (!wasNoRows) {
                Double outKey = (Double)(fractionalRowNum <= fractionalRoot ? this.posPerRow_.firstKey() : this.posPerRow_.lastKey());
                double maybeLast = outKey;
                if (fractionalRowNum <= fractionalRoot && maybeLast <= fractionalRoot) {
                    lastRow = maybeLast;
                } else if (fractionalRowNum > fractionalRoot && maybeLast >= fractionalRoot) {
                    lastRow = maybeLast;
                }
            }
            perRow = new TreeMap<Integer, Object>();
            this.posPerRow_.put(rowNumObj, perRow);
            TrackedGrid.RCTrack colTrack = this.rootPos_.getRCTrack();
            TrackedGrid.TrackSpec colSpec = colTrack.getCol();
            if (!direct) {
                TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(rowNum, this.srcID_);
                rowLoc = this.grid_.buildRCTrack(rowSpec, colSpec);
            } else {
                rowLoc = this.grid_.buildRCTrackForRowMidline(colSpec, padNum, nodeID, linkID, true, linkSign, rowNum);
            }
            posForRow = new TrackedGrid.TrackPosRC(rowLoc);
            perRow.put(new Integer(this.rootCol_), posForRow.clone());
            if (wasNoRows) {
                retval.path.add(this.rootPos_.clone());
            } else if (lastRow != Double.NEGATIVE_INFINITY) {
                TreeMap perLastRow = (TreeMap)this.posPerRow_.get(new Double(lastRow));
                Integer outKey = new Integer(this.rootCol_);
                TrackedGrid.TrackPosRC posForLastRow = (TrackedGrid.TrackPosRC)perLastRow.get(outKey);
                retval.path.add(posForLastRow.clone());
            }
        } else {
            Integer outKey = (Integer)(colNum <= this.rootCol_ ? perRow.firstKey() : perRow.lastKey());
            posForRow = (TrackedGrid.TrackPosRC)perRow.get(outKey);
            if (colNum == outKey) {
                posForRowCol = posForRow;
            }
        }
        retval.path.add(posForRow.clone());
        if (posForRowCol != null && posForRowCol.getRCTrack().getColPadNum() == padNum) {
            retval.pos = (TrackedGrid.TrackPosRC)posForRowCol.clone();
            return retval;
        }
        if (!direct) {
            TrackedGrid.TrackSpec rowSpec = posForRow.getRCTrack().getRow();
            lastLoc = this.grid_.buildRCTrackForColMidline(rowSpec, padNum, nodeID, linkID, true, linkSign, Integer.MIN_VALUE);
        } else {
            lastLoc = (TrackedGrid.RCTrack)rowLoc.clone();
        }
        TrackedGrid.TrackPosRC lastPos = new TrackedGrid.TrackPosRC(lastLoc);
        perRow.put(new Integer(colNum), lastPos);
        retval.pos = (TrackedGrid.TrackPosRC)lastPos.clone();
        return retval;
    }

    public TrackedGrid.TrackPosRC getBottomElbowPoint(int rowNum, int colNum, int sPadNum, int tPadNum, String nodeID, String linkID, int linkSign) {
        double fractionalRowNum = (double)rowNum + 0.5;
        double fractionalRoot = (double)this.rootRow_ + 0.5;
        Double rowNumObj = new Double(fractionalRowNum);
        TreeMap<Integer, Object> perRow = (TreeMap<Integer, Object>)this.posPerRow_.get(rowNumObj);
        TrackedGrid.TrackPosRC posForRowCol = null;
        TrackedGrid.RCTrack rowLoc = null;
        if (perRow == null) {
            boolean wasNoRows = this.posPerRow_.isEmpty();
            double lastRow = Double.NEGATIVE_INFINITY;
            if (!wasNoRows) {
                Double outKey = (Double)(fractionalRowNum <= fractionalRoot ? this.posPerRow_.firstKey() : this.posPerRow_.lastKey());
                double maybeLast = outKey;
                if (fractionalRowNum <= fractionalRoot && maybeLast <= fractionalRoot) {
                    lastRow = maybeLast;
                } else if (fractionalRowNum > fractionalRoot && maybeLast >= fractionalRoot) {
                    lastRow = maybeLast;
                }
            }
            perRow = new TreeMap<Integer, Object>();
            this.posPerRow_.put(rowNumObj, perRow);
            TrackedGrid.RCTrack colTrack = this.rootPos_.getRCTrack();
            TrackedGrid.TrackSpec colSpec = colTrack.getCol();
            rowLoc = this.grid_.buildRCTrackForRowMidline(colSpec, tPadNum, nodeID, linkID, true, linkSign, rowNum);
            TrackedGrid.TrackPosRC posForRow = new TrackedGrid.TrackPosRC(rowLoc);
            perRow.put(new Integer(this.rootCol_), posForRow.clone());
            if (!wasNoRows && lastRow != Double.NEGATIVE_INFINITY) {
                throw new IllegalStateException();
            }
        } else {
            Integer outKey = (Integer)(colNum <= this.rootCol_ ? perRow.firstKey() : perRow.lastKey());
            TrackedGrid.TrackPosRC posForRow = (TrackedGrid.TrackPosRC)perRow.get(outKey);
            if (colNum == outKey) {
                posForRowCol = posForRow;
            }
        }
        if (posForRowCol != null) {
            throw new IllegalStateException();
        }
        TrackedGrid.RCTrack lastLoc = rowLoc == null ? this.grid_.buildRCTrackForDualMidline(tPadNum, nodeID, true, sPadNum, this.srcID_, false, linkSign, linkID, Integer.MIN_VALUE, rowNum) : (TrackedGrid.RCTrack)rowLoc.clone();
        TrackedGrid.TrackPosRC lastPos = new TrackedGrid.TrackPosRC(lastLoc);
        perRow.put(new Integer(colNum), lastPos);
        return (TrackedGrid.TrackPosRC)lastPos.clone();
    }

    public PointAndPath getSimpleFeedbackPoint() {
        PointAndPath retval = new PointAndPath();
        this.setupFeedbackPoint(retval);
        return retval;
    }

    public PointAndPath getPointForInboundDirectToCore(boolean comingFromTop) {
        PointAndPath retval = new PointAndPath();
        this.inboundDirectToCore(retval, comingFromTop);
        return retval;
    }

    public PointAndPath getLastPointForInbound(boolean direct, int rowNum, int colNum, int padNum, String nodeID, String linkID, int linkSign, boolean comingFromTop) {
        TrackedGrid.RCTrack lastLoc;
        TrackedGrid.TrackPosRC posForRow;
        PointAndPath retval = new PointAndPath();
        Integer farLeftKey = new Integer(-1);
        double fractionalRowNum = direct ? (double)rowNum + 0.5 : (double)rowNum;
        Double rowNumObj = new Double(fractionalRowNum);
        TreeMap<Integer, Object> perRow = (TreeMap<Integer, Object>)this.posPerRow_.get(rowNumObj);
        TrackedGrid.TrackPosRC posForRowCol = null;
        TrackedGrid.RCTrack rowLoc = null;
        if (perRow == null) {
            boolean wasNoRows = this.posPerRow_.isEmpty();
            double lastRow = wasNoRows ? Double.NEGATIVE_INFINITY : (Double)(comingFromTop ? this.posPerRow_.lastKey() : this.posPerRow_.firstKey());
            perRow = new TreeMap<Integer, Object>();
            this.posPerRow_.put(rowNumObj, perRow);
            TrackedGrid.RCTrack colTrack = this.rootPos_.getRCTrack();
            if (!direct) {
                TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(rowNum, this.srcID_);
                rowLoc = this.grid_.buildRCTrack(colTrack, rowSpec, 1);
            } else {
                rowLoc = this.grid_.inheritRCTrackNewRowMidline(colTrack, padNum, nodeID, linkID, true, linkSign, rowNum);
            }
            posForRow = new TrackedGrid.TrackPosRC(rowLoc);
            perRow.put(farLeftKey, posForRow.clone());
            if (wasNoRows) {
                if (!direct || direct && comingFromTop) {
                    retval.path.add(this.rootPos_.clone());
                }
            } else if (lastRow != Double.NEGATIVE_INFINITY) {
                TreeMap perLastRow = (TreeMap)this.posPerRow_.get(new Double(lastRow));
                TrackedGrid.TrackPosRC posForLastRow = (TrackedGrid.TrackPosRC)perLastRow.get(farLeftKey);
                retval.path.add(posForLastRow.clone());
            }
        } else {
            Integer outKey = (Integer)perRow.lastKey();
            posForRow = (TrackedGrid.TrackPosRC)perRow.get(outKey);
            if (colNum == outKey) {
                posForRowCol = posForRow;
            }
        }
        retval.path.add(posForRow.clone());
        if (posForRowCol != null) {
            if (!direct) {
                if (posForRowCol.getRCTrack().getColPadNum() == padNum) {
                    retval.pos = (TrackedGrid.TrackPosRC)posForRowCol.clone();
                    return retval;
                }
            } else if (posForRowCol.getRCTrack().getRowPadNum() == padNum) {
                retval.pos = (TrackedGrid.TrackPosRC)posForRowCol.clone();
                return retval;
            }
        }
        if (!direct) {
            TrackedGrid.TrackSpec rowSpec = posForRow.getRCTrack().getRow();
            lastLoc = this.grid_.buildRCTrackForColMidline(rowSpec, padNum, nodeID, linkID, true, linkSign, Integer.MIN_VALUE);
        } else {
            lastLoc = (TrackedGrid.RCTrack)rowLoc.clone();
        }
        TrackedGrid.TrackPosRC lastPos = new TrackedGrid.TrackPosRC(lastLoc);
        perRow.put(new Integer(colNum), lastPos);
        retval.pos = (TrackedGrid.TrackPosRC)lastPos.clone();
        return retval;
    }

    public PointAndPath hangJumperOffDirectToCore() {
        PointAndPath retval = new PointAndPath();
        DepartureInfo di = this.setupDepartingPoint(retval);
        TrackedGrid.TrackPosRC lastPos = (TrackedGrid.TrackPosRC)this.rightDeparturePerRow_.get(di.useRowNumObj);
        retval.pos = (TrackedGrid.TrackPosRC)lastPos.clone();
        retval.path.clear();
        return retval;
    }

    public void updateLastDepartingPointToCore(TrackedGrid.TrackPosRC newLastPos) {
        PointAndPath retval = new PointAndPath();
        DepartureInfo di = this.setupDepartingPoint(retval);
        this.rightDeparturePerRow_.put(di.useRowNumObj, newLastPos.clone());
    }

    public PointAndPath getDepartingPointToCore(int padNum, String nodeID, String linkID, int linkSign) {
        PointAndPath retval = new PointAndPath();
        DepartureInfo di = this.setupDepartingPoint(retval);
        TrackedGrid.RCTrack lastLoc = this.grid_.inheritRCTrackNewColMidline(di.rowTrack, padNum, nodeID, linkID, true, linkSign, Integer.MIN_VALUE);
        TrackedGrid.TrackPosRC lastPos = new TrackedGrid.TrackPosRC(lastLoc);
        this.rightDeparturePerRow_.put(di.useRowNumObj, lastPos);
        retval.pos = (TrackedGrid.TrackPosRC)lastPos.clone();
        return retval;
    }

    public PointAndPath getDepartingPointToOutbound() {
        PointAndPath retval = new PointAndPath();
        DepartureInfo di = this.setupDepartingPoint(retval);
        int numCol = this.grid_.getNumCols();
        TrackedGrid.TrackSpec colSpec = this.grid_.reserveColumnTrack(numCol, this.srcID_);
        TrackedGrid.RCTrack lastLoc = this.grid_.buildRCTrack(di.rowTrack, colSpec, 0);
        TrackedGrid.TrackPosRC lastPos = new TrackedGrid.TrackPosRC(lastLoc);
        this.rightDeparturePerRow_.put(di.useRowNumObj, lastPos);
        retval.pos = (TrackedGrid.TrackPosRC)lastPos.clone();
        return retval;
    }

    private DepartureInfo setupDepartingPoint(PointAndPath pap) {
        TrackedGrid.TrackSpec colSpec;
        TrackedGrid.RCTrack rowTrack;
        boolean haveARow;
        TreeMap<Integer, Object> perRow;
        TrackedGrid.TrackPosRC usePosForRow = null;
        Double useRowNumObj = null;
        TrackedGrid.TrackPosRC establishedPosForRow = null;
        Double establishedRow = null;
        TrackedGrid.TrackPosRC bottomPosForRow = null;
        Double bottomRow = null;
        Iterator pprkit = this.posPerRow_.keySet().iterator();
        while (pprkit.hasNext()) {
            Double rowNumObj = (Double)pprkit.next();
            boolean keyEven = Math.floor(rowNumObj) == rowNumObj;
            perRow = (TreeMap<Integer, Object>)this.posPerRow_.get(rowNumObj);
            Integer outKey = (Integer)perRow.lastKey();
            if (keyEven) {
                int maybeLast = outKey;
                if (maybeLast >= this.rootCol_) {
                    usePosForRow = (TrackedGrid.TrackPosRC)perRow.get(outKey);
                    useRowNumObj = rowNumObj;
                }
                establishedPosForRow = (TrackedGrid.TrackPosRC)perRow.get(outKey);
                establishedRow = rowNumObj;
            }
            bottomPosForRow = (TrackedGrid.TrackPosRC)perRow.get(outKey);
            bottomRow = rowNumObj;
        }
        boolean bl = haveARow = useRowNumObj != null || establishedRow != null;
        if (haveARow) {
            if (useRowNumObj == null) {
                usePosForRow = establishedPosForRow;
                useRowNumObj = establishedRow;
            }
            pap.path.add(usePosForRow.clone());
            rowTrack = usePosForRow.getRCTrack();
        } else if (bottomRow != null) {
            pap.path.add(bottomPosForRow.clone());
            perRow = new TreeMap<Integer, Object>();
            useRowNumObj = new Double(bottomRow + 0.5);
            this.posPerRow_.put(useRowNumObj, perRow);
            colSpec = this.rootPos_.getRCTrack().getCol();
            TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(useRowNumObj.intValue(), this.srcID_);
            rowTrack = this.grid_.buildRCTrack(rowSpec, colSpec);
            TrackedGrid.TrackPosRC posForRow = new TrackedGrid.TrackPosRC(rowTrack);
            perRow.put(new Integer(this.rootCol_), posForRow.clone());
            pap.path.add(posForRow.clone());
        } else {
            perRow = new TreeMap<Integer, Object>();
            useRowNumObj = new Double(this.rootRow_);
            this.posPerRow_.put(useRowNumObj, perRow);
            colSpec = this.rootPos_.getRCTrack().getCol();
            TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(this.rootRow_, this.srcID_);
            rowTrack = this.grid_.buildRCTrack(rowSpec, colSpec);
            TrackedGrid.TrackPosRC posForRow = new TrackedGrid.TrackPosRC(rowTrack);
            perRow.put(new Integer(this.rootCol_), posForRow.clone());
            pap.path.add(this.rootPos_.clone());
            pap.path.add(posForRow.clone());
        }
        return new DepartureInfo(rowTrack, useRowNumObj);
    }

    private DepartureInfo setupFeedbackPoint(PointAndPath pap) {
        TrackedGrid.RCTrack rowTrack;
        TreeMap perRow;
        Double rowNumObj;
        TrackedGrid.TrackPosRC usePosForRow = null;
        Double useRowNumObj = null;
        Iterator pprkit = this.posPerRow_.keySet().iterator();
        while (pprkit.hasNext() && !((rowNumObj = (Double)pprkit.next()) > (double)this.rootRow_)) {
            perRow = (TreeMap)this.posPerRow_.get(rowNumObj);
            Integer feedKey = (Integer)perRow.firstKey();
            usePosForRow = (TrackedGrid.TrackPosRC)perRow.get(feedKey);
            useRowNumObj = rowNumObj;
        }
        if (useRowNumObj != null) {
            pap.pos = (TrackedGrid.TrackPosRC)usePosForRow.clone();
            rowTrack = usePosForRow.getRCTrack();
        } else {
            perRow = new TreeMap();
            useRowNumObj = new Double(this.rootRow_);
            this.posPerRow_.put(useRowNumObj, perRow);
            TrackedGrid.TrackSpec colSpec = this.rootPos_.getRCTrack().getCol();
            TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(this.rootRow_, this.srcID_);
            rowTrack = this.grid_.buildRCTrack(rowSpec, colSpec);
            TrackedGrid.TrackPosRC posForRow = new TrackedGrid.TrackPosRC(rowTrack);
            perRow.put(new Integer(this.rootCol_), posForRow.clone());
            pap.path.add(this.rootPos_.clone());
            pap.pos = (TrackedGrid.TrackPosRC)posForRow.clone();
        }
        return new DepartureInfo(rowTrack, useRowNumObj);
    }

    private DepartureInfo inboundDirectToCore(PointAndPath pap, boolean comingFromTop) {
        TrackedGrid.RCTrack rowTrack;
        TreeMap perRow;
        Double getKey;
        TrackedGrid.TrackPosRC usePosForRow = null;
        Double useRowNumObj = null;
        Double rootKey = new Double(0.0);
        Double d = getKey = this.posPerRow_.isEmpty() ? rootKey : (Double)this.posPerRow_.lastKey();
        if (Math.floor(getKey) != getKey) {
            getKey = rootKey;
        }
        if ((perRow = (TreeMap)this.posPerRow_.get(getKey)) != null) {
            Integer coreKey = (Integer)perRow.lastKey();
            usePosForRow = (TrackedGrid.TrackPosRC)perRow.get(coreKey);
            useRowNumObj = getKey;
        }
        if (useRowNumObj != null) {
            pap.pos = (TrackedGrid.TrackPosRC)usePosForRow.clone();
            rowTrack = usePosForRow.getRCTrack();
        } else {
            if (!comingFromTop && !this.posPerRow_.isEmpty()) {
                getKey = (Double)this.posPerRow_.firstKey();
                perRow = (TreeMap)this.posPerRow_.get(getKey);
                Integer coreKey = (Integer)perRow.firstKey();
                usePosForRow = (TrackedGrid.TrackPosRC)perRow.get(coreKey);
                pap.path.add(usePosForRow.clone());
            }
            perRow = new TreeMap();
            useRowNumObj = new Double(this.rootRow_);
            this.posPerRow_.put(useRowNumObj, perRow);
            TrackedGrid.RCTrack rootRC = this.rootPos_.getRCTrack();
            TrackedGrid.TrackSpec rowSpec = this.grid_.reserveRowTrack(this.rootRow_, this.srcID_);
            rowTrack = this.grid_.buildRCTrack(rootRC, rowSpec, 1);
            TrackedGrid.TrackPosRC posForRow = new TrackedGrid.TrackPosRC(rowTrack);
            perRow.put(new Integer(this.rootCol_), posForRow.clone());
            pap.path.add(this.rootPos_.clone());
            pap.pos = (TrackedGrid.TrackPosRC)posForRow.clone();
        }
        return new DepartureInfo(rowTrack, useRowNumObj);
    }

    private static class DepartureInfo {
        TrackedGrid.RCTrack rowTrack;
        Double useRowNumObj;

        DepartureInfo(TrackedGrid.RCTrack rowTrack, Double useRowNumObj) {
            this.rowTrack = rowTrack;
            this.useRowNumObj = useRowNumObj;
        }
    }

    public static class PointAndPath {
        public TrackedGrid.TrackPosRC pos;
        public ArrayList path = new ArrayList();

        PointAndPath() {
        }

        public String toString() {
            return "PointAndPath: pos = " + this.pos + " path = " + this.path;
        }
    }
}

