/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.HaloLayoutSetupDialog;
import org.systemsbiology.biotapestry.ui.layouts.MetaClusterPointSource;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayout;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutData;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParamDialog;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class HaloLayout
implements SpecialtyLayout {
    private static final int NON_GENE_SOURCE_PAD_ = 2;
    private static final int FIRST_ROW_PAD_ = 1;
    private static final int MAX_SRC_STACKING_ = 10;
    private static final double SRC_OFFSET_X_ = 160.0;
    private static final double OFFSET_X_ = 250.0;
    private static final double TRACE_OFFSET_X_ = 50.0;
    private static final double PER_TRACE_ = 30.0;
    private static final int MIN_TRACE_DIFF_ = 3;
    private static final double VERTICAL_CLUSTER_PAD_ = 40.0;
    private static final int SELECTED_START_ = 0;
    private static final int GREEDY_START_ = 1;
    private static final int MEDIAN_START_ = 2;
    private static final int NUM_STARTS_ = 3;
    private static final String SELECTED_START_TAG_ = "selectedStart";
    private static final String GREEDY_START_TAG_ = "greedyStart";
    private static final String MEDIAN_START_TAG_ = "medianStart";
    private SpecialtyLayoutData sld_;
    private HashMap geneSrcToTraceNumberPerClusterRun_;
    private HashMap nonGeneSrcToTraceNumberPerClusterRun_;
    private HashMap geneSrcToClusters_;
    private HashMap nonGeneSrcToClusters_;
    private HashMap clusterRunStarts_;
    private HashMap clusterRunSpecialPads_;
    private HashMap clusterToClusterRunNumber_;
    private HashMap sourceToTrace_;
    private Point2D traceBoundary_;
    private List termClusters_;
    private Set geneSources_;
    private Set nonGeneSources_;

    public SpecialtyLayout forkForSubset(SpecialtyLayoutData sld) {
        HaloLayout retval = new HaloLayout();
        retval.sld_ = sld;
        return retval;
    }

    public String setUpIsOK() {
        return null;
    }

    public String getMenuName() {
        return ResourceManager.getManager().getString("command.HaloLayout");
    }

    public char getMenuMnemonic() {
        return ResourceManager.getManager().getChar("command.HaloLayoutMnem");
    }

    public boolean selectionIsValid(Genome genome, String selected) {
        Set geneSources = this.findGeneSources(genome);
        return geneSources.contains(selected);
    }

    public int topologyIsHandled(Genome genome) {
        GenomeSubset subset = new GenomeSubset(genome.getID(), (Point2D)new Point2D.Double());
        List termClusters = GeneAndSatelliteCluster.findTerminalTargets(subset, false, 10.0, false);
        GeneAndSatelliteCluster.fillTargetClusters(genome, termClusters, null, null);
        Set gs = this.findGeneSources(genome);
        Set ngs = this.findNonGeneSources(genome);
        HashSet handledNodes = new HashSet();
        int numClust = termClusters.size();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)termClusters.get(i);
            if (!tc.okForHalo(genome)) {
                return 1;
            }
            handledNodes.addAll(tc.allNodesInCluster());
        }
        handledNodes.addAll(gs);
        handledNodes.addAll(ngs);
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            if (handledNodes.contains(node.getID())) continue;
            return 2;
        }
        return 0;
    }

    public void layoutNodes(BTProgressMonitor monitor, Map padChanges, SortedMap existingOrder) throws AsynchExitRequestException {
        String startSrc;
        this.sld_.results = new SpecialtyInstructions(padChanges);
        this.sld_.gASCs = new ArrayList();
        Map placement = this.sld_.results.nodeLocations;
        Map lengthChanges = this.sld_.results.lengthChanges;
        Map extraGrowthChanges = this.sld_.results.extraGrowthChanges;
        this.sld_.results.assignColorsAfterLayout = false;
        HaloLayoutParams hlParams = (HaloLayoutParams)this.sld_.param;
        Genome baseGenome = this.sld_.genome;
        double traceOffset = (double)hlParams.traceMult * 10.0;
        this.termClusters_ = GeneAndSatelliteCluster.findTerminalTargets(this.sld_.subset, false, traceOffset, hlParams.textToo);
        GeneAndSatelliteCluster.fillTargetClusters(baseGenome, this.termClusters_, this.sld_.lo, this.sld_.frc);
        HashMap<String, GeneAndSatelliteCluster> clusterMap = new HashMap<String, GeneAndSatelliteCluster>();
        int numClust = this.termClusters_.size();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)this.termClusters_.get(i);
            clusterMap.put(tc.getCoreID(), tc);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.geneSources_ = this.findGeneSources(baseGenome);
        this.nonGeneSources_ = this.findNonGeneSources(baseGenome);
        Iterator ngsit = this.nonGeneSources_.iterator();
        while (ngsit.hasNext()) {
            String nonGene = (String)ngsit.next();
            this.calcNonGeneSrcPadChanges(nonGene, baseGenome, padChanges);
        }
        HashMap nonGeneSizeMap = new HashMap();
        this.nonGeneSizes(this.nonGeneSources_, baseGenome, this.sld_.lo, this.sld_.frc, nonGeneSizeMap);
        double traceWidth = (double)this.geneSources_.size() * 50.0;
        Iterator smit = nonGeneSizeMap.values().iterator();
        while (smit.hasNext()) {
            Integer extra = (Integer)smit.next();
            traceWidth += 2.0 * extra.doubleValue() * 50.0;
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.geneSrcToClusters_ = new HashMap();
        this.nonGeneSrcToClusters_ = new HashMap();
        HashSet singletonClusters = new HashSet();
        List rankedSources = this.rankAllSourcesByTargetClusters(this.geneSources_, this.nonGeneSources_, this.termClusters_, this.geneSrcToClusters_, this.nonGeneSrcToClusters_, singletonClusters);
        HashMap allSrcToClusters = new HashMap(this.geneSrcToClusters_);
        allSrcToClusters.putAll(this.nonGeneSrcToClusters_);
        if (allSrcToClusters.isEmpty()) {
            this.sld_.results = null;
            return;
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        int rsNum = rankedSources.size();
        ArrayList<String> remainingSrcs = new ArrayList<String>();
        for (int i = 0; i < rsNum; ++i) {
            TaggedByCount tbc = (TaggedByCount)rankedSources.get(i);
            remainingSrcs.add(tbc.id);
        }
        switch (hlParams.startType) {
            case 1: {
                startSrc = (String)remainingSrcs.get(remainingSrcs.size() - 1);
                break;
            }
            case 2: {
                startSrc = (String)remainingSrcs.get(remainingSrcs.size() / 2);
                break;
            }
            case 0: {
                if (hlParams.selected != null && remainingSrcs.contains(hlParams.selected)) {
                    startSrc = hlParams.selected;
                    break;
                }
                startSrc = (String)remainingSrcs.get(remainingSrcs.size() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        remainingSrcs.remove(startSrc);
        this.clusterToClusterRunNumber_ = new HashMap();
        this.geneSrcToTraceNumberPerClusterRun_ = new HashMap();
        this.nonGeneSrcToTraceNumberPerClusterRun_ = new HashMap();
        this.clusterRunStarts_ = new HashMap();
        this.clusterRunSpecialPads_ = new HashMap();
        int currClustRun = 0;
        List currClusters = (List)allSrcToClusters.get(startSrc);
        ArrayList clustCounts = new ArrayList();
        ArrayList sourceCounts = new ArrayList();
        this.orderInitialTargetClusters(currClusters, allSrcToClusters, clustCounts, sourceCounts);
        this.recordClusterRunNumber(this.clusterToClusterRunNumber_, clustCounts, currClustRun);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        List srcLeads = this.orderInitialSourceLeads(baseGenome, clusterMap, clustCounts, sourceCounts, this.nonGeneSources_);
        int numCurr = currClusters.size();
        for (int i = 0; i < numCurr; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)currClusters.get(i);
            clust.calcPadChanges(this.sld_.subset, srcLeads, padChanges, lengthChanges, extraGrowthChanges);
        }
        this.recordTraceForClusterRun(this.geneSrcToTraceNumberPerClusterRun_, this.nonGeneSrcToTraceNumberPerClusterRun_, srcLeads, currClustRun, this.nonGeneSources_);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.sourceToTrace_ = new HashMap();
        HashMap currentSourceToTrace = new HashMap();
        TreeMap<Integer, String> traceToSource = new TreeMap<Integer, String>();
        Integer firstTrace = new Integer(0);
        this.sourceToTrace_.put(startSrc, firstTrace);
        traceToSource.put(firstTrace, startSrc);
        this.assignSourceTraces(this.sourceToTrace_, traceToSource, currentSourceToTrace, srcLeads, nonGeneSizeMap, currClusters, allSrcToClusters);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        Point2D center = (Point2D)this.sld_.subset.getPreferredCenter().clone();
        UiUtil.forceToGrid(center, 10.0);
        int runNum = this.sourcesInboundToRun(currClusters);
        Point2D.Double runStart = new Point2D.Double();
        Point2D.Double traceStart = new Point2D.Double();
        HashSet<String> srcs = new HashSet<String>();
        for (int i = 0; i < sourceCounts.size(); ++i) {
            String srcID = ((TaggedByCount)sourceCounts.get((int)i)).id;
            if (!this.geneSources_.contains(srcID)) continue;
            srcs.add(srcID);
        }
        HashMap specialTracePads = new HashMap();
        this.clusterRunSpecialPads_.put(new Integer(0), specialTracePads);
        HashMap srcLocs = new HashMap();
        this.tracePaddingFromSources(srcs, 0, this.geneSrcToTraceNumberPerClusterRun_, specialTracePads, srcLocs);
        this.placeTargetClusters(center, clustCounts, 0, clusterMap, this.clusterRunSpecialPads_, runNum, baseGenome, this.sld_.lo, this.sld_.frc, placement, runStart, traceStart);
        this.clusterRunStarts_.put(new Integer(0), traceStart);
        this.traceBoundary_ = (Point2D)traceStart.clone();
        this.placeSources(srcs, 0, runStart, traceWidth, this.geneSrcToTraceNumberPerClusterRun_, this.clusterRunStarts_, srcLocs, this.clusterRunSpecialPads_, baseGenome, this.sld_.lo, this.sld_.frc, placement);
        this.placeNonGeneSources(center, this.traceBoundary_, this.nonGeneSrcToTraceNumberPerClusterRun_, this.sourceToTrace_, placement);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        Map remainingClusters = this.tossPlacedClusters(currClusters, allSrcToClusters);
        int currTrace = 1;
        ++currClustRun;
        while (!remainingClusters.isEmpty()) {
            Integer maxTrace = (Integer)traceToSource.lastKey();
            String currSource = null;
            if (maxTrace >= currTrace) {
                currSource = (String)traceToSource.get(new Integer(currTrace));
            } else {
                switch (hlParams.startType) {
                    case 1: {
                        currSource = (String)remainingSrcs.get(remainingSrcs.size() - 1);
                        break;
                    }
                    case 0: 
                    case 2: {
                        currSource = (String)remainingSrcs.get(remainingSrcs.size() / 2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            remainingSrcs.remove(currSource);
            List nextClusters = (List)remainingClusters.get(currSource);
            if (nextClusters != null && !nextClusters.isEmpty()) {
                srcLeads = this.orderNewSources(nextClusters, remainingClusters, this.sourceToTrace_);
                srcs.clear();
                srcs.addAll(srcLeads);
                srcs.removeAll(this.nonGeneSources_);
                this.assignSourceTraces(this.sourceToTrace_, traceToSource, currentSourceToTrace, srcLeads, nonGeneSizeMap, nextClusters, remainingClusters);
                clustCounts = new ArrayList();
                sourceCounts = new ArrayList();
                this.orderFollowingTargetClusters(nextClusters, remainingClusters, currentSourceToTrace, clustCounts);
                this.recordClusterRunNumber(this.clusterToClusterRunNumber_, clustCounts, currClustRun);
                srcLeads = this.orderFollowingSourceLeads(baseGenome, clusterMap, clustCounts, this.nonGeneSources_);
                int numNext = nextClusters.size();
                for (int i = 0; i < numNext; ++i) {
                    GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)nextClusters.get(i);
                    clust.calcPadChanges(this.sld_.subset, srcLeads, padChanges, lengthChanges, extraGrowthChanges);
                }
                this.recordTraceForClusterRun(this.geneSrcToTraceNumberPerClusterRun_, this.nonGeneSrcToTraceNumberPerClusterRun_, srcLeads, currClustRun, this.nonGeneSources_);
                runNum = this.sourcesInboundToRun(nextClusters);
                specialTracePads = new HashMap();
                Integer ccRunObj = new Integer(currClustRun);
                this.clusterRunSpecialPads_.put(ccRunObj, specialTracePads);
                srcLocs.clear();
                this.tracePaddingFromSources(srcs, currClustRun, this.geneSrcToTraceNumberPerClusterRun_, specialTracePads, srcLocs);
                Point2D lastRunStart = (Point2D)runStart.clone();
                runStart = new Point2D.Double();
                traceStart = new Point2D.Double();
                this.placeTargetClusters(lastRunStart, clustCounts, currClustRun, clusterMap, this.clusterRunSpecialPads_, runNum, baseGenome, this.sld_.lo, this.sld_.frc, placement, runStart, traceStart);
                this.clusterRunStarts_.put(ccRunObj, traceStart);
                this.placeSources(srcs, currClustRun++, this.traceBoundary_, traceWidth, this.geneSrcToTraceNumberPerClusterRun_, this.clusterRunStarts_, srcLocs, this.clusterRunSpecialPads_, baseGenome, this.sld_.lo, this.sld_.frc, placement);
                this.placeNonGeneSources(center, this.traceBoundary_, this.nonGeneSrcToTraceNumberPerClusterRun_, this.sourceToTrace_, placement);
                if (monitor != null && !monitor.keepGoing()) {
                    throw new AsynchExitRequestException();
                }
                remainingClusters = this.tossPlacedClusters(nextClusters, remainingClusters);
            }
            ++currTrace;
        }
        this.placeSingletonClusters(runStart, singletonClusters, clusterMap, baseGenome, this.sld_.lo, this.sld_.frc, placement);
        if (!traceToSource.isEmpty()) {
            Integer minTrace = (Integer)traceToSource.firstKey();
            Integer maxTrace = (Integer)traceToSource.lastKey();
            double actualWidth = (double)(maxTrace - minTrace) * 50.0;
            double traceFixup = traceWidth - actualWidth - 100.0;
            if (traceFixup != 0.0) {
                Iterator pit = placement.keySet().iterator();
                while (pit.hasNext()) {
                    String src = (String)pit.next();
                    if (!this.geneSources_.contains(src)) continue;
                    Point2D loc = (Point2D)placement.get(src);
                    loc.setLocation(loc.getX() + traceFixup, loc.getY());
                }
            }
        }
        this.sld_.gASCs.addAll(this.termClusters_);
    }

    public void routeLinks(SpecialtyLayoutEngine.GlobalSLEState gsles, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.sld_.results == null) {
            return;
        }
        Iterator sit = this.geneSrcToClusters_.keySet().iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            SpecialtyLayoutLinkData spec = this.buildLinkSegmentsToClusters(srcID, this.geneSrcToClusters_, this.clusterRunStarts_, this.clusterRunSpecialPads_, this.clusterToClusterRunNumber_, this.geneSrcToTraceNumberPerClusterRun_, this.sourceToTrace_, this.traceBoundary_, this.sld_.genome, this.sld_.lo, this.sld_.frc, this.sld_.results.nodeLocations, this.sld_.results.padChanges);
            this.sld_.results.setLinkPointsForSrc(srcID, spec);
        }
        Iterator ngstcit = this.nonGeneSrcToClusters_.keySet().iterator();
        while (ngstcit.hasNext()) {
            String srcID = (String)ngstcit.next();
            SpecialtyLayoutLinkData spec = this.buildLinkSegmentsToClusters(srcID, this.nonGeneSrcToClusters_, this.clusterRunStarts_, this.clusterRunSpecialPads_, this.clusterToClusterRunNumber_, this.nonGeneSrcToTraceNumberPerClusterRun_, this.sourceToTrace_, this.traceBoundary_, this.sld_.genome, this.sld_.lo, this.sld_.frc, this.sld_.results.nodeLocations, this.sld_.results.padChanges);
            this.sld_.results.setLinkPointsForSrc(srcID, spec);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
    }

    public void assignColors(BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.sld_.results == null) {
            return;
        }
        this.assignColors(this.geneSrcToTraceNumberPerClusterRun_, this.nonGeneSrcToTraceNumberPerClusterRun_, this.sld_.genome, this.termClusters_, this.geneSources_, this.nonGeneSources_, this.sld_.results.nodeLocations, this.sld_.results.nodeColors, this.sld_.results.linkColors);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
    }

    public SpecialtyLayoutEngineParamDialog getParameterDialog(JFrame parent, Genome genome, String selectedID, boolean forSubset) {
        return new HaloLayoutSetupDialog(parent, genome, selectedID, this);
    }

    public String getUndoString() {
        return "undo.haloLayout";
    }

    public static String mapStrategyTypes(int startType) {
        switch (startType) {
            case 0: {
                return SELECTED_START_TAG_;
            }
            case 1: {
                return GREEDY_START_TAG_;
            }
            case 2: {
                return MEDIAN_START_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapStrategyTypeTag(String startTypeTag) {
        if (startTypeTag.equalsIgnoreCase(SELECTED_START_TAG_)) {
            return 0;
        }
        if (startTypeTag.equalsIgnoreCase(GREEDY_START_TAG_)) {
            return 1;
        }
        if (startTypeTag.equalsIgnoreCase(MEDIAN_START_TAG_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getStrategyTypeChoices(boolean haveSelected) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            if (i == 0 && !haveSelected) continue;
            retval.add(HaloLayout.stratTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent stratTypeForCombo(int startType) {
        return new ChoiceContent(ResourceManager.getManager().getString("haloLayout." + HaloLayout.mapStrategyTypes(startType)), startType);
    }

    public static HaloLayoutParams getDefaultParams() {
        HaloLayoutParams retval = new HaloLayoutParams();
        retval.startType = 1;
        retval.selected = null;
        retval.overlayOption = 1;
        retval.traceMult = 2;
        retval.textToo = true;
        return retval;
    }

    private void calcNonGeneSrcPadChanges(String ngSrc, Genome genome, Map padChanges) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String lsource = link.getSource();
            if (!lsource.equals(ngSrc)) continue;
            PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)padChanges.get(link.getID());
            if (pres != null) {
                pres.launch = 2;
                continue;
            }
            pres = new PadCalculatorToo.PadResult(2, link.getLandingPad());
            padChanges.put(link.getID(), pres);
        }
    }

    private void assignColors(Map srcToTraceNumberPerClusterRun, Map nonGeneSrcToTraceNumberPerClusterRun, Genome genome, List clusters, Set geneSources, Set nonGeneSources, Map placement, Map nodeColors, Map linkColors) {
        ArrayList<TaggedByCount> srcTopToBottom = new ArrayList<TaggedByCount>();
        ArrayList<String> junkList = new ArrayList<String>();
        Iterator git = geneSources.iterator();
        while (git.hasNext()) {
            String gene = (String)git.next();
            Point2D ptLoc = (Point2D)placement.get(gene);
            if (ptLoc == null) {
                junkList.add(gene);
                continue;
            }
            TaggedByCount tbc = new TaggedByCount(gene, (int)Math.round(ptLoc.getY()));
            srcTopToBottom.add(tbc);
        }
        Collections.sort(srcTopToBottom);
        if (!srcTopToBottom.isEmpty()) {
            TaggedByCount genetc = (TaggedByCount)srcTopToBottom.get(0);
            int newMin = genetc.count - 1;
            int numJ = junkList.size();
            for (int i = 0; i < numJ; ++i) {
                String gene = (String)junkList.get(i);
                TaggedByCount tbc = new TaggedByCount(gene, newMin);
                srcTopToBottom.add(0, tbc);
            }
        }
        HashMap<String, MinMax> minMaxClustPerSrc = new HashMap<String, MinMax>();
        Iterator sit = srcToTraceNumberPerClusterRun.keySet().iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            MinMax mm = new MinMax(Integer.MAX_VALUE, Integer.MIN_VALUE);
            minMaxClustPerSrc.put(srcID, mm);
            Map perSrc = (Map)srcToTraceNumberPerClusterRun.get(srcID);
            Iterator psit = perSrc.keySet().iterator();
            while (psit.hasNext()) {
                Integer currClust = (Integer)psit.next();
                int clustNum = currClust;
                if (clustNum < mm.min) {
                    mm.min = clustNum;
                }
                if (clustNum <= mm.max) continue;
                mm.max = clustNum;
            }
        }
        Iterator ngsit = nonGeneSrcToTraceNumberPerClusterRun.keySet().iterator();
        while (ngsit.hasNext()) {
            String srcID = (String)ngsit.next();
            MinMax mm = new MinMax(Integer.MAX_VALUE, Integer.MIN_VALUE);
            minMaxClustPerSrc.put(srcID, mm);
            Map perSrc = (Map)nonGeneSrcToTraceNumberPerClusterRun.get(srcID);
            Iterator psit = perSrc.keySet().iterator();
            while (psit.hasNext()) {
                Integer currClust = (Integer)psit.next();
                int clustNum = currClust;
                if (clustNum < mm.min) {
                    mm.min = clustNum;
                }
                if (clustNum <= mm.max) continue;
                mm.max = clustNum;
            }
        }
        Database db = Database.getDB();
        int numCol = db.getNumColors();
        HashMap<String, MinMax> minMaxClustPerColor = new HashMap<String, MinMax>();
        int currCol = 0;
        Iterator ngit = nonGeneSources.iterator();
        while (ngit.hasNext()) {
            String nextCol;
            MinMax mmc;
            String nonGene = (String)ngit.next();
            MinMax mms = (MinMax)minMaxClustPerSrc.get(nonGene);
            if (mms == null) {
                mms = new MinMax(0, 0);
            }
            if ((mmc = (MinMax)minMaxClustPerColor.get(nextCol = db.getGeneColor(currCol))) != null && mms.min <= mmc.max) continue;
            nodeColors.put(nonGene, nextCol);
            minMaxClustPerColor.put(nextCol, mms);
            currCol = (currCol + 1) % numCol;
        }
        int numSrc = srcTopToBottom.size();
        for (int i = 0; i < numSrc; ++i) {
            String nextCol;
            MinMax mmc;
            TaggedByCount gene = (TaggedByCount)srcTopToBottom.get(i);
            String srcID = gene.id;
            MinMax mms = (MinMax)minMaxClustPerSrc.get(srcID);
            if (mms == null) {
                mms = new MinMax(0, 0);
            }
            if ((mmc = (MinMax)minMaxClustPerColor.get(nextCol = db.getGeneColor(currCol))) == null || mms.min > mmc.max) {
                nodeColors.put(srcID, nextCol);
                minMaxClustPerColor.put(nextCol, mms);
                currCol = (currCol + 1) % numCol;
                continue;
            }
            int checkCol = (currCol + 1) % numCol;
            for (int j = 0; j < numCol - 1; ++j) {
                nextCol = db.getGeneColor(checkCol);
                mmc = (MinMax)minMaxClustPerColor.get(nextCol);
                if (mmc == null || mms.min > mmc.max) {
                    nodeColors.put(srcID, nextCol);
                    minMaxClustPerColor.put(nextCol, mms);
                    currCol = (currCol + 1) % numCol;
                    break;
                }
                checkCol = (checkCol + 1) % numCol;
            }
            if (checkCol != currCol) continue;
            nextCol = db.getGeneColor(checkCol);
            nodeColors.put(srcID, nextCol);
            MinMax mmCombo = new MinMax(mmc.min, mms.max);
            minMaxClustPerColor.put(nextCol, mmCombo);
            currCol = (currCol + 1) % numCol;
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String lsource = link.getSource();
            if (!geneSources.contains(lsource) && !nonGeneSources.contains(lsource)) continue;
            String color = (String)nodeColors.get(lsource);
            linkColors.put(link.getID(), color);
        }
        int numClust = clusters.size();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)clusters.get(i);
            tc.colorTheCluster(genome, nodeColors, linkColors);
        }
    }

    private Map tossPlacedClusters(List placedClusters, Map srcToClust) {
        int pnum = placedClusters.size();
        HashMap retval = new HashMap();
        Iterator kit = srcToClust.keySet().iterator();
        while (kit.hasNext()) {
            String srcID = (String)kit.next();
            List oldClusts = (List)srcToClust.get(srcID);
            ArrayList<GeneAndSatelliteCluster> newClusts = new ArrayList<GeneAndSatelliteCluster>();
            int onum = oldClusts.size();
            for (int i = 0; i < onum; ++i) {
                GeneAndSatelliteCluster oldClust = (GeneAndSatelliteCluster)oldClusts.get(i);
                boolean ditch = false;
                for (int j = 0; j < pnum; ++j) {
                    GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)placedClusters.get(j);
                    if (!clust.getCoreID().equals(oldClust.getCoreID())) continue;
                    ditch = true;
                    break;
                }
                if (ditch) continue;
                newClusts.add(oldClust);
            }
            if (newClusts.isEmpty()) continue;
            retval.put(srcID, newClusts);
        }
        return retval;
    }

    private Point2D sourcePos(String srcID, Point2D basePos, Genome genome, Layout lo, FontRenderContext frc) {
        INodeRenderer rend = NodeProperties.chooseRenderer(genome.getNode(srcID).getNodeType(), lo.getLayoutType());
        Node srcNode = genome.getNode(srcID);
        Vector2D offset = rend.getLaunchPadOffset(0, srcNode, lo, frc);
        offset.scale(-1.0);
        Point2D srcLoc = offset.add(basePos);
        UiUtil.forceToGrid(srcLoc.getX(), srcLoc.getY(), srcLoc, 10.0);
        return srcLoc;
    }

    private void nonGeneSizes(Set ngSrcID, Genome genome, Layout lo, FontRenderContext frc, Map sizeMap) {
        Iterator ngit = ngSrcID.iterator();
        while (ngit.hasNext()) {
            String nonGene = (String)ngit.next();
            if (sizeMap.containsKey(nonGene)) continue;
            int size = this.nonGeneSize(nonGene, genome, lo, frc);
            sizeMap.put(nonGene, new Integer(size));
        }
    }

    private int nonGeneSize(String srcID, Genome genome, Layout lo, FontRenderContext frc) {
        INodeRenderer rend = NodeProperties.chooseRenderer(genome.getNode(srcID).getNodeType(), lo.getLayoutType());
        Node srcNode = genome.getNode(srcID);
        Rectangle bounds = rend.getBounds(genome, srcNode, lo, frc, null);
        int numTracks = (int)Math.ceil((double)bounds.width / 2.0 / 50.0);
        return numTracks;
    }

    private void tracePaddingFromSources(Set srcs, int clusterRun, Map srcToTraceNumberPerClusterRun, Map specialTracePads, Map srcLocs) {
        TreeMap<Integer, String> orderedSrcs = new TreeMap<Integer, String>();
        Iterator sit = srcs.iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            Map perSrc = (Map)srcToTraceNumberPerClusterRun.get(srcID);
            Integer traceNum = (Integer)perSrc.get(new Integer(clusterRun));
            orderedSrcs.put(traceNum, srcID);
        }
        boolean first = true;
        int xPos = 0;
        Iterator osit = orderedSrcs.keySet().iterator();
        int lastTraceNum = Integer.MIN_VALUE;
        while (osit.hasNext()) {
            Integer traceNum = (Integer)osit.next();
            String srcID = (String)orderedSrcs.get(traceNum);
            if (first) {
                srcLocs.put(srcID, new Integer(xPos--));
                lastTraceNum = traceNum;
                first = false;
                continue;
            }
            int currTraceNum = traceNum;
            int traceDiff = currTraceNum - lastTraceNum;
            if (traceDiff <= 3) {
                if (-xPos == 10) {
                    xPos = 0;
                    specialTracePads.put(new Integer(currTraceNum - 1), new Integer(4 - traceDiff));
                }
            } else {
                xPos = 0;
            }
            srcLocs.put(srcID, new Integer(xPos--));
            lastTraceNum = currTraceNum;
        }
    }

    private void placeSources(Set srcs, int clusterRun, Point2D basePt, double traceOffset, Map srcToTraceNumberPerClusterRun, Map clusterRunStarts, Map srcLocs, Map clusterRunSpecialPads, Genome genome, Layout lo, FontRenderContext frc, Map placement) {
        double startX = basePt.getX() - traceOffset;
        Integer crObj = new Integer(clusterRun);
        Iterator sit = srcs.iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            Map perSrc = (Map)srcToTraceNumberPerClusterRun.get(srcID);
            Integer traceNum = (Integer)perSrc.get(crObj);
            double runY = this.getClusterRunTraceY(clusterRunStarts, clusterRunSpecialPads, clusterRun, traceNum);
            Integer xOff = (Integer)srcLocs.get(srcID);
            double srcX = startX + xOff.doubleValue() * 160.0;
            Point2D.Double pt = new Point2D.Double(srcX, runY);
            Point2D ptSrc = this.sourcePos(srcID, pt, genome, lo, frc);
            placement.put(srcID, ptSrc);
        }
    }

    private void placeNonGeneSources(Point2D basePt, Point2D traceBoundary, Map nonGeneSrcToTraceNumberPerClusterRun, Map sourceToTrace, Map placement) {
        Iterator sit = nonGeneSrcToTraceNumberPerClusterRun.keySet().iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            Point2D placePt = (Point2D)placement.get(srcID);
            Integer trace = (Integer)sourceToTrace.get(srcID);
            if (placePt != null || trace == null) continue;
            double traceX = this.getMainTraceX(srcID, sourceToTrace, traceBoundary);
            placePt = new Point2D.Double(traceX, basePt.getY());
            placement.put(srcID, placePt);
        }
    }

    private void placeTargetClusters(Point2D startPoint, List clustCounts, int runNum, Map clusterMap, Map clusterRunSpecialPads, int traceCount, Genome genome, Layout lo, FontRenderContext frc, Map placement, Point2D runStart, Point2D traceStart) {
        double startX = startPoint.getX();
        double maxNodeSpace = 10.0;
        int num = clustCounts.size();
        for (int i = 0; i < num; ++i) {
            TaggedByCount tbc = (TaggedByCount)clustCounts.get(i);
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)clusterMap.get(tbc.id);
            GeneAndSatelliteCluster.ClusterDims oh = tc.getClusterDims(genome, lo, frc);
            double needs = oh.getFullHeightIncrement();
            if (!(needs > maxNodeSpace)) continue;
            maxNodeSpace = needs;
        }
        Double maxNodeSpaceObj = new Double(maxNodeSpace);
        double traceY = this.getClusterRunTraceYRequirements(clusterRunSpecialPads, runNum, traceCount);
        traceY += startPoint.getY() + 40.0;
        int tcount = 0;
        for (int i = 0; i < num; ++i) {
            TaggedByCount tbc = (TaggedByCount)clustCounts.get(i);
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)clusterMap.get(tbc.id);
            Point2D.Double base = new Point2D.Double(startX + (double)tcount * 250.0, traceY);
            tc.locateAsTarget(base, placement, genome, lo, frc, maxNodeSpaceObj);
            ++tcount;
        }
        traceStart.setLocation(startX, traceY);
        double startY = traceY + maxNodeSpace;
        runStart.setLocation(startX, startY);
    }

    private void placeSingletonClusters(Point2D startPoint, Set singletonClusters, Map clusterMap, Genome genome, Layout lo, FontRenderContext frc, Map placement) {
        double startX = startPoint.getX();
        TreeSet fixedOrder = new TreeSet(singletonClusters);
        double maxNodeSpace = 10.0;
        Iterator sit = fixedOrder.iterator();
        while (sit.hasNext()) {
            String singID = (String)sit.next();
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)clusterMap.get(singID);
            GeneAndSatelliteCluster.ClusterDims oh = tc.getClusterDims(genome, lo, frc);
            double needs = oh.getFullHeightIncrement();
            if (!(needs > maxNodeSpace)) continue;
            maxNodeSpace = needs;
        }
        Double maxNodeSpaceObj = new Double(maxNodeSpace);
        double startY = startPoint.getY() + 40.0;
        double currX = startX;
        sit = fixedOrder.iterator();
        while (sit.hasNext()) {
            String singID = (String)sit.next();
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)clusterMap.get(singID);
            Point2D.Double base = new Point2D.Double(currX, startY);
            tc.locateAsTarget(base, placement, genome, lo, frc, maxNodeSpaceObj);
            INodeRenderer rend = NodeProperties.chooseRenderer(genome.getNode(singID).getNodeType(), lo.getLayoutType());
            Node singNode = genome.getNode(singID);
            double width = rend.getWidth(genome, singNode, lo, frc);
            int numOff = (int)Math.ceil(width / 250.0);
            currX += (double)numOff * 250.0;
        }
    }

    private Set findGeneSources(Genome genome) {
        HashSet<String> retval = new HashSet<String>();
        Iterator nit = genome.getGeneIterator();
        while (nit.hasNext()) {
            int sc;
            Gene gene = (Gene)nit.next();
            String geneID = gene.getID();
            int tc = genome.getTargetCount(geneID);
            if (tc == 0 || (sc = genome.getSourceCount(geneID)) != 0) continue;
            retval.add(geneID);
        }
        return retval;
    }

    private Set findNonGeneSources(Genome genome) {
        HashSet<String> retval = new HashSet<String>();
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            int sc;
            Node node = (Node)nit.next();
            String nodeID = node.getID();
            int tc = genome.getTargetCount(nodeID);
            if (tc == 0 || (sc = genome.getSourceCount(nodeID)) != 0) continue;
            retval.add(nodeID);
        }
        return retval;
    }

    private List rankAllSourcesByTargetClusters(Set srcGenes, Set srcNonGenes, List allClusters, Map srcToClust, Map nonGeneSrcToClusters, Set singletonClusters) {
        ArrayList<TaggedByCount> retval = new ArrayList<TaggedByCount>();
        int num = allClusters.size();
        singletonClusters.clear();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)allClusters.get(i);
            singletonClusters.add(clust.getCoreID());
        }
        HashSet allSrc = new HashSet(srcGenes);
        allSrc.addAll(srcNonGenes);
        Iterator sit = allSrc.iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            Map targMap = srcNonGenes.contains(srcID) ? nonGeneSrcToClusters : srcToClust;
            TaggedByCount tbc = new TaggedByCount(srcID);
            retval.add(tbc);
            for (int i = 0; i < num; ++i) {
                GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)allClusters.get(i);
                if (!clust.isATarget(srcID)) continue;
                tbc.increment();
                ArrayList<GeneAndSatelliteCluster> clusts = (ArrayList<GeneAndSatelliteCluster>)targMap.get(srcID);
                if (clusts == null) {
                    clusts = new ArrayList<GeneAndSatelliteCluster>();
                    targMap.put(srcID, clusts);
                }
                clusts.add(clust);
                singletonClusters.remove(clust.getCoreID());
            }
        }
        Collections.sort(retval);
        return retval;
    }

    private void orderInitialTargetClusters(List currClusters, Map srcToClust, List clustCounts, List sourceCounts) {
        HashSet<String> runClusts = new HashSet<String>();
        int num = currClusters.size();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)currClusters.get(i);
            runClusts.add(clust.getCoreID());
        }
        HashMap srcToNonCurrClusts = new HashMap();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)currClusters.get(i);
            HashSet<String> clustSet = new HashSet<String>();
            Iterator sit = clust.getInputs().iterator();
            while (sit.hasNext()) {
                String sID = (String)sit.next();
                List clusts = (List)srcToClust.get(sID);
                if (clusts == null) continue;
                int cNum = clusts.size();
                for (int j = 0; j < cNum; ++j) {
                    GeneAndSatelliteCluster oClust = (GeneAndSatelliteCluster)clusts.get(j);
                    HashSet<String> currSrcToNonCurrClust = (HashSet<String>)srcToNonCurrClusts.get(sID);
                    if (currSrcToNonCurrClust == null) {
                        currSrcToNonCurrClust = new HashSet<String>();
                        srcToNonCurrClusts.put(sID, currSrcToNonCurrClust);
                    }
                    if (runClusts.contains(oClust.getCoreID())) continue;
                    currSrcToNonCurrClust.add(oClust.getCoreID());
                    clustSet.add(oClust.getCoreID());
                }
            }
            TaggedByCount tbc = new TaggedByCount(clust.getCoreID(), clustSet.size());
            clustCounts.add(tbc);
        }
        Iterator kit = srcToNonCurrClusts.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            Set nonCurr = (Set)srcToNonCurrClusts.get(key);
            sourceCounts.add(new TaggedByCount(key, nonCurr.size()));
        }
        Collections.sort(clustCounts);
        Collections.sort(sourceCounts);
    }

    private List orderInitialSourceLeads(Genome genome, Map clusterMap, List clustCounts, List sourceCounts, Set nonGeneSources) {
        GeneAndSatelliteCluster tc;
        TaggedByCount tbc;
        int i;
        ArrayList<String> retval = new ArrayList<String>();
        int num = clustCounts.size();
        for (i = num - 1; i >= 0; --i) {
            tbc = (TaggedByCount)clustCounts.get(i);
            tc = (GeneAndSatelliteCluster)clusterMap.get(tbc.id);
            int sNum = sourceCounts.size();
            for (int j = sNum - 1; j >= 0; --j) {
                TaggedByCount stbc = (TaggedByCount)sourceCounts.get(j);
                if (!tc.isATarget(stbc.id) || retval.contains(stbc.id)) continue;
                retval.add(stbc.id);
            }
            Iterator ngsit = nonGeneSources.iterator();
            while (ngsit.hasNext()) {
                String nonGene = (String)ngsit.next();
                if (!tc.isATarget(nonGene) || retval.contains(nonGene)) continue;
                retval.add(nonGene);
            }
        }
        for (i = 0; i < num; ++i) {
            tbc = (TaggedByCount)clustCounts.get(i);
            tc = (GeneAndSatelliteCluster)clusterMap.get(tbc.id);
            tc.orderByTraceOrder(retval, genome);
        }
        return retval;
    }

    private int sourcesInboundToRun(List currClusters) {
        HashSet<String> srcs = new HashSet<String>();
        int num = currClusters.size();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)currClusters.get(i);
            Iterator sit = clust.getInputs().iterator();
            while (sit.hasNext()) {
                String sID = (String)sit.next();
                srcs.add(sID);
            }
        }
        return srcs.size();
    }

    private void assignSourceTraces(Map sourceToTrace, SortedMap traceToSource, Map currentSourceToTrace, List newSources, Map nonGeneSizes, List nextClusters, Map remainingClusters) {
        Integer lastKey = (Integer)traceToSource.lastKey();
        int currTrace = lastKey + 1;
        Map downstreamClusters = this.tossPlacedClusters(nextClusters, remainingClusters);
        Set nonGeneKeys = nonGeneSizes.keySet();
        int num = newSources.size();
        for (int i = 0; i < num; ++i) {
            int traceExtra;
            List lowerRows;
            String src = (String)newSources.get(i);
            currentSourceToTrace.put(src, new Integer(i));
            if (!nonGeneKeys.contains(src) && ((lowerRows = (List)downstreamClusters.get(src)) == null || lowerRows.isEmpty())) continue;
            Integer ngSize = (Integer)nonGeneSizes.get(src);
            int n = traceExtra = ngSize == null ? 0 : ngSize;
            if (traceExtra != 0) {
                Integer lastNonTrace = null;
                Integer lastNonWidth = null;
                Iterator tsit = traceToSource.keySet().iterator();
                while (tsit.hasNext()) {
                    Integer trace = (Integer)tsit.next();
                    String lastSrc = (String)traceToSource.get(trace);
                    if (!nonGeneKeys.contains(lastSrc)) continue;
                    lastNonTrace = trace;
                    lastNonWidth = (Integer)nonGeneSizes.get(lastSrc);
                }
                if (lastNonTrace != null) {
                    int traceDelta = currTrace - lastNonTrace;
                    int needWidth = lastNonWidth + traceExtra;
                    traceExtra = needWidth - traceDelta;
                    if (traceExtra < 0) {
                        traceExtra = 0;
                    }
                }
                currTrace += traceExtra;
            }
            Integer newTrace = new Integer(currTrace);
            sourceToTrace.put(src, newTrace);
            traceToSource.put(newTrace, src);
            currTrace += 1 + traceExtra;
        }
    }

    private List orderNewSources(List currClusters, Map srcToClust, Map sourceToTrace) {
        ArrayList<TaggedByCount> sourceCounts = new ArrayList<TaggedByCount>();
        HashSet<String> runClusts = new HashSet<String>();
        int num = currClusters.size();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)currClusters.get(i);
            runClusts.add(clust.getCoreID());
        }
        HashMap newSrcToNonCurrClusts = new HashMap();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)currClusters.get(i);
            Iterator sit = clust.getInputs().iterator();
            while (sit.hasNext()) {
                List clusts;
                String sID = (String)sit.next();
                if (sourceToTrace.keySet().contains(sID) || (clusts = (List)srcToClust.get(sID)) == null) continue;
                int cNum = clusts.size();
                for (int j = 0; j < cNum; ++j) {
                    GeneAndSatelliteCluster oClust = (GeneAndSatelliteCluster)clusts.get(j);
                    HashSet<String> currSrcToNonCurrClust = (HashSet<String>)newSrcToNonCurrClusts.get(sID);
                    if (currSrcToNonCurrClust == null) {
                        currSrcToNonCurrClust = new HashSet<String>();
                        newSrcToNonCurrClusts.put(sID, currSrcToNonCurrClust);
                    }
                    if (runClusts.contains(oClust.getCoreID())) continue;
                    currSrcToNonCurrClust.add(oClust.getCoreID());
                }
            }
        }
        Iterator kit = newSrcToNonCurrClusts.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            Set nonCurr = (Set)newSrcToNonCurrClusts.get(key);
            sourceCounts.add(new TaggedByCount(key, nonCurr.size()));
        }
        Collections.sort(sourceCounts);
        ArrayList<String> retval = new ArrayList<String>();
        int snum = sourceCounts.size();
        for (int i = snum - 1; i >= 0; --i) {
            TaggedByCount tbc = (TaggedByCount)sourceCounts.get(i);
            retval.add(tbc.id);
        }
        return retval;
    }

    private void orderFollowingTargetClusters(List currClusters, Map srcToClust, Map sourceToTrace, List clustCounts) {
        int num = currClusters.size();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)currClusters.get(i);
            Iterator sit = clust.getInputs().iterator();
            int sum = 0;
            int count = 0;
            while (sit.hasNext()) {
                String sID = (String)sit.next();
                Integer trace = (Integer)sourceToTrace.get(sID);
                if (trace == null) continue;
                sum += trace.intValue();
                ++count;
            }
            clustCounts.add(new TaggedByCount(clust.getCoreID(), (int)Math.round((double)sum / (double)count)));
        }
        Collections.sort(clustCounts);
    }

    private List orderFollowingSourceLeads(Genome genome, Map clusterMap, List clustCounts, Set nonGeneSources) {
        GeneAndSatelliteCluster tc;
        TaggedByCount tbc;
        int i;
        ArrayList<String> retval = new ArrayList<String>();
        int num = clustCounts.size();
        for (i = num - 1; i >= 0; --i) {
            tbc = (TaggedByCount)clustCounts.get(i);
            tc = (GeneAndSatelliteCluster)clusterMap.get(tbc.id);
            Iterator iit = tc.getInputs().iterator();
            while (iit.hasNext()) {
                String srcID = (String)iit.next();
                if (retval.contains(srcID)) continue;
                retval.add(srcID);
            }
            Iterator ngsit = nonGeneSources.iterator();
            while (ngsit.hasNext()) {
                String nonGene = (String)ngsit.next();
                if (!tc.isATarget(nonGene) || retval.contains(nonGene)) continue;
                retval.add(nonGene);
            }
        }
        for (i = 0; i < num; ++i) {
            tbc = (TaggedByCount)clustCounts.get(i);
            tc = (GeneAndSatelliteCluster)clusterMap.get(tbc.id);
            tc.orderByTraceOrder(retval, genome);
        }
        return retval;
    }

    private void recordClusterRunNumber(Map clusterToClusterRunNumber, List clustOrder, int currRun) {
        Integer currRunObj = new Integer(currRun);
        int num = clustOrder.size();
        int i = 0;
        while (i < num) {
            TaggedByCount clust = (TaggedByCount)clustOrder.get(i);
            int[] pos = new int[]{currRun, i++};
            clusterToClusterRunNumber.put(clust.id, pos);
        }
    }

    private void recordTraceForClusterRun(Map srcToTraceNumberPerClusterRun, Map nonGeneSrcToTraceNumberPerClusterRun, List srcLeads, int currRun, Set nonGeneSources) {
        Integer currRunObj = new Integer(currRun);
        int num = srcLeads.size();
        int count = 0;
        for (int i = num - 1; i >= 0; --i) {
            String srcID = (String)srcLeads.get(i);
            Map targMap = nonGeneSources.contains(srcID) ? nonGeneSrcToTraceNumberPerClusterRun : srcToTraceNumberPerClusterRun;
            HashMap<Integer, Integer> perSrc = (HashMap<Integer, Integer>)targMap.get(srcID);
            if (perSrc == null) {
                perSrc = new HashMap<Integer, Integer>();
                targMap.put(srcID, perSrc);
            }
            perSrc.put(currRunObj, new Integer(count++));
        }
    }

    private Double getMainTraceX(String srcID, Map sourceToTrace, Point2D traceBoundary) {
        Integer traceNum = (Integer)sourceToTrace.get(srcID);
        if (traceNum == null) {
            double retval = UiUtil.forceToGridValue(traceBoundary.getX() - 50.0 + 10.0, 10.0);
            return new Double(retval);
        }
        double retval = UiUtil.forceToGridValue(traceBoundary.getX() - traceNum.doubleValue() * 50.0, 10.0);
        return new Double(retval);
    }

    private double getClusterRunTraceYRequirements(Map clusterRunSpecialPads, int runNum, int maxTrace) {
        Integer runObj = new Integer(runNum);
        Map specialPads = (Map)clusterRunSpecialPads.get(runObj);
        int sum = 0;
        for (int i = 0; i < maxTrace; ++i) {
            Integer specPad = (Integer)specialPads.get(new Integer(i));
            if (specPad != null) {
                sum += specPad.intValue();
                continue;
            }
            ++sum;
        }
        return (double)sum * 30.0;
    }

    private double getClusterRunTraceY(Map clusterRunStarts, Map clusterRunSpecialPads, int runNum, int traceNum) {
        Integer runObj = new Integer(runNum);
        Point2D runBase = (Point2D)clusterRunStarts.get(runObj);
        Map specialPads = (Map)clusterRunSpecialPads.get(runObj);
        int sum = 0;
        for (int i = 0; i < traceNum; ++i) {
            Integer specPad = (Integer)specialPads.get(new Integer(i));
            if (specPad != null) {
                sum += specPad.intValue();
                continue;
            }
            ++sum;
        }
        double startY = runBase.getY() - (double)sum * 30.0;
        return startY;
    }

    private SpecialtyLayoutLinkData buildLinkSegmentsToClusters(String srcID, Map srcToClusters, Map clusterRunStarts, Map clusterRunSpecialPads, Map clusterToClusterRunNumber, Map srcToTraceNumberPerClusterRun, Map sourceToTrace, Point2D traceBoundary, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges) {
        SpecialtyLayoutLinkData retval = new SpecialtyLayoutLinkData(srcID);
        Map perSrc = (Map)srcToTraceNumberPerClusterRun.get(srcID);
        Double traceXObj = this.getMainTraceX(srcID, sourceToTrace, traceBoundary);
        double traceX = traceXObj;
        HashMap<String, GeneAndSatelliteCluster> clustMap = new HashMap<String, GeneAndSatelliteCluster>();
        ArrayList<TaggedByPair> ordering = new ArrayList<TaggedByPair>();
        List clusts = (List)srcToClusters.get(srcID);
        int num = clusts.size();
        for (int i = 0; i < num; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)clusts.get(i);
            clustMap.put(clust.getCoreID(), clust);
            int[] pos = (int[])clusterToClusterRunNumber.get(clust.getCoreID());
            if (pos == null) continue;
            TaggedByPair tbp = new TaggedByPair(clust.getCoreID(), pos[0], pos[1]);
            ordering.add(tbp);
        }
        Collections.sort(ordering);
        int onum = ordering.size();
        int currClustRun = Integer.MIN_VALUE;
        double runY = Double.NEGATIVE_INFINITY;
        GeneAndSatelliteCluster.LinkPlacementState lps = new GeneAndSatelliteCluster.LinkPlacementState();
        lps.isRoot = true;
        lps.runPt = null;
        lps.lastAttach = null;
        lps.lastRun = null;
        Point2D runBase = null;
        num = ordering.size();
        for (int i = 0; i < num; ++i) {
            TaggedByPair clust = (TaggedByPair)ordering.get(i);
            GeneAndSatelliteCluster cluster = (GeneAndSatelliteCluster)clustMap.get(clust.id);
            lps.isRunStart = false;
            if (currClustRun != clust.val1) {
                currClustRun = clust.val1;
                lps.isRunStart = true;
                Integer traceNum = (Integer)perSrc.get(new Integer(currClustRun));
                runY = this.getClusterRunTraceY(clusterRunStarts, clusterRunSpecialPads, currClustRun, traceNum);
                lps.runPt = new Point2D.Double(traceX, runY);
                runBase = (Point2D)clusterRunStarts.get(new Integer(clust.val1));
            }
            MetaClusterPointSource mcps = new MetaClusterPointSource(srcID, null, 0);
            mcps.setTargetTraceY(runY);
            cluster.finalLinkRouting(srcID, genome, lo, frc, placement, padChanges, mcps, retval, lps);
        }
        return retval;
    }

    private static class TaggedByPair
    implements Comparable {
        String id;
        int val1;
        int val2;

        TaggedByPair(String id) {
            this.id = id;
            this.val1 = 0;
            this.val2 = 0;
        }

        TaggedByPair(String id, int val1, int val2) {
            this.id = id;
            this.val1 = val1;
            this.val2 = val2;
        }

        public int compareTo(Object o) {
            TaggedByPair other = (TaggedByPair)o;
            int diff1 = this.val1 - other.val1;
            if (diff1 != 0) {
                return diff1;
            }
            int diff2 = this.val2 - other.val2;
            if (diff2 != 0) {
                return diff2;
            }
            return this.id.compareTo(other.id);
        }

        public String toString() {
            return "TaggedByPair: " + this.id + " : " + this.val1 + " , " + this.val2;
        }
    }

    private static class TaggedByCount
    implements Comparable {
        String id;
        int count;

        TaggedByCount(String id) {
            this.id = id;
            this.count = 0;
        }

        TaggedByCount(String id, int count) {
            this.id = id;
            this.count = count;
        }

        public int compareTo(Object o) {
            TaggedByCount other = (TaggedByCount)o;
            int diff = this.count - other.count;
            if (diff != 0) {
                return diff;
            }
            return this.id.compareTo(other.id);
        }

        public String toString() {
            return "TaggedByCount: " + this.id + " : " + this.count;
        }

        void increment() {
            ++this.count;
        }
    }

    public static class HaloLayoutParams
    implements SpecialtyLayoutEngineParams,
    Cloneable {
        public int startType;
        public String selected;
        public int overlayOption;
        public int traceMult;
        public boolean textToo;

        public Object clone() {
            try {
                HaloLayoutParams retval = (HaloLayoutParams)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int getOverlayRelayoutOption() {
            return this.overlayOption;
        }
    }
}

