/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.layouts.HaloLayout;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class HaloLayoutSetupPanel
extends JPanel {
    private boolean haveResult_ = false;
    private HaloLayout.HaloLayoutParams params_;
    private JComboBox strategyCombo_;
    private JComboBox overlayOptionCombo_;
    private JFrame parent_;

    public HaloLayoutSetupPanel(JFrame parent, Genome genome, String selectedID, HaloLayout halo, HaloLayout.HaloLayoutParams params) {
        boolean activate;
        this.parent_ = parent;
        this.params_ = (HaloLayout.HaloLayoutParams)params.clone();
        this.params_.selected = selectedID;
        ResourceManager rMan = ResourceManager.getManager();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.params_.selected != null && !halo.selectionIsValid(genome, this.params_.selected)) {
            this.params_.selected = null;
        }
        JLabel strategyLabel = new JLabel(rMan.getString("haloLayout.strategyType"));
        Vector strategyChoices = HaloLayout.getStrategyTypeChoices(this.params_.selected != null);
        this.strategyCombo_ = new JComboBox(strategyChoices);
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)strategyLabel, gbc);
        UiUtil.gbcSet(gbc, 1, 0, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.strategyCombo_, gbc);
        JLabel overlayLabel = new JLabel(rMan.getString("haloLayout.overlayOptions"));
        Vector relayoutChoices = NetOverlayProperties.getRelayoutOptions();
        this.overlayOptionCombo_ = new JComboBox(relayoutChoices);
        boolean bl = activate = genome == null || genome.getNetworkOverlayCount() > 0;
        if (!activate) {
            overlayLabel.setEnabled(false);
            this.overlayOptionCombo_.setEnabled(false);
        }
        UiUtil.gbcSet(gbc, 0, 1, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)overlayLabel, gbc);
        UiUtil.gbcSet(gbc, 1, 1, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.overlayOptionCombo_, gbc);
    }

    public SpecialtyLayoutEngineParams getParams() {
        return this.params_;
    }

    public boolean haveResult() {
        return this.haveResult_;
    }

    public void resetDefaults() {
        this.params_ = HaloLayout.getDefaultParams();
        this.displayProperties();
    }

    public void displayProperties() {
        this.strategyCombo_.setSelectedItem(HaloLayout.stratTypeForCombo(this.params_.startType));
        this.overlayOptionCombo_.setSelectedItem(NetOverlayProperties.relayoutForCombo(this.params_.overlayOption));
    }

    public boolean stashResults(boolean ok) {
        if (ok) {
            this.params_.startType = ((ChoiceContent)this.strategyCombo_.getSelectedItem()).val;
            this.params_.overlayOption = ((ChoiceContent)this.overlayOptionCombo_.getSelectedItem()).val;
            this.haveResult_ = true;
            return true;
        }
        this.params_ = null;
        this.haveResult_ = false;
        return true;
    }
}

