/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutRubberStamper;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.SuperSrcRouterPointSource;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class LayoutFailureTracker {
    public static final double GRID_SIZE = 10.0;
    public static final int GRID_SIZE_INT = 10;
    private static HashMap bordersExits_;
    private static HashMap bordersExitsShifted_;
    private static HashMap linkOrder_;
    private static HashMap exitRoutes_;
    private static HashMap mergeData_;
    private static HashMap ptLists_;
    private static HashMap trunkPoints_;
    private static HashMap leafPoints_;
    private static HashMap postLayoutForSource_;
    private static HashMap recoveryPoints_;
    private static HashMap recoveryTosses_;
    private static boolean enabled_;
    private static StringBuffer buf_;
    private static String glueDone_;
    private static ArrayList failedLinks_;
    private static int passNum_;
    private static int subPassNum_;

    public static void recordRecoveryToss(String srcID, String linkID, LayoutRubberStamper.EdgeMove emov, Point2D point) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String pre = (String)recoveryPoints_.get(srcID);
        if (pre != null) {
            buf_.append(pre);
        }
        buf_.append("Recovery Toss " + srcID + " " + linkID + " " + emov + " " + point);
        buf_.append("\n");
        recoveryTosses_.put(srcID, buf_.toString());
    }

    public static void recordRecoveryTrack(String srcID, String linkID, List points) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String pre = (String)recoveryPoints_.get(srcID);
        if (pre != null) {
            buf_.append(pre);
        } else {
            buf_.append("Recover " + srcID + " " + linkID);
        }
        buf_.append(points.toString());
        buf_.append("\n");
        recoveryPoints_.put(srcID, buf_.toString());
    }

    public static void postLayoutReport(Genome genome, Layout layout, FontRenderContext frc) {
        if (!enabled_) {
            return;
        }
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node aNode = (Node)nit.next();
            String srcID = aNode.getID();
            BusProperties bp = layout.getLinkPropertiesForSource(srcID);
            if (bp == null) continue;
            buf_.setLength(0);
            String pre = (String)postLayoutForSource_.get(srcID);
            if (pre != null) {
                buf_.append(pre);
            } else {
                buf_.append("Full Post Layout for " + srcID + ":\n");
            }
            Set allPts = bp.getAllPointsToLeaves(LinkSegmentID.buildIDForStartDrop());
            if (!allPts.isEmpty()) {
                buf_.append(srcID + ": " + bp.getDepthFirstDebug(genome, layout, frc));
            }
            buf_.append("\n");
            postLayoutForSource_.put(srcID, buf_.toString());
        }
    }

    public static void recordTreeTrunk(SpecialtyLayoutLinkData sin, String linkID, List ptsPerLink) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String srcID = sin.getSrcID();
        String pre = (String)trunkPoints_.get(srcID);
        if (pre != null) {
            buf_.append(pre);
        } else {
            buf_.append("Tree Trunk Record for " + sin.getSrcID() + ":\n");
        }
        buf_.append(linkID);
        buf_.append(": ");
        buf_.append(ptsPerLink.toString());
        buf_.append("\n");
        trunkPoints_.put(srcID, buf_.toString());
    }

    public static void recordTreeLeaf(SpecialtyLayoutLinkData sin, String linkID, List ptsPerLink) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String srcID = sin.getSrcID();
        String pre = (String)leafPoints_.get(srcID);
        if (pre != null) {
            buf_.append(pre);
        } else {
            buf_.append("Tree Leaf Record for " + sin.getSrcID() + ":\n");
        }
        buf_.append(linkID);
        buf_.append(": ");
        buf_.append(ptsPerLink.toString());
        buf_.append("\n");
        leafPoints_.put(srcID, buf_.toString());
    }

    public static void recordBordersAndExits(SuperSrcRouterPointSource ssr, SpecialtyLayoutLinkData sin, int debugPath) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        buf_.append("Borders and exits for " + sin.getSrcID() + " set via branch " + debugPath + "\n");
        LayoutFailureTracker.recordBordersAndExitGuts(sin, bordersExits_);
    }

    private static void recordBordersAndExitGuts(SpecialtyLayoutLinkData sin, Map useMap) {
        int i;
        for (i = 0; i < 6; ++i) {
            SpecialtyLayoutLinkData.PlacedPoint pp = sin.getExitFrameworkForDebug(i);
            buf_.append("Exit  " + i + " = " + pp + "\n");
        }
        for (i = 0; i < 4; ++i) {
            Point2D bp = sin.getBorderPosition(i);
            buf_.append("Border " + i + " = " + bp + "\n");
        }
        useMap.put(sin.getSrcID(), buf_.toString());
    }

    public static void recordLayoutPass(int i, int j) {
        if (!enabled_) {
            return;
        }
        passNum_ = i;
        subPassNum_ = j;
    }

    public static void clearLayoutPass() {
        if (!enabled_) {
            return;
        }
        passNum_ = -1;
        subPassNum_ = -1;
    }

    public static void recordShiftedBordersAndExits(SpecialtyLayoutLinkData sin, Vector2D shift) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        buf_.append("Shifted Borders and exits for " + sin.getSrcID() + " after shift " + shift + "\n");
        LayoutFailureTracker.recordBordersAndExitGuts(sin, bordersExitsShifted_);
    }

    public static void reportFailedLinks(Set failures) {
        if (!enabled_) {
            return;
        }
        failedLinks_.add(failures.toString());
    }

    public static void recordMergeOperation(SpecialtyLayoutLinkData sin, String funcName) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String srcID = sin.getSrcID();
        String pre = (String)mergeData_.get(srcID);
        if (pre != null) {
            buf_.append(pre);
        }
        buf_.append("POST MERGE SpecialtyLayoutLinkData " + srcID + " via " + funcName + ":\n");
        LayoutFailureTracker.linkDataGuts(sin);
        mergeData_.put(srcID, buf_.toString());
    }

    public static void recordPreMergeOperation(SpecialtyLayoutLinkData sin, SpecialtyLayoutLinkData other, String funcName) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String srcID = sin.getSrcID();
        String pre = (String)mergeData_.get(srcID);
        if (pre == null) {
            buf_.append("MERGE DATA FOR " + srcID + ": " + "\n");
        } else {
            buf_.append(pre);
        }
        buf_.append("PRIME MERGE SpecialtyLayoutLinkData " + srcID + " via " + funcName + ":\n");
        LayoutFailureTracker.linkDataGuts(sin);
        buf_.append("OTHER MERGE SpecialtyLayoutLinkData " + other.getSrcID() + " via " + funcName + "\n");
        LayoutFailureTracker.linkDataGuts(other);
        mergeData_.put(srcID, buf_.toString());
    }

    private static void linkDataGuts(SpecialtyLayoutLinkData sin) {
        int numLinks = sin.numLinks();
        for (int j = 0; j < numLinks; ++j) {
            String linkID = sin.getLink(j);
            buf_.append(linkID);
            buf_.append(": ");
            List posList = sin.getPositionList(linkID);
            int numPos = posList.size();
            for (int i = 0; i < numPos; ++i) {
                Point2D pt = ((SpecialtyLayoutLinkData.TrackPos)posList.get(i)).getPoint();
                buf_.append(pt);
                if (i == numPos - 1) continue;
                buf_.append(", ");
            }
            buf_.append("\n");
        }
    }

    public static void reportGluingDone(List placeList) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        buf_.append("Glue phase is complete\n");
        int numSin = placeList.size();
        for (int i = 0; i < numSin; ++i) {
            SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)placeList.get(i);
            buf_.append(sin != null ? sin.getSrcID() : "<no linkData>");
            if (i == numSin - 1) continue;
            buf_.append(", ");
        }
        buf_.append("\n");
        glueDone_ = buf_.toString();
    }

    public static void reportReorder(SpecialtyLayoutLinkData sin) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        buf_.append("Final link order for src " + sin.getSrcID() + ": ");
        int numLinks = sin == null ? 0 : sin.numLinks();
        for (int i = 0; i < numLinks; ++i) {
            String linkID = sin.getLink(i);
            buf_.append(linkID);
            if (i == numLinks - 1) continue;
            buf_.append(", ");
        }
        buf_.append("\n");
        linkOrder_.put(sin.getSrcID(), buf_.toString());
    }

    public static void reportAssembly(String srcID, String linkID, List ptList) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String pre = (String)ptLists_.get(srcID);
        if (pre == null) {
            buf_.append("Placing links for src " + srcID + ": " + "\n");
        } else {
            buf_.append(pre);
        }
        buf_.append("  Point list for link " + linkID + ": ");
        int numPts = ptList.size();
        for (int i = 0; i < numPts; ++i) {
            Point2D pt = ((SpecialtyLayoutLinkData.TrackPos)ptList.get(i)).getPoint();
            buf_.append(pt);
            if (i == numPts - 1) continue;
            buf_.append(", ");
        }
        buf_.append("\n");
        ptLists_.put(srcID, buf_.toString());
    }

    public static void considerFailureReport(String linkID, Point2D reloc, BusProperties bp) {
        if (!enabled_) {
            return;
        }
        if (!bp.getAllTreePoints().contains(reloc)) {
            System.err.println("EMERGENCY fallback placement for linkID: " + linkID + " no attachment for" + reloc);
            System.err.println("pass: " + passNum_ + " subPass: " + subPassNum_);
            LayoutFailureTracker.failureReport(bp);
        }
    }

    public static void forceFailureReport(String linkID, String forceID, BusProperties bp) {
        if (!enabled_) {
            return;
        }
        if (linkID.equals(forceID)) {
            System.err.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            System.err.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            System.err.println("Forced failure report for linkID: " + linkID);
            System.err.println("pass: " + passNum_ + " subPass: " + subPassNum_);
            LayoutFailureTracker.failureReport(bp);
        }
    }

    private static void failureReport(BusProperties bp) {
        System.err.println("****************************************************************");
        System.err.println("Link Layout Failures:");
        for (int i = 0; i < failedLinks_.size(); ++i) {
            String failed = (String)failedLinks_.get(i);
            System.err.println(failed);
        }
        System.err.println("****************************************************************");
        String rct = (String)recoveryTosses_.get(bp.getSourceTag());
        System.err.print(rct);
        System.err.println("****************************************************************");
        String rco = (String)recoveryPoints_.get(bp.getSourceTag());
        System.err.print(rco);
        System.err.println("****************************************************************");
        String ploTxt = (String)postLayoutForSource_.get(bp.getSourceTag());
        System.err.print(ploTxt);
        System.err.println("****************************************************************");
        System.err.println("Current BP: " + bp.getAllPointsToLeaves(LinkSegmentID.buildIDForStartDrop()));
        System.err.println("****************************************************************");
        String trpTxt = (String)trunkPoints_.get(bp.getSourceTag());
        System.err.print(trpTxt);
        System.err.println("****************************************************************");
        String lepTxt = (String)leafPoints_.get(bp.getSourceTag());
        System.err.print(lepTxt);
        System.err.println("****************************************************************");
        String beTxt = (String)bordersExits_.get(bp.getSourceTag());
        System.err.print(beTxt);
        System.err.println("****************************************************************");
        String besTxt = (String)bordersExitsShifted_.get(bp.getSourceTag());
        System.err.print("bs " + besTxt);
        System.err.println("****************************************************************");
        String erTxt = (String)exitRoutes_.get(bp.getSourceTag());
        System.err.print("er " + erTxt);
        System.err.println("****************************************************************");
        String mrgTxt = (String)mergeData_.get(bp.getSourceTag());
        System.err.print("md " + mrgTxt);
        System.err.println("****************************************************************");
        System.err.print(glueDone_);
        System.err.println("****************************************************************");
        String loTxt = (String)linkOrder_.get(bp.getSourceTag());
        System.err.print(loTxt);
        System.err.println("****************************************************************");
        String plTxt = (String)ptLists_.get(bp.getSourceTag());
        System.err.print(plTxt);
        System.err.println("****************************************************************");
    }

    public static void trackRouteNeeds(SpecialtyLayoutLinkData sin, SpecialtyLayoutLinkData.RouteNeeds rn) {
        if (!enabled_) {
            return;
        }
        buf_.setLength(0);
        String srcID = sin.getSrcID();
        String pre = (String)exitRoutes_.get(srcID);
        if (pre == null) {
            buf_.append("Exit route built for " + sin.getSrcID() + ": " + "\n");
        } else {
            buf_.append(pre);
        }
        buf_.append(rn.toString());
        buf_.append("\n");
        exitRoutes_.put(srcID, buf_.toString());
    }

    public static void tracePaths(String msg) {
        if (!enabled_) {
            return;
        }
    }

    private LayoutFailureTracker() {
    }

    static {
        UiUtil.fixMePrintout("Make sure this is disabled for production release!");
        enabled_ = false;
        if (enabled_) {
            buf_ = new StringBuffer();
            bordersExits_ = new HashMap();
            bordersExitsShifted_ = new HashMap();
            mergeData_ = new HashMap();
            exitRoutes_ = new HashMap();
            linkOrder_ = new HashMap();
            trunkPoints_ = new HashMap();
            leafPoints_ = new HashMap();
            ptLists_ = new HashMap();
            postLayoutForSource_ = new HashMap();
            recoveryPoints_ = new HashMap();
            recoveryTosses_ = new HashMap();
            failedLinks_ = new ArrayList();
            passNum_ = -1;
            subPassNum_ = -1;
        }
    }
}

