/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.ui.layouts.SuperSourceCluster;

public class LinkAnnotatedSuper {
    public SuperSourceCluster ssc;
    public HashSet allInputs;
    public HashSet allOutputs;
    public HashSet pastInputs;
    public HashSet immediateInputs;
    public HashSet forwardOutputs;
    public HashSet immediateOutputs;
    public HashSet backwardOutputs;
    public HashSet backwardInputs;
    public HashSet backwardSources;
    public HashSet pureBackwardOutputSources;
    public Map deferredTerminalPaths;
    public int srcRow;
    public int srcCol;
    public HashSet beforeRowSources;
    public HashSet afterRowSources;
    public HashSet beforeRowTargets;
    public HashSet afterRowTargets;

    public LinkAnnotatedSuper(SuperSourceCluster ssc) {
        this.ssc = ssc;
        this.allInputs = new HashSet();
        this.allOutputs = new HashSet();
        this.pastInputs = new HashSet();
        this.immediateInputs = new HashSet();
        this.forwardOutputs = new HashSet();
        this.immediateOutputs = new HashSet();
        this.backwardOutputs = new HashSet();
        this.backwardInputs = new HashSet();
        this.backwardSources = new HashSet();
        this.pureBackwardOutputSources = new HashSet();
        this.beforeRowSources = new HashSet();
        this.afterRowSources = new HashSet();
        this.beforeRowTargets = new HashSet();
        this.afterRowTargets = new HashSet();
    }

    public Set forwardSources(Genome genome) {
        HashSet<String> onlySrcs = new HashSet<String>();
        Iterator foit = this.forwardOutputs.iterator();
        while (foit.hasNext()) {
            String linkID = (String)foit.next();
            Linkage link = genome.getLinkage(linkID);
            onlySrcs.add(link.getSource());
        }
        Iterator ioit = this.immediateOutputs.iterator();
        while (ioit.hasNext()) {
            String linkID = (String)ioit.next();
            Linkage link = genome.getLinkage(linkID);
            onlySrcs.add(link.getSource());
        }
        return onlySrcs;
    }

    public Set backwardSources(Genome genome) {
        HashSet<String> onlySrcs = new HashSet<String>();
        Iterator foit = this.backwardOutputs.iterator();
        while (foit.hasNext()) {
            String linkID = (String)foit.next();
            Linkage link = genome.getLinkage(linkID);
            onlySrcs.add(link.getSource());
        }
        return onlySrcs;
    }
}

