/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.MinMax;

public class LinkBundleSplicer {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int NUM_SIDES = 4;
    private static final int INTERNAL_INIT_HACK_ = 100000;
    private static final int GLUE_HACK_ = 99998;

    public SpliceSolution spliceBundles(SpliceProblem sp, boolean multiBorderSoln) {
        if (sp instanceof RightAngleProblem) {
            RightAngleProblem rap = (RightAngleProblem)sp;
            if (!multiBorderSoln && rap.canConvertToButtEndProblem()) {
                sp = new ButtEndProblem(rap);
            }
        }
        if (sp instanceof ButtEndProblem) {
            if (sp.directOrdering()) {
                return this.spliceDirectOrderedEnds((ButtEndProblem)sp);
            }
            return this.spliceDirectUnorderedEnds((ButtEndProblem)sp);
        }
        return this.spliceRightAngle((RightAngleProblem)sp);
    }

    private boolean doNotBother(int track, SortedMap trackUsage, MultiInstanceKey internalTag) {
        ArrayList trackUses = (ArrayList)trackUsage.get(new Integer(track));
        if (trackUses == null) {
            throw new IllegalStateException();
        }
        Iterator minIt = trackUses.iterator();
        while (minIt.hasNext()) {
            TaggedMinMax tmm = (TaggedMinMax)minIt.next();
            if (tmm.mik.tag.equals(internalTag.tag)) continue;
            return true;
        }
        return false;
    }

    private boolean trackRouteWorks(PerpTask task, TaggedMinMax needed, int perpTrack, boolean isRight) {
        ArrayList<TaggedMinMax> minUses = (ArrayList<TaggedMinMax>)task.trackUsage.get(new Integer(needed.range.min));
        ArrayList<TaggedMinMax> maxUses = (ArrayList<TaggedMinMax>)task.trackUsage.get(new Integer(needed.range.max));
        int internal = task.internalIsMin ? -99998 : 99998;
        MinMax gluePiece = new MinMax().init().update(perpTrack).update(task.start + internal);
        TaggedMinMax minMatch = null;
        TaggedMinMax maxMatch = null;
        boolean glueViaMin = true;
        if (minUses != null) {
            Iterator minIt = minUses.iterator();
            while (minIt.hasNext()) {
                TaggedMinMax tmm = (TaggedMinMax)minIt.next();
                if (tmm.range.intersect(gluePiece) != null && !tmm.mik.tag.equals(needed.mik.tag)) {
                    if (task.antisense) {
                        return false;
                    }
                    glueViaMin = false;
                    break;
                }
                if (!tmm.mik.tag.equals(needed.mik.tag)) continue;
                minMatch = tmm;
            }
        }
        boolean glueViaMax = true;
        if (maxUses != null) {
            Iterator maxIt = maxUses.iterator();
            while (maxIt.hasNext()) {
                TaggedMinMax tmm = (TaggedMinMax)maxIt.next();
                if (tmm.range.intersect(gluePiece) != null && !tmm.mik.tag.equals(needed.mik.tag)) {
                    if (task.antisense) {
                        return false;
                    }
                    glueViaMax = false;
                    break;
                }
                if (!tmm.mik.tag.equals(needed.mik.tag)) continue;
                maxMatch = tmm;
            }
        }
        if (!glueViaMin && !glueViaMax) {
            return false;
        }
        if (minUses == null) {
            minUses = new ArrayList<TaggedMinMax>();
            task.trackUsage.put(new Integer(needed.range.min), minUses);
        }
        if (maxUses == null) {
            maxUses = new ArrayList<TaggedMinMax>();
            task.trackUsage.put(new Integer(needed.range.max), maxUses);
        }
        if (minMatch == null) {
            TaggedMinMax addMin;
            if (task.leftTurnTurnsTowardsMin) {
                addMin = new TaggedMinMax(new MultiInstanceKey(needed.mik.tag, needed.range.min), (MinMax)gluePiece.clone());
                minUses.add(addMin);
            } else {
                addMin = new TaggedMinMax(new MultiInstanceKey(needed.mik.tag, needed.range.min), new MinMax(perpTrack, Integer.MAX_VALUE));
                maxUses.add(addMin);
            }
        } else if (task.leftTurnTurnsTowardsMin) {
            if (!isRight) {
                minMatch.range = minMatch.range.union(gluePiece);
            } else {
                minMatch.range.update(perpTrack);
            }
        } else if (!isRight) {
            minMatch.range.update(perpTrack);
        } else {
            minMatch.range = minMatch.range.union(gluePiece);
        }
        if (maxMatch == null) {
            TaggedMinMax addMax;
            if (task.leftTurnTurnsTowardsMin) {
                addMax = new TaggedMinMax(new MultiInstanceKey(needed.mik.tag, needed.range.max), new MinMax(perpTrack, Integer.MAX_VALUE));
                maxUses.add(addMax);
            } else {
                addMax = new TaggedMinMax(new MultiInstanceKey(needed.mik.tag, needed.range.max), (MinMax)gluePiece.clone());
                maxUses.add(addMax);
            }
        } else if (task.leftTurnTurnsTowardsMin) {
            if (!isRight) {
                maxMatch.range.update(perpTrack);
            } else {
                maxMatch.range = maxMatch.range.union(gluePiece);
            }
        } else if (!isRight) {
            maxMatch.range = maxMatch.range.union(gluePiece);
        } else {
            maxMatch.range.update(perpTrack);
        }
        return true;
    }

    private int getPerpRoute(PerpTask task, TaggedMinMax needed, boolean isRight) {
        Iterator<Object> useIt;
        boolean justReverse;
        int firstKey = task.start;
        int lastKey = task.start;
        int nextKey = task.start;
        if (!task.externalPerpTrackUsage.isEmpty()) {
            firstKey = (Integer)task.externalPerpTrackUsage.firstKey();
            lastKey = (Integer)task.externalPerpTrackUsage.lastKey();
        }
        if (task.exclusive && !task.antisense) {
            if (!task.externalPerpTrackUsage.isEmpty()) {
                nextKey = lastKey + (task.internalIsMin ? 1 : -1);
            }
            if (!this.trackRouteWorks(task, needed, nextKey, isRight)) {
                throw new IllegalStateException();
            }
            ArrayList<TaggedMinMax> uses = new ArrayList<TaggedMinMax>();
            task.externalPerpTrackUsage.put(new Integer(nextKey), uses);
            uses.add(new TaggedMinMax(needed));
            return nextKey;
        }
        int track = isRight ? (task.leftTurnTurnsTowardsMin ? needed.range.max : needed.range.min) : (task.leftTurnTurnsTowardsMin ? needed.range.min : needed.range.max);
        boolean bl = justReverse = task.antisense && this.doNotBother(track, task.trackUsage, needed.mik);
        if (justReverse) {
            TreeSet backwardsSet = task.internalIsMin ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
            backwardsSet.addAll(task.externalPerpTrackUsage.keySet());
            int extraKeyVal = task.internalIsMin ? firstKey - 1 : firstKey + 1;
            backwardsSet.add(new Integer(extraKeyVal));
            useIt = backwardsSet.iterator();
        } else {
            TreeSet<Object> forwardSet = task.internalIsMin ? new TreeSet<Object>() : new TreeSet(Collections.reverseOrder());
            forwardSet.addAll(task.externalPerpTrackUsage.keySet());
            int extraKeyVal = task.internalIsMin ? lastKey + 1 : lastKey - 1;
            forwardSet.add(new Integer(extraKeyVal));
            useIt = forwardSet.iterator();
        }
        while (useIt.hasNext()) {
            Integer perpTrack = (Integer)useIt.next();
            ArrayList<TaggedMinMax> uses = (ArrayList<TaggedMinMax>)task.externalPerpTrackUsage.get(perpTrack);
            boolean slotFound = true;
            if (uses != null) {
                Iterator uit = uses.iterator();
                while (uit.hasNext()) {
                    TaggedMinMax used = (TaggedMinMax)uit.next();
                    if (used.range.intersect(needed.range) == null) continue;
                    slotFound = false;
                    break;
                }
            }
            if (slotFound && this.trackRouteWorks(task, needed, perpTrack, isRight)) {
                if (uses == null) {
                    uses = new ArrayList<TaggedMinMax>();
                    task.externalPerpTrackUsage.put(perpTrack, uses);
                }
                uses.add(new TaggedMinMax(needed));
                return perpTrack;
            }
            nextKey = perpTrack + (task.internalIsMin ? 1 : -1);
        }
        System.err.println("Why did I get key " + nextKey);
        throw new IllegalStateException();
    }

    private SpliceSolution spliceDirectOrderedEnds(ButtEndProblem bep) {
        int solnSide = bep.getSide();
        SpliceSolution retval = new SpliceSolution(solnSide);
        PerpTask task = new PerpTask(solnSide);
        task.initTrackRoutes(bep);
        task.assignTurnDirections(bep);
        int interfaceCoord = bep.getInterfaceCoord();
        task.setupUsage(interfaceCoord);
        task.buildTrackSets(bep);
        Iterator ebit = task.backTracks.iterator();
        while (ebit.hasNext()) {
            Integer externTrackObj = (Integer)ebit.next();
            MultiInstanceKey ebSrcK = (MultiInstanceKey)bep.externalBundle_.get(externTrackObj);
            int trackNum = externTrackObj;
            if (task.straight.contains(ebSrcK)) {
                ArrayList<Point> path = new ArrayList<Point>();
                retval.addPath(ebSrcK, path);
                path.add(task.tracksAreYCoord ? new Point(interfaceCoord, trackNum) : new Point(trackNum, interfaceCoord));
                continue;
            }
            if (task.rightTurns.contains(ebSrcK)) {
                task.routeDirect(bep, externTrackObj, retval, true);
                continue;
            }
            task.leftTracks.add(externTrackObj);
        }
        task.externalPerpTrackUsage.clear();
        Iterator ltit = task.leftTracks.iterator();
        while (ltit.hasNext()) {
            Integer externTrackObj = (Integer)ltit.next();
            task.routeDirect(bep, externTrackObj, retval, false);
        }
        return retval;
    }

    private int checkDirectDirection(ButtEndProblem bep, HashSet recoveryTurns, HashSet partialRecoveryTurnsInternal, HashSet partialRecoveryTurnsExternal, HashSet directTurns, PerpTask task, boolean recoveryIsRight) {
        if (!recoveryIsRight) {
            task.antisense = true;
        }
        task.buildTrackSets(bep);
        recoveryTurns.addAll(recoveryIsRight ? task.rightTurns : task.leftTurns);
        directTurns.addAll(recoveryIsRight ? task.leftTurns : task.rightTurns);
        HashSet ibUses = bep.allInternalTrackVals();
        Iterator rtit = recoveryTurns.iterator();
        block0: while (rtit.hasNext()) {
            MultiInstanceKey srcK = (MultiInstanceKey)rtit.next();
            HashSet internalTracks = (HashSet)bep.internalBundle_.get(srcK.tag);
            if (internalTracks.size() != 1) {
                throw new IllegalStateException();
            }
            Integer targTrack = (Integer)internalTracks.iterator().next();
            MultiInstanceKey ebSrcK = (MultiInstanceKey)bep.externalBundle_.get(targTrack);
            if (ebSrcK == null) {
                partialRecoveryTurnsExternal.add(new MultiInstanceKey(srcK));
                continue;
            }
            Iterator ebtit = bep.externalBundle_.keySet().iterator();
            while (ebtit.hasNext()) {
                Integer chkTrack = (Integer)ebtit.next();
                MultiInstanceKey chkSrcK = (MultiInstanceKey)bep.externalBundle_.get(chkTrack);
                if (!chkSrcK.tag.equals(srcK.tag)) continue;
                if (ibUses.contains(chkTrack)) continue block0;
                partialRecoveryTurnsInternal.add(new MultiInstanceKey(srcK));
                continue block0;
            }
        }
        recoveryTurns.removeAll(partialRecoveryTurnsExternal);
        recoveryTurns.removeAll(partialRecoveryTurnsInternal);
        return recoveryTurns.size();
    }

    private EndRunAnswer guaranteedDetours(ButtEndProblem bep, int indirectSize, boolean recoveryIsRight, PerpTask task) {
        int endRun;
        int endIncrement;
        int leftDetour = (Integer)task.backTracks.first();
        TreeSet forInternalLeftMost = task.leftTurnTurnsTowardsMin ? new TreeSet() : new TreeSet(Collections.reverseOrder());
        forInternalLeftMost.addAll(bep.allInternalTrackVals());
        Integer internalLeftmostObj = (Integer)forInternalLeftMost.first();
        int internalLeftmost = internalLeftmostObj;
        if (task.leftTurnTurnsTowardsMin && internalLeftmost < leftDetour || !task.leftTurnTurnsTowardsMin && internalLeftmost > leftDetour) {
            leftDetour = internalLeftmost;
        }
        int rightDetour = (Integer)task.backTracks.first();
        TreeSet forInternalRightmost = task.leftTurnTurnsTowardsMin ? new TreeSet() : new TreeSet(Collections.reverseOrder());
        forInternalRightmost.addAll(bep.allInternalTrackVals());
        Integer internalRightmostObj = (Integer)forInternalRightmost.last();
        int internalRightmost = internalRightmostObj;
        if (task.leftTurnTurnsTowardsMin && internalRightmost > rightDetour || !task.leftTurnTurnsTowardsMin && internalRightmost < rightDetour) {
            rightDetour = internalRightmost;
        }
        int leftEndIncrement = task.leftTurnTurnsTowardsMin ? 1 : -1;
        int leftMax = leftDetour - leftEndIncrement * indirectSize;
        int rightEndIncrement = task.leftTurnTurnsTowardsMin ? -1 : 1;
        int rightMax = rightDetour - rightEndIncrement * indirectSize;
        if (recoveryIsRight) {
            endIncrement = leftEndIncrement;
            endRun = leftMax;
        } else {
            endIncrement = rightEndIncrement;
            endRun = rightMax;
        }
        HashSet ibUses = new HashSet(bep.allInternalTrackVals());
        HashSet ebKeys = new HashSet(bep.externalBundle_.keySet());
        SortedSet availDetours = new TreeSet<Integer>();
        availDetours.add(new Integer(leftMax));
        availDetours.add(new Integer(rightMax));
        availDetours = DataUtil.fillOutHourly(availDetours);
        availDetours.removeAll(ibUses);
        availDetours.removeAll(ebKeys);
        return new EndRunAnswer(availDetours, endRun, endIncrement, leftDetour, leftEndIncrement, leftMax, rightDetour, rightEndIncrement, rightMax);
    }

    private SpliceSolution spliceDirectUnorderedEnds(ButtEndProblem bep) {
        Integer use;
        MultiInstanceKey ebSrcK;
        PerpTask task;
        boolean recoveryIsRight;
        HashSet directTurns;
        HashSet partialRecoveryTurnsExternal;
        HashSet partialRecoveryTurnsInternal;
        HashSet recoveryTurns;
        int solnSide = bep.getSide();
        SpliceSolution retval = new SpliceSolution(solnSide);
        PerpTask preTask = new PerpTask(solnSide);
        preTask.initTrackRoutes(bep);
        preTask.assignTurnDirections(bep);
        int interfaceCoord = bep.getInterfaceCoord();
        preTask.setupUsage(interfaceCoord);
        HashSet rightRecoveryTurns = new HashSet();
        HashSet rightPartialRecoveryTurnsInternal = new HashSet();
        HashSet rightPartialRecoveryTurnsExternal = new HashSet();
        HashSet rightDirectTurns = new HashSet();
        PerpTask rightTask = (PerpTask)preTask.clone();
        int rightRecoveryCount = this.checkDirectDirection(bep, rightRecoveryTurns, rightPartialRecoveryTurnsInternal, rightPartialRecoveryTurnsExternal, rightDirectTurns, rightTask, true);
        HashSet leftRecoveryTurns = new HashSet();
        HashSet leftPartialRecoveryTurnsInternal = new HashSet();
        HashSet leftPartialRecoveryTurnsExternal = new HashSet();
        HashSet leftDirectTurns = new HashSet();
        PerpTask leftTask = (PerpTask)preTask.clone();
        int leftRecoveryCount = this.checkDirectDirection(bep, leftRecoveryTurns, leftPartialRecoveryTurnsInternal, leftPartialRecoveryTurnsExternal, leftDirectTurns, leftTask, false);
        if (leftRecoveryCount < rightRecoveryCount) {
            recoveryTurns = leftRecoveryTurns;
            partialRecoveryTurnsInternal = leftPartialRecoveryTurnsInternal;
            partialRecoveryTurnsExternal = leftPartialRecoveryTurnsExternal;
            directTurns = leftDirectTurns;
            recoveryIsRight = false;
            task = leftTask;
        } else {
            recoveryTurns = rightRecoveryTurns;
            partialRecoveryTurnsInternal = rightPartialRecoveryTurnsInternal;
            partialRecoveryTurnsExternal = rightPartialRecoveryTurnsExternal;
            directTurns = rightDirectTurns;
            recoveryIsRight = true;
            task = rightTask;
        }
        HashMap<String, Integer> indirAssignS = new HashMap<String, Integer>();
        HashMap<String, Integer> indirRecoveryS = new HashMap<String, Integer>();
        int preAssign = task.start;
        Iterator ebit = task.backTracks.iterator();
        ArrayList<MultiInstanceKey> forMainRecovery = new ArrayList<MultiInstanceKey>();
        ArrayList<MultiInstanceKey> forMainDirects = new ArrayList<MultiInstanceKey>();
        while (ebit.hasNext()) {
            Integer externTrackObj = (Integer)ebit.next();
            ebSrcK = (MultiInstanceKey)bep.externalBundle_.get(externTrackObj);
            if (recoveryTurns.contains(ebSrcK)) {
                indirRecoveryS.put(ebSrcK.tag, new Integer(preAssign));
                preAssign += task.internalIsMin ? 1 : -1;
                forMainRecovery.add(0, ebSrcK);
                continue;
            }
            if (partialRecoveryTurnsInternal.contains(ebSrcK)) {
                indirRecoveryS.put(ebSrcK.tag, new Integer(preAssign));
                preAssign += task.internalIsMin ? 1 : -1;
                forMainRecovery.add(0, ebSrcK);
                continue;
            }
            if (partialRecoveryTurnsExternal.contains(ebSrcK)) {
                forMainRecovery.add(ebSrcK);
                continue;
            }
            if (!directTurns.contains(ebSrcK)) continue;
            forMainDirects.add(0, ebSrcK);
        }
        Iterator fmlit = forMainDirects.iterator();
        while (fmlit.hasNext()) {
            ebSrcK = (MultiInstanceKey)fmlit.next();
            indirAssignS.put(ebSrcK.tag, new Integer(preAssign));
            preAssign += task.internalIsMin ? 1 : -1;
        }
        Iterator fmrit = forMainRecovery.iterator();
        while (fmrit.hasNext()) {
            MultiInstanceKey ebSrcK2 = (MultiInstanceKey)fmrit.next();
            if (partialRecoveryTurnsInternal.contains(ebSrcK2)) continue;
            indirAssignS.put(ebSrcK2.tag, new Integer(preAssign));
            preAssign += task.internalIsMin ? 1 : -1;
        }
        EndRunAnswer era = this.guaranteedDetours(bep, recoveryTurns.size(), recoveryIsRight, task);
        HashMap<MultiInstanceKey, Integer> assignedDetours = new HashMap<MultiInstanceKey, Integer>();
        HashSet detours = new HashSet(era.availDetours);
        task.leftTracks.clear();
        task.leftTracks.addAll(task.backTracks);
        boolean tieBreakBelow = true;
        Iterator dtit = task.leftTracks.iterator();
        while (dtit.hasNext()) {
            int sumI;
            Integer externTrackObj = (Integer)dtit.next();
            MultiInstanceKey ebSrcK3 = (MultiInstanceKey)bep.externalBundle_.get(externTrackObj);
            int trackNum = externTrackObj;
            if (!recoveryTurns.contains(ebSrcK3)) continue;
            int internalTrack = bep.getSingleInternalTrackVal(ebSrcK3);
            Integer useTrackE = DataUtil.closestInt(detours, trackNum, tieBreakBelow);
            int uteVal = useTrackE;
            Integer useTrackI = DataUtil.closestInt(detours, internalTrack, tieBreakBelow);
            int utiVal = useTrackI;
            int sumE = Math.abs(uteVal - trackNum) + Math.abs(uteVal - internalTrack);
            use = sumE < (sumI = Math.abs(utiVal - trackNum) + Math.abs(utiVal - internalTrack)) ? useTrackE : useTrackI;
            detours.remove(use);
            assignedDetours.put(ebSrcK3, use);
        }
        task.leftTracks.clear();
        Iterator btit = task.backTracks.iterator();
        while (btit.hasNext()) {
            int crossTrack;
            Integer crossTrackObj;
            int internalTrack;
            ArrayList<Point> path;
            Integer externTrackObj = (Integer)btit.next();
            MultiInstanceKey ebSrcK4 = (MultiInstanceKey)bep.externalBundle_.get(externTrackObj);
            int trackNum = externTrackObj;
            if (task.straight.contains(ebSrcK4)) {
                path = new ArrayList<Point>();
                retval.addPath(ebSrcK4, path);
                path.add(task.tracksAreYCoord ? new Point(interfaceCoord, trackNum) : new Point(trackNum, interfaceCoord));
                continue;
            }
            if (directTurns.contains(ebSrcK4)) {
                path = new ArrayList();
                retval.addPath(ebSrcK4, path);
                internalTrack = bep.getSingleInternalTrackVal(ebSrcK4);
                crossTrackObj = (Integer)indirAssignS.get(ebSrcK4.tag);
                crossTrack = crossTrackObj;
                path.add(task.tracksAreYCoord ? new Point(crossTrack, internalTrack) : new Point(internalTrack, crossTrack));
                path.add(task.tracksAreYCoord ? new Point(crossTrack, trackNum) : new Point(trackNum, crossTrack));
                continue;
            }
            if (partialRecoveryTurnsInternal.contains(ebSrcK4)) {
                path = new ArrayList();
                retval.addPath(ebSrcK4, path);
                internalTrack = bep.getSingleInternalTrackVal(ebSrcK4);
                Integer recoveryObj = (Integer)indirRecoveryS.get(ebSrcK4.tag);
                int recoveryTrack = recoveryObj;
                path.add(task.tracksAreYCoord ? new Point(recoveryTrack, internalTrack) : new Point(internalTrack, recoveryTrack));
                path.add(task.tracksAreYCoord ? new Point(recoveryTrack, trackNum) : new Point(trackNum, recoveryTrack));
                continue;
            }
            if (partialRecoveryTurnsExternal.contains(ebSrcK4)) {
                path = new ArrayList();
                retval.addPath(ebSrcK4, path);
                internalTrack = bep.getSingleInternalTrackVal(ebSrcK4);
                crossTrackObj = (Integer)indirAssignS.get(ebSrcK4.tag);
                crossTrack = crossTrackObj;
                path.add(task.tracksAreYCoord ? new Point(crossTrack, internalTrack) : new Point(internalTrack, crossTrack));
                path.add(task.tracksAreYCoord ? new Point(crossTrack, trackNum) : new Point(trackNum, crossTrack));
                continue;
            }
            path = new ArrayList();
            retval.addPath(ebSrcK4, path);
            internalTrack = bep.getSingleInternalTrackVal(ebSrcK4);
            crossTrackObj = (Integer)indirAssignS.get(ebSrcK4.tag);
            crossTrack = crossTrackObj;
            Integer recoveryObj = (Integer)indirRecoveryS.get(ebSrcK4.tag);
            int recoveryTrack = recoveryObj;
            use = (Integer)assignedDetours.get(ebSrcK4);
            int useVal = use;
            path.add(task.tracksAreYCoord ? new Point(recoveryTrack, internalTrack) : new Point(internalTrack, recoveryTrack));
            path.add(task.tracksAreYCoord ? new Point(recoveryTrack, useVal) : new Point(useVal, recoveryTrack));
            path.add(task.tracksAreYCoord ? new Point(crossTrack, useVal) : new Point(useVal, crossTrack));
            path.add(task.tracksAreYCoord ? new Point(crossTrack, trackNum) : new Point(trackNum, crossTrack));
        }
        return retval;
    }

    private SpliceSolution spliceRightAngle(RightAngleProblem rap) {
        rap.internalContraints_ = new HashMap();
        Iterator ulflit = rap.internalBundle_.keySet().iterator();
        while (ulflit.hasNext()) {
            String urID = (String)ulflit.next();
            HashSet tracks = (HashSet)rap.internalBundle_.get(urID);
            Iterator trit = tracks.iterator();
            while (trit.hasNext()) {
                Integer track = (Integer)trit.next();
                Integer targCol = (Integer)rap.rightAngleTargTraces_.get(urID);
                rap.internalContraints_.put(track, targCol);
            }
        }
        int solnSide = rap.getSide();
        SpliceSolution retval = new SpliceSolution(solnSide);
        PerpTask task = new PerpTask(solnSide);
        TreeSet useForCurrCalc = new TreeSet(rap.rightAngleTargTraces_.values());
        int currBlockTrack = !task.internalIsMin ? (Integer)useForCurrCalc.first() - 1 : (Integer)useForCurrCalc.last() + 1;
        HashSet<Integer> tracksUsed = new HashSet<Integer>();
        TreeSet<Integer> gottaDetour = new TreeSet<Integer>();
        Iterator trackKit = rap.externalBundle_.keySet().iterator();
        while (trackKit.hasNext()) {
            Integer track = (Integer)trackKit.next();
            int trackNum = track;
            MultiInstanceKey ridK = (MultiInstanceKey)rap.externalBundle_.get(track);
            Integer targetObj = (Integer)rap.rightAngleTargTraces_.get(ridK.tag);
            int target = targetObj;
            if (this.trackIsAvailable(ridK.tag, track, rap, task, target)) {
                ArrayList<Point> path = new ArrayList<Point>();
                retval.addPath(ridK, path);
                path.add(task.tracksAreYCoord ? new Point(target, trackNum) : new Point(trackNum, target));
                tracksUsed.add(track);
                continue;
            }
            gottaDetour.add(track);
        }
        Iterator gdit = gottaDetour.iterator();
        while (gdit.hasNext()) {
            Integer amtObj;
            Integer amtObj2;
            Integer track = (Integer)gdit.next();
            int trackNum = track;
            MultiInstanceKey ridK = (MultiInstanceKey)rap.externalBundle_.get(track);
            Integer targetObj = (Integer)rap.rightAngleTargTraces_.get(ridK.tag);
            int target = targetObj;
            int availMinTrack = trackNum - 1;
            while (!this.trackIsAvailable(ridK.tag, amtObj2 = new Integer(availMinTrack), rap, task, target) || gottaDetour.contains(amtObj2) || tracksUsed.contains(amtObj2)) {
                --availMinTrack;
            }
            int availMaxTrack = trackNum + 1;
            while (!this.trackIsAvailable(ridK.tag, amtObj = new Integer(availMaxTrack), rap, task, target) || gottaDetour.contains(amtObj) || tracksUsed.contains(amtObj)) {
                ++availMaxTrack;
            }
            TreeSet targTracks = new TreeSet((HashSet)rap.internalBundle_.get(ridK.tag));
            Integer minTrg = (Integer)targTracks.first();
            Integer maxTrg = (Integer)targTracks.last();
            int lenViaMax = Math.abs(availMaxTrack - trackNum) + Math.abs(availMaxTrack - maxTrg);
            int lenViaMin = Math.abs(availMinTrack - trackNum) + Math.abs(availMinTrack - minTrg);
            int sign = task.internalIsMin ? 1 : -1;
            ArrayList<Point> path = new ArrayList<Point>();
            retval.addPath(ridK, path);
            if (lenViaMin < lenViaMax) {
                path.add(task.tracksAreYCoord ? new Point(target, availMinTrack) : new Point(availMinTrack, target));
                path.add(task.tracksAreYCoord ? new Point(currBlockTrack, availMinTrack) : new Point(availMinTrack, currBlockTrack));
                path.add(task.tracksAreYCoord ? new Point(currBlockTrack, trackNum) : new Point(trackNum, currBlockTrack));
                currBlockTrack += sign;
                tracksUsed.add(new Integer(availMinTrack));
                continue;
            }
            path.add(task.tracksAreYCoord ? new Point(target, availMaxTrack) : new Point(availMaxTrack, target));
            path.add(task.tracksAreYCoord ? new Point(currBlockTrack, availMaxTrack) : new Point(availMaxTrack, currBlockTrack));
            path.add(task.tracksAreYCoord ? new Point(currBlockTrack, trackNum) : new Point(trackNum, currBlockTrack));
            currBlockTrack += sign;
            tracksUsed.add(new Integer(availMaxTrack));
        }
        return retval;
    }

    private boolean trackIsAvailable(String ebSrc, Integer checkTrack, RightAngleProblem rap, PerpTask task, int target) {
        HashSet tracks;
        Integer backBlock = (Integer)rap.internalContraints_.get(checkTrack);
        if (backBlock == null) {
            return true;
        }
        int bbVal = backBlock;
        if (!task.internalIsMin && bbVal > target || task.internalIsMin && bbVal < target) {
            return true;
        }
        return bbVal == target && (tracks = (HashSet)rap.internalBundle_.get(ebSrc)) != null && tracks.contains(checkTrack);
    }

    private static class MultiInstanceKey {
        String tag;
        int instance;

        MultiInstanceKey(String tag, int instance) {
            this.tag = tag;
            this.instance = instance;
        }

        MultiInstanceKey(MultiInstanceKey other) {
            this.tag = other.tag;
            this.instance = other.instance;
        }

        public String toString() {
            return "MultiInstanceKey " + this.tag + " : " + this.instance;
        }

        public int hashCode() {
            return this.tag.hashCode() + this.instance;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof MultiInstanceKey)) {
                return false;
            }
            MultiInstanceKey omik = (MultiInstanceKey)other;
            if (!this.tag.equals(omik.tag)) {
                return false;
            }
            return this.instance == omik.instance;
        }
    }

    private static class TaggedMinMax {
        MultiInstanceKey mik;
        MinMax range;

        TaggedMinMax(MultiInstanceKey mik, MinMax range) {
            this.mik = new MultiInstanceKey(mik);
            this.range = (MinMax)range.clone();
        }

        TaggedMinMax(TaggedMinMax other) {
            this.mik = new MultiInstanceKey(other.mik);
            this.range = (MinMax)other.range.clone();
        }
    }

    private static class EndRunAnswer {
        SortedSet availDetours;
        int endRun;
        int endIncrement;
        int leftEndIncrement;
        int leftMax;
        int rightEndIncrement;
        int rightMax;
        int leftDetour;
        int rightDetour;

        EndRunAnswer(SortedSet availDetours, int endRun, int endIncrement, int leftDetour, int leftEndIncrement, int leftMax, int rightDetour, int rightEndIncrement, int rightMax) {
            this.availDetours = availDetours;
            this.endRun = endRun;
            this.endIncrement = endIncrement;
            this.leftEndIncrement = leftEndIncrement;
            this.leftMax = leftMax;
            this.rightEndIncrement = rightEndIncrement;
            this.rightMax = rightMax;
            this.leftDetour = leftDetour;
            this.rightDetour = rightDetour;
        }
    }

    private class PerpTask
    implements Cloneable {
        TreeMap externalPerpTrackUsage;
        TreeMap trackUsage;
        int start;
        boolean exclusive;
        boolean antisense;
        boolean internalIsMin;
        boolean leftTurnTurnsTowardsMin;
        boolean tracksAreYCoord;
        HashSet rightTurns;
        HashSet leftTurns;
        HashSet straight;
        TreeSet backTracks;
        TreeSet leftTracks;

        PerpTask(int solnSide) {
            this.leftTurnTurnsTowardsMin = solnSide == 2 || solnSide == 1;
            this.internalIsMin = solnSide == 3 || solnSide == 1;
            this.tracksAreYCoord = solnSide == 2 || solnSide == 3;
            this.antisense = false;
            this.exclusive = true;
            this.rightTurns = new HashSet();
            this.leftTurns = new HashSet();
            this.straight = new HashSet();
        }

        public Object clone() {
            try {
                PerpTask retval = (PerpTask)super.clone();
                retval.externalPerpTrackUsage = new TreeMap();
                Iterator epit = this.externalPerpTrackUsage.keySet().iterator();
                while (epit.hasNext()) {
                    Integer perpTrack = (Integer)epit.next();
                    ArrayList uses = (ArrayList)this.externalPerpTrackUsage.get(perpTrack);
                    ArrayList<TaggedMinMax> retUses = new ArrayList<TaggedMinMax>();
                    retval.externalPerpTrackUsage.put(perpTrack, retUses);
                    Iterator uit = uses.iterator();
                    while (uit.hasNext()) {
                        TaggedMinMax used = (TaggedMinMax)uit.next();
                        TaggedMinMax retTmm = new TaggedMinMax(used);
                        retUses.add(retTmm);
                    }
                }
                retval.trackUsage = new TreeMap();
                Iterator tuit = this.trackUsage.keySet().iterator();
                while (tuit.hasNext()) {
                    Integer ebTrackObj = (Integer)tuit.next();
                    ArrayList uses = (ArrayList)this.trackUsage.get(ebTrackObj);
                    ArrayList<TaggedMinMax> retUses = new ArrayList<TaggedMinMax>();
                    retval.trackUsage.put(ebTrackObj, retUses);
                    Iterator uit = uses.iterator();
                    while (uit.hasNext()) {
                        TaggedMinMax tmm = (TaggedMinMax)uit.next();
                        TaggedMinMax retTmm = new TaggedMinMax(tmm);
                        retUses.add(retTmm);
                    }
                }
                retval.rightTurns = this.rightTurns == null ? null : (HashSet)this.rightTurns.clone();
                retval.leftTurns = this.leftTurns == null ? null : (HashSet)this.leftTurns.clone();
                retval.straight = this.straight == null ? null : (HashSet)this.straight.clone();
                retval.backTracks = this.backTracks == null ? null : (TreeSet)this.backTracks.clone();
                retval.leftTracks = this.leftTracks == null ? null : (TreeSet)this.leftTracks.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        void setupUsage(int interfaceCoord) {
            this.externalPerpTrackUsage = this.internalIsMin ? new TreeMap() : new TreeMap(Collections.reverseOrder());
            this.start = interfaceCoord + (this.internalIsMin ? -1 : 1);
        }

        void initTrackRoutes(ButtEndProblem bep) {
            this.trackUsage = new TreeMap();
            Iterator ibit = bep.internalBundle_.keySet().iterator();
            while (ibit.hasNext()) {
                String internSrc = (String)ibit.next();
                HashSet ibTrackObj = (HashSet)bep.internalBundle_.get(internSrc);
                Iterator ibtoit = ibTrackObj.iterator();
                while (ibtoit.hasNext()) {
                    Integer trackObj = (Integer)ibtoit.next();
                    ArrayList<TaggedMinMax> uses = new ArrayList<TaggedMinMax>();
                    this.trackUsage.put(trackObj, uses);
                    MinMax ismm = this.internalIsMin ? new MinMax(Integer.MIN_VALUE, bep.interfaceCoord_ - 100000) : new MinMax(bep.interfaceCoord_ + 100000, Integer.MAX_VALUE);
                    uses.add(new TaggedMinMax(new MultiInstanceKey(internSrc, trackObj), ismm));
                }
            }
            Iterator ebit = bep.externalBundle_.keySet().iterator();
            while (ebit.hasNext()) {
                Integer ebTrackObj = (Integer)ebit.next();
                MultiInstanceKey extSrcK = (MultiInstanceKey)bep.externalBundle_.get(ebTrackObj);
                ArrayList<TaggedMinMax> uses = (ArrayList<TaggedMinMax>)this.trackUsage.get(ebTrackObj);
                if (uses == null) {
                    uses = new ArrayList<TaggedMinMax>();
                    this.trackUsage.put(ebTrackObj, uses);
                }
                MinMax esmm = this.internalIsMin ? new MinMax(Integer.MAX_VALUE, Integer.MAX_VALUE) : new MinMax(Integer.MIN_VALUE, Integer.MIN_VALUE);
                uses.add(new TaggedMinMax(extSrcK, esmm));
            }
        }

        void assignTurnDirections(ButtEndProblem bep) {
            Iterator ebit = bep.externalBundle_.keySet().iterator();
            while (ebit.hasNext()) {
                int intTrack;
                Integer externTrackObj = (Integer)ebit.next();
                MultiInstanceKey ebSrcK = (MultiInstanceKey)bep.externalBundle_.get(externTrackObj);
                int extTrack = externTrackObj;
                if (extTrack == (intTrack = bep.getSingleInternalTrackVal(ebSrcK))) {
                    this.straight.add(ebSrcK);
                    continue;
                }
                if (this.leftTurnTurnsTowardsMin && extTrack > intTrack || !this.leftTurnTurnsTowardsMin && extTrack < intTrack) {
                    this.leftTurns.add(ebSrcK);
                    continue;
                }
                this.rightTurns.add(ebSrcK);
            }
        }

        void routeDirect(ButtEndProblem bep, Integer externTrackObj, SpliceSolution retval, boolean isRight) {
            MultiInstanceKey ebSrcK = (MultiInstanceKey)bep.externalBundle_.get(externTrackObj);
            int trackNum = externTrackObj;
            ArrayList<Point> path = new ArrayList<Point>();
            retval.addPath(ebSrcK, path);
            int intTrack = bep.getSingleInternalTrackVal(ebSrcK);
            MinMax needed = new MinMax().init().update(intTrack).update(trackNum);
            TaggedMinMax tNeed = new TaggedMinMax(ebSrcK, needed);
            int avail = LinkBundleSplicer.this.getPerpRoute(this, tNeed, isRight);
            path.add(this.tracksAreYCoord ? new Point(avail, intTrack) : new Point(intTrack, avail));
            path.add(this.tracksAreYCoord ? new Point(avail, trackNum) : new Point(trackNum, avail));
        }

        void buildTrackSets(ButtEndProblem bep) {
            if (this.leftTurnTurnsTowardsMin) {
                this.backTracks = this.antisense ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
                this.leftTracks = this.antisense ? new TreeSet() : new TreeSet(Collections.reverseOrder());
            } else {
                this.backTracks = this.antisense ? new TreeSet() : new TreeSet(Collections.reverseOrder());
                this.leftTracks = this.antisense ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
            }
            this.backTracks.addAll(bep.externalBundle_.keySet());
        }
    }

    public static class SpliceSolution {
        private int side_;
        private HashMap pathBySrc_;

        public SpliceSolution(int side) {
            this.side_ = side;
            this.pathBySrc_ = new HashMap();
        }

        public int getSide() {
            return this.side_;
        }

        void addPath(MultiInstanceKey mik, List path) {
            HashMap<Integer, List> perTrace = (HashMap<Integer, List>)this.pathBySrc_.get(mik.tag);
            if (perTrace == null) {
                perTrace = new HashMap<Integer, List>();
                this.pathBySrc_.put(mik.tag, perTrace);
            }
            perTrace.put(new Integer(mik.instance), path);
        }

        public Rectangle2D getBounds() {
            Rectangle2D retval = null;
            Iterator pbsit = this.pathBySrc_.keySet().iterator();
            while (pbsit.hasNext()) {
                String tag = (String)pbsit.next();
                Map pbs = (Map)this.pathBySrc_.get(tag);
                Iterator pbskit = pbs.keySet().iterator();
                while (pbskit.hasNext()) {
                    Integer trk = (Integer)pbskit.next();
                    List path = (List)pbs.get(trk);
                    int pLen = path.size();
                    for (int i = 0; i < pLen; ++i) {
                        Point nextPt = (Point)path.get(i);
                        if (retval == null) {
                            retval = Bounds.initBoundsWithPoint(nextPt);
                            continue;
                        }
                        Bounds.tweakBoundsWithPoint(retval, nextPt);
                    }
                }
            }
            return retval;
        }

        public Map getPaths(String tag) {
            return (HashMap)this.pathBySrc_.get(tag);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            Iterator pbsit = this.pathBySrc_.keySet().iterator();
            while (pbsit.hasNext()) {
                String tag = (String)pbsit.next();
                Map pbs = (Map)this.pathBySrc_.get(tag);
                Iterator pbskit = pbs.keySet().iterator();
                while (pbskit.hasNext()) {
                    Integer trk = (Integer)pbskit.next();
                    List path = (List)pbs.get(trk);
                    buf.append(tag);
                    buf.append(": ");
                    buf.append(trk);
                    buf.append(": ");
                    buf.append(path.toString());
                    buf.append("\n");
                }
            }
            return buf.toString();
        }
    }

    public static class RightAngleProblem
    extends SpliceProblem {
        Map rightAngleTargTraces_ = new HashMap();
        HashMap internalContraints_ = new HashMap();

        public RightAngleProblem(int side) {
            super(side);
        }

        public boolean canConvertToButtEndProblem() {
            Iterator ibit = this.internalBundle_.values().iterator();
            while (ibit.hasNext()) {
                HashSet internalTracks = (HashSet)ibit.next();
                if (internalTracks.size() == 1) continue;
                return false;
            }
            return true;
        }

        public void putTargetTrace(String src, int coord) {
            super.putTargetTrace(src, coord);
            this.rightAngleTargTraces_.put(src, new Integer(coord));
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("*********************LCO\n");
            TreeSet order = new TreeSet(this.internalContraints_.keySet());
            Iterator odit = order.iterator();
            while (odit.hasNext()) {
                Integer r = (Integer)odit.next();
                Integer blo = (Integer)this.internalContraints_.get(r);
                buf.append("***" + r + " -> " + blo + "\n");
            }
            buf.append("*********************URFL\n");
            TreeSet order1 = new TreeSet(this.internalBundle_.keySet());
            Iterator odit1 = order1.iterator();
            while (odit1.hasNext()) {
                String r = (String)odit1.next();
                HashSet blo = (HashSet)this.internalBundle_.get(r);
                buf.append("*** s" + r + " -> " + blo + "\n");
            }
            buf.append("*********************HRB\n");
            TreeSet order2 = new TreeSet(this.externalBundle_.keySet());
            Iterator odit2 = order2.iterator();
            while (odit2.hasNext()) {
                Integer r = (Integer)odit2.next();
                MultiInstanceKey blo = (MultiInstanceKey)this.externalBundle_.get(r);
                buf.append("***" + r + " -> s" + blo + "\n");
            }
            return buf.toString();
        }
    }

    public static class ButtEndProblem
    extends SpliceProblem {
        public ButtEndProblem(int side) {
            super(side);
        }

        public ButtEndProblem(RightAngleProblem rap) {
            super(rap);
        }
    }

    public static abstract class SpliceProblem {
        protected SortedMap externalBundle_;
        protected int side_;
        protected Map internalBundle_;
        protected int interfaceCoord_;

        protected SpliceProblem(SpliceProblem other) {
            this.side_ = other.side_;
            this.externalBundle_ = other.externalBundle_;
            this.internalBundle_ = other.internalBundle_;
            this.interfaceCoord_ = other.interfaceCoord_;
        }

        protected SpliceProblem(int side) {
            this.side_ = side;
            this.externalBundle_ = new TreeMap();
            this.internalBundle_ = new HashMap();
            this.interfaceCoord_ = side == 1 || side == 3 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }

        public boolean wantY() {
            return this.side_ == 2 || this.side_ == 3;
        }

        public int getSide() {
            return this.side_;
        }

        public void putExternalBundle(int coord, String src) {
            this.externalBundle_.put(new Integer(coord), new MultiInstanceKey(src, coord));
        }

        public void setInternalTrack(String src, int coord) {
            HashSet<Integer> forSrc = (HashSet<Integer>)this.internalBundle_.get(src);
            if (forSrc == null) {
                forSrc = new HashSet<Integer>();
                this.internalBundle_.put(src, forSrc);
            }
            forSrc.add(new Integer(coord));
        }

        public void setAdditionalInternalTracks(String src, List coords) {
            HashSet forSrc = (HashSet)this.internalBundle_.get(src);
            if (forSrc == null) {
                forSrc = new HashSet();
                this.internalBundle_.put(src, forSrc);
            }
            forSrc.addAll(coords);
        }

        HashSet allInternalTrackVals() {
            HashSet ibUses = new HashSet();
            Iterator ibit = this.internalBundle_.values().iterator();
            while (ibit.hasNext()) {
                HashSet internalTracks = (HashSet)ibit.next();
                if (internalTracks.size() != 1) {
                    throw new IllegalStateException();
                }
                ibUses.addAll(internalTracks);
            }
            return ibUses;
        }

        int getSingleInternalTrackVal(MultiInstanceKey srcIDK) {
            HashSet internalTracks = (HashSet)this.internalBundle_.get(srcIDK.tag);
            if (internalTracks.size() != 1) {
                throw new IllegalStateException();
            }
            return (Integer)internalTracks.iterator().next();
        }

        protected boolean directOrdering() {
            int lastIbtr = Integer.MIN_VALUE;
            HashSet<String> seenMIK = new HashSet<String>();
            Iterator ebit = this.externalBundle_.values().iterator();
            while (ebit.hasNext()) {
                MultiInstanceKey ebsrck = (MultiInstanceKey)ebit.next();
                HashSet forSrc = (HashSet)this.internalBundle_.get(ebsrck.tag);
                if (forSrc.size() != 1) {
                    return false;
                }
                if (seenMIK.contains(ebsrck.tag)) {
                    return false;
                }
                seenMIK.add(ebsrck.tag);
                Integer ibtr = (Integer)forSrc.iterator().next();
                int currIbtr = ibtr;
                if (currIbtr <= lastIbtr) {
                    return false;
                }
                lastIbtr = currIbtr;
            }
            return true;
        }

        public void updateInterfaceCoord(Rectangle2D rect) {
            int altIC;
            if (this.side_ == 0) {
                int altIC2 = (int)rect.getMinY();
                if (this.interfaceCoord_ > altIC2) {
                    this.interfaceCoord_ = altIC2 - 10;
                }
            } else if (this.side_ == 1 && this.interfaceCoord_ < (altIC = (int)rect.getMaxY())) {
                this.interfaceCoord_ = altIC + 10;
            }
        }

        public void putTargetTrace(String src, int coord) {
            if (this.side_ == 1 || this.side_ == 3) {
                if (coord < this.interfaceCoord_) {
                    this.interfaceCoord_ = coord;
                }
            } else if (coord > this.interfaceCoord_) {
                this.interfaceCoord_ = coord;
            }
        }

        public int getInterfaceCoord() {
            return this.interfaceCoord_;
        }
    }
}

