/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.ui.layouts.LinkBundleSplicer;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class LinkModuleBoundaryBuilder {
    public Map spliceBoundsPerModule(Map spliceSolution) {
        HashMap<String, Rectangle> retval = new HashMap<String, Rectangle>();
        Iterator sskit = spliceSolution.keySet().iterator();
        while (sskit.hasNext()) {
            String modID = (String)sskit.next();
            HashMap solPerBorder = (HashMap)spliceSolution.get(modID);
            retval.put(modID, this.spliceBoundsForAllBorders(solPerBorder));
        }
        return retval;
    }

    public Rectangle spliceBoundsForAllBorders(Map solPerBorder) {
        Rectangle spliceBoundsAllBoarders = null;
        Iterator spbit = solPerBorder.keySet().iterator();
        while (spbit.hasNext()) {
            Integer borderObj = (Integer)spbit.next();
            LinkBundleSplicer.SpliceSolution sSol = (LinkBundleSplicer.SpliceSolution)solPerBorder.get(borderObj);
            Rectangle2D perBound = sSol.getBounds();
            Rectangle rfr2d = UiUtil.rectFromRect2D(perBound);
            if (rfr2d == null) continue;
            if (spliceBoundsAllBoarders == null) {
                spliceBoundsAllBoarders = rfr2d;
                continue;
            }
            Bounds.tweakBounds(spliceBoundsAllBoarders, rfr2d);
        }
        return spliceBoundsAllBoarders;
    }

    public Map nonOverlaySplicePrep(SpecialtyInstructions spSrc, List shiftedCopies, Map alienSources, List forRecoveriesOut) {
        HashMap<String, Point2D[]> borderPtsPerSrc = new HashMap<String, Point2D[]>();
        HashMap<String, List> leftAlignedPerSource = new HashMap<String, List>();
        Iterator stiit = spSrc.getLinkSrcIterator();
        while (stiit.hasNext()) {
            List aligned;
            String srcID = (String)stiit.next();
            SpecialtyLayoutLinkData siSrc = spSrc.getLinkPointsForSrc(srcID);
            Point2D[] pts = this.extractBordersPerNonOverlaySource(siSrc);
            if (pts != null) {
                borderPtsPerSrc.put(srcID, pts);
            }
            if ((aligned = siSrc.getLeftBorderAlignedPositions()) == null) continue;
            leftAlignedPerSource.put(srcID, aligned);
        }
        TreeMap spPerBorder = new TreeMap(new BorderComparator());
        Iterator asit = alienSources.keySet().iterator();
        while (asit.hasNext()) {
            String srcID = (String)asit.next();
            SpecialtyLayoutLinkData siTrg = spSrc.getLinkPointsForSrc(srcID);
            SpecialtyLayoutLinkData siSrc = (SpecialtyLayoutLinkData)alienSources.get(srcID);
            for (int i = 0; i < 4; ++i) {
                this.buildNonOverlayBorderBundle(i, siSrc, siTrg, spPerBorder, true);
            }
        }
        Map forRecovery = (Map)forRecoveriesOut.get(0);
        if (!forRecovery.isEmpty()) {
            Iterator sit = forRecovery.keySet().iterator();
            while (sit.hasNext()) {
                String srcID = (String)sit.next();
                SpecialtyLayoutLinkData si = spSrc.getLinkPointsForSrc(srcID);
                SpecialtyLayoutLinkData recSi = (SpecialtyLayoutLinkData)forRecovery.get(srcID);
                for (int i = 0; i < 4; ++i) {
                    this.buildNonOverlayBorderBundle(i, si, recSi, spPerBorder, false);
                }
            }
        }
        LinkBundleSplicer lbs = new LinkBundleSplicer();
        HashSet<Integer> skipIt = new HashSet<Integer>();
        Iterator rpbit = spPerBorder.keySet().iterator();
        while (rpbit.hasNext()) {
            Integer borderObj = (Integer)rpbit.next();
            LinkBundleSplicer.SpliceProblem sp = (LinkBundleSplicer.SpliceProblem)spPerBorder.get(borderObj);
            if (this.installBorderToSpliceMapGuts(borderPtsPerSrc, leftAlignedPerSource, borderObj, sp)) continue;
            skipIt.add(borderObj);
        }
        HashMap<Integer, LinkBundleSplicer.SpliceSolution> solnPerBorder = new HashMap<Integer, LinkBundleSplicer.SpliceSolution>();
        boolean multiBorderSoln = spPerBorder.size() > 1;
        rpbit = spPerBorder.keySet().iterator();
        while (rpbit.hasNext()) {
            Integer borderObj = (Integer)rpbit.next();
            LinkBundleSplicer.SpliceProblem sp = (LinkBundleSplicer.SpliceProblem)spPerBorder.get(borderObj);
            LinkBundleSplicer.SpliceSolution sSol = lbs.spliceBundles(sp, multiBorderSoln);
            this.tweakPendingSpliceProblems(spPerBorder, borderObj, sSol);
            solnPerBorder.put(borderObj, sSol);
        }
        return solnPerBorder;
    }

    private boolean buildNonOverlayBorderBundle(int border, SpecialtyLayoutLinkData slldSrc, SpecialtyLayoutLinkData slldTrg, SortedMap spPerBorder, boolean srcIsAlien) {
        Point2D pt;
        Point2D point2D = pt = srcIsAlien ? slldSrc.extractForAlienSplice(slldTrg, border) : slldSrc.extractForNonSubSplice(slldTrg, border);
        if (pt != null) {
            LinkBundleSplicer.SpliceProblem sp = this.retrieveNonOverlaySP(border, spPerBorder);
            boolean wantY = sp.wantY();
            String src = slldSrc.getSrcID();
            int coord = (int)(wantY ? pt.getY() : pt.getX());
            sp.putExternalBundle(coord / 10, src);
            return true;
        }
        return false;
    }

    public Map splicePrep(NetModuleLinkExtractor.SubsetAnalysis sa, Map shiftedIMS, List shiftedCopies) {
        NetModuleLinkExtractor.ExtractResultForSource interModForSrc;
        HashMap problemSets = new HashMap();
        HashMap modToBorderPoints = new HashMap();
        HashMap modToLeftAlignedPoints = new HashMap();
        HashSet<String> allKeys = new HashSet<String>();
        HashMap<String, NetModuleLinkExtractor.ExtractResultForSource> resultsAsSource = new HashMap<String, NetModuleLinkExtractor.ExtractResultForSource>();
        HashMap<String, ArrayList<NetModuleLinkExtractor.ExtractResultForTarg>> resultsAsTarget = new HashMap<String, ArrayList<NetModuleLinkExtractor.ExtractResultForTarg>>();
        Iterator stiit = sa.getSrcKeys();
        while (stiit.hasNext()) {
            String modName;
            String srcID = (String)stiit.next();
            NetModuleLinkExtractor.PrimaryAndOthers pao = sa.getModulesForSrcID(srcID);
            interModForSrc = null;
            if (pao.sourceInModule() && (modName = sa.getPrimaryModuleName(pao)) != null) {
                interModForSrc = (NetModuleLinkExtractor.ExtractResultForSource)shiftedIMS.get(modName);
                resultsAsSource.put(modName, interModForSrc);
                allKeys.add(modName);
                Map srcCopyMap = (Map)shiftedCopies.get(sa.getMappedPrimaryModuleIndex(pao));
                SpecialtyLayoutLinkData siSrc = (SpecialtyLayoutLinkData)srcCopyMap.get(srcID);
                if (siSrc != null) {
                    this.extractBordersPerSource(siSrc, srcID, modName, modToBorderPoints);
                    this.extractLeftBorderAlignedPositions(siSrc, srcID, modName, modToLeftAlignedPoints);
                }
            }
            Iterator oit = pao.getTargetModules();
            while (oit.hasNext()) {
                Map placeCopyMap;
                SpecialtyLayoutLinkData siPlace;
                NetModuleLinkExtractor.ExtractResultForTarg interModPath;
                Integer other = (Integer)oit.next();
                String modName2 = sa.getTargetModuleName(pao, other);
                NetModuleLinkExtractor.ExtractResultForTarg extractResultForTarg = interModPath = interModForSrc == null ? null : interModForSrc.getResultForTarg(modName2);
                if (interModPath != null) {
                    ArrayList<NetModuleLinkExtractor.ExtractResultForTarg> targs = (ArrayList<NetModuleLinkExtractor.ExtractResultForTarg>)resultsAsTarget.get(modName2);
                    if (targs == null) {
                        targs = new ArrayList<NetModuleLinkExtractor.ExtractResultForTarg>();
                        resultsAsTarget.put(modName2, targs);
                        allKeys.add(modName2);
                    }
                    targs.add(interModPath);
                }
                if ((siPlace = (SpecialtyLayoutLinkData)(placeCopyMap = (Map)shiftedCopies.get(sa.getMappedTargetModuleIndex(pao, other))).get(srcID)) == null) continue;
                this.extractBordersPerSource(siPlace, srcID, modName2, modToBorderPoints);
                this.extractLeftBorderAlignedPositions(siPlace, srcID, modName2, modToLeftAlignedPoints);
            }
        }
        Iterator akit = allKeys.iterator();
        while (akit.hasNext()) {
            ArrayList targs;
            String modName = (String)akit.next();
            interModForSrc = (NetModuleLinkExtractor.ExtractResultForSource)resultsAsSource.get(modName);
            if (interModForSrc != null) {
                HashMap pointData = new HashMap();
                HashMap vectorData = new HashMap();
                interModForSrc.buildDepartureData(pointData, vectorData);
                Iterator pdit = pointData.keySet().iterator();
                while (pdit.hasNext()) {
                    String treeID = (String)pdit.next();
                    Vector2D dir = (Vector2D)vectorData.get(treeID);
                    this.buildSourceBorderBundle(modName, dir, treeID, pointData, problemSets);
                }
            }
            if ((targs = (ArrayList)resultsAsTarget.get(modName)) == null) continue;
            Iterator trit = targs.iterator();
            while (trit.hasNext()) {
                NetModuleLinkExtractor.ExtractResultForTarg interModForTarg = (NetModuleLinkExtractor.ExtractResultForTarg)trit.next();
                Vector2D termDir = interModForTarg.getTerminalDirection();
                this.buildTargetBorderBundle(modName, termDir, interModForTarg, problemSets);
            }
        }
        HashMap<String, HashMap<Integer, LinkBundleSplicer.SpliceSolution>> retval = new HashMap<String, HashMap<Integer, LinkBundleSplicer.SpliceSolution>>();
        LinkBundleSplicer lbs = new LinkBundleSplicer();
        Iterator psmodit = problemSets.keySet().iterator();
        while (psmodit.hasNext()) {
            boolean multiBorderSoln;
            String modID = (String)psmodit.next();
            TreeMap spPerBorder = (TreeMap)problemSets.get(modID);
            HashSet<Integer> skipIt = new HashSet<Integer>();
            Iterator rpbit = spPerBorder.keySet().iterator();
            while (rpbit.hasNext()) {
                Integer borderObj = (Integer)rpbit.next();
                LinkBundleSplicer.SpliceProblem sp = (LinkBundleSplicer.SpliceProblem)spPerBorder.get(borderObj);
                if (this.installBorderToSpliceMaps(modToBorderPoints, modToLeftAlignedPoints, modID, borderObj, sp)) continue;
                skipIt.add(borderObj);
            }
            rpbit = spPerBorder.keySet().iterator();
            boolean bl = multiBorderSoln = spPerBorder.size() > 1;
            while (rpbit.hasNext()) {
                Integer borderObj = (Integer)rpbit.next();
                if (skipIt.contains(borderObj)) continue;
                LinkBundleSplicer.SpliceProblem sp = (LinkBundleSplicer.SpliceProblem)spPerBorder.get(borderObj);
                LinkBundleSplicer.SpliceSolution sSol = lbs.spliceBundles(sp, multiBorderSoln);
                this.tweakPendingSpliceProblems(spPerBorder, borderObj, sSol);
                HashMap<Integer, LinkBundleSplicer.SpliceSolution> solPerBorder = (HashMap<Integer, LinkBundleSplicer.SpliceSolution>)retval.get(modID);
                if (solPerBorder == null) {
                    solPerBorder = new HashMap<Integer, LinkBundleSplicer.SpliceSolution>();
                    retval.put(modID, solPerBorder);
                }
                solPerBorder.put(borderObj, sSol);
            }
        }
        return retval;
    }

    private void extractBordersPerSource(SpecialtyLayoutLinkData siSrc, String srcID, String modName, Map modToBorderPoints) {
        for (int i = 0; i < 4; ++i) {
            Point2D[] pts;
            Point2D borderPt = siSrc.getBorderPosition(i);
            if (borderPt == null) continue;
            HashMap<String, Point2D[]> bordersPerSource = (HashMap<String, Point2D[]>)modToBorderPoints.get(modName);
            if (bordersPerSource == null) {
                bordersPerSource = new HashMap<String, Point2D[]>();
                modToBorderPoints.put(modName, bordersPerSource);
            }
            if ((pts = (Point2D[])bordersPerSource.get(srcID)) == null) {
                pts = new Point2D[4];
                bordersPerSource.put(srcID, pts);
            }
            pts[i] = borderPt;
        }
    }

    private Point2D[] extractBordersPerNonOverlaySource(SpecialtyLayoutLinkData siSrc) {
        Point2D[] pts = null;
        for (int i = 0; i < 4; ++i) {
            Point2D borderPt = siSrc.getBorderPosition(i);
            if (borderPt == null) continue;
            if (pts == null) {
                pts = new Point2D[4];
            }
            pts[i] = borderPt;
        }
        return pts;
    }

    private void extractLeftBorderAlignedPositions(SpecialtyLayoutLinkData siSrc, String srcID, String modName, Map modToLeftAlignedPoints) {
        List aligned = siSrc.getLeftBorderAlignedPositions();
        HashMap<String, List> alignedPerSource = (HashMap<String, List>)modToLeftAlignedPoints.get(modName);
        if (alignedPerSource == null) {
            alignedPerSource = new HashMap<String, List>();
            modToLeftAlignedPoints.put(modName, alignedPerSource);
        }
        alignedPerSource.put(srcID, aligned);
    }

    private boolean installBorderToSpliceMaps(Map modToBorderPoints, Map modToLeftAlignedPoints, String modName, int border, LinkBundleSplicer.SpliceProblem sp) {
        HashMap bordersPerSource = (HashMap)modToBorderPoints.get(modName);
        HashMap leftAlignedPerSource = border == 2 ? (HashMap)modToLeftAlignedPoints.get(modName) : null;
        return this.installBorderToSpliceMapGuts(bordersPerSource, leftAlignedPerSource, border, sp);
    }

    private boolean installBorderToSpliceMapGuts(HashMap bordersPerSource, HashMap leftAlignedPerSource, int border, LinkBundleSplicer.SpliceProblem sp) {
        ArrayList<Integer> coords;
        Iterator sit = bordersPerSource.keySet().iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            Point2D[] pts = (Point2D[])bordersPerSource.get(srcID);
            Point2D borderPt = pts[border];
            coords = null;
            if (border == 2) {
                coords = new ArrayList<Integer>();
                List aligned = (List)leftAlignedPerSource.get(srcID);
                Iterator ait = aligned.iterator();
                while (ait.hasNext()) {
                    Point2D alignPt = (Point2D)ait.next();
                    coords.add(new Integer((int)alignPt.getY() / 10));
                }
            }
            if (borderPt == null) {
                return false;
            }
            boolean wantY = sp.wantY();
            int coord = (int)(wantY ? borderPt.getX() : borderPt.getY());
            sp.putTargetTrace(srcID, coord / 10);
            coord = (int)(wantY ? borderPt.getY() : borderPt.getX());
            sp.setInternalTrack(srcID, coord / 10);
            if (coords == null) continue;
            sp.setAdditionalInternalTracks(srcID, coords);
        }
        if (border == 2) {
            HashSet seenSrc = new HashSet(bordersPerSource.keySet());
            Iterator lait = leftAlignedPerSource.keySet().iterator();
            while (lait.hasNext()) {
                String srcID = (String)lait.next();
                if (seenSrc.contains(srcID)) continue;
                coords = new ArrayList();
                List aligned = (List)leftAlignedPerSource.get(srcID);
                Iterator ait = aligned.iterator();
                boolean isFirst = true;
                while (ait.hasNext()) {
                    Point2D alignPt = (Point2D)ait.next();
                    if (isFirst) {
                        sp.putTargetTrace(srcID, (int)alignPt.getX() / 10);
                        isFirst = false;
                    }
                    coords.add(new Integer((int)alignPt.getY() / 10));
                }
                sp.setAdditionalInternalTracks(srcID, coords);
            }
        }
        return true;
    }

    private LinkBundleSplicer.SpliceProblem retrieveSP(String modName, int border, Map problemSets) {
        LinkBundleSplicer.SpliceProblem sp;
        Integer borderObj = new Integer(border);
        TreeMap<Integer, LinkBundleSplicer.SpliceProblem> spPerBorder = (TreeMap<Integer, LinkBundleSplicer.SpliceProblem>)problemSets.get(modName);
        if (spPerBorder == null) {
            spPerBorder = new TreeMap<Integer, LinkBundleSplicer.SpliceProblem>(new BorderComparator());
            problemSets.put(modName, spPerBorder);
        }
        if ((sp = (LinkBundleSplicer.SpliceProblem)spPerBorder.get(borderObj)) == null) {
            sp = border == 2 ? new LinkBundleSplicer.RightAngleProblem(SpecialtyLayoutLinkData.borderToSpSide(border)) : new LinkBundleSplicer.ButtEndProblem(SpecialtyLayoutLinkData.borderToSpSide(border));
            spPerBorder.put(borderObj, sp);
        }
        return sp;
    }

    private LinkBundleSplicer.SpliceProblem retrieveNonOverlaySP(int border, SortedMap spPerBorder) {
        Integer borderObj = new Integer(border);
        LinkBundleSplicer.SpliceProblem sp = (LinkBundleSplicer.SpliceProblem)spPerBorder.get(borderObj);
        if (sp == null) {
            sp = border == 2 ? new LinkBundleSplicer.RightAngleProblem(SpecialtyLayoutLinkData.borderToSpSide(border)) : new LinkBundleSplicer.ButtEndProblem(SpecialtyLayoutLinkData.borderToSpSide(border));
            spPerBorder.put(borderObj, sp);
        }
        return sp;
    }

    private void buildSourceBorderBundle(String modName, Vector2D dir, String treeID, Map pointData, Map problemSets) {
        int border = SpecialtyLayoutLinkData.vecToBorder(dir);
        LinkBundleSplicer.SpliceProblem sp = this.retrieveSP(modName, border, problemSets);
        boolean wantY = sp.wantY();
        Map pts = (Map)pointData.get(treeID);
        Iterator pit = pts.keySet().iterator();
        while (pit.hasNext()) {
            String src = (String)pit.next();
            Point2D pt = (Point2D)pts.get(src);
            int coord = (int)(wantY ? pt.getY() : pt.getX());
            sp.putExternalBundle(coord / 10, src);
        }
    }

    private void buildTargetBorderBundle(String modName, Vector2D termDir, NetModuleLinkExtractor.ExtractResultForTarg interModForTarg, Map problemSets) {
        int border = SpecialtyLayoutLinkData.vecToBorder(termDir);
        LinkBundleSplicer.SpliceProblem sp = this.retrieveSP(modName, border, problemSets);
        boolean wantY = sp.wantY();
        Set srcs = interModForTarg.getSourcesToModule();
        Iterator sit = srcs.iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            Point2D pt = interModForTarg.getArrivalPoint(srcID);
            int coord = (int)(wantY ? pt.getY() : pt.getX());
            sp.putExternalBundle(coord / 10, srcID);
        }
    }

    private void tweakPendingSpliceProblems(TreeMap spPerBorder, Integer borderObj, LinkBundleSplicer.SpliceSolution sSol) {
        Integer pasttBorderObj;
        Iterator rpbit = spPerBorder.keySet().iterator();
        while (rpbit.hasNext() && !(pasttBorderObj = (Integer)rpbit.next()).equals(borderObj)) {
        }
        Rectangle2D growth = sSol.getBounds();
        while (rpbit.hasNext()) {
            Integer futureBorderObj = (Integer)rpbit.next();
            if (growth == null) continue;
            LinkBundleSplicer.SpliceProblem futureSp = (LinkBundleSplicer.SpliceProblem)spPerBorder.get(futureBorderObj);
            futureSp.updateInterfaceCoord(growth);
        }
    }

    public static class BorderComparator
    implements Comparator {
        private static HashMap myOrder_ = new HashMap();

        public int compare(Object o1, Object o2) {
            Integer border1 = (Integer)o1;
            Integer border2 = (Integer)o2;
            Integer rank1 = (Integer)myOrder_.get(border1);
            Integer rank2 = (Integer)myOrder_.get(border2);
            return rank1.compareTo(rank2);
        }

        static {
            myOrder_.put(new Integer(2), new Integer(0));
            myOrder_.put(new Integer(3), new Integer(1));
            myOrder_.put(new Integer(0), new Integer(2));
            myOrder_.put(new Integer(1), new Integer(3));
        }
    }
}

