/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.SuperSrcRouterPointSource;
import org.systemsbiology.biotapestry.util.UiUtil;

public class MetaClusterPointSource {
    public static final int FOR_PURE_TARG = 0;
    public static final int FOR_INBOUND_SRC = 1;
    public static final int FOR_INTRA_SRC = 2;
    public static final int FOR_ALWAYS_BELOW = 3;
    private Point2D dropForRow_;
    private boolean srcIsCarriedOver_;
    private boolean dropIsCarriedDown_;
    private boolean startForSource_;
    private SuperSrcRouterPointSource lmp_;
    private int type_;
    private double targetTraceY_;
    private double traceDistance_;
    private Map inboundTraces_;
    private Point2D base_;
    private Map inboundsPerSrc_;
    private boolean abNeedsHoriz_;
    private boolean deferredPlacementOnly_;
    private String srcID_;
    private boolean needsTraceYUpdate_;
    private Point2D lastLeftPoint_;
    private Point2D targetDropRoot_;
    private Point2D targetRowDrop_;
    private boolean singleRow_;

    public MetaClusterPointSource(String srcID, SuperSrcRouterPointSource lmp, int usage) {
        this.srcID_ = srcID;
        this.lmp_ = lmp;
        this.type_ = usage;
        this.deferredPlacementOnly_ = false;
        this.singleRow_ = false;
        if (usage == 2) {
            this.startForSource_ = true;
            this.dropForRow_ = null;
            this.lastLeftPoint_ = null;
            this.needsTraceYUpdate_ = true;
        } else if (usage == 1) {
            this.startForSource_ = true;
            this.dropForRow_ = null;
            this.lastLeftPoint_ = null;
            this.needsTraceYUpdate_ = true;
        } else if (usage == 0) {
            this.targetDropRoot_ = null;
            this.targetRowDrop_ = null;
            this.lastLeftPoint_ = null;
            this.srcIsCarriedOver_ = false;
            this.needsTraceYUpdate_ = false;
        } else if (usage == 3) {
            this.startForSource_ = true;
            this.dropForRow_ = null;
            this.lastLeftPoint_ = null;
            this.needsTraceYUpdate_ = false;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void closeOutComplexCluster(SpecialtyLayoutLinkData.TrackPos finalForClust) {
        this.lastLeftPoint_ = this.type_ == 0 ? (Point2D)finalForClust.getPoint().clone() : null;
    }

    public void updateDropPoint(Point2D finalInbound) {
        this.dropForRow_ = (Point2D)finalInbound.clone();
    }

    public void updateRightmostDropPoint(Point2D finalRightmost) {
        this.lastLeftPoint_ = (Point2D)finalRightmost.clone();
    }

    public boolean busFeedIsHorizontal() {
        return this.type_ == 0 || this.type_ == 3 && !this.abNeedsHoriz_;
    }

    public int getType() {
        return this.type_;
    }

    public Point2D getComplexInterfacePoint() {
        return this.type_ == 0 ? (Point2D)this.targetRowDrop_.clone() : (Point2D)this.dropForRow_.clone();
    }

    public void buildPrePath(SpecialtyLayoutLinkData sin, String linkID, Point2D lastPoint, boolean firstForClust, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, boolean extendingVertically, boolean firstFromTop) {
        switch (this.type_) {
            case 0: {
                this.doPureTargetTipAccounting(sin, linkID, lastPoint.getX(), positions, padChanges, genome, lo, frc);
                return;
            }
            case 1: 
            case 2: {
                this.doInboundTipAccounting(sin, linkID, lastPoint, firstForClust, positions, padChanges, genome, lo, frc, extendingVertically, firstFromTop);
                return;
            }
        }
        throw new IllegalStateException();
    }

    public void fanBlockBuildPrePath(SpecialtyLayoutLinkData sin, String linkID, Point2D lastPoint, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        switch (this.type_) {
            case 0: {
                this.doPureTargetTipAccounting(sin, linkID, lastPoint.getX(), positions, padChanges, genome, lo, frc);
                return;
            }
            case 1: 
            case 2: {
                this.doInboundTipAccountingForBlock(sin, linkID, lastPoint, positions, padChanges, genome, lo, frc);
                return;
            }
        }
        throw new IllegalStateException();
    }

    public double getVerticalDropX(Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        switch (this.type_) {
            case 1: {
                Point2D icDrop = this.getFirstDropFromTraces();
                return icDrop.getX();
            }
            case 2: {
                Point2D intBr = this.lmp_.getInternalBranch(positions, padChanges, genome, lo, frc);
                return intBr != null ? intBr.getX() : 0.0;
            }
            case 3: {
                Point2D icDrop = this.getFirstDropFromTraces();
                return icDrop.getX();
            }
        }
        throw new IllegalStateException();
    }

    public Point2D getTargetDropRoot() {
        return this.targetDropRoot_;
    }

    public void initializeTargetDropRoot(Point2D pt) {
        this.targetDropRoot_ = (Point2D)pt.clone();
    }

    public void initTargetDropRow(double y, boolean singleRow) {
        this.targetRowDrop_ = new Point2D.Double(this.targetDropRoot_.getX(), y);
        this.singleRow_ = singleRow;
        this.dropIsCarriedDown_ = false;
    }

    public void closeOutTargetDropRow() {
        if (this.dropIsCarriedDown_) {
            this.lmp_.updateMainHotTip((Point2D)this.targetRowDrop_.clone());
        }
    }

    public void updateMainHotTip(Point2D pt) {
        this.lmp_.updateMainHotTip(pt);
    }

    public double getTargetTraceY() {
        return this.targetTraceY_;
    }

    public void setTargetTraceY(double y) {
        this.targetTraceY_ = y;
    }

    public boolean needsTraceYUpdate() {
        return this.needsTraceYUpdate_;
    }

    public double getTraceDistance() {
        return this.traceDistance_;
    }

    public boolean hasInboundTraces() {
        return this.inboundTraces_ != null;
    }

    public Map getInboundTraces() {
        return this.inboundTraces_;
    }

    public Point2D getFirstDropFromTraces() {
        Integer inTrace = (Integer)this.inboundTraces_.get(this.srcID_);
        double traceColVal = inTrace.doubleValue();
        double dropX = this.base_.getX() + traceColVal * this.traceDistance_;
        return new Point2D.Double(dropX, this.targetTraceY_);
    }

    public void setInboundParams(double traceDistance, Map inboundTraces, Point2D base, Map inboundsPerSrc) {
        this.traceDistance_ = traceDistance;
        this.inboundTraces_ = inboundTraces;
        if (UiUtil.forceToGridValue(base.getX(), 10.0) != base.getX()) {
            throw new IllegalArgumentException();
        }
        this.base_ = base;
        this.inboundsPerSrc_ = inboundsPerSrc;
    }

    public void setStackedParams(double traceDistance, Point2D base, Map inboundsPerSrc, Map inboundTraces) {
        if (UiUtil.forceToGridValue(base.getX(), 10.0) != base.getX()) {
            throw new IllegalArgumentException();
        }
        this.traceDistance_ = traceDistance;
        this.base_ = base;
        this.inboundsPerSrc_ = inboundsPerSrc;
        this.inboundTraces_ = inboundTraces;
        this.needsTraceYUpdate_ = this.abNeedsHoriz_ = true;
    }

    public void setForDeferredPlacementOnly(boolean deferred) {
        this.deferredPlacementOnly_ = deferred;
    }

    public boolean isForDeferredOnly() {
        return this.deferredPlacementOnly_;
    }

    public List initInboundsPerSrcForDeferred(String coreID, String srcID) {
        if (!this.deferredPlacementOnly_) {
            throw new IllegalStateException();
        }
        GeneAndSatelliteCluster.TagAnnotatedList perClust = new ArrayList();
        ArrayList<GeneAndSatelliteCluster.TagAnnotatedList> inbounds = (ArrayList<GeneAndSatelliteCluster.TagAnnotatedList>)this.inboundsPerSrc_.get(srcID);
        if (inbounds == null) {
            inbounds = new ArrayList<GeneAndSatelliteCluster.TagAnnotatedList>();
            this.inboundsPerSrc_.put(srcID, inbounds);
        }
        perClust = new GeneAndSatelliteCluster.TagAnnotatedList(coreID);
        inbounds.add(perClust);
        return perClust;
    }

    public void setIntraParams(double traceDistance) {
        this.traceDistance_ = traceDistance;
        this.inboundTraces_ = null;
        this.base_ = null;
        this.inboundsPerSrc_ = null;
    }

    private void doPureTargetTipAccounting(SpecialtyLayoutLinkData sin, String linkID, double lastX, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        Point2D hotTip = this.lmp_.getMainHotTip();
        if (hotTip == null) {
            this.lmp_.startOutboundBranch(sin, linkID, positions, padChanges, genome, lo, frc);
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.targetDropRoot_));
            if (!this.singleRow_) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.targetRowDrop_));
            }
            this.lmp_.updateMainHotTip((Point2D)this.targetRowDrop_.clone());
            this.srcIsCarriedOver_ = true;
            this.dropIsCarriedDown_ = true;
        } else if (!this.srcIsCarriedOver_) {
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.targetDropRoot_));
            if (!this.singleRow_) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.targetRowDrop_));
            }
            this.lmp_.updateMainHotTip((Point2D)this.targetRowDrop_.clone());
            this.srcIsCarriedOver_ = true;
            this.dropIsCarriedDown_ = true;
        } else if (!this.dropIsCarriedDown_) {
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
            if (!this.singleRow_) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.targetRowDrop_));
            }
            this.lmp_.updateMainHotTip((Point2D)this.targetRowDrop_.clone());
            this.dropIsCarriedDown_ = true;
        } else if (this.lastLeftPoint_ != null) {
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.lastLeftPoint_.clone()));
        }
        this.lastLeftPoint_ = new Point2D.Double(lastX, this.targetRowDrop_.getY());
    }

    public void closeOutCluster() {
        if (this.type_ != 0) {
            this.lastLeftPoint_ = null;
        }
    }

    public Point2D getLastLeftPoint() {
        return this.lastLeftPoint_;
    }

    private void establishTopDrop(SpecialtyLayoutLinkData sin, String linkID, Point2D lastCoord, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, boolean extendingVertically) {
        Point2D hotTip = this.lmp_.getMainHotTip();
        if (hotTip == null) {
            this.lmp_.startOutboundBranch(sin, linkID, positions, padChanges, genome, lo, frc);
        } else {
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
        }
        Point2D icDrop = this.getFirstDropFromTraces();
        Point2D.Double topDrop = new Point2D.Double(icDrop.getX(), this.lmp_.getTrace().getY());
        sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)topDrop.clone()));
        this.lmp_.updateMainHotTip((Point2D)topDrop.clone());
        boolean invert = icDrop.getY() < ((Point2D)topDrop).getY();
        this.dropForRow_ = extendingVertically && invert ? (Point2D)topDrop.clone() : (Point2D)icDrop.clone();
        sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
        if (extendingVertically) {
            this.lastLeftPoint_ = new Point2D.Double(this.dropForRow_.getX(), lastCoord.getY());
            this.dropForRow_ = (Point2D)this.lastLeftPoint_.clone();
        } else {
            this.lastLeftPoint_ = new Point2D.Double(lastCoord.getX(), this.dropForRow_.getY());
        }
    }

    private void establishInternalBranch(SpecialtyLayoutLinkData sin, String linkID, Point2D lastCoord, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, boolean extendingVertically) {
        this.lmp_.startInternalBranch(sin, linkID, positions, padChanges, genome, lo, frc);
        Point2D internalBranch = this.lmp_.getInternalBranch(positions, padChanges, genome, lo, frc);
        sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)internalBranch.clone()));
        if (!extendingVertically) {
            this.dropForRow_ = new Point2D.Double(internalBranch.getX(), this.targetTraceY_);
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
            this.lastLeftPoint_ = new Point2D.Double(lastCoord.getX(), this.dropForRow_.getY());
        } else {
            this.dropForRow_ = new Point2D.Double(internalBranch.getX(), lastCoord.getY());
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
            this.lastLeftPoint_ = (Point2D)this.dropForRow_.clone();
        }
    }

    private void establishInboundTipForAddedCluster(SpecialtyLayoutLinkData sin, String linkID, Point2D newTipPt, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, boolean extendingVertically, boolean firstFromTop) {
        double dropX;
        sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
        Point2D internalBranch = this.lmp_.getInternalBranch(positions, padChanges, genome, lo, frc);
        double d = dropX = this.type_ == 1 || this.type_ == 3 && this.abNeedsHoriz_ ? this.getFirstDropFromTraces().getX() : internalBranch.getX();
        if (extendingVertically) {
            this.dropForRow_ = new Point2D.Double(dropX, newTipPt.getY());
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
            this.lastLeftPoint_ = (Point2D)this.dropForRow_.clone();
        } else if (firstFromTop && this.targetTraceY_ != newTipPt.getY()) {
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
            this.dropForRow_ = new Point2D.Double(dropX, newTipPt.getY());
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
            this.lastLeftPoint_ = new Point2D.Double(newTipPt.getX(), newTipPt.getY());
        } else {
            this.dropForRow_ = new Point2D.Double(dropX, this.targetTraceY_);
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
            this.lastLeftPoint_ = new Point2D.Double(newTipPt.getX(), this.targetTraceY_);
        }
    }

    private void extendInboundTipForCluster(SpecialtyLayoutLinkData sin, String linkID, Point2D newTipPt, boolean extendingVertically) {
        if (extendingVertically) {
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.dropForRow_.clone()));
            this.lastLeftPoint_ = new Point2D.Double(this.lastLeftPoint_.getX(), newTipPt.getY());
            this.dropForRow_ = (Point2D)this.lastLeftPoint_.clone();
        } else {
            if (this.lastLeftPoint_ == null) {
                throw new IllegalStateException();
            }
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.lastLeftPoint_.clone()));
            this.lastLeftPoint_ = new Point2D.Double(newTipPt.getX(), this.lastLeftPoint_.getY());
        }
        sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)this.lastLeftPoint_.clone()));
    }

    private void doInboundTipAccounting(SpecialtyLayoutLinkData sin, String linkID, Point2D lastPoint, boolean firstForClust, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, boolean extendingVertically, boolean firstFromTop) {
        if (this.type_ == 0) {
            throw new IllegalStateException();
        }
        if (this.startForSource_) {
            if (this.type_ == 1 || this.type_ == 3 && this.abNeedsHoriz_) {
                this.establishTopDrop(sin, linkID, lastPoint, positions, padChanges, genome, lo, frc, extendingVertically);
            } else {
                this.establishInternalBranch(sin, linkID, lastPoint, positions, padChanges, genome, lo, frc, extendingVertically);
            }
            this.startForSource_ = false;
        } else if (firstForClust) {
            this.establishInboundTipForAddedCluster(sin, linkID, lastPoint, positions, padChanges, genome, lo, frc, extendingVertically, firstFromTop);
        } else {
            this.extendInboundTipForCluster(sin, linkID, lastPoint, extendingVertically);
        }
    }

    private void doInboundTipAccountingForBlock(SpecialtyLayoutLinkData sin, String linkID, Point2D lastPoint, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        if (this.type_ == 0) {
            throw new IllegalStateException();
        }
        if (this.startForSource_) {
            if (this.type_ == 1 || this.type_ == 3 && this.abNeedsHoriz_) {
                this.establishTopDrop(sin, linkID, lastPoint, positions, padChanges, genome, lo, frc, false);
            } else {
                this.establishInternalBranch(sin, linkID, lastPoint, positions, padChanges, genome, lo, frc, false);
            }
            this.startForSource_ = false;
        } else {
            this.establishInboundTipForAddedCluster(sin, linkID, lastPoint, positions, padChanges, genome, lo, frc, false, false);
        }
    }
}

