/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.CenteredGridElement;
import org.systemsbiology.biotapestry.analysis.CycleFinder;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleBusDrop;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.PointAndVec;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class NetModuleLinkExtractor {
    public Map extract(Genome genome, Layout lo, FontRenderContext frc, String overlayKey, List subsetList) {
        HashMap<String, ExtractResultForSource> retval = new HashMap<String, ExtractResultForSource>();
        Database db = Database.getDB();
        String genomeKey = genome.getID();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
        NetworkOverlay nov = owner.getNetworkOverlay(overlayKey);
        NetOverlayProperties noProps = lo.getNetOverlayProperties(overlayKey);
        Iterator lpkit = noProps.getNetModuleLinkagePropertiesKeys();
        HashSet<Point2D> seenPts = new HashSet<Point2D>();
        while (lpkit.hasNext()) {
            String treeID = (String)lpkit.next();
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
            String srcMod = nmlp.getSourceTag();
            ExtractResultForSource er4s = (ExtractResultForSource)retval.get(srcMod);
            if (er4s == null) {
                er4s = new ExtractResultForSource(srcMod);
                retval.put(srcMod, er4s);
            }
            List allLinks = nmlp.getLinkageList();
            HashMap<String, String> linkToTarget = new HashMap<String, String>();
            int numL = allLinks.size();
            for (int i = 0; i < numL; ++i) {
                String linkID = (String)allLinks.get(i);
                NetModuleLinkage nml = nov.getLinkage(linkID);
                linkToTarget.put(linkID, nml.getTarget());
            }
            Map segGeoms = nmlp.getAllSegmentGeometries(genome, lo, frc, true);
            NetModuleBusDrop rootDrop = (NetModuleBusDrop)nmlp.getRootDrop();
            Vector2D startDir = new Vector2D(rootDrop.getEnd(0.0), rootDrop.getEnd(1.0));
            Iterator dit = nmlp.getDrops();
            while (dit.hasNext()) {
                NetModuleBusDrop drop = (NetModuleBusDrop)dit.next();
                if (drop.getDropType() != 1) continue;
                String tRef = drop.getTargetRef();
                NetModuleLinkage nlm = nov.getLinkage(tRef);
                String trgMod = nlm.getTarget();
                ExtractResultForTarg extRes = er4s.getOrPrepResultForTarg(trgMod, treeID);
                if (extRes == null) {
                    Vector2D endDir = new Vector2D(drop.getEnd(0.0), drop.getEnd(1.0));
                    extRes = new ExtractResultForTarg(trgMod, startDir, endDir);
                    er4s.addResultForTarg(trgMod, extRes);
                }
                List segsToRoot = nmlp.getSegmentIDsToRootForEndDrop(drop);
                int nums2r = segsToRoot.size();
                for (int i = 0; i < nums2r; ++i) {
                    boolean lastEntry = i == nums2r - 1;
                    LinkSegmentID lsid = (LinkSegmentID)segsToRoot.get(i);
                    Set linksThru = nmlp.resolveLinkagesThroughSegment(lsid, genome);
                    Iterator ltit = linksThru.iterator();
                    HashSet<String> targsThru = new HashSet<String>();
                    while (ltit.hasNext()) {
                        String linkID = (String)ltit.next();
                        String targMod = (String)linkToTarget.get(linkID);
                        targsThru.add(targMod);
                    }
                    extRes.addToTargList(targsThru);
                    if (lastEntry) {
                        extRes.addToTargList(new HashSet(linkToTarget.values()));
                    }
                    LinkSegment fake = (LinkSegment)segGeoms.get(lsid);
                    if (i == 0) {
                        Point2D cloneEnd = (Point2D)drop.getEnd(0.0).clone();
                        UiUtil.forceToGrid(cloneEnd, 10.0);
                        extRes.addPoint(new PointAndVec(cloneEnd, fake.getRun()), targsThru, false);
                        Point2D key = (Point2D)cloneEnd.clone();
                        if (!seenPts.contains(key)) {
                            extRes.addElement(new CenteredGridElement(cloneEnd));
                            seenPts.add(key);
                        }
                    }
                    boolean orthoParent = false;
                    Vector2D prun = null;
                    if (!lastEntry) {
                        LinkSegmentID psid = (LinkSegmentID)segsToRoot.get(i + 1);
                        LinkSegment fakep = (LinkSegment)segGeoms.get(psid);
                        int myRunCanon = fake.getRun().canonicalDir();
                        int parRunCanon = fakep.getRun().canonicalDir();
                        prun = fakep.getRun();
                        orthoParent = myRunCanon != -1 && parRunCanon != -1 && Vector2D.canonicalsAreOrtho(myRunCanon, parRunCanon);
                    }
                    Point2D cloneStrt = lastEntry ? (Point2D)rootDrop.getEnd(0.0).clone() : (Point2D)fake.getStart().clone();
                    UiUtil.forceToGrid(cloneStrt, 10.0);
                    extRes.addPoint(new PointAndVec(cloneStrt, prun), targsThru, orthoParent);
                    Point2D key = (Point2D)cloneStrt.clone();
                    if (seenPts.contains(key)) continue;
                    extRes.addElement(new CenteredGridElement(cloneStrt));
                    seenPts.add(key);
                }
            }
        }
        Iterator rvit = retval.values().iterator();
        while (rvit.hasNext()) {
            ExtractResultForSource er4s = (ExtractResultForSource)rvit.next();
            er4s.reverse();
        }
        return retval;
    }

    public SubsetAnalysis analyzeForMods(List subsetList, Map interModPaths) {
        PrimaryAndOthers pao;
        String srcID;
        GenomeSubset subset;
        int i;
        int numSub = subsetList.size();
        if (numSub == 0) {
            return null;
        }
        SubsetAnalysis sa = new SubsetAnalysis(interModPaths);
        for (i = 0; i < numSub; ++i) {
            subset = (GenomeSubset)subsetList.get(i);
            String modName = subset.getModuleID();
            if (modName == null) continue;
            sa.mapIndexToModName(i, modName);
        }
        for (i = 0; i < numSub; ++i) {
            subset = (GenomeSubset)subsetList.get(i);
            HashSet allSrc = new HashSet();
            allSrc.addAll(subset.getSourcesHeadedOut());
            allSrc.addAll(subset.getSourcesForInternal());
            Iterator asit = allSrc.iterator();
            while (asit.hasNext()) {
                srcID = (String)asit.next();
                pao = new PrimaryAndOthers(srcID, i);
                sa.mapSourceToModules(srcID, pao);
            }
        }
        for (i = 0; i < numSub; ++i) {
            subset = (GenomeSubset)subsetList.get(i);
            Set srcsIn = subset.getSourcesHeadedIn();
            Iterator sit = srcsIn.iterator();
            while (sit.hasNext()) {
                srcID = (String)sit.next();
                pao = sa.getModulesForSrcID(srcID);
                if (pao == null) {
                    pao = new PrimaryAndOthers(srcID, Integer.MIN_VALUE);
                    pao.addOtherCode(i);
                    sa.mapSourceToModules(srcID, pao);
                    continue;
                }
                if (pao.getPrimCode() == i) continue;
                pao.addOtherCode(i);
            }
        }
        sa.allocateInterModulePaths();
        sa.generatePartialOrder();
        sa.generateBorderOrderedInbounds();
        return sa;
    }

    static class FullBorderOrder {
        OneBorderOrder[] allOrders;
        private int[] drainOrder_ = new int[]{2, 0, 3, 1};

        FullBorderOrder() {
            this.allOrders = new OneBorderOrder[4];
            for (int i = 0; i < 4; ++i) {
                this.allOrders[i] = new OneBorderOrder(i);
            }
        }

        void addAModule(String srcModuleID, Point2D arrivePt, Vector2D arriveDir) {
            int border = SpecialtyLayoutLinkData.vecToBorder(arriveDir);
            OneBorderOrder forBord = this.allOrders[border];
            forBord.addAModule(srcModuleID, arrivePt);
        }

        List drainTheOrder() {
            ArrayList retval = new ArrayList();
            for (int i = 0; i < 4; ++i) {
                int toDrain = this.drainOrder_[i];
                OneBorderOrder drainIt = this.allOrders[toDrain];
                drainIt.drainTheOrder(retval);
            }
            return retval;
        }
    }

    static class OneBorderOrder {
        int border;
        boolean useY;
        TreeMap srcModuleOrder;

        OneBorderOrder(int border) {
            this.border = border;
            this.useY = border == 3 || border == 2;
            this.srcModuleOrder = border == 2 ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
        }

        void addAModule(String srcModuleID, Point2D arrivePt) {
            Double val = new Double(this.useY ? arrivePt.getY() : arrivePt.getX());
            TreeSet<String> forVal = (TreeSet<String>)this.srcModuleOrder.get(val);
            if (forVal == null) {
                forVal = new TreeSet<String>();
                this.srcModuleOrder.put(val, forVal);
            }
            forVal.add(srcModuleID);
        }

        void drainTheOrder(ArrayList drainTarg) {
            Iterator smoit = this.srcModuleOrder.values().iterator();
            while (smoit.hasNext()) {
                TreeSet forVal = (TreeSet)smoit.next();
                drainTarg.addAll(forVal);
            }
        }
    }

    public class PrimaryAndOthers {
        public String srcID;
        private int primary_;
        private HashSet others_;

        PrimaryAndOthers(String srcID, int primary) {
            this.primary_ = primary;
            this.others_ = new HashSet();
        }

        int getPrimCode() {
            return this.primary_;
        }

        void addOtherCode(int otherCode) {
            this.others_.add(new Integer(otherCode));
        }

        public boolean sourceInModule() {
            return this.primary_ != Integer.MIN_VALUE;
        }

        public Iterator getTargetModules() {
            return this.others_.iterator();
        }
    }

    public static class SubsetAnalysis {
        private HashMap indexToModName_ = new HashMap();
        private HashMap srcToIndex_ = new HashMap();
        private Map interModPaths_;
        private List partialOrder_;
        private Map topoIndexReorder_;
        private List topoOrderedSubsets_;
        private HashMap modNameToBorderOrderedInbounds_;

        SubsetAnalysis(Map interModPaths) {
            this.interModPaths_ = interModPaths;
            this.partialOrder_ = null;
        }

        public void mapIndexToModName(int i, String modName) {
            this.indexToModName_.put(new Integer(i), modName);
        }

        public List getBorderOrderedSrcModules(String trgMod) {
            FullBorderOrder fbo = (FullBorderOrder)this.modNameToBorderOrderedInbounds_.get(trgMod);
            if (fbo == null) {
                return new ArrayList();
            }
            return fbo.drainTheOrder();
        }

        public void mapSourceToModules(String srcID, PrimaryAndOthers pao) {
            this.srcToIndex_.put(srcID, pao);
        }

        public boolean hasInterModulePaths() {
            return this.interModPaths_ != null;
        }

        public Iterator getSrcKeys() {
            return this.srcToIndex_.keySet().iterator();
        }

        public String getSourceModuleIDForSource(String srcID) {
            PrimaryAndOthers pao = (PrimaryAndOthers)this.srcToIndex_.get(srcID);
            return this.getPrimaryModuleName(pao);
        }

        public Iterator getInterModPathKeys() {
            if (this.interModPaths_ == null) {
                return null;
            }
            return this.interModPaths_.keySet().iterator();
        }

        public PrimaryAndOthers getModulesForSrcID(String srcID) {
            return (PrimaryAndOthers)this.srcToIndex_.get(srcID);
        }

        public String getPrimaryModuleName(PrimaryAndOthers pao) {
            if (!pao.sourceInModule()) {
                throw new IllegalStateException();
            }
            String modName = (String)this.indexToModName_.get(new Integer(pao.getPrimCode()));
            return modName;
        }

        public String getTargetModuleName(PrimaryAndOthers pao, Integer which) {
            String modName = (String)this.indexToModName_.get(which);
            return modName;
        }

        public ExtractResultForSource getExtractResultForSource(String modName) {
            ExtractResultForSource interModForSrc = (ExtractResultForSource)this.interModPaths_.get(modName);
            return interModForSrc;
        }

        public int getMappedPrimaryModuleIndex(PrimaryAndOthers pao) {
            if (!pao.sourceInModule()) {
                throw new IllegalStateException();
            }
            Integer mapped = (Integer)this.topoIndexReorder_.get(new Integer(pao.primary_));
            return mapped;
        }

        public int getMappedTargetModuleIndex(PrimaryAndOthers pao, Integer which) {
            if (!pao.sourceInModule()) {
                throw new IllegalStateException();
            }
            Integer mapped = (Integer)this.topoIndexReorder_.get(which);
            return mapped;
        }

        public void generateBorderOrderedInbounds() {
            this.modNameToBorderOrderedInbounds_ = new HashMap();
            Iterator impit = this.getInterModPathKeys();
            if (impit == null) {
                return;
            }
            while (impit.hasNext()) {
                String modID = (String)impit.next();
                ExtractResultForSource er4s = this.getExtractResultForSource(modID);
                Map tmods = er4s.getTargetMods();
                Iterator tmodit = tmods.keySet().iterator();
                while (tmodit.hasNext()) {
                    String tMod = (String)tmodit.next();
                    ExtractResultForTarg er4t = er4s.getResultForTarg(tMod);
                    FullBorderOrder fbo = (FullBorderOrder)this.modNameToBorderOrderedInbounds_.get(tMod);
                    if (fbo == null) {
                        fbo = new FullBorderOrder();
                        this.modNameToBorderOrderedInbounds_.put(tMod, fbo);
                    }
                    Point2D coreArrive = er4t.getCoreArrivalPoint();
                    Vector2D arrDir = er4t.getTerminalDirection();
                    fbo.addAModule(modID, coreArrive, arrDir);
                }
            }
        }

        private void generatePartialOrder() {
            HashSet<String> nodeSet = new HashSet<String>();
            TreeMap linkMap = new TreeMap(Collections.reverseOrder());
            HashSet<Link> linkSet = new HashSet<Link>();
            Iterator stiit = this.srcToIndex_.keySet().iterator();
            while (stiit.hasNext()) {
                ExtractResultForSource er4s;
                String modName;
                String srcID = (String)stiit.next();
                PrimaryAndOthers pao = (PrimaryAndOthers)this.srcToIndex_.get(srcID);
                if (!pao.sourceInModule() || (modName = (String)this.indexToModName_.get(new Integer(pao.getPrimCode()))) == null || this.interModPaths_ == null || (er4s = (ExtractResultForSource)this.interModPaths_.get(modName)) == null) continue;
                nodeSet.add(modName);
                Map myMods = er4s.getTargetMods();
                Iterator mmit = myMods.keySet().iterator();
                while (mmit.hasNext()) {
                    String trg = (String)mmit.next();
                    nodeSet.add(trg);
                    Integer ranking = (Integer)myMods.get(trg);
                    Link modLink = new Link(modName, trg);
                    TreeSet<Link> forRank = (TreeSet<Link>)linkMap.get(ranking);
                    if (forRank == null) {
                        forRank = new TreeSet<Link>();
                        linkMap.put(ranking, forRank);
                    }
                    forRank.add(modLink);
                }
            }
            Iterator vit = linkMap.values().iterator();
            while (vit.hasNext()) {
                TreeSet forRank = (TreeSet)vit.next();
                Iterator fit = forRank.iterator();
                while (fit.hasNext()) {
                    Link modLink = (Link)fit.next();
                    linkSet.add(modLink);
                    CycleFinder cf = new CycleFinder(nodeSet, linkSet);
                    if (!cf.hasACycle()) continue;
                    linkSet.remove(modLink);
                }
            }
            GraphSearcher gs = new GraphSearcher(nodeSet, linkSet);
            Map queue = gs.topoSort(false);
            this.partialOrder_ = gs.topoSortToPartialOrdering(queue);
        }

        private void allocateInterModulePaths() {
            Iterator stiit = this.srcToIndex_.keySet().iterator();
            while (stiit.hasNext()) {
                ExtractResultForSource er4s;
                String modName;
                String srcID = (String)stiit.next();
                PrimaryAndOthers pao = (PrimaryAndOthers)this.srcToIndex_.get(srcID);
                if (!pao.sourceInModule() || (modName = (String)this.indexToModName_.get(new Integer(pao.getPrimCode()))) == null || this.interModPaths_ == null || (er4s = (ExtractResultForSource)this.interModPaths_.get(modName)) == null) continue;
                Iterator oit = pao.getTargetModules();
                while (oit.hasNext()) {
                    Integer other = (Integer)oit.next();
                    String trgModName = (String)this.indexToModName_.get(other);
                    if (trgModName == null) continue;
                    er4s.sourceGoesToModule(srcID, trgModName);
                }
            }
        }

        public List topoReorder(List subsetList) {
            this.topoIndexReorder_ = new HashMap();
            int numSub = subsetList.size();
            this.topoOrderedSubsets_ = new ArrayList();
            SortedSet notAssigned = new MinMax(0, numSub - 1).getAsSortedSet();
            int numPO = this.partialOrder_.size();
            block0: for (int j = 0; j < numPO; ++j) {
                String modID = (String)this.partialOrder_.get(j);
                for (int i = 0; i < numSub; ++i) {
                    GenomeSubset subset = (GenomeSubset)subsetList.get(i);
                    String smid = subset.getModuleID();
                    if (smid == null || !smid.equals(modID)) continue;
                    Integer matchIndex = new Integer(i);
                    this.topoOrderedSubsets_.add(subset);
                    notAssigned.remove(matchIndex);
                    this.topoIndexReorder_.put(matchIndex, new Integer(this.topoOrderedSubsets_.size() - 1));
                    continue block0;
                }
            }
            Iterator nait = notAssigned.iterator();
            while (nait.hasNext()) {
                Integer na = (Integer)nait.next();
                this.topoOrderedSubsets_.add(subsetList.get(na));
                this.topoIndexReorder_.put(na, new Integer(this.topoOrderedSubsets_.size() - 1));
            }
            return this.topoOrderedSubsets_;
        }
    }

    public static class ExtractResultForTarg
    implements Cloneable {
        private ArrayList pointList_ = new ArrayList();
        private ArrayList elemList_ = new ArrayList();
        private ArrayList targList_ = new ArrayList();
        private Vector2D endDir_;
        private Vector2D startDir_;
        private String trgMod_;
        private ExtractResultForTree myTree_;
        private HashMap shifted_;
        private HashSet inboundSrcs_;

        ExtractResultForTarg(String trgMod, Vector2D startDir, Vector2D endDir) {
            this.endDir_ = endDir;
            this.startDir_ = startDir;
            this.trgMod_ = trgMod;
            this.shifted_ = new HashMap();
            this.inboundSrcs_ = new HashSet();
        }

        public Object clone() {
            try {
                ExtractResultForTarg retval = (ExtractResultForTarg)super.clone();
                retval.pointList_ = new ArrayList();
                int numPL = this.pointList_.size();
                for (int i = 0; i < numPL; ++i) {
                    PointAndVec pAndV = (PointAndVec)this.pointList_.get(i);
                    retval.pointList_.add(pAndV.clone());
                }
                retval.elemList_ = new ArrayList();
                int numEL = this.elemList_.size();
                for (int i = 0; i < numEL; ++i) {
                    CenteredGridElement ge = (CenteredGridElement)this.elemList_.get(i);
                    CenteredGridElement retGe = new CenteredGridElement(ge);
                    retGe.setID(ge.getID());
                    retval.elemList_.add(retGe);
                }
                retval.targList_ = new ArrayList();
                int numTL = this.targList_.size();
                for (int i = 0; i < numTL; ++i) {
                    Set trgs = (Set)this.targList_.get(i);
                    HashSet retTrgs = new HashSet(trgs);
                    retval.targList_.add(retTrgs);
                }
                retval.endDir_ = (Vector2D)this.endDir_.clone();
                retval.startDir_ = (Vector2D)this.startDir_.clone();
                retval.shifted_ = new HashMap();
                Iterator skit = this.shifted_.keySet().iterator();
                while (skit.hasNext()) {
                    Point2D key = (Point2D)skit.next();
                    Point2D val = (Point2D)this.shifted_.get(key);
                    retval.shifted_.put(key.clone(), val.clone());
                }
                retval.inboundSrcs_ = (HashSet)this.inboundSrcs_.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        String getTrgID() {
            return this.trgMod_;
        }

        void shareTrackAssignment(ExtractResultForTree myTree) {
            this.myTree_ = myTree;
        }

        public Vector2D getTerminalDirection() {
            return this.endDir_;
        }

        public Vector2D getStartDirection() {
            return this.startDir_;
        }

        public int size() {
            return this.pointList_.size();
        }

        public int numElem() {
            return this.elemList_.size();
        }

        public CenteredGridElement getElem(int i) {
            return (CenteredGridElement)this.elemList_.get(i);
        }

        Point2D getOriginalCorePoint(int i) {
            return ((PointAndVec)this.pointList_.get((int)i)).origin;
        }

        Point2D getCorePoint(int i) {
            Point2D orig = this.getOriginalCorePoint(i);
            Point2D shifted = (Point2D)this.shifted_.get(orig);
            return shifted == null ? orig : shifted;
        }

        void addToMultiDataMap(Map multiDataMap) {
            int numPt = this.pointList_.size();
            for (int i = 0; i < numPt; ++i) {
                Point2D keyPt = this.getCorePoint(i);
                Iterator isit = this.inboundSrcs_.iterator();
                while (isit.hasNext()) {
                    String srcID = (String)isit.next();
                    Point trkPt = this.getSrcTrack(srcID, i);
                    HashMap<String, Point> mapForPt = (HashMap<String, Point>)multiDataMap.get(keyPt);
                    if (mapForPt == null) {
                        mapForPt = new HashMap<String, Point>();
                        multiDataMap.put(keyPt, mapForPt);
                    }
                    if (mapForPt.containsKey(srcID)) continue;
                    mapForPt.put(srcID, trkPt);
                }
            }
        }

        public Point2D getPoint(String srcID, int i) {
            Point trkPt = this.getSrcTrack(srcID, i);
            Point2D corePt = this.getCorePoint(i);
            Vector2D off = new Vector2D(trkPt.getX() * 10.0, trkPt.getY() * 10.0);
            return off.add(corePt);
        }

        Point2D getDeparturePoint(String srcID) {
            Point trkPt = this.getSrcTrack(srcID, 0);
            Point2D corePt = this.getCorePoint(0);
            Vector2D off = new Vector2D(trkPt.getX() * 10.0, trkPt.getY() * 10.0);
            return off.add(corePt);
        }

        public Point2D getCoreArrivalPoint() {
            return this.getCorePoint(this.pointList_.size() - 1);
        }

        public Point2D getArrivalPoint(String srcID) {
            Point trkPt = this.getSrcTrack(srcID, this.pointList_.size() - 1);
            Point2D corePt = this.getCorePoint(this.pointList_.size() - 1);
            Vector2D off = new Vector2D(trkPt.getX() * 10.0, trkPt.getY() * 10.0);
            return off.add(corePt);
        }

        public Set getTargs(int i) {
            return (Set)this.targList_.get(i);
        }

        void addToTargList(Set trgsThru) {
            this.targList_.add(trgsThru);
        }

        void addPoint(PointAndVec pAndV, Set trgMods, boolean orthoParent) {
            this.pointList_.add(pAndV);
            Map globalOrthoOutboundMods = this.myTree_.getGlobalOrthoOutboundMods();
            if (orthoParent) {
                HashSet forOrth = (HashSet)globalOrthoOutboundMods.get(pAndV.origin);
                if (forOrth == null) {
                    forOrth = new HashSet();
                    globalOrthoOutboundMods.put(pAndV.origin, forOrth);
                }
                forOrth.addAll(trgMods);
            }
        }

        public void addElement(CenteredGridElement elem) {
            this.elemList_.add(elem);
        }

        private int reducedOrder(String cand, Set reducedSet, Map globalOrder) {
            TreeMap<Integer, String> runSrcs = new TreeMap<Integer, String>();
            Iterator sit = reducedSet.iterator();
            int numNeg = 0;
            while (sit.hasNext()) {
                String nextSrc = (String)sit.next();
                Integer goVal = (Integer)globalOrder.get(nextSrc);
                if (goVal < 0) {
                    ++numNeg;
                }
                runSrcs.put(goVal, nextSrc);
            }
            int outNeg = -numNeg;
            int outPos = 0;
            Iterator rit = runSrcs.keySet().iterator();
            while (rit.hasNext()) {
                Integer nextVal = (Integer)rit.next();
                boolean isNeg = nextVal < 0;
                String nextSrc = (String)runSrcs.get(nextVal);
                if (nextSrc.equals(cand)) {
                    return isNeg ? outNeg : outPos;
                }
                if (isNeg) {
                    ++outNeg;
                    continue;
                }
                ++outPos;
            }
            throw new IllegalStateException();
        }

        private Point getSrcTrack(String src, int i) {
            PointAndVec myPAndV = (PointAndVec)this.pointList_.get(i);
            PointAndVec parPAndV = this.getTrackTurn(i);
            Point retval = this.getSrcTrackAtTurn(src, parPAndV, myPAndV);
            if (i == 0) {
                int dir = this.startDir_.canonicalDir();
                if (dir == 1 || dir == 3) {
                    retval.setLocation(0, retval.y);
                } else {
                    retval.setLocation(retval.x, 0);
                }
            } else if (i == this.pointList_.size() - 1) {
                int dir = this.endDir_.canonicalDir();
                if (dir == 1 || dir == 3) {
                    retval.setLocation(0, retval.y);
                } else {
                    retval.setLocation(retval.x, 0);
                }
            }
            return retval;
        }

        private PointAndVec getTrackTurn(int i) {
            PointAndVec pAndV = (PointAndVec)this.pointList_.get(i);
            if (i == 0) {
                return pAndV;
            }
            int canon = pAndV.offset.canonicalDir();
            for (int j = i - 1; j >= 0; --j) {
                PointAndVec parPAndV = (PointAndVec)this.pointList_.get(j);
                if (parPAndV.offset == null) {
                    return parPAndV;
                }
                int parCanon = parPAndV.offset.canonicalDir();
                if (parCanon == canon && j != 0) continue;
                return parPAndV;
            }
            throw new IllegalArgumentException();
        }

        private Point getSrcTrackAtTurn(String src, PointAndVec parPAndV, PointAndVec myPAndV) {
            int r2;
            Map gso = this.myTree_.getGlobalSourceOrder();
            Map globalOrthoOutboundSrcs = this.myTree_.getGlobalOrthoOutboundSrcs();
            Set srcs = (Set)globalOrthoOutboundSrcs.get(parPAndV.origin);
            if (srcs == null) {
                srcs = this.myTree_.getInboundSourcesForPoint(parPAndV.origin);
            }
            int r1 = this.reducedOrder(src, srcs, gso);
            HashSet oosrcs = (HashSet)globalOrthoOutboundSrcs.get(myPAndV.origin);
            int n = r2 = oosrcs != null && (myPAndV.offset == null || oosrcs.contains(src)) ? this.reducedOrder(src, oosrcs, gso) : r1;
            if (r1 == r2) {
                return new Point(this.xSign(parPAndV, myPAndV) * r1, this.ySign(parPAndV, myPAndV) * r2);
            }
            int canon = myPAndV.offset.canonicalDir();
            if (canon == 3 || canon == 1) {
                return new Point(this.xSign(parPAndV, myPAndV) * r2, this.ySign(parPAndV, myPAndV) * r1);
            }
            return new Point(this.xSign(parPAndV, myPAndV) * r1, this.ySign(parPAndV, myPAndV) * r2);
        }

        private int xSign(PointAndVec parPAndV, PointAndVec myPAndV) {
            return 1;
        }

        private int ySign(PointAndVec parPAndV, PointAndVec myPAndV) {
            return 1;
        }

        public Set getSourcesToModule() {
            return this.inboundSrcs_;
        }

        void sourceGoesToModule(String src) {
            this.inboundSrcs_.add(src);
            Map globalOrthoOutboundMods = this.myTree_.getGlobalOrthoOutboundMods();
            Map globalOrthoOutboundSrcs = this.myTree_.getGlobalOrthoOutboundSrcs();
            Set globalTreeSrcs = this.myTree_.getGlobalTreeSrcs();
            int numTL = this.targList_.size();
            for (int i = 0; i < numTL; ++i) {
                Set trgs = (Set)this.targList_.get(i);
                PointAndVec pAndV = (PointAndVec)this.pointList_.get(i);
                if (!trgs.contains(this.trgMod_)) continue;
                Set srcs = this.myTree_.getInboundSourcesForPoint(pAndV.origin);
                srcs.add(src);
                globalTreeSrcs.add(src);
                HashSet forOrth = (HashSet)globalOrthoOutboundMods.get(pAndV.origin);
                if (forOrth == null || !forOrth.contains(this.trgMod_)) continue;
                HashSet<String> oosrcs = (HashSet<String>)globalOrthoOutboundSrcs.get(pAndV.origin);
                if (oosrcs == null) {
                    oosrcs = new HashSet<String>();
                    globalOrthoOutboundSrcs.put(pAndV.origin, oosrcs);
                }
                oosrcs.add(src);
            }
        }

        void collectGridElements(Set cpIDs, List gridElements, Map dimChanges) {
            if (dimChanges != null) {
                gridElements.addAll(this.updateElementsViaMap(dimChanges));
                int numel = this.numElem();
                for (int j = 0; j < numel; ++j) {
                    CenteredGridElement ge = this.getElem(j);
                    cpIDs.add(ge.getID());
                }
                return;
            }
            int numel = this.numElem();
            for (int j = 0; j < numel; ++j) {
                CenteredGridElement ge = this.getElem(j);
                CenteredGridElement copy = new CenteredGridElement(ge);
                copy.setID(ge.getID());
                gridElements.add(copy);
                cpIDs.add(ge.getID());
            }
        }

        private List updateElementsViaMap(Map dimChanges) {
            ArrayList<CenteredGridElement> retval = new ArrayList<CenteredGridElement>();
            HashMap forTree = (HashMap)dimChanges.get(this.myTree_.getTreeID());
            int numel = this.numElem();
            for (int j = 0; j < numel; ++j) {
                Dimension[] forPoint;
                CenteredGridElement ge = this.getElem(j);
                Point2D pt = ge.getID();
                CenteredGridElement copy = new CenteredGridElement(ge);
                copy.setID(ge.getID());
                retval.add(copy);
                if (forTree == null || (forPoint = (Dimension[])forTree.get(pt)) == null) continue;
                copy.setDeltas(forPoint[0].width, forPoint[1].width, forPoint[0].height, forPoint[1].height);
            }
            return retval;
        }

        private List updateElementsForTracks() {
            ArrayList<CenteredGridElement> retval = new ArrayList<CenteredGridElement>();
            int numel = this.numElem();
            for (int j = 0; j < numel; ++j) {
                CenteredGridElement ge = this.getElem(j);
                CenteredGridElement copy = new CenteredGridElement(ge);
                copy.setID(ge.getID());
                retval.add(copy);
                if (j == numel - 1) continue;
                Point2D pt = ge.getID();
                Set srcs = this.myTree_.getInboundSourcesForPoint(pt);
                MinMax xRange = new MinMax();
                xRange.init();
                MinMax yRange = new MinMax();
                yRange.init();
                Iterator sit = srcs.iterator();
                while (sit.hasNext()) {
                    String srcID = (String)sit.next();
                    Point trkPt = this.getSrcTrack(srcID, j);
                    xRange.update(trkPt.x);
                    yRange.update(trkPt.y);
                }
                int delX = (xRange.max - xRange.min) / 2;
                int delY = (yRange.max - yRange.min) / 2;
                copy.setDeltas(delX, delX, delY, delY);
            }
            return retval;
        }

        void shiftPaths(Map movedPts) {
            int numel = this.size();
            for (int j = 0; j < numel; ++j) {
                Point2D pt = this.getOriginalCorePoint(j);
                Point2D moved = (Point2D)movedPts.get(pt);
                if (moved == null) continue;
                Point2D gridded = (Point2D)moved.clone();
                UiUtil.forceToGrid(gridded, 10.0);
                this.shifted_.put(pt.clone(), gridded);
            }
        }

        void reverse() {
            Collections.reverse(this.pointList_);
            Collections.reverse(this.elemList_);
            Collections.reverse(this.targList_);
        }
    }

    static class ExtractResultForTree
    implements Cloneable {
        private HashMap resultsByTarget_ = new HashMap();
        private String treeID_;
        private TreeMap globalTrackAssignment_;
        private HashMap globalOrthoOutboundMods_;
        private HashMap globalOrthoOutboundSrcs_;
        private HashMap globalInboundSrcs_;
        private HashMap globalSrcOrder_;
        private HashSet globalTreeSrcs_;

        ExtractResultForTree(String treeID) {
            this.treeID_ = treeID;
            this.globalTrackAssignment_ = null;
            this.globalOrthoOutboundMods_ = new HashMap();
            this.globalOrthoOutboundSrcs_ = new HashMap();
            this.globalInboundSrcs_ = new HashMap();
            this.globalSrcOrder_ = null;
            this.globalTreeSrcs_ = new HashSet();
        }

        public Object clone() {
            try {
                ExtractResultForTree retval = (ExtractResultForTree)super.clone();
                retval.resultsByTarget_ = new HashMap();
                Iterator rbtit = this.resultsByTarget_.keySet().iterator();
                while (rbtit.hasNext()) {
                    String targID = (String)rbtit.next();
                    ExtractResultForTarg er4g = (ExtractResultForTarg)this.resultsByTarget_.get(targID);
                    ExtractResultForTarg retEr4g = (ExtractResultForTarg)er4g.clone();
                    retEr4g.shareTrackAssignment(retval);
                    retval.resultsByTarget_.put(targID, retEr4g);
                }
                retval.globalTrackAssignment_ = this.globalTrackAssignment_ == null ? null : (TreeMap)this.globalTrackAssignment_.clone();
                retval.globalOrthoOutboundMods_ = new HashMap();
                Iterator goomit = this.globalOrthoOutboundMods_.keySet().iterator();
                while (goomit.hasNext()) {
                    Point2D key = (Point2D)goomit.next();
                    HashSet forOrth = (HashSet)this.globalOrthoOutboundMods_.get(key);
                    retval.globalOrthoOutboundMods_.put(key.clone(), forOrth.clone());
                }
                retval.globalOrthoOutboundSrcs_ = new HashMap();
                Iterator goosit = this.globalOrthoOutboundSrcs_.keySet().iterator();
                while (goosit.hasNext()) {
                    Point2D key = (Point2D)goosit.next();
                    HashSet forOrth = (HashSet)this.globalOrthoOutboundSrcs_.get(key);
                    retval.globalOrthoOutboundSrcs_.put(key.clone(), forOrth.clone());
                }
                retval.globalInboundSrcs_ = new HashMap();
                Iterator gisit = this.globalInboundSrcs_.keySet().iterator();
                while (gisit.hasNext()) {
                    Point2D key = (Point2D)gisit.next();
                    HashSet forSrc = (HashSet)this.globalInboundSrcs_.get(key);
                    retval.globalInboundSrcs_.put(key.clone(), forSrc.clone());
                }
                retval.globalSrcOrder_ = this.globalSrcOrder_ == null ? null : (HashMap)this.globalSrcOrder_.clone();
                retval.globalTreeSrcs_ = (HashSet)this.globalTreeSrcs_.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        String getTreeID() {
            return this.treeID_;
        }

        void setSourceOrder(SortedMap sourceOrder) {
            this.globalTrackAssignment_ = new TreeMap(sourceOrder);
        }

        Map getDeparturePoints() {
            HashMap<String, Point2D> retval = new HashMap<String, Point2D>();
            HashSet needed = new HashSet(this.globalTrackAssignment_.values());
            Iterator rbtit = this.resultsByTarget_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTarg er4g = (ExtractResultForTarg)rbtit.next();
                Iterator s2mit = er4g.getSourcesToModule().iterator();
                while (s2mit.hasNext()) {
                    String srcID = (String)s2mit.next();
                    if (!needed.contains(srcID)) continue;
                    Point2D ppt = er4g.getDeparturePoint(srcID);
                    retval.put(srcID, ppt);
                    needed.remove(srcID);
                }
            }
            return retval;
        }

        Vector2D getDepartureDir() {
            Iterator rbtit = this.resultsByTarget_.values().iterator();
            Vector2D retval = null;
            while (rbtit.hasNext()) {
                ExtractResultForTarg er4g = (ExtractResultForTarg)rbtit.next();
                Vector2D sd = er4g.getStartDirection();
                if (retval == null) {
                    retval = (Vector2D)sd.clone();
                    continue;
                }
                if (retval.equals(sd)) continue;
                throw new IllegalStateException();
            }
            return retval;
        }

        Vector2D getArrivalDir(String trgID) {
            ExtractResultForTarg er4g = (ExtractResultForTarg)this.resultsByTarget_.get(trgID);
            return er4g.getTerminalDirection();
        }

        Set getAllSources() {
            return this.getGlobalSourceOrder().keySet();
        }

        Map getGlobalOrthoOutboundMods() {
            return this.globalOrthoOutboundMods_;
        }

        Map getGlobalOrthoOutboundSrcs() {
            return this.globalOrthoOutboundSrcs_;
        }

        Set getGlobalTreeSrcs() {
            return this.globalTreeSrcs_;
        }

        Set getSourcesToModule(String trgID) {
            ExtractResultForTarg er4g = (ExtractResultForTarg)this.resultsByTarget_.get(trgID);
            return er4g.getSourcesToModule();
        }

        Set getInboundSourcesForPoint(Point2D pt) {
            HashSet srcs = (HashSet)this.globalInboundSrcs_.get(pt);
            if (srcs == null) {
                srcs = new HashSet();
                this.globalInboundSrcs_.put(pt, srcs);
            }
            return srcs;
        }

        Map getGlobalSourceOrder() {
            if (this.globalTrackAssignment_ == null) {
                throw new IllegalStateException();
            }
            if (this.globalSrcOrder_ == null) {
                this.globalSrcOrder_ = new HashMap();
                Iterator sit = this.globalTrackAssignment_.values().iterator();
                int size = this.globalTreeSrcs_.size();
                int count = -size / 2;
                while (sit.hasNext()) {
                    String srcID = (String)sit.next();
                    if (!this.globalTreeSrcs_.contains(srcID)) continue;
                    this.globalSrcOrder_.put(srcID, new Integer(count++));
                }
            }
            return this.globalSrcOrder_;
        }

        ExtractResultForTarg getResultForTarg(String trgID) {
            ExtractResultForTarg er4g = (ExtractResultForTarg)this.resultsByTarget_.get(trgID);
            return er4g;
        }

        void addResultForTarg(ExtractResultForTarg er4t) {
            er4t.shareTrackAssignment(this);
            this.resultsByTarget_.put(er4t.getTrgID(), er4t);
        }

        void sourceGoesToModule(String src, String trgID) {
            ExtractResultForTarg er4g = (ExtractResultForTarg)this.resultsByTarget_.get(trgID);
            er4g.sourceGoesToModule(src);
        }

        void reverse() {
            Iterator rbtit = this.resultsByTarget_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTarg er4g = (ExtractResultForTarg)rbtit.next();
                er4g.reverse();
            }
        }

        void collectGridElements(Set cpIDs, List gridElements, Map modMap) {
            Iterator rbtit = this.resultsByTarget_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTarg er4g = (ExtractResultForTarg)rbtit.next();
                er4g.collectGridElements(cpIDs, gridElements, modMap);
            }
        }

        void shiftPaths(Map movedPts) {
            Iterator rbtit = this.resultsByTarget_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTarg er4g = (ExtractResultForTarg)rbtit.next();
                er4g.shiftPaths(movedPts);
            }
        }

        void addToMultiDataMap(Map multiDataMap) {
            Iterator rbtit = this.resultsByTarget_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTarg er4g = (ExtractResultForTarg)rbtit.next();
                er4g.addToMultiDataMap(multiDataMap);
            }
        }
    }

    public static class ExtractResultForSource
    implements Cloneable {
        private HashMap resultsByTrees_ = new HashMap();
        private HashMap trgToTree_ = new HashMap();
        private String srcMod_;

        ExtractResultForSource(String srcMod) {
            this.srcMod_ = srcMod;
        }

        public Object clone() {
            try {
                ExtractResultForSource retval = (ExtractResultForSource)super.clone();
                retval.resultsByTrees_ = new HashMap();
                Iterator rbtit = this.resultsByTrees_.keySet().iterator();
                while (rbtit.hasNext()) {
                    String treeID = (String)rbtit.next();
                    ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(treeID);
                    ExtractResultForTree retEr4t = (ExtractResultForTree)er4t.clone();
                    retval.resultsByTrees_.put(treeID, retEr4t);
                }
                retval.trgToTree_ = (HashMap)this.trgToTree_.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public Map getTargetMods() {
            HashMap<String, Integer> retval = new HashMap<String, Integer>();
            Iterator mtit = this.trgToTree_.keySet().iterator();
            while (mtit.hasNext()) {
                String trgMod = (String)mtit.next();
                String useTree = (String)this.trgToTree_.get(trgMod);
                ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(useTree);
                Set s2m = er4t.getSourcesToModule(trgMod);
                retval.put(trgMod, new Integer(s2m.size()));
            }
            return retval;
        }

        public ExtractResultForTarg getResultForTarg(String trgMod) {
            String useTree = (String)this.trgToTree_.get(trgMod);
            ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(useTree);
            return er4t.getResultForTarg(trgMod);
        }

        public Map getAllDepartures() {
            HashMap<String, HashSet<Vector2D>> retval = new HashMap<String, HashSet<Vector2D>>();
            Iterator rbtit = this.resultsByTrees_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTree er4t = (ExtractResultForTree)rbtit.next();
                Set as = er4t.getAllSources();
                Vector2D depDir = new Vector2D(er4t.getDepartureDir());
                Iterator asit = as.iterator();
                while (asit.hasNext()) {
                    String src = (String)asit.next();
                    HashSet<Vector2D> all4src = (HashSet<Vector2D>)retval.get(src);
                    if (all4src == null) {
                        all4src = new HashSet<Vector2D>();
                        retval.put(src, all4src);
                    }
                    all4src.add(depDir);
                }
            }
            return retval;
        }

        public Map getArrivalDirs(String trgMod) {
            String useTree = (String)this.trgToTree_.get(trgMod);
            if (useTree == null) {
                return null;
            }
            ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(useTree);
            HashMap<String, Vector2D> retval = new HashMap<String, Vector2D>();
            Vector2D arr = new Vector2D(er4t.getArrivalDir(trgMod));
            Set s2m = er4t.getSourcesToModule(trgMod);
            Iterator s2mit = s2m.iterator();
            while (s2mit.hasNext()) {
                String src = (String)s2mit.next();
                retval.put(src, arr);
            }
            return retval;
        }

        ExtractResultForTarg getOrPrepResultForTarg(String trgMod, String treeID) {
            ExtractResultForTree er4t;
            String useTree = (String)this.trgToTree_.get(trgMod);
            if (useTree == null) {
                er4t = (ExtractResultForTree)this.resultsByTrees_.get(treeID);
                if (er4t == null) {
                    er4t = new ExtractResultForTree(treeID);
                    this.resultsByTrees_.put(er4t.getTreeID(), er4t);
                }
                this.trgToTree_.put(trgMod, treeID);
            } else {
                if (!useTree.equals(treeID)) {
                    throw new IllegalStateException();
                }
                er4t = (ExtractResultForTree)this.resultsByTrees_.get(useTree);
            }
            return er4t.getResultForTarg(trgMod);
        }

        void addResultForTarg(String trgMod, ExtractResultForTarg er4g) {
            String treeID = (String)this.trgToTree_.get(trgMod);
            ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(treeID);
            er4t.addResultForTarg(er4g);
        }

        void reverse() {
            Iterator rbtit = this.resultsByTrees_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTree er4t = (ExtractResultForTree)rbtit.next();
                er4t.reverse();
            }
        }

        void sourceGoesToModule(String src, String module) {
            String useTree = (String)this.trgToTree_.get(module);
            if (useTree == null) {
                return;
            }
            ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(useTree);
            er4t.sourceGoesToModule(src, module);
        }

        public void setSourceOrder(SortedMap sourceOrder) {
            Iterator rbtit = this.resultsByTrees_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTree er4t = (ExtractResultForTree)rbtit.next();
                er4t.setSourceOrder(sourceOrder);
            }
        }

        public void collectGridElements(Set cpIDs, List gridElements, Map modMap) {
            Iterator rbtit = this.resultsByTrees_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTree er4t = (ExtractResultForTree)rbtit.next();
                er4t.collectGridElements(cpIDs, gridElements, modMap);
            }
        }

        public void shiftPaths(Map movedPts) {
            Iterator rbtit = this.resultsByTrees_.values().iterator();
            while (rbtit.hasNext()) {
                ExtractResultForTree er4t = (ExtractResultForTree)rbtit.next();
                er4t.shiftPaths(movedPts);
            }
        }

        public void buildMultiDataMap(Map multiDataMap) {
            Iterator rbtit = this.resultsByTrees_.keySet().iterator();
            while (rbtit.hasNext()) {
                String treeID = (String)rbtit.next();
                ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(treeID);
                HashMap myResult = new HashMap();
                multiDataMap.put(treeID, myResult);
                er4t.addToMultiDataMap(myResult);
            }
        }

        public void buildDepartureData(Map pointData, Map vectorData) {
            Iterator rbtit = this.resultsByTrees_.keySet().iterator();
            while (rbtit.hasNext()) {
                String treeID = (String)rbtit.next();
                ExtractResultForTree er4t = (ExtractResultForTree)this.resultsByTrees_.get(treeID);
                Vector2D depDir = er4t.getDepartureDir();
                vectorData.put(treeID, depDir);
                Map depPts = er4t.getDeparturePoints();
                pointData.put(treeID, depPts);
            }
        }
    }
}

