/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class OverlayLayoutAnalyzer {
    public OverlayReport canSupport(Genome genome, Layout lo, FontRenderContext frc, String overlayKey) {
        Database db = Database.getDB();
        String genomeKey = genome.getID();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
        NetworkOverlay nov = owner.getNetworkOverlay(overlayKey);
        NetOverlayProperties noProps = lo.getNetOverlayProperties(overlayKey);
        Iterator nmpkit = noProps.getNetModulePropertiesKeys();
        while (nmpkit.hasNext()) {
            String propID = (String)nmpkit.next();
            NetModuleProperties nmp = noProps.getNetModuleProperties(propID);
            int nmpType = nmp.getType();
            if (nmpType == 0) continue;
            return new OverlayReport(1);
        }
        Iterator nmlpkit = noProps.getNetModuleLinkagePropertiesKeys();
        while (nmlpkit.hasNext()) {
            String treeID = (String)nmlpkit.next();
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
            Set nonOrtho = nmlp.getNonOrthoSegments(genome, lo, frc);
            if (nonOrtho.isEmpty()) continue;
            return new OverlayReport(6);
        }
        Map boundsPerMod = lo.getLayoutBoundsForEachNetModule(genome, owner, overlayKey, frc);
        HashSet<String> seenOuter = new HashSet<String>();
        Iterator bit = boundsPerMod.keySet().iterator();
        while (bit.hasNext()) {
            String key = (String)bit.next();
            seenOuter.add(key);
            Rectangle bounds = (Rectangle)boundsPerMod.get(key);
            Iterator bit2 = boundsPerMod.keySet().iterator();
            while (bit2.hasNext()) {
                Rectangle bounds2;
                String key2 = (String)bit2.next();
                if (seenOuter.contains(key2) || !(bounds2 = (Rectangle)boundsPerMod.get(key2)).intersects(bounds)) continue;
                return new OverlayReport(2);
            }
        }
        HashSet<String> allNodes = new HashSet<String>();
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            allNodes.add(node.getID());
        }
        HashMap<String, String> inMod = new HashMap<String, String>();
        Iterator mit = nov.getModuleIterator();
        while (mit.hasNext()) {
            NetModule nmod = (NetModule)mit.next();
            Iterator memit = nmod.getMemberIterator();
            while (memit.hasNext()) {
                NetModuleMember nmm = (NetModuleMember)memit.next();
                String nmmID = nmm.getID();
                if (inMod.containsKey(nmmID)) {
                    return new OverlayReport(3);
                }
                inMod.put(nmmID, nmod.getID());
                allNodes.remove(nmmID);
            }
        }
        if (!allNodes.isEmpty()) {
            return new OverlayReport(7);
        }
        HashSet<Link> needsForLinks = new HashSet<Link>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            String srcMod = (String)inMod.get(src);
            String trgMod = (String)inMod.get(trg);
            if (srcMod == null || trgMod == null || srcMod.equals(trgMod)) continue;
            Link interMod = new Link(srcMod, trgMod);
            needsForLinks.add(interMod);
        }
        HashSet<Link> duplicated = new HashSet<Link>();
        HashSet unsatisfied = new HashSet(needsForLinks);
        Iterator mlit = nov.getLinkageIterator();
        while (mlit.hasNext()) {
            NetModuleLinkage nmodLink = (NetModuleLinkage)mlit.next();
            if (nmodLink.getSign() == -1) {
                return new OverlayReport(9);
            }
            String srcMod = nmodLink.getSource();
            String trgMod = nmodLink.getTarget();
            Link interMod = new Link(srcMod, trgMod);
            unsatisfied.remove(interMod);
            if (duplicated.contains(interMod)) {
                return new OverlayReport(4);
            }
            duplicated.add(interMod);
        }
        if (!unsatisfied.isEmpty()) {
            TreeSet<String> msgList = new TreeSet<String>();
            Iterator unit = unsatisfied.iterator();
            while (unit.hasNext()) {
                Link missing = (Link)unit.next();
                String srcName = nov.getModule(missing.getSrc()).getName();
                String trgName = nov.getModule(missing.getTrg()).getName();
                msgList.add(srcName + " -> " + trgName);
            }
            return new OverlayReport(unsatisfied, new ArrayList(msgList));
        }
        if (lo.netModuleLinksPadCollisions(overlayKey)) {
            return new OverlayReport(8);
        }
        return new OverlayReport(0);
    }

    public static class OverlayReport {
        public static final int NO_PROBLEMS = 0;
        public static final int NOT_ALL_CONTIG_RECT = 1;
        public static final int MODULES_OVERLAP = 2;
        public static final int NODE_IN_MULTIPLE_MODULES = 3;
        public static final int DUPLICATED_LINKS = 4;
        public static final int MISSING_LINKS = 5;
        public static final int CROOKED_LINKS = 6;
        public static final int NODE_NOT_IN_MODULE = 7;
        public static final int SHARED_MODULE_LINK_PADS = 8;
        public static final int NEGATIVE_LINK_SIGN = 9;
        private int result_;
        private Set missingLinks_;
        private List missingMsgs_;

        OverlayReport(int result) {
            this.result_ = result;
        }

        OverlayReport(Set missingLinks, List msgs) {
            this.result_ = 5;
            this.missingLinks_ = missingLinks;
            this.missingMsgs_ = msgs;
        }

        public int getResult() {
            return this.result_;
        }

        public Set getMissingLinks() {
            return this.missingLinks_;
        }

        public List getMissingLinkMessages() {
            return this.missingMsgs_;
        }

        public String getResultMessage() {
            ResourceManager rMan = ResourceManager.getManager();
            String suffix = "badNews";
            switch (this.result_) {
                case 0: {
                    suffix = "noProblem";
                    break;
                }
                case 1: {
                    suffix = "notContig";
                    break;
                }
                case 2: {
                    suffix = "overlap";
                    break;
                }
                case 3: {
                    suffix = "multiMod";
                    break;
                }
                case 4: {
                    suffix = "dupModLinks";
                    break;
                }
                case 5: {
                    suffix = "missingLinks";
                    break;
                }
                case 6: {
                    suffix = "crookedLinks";
                    break;
                }
                case 7: {
                    suffix = "noModForNode";
                    break;
                }
                case 8: {
                    suffix = "linkPadCollide";
                    break;
                }
                case 9: {
                    suffix = "negLinkSign";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return rMan.getString("overlayAnalyzer." + suffix);
        }
    }
}

