/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.ClusterBuilder;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;

public class RowBuilder {
    public SortedMap buildRowsByAssignment(List sClustList, SortedMap assignments) {
        int numClust = sClustList.size();
        HashMap<String, GeneAndSatelliteCluster> idToGasc = new HashMap<String, GeneAndSatelliteCluster>();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            String srcID = sc.getCoreID();
            idToGasc.put(srcID, sc);
        }
        TreeMap retval = new TreeMap();
        Iterator aksit = assignments.keySet().iterator();
        while (aksit.hasNext()) {
            Integer rowNum = (Integer)aksit.next();
            ArrayList<GeneAndSatelliteCluster> gascList = new ArrayList<GeneAndSatelliteCluster>();
            retval.put(rowNum, gascList);
            ArrayList perRow = (ArrayList)assignments.get(rowNum);
            int numPer = perRow.size();
            for (int i = 0; i < numPer; ++i) {
                String coreID = (String)perRow.get(i);
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)idToGasc.get(coreID);
                gascList.add(sc);
            }
        }
        return retval;
    }

    public SortedMap buildClusterSeriesBySort(List sClustList, Map topoSort, int maxSize, Integer startKey) {
        Integer depth;
        int numClust = sClustList.size();
        TreeMap<Integer, Integer> numPerDepth = new TreeMap<Integer, Integer>();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            String srcID = sc.getCoreID();
            depth = (Integer)topoSort.get(srcID);
            Integer perDepth = (Integer)numPerDepth.get(depth);
            if (perDepth == null) {
                numPerDepth.put(depth, new Integer(1));
                continue;
            }
            int newPerDepth = perDepth + 1;
            numPerDepth.put(depth, new Integer(newPerDepth));
        }
        HashMap<Integer, Integer> baseKeys = new HashMap<Integer, Integer>();
        int currKey = startKey == null ? 0 : startKey;
        Iterator kit = numPerDepth.keySet().iterator();
        while (kit.hasNext()) {
            depth = (Integer)kit.next();
            Integer max = (Integer)numPerDepth.get(depth);
            baseKeys.put(depth, new Integer(currKey));
            int numKeys = max / maxSize + 1;
            currKey += numKeys;
        }
        TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>> retval = new TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>>();
        HashMap<Integer, Integer> seenPerDepth = new HashMap<Integer, Integer>();
        for (int i = 0; i < numClust; ++i) {
            int keyOffset;
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            String srcID = sc.getCoreID();
            Integer depth2 = (Integer)topoSort.get(srcID);
            Integer perDepth = (Integer)seenPerDepth.get(depth2);
            if (perDepth == null) {
                seenPerDepth.put(depth2, new Integer(1));
                keyOffset = 0;
            } else {
                int newPerDepth = perDepth + 1;
                seenPerDepth.put(depth2, new Integer(newPerDepth));
                keyOffset = newPerDepth / maxSize;
            }
            Integer keyBase = (Integer)baseKeys.get(depth2);
            int keyValue = keyBase + keyOffset;
            Integer keyValueObj = new Integer(keyValue);
            ArrayList<GeneAndSatelliteCluster> perLev = (ArrayList<GeneAndSatelliteCluster>)retval.get(keyValueObj);
            if (perLev == null) {
                perLev = new ArrayList<GeneAndSatelliteCluster>();
                retval.put(keyValueObj, perLev);
            }
            perLev.add(sc);
        }
        return retval;
    }

    public SortedMap assignRowsByTime(List geneClusters, int max, Integer startKey) {
        int count;
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>> tClustRows = new TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>>();
        int numTClust = geneClusters.size();
        for (int i = 0; i < numTClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)geneClusters.get(i);
            int firstTime = tcd.getFirstExpressionTime(tc.getCoreID());
            Integer rowObj = new Integer(firstTime);
            ArrayList<GeneAndSatelliteCluster> perTime = (ArrayList<GeneAndSatelliteCluster>)tClustRows.get(rowObj);
            if (perTime == null) {
                perTime = new ArrayList<GeneAndSatelliteCluster>();
                tClustRows.put(rowObj, perTime);
            }
            perTime.add(tc);
        }
        TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>> retval = new TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>>();
        Iterator ntcit = tClustRows.values().iterator();
        int n = count = startKey == null ? 0 : startKey * max;
        while (ntcit.hasNext()) {
            ArrayList perName = (ArrayList)ntcit.next();
            int numPN = perName.size();
            for (int i = 0; i < numPN; ++i) {
                int key;
                Integer rowObj;
                ArrayList<GeneAndSatelliteCluster> perTime;
                GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)perName.get(i);
                if ((perTime = (ArrayList<GeneAndSatelliteCluster>)retval.get(rowObj = new Integer(key = count++ / max))) == null) {
                    perTime = new ArrayList<GeneAndSatelliteCluster>();
                    retval.put(rowObj, perTime);
                }
                perTime.add(tc);
            }
        }
        return retval;
    }

    public SortedMap assignRowsByAlpha(List geneClusters, Genome genome, int max, Integer startKey) {
        int count;
        TreeMap<String, ArrayList<GeneAndSatelliteCluster>> nameToGAS = new TreeMap<String, ArrayList<GeneAndSatelliteCluster>>();
        int numTClust = geneClusters.size();
        for (int i = 0; i < numTClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)geneClusters.get(i);
            String core = tc.getCoreID();
            String coreName = genome.getNode(core).getName().toUpperCase();
            ArrayList<GeneAndSatelliteCluster> perName = (ArrayList<GeneAndSatelliteCluster>)nameToGAS.get(coreName);
            if (perName == null) {
                perName = new ArrayList<GeneAndSatelliteCluster>();
                nameToGAS.put(coreName, perName);
            }
            perName.add(tc);
        }
        TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>> tClustRows = new TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>>();
        Iterator ntcit = nameToGAS.values().iterator();
        int n = count = startKey == null ? 0 : startKey * max;
        while (ntcit.hasNext()) {
            ArrayList perName = (ArrayList)ntcit.next();
            int numPN = perName.size();
            for (int i = 0; i < numPN; ++i) {
                int key;
                Integer rowObj;
                ArrayList<GeneAndSatelliteCluster> perTime;
                GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)perName.get(i);
                if ((perTime = (ArrayList<GeneAndSatelliteCluster>)tClustRows.get(rowObj = new Integer(key = count++ / max))) == null) {
                    perTime = new ArrayList<GeneAndSatelliteCluster>();
                    tClustRows.put(rowObj, perTime);
                }
                perTime.add(tc);
            }
        }
        return tClustRows;
    }

    public SortedMap assignRowsByInputs(List geneClusters, Genome genome, int max, boolean doChunked, Integer startKey) {
        List clusterOrder;
        GenomeItemInstance.DBAndInstanceConsistentComparator cc = new GenomeItemInstance.DBAndInstanceConsistentComparator();
        TreeSet<String> targetNodes = new TreeSet<String>(cc);
        HashMap<String, Set> inboundLinkMap = new HashMap<String, Set>();
        HashMap<String, GeneAndSatelliteCluster> coreToGAS = new HashMap<String, GeneAndSatelliteCluster>();
        int numTClust = geneClusters.size();
        for (int i = 0; i < numTClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)geneClusters.get(i);
            String core = tc.getCoreID();
            Set inboundLinks = tc.getInboundLinks();
            inboundLinkMap.put(core, inboundLinks);
            coreToGAS.put(core, tc);
            targetNodes.add(core);
        }
        TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>> tClustRows = new TreeMap<Integer, ArrayList<GeneAndSatelliteCluster>>();
        ClusterBuilder cb = new ClusterBuilder(genome, targetNodes, inboundLinkMap);
        cb.buildClusters();
        if (doChunked) {
            clusterOrder = cb.getChunkedOrdering();
            int coSize = clusterOrder.size();
            int currRow = startKey == null ? 0 : startKey;
            int currIndex = 0;
            while (currIndex < coSize) {
                List chunkList = (List)clusterOrder.get(currIndex);
                int clSize = chunkList.size();
                if (clSize >= max) {
                    currRow = this.assignLargeCluster(chunkList, tClustRows, coreToGAS, currRow, max);
                    ++currIndex;
                    continue;
                }
                currIndex = this.assignSmallClusterSeries(clusterOrder, currIndex, tClustRows, coreToGAS, currRow, max);
                ++currRow;
            }
        } else {
            clusterOrder = cb.getOrdering();
            int coSize = clusterOrder.size();
            int base = startKey == null ? 0 : startKey;
            for (int i = 0; i < coSize; ++i) {
                String coreID = (String)clusterOrder.get(i);
                GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)coreToGAS.get(coreID);
                int key = i / max + base;
                Integer rowObj = new Integer(key);
                ArrayList<GeneAndSatelliteCluster> perRow = (ArrayList<GeneAndSatelliteCluster>)tClustRows.get(rowObj);
                if (perRow == null) {
                    perRow = new ArrayList<GeneAndSatelliteCluster>();
                    tClustRows.put(rowObj, perRow);
                }
                perRow.add(tc);
            }
        }
        return tClustRows;
    }

    private int assignLargeCluster(List chunkList, SortedMap tClustRows, Map coreToGAS, int currRow, int max) {
        int extra;
        int balanced;
        int clSize = chunkList.size();
        if (clSize < max) {
            throw new IllegalArgumentException();
        }
        if (clSize > max) {
            int numRows = clSize / max + 1;
            balanced = clSize / numRows;
            extra = clSize - balanced * numRows;
        } else {
            balanced = clSize;
            extra = 0;
        }
        int perRow = 1;
        int extraPerRow = 0;
        for (int j = 0; j < clSize; ++j) {
            String coreID = (String)chunkList.get(j);
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)coreToGAS.get(coreID);
            Integer rowObj = new Integer(currRow);
            ArrayList<GeneAndSatelliteCluster> perTime = (ArrayList<GeneAndSatelliteCluster>)tClustRows.get(rowObj);
            if (perTime == null) {
                perTime = new ArrayList<GeneAndSatelliteCluster>();
                tClustRows.put(rowObj, perTime);
            }
            perTime.add(tc);
            if (perRow >= balanced) {
                if (extra > 0 && extraPerRow == 0) {
                    --extra;
                    ++extraPerRow;
                    ++perRow;
                    continue;
                }
                ++currRow;
                perRow = 1;
                extraPerRow = 0;
                continue;
            }
            ++perRow;
        }
        return ++currRow;
    }

    private int assignSmallClusterSeries(List clusterOrder, int currIndex, SortedMap tClustRows, Map coreToGAS, int currRow, int max) {
        ArrayList cand;
        Integer scObj;
        int clSize;
        int coSize = clusterOrder.size();
        TreeMap<Integer, ArrayList<ClusterBuilder.IntAnnotatedList>> bySize = new TreeMap<Integer, ArrayList<ClusterBuilder.IntAnnotatedList>>();
        for (int perRow = 0; perRow <= max && currIndex < coSize; perRow += clSize) {
            ClusterBuilder.IntAnnotatedList chunkList = (ClusterBuilder.IntAnnotatedList)clusterOrder.get(currIndex);
            clSize = chunkList.size();
            if (perRow + clSize > max) continue;
            int sourceCount = chunkList.val;
            scObj = new Integer(sourceCount);
            cand = (ArrayList)bySize.get(scObj);
            if (cand == null) {
                cand = new ArrayList();
                bySize.put(scObj, cand);
            }
            cand.add(chunkList);
            ++currIndex;
        }
        ArrayList revList = new ArrayList(bySize.keySet());
        Collections.reverse(revList);
        int numRev = revList.size();
        for (int i = 0; i < numRev; ++i) {
            scObj = (Integer)revList.get(i);
            cand = (ArrayList)bySize.get(scObj);
            int numCand = cand.size();
            for (int j = 0; j < numCand; ++j) {
                ClusterBuilder.IntAnnotatedList chunkList = (ClusterBuilder.IntAnnotatedList)cand.get(j);
                int clSize2 = chunkList.size();
                for (int k = 0; k < clSize2; ++k) {
                    String coreID = (String)chunkList.get(k);
                    GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)coreToGAS.get(coreID);
                    Integer rowObj = new Integer(currRow);
                    ArrayList<GeneAndSatelliteCluster> perTime = (ArrayList<GeneAndSatelliteCluster>)tClustRows.get(rowObj);
                    if (perTime == null) {
                        perTime = new ArrayList<GeneAndSatelliteCluster>();
                        tClustRows.put(rowObj, perTime);
                    }
                    perTime.add(tc);
                }
            }
        }
        return currIndex;
    }
}

