/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.systemsbiology.biotapestry.ui.layouts.LayoutCompressionFramework;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class SpecialtyInstructions {
    public boolean assignColorsAfterLayout = false;
    public Map nodeColors;
    public Map linkColors;
    public Map nodeLocations;
    public Map padChanges;
    public Map lengthChanges;
    public Map orientChanges;
    public Map extraGrowthChanges;
    private Map linkData_ = new HashMap();
    private SortedMap sourceOrder_;
    private Rectangle strictGrownBounds_;
    private Rectangle origNodeBounds_;
    private Rectangle origModuleBounds_;
    private Rectangle placedStackBounds_;
    private Rectangle placedStackNodeOnlyBounds_;
    private Rectangle placedFullBounds_;
    private Map placedFullBoundsPerSrc_;
    public LayoutCompressionFramework lcf;
    public String moduleID;

    public SpecialtyInstructions(Map padChanges) {
        this.nodeColors = new HashMap();
        this.linkColors = new HashMap();
        this.nodeLocations = new HashMap();
        this.lengthChanges = new HashMap();
        this.orientChanges = new HashMap();
        this.extraGrowthChanges = new HashMap();
        this.padChanges = padChanges;
        this.origNodeBounds_ = null;
        this.placedStackBounds_ = null;
        this.placedStackNodeOnlyBounds_ = null;
        this.placedFullBounds_ = null;
        this.origModuleBounds_ = null;
        this.strictGrownBounds_ = null;
        this.placedFullBoundsPerSrc_ = new HashMap();
        this.lcf = null;
        this.moduleID = null;
    }

    public void setSourceOrder(SortedMap sourceOrder) {
        this.sourceOrder_ = sourceOrder;
    }

    public SortedMap getSourceOrder() {
        return this.sourceOrder_;
    }

    public void setOrigNodeBounds(Rectangle bounds) {
        this.origNodeBounds_ = bounds == null ? null : (Rectangle)bounds.clone();
    }

    public void setPlacedStackBounds(Rectangle bounds) {
        this.placedStackBounds_ = bounds == null ? null : (Rectangle)bounds.clone();
    }

    public void setPlacedStackNodeOnlyBounds(Rectangle bounds) {
        this.placedStackNodeOnlyBounds_ = bounds == null ? null : (Rectangle)bounds.clone();
    }

    public void setOrigModuleRect(Rectangle bounds) {
        this.origModuleBounds_ = bounds == null ? null : (Rectangle)bounds.clone();
    }

    public boolean hasLinkPointsForSrc(String srcID) {
        return this.linkData_.containsKey(srcID);
    }

    public Iterator getLinkSrcIterator() {
        return this.linkData_.keySet().iterator();
    }

    public SpecialtyLayoutLinkData getLinkPointsForSrc(String srcID) {
        return (SpecialtyLayoutLinkData)this.linkData_.get(srcID);
    }

    public SpecialtyLayoutLinkData getOrStartLinkPointsForSrc(String srcID) {
        SpecialtyLayoutLinkData slld = (SpecialtyLayoutLinkData)this.linkData_.get(srcID);
        if (slld == null) {
            slld = new SpecialtyLayoutLinkData(srcID);
            this.linkData_.put(srcID, slld);
        }
        return slld;
    }

    public void setLinkPointsForSrc(String srcID, SpecialtyLayoutLinkData slld) {
        this.linkData_.put(srcID, slld);
    }

    public Rectangle getOrigModuleRect() {
        return this.origModuleBounds_;
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public Rectangle getPlacedFullBounds() {
        if (this.placedStackBounds_ != null && this.placedFullBounds_ != null) {
            return this.placedFullBounds_.union(this.placedStackBounds_);
        }
        return this.placedFullBounds_;
    }

    public Rectangle getStrictGrownBounds() {
        return this.strictGrownBounds_;
    }

    public void setStrictGrownBounds(Rectangle strictGrown) {
        this.strictGrownBounds_ = strictGrown == null ? null : (Rectangle)strictGrown.clone();
    }

    public Rectangle getPlacedStackBounds() {
        return this.placedStackBounds_;
    }

    public Rectangle getPlacedStackNodeOnlyBounds() {
        return this.placedStackNodeOnlyBounds_;
    }

    public Rectangle getOrigNodeBounds() {
        return this.origNodeBounds_;
    }

    public Rectangle getLinkBoundsForSrc(String srcID) {
        return (Rectangle)this.placedFullBoundsPerSrc_.get(srcID);
    }

    public void setBoundsForLinks(NetModuleLinkExtractor.SubsetAnalysis sa) {
        HashMap allDepartures = null;
        HashMap allArrivals = null;
        if (this.moduleID != null) {
            allDepartures = new HashMap();
            allArrivals = new HashMap();
            this.departsAndArrives(sa, allDepartures, allArrivals);
        }
        Iterator siit = this.linkData_.keySet().iterator();
        while (siit.hasNext()) {
            String srcID = (String)siit.next();
            SpecialtyLayoutLinkData si = (SpecialtyLayoutLinkData)this.linkData_.get(srcID);
            Rectangle sib = UiUtil.rectFromRect2D(si.getLinkBounds(allArrivals, allDepartures));
            if (sib == null) continue;
            if (this.placedFullBounds_ == null) {
                this.placedFullBounds_ = (Rectangle)sib.clone();
            } else {
                Bounds.tweakBounds(this.placedFullBounds_, sib);
            }
            this.placedFullBoundsPerSrc_.put(srcID, sib);
        }
        if (this.origModuleBounds_ != null && this.placedFullBounds_ != null) {
            double oH = this.origModuleBounds_.getHeight();
            double pH = this.placedFullBounds_.getHeight();
            double oW = this.origModuleBounds_.getWidth();
            double pW = this.placedFullBounds_.getWidth();
            double diffH = oH > pH ? oH - pH : 0.0;
            double diffW = oW > pW ? oW - pW : 0.0;
            diffH = UiUtil.forceToGridValueMax(diffH / 2.0, 10.0);
            diffW = UiUtil.forceToGridValueMax(diffW / 2.0, 10.0);
            if (diffH > 0.0 || diffW > 0.0) {
                this.placedFullBounds_ = UiUtil.rectFromRect2D(UiUtil.padTheRect(this.placedFullBounds_, diffH, diffW));
            }
        }
    }

    private void departsAndArrives(NetModuleLinkExtractor.SubsetAnalysis sa, Map allDepartures, Map allArrivals) {
        Iterator impit = sa.getInterModPathKeys();
        while (impit.hasNext()) {
            String modID = (String)impit.next();
            NetModuleLinkExtractor.ExtractResultForSource er4s = sa.getExtractResultForSource(modID);
            if (modID.equals(this.moduleID)) {
                Map departs = er4s.getAllDepartures();
                if (departs == null) continue;
                allDepartures.putAll(departs);
                continue;
            }
            Map ad = er4s.getArrivalDirs(this.moduleID);
            if (ad == null) continue;
            Iterator kit = ad.keySet().iterator();
            while (kit.hasNext()) {
                String src = (String)kit.next();
                HashSet<Vector2D> ad4s = (HashSet<Vector2D>)allArrivals.get(src);
                if (ad4s == null) {
                    ad4s = new HashSet<Vector2D>();
                    allArrivals.put(src, ad4s);
                }
                Vector2D myArr = (Vector2D)ad.get(src);
                ad4s.add(myArr);
            }
        }
    }

    public Map getShiftedLinkDataCopy(Vector2D shiftVec) {
        HashMap<String, SpecialtyLayoutLinkData> retval = new HashMap<String, SpecialtyLayoutLinkData>();
        Iterator siit = this.linkData_.keySet().iterator();
        while (siit.hasNext()) {
            String srcID = (String)siit.next();
            SpecialtyLayoutLinkData si = (SpecialtyLayoutLinkData)this.linkData_.get(srcID);
            SpecialtyLayoutLinkData siCopy = (SpecialtyLayoutLinkData)si.clone();
            siCopy.shift(shiftVec);
            retval.put(srcID, siCopy);
        }
        return retval;
    }

    public void shiftNodesOnly(Vector2D shiftVec) {
        Iterator locit = this.nodeLocations.values().iterator();
        while (locit.hasNext()) {
            Point2D loc = (Point2D)locit.next();
            loc.setLocation(shiftVec.add(loc));
        }
    }

    public void shift(Vector2D shiftVec, boolean skipNodes) {
        Point2D loc;
        Iterator siit = this.linkData_.values().iterator();
        while (siit.hasNext()) {
            SpecialtyLayoutLinkData si = (SpecialtyLayoutLinkData)siit.next();
            si.shift(shiftVec);
        }
        if (!skipNodes) {
            Iterator locit = this.nodeLocations.values().iterator();
            while (locit.hasNext()) {
                Point2D loc2 = (Point2D)locit.next();
                loc2.setLocation(shiftVec.add(loc2));
            }
        }
        if (this.placedStackBounds_ != null) {
            loc = this.placedStackBounds_.getLocation();
            loc = shiftVec.add(loc);
            this.placedStackBounds_.setLocation((int)loc.getX(), (int)loc.getY());
        }
        if (this.placedStackNodeOnlyBounds_ != null) {
            loc = this.placedStackNodeOnlyBounds_.getLocation();
            loc = shiftVec.add(loc);
            this.placedStackNodeOnlyBounds_.setLocation((int)loc.getX(), (int)loc.getY());
        }
        if (this.placedFullBounds_ != null) {
            loc = this.placedFullBounds_.getLocation();
            loc = shiftVec.add(loc);
            this.placedFullBounds_.setLocation((int)loc.getX(), (int)loc.getY());
        }
        Iterator pfbit = this.placedFullBoundsPerSrc_.values().iterator();
        while (pfbit.hasNext()) {
            Rectangle rec = (Rectangle)pfbit.next();
            Point2D loc3 = rec.getLocation();
            loc3 = shiftVec.add(loc3);
            rec.setLocation((int)loc3.getX(), (int)loc3.getY());
        }
        if (this.lcf != null) {
            Iterator bit = this.lcf.getBounds();
            while (bit.hasNext()) {
                Rectangle brect = (Rectangle)bit.next();
                Point2D loc4 = brect.getLocation();
                loc4 = shiftVec.add(loc4);
                brect.setLocation((int)loc4.getX(), (int)loc4.getY());
            }
        }
    }
}

