/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.analysis.CenteredGridElement;
import org.systemsbiology.biotapestry.analysis.GridElement;
import org.systemsbiology.biotapestry.analysis.GridGrower;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LayoutRubberStamper;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.freerender.GroupFree;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.LinkModuleBoundaryBuilder;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayout;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutData;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;
import org.systemsbiology.biotapestry.util.Vector2D;

public class SpecialtyLayoutEngine {
    private static final int MODULE_LINK_PAD_ = 8;
    private static final int MODULE_EXPAND_LIMIT_ = 50;
    private static final int MODULE_NOPROGRESS_LIMIT_ = 10;
    private FontRenderContext fixedFrc_ = new FontRenderContext(null, true, true);
    private List subsetListIn_;
    private Layout lox2_;
    private SpecialtyLayout specL_;
    private NetModuleLinkExtractor.SubsetAnalysis sa_;
    private Point2D fullGenomeCenter_;
    private AddCommands ac_;
    private SpecialtyLayoutEngineParams params_;
    private boolean fromScratch_;
    private Layout.PadNeedsForLayout padNeedsForLayout_;
    private Map moduleShapeRecovery_;
    private boolean hideNames_;
    private List topoSortedSubsetList_;
    private List propList_;
    private Map splicePlans_;
    private Map rememberProps_;
    private HashMap shiftedIMP_ = new HashMap();
    private Vector2D shiftedAmount_ = new Vector2D(0.0, 0.0);
    private int overlayOption_;
    private HashSet newLinks_;
    private ArrayList forRecoveriesOut_;
    private HashMap alienSources_;
    private HashMap srcToBetween_;
    private Map nonOverlaySolutions_;
    private Rectangle nonOverlaySpliceBorders_;
    private Layout workingLayout_;
    private HashSet ultimateFailures_;
    private Layout.SupplementalDataCoords sdc_;

    public SpecialtyLayoutEngine(List subsetListIn, Layout lo, SpecialtyLayout specL, NetModuleLinkExtractor.SubsetAnalysis sa, Point2D fullGenomeCenter, AddCommands ac, SpecialtyLayoutEngineParams params, boolean fromScratch, boolean hideNames) {
        this.subsetListIn_ = subsetListIn;
        this.lox2_ = lo;
        this.specL_ = specL;
        this.sa_ = sa;
        this.fullGenomeCenter_ = fullGenomeCenter;
        this.ac_ = ac;
        this.params_ = params;
        this.fromScratch_ = fromScratch;
        this.hideNames_ = hideNames;
        this.newLinks_ = new HashSet();
        this.forRecoveriesOut_ = new ArrayList();
        this.alienSources_ = new HashMap();
        this.srcToBetween_ = new HashMap();
        this.workingLayout_ = null;
        this.ultimateFailures_ = new HashSet();
    }

    public List getForRecoveriesOut() {
        return this.forRecoveriesOut_;
    }

    public Layout getWorkingLayout() {
        return this.workingLayout_;
    }

    public Set getUltimateFailures() {
        return this.ultimateFailures_;
    }

    public Map getAlienSources() {
        return this.alienSources_;
    }

    public Map getSrcToBetween() {
        return this.srcToBetween_;
    }

    public Set getNewLinks() {
        return this.newLinks_;
    }

    public List getSortedGenomeSubsets() {
        return this.topoSortedSubsetList_;
    }

    public List getInstructions() {
        return this.propList_;
    }

    public Layout.PadNeedsForLayout getPadNeedsForLayout() {
        return this.padNeedsForLayout_;
    }

    public Map getModuleShapeRecovery() {
        return this.moduleShapeRecovery_;
    }

    public int getOverlayOption() {
        return this.overlayOption_;
    }

    public Layout getLayout() {
        return this.lox2_;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fixedFrc_;
    }

    public Map getRememberProps() {
        return this.rememberProps_;
    }

    public Map getSplicePlans() {
        return this.splicePlans_;
    }

    public Map getNonOverlaySplicePlans() {
        return this.nonOverlaySolutions_;
    }

    public Vector2D getShiftedAmount() {
        return this.shiftedAmount_;
    }

    public Map getModLinkCornerMoves() {
        return this.shiftedIMP_;
    }

    public Layout.SupplementalDataCoords getSupplementalDataCoords() {
        return this.sdc_;
    }

    public Point2D getFullGenomeCenter() {
        return this.fullGenomeCenter_;
    }

    public NetModuleLinkExtractor.SubsetAnalysis getSubsetAnalysis() {
        return this.sa_;
    }

    public boolean doFromScratch() {
        return this.fromScratch_;
    }

    public boolean doHideNames() {
        return this.hideNames_;
    }

    public void setModuleRecoveryData(Layout.PadNeedsForLayout padNeedsForLayout, Map moduleShapeRecovery) {
        this.padNeedsForLayout_ = padNeedsForLayout;
        this.moduleShapeRecovery_ = moduleShapeRecovery;
    }

    public LinkRouter.RoutingResult specialtyLayout(UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        SpecialtyInstructions results;
        int i;
        SpecialtyLayout forked;
        int i2;
        int numSub;
        this.workingLayout_ = new Layout(this.lox2_);
        Layout.OverlayKeySet loModKeys = null;
        if (this.padNeedsForLayout_ != null) {
            loModKeys = this.padNeedsForLayout_.getFullModuleKeys();
        }
        if ((numSub = this.subsetListIn_.size()) == 0) {
            return new LinkRouter.RoutingResult();
        }
        this.topoSortedSubsetList_ = this.sa_.topoReorder(this.subsetListIn_);
        GenomeSubset firstSubset = (GenomeSubset)this.subsetListIn_.get(0);
        Genome baseGenome = firstSubset.getBaseGenome();
        String overlayKey = firstSubset.getOverlayID();
        this.sdc_ = this.workingLayout_.getSupplementalCoords(baseGenome, this.fixedFrc_, loModKeys);
        this.rememberProps_ = this.workingLayout_.buildRememberProps(baseGenome, this.fixedFrc_);
        this.overlayOption_ = this.params_.getOverlayRelayoutOption();
        if (this.moduleShapeRecovery_ == null) {
            this.moduleShapeRecovery_ = this.workingLayout_.getModuleShapeParams(loModKeys, this.fixedFrc_, this.fullGenomeCenter_);
        }
        if (this.overlayOption_ == 0) {
            this.workingLayout_.convertAllModulesToMemberOnly(loModKeys, this.fixedFrc_);
        }
        TreeMap<Integer, String> existingOrder = new TreeMap<Integer, String>();
        HashMap globalPadChanges = new HashMap();
        GlobalSLEState gss = new GlobalSLEState(globalPadChanges);
        ArrayList<SpecialtyLayout> forkList = new ArrayList<SpecialtyLayout>();
        ArrayList<String> proc = new ArrayList<String>();
        for (i2 = 0; i2 < numSub; ++i2) {
            GenomeSubset subset = (GenomeSubset)this.topoSortedSubsetList_.get(i2);
            proc.add(subset.getModuleID());
            SpecialtyLayoutData sld = new SpecialtyLayoutData(subset, this.workingLayout_, this.fixedFrc_, this.params_);
            gss.addData(sld);
            SpecialtyLayout forked2 = this.specL_.forkForSubset(sld);
            forkList.add(forked2);
            SortedMap customOrder = this.customOrderForTarget(existingOrder, subset);
            forked2.layoutNodes(monitor, globalPadChanges, customOrder);
            if (sld.results == null) {
                return new LinkRouter.RoutingResult(4);
            }
            SortedMap outOrder = sld.results.getSourceOrder();
            if (outOrder != null) {
                int keyBase = 0;
                if (!existingOrder.isEmpty()) {
                    Integer last = (Integer)existingOrder.lastKey();
                    keyBase = last + 1;
                }
                Iterator ooit = outOrder.keySet().iterator();
                while (ooit.hasNext()) {
                    Integer key = (Integer)ooit.next();
                    String srcID = (String)outOrder.get(key);
                    if (existingOrder.containsValue(srcID)) continue;
                    existingOrder.put(new Integer(key + keyBase), srcID);
                }
            }
            if (monitor == null || monitor.keepGoing()) continue;
            throw new AsynchExitRequestException();
        }
        for (i2 = 0; i2 < numSub; ++i2) {
            forked = (SpecialtyLayout)forkList.get(i2);
            forked.routeLinks(gss, monitor);
            if (monitor == null || monitor.keepGoing()) continue;
            throw new AsynchExitRequestException();
        }
        for (i2 = 0; i2 < numSub; ++i2) {
            forked = (SpecialtyLayout)forkList.get(i2);
            forked.assignColors(monitor);
            if (monitor == null || monitor.keepGoing()) continue;
            throw new AsynchExitRequestException();
        }
        this.propList_ = new ArrayList();
        Iterator dit = gss.dataIterator();
        while (dit.hasNext()) {
            SpecialtyLayoutData sld = (SpecialtyLayoutData)dit.next();
            this.propList_.add(sld.results);
            if (sld.results != null) continue;
        }
        int pSize = this.propList_.size();
        for (i = 0; i < pSize; ++i) {
            NetModuleLinkExtractor.ExtractResultForSource er4s;
            String moduleID;
            results = (SpecialtyInstructions)this.propList_.get(i);
            if (results == null || (moduleID = results.getModuleID()) == null || (er4s = this.sa_.getExtractResultForSource(moduleID)) == null) continue;
            er4s.setSourceOrder(results.getSourceOrder());
        }
        for (i = 0; i < pSize; ++i) {
            results = (SpecialtyInstructions)this.propList_.get(i);
            if (results == null) continue;
            results.setBoundsForLinks(this.sa_);
        }
        String grpID = firstSubset.getGroupID();
        if (!firstSubset.isCompleteGenome() && overlayKey != null) {
            this.splicePlans_ = this.shiftTheModules(gss, overlayKey, this.workingLayout_, monitor);
        } else if (grpID == null) {
            ArrayList shiftVecs = new ArrayList();
            ArrayList shiftedCopies = new ArrayList();
            this.buildShiftedVecsAndCopies(gss, shiftVecs, shiftedCopies, new HashMap(), new HashMap(), null);
            this.installShift(gss, shiftVecs, new HashMap(), false);
        }
        double currStart = startFrac;
        Rectangle paddedBounds = null;
        if (!firstSubset.isCompleteGenome() && grpID != null) {
            GenomeInstance bgi = (GenomeInstance)baseGenome;
            LayoutRubberStamper lrs = new LayoutRubberStamper();
            HashSet<String> groups = new HashSet<String>();
            groups.add(grpID);
            double expandMax = currStart + (maxFrac - currStart) * 0.2;
            LayoutOptions options = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            options.overlayCpexOption = this.overlayOption_;
            GroupFree renderer = new GroupFree();
            Rectangle origRegionBounds = renderer.getBounds(baseGenome, bgi.getGroup(grpID), this.workingLayout_, this.fixedFrc_, null);
            Rectangle labelBounds = renderer.getLabelBounds(baseGenome, bgi.getGroup(grpID), this.workingLayout_, this.fixedFrc_);
            HashMap chopDeparts = new HashMap();
            HashMap chopArrives = new HashMap();
            this.chopForRegionLayout(firstSubset, this.workingLayout_, origRegionBounds, chopDeparts, chopArrives);
            SpecialtyInstructions props = (SpecialtyInstructions)this.propList_.get(0);
            Rectangle baseline = props.getPlacedFullBounds();
            if (baseline == null) {
                baseline = (Rectangle)origRegionBounds.clone();
            }
            paddedBounds = UiUtil.rectFromRect2D(UiUtil.padTheRect(baseline, 40.0));
            if (labelBounds != null) {
                paddedBounds.setLocation(paddedBounds.x, (int)UiUtil.forceToGridValueMin(paddedBounds.getY() - labelBounds.getHeight(), 10.0));
                paddedBounds.setSize(paddedBounds.width, (int)UiUtil.forceToGridValueMax(paddedBounds.getHeight() + labelBounds.getHeight(), 10.0));
            }
            Rectangle regx = (Rectangle)paddedBounds.clone();
            regx.setLocation(origRegionBounds.x, origRegionBounds.y);
            Vector2D shift = new Vector2D(UiUtil.forceToGridValue(origRegionBounds.x - paddedBounds.x, 10.0), UiUtil.forceToGridValue(origRegionBounds.y - paddedBounds.y, 10.0));
            props.shiftNodesOnly(shift);
            paddedBounds.x = (int)((double)paddedBounds.x + shift.getX());
            paddedBounds.y = (int)((double)paddedBounds.y + shift.getY());
            RegionLayoutExpander rexp = new RegionLayoutExpander(grpID, origRegionBounds, regx, support, firstSubset, paddedBounds, chopDeparts, chopArrives);
            Vector2D centeringShift = lrs.generalizedExpandRootInstanceLayout(this.workingLayout_, bgi, groups, rexp, this.ultimateFailures_, this.fixedFrc_, this.padNeedsForLayout_, loModKeys, this.moduleShapeRecovery_, options, monitor, currStart, expandMax, true);
            currStart = expandMax;
            shift = shift.add(centeringShift);
            shift = shift.add(rexp.getDelta(grpID));
            ArrayList<Vector2D> shiftVecs = new ArrayList<Vector2D>();
            shiftVecs.add(shift);
            this.installShift(gss, shiftVecs, new HashMap(), true);
        }
        if (!firstSubset.isCompleteGenome()) {
            this.linkChopping(baseGenome, this.workingLayout_, grpID != null);
        }
        if (!firstSubset.isCompleteGenome() && overlayKey == null && grpID == null) {
            SpecialtyInstructions props = (SpecialtyInstructions)this.propList_.get(0);
            GenomeSubset sub = (GenomeSubset)this.topoSortedSubsetList_.get(0);
            Set ignoreLinks = DataUtil.setFromIterator(sub.getLinkageSuperSetIterator());
            Set ignoreNodes = DataUtil.setFromIterator(sub.getNodeIterator());
            HashSet<String> keepNodes = new HashSet<String>();
            Iterator anit = baseGenome.getAllNodeIterator();
            while (anit.hasNext()) {
                Node nextNode = (Node)anit.next();
                keepNodes.add(nextNode.getID());
            }
            keepNodes.removeAll(ignoreNodes);
            LinkRouter router = new LinkRouter();
            LinkPlacementGrid lps = router.initLimitedGrid(baseGenome, this.workingLayout_, this.fixedFrc_, keepNodes, ignoreLinks, 4);
            Rectangle chopRect = props.getPlacedFullBounds();
            if (this.nonOverlaySpliceBorders_ != null) {
                chopRect = chopRect.union(this.nonOverlaySpliceBorders_);
            }
            if (!lps.isEmpty(chopRect = UiUtil.rectFromRect2D(UiUtil.padTheRect(chopRect, 10.0)))) {
                return new LinkRouter.RoutingResult(8);
            }
        }
        if (grpID == null) {
            dit = gss.dataIterator();
            int count = 0;
            while (dit.hasNext()) {
                SpecialtyInstructions results2;
                SpecialtyLayoutData sld = (SpecialtyLayoutData)dit.next();
                if ((results2 = (SpecialtyInstructions)this.propList_.get(count++)) == null) continue;
                this.installNodeProps(results2, baseGenome, this.workingLayout_, support, sld.subset, monitor, false);
                if (monitor == null || monitor.keepGoing()) continue;
                throw new AsynchExitRequestException();
            }
        }
        LinkRouter.RoutingResult retval = this.ac_.runSpecialtyLinkPlacement(this, support, monitor, currStart, maxFrac);
        return retval;
    }

    private void updateRegionBounds(Genome baseGenome, Rectangle needBounds, String grpID, Layout trgLayout) {
        GenomeInstance bgi = (GenomeInstance)baseGenome;
        GroupProperties gp = trgLayout.getGroupProperties(Group.getBaseID(grpID));
        Point2D oldPos = gp.getLabelLocation();
        GroupFree renderer = new GroupFree();
        Rectangle labelBounds = renderer.getLabelBounds(baseGenome, bgi.getGroup(grpID), trgLayout, this.fixedFrc_);
        double lbw = labelBounds == null ? 0.0 : labelBounds.getWidth() / 2.0;
        double lbh = labelBounds == null ? 0.0 : labelBounds.getHeight();
        double newX = UiUtil.forceToGridValueMax(needBounds.getX() + lbw, 10.0);
        double newY = UiUtil.forceToGridValueMax(needBounds.getY() + lbh, 10.0);
        trgLayout.moveGroup(grpID, bgi, newX - oldPos.getX(), newY - oldPos.getY());
        Rectangle bounds = renderer.getBounds(baseGenome, bgi.getGroup(grpID), trgLayout, this.fixedFrc_, null);
        GroupProperties changedProps = new GroupProperties(gp);
        int pad = changedProps.getPadding(0);
        int delt = bounds.y - needBounds.y;
        changedProps.setPadding(0, (int)UiUtil.forceToGridValueMax(delt + pad, 10.0));
        int bpad = changedProps.getPadding(1);
        delt = needBounds.y + needBounds.height - (bounds.y + bounds.height);
        changedProps.setPadding(1, (int)UiUtil.forceToGridValueMax(delt + bpad, 10.0));
        int lpad = changedProps.getPadding(2);
        delt = bounds.x - needBounds.x;
        changedProps.setPadding(2, (int)UiUtil.forceToGridValueMax(delt + lpad, 10.0));
        int rpad = changedProps.getPadding(3);
        delt = needBounds.x + needBounds.width - (bounds.x + bounds.width);
        changedProps.setPadding(3, (int)UiUtil.forceToGridValueMax(delt + rpad, 10.0));
        trgLayout.replaceGroupProperties(gp, changedProps);
    }

    private void linkChopping(Genome baseGenome, Layout lo, boolean choppedRegion) {
        Layout workingCopyLo = new Layout(lo);
        HashMap<String, Map> savedTreeGeom = new HashMap<String, Map>();
        Iterator lit = baseGenome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String srcID = link.getSource();
            if (savedTreeGeom.get(srcID) != null) continue;
            BusProperties bp = workingCopyLo.getBusForSource(srcID);
            Map geoms = bp.getAllSegmentGeometries(baseGenome, workingCopyLo, this.fixedFrc_, true);
            savedTreeGeom.put(srcID, geoms);
        }
        HashSet intoSets = new HashSet();
        HashSet outOfSets = new HashSet();
        HashSet betweenSets = new HashSet();
        HashSet insideSets = new HashSet();
        int numSub = this.topoSortedSubsetList_.size();
        for (int i = 0; i < numSub; ++i) {
            GenomeSubset subset = (GenomeSubset)this.topoSortedSubsetList_.get(i);
            Set internalLinksForSet = DataUtil.setFromIterator(subset.getLinkageIterator());
            intoSets.addAll(DataUtil.setFromIterator(subset.getLinksInIterator()));
            outOfSets.addAll(DataUtil.setFromIterator(subset.getLinksOutIterator()));
            insideSets.addAll(internalLinksForSet);
        }
        betweenSets.addAll(intoSets);
        betweenSets.retainAll(outOfSets);
        outOfSets.removeAll(betweenSets);
        intoSets.removeAll(betweenSets);
        HashMap fakeRememberProps = new HashMap();
        Iterator nlit = insideSets.iterator();
        while (nlit.hasNext()) {
            String lid = (String)nlit.next();
            workingCopyLo.removeLinkPropertiesAndRemember(lid, fakeRememberProps, baseGenome, this.fixedFrc_);
        }
        this.newLinks_.addAll(insideSets);
        HashSet<String> allAlienSources = new HashSet<String>();
        Iterator ilit = intoSets.iterator();
        while (ilit.hasNext()) {
            String lid = (String)ilit.next();
            allAlienSources.add(baseGenome.getLinkage(lid).getSource());
        }
        HashMap seenSegsPerSrc = new HashMap();
        for (int i = 0; i < numSub; ++i) {
            SpecialtyInstructions props = (SpecialtyInstructions)this.propList_.get(i);
            GenomeSubset subset = (GenomeSubset)this.topoSortedSubsetList_.get(i);
            Rectangle chopRect = props.getPlacedFullBounds();
            if (chopRect != null) {
                chopRect = UiUtil.rectFromRect2D(UiUtil.padTheRect(chopRect, 10.0));
            }
            this.forRecoveriesOut_.add(this.recoverSpecialtyInputsOut(subset.getSourcesHeadedOut(), workingCopyLo, chopRect, betweenSets, savedTreeGeom, choppedRegion));
            HashSet aliens = new HashSet(allAlienSources);
            aliens.retainAll(subset.getSourcesHeadedIn());
            Set allLinksIntoSubset = DataUtil.setFromIterator(subset.getLinksInIterator());
            HashMap<String, HashSet<String>> linksFromAlienSrcToSubset = new HashMap<String, HashSet<String>>();
            Iterator ailit = allLinksIntoSubset.iterator();
            while (ailit.hasNext()) {
                String lid = (String)ailit.next();
                String linkSrc = baseGenome.getLinkage(lid).getSource();
                if (!allAlienSources.contains(linkSrc)) continue;
                HashSet<String> linksForSource = (HashSet<String>)linksFromAlienSrcToSubset.get(linkSrc);
                if (linksForSource == null) {
                    linksForSource = new HashSet<String>();
                    linksFromAlienSrcToSubset.put(linkSrc, linksForSource);
                }
                linksForSource.add(lid);
            }
            if (!linksFromAlienSrcToSubset.isEmpty()) {
                this.recoverSpecialtyInputsIn(aliens, workingCopyLo, linksFromAlienSrcToSubset, chopRect, savedTreeGeom, this.alienSources_, seenSegsPerSrc);
            }
            this.srcToBetween_.putAll(this.recoverSpecialtyInputsOut(subset.getSourcesHeadedOut(), workingCopyLo, chopRect, intoSets, savedTreeGeom, choppedRegion));
        }
        this.newLinks_.addAll(outOfSets);
        this.newLinks_.addAll(intoSets);
        this.newLinks_.addAll(betweenSets);
        LinkModuleBoundaryBuilder lmbb = new LinkModuleBoundaryBuilder();
        SpecialtyInstructions spSrc = (SpecialtyInstructions)this.propList_.get(0);
        this.nonOverlaySolutions_ = lmbb.nonOverlaySplicePrep(spSrc, null, this.alienSources_, this.forRecoveriesOut_);
        this.nonOverlaySpliceBorders_ = lmbb.spliceBoundsForAllBorders(this.nonOverlaySolutions_);
        if (this.nonOverlaySpliceBorders_ != null) {
            this.nonOverlaySpliceBorders_ = UiUtil.growTheRect(this.nonOverlaySpliceBorders_, 10);
        }
    }

    private Map recoverSpecialtyInputsOut(Set srcs, Layout lo, Rectangle chopRect, Set ignoreLinks, Map savedTreeGeom, boolean choppedRegion) {
        HashMap<String, SpecialtyLayoutLinkData> retval = new HashMap<String, SpecialtyLayoutLinkData>();
        Iterator sit = srcs.iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            Map geoms = (Map)savedTreeGeom.get(srcID);
            SpecialtyLayoutLinkData sin = new SpecialtyLayoutLinkData(srcID);
            BusProperties bp = lo.getBusForSource(srcID);
            sin.extractTreeLeafRemains(bp, chopRect, geoms, ignoreLinks, choppedRegion);
            retval.put(srcID, sin);
        }
        return retval;
    }

    private void chopForRegionLayout(GenomeSubset regionSubset, Layout lo, Rectangle chopRect, Map chopDepart, Map chopArrive) {
        Genome baseGenome = regionSubset.getBaseGenome();
        chopRect = UiUtil.rectFromRect2D(UiUtil.padTheRect(chopRect, 20.0));
        Iterator liit = regionSubset.getLinksInIterator();
        this.chopAndClean(regionSubset, liit, lo, chopArrive, chopRect, false);
        Iterator loit = regionSubset.getLinksOutIterator();
        this.chopAndClean(regionSubset, loit, lo, chopDepart, chopRect, true);
        Iterator xrit = regionSubset.getLinkageIterator();
        HashMap fakeRememberProps = new HashMap();
        while (xrit.hasNext()) {
            String linkID = (String)xrit.next();
            lo.removeLinkPropertiesAndRemember(linkID, fakeRememberProps, baseGenome, this.fixedFrc_);
            AddCommands.autoAddCrudeLinkProperties(baseGenome, lo, linkID, null, fakeRememberProps, this.fixedFrc_);
        }
    }

    private void chopAndClean(GenomeSubset subset, Iterator lit, Layout lo, Map edgeMovesForSrc, Rectangle chopRect, boolean headingOut) {
        Genome baseGenome = subset.getBaseGenome();
        String regionID = subset.getGroupID();
        block0: while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String srcID = link.getSource();
            HashMap<String, LayoutRubberStamper.EdgeMove> moves = (HashMap<String, LayoutRubberStamper.EdgeMove>)edgeMovesForSrc.get(srcID);
            if (moves != null) continue;
            moves = new HashMap<String, LayoutRubberStamper.EdgeMove>();
            edgeMovesForSrc.put(srcID, moves);
            BusProperties bp = lo.getBusForSource(srcID);
            boolean working = true;
            int count = 0;
            block1: while (working) {
                if (count++ >= 500) {
                    System.err.println("chopAndClean failing to converge for: " + srcID);
                    continue block0;
                }
                Map geoms = bp.getAllSegmentGeometries(baseGenome, lo, this.fixedFrc_, true);
                Iterator sit = geoms.keySet().iterator();
                while (sit.hasNext()) {
                    LinkSegmentID lsid = (LinkSegmentID)sit.next();
                    Set linksThru = bp.resolveLinkagesThroughSegment(lsid);
                    LinkSegment fakeSeg = (LinkSegment)geoms.get(lsid);
                    Point2D start = fakeSeg.getStart();
                    Point2D end = fakeSeg.getEnd();
                    UiUtil.PointAndSide[] pasIntersect = UiUtil.rectIntersections(chopRect, start, end);
                    boolean hadAMove = false;
                    if (pasIntersect != null) {
                        LinkSegmentID reattachID;
                        LinkSegmentID attachID;
                        String nextLinkID;
                        Point2D.Double forcedSplit = new Point2D.Double();
                        int useIndex = headingOut ? 0 : pasIntersect.length - 1;
                        UiUtil.forceToGrid(pasIntersect[useIndex].point.getX(), pasIntersect[useIndex].point.getY(), forcedSplit, 10.0);
                        if (forcedSplit.equals(start) || forcedSplit.equals(end)) {
                            if (!lsid.isForDrop() && (forcedSplit.equals(start) && headingOut || forcedSplit.equals(end) && !headingOut)) {
                                LayoutRubberStamper.EdgeMove em = new LayoutRubberStamper.EdgeMove(new UiUtil.PointAndSide(pasIntersect[useIndex], forcedSplit), srcID, regionID);
                                Iterator ltit = linksThru.iterator();
                                boolean repeated = false;
                                while (ltit.hasNext()) {
                                    nextLinkID = (String)ltit.next();
                                    LayoutRubberStamper.EdgeMove emchk = (LayoutRubberStamper.EdgeMove)moves.get(nextLinkID);
                                    if (emchk != null && emchk.pas.equals(pasIntersect[useIndex])) {
                                        repeated = true;
                                        continue;
                                    }
                                    moves.put(nextLinkID, em);
                                }
                                if (!repeated) {
                                    if (headingOut) {
                                        LinkSegment ls = bp.getSegment(lsid);
                                        String parID = ls.getParent();
                                        if (parID != null) {
                                            LinkSegmentID attachID2 = (LinkSegmentID)bp.getRootSegmentID().clone();
                                            LinkSegmentID reattachID2 = LinkSegmentID.buildIDForSegment(parID);
                                            attachID2.tagIDWithEndpoint("S");
                                            reattachID2.tagIDWithEndpoint("S");
                                            bp.moveSegmentOnTree(reattachID2, attachID2);
                                            hadAMove = true;
                                            continue block1;
                                        }
                                    } else {
                                        attachID = (LinkSegmentID)lsid.clone();
                                        reattachID = LinkSegmentID.buildIDForEndDrop(linkID);
                                        LinkBusDrop drop = bp.getDrop(reattachID);
                                        if (!drop.getConnectionTag().equals(bp.getSegment(lsid).getID())) {
                                            attachID.tagIDWithEndpoint("E");
                                            reattachID.tagIDWithEndpoint("S");
                                            bp.moveSegmentOnTree(reattachID, attachID);
                                            hadAMove = true;
                                            continue block1;
                                        }
                                    }
                                }
                            }
                        } else {
                            LinkSegmentID[] splits = bp.linkSplitSupport(lsid, forcedSplit);
                            if (splits != null) {
                                LayoutRubberStamper.EdgeMove em = new LayoutRubberStamper.EdgeMove(new UiUtil.PointAndSide(pasIntersect[useIndex], forcedSplit), srcID, regionID);
                                Iterator ltit = linksThru.iterator();
                                while (ltit.hasNext()) {
                                    nextLinkID = (String)ltit.next();
                                    moves.put(nextLinkID, em);
                                }
                                if (headingOut) {
                                    attachID = (LinkSegmentID)bp.getRootSegmentID().clone();
                                    attachID.tagIDWithEndpoint("S");
                                    reattachID = (LinkSegmentID)splits[0].clone();
                                    reattachID.tagIDWithEndpoint("S");
                                    bp.moveSegmentOnTree(reattachID, attachID);
                                    hadAMove = true;
                                    continue block1;
                                }
                                attachID = (LinkSegmentID)splits[0].clone();
                                attachID.tagIDWithEndpoint("E");
                                reattachID = LinkSegmentID.buildIDForEndDrop(linkID);
                                reattachID.tagIDWithEndpoint("S");
                                bp.moveSegmentOnTree(reattachID, attachID);
                                hadAMove = true;
                                continue block1;
                            }
                        }
                    }
                    if (hadAMove) continue block1;
                    if (sit.hasNext()) continue;
                    working = false;
                }
            }
        }
    }

    private void recoverSpecialtyInputsIn(Set srcs, Layout lo, Map linksFromAlienSrcsToSubset, Rectangle chopRect, Map savedTreeGeom, Map alienSources, Map seenSegsPerSrc) {
        Iterator sit = srcs.iterator();
        while (sit.hasNext()) {
            HashSet seenSegs;
            SpecialtyLayoutLinkData sin;
            String srcID = (String)sit.next();
            Map geoms = (Map)savedTreeGeom.get(srcID);
            SpecialtyLayoutLinkData originalSin = (SpecialtyLayoutLinkData)alienSources.get(srcID);
            SpecialtyLayoutLinkData specialtyLayoutLinkData = sin = originalSin != null ? originalSin : new SpecialtyLayoutLinkData(srcID);
            if (originalSin == null) {
                alienSources.put(srcID, sin);
            }
            if ((seenSegs = (HashSet)seenSegsPerSrc.get(srcID)) == null) {
                seenSegs = new HashSet();
                seenSegsPerSrc.put(srcID, seenSegs);
            }
            BusProperties bp = lo.getBusForSource(srcID);
            Set linksForSource = (Set)linksFromAlienSrcsToSubset.get(srcID);
            sin.extractTreeTrunkRemains(bp, linksForSource, chopRect, geoms, seenSegs);
        }
    }

    private SortedMap customOrderForTarget(TreeMap existingOrder, GenomeSubset subset) {
        String trgModule = subset.getModuleID();
        if (trgModule == null) {
            return new TreeMap(existingOrder);
        }
        List clockwise = this.sa_.getBorderOrderedSrcModules(trgModule);
        HashMap<String, TreeMap<Integer, String>> orderPerSrcMod = new HashMap<String, TreeMap<Integer, String>>();
        Iterator eoit = existingOrder.keySet().iterator();
        while (eoit.hasNext()) {
            Integer keyVal = (Integer)eoit.next();
            String srcID = (String)existingOrder.get(keyVal);
            String srcMod = this.sa_.getSourceModuleIDForSource(srcID);
            TreeMap<Integer, String> perMod = (TreeMap<Integer, String>)orderPerSrcMod.get(srcMod);
            if (perMod == null) {
                perMod = new TreeMap<Integer, String>();
                orderPerSrcMod.put(srcMod, perMod);
            }
            perMod.put(keyVal, srcID);
        }
        TreeMap<Integer, String> retval = new TreeMap<Integer, String>();
        int offset = 0;
        Iterator cwit = clockwise.iterator();
        while (cwit.hasNext()) {
            String srcModID = (String)cwit.next();
            TreeMap ops = (TreeMap)orderPerSrcMod.get(srcModID);
            if (ops == null) continue;
            Iterator okit = ops.keySet().iterator();
            int highKey = 0;
            while (okit.hasNext()) {
                Integer keyVal = (Integer)okit.next();
                highKey = keyVal;
                String srcID = (String)ops.get(keyVal);
                retval.put(new Integer(highKey + offset), srcID);
            }
            offset += highKey + 1;
        }
        return retval;
    }

    private Vector2D buildAShiftVec(SpecialtyLayoutData sld, GridElement grown, Rectangle padded, Rectangle renderedRegion) {
        Vector2D shift = null;
        if (grown != null) {
            Rectangle orig = sld.results.getOrigModuleRect();
            double deltaX = orig.getX() - (double)padded.x + (grown.rect.getX() - orig.getX());
            double deltaY = orig.getY() - (double)padded.y + (grown.rect.getY() - orig.getY());
            Rectangle placed = sld.results.getPlacedFullBounds();
            if (placed == null) {
                placed = orig;
            }
            Rectangle shiftedLoc = new Rectangle((int)(placed.getX() + deltaX), (int)(placed.getY() + deltaY), placed.width, placed.height);
            double deltaXtoCenter = grown.rect.getCenterX() - shiftedLoc.getCenterX();
            double deltaYtoCenter = grown.rect.getCenterY() - shiftedLoc.getCenterY();
            deltaX += deltaXtoCenter;
            deltaY += deltaYtoCenter;
            deltaX = UiUtil.forceToGridValue(deltaX, 10.0);
            deltaY = UiUtil.forceToGridValue(deltaY, 10.0);
            shift = new Vector2D(deltaX, deltaY);
        } else {
            if (renderedRegion != null) {
                System.err.println("Implement me!");
                throw new IllegalArgumentException();
            }
            Rectangle placedBounds = sld.results.getPlacedStackNodeOnlyBounds();
            if (sld.results.getOrigNodeBounds() != null && placedBounds != null) {
                double origX = sld.subset.getPreferredCenter().getX();
                double origY = sld.subset.getPreferredCenter().getY();
                double newCenterX = placedBounds.getCenterX();
                double newCenterY = placedBounds.getCenterY();
                shift = new Vector2D(UiUtil.forceToGridValue(origX - newCenterX, 10.0), UiUtil.forceToGridValue(origY - newCenterY, 10.0));
            }
        }
        return shift;
    }

    private Map shiftTheModules(GlobalSLEState gss, String overlayKey, Layout working, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Map splicePlans = null;
        HashMap grownResults = new HashMap();
        ArrayList shiftVecs = null;
        HashMap spliceNeeds = new HashMap();
        HashMap myShiftedIMP = new HashMap();
        for (int i = 0; i < 20; ++i) {
            Map impCopy = this.copyInterModPaths();
            grownResults.clear();
            HashMap paddedResults = new HashMap();
            HashMap multiLinkData = new HashMap();
            myShiftedIMP.clear();
            int count = 0;
            int nonProgCount = 0;
            Map lastPlan = null;
            Map recoveryPlan = null;
            while ((recoveryPlan = this.shiftGrownSubsets(impCopy, grownResults, paddedResults, myShiftedIMP, multiLinkData, overlayKey, recoveryPlan, spliceNeeds, working)) != null) {
                nonProgCount = ((Object)recoveryPlan).equals(lastPlan) ? ++nonProgCount : 0;
                if (++count >= 50 || nonProgCount == 10) break;
                lastPlan = recoveryPlan;
            }
            if (this.sa_.hasInterModulePaths()) {
                this.shiftWorkingInterModPaths(impCopy, myShiftedIMP);
            }
            shiftVecs = new ArrayList();
            ArrayList shiftedCopies = new ArrayList();
            this.buildShiftedVecsAndCopies(gss, shiftVecs, shiftedCopies, grownResults, paddedResults, null);
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            LinkModuleBoundaryBuilder lmbb = new LinkModuleBoundaryBuilder();
            splicePlans = lmbb.splicePrep(this.sa_, impCopy, shiftedCopies);
            boolean done = true;
            Map needForSplice = lmbb.spliceBoundsPerModule(splicePlans);
            int plNum = this.propList_.size();
            for (int j = 0; j < plNum; ++j) {
                Rectangle spliceBounds;
                String strKey = Integer.toString(j);
                GridElement grown = (GridElement)grownResults.get(strKey);
                Rectangle grownRect = UiUtil.rectFromRect2D(grown.rect);
                SpecialtyInstructions results = (SpecialtyInstructions)this.propList_.get(j);
                if (results == null || (spliceBounds = (Rectangle)needForSplice.get(results.moduleID)) == null) continue;
                Rectangle speW = UiUtil.growTheRect(spliceBounds, 10);
                Rectangle reallyNeeded = grownRect.union(speW = UiUtil.rectFromRect2D(UiUtil.padTheRect(speW, 10.0)));
                if (reallyNeeded.equals(grownRect)) continue;
                ArrayList needElems = (ArrayList)spliceNeeds.get(results.moduleID);
                if (needElems == null) {
                    needElems = new ArrayList();
                    spliceNeeds.put(results.moduleID, needElems);
                }
                this.buildBoundaryGridElements(results, grownRect, speW, needElems, i);
                done = false;
            }
            if (done) break;
        }
        if (this.sa_.hasInterModulePaths()) {
            this.installShiftedInterModPaths(myShiftedIMP);
        }
        this.shiftedIMP_.putAll(myShiftedIMP);
        this.installShift(gss, shiftVecs, grownResults, false);
        return splicePlans;
    }

    private void installShift(GlobalSLEState gss, List shiftVecs, Map grownResults, boolean skipNodes) {
        Iterator dit = gss.dataIterator();
        int count = 0;
        while (dit.hasNext()) {
            SpecialtyLayoutData sld = (SpecialtyLayoutData)dit.next();
            SpecialtyInstructions results = (SpecialtyInstructions)this.propList_.get(count);
            Vector2D shift = (Vector2D)shiftVecs.get(count);
            GridElement grown = (GridElement)grownResults.get(Integer.toString(count++));
            if (results == null || shift == null) continue;
            sld.results.shift(shift, skipNodes);
            if (grown == null) continue;
            Rectangle forcedR = UiUtil.rectFromRect2D(grown.rect);
            UiUtil.forceToGrid(forcedR, 10.0);
            sld.results.setStrictGrownBounds(forcedR);
        }
    }

    private void buildBoundaryGridElements(SpecialtyInstructions results, Rectangle grownRect, Rectangle speW, List needElems, int pass) {
        Rectangle oldBounds = results.getOrigModuleRect();
        double topNeed = grownRect.getMinY() - speW.getMinY();
        double botNeed = speW.getMaxY() - grownRect.getMaxY();
        double rightNeed = speW.getMaxX() - grownRect.getMaxX();
        double leftNeed = grownRect.getMinX() - speW.getMinX();
        HashMap<Object, GridElement> gotEm = new HashMap<Object, GridElement>();
        int numGot = needElems.size();
        for (int i = 0; i < numGot; ++i) {
            GridElement ge = (GridElement)needElems.get(i);
            gotEm.put(ge.id, ge);
        }
        needElems.clear();
        double padHack = 20.0;
        String key = this.hacktasticKeyGen(0, results.moduleID);
        GridElement ge = (GridElement)gotEm.get(key);
        if (topNeed > 0.0) {
            if (ge != null) {
                ge.deltaY += topNeed;
            } else {
                ge = new GridElement((Rectangle2D)new Rectangle(oldBounds.x, oldBounds.y, 10, 10), (Object)key, 0.0, topNeed + padHack);
            }
        }
        if (ge != null) {
            needElems.add(ge);
        }
        key = this.hacktasticKeyGen(1, results.moduleID);
        ge = (GridElement)gotEm.get(key);
        if (botNeed > 0.0) {
            if (ge != null) {
                ge.deltaY += botNeed;
            } else {
                ge = new GridElement((Rectangle2D)new Rectangle(oldBounds.x, oldBounds.y + oldBounds.height - 10, 10, 10), (Object)key, 0.0, botNeed + padHack);
            }
        }
        if (ge != null) {
            needElems.add(ge);
        }
        key = this.hacktasticKeyGen(3, results.moduleID);
        ge = (GridElement)gotEm.get(key);
        if (rightNeed > 0.0) {
            if (ge != null) {
                ge.deltaX += rightNeed;
            } else {
                ge = new GridElement((Rectangle2D)new Rectangle(oldBounds.x + oldBounds.width - 10, oldBounds.y, 10, 10), (Object)key, rightNeed + padHack, 0.0);
            }
        }
        if (ge != null) {
            needElems.add(ge);
        }
        key = this.hacktasticKeyGen(2, results.moduleID);
        ge = (GridElement)gotEm.get(key);
        if (leftNeed > 0.0) {
            if (ge != null) {
                ge.deltaX += leftNeed;
            } else {
                ge = new GridElement((Rectangle2D)new Rectangle(oldBounds.x, oldBounds.y, 10, 10), (Object)key, leftNeed + padHack, 0.0);
            }
        }
        if (ge != null) {
            needElems.add(ge);
        }
    }

    private String hacktasticKeyGen(int border, String moduleID) {
        return "WJRL_HACKASTIC_" + border + "_KEY_" + moduleID;
    }

    private void buildShiftedVecsAndCopies(GlobalSLEState gss, ArrayList shiftVecs, ArrayList shiftedCopies, HashMap grownResults, HashMap paddedResults, Rectangle renderedRegion) {
        Iterator dit = gss.dataIterator();
        int count = 0;
        while (dit.hasNext()) {
            SpecialtyInstructions results;
            SpecialtyLayoutData sld = (SpecialtyLayoutData)dit.next();
            String strKey = Integer.toString(count);
            GridElement grown = (GridElement)grownResults.get(strKey);
            Rectangle padded = (Rectangle)paddedResults.get(strKey);
            if ((results = (SpecialtyInstructions)this.propList_.get(count++)) == null) {
                shiftVecs.add(null);
                shiftedCopies.add(null);
                continue;
            }
            Vector2D shift = this.buildAShiftVec(sld, grown, padded, renderedRegion);
            shiftVecs.add(shift);
            if (shift != null) {
                Map shiftedCopy = sld.results.getShiftedLinkDataCopy(shift);
                shiftedCopies.add(shiftedCopy);
                continue;
            }
            shiftedCopies.add(null);
        }
    }

    private List collectGridElements(Map paddedResults, Set cpIDs, Map linkExpansions, Map impCopy, Map spliceNeeds) {
        int i;
        ArrayList<GridElement> gridElements = new ArrayList<GridElement>();
        int numSub = this.propList_.size();
        for (i = 0; i < numSub; ++i) {
            GridElement ge;
            String strKey = Integer.toString(i);
            SpecialtyInstructions sp = (SpecialtyInstructions)this.propList_.get(i);
            if (sp.moduleID == null) continue;
            Rectangle oldBounds = sp.getOrigModuleRect();
            Rectangle newBounds = sp.getPlacedFullBounds();
            Rectangle padded = new Rectangle(newBounds == null ? oldBounds : newBounds);
            int extraW = 0;
            int extraH = 0;
            List spliceExtras = (List)spliceNeeds.get(sp.moduleID);
            if (spliceExtras != null) {
                gridElements.addAll(spliceExtras);
                int numExtra = spliceExtras.size();
                for (int j = 0; j < numExtra; ++j) {
                    ge = (GridElement)spliceExtras.get(j);
                    extraW = (int)((double)extraW + ge.deltaX);
                    extraH = (int)((double)extraH + ge.deltaY);
                }
            }
            paddedResults.put(strKey, padded);
            int hDiff = padded.height - oldBounds.height;
            int wDiff = padded.width - oldBounds.width;
            if (hDiff < 0) {
                hDiff = 0;
            }
            if (wDiff < 0) {
                wDiff = 0;
            }
            ge = new GridElement((Rectangle2D)oldBounds, (Object)strKey, (double)(wDiff + extraW * 2), (double)(hDiff + extraH * 2));
            gridElements.add(ge);
        }
        for (i = 0; i < numSub; ++i) {
            NetModuleLinkExtractor.ExtractResultForSource res;
            SpecialtyInstructions sp = (SpecialtyInstructions)this.propList_.get(i);
            if (sp.moduleID == null || (res = (NetModuleLinkExtractor.ExtractResultForSource)impCopy.get(sp.moduleID)) == null) continue;
            res.collectGridElements(cpIDs, gridElements, linkExpansions);
        }
        return gridElements;
    }

    private Map shiftGrownSubsets(Map impCopy, Map grownResults, Map paddedResults, Map shiftedIMP, Map multiLinkData, String overlayKey, Map linkExpansions, Map spliceNeeds, Layout working) {
        grownResults.clear();
        paddedResults.clear();
        shiftedIMP.clear();
        multiLinkData.clear();
        HashSet cpIDs = new HashSet();
        List gridElements = this.collectGridElements(paddedResults, cpIDs, linkExpansions, impCopy, spliceNeeds);
        GridGrower grower = new GridGrower();
        List grown = grower.growGrid(gridElements, 0);
        HashMap<Point2D, Point2D> inverse = new HashMap<Point2D, Point2D>();
        HashMap<Object, Rectangle2D> forGrid = new HashMap<Object, Rectangle2D>();
        int numGrown = grown.size();
        for (int i = 0; i < numGrown; ++i) {
            GridGrower.GeneralizedGridElement ele = (GridGrower.GeneralizedGridElement)grown.get(i);
            if (ele instanceof CenteredGridElement) {
                CenteredGridElement cge = (CenteredGridElement)ele;
                Point2D id = cge.getID();
                if (!cpIDs.contains(cge.getID())) {
                    throw new IllegalStateException();
                }
                Point2D use = (Point2D)cge.getPoint().clone();
                UiUtil.forceToGrid(use, 10.0);
                shiftedIMP.put(id, use);
                inverse.put(use, id);
                continue;
            }
            GridElement ge = (GridElement)ele;
            grownResults.put(ge.id, ele);
            forGrid.put(ge.id, ge.rect);
        }
        HashMap<String, NetModuleLinkageProperties> moduleLinkTrees = new HashMap<String, NetModuleLinkageProperties>();
        NetOverlayProperties nop = working.getNetOverlayProperties(overlayKey);
        Iterator tkit = nop.getNetModuleLinkagePropertiesKeys();
        while (tkit.hasNext()) {
            String tKey = (String)tkit.next();
            NetModuleLinkageProperties lp = working.getNetModuleLinkagePropertiesFromTreeID(tKey, overlayKey);
            NetModuleLinkageProperties myCopy = (NetModuleLinkageProperties)lp.clone();
            myCopy.shiftPerMap(shiftedIMP, true);
            moduleLinkTrees.put(tKey, myCopy);
        }
        Iterator samit = impCopy.keySet().iterator();
        while (samit.hasNext()) {
            String modID = (String)samit.next();
            NetModuleLinkExtractor.ExtractResultForSource res = (NetModuleLinkExtractor.ExtractResultForSource)impCopy.get(modID);
            NetModuleLinkExtractor.ExtractResultForSource localCopy = (NetModuleLinkExtractor.ExtractResultForSource)res.clone();
            localCopy.shiftPaths(shiftedIMP);
            localCopy.buildMultiDataMap(multiLinkData);
        }
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid initialGrid = router.initGridForModuleGuidedLinks(forGrid, multiLinkData, moduleLinkTrees);
        Map badCells = initialGrid.findBadModuleCells(true);
        Map retval = null;
        if (badCells != null && !badCells.isEmpty()) {
            Map currMap = this.buildRecoveryPlan(badCells, inverse, linkExpansions, true);
            retval = this.buildRecoveryPlan(badCells, inverse, currMap == null ? linkExpansions : currMap, false);
        }
        if (retval == null && this.sa_.hasInterModulePaths()) {
            this.shiftWorkingInterModPaths(impCopy, shiftedIMP);
        }
        return retval;
    }

    private Map decoSort(Point point, List decos, boolean isVert) {
        LinkPlacementGrid.DecoInfo deco;
        int i;
        HashMap<LinkPlacementGrid.DecoInfoKey, int[]> retval = new HashMap<LinkPlacementGrid.DecoInfoKey, int[]>();
        if (decos == null || decos.isEmpty()) {
            return null;
        }
        int numDecos = decos.size();
        boolean haveModuleOverlap = false;
        TreeMap<Double, LinkPlacementGrid.DecoInfo> forSort = new TreeMap<Double, LinkPlacementGrid.DecoInfo>();
        for (int i2 = 0; i2 < numDecos; ++i2) {
            LinkPlacementGrid.DecoInfo deco2 = (LinkPlacementGrid.DecoInfo)decos.get(i2);
            if (deco2.isModule) {
                haveModuleOverlap = true;
                continue;
            }
            double firstCoord = isVert ? deco2.firstPt.getX() : deco2.firstPt.getY();
            forSort.put(new Double(firstCoord), deco2);
        }
        ArrayList sortedList = new ArrayList(forSort.values());
        int numSort = sortedList.size();
        LinkPlacementGrid.DecoInfoKey firstDeco = null;
        LinkPlacementGrid.DecoInfoKey lastDeco = null;
        double overCoord = isVert ? point.getX() : point.getY();
        HashMap<Integer, Double> currentGaps = new HashMap<Integer, Double>();
        HashMap<Integer, Double> neededGaps = new HashMap<Integer, Double>();
        for (i = 0; i < numSort; ++i) {
            Double existing;
            Integer cintIndex;
            int overOffset;
            deco = (LinkPlacementGrid.DecoInfo)sortedList.get(i);
            if (i == 0) {
                firstDeco = deco.getDIK();
            }
            if (i == numSort - 1) {
                lastDeco = deco.getDIK();
            }
            double decoCoord = (isVert ? deco.firstPt.getX() : deco.firstPt.getY()) / 10.0;
            boolean ptLT = decoCoord >= overCoord;
            int n = overOffset = isVert ? deco.offsetForSrc.x : deco.offsetForSrc.y;
            if (overOffset >= 0 || !ptLT) {
                // empty if block
            }
            int overlap = overOffset < 0 ? -deco.traceRange.min : deco.traceRange.max;
            Integer intIndex = new Integer(ptLT ? i - 1 : i);
            Double need = (Double)neededGaps.get(intIndex);
            if (need == null) {
                need = new Double(overlap);
                neededGaps.put(intIndex, need);
            } else {
                neededGaps.put(intIndex, new Double((double)overlap + need));
            }
            if (i > 0) {
                cintIndex = new Integer(i - 1);
                existing = (Double)currentGaps.get(cintIndex);
                if (existing == null) {
                    throw new IllegalStateException();
                }
                currentGaps.put(cintIndex, new Double(decoCoord - existing));
            }
            cintIndex = new Integer(i);
            existing = new Double(decoCoord);
            currentGaps.put(cintIndex, existing);
        }
        for (i = 0; i < numSort - 1; ++i) {
            deco = (LinkPlacementGrid.DecoInfo)sortedList.get(i);
            Integer intIndex = new Integer(i);
            Double needObj = (Double)neededGaps.get(intIndex);
            double need = needObj == null ? 0.0 : needObj;
            Double existingObj = (Double)currentGaps.get(intIndex);
            double existing = existingObj;
            double expand = need - existing;
            int[] forL = new int[]{0, expand >= 0.0 ? (int)expand + 8 : 0};
            retval.put(deco.getDIK(), forL);
        }
        if (haveModuleOverlap) {
            int[] forL;
            Double needObj = (Double)neededGaps.get(new Integer(-1));
            if (needObj != null) {
                forL = (int[])retval.get(firstDeco);
                if (forL == null) {
                    forL = new int[2];
                    forL[1] = 0;
                    retval.put(firstDeco, forL);
                }
                forL[0] = needObj.intValue() + 8;
            }
            if ((needObj = (Double)neededGaps.get(new Integer(numSort - 1))) != null) {
                forL = new int[]{0, needObj.intValue() + 8};
                retval.put(lastDeco, forL);
            }
        }
        return retval;
    }

    private Map buildRecoveryPlan(Map badCells, Map inverse, Map currMap, boolean forVert) {
        Map retval = currMap == null ? new HashMap() : currMap;
        boolean upgraded = false;
        Iterator bcit = badCells.keySet().iterator();
        while (bcit.hasNext()) {
            Map minForPt;
            Point ptKey = (Point)bcit.next();
            boolean pending = false;
            boolean modified = false;
            boolean treePending = false;
            Map forPt = (Map)badCells.get(ptKey);
            ArrayList<LinkPlacementGrid.DecoInfo> split = new ArrayList<LinkPlacementGrid.DecoInfo>();
            HashMap<LinkPlacementGrid.DecoInfoKey, Point2D> firstPtForTreeID = new HashMap<LinkPlacementGrid.DecoInfoKey, Point2D>();
            boolean modFound = false;
            Iterator fpit = forPt.keySet().iterator();
            while (fpit.hasNext()) {
                String srcKey = (String)fpit.next();
                LinkPlacementGrid.DecoInfo deco = (LinkPlacementGrid.DecoInfo)forPt.get(srcKey);
                if (deco.isModule) {
                    split.add(deco);
                    modFound = true;
                    continue;
                }
                if (deco.normCanon == 1 || deco.normCanon == 3) {
                    if (!forVert) continue;
                    split.add(deco);
                    firstPtForTreeID.put(deco.getDIK(), deco.firstPt);
                    continue;
                }
                if (forVert) continue;
                split.add(deco);
                firstPtForTreeID.put(deco.getDIK(), deco.firstPt);
            }
            if (split.size() < 2) {
                if (split.size() != 1 || !modFound) {
                    // empty if block
                }
                split = null;
            }
            if ((minForPt = this.decoSort(ptKey, split, forVert)) == null) continue;
            Iterator mfpit = minForPt.keySet().iterator();
            while (mfpit.hasNext()) {
                Point2D first;
                Point2D orig;
                Dimension[] forPoint;
                LinkPlacementGrid.DecoInfoKey dik = (LinkPlacementGrid.DecoInfoKey)mfpit.next();
                int[] overlap = (int[])minForPt.get(dik);
                HashMap<Point2D, Dimension[]> forTree = (HashMap<Point2D, Dimension[]>)retval.get(dik.treeID);
                if (forTree == null) {
                    treePending = true;
                    forTree = new HashMap<Point2D, Dimension[]>();
                }
                if ((forPoint = (Dimension[])forTree.get(orig = (Point2D)inverse.get(first = (Point2D)firstPtForTreeID.get(dik)))) == null) {
                    forPoint = new Dimension[]{new Dimension(0, 0), new Dimension(0, 0)};
                    pending = true;
                }
                if (overlap[0] > (forVert ? forPoint[0].width : forPoint[0].height)) {
                    if (forVert) {
                        forPoint[0].width = overlap[0];
                    } else {
                        forPoint[0].height = overlap[0];
                    }
                    modified = true;
                    upgraded = true;
                }
                if (overlap[1] > (forVert ? forPoint[1].width : forPoint[1].height)) {
                    if (forVert) {
                        forPoint[1].width = overlap[1];
                    } else {
                        forPoint[1].height = overlap[1];
                    }
                    modified = true;
                    upgraded = true;
                }
                if (!pending || !modified) continue;
                if (treePending) {
                    retval.put(dik.treeID, forTree);
                }
                forTree.put(orig, forPoint);
            }
        }
        return !upgraded && currMap == null ? null : retval;
    }

    private void shiftWorkingInterModPaths(Map workingCopy, Map movedPts) {
        Iterator samit = this.sa_.getInterModPathKeys();
        while (samit.hasNext()) {
            String modID = (String)samit.next();
            NetModuleLinkExtractor.ExtractResultForSource res = (NetModuleLinkExtractor.ExtractResultForSource)workingCopy.get(modID);
            res.shiftPaths(movedPts);
        }
    }

    private void installShiftedInterModPaths(Map movedPts) {
        Iterator samit = this.sa_.getInterModPathKeys();
        while (samit.hasNext()) {
            String modID = (String)samit.next();
            NetModuleLinkExtractor.ExtractResultForSource res = this.sa_.getExtractResultForSource(modID);
            res.shiftPaths(movedPts);
        }
    }

    private Map copyInterModPaths() {
        HashMap<String, NetModuleLinkExtractor.ExtractResultForSource> localCopy = new HashMap<String, NetModuleLinkExtractor.ExtractResultForSource>();
        Iterator samit = this.sa_.getInterModPathKeys();
        while (samit.hasNext()) {
            String modID = (String)samit.next();
            NetModuleLinkExtractor.ExtractResultForSource res = this.sa_.getExtractResultForSource(modID);
            NetModuleLinkExtractor.ExtractResultForSource myCopy = (NetModuleLinkExtractor.ExtractResultForSource)res.clone();
            localCopy.put(modID, myCopy);
        }
        return localCopy;
    }

    private void installNodeProps(SpecialtyInstructions props, Genome genome, Layout working, UndoSupport support, GenomeSubset subset, BTProgressMonitor monitor, boolean skipPads) throws AsynchExitRequestException {
        Map ptPos = props.nodeLocations;
        Iterator pkit = ptPos.keySet().iterator();
        while (pkit.hasNext()) {
            String ptID = (String)pkit.next();
            if (subset != null && !subset.nodeInSubset(ptID)) continue;
            Point2D loc = (Point2D)ptPos.get(ptID);
            NodeProperties npo = working.getNodeProperties(ptID);
            Point2D currLoc = npo.getLocation();
            double dx = UiUtil.forceToGridValue(loc.getX() - currLoc.getX(), 10.0);
            double dy = UiUtil.forceToGridValue(loc.getY() - currLoc.getY(), 10.0);
            working.moveNode(ptID, genome, dx, dy, skipPads ? null : this.padNeedsForLayout_);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        Map nodeOrient = props.orientChanges;
        Iterator noit = nodeOrient.keySet().iterator();
        while (noit.hasNext()) {
            String nodeID = (String)noit.next();
            if (subset != null && !subset.nodeInSubset(nodeID)) continue;
            Integer orient = (Integer)nodeOrient.get(nodeID);
            int newOrient = orient;
            NodeProperties npo = working.getNodeProperties(nodeID);
            int currOrient = npo.getOrientation();
            if (currOrient == newOrient) continue;
            NodeProperties changedProps = (NodeProperties)npo.clone();
            changedProps.setOrientation(newOrient);
            working.replaceNodeProperties(npo, changedProps);
        }
        Map nodeExtraGrowth = props.extraGrowthChanges;
        Iterator negit = nodeExtraGrowth.keySet().iterator();
        while (negit.hasNext()) {
            String nodeID = (String)negit.next();
            if (subset != null && !subset.nodeInSubset(nodeID)) continue;
            Integer extraGrowth = (Integer)nodeExtraGrowth.get(nodeID);
            int newExtra = extraGrowth;
            NodeProperties npo = working.getNodeProperties(nodeID);
            int currExtra = npo.getExtraGrowthDirection();
            if (currExtra == newExtra) continue;
            NodeProperties changedProps = (NodeProperties)npo.clone();
            changedProps.setExtraGrowthDirection(newExtra);
            working.replaceNodeProperties(npo, changedProps);
        }
        this.ac_.specialtyPadChanges(props.padChanges, genome, support);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        Iterator pit = props.lengthChanges.keySet().iterator();
        while (pit.hasNext()) {
            GenomeChange gc;
            String nodeID = (String)pit.next();
            if (subset != null && !subset.nodeInSubset(nodeID)) continue;
            Node node = genome.getNode(nodeID);
            int currPads = node.getPadCount();
            Integer wantPads = (Integer)props.lengthChanges.get(nodeID);
            int newPads = wantPads;
            if (newPads <= currPads || (gc = node.getNodeType() == 4 ? genome.changeGeneSize(nodeID, newPads) : genome.changeNodeSize(nodeID, newPads)) == null || support == null) continue;
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
    }

    public class RegionLayoutExpander
    extends LayoutRubberStamper.RegionExpander {
        private String regionID_;
        private Rectangle oldRect_;
        private Rectangle newRect_;
        private UndoSupport support_;
        private GenomeSubset sub_;
        private Rectangle padded_;

        public RegionLayoutExpander(String regionID, Rectangle oldRect, Rectangle newRect, UndoSupport support, GenomeSubset sub, Rectangle padded, Map chopDeparts, Map chopArrives) {
            super(chopDeparts, chopArrives);
            this.regionID_ = regionID;
            this.oldRect_ = (Rectangle)oldRect.clone();
            this.newRect_ = (Rectangle)newRect.clone();
            this.support_ = support;
            this.sub_ = sub;
            this.padded_ = padded;
        }

        protected void customExpandTheRegion(String grpID, double startFrac, double endFrac) throws AsynchExitRequestException {
            if (!this.regionID_.equals(grpID)) {
                throw new IllegalArgumentException();
            }
            int extraWidth = this.newRect_.width - this.oldRect_.width;
            int extraHeight = this.newRect_.height - this.oldRect_.height;
            if (extraWidth < 0) {
                extraWidth = 0;
            }
            if (extraHeight < 0) {
                extraHeight = 0;
            }
            SpecialtyInstructions results = (SpecialtyInstructions)SpecialtyLayoutEngine.this.propList_.get(0);
            SpecialtyLayoutEngine.this.installNodeProps(results, this.gi, this.grpLo, this.support_, this.sub_, this.monitor, true);
            SpecialtyLayoutEngine.this.updateRegionBounds(this.gi, this.padded_, grpID, this.grpLo);
            int mult = 1;
            if (mult > 0) {
                // empty if block
            }
        }

        public Rectangle getGroupBounds(String grpID) {
            if (this.regionID_.equals(grpID)) {
                return this.newRect_;
            }
            Group grp = this.gi.getGroup(grpID);
            this.grpLo = (Layout)this.layouts.get(grpID);
            return this.grpLo.getLayoutBoundsForGroup(this.gi, grp, this.frc, true);
        }
    }

    public static class GlobalSLEState {
        private ArrayList sldData_ = new ArrayList();
        private Map padChanges_;

        public GlobalSLEState(Map padChanges) {
            this.padChanges_ = padChanges;
        }

        public void addData(SpecialtyLayoutData sld) {
            this.sldData_.add(sld);
        }

        public Map getGlobalPadChanges() {
            return this.padChanges_;
        }

        public Iterator dataIterator() {
            return this.sldData_.iterator();
        }
    }
}

