/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.analysis.CycleFinder;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.ui.BusDrop;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.layouts.LayoutFailureTracker;
import org.systemsbiology.biotapestry.ui.layouts.LinkBundleSplicer;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class SpecialtyLayoutLinkData
implements Cloneable {
    public static final int INIT_POINT = 0;
    public static final int RIGHT_TIP = 1;
    public static final int LEFT_TIP = 2;
    public static final int INIT_TRACE = 3;
    public static final int MIN_TRACE = 4;
    public static final int MAX_TRACE = 5;
    public static final int NUM_EXIT_FRAMEWORK = 6;
    public static final int TOP_BORDER = 0;
    public static final int BOTTOM_BORDER = 1;
    public static final int LEFT_BORDER = 2;
    public static final int RIGHT_BORDER = 3;
    public static final int NUM_BORDERS = 4;
    private List initRoute_ = null;
    private HashMap borderPoints_;
    private HashMap exitFramework_;
    private String srcID_;
    private HashMap chopPtToBoundary_;
    private ArrayList linkIDs_ = new ArrayList();
    private HashMap pointsPerLink_ = new HashMap();
    private HashSet needsExitGlue_;
    private boolean normalized_ = false;

    public SpecialtyLayoutLinkData(String srcID) {
        this.borderPoints_ = new HashMap();
        this.exitFramework_ = new HashMap();
        this.needsExitGlue_ = new HashSet();
        this.chopPtToBoundary_ = new HashMap();
        this.srcID_ = srcID;
    }

    public void setNeedsExitGlue(String linkID) {
        this.needsExitGlue_.add(linkID);
    }

    public String getSrcID() {
        return this.srcID_;
    }

    public int numLinks() {
        return this.linkIDs_ == null ? 0 : this.linkIDs_.size();
    }

    public String getLink(int i) {
        return (String)this.linkIDs_.get(i);
    }

    public boolean haveLink(String linkID) {
        return this.linkIDs_.contains(linkID);
    }

    public void setExitFramework(PlacedPoint pt, int role) {
        this.exitFramework_.put(new Integer(role), pt);
    }

    public boolean hasExitFramework(int role) {
        return this.exitFramework_.containsKey(new Integer(role));
    }

    public PlacedPoint getExitFrameworkForDebug(int i) {
        return (PlacedPoint)this.exitFramework_.get(new Integer(i));
    }

    public List getLinkList() {
        return this.linkIDs_;
    }

    public List getPositionList(String linkID) {
        return (List)this.pointsPerLink_.get(linkID);
    }

    public List getCleanedPositionList(String linkID) {
        if (!this.normalized_) {
            throw new IllegalStateException();
        }
        NoZeroList nzl = (NoZeroList)this.pointsPerLink_.get(linkID);
        return nzl;
    }

    public void shift(Vector2D shiftVec) {
        Iterator pplit = this.pointsPerLink_.values().iterator();
        while (pplit.hasNext()) {
            ArrayList ptsList = (ArrayList)pplit.next();
            int numL = ptsList.size();
            for (int i = 0; i < numL; ++i) {
                TrackPos tp = (TrackPos)ptsList.get(i);
                if (tp.needsConversion()) continue;
                Point2D segPt = tp.getPoint();
                segPt.setLocation(shiftVec.add(segPt));
            }
        }
        if (this.initRoute_ != null) {
            Iterator irit = this.initRoute_.iterator();
            while (irit.hasNext()) {
                TrackPos tp = (TrackPos)irit.next();
                if (tp.needsConversion()) continue;
                Point2D segPt = tp.getPoint();
                segPt.setLocation(shiftVec.add(segPt));
            }
        }
        Iterator epit = this.borderPoints_.values().iterator();
        while (epit.hasNext()) {
            Point2D pt = (Point2D)epit.next();
            pt.setLocation(shiftVec.add(pt));
        }
        Iterator efit = this.exitFramework_.values().iterator();
        while (efit.hasNext()) {
            PlacedPoint pt = (PlacedPoint)efit.next();
            pt.point.setLocation(shiftVec.add(pt.point));
        }
        Iterator cpit = this.chopPtToBoundary_.keySet().iterator();
        HashMap<Point2D, Integer> newMap = new HashMap<Point2D, Integer>();
        while (cpit.hasNext()) {
            Point2D pt = (Point2D)cpit.next();
            Integer boundForChop = (Integer)this.chopPtToBoundary_.get(pt);
            Point2D newKey = (Point2D)pt.clone();
            newKey.setLocation(shiftVec.add(pt));
            newMap.put(newKey, boundForChop);
        }
        this.chopPtToBoundary_.clear();
        this.chopPtToBoundary_.putAll(newMap);
        LayoutFailureTracker.recordShiftedBordersAndExits(this, shiftVec);
    }

    public boolean yesWeNeedIt(Integer side, Map needArrivals, Map needDepartures) {
        if (needArrivals == null || needDepartures == null) {
            return true;
        }
        HashSet forArr = (HashSet)needArrivals.get(this.srcID_);
        HashSet forDep = (HashSet)needDepartures.get(this.srcID_);
        if (forArr == null) {
            forArr = new HashSet();
        }
        if (forDep == null) {
            forDep = new HashSet();
        }
        switch (side) {
            case 0: {
                return forDep.contains(new Vector2D(0.0, 1.0)) || forArr.contains(new Vector2D(0.0, 1.0));
            }
            case 1: {
                return forDep.contains(new Vector2D(0.0, -1.0)) || forArr.contains(new Vector2D(0.0, -1.0));
            }
            case 2: {
                return forDep.contains(new Vector2D(1.0, 0.0)) || forArr.contains(new Vector2D(1.0, 0.0));
            }
            case 3: {
                return forDep.contains(new Vector2D(-1.0, 0.0)) || forArr.contains(new Vector2D(-1.0, 0.0));
            }
        }
        throw new IllegalArgumentException();
    }

    public static int vecToBorder(Vector2D vec) {
        if (vec.equals(new Vector2D(0.0, 1.0))) {
            return 0;
        }
        if (vec.equals(new Vector2D(0.0, -1.0))) {
            return 1;
        }
        if (vec.equals(new Vector2D(1.0, 0.0))) {
            return 2;
        }
        if (vec.equals(new Vector2D(-1.0, 0.0))) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public Rectangle2D getLinkBounds(Map needArrivals, Map needDepartures) {
        Iterator<Object> pplit;
        Rectangle2D retval = null;
        if (this.initRoute_ != null) {
            pplit = this.initRoute_.iterator();
            TrackPos tp = (TrackPos)pplit.next();
            Point2D segPt = tp.getPoint();
            if (segPt == null) {
                throw new IllegalStateException();
            }
            if (retval == null) {
                retval = Bounds.initBoundsWithPoint(segPt);
            } else {
                Bounds.tweakBoundsWithPoint(retval, segPt);
            }
        } else {
            pplit = this.pointsPerLink_.values().iterator();
            while (pplit.hasNext()) {
                ArrayList ptsList = (ArrayList)pplit.next();
                int numL = ptsList.size();
                for (int i = 0; i < numL; ++i) {
                    TrackPos tp = (TrackPos)ptsList.get(i);
                    Point2D segPt = tp.getPoint();
                    if (segPt == null) {
                        throw new IllegalStateException();
                    }
                    if (retval == null) {
                        retval = Bounds.initBoundsWithPoint(segPt);
                        continue;
                    }
                    Bounds.tweakBoundsWithPoint(retval, segPt);
                }
            }
        }
        Iterator efit = this.borderPoints_.keySet().iterator();
        while (efit.hasNext()) {
            Integer side = (Integer)efit.next();
            if (!this.yesWeNeedIt(side, needArrivals, needDepartures)) continue;
            Point2D pt = (Point2D)this.borderPoints_.get(side);
            if (retval == null) {
                retval = Bounds.initBoundsWithPoint(pt);
                continue;
            }
            Bounds.tweakBoundsWithPoint(retval, pt);
        }
        return retval;
    }

    public void extractTreeTrunkRemains(BusProperties bp, Set links, Rectangle chopRect, Map segGeoms, Set seenSegs) {
        Iterator dit = bp.getDrops();
        ArrayList<String> linkIDCandidates = new ArrayList<String>();
        HashMap<String, NoZeroList> candPointsPerLink = new HashMap<String, NoZeroList>();
        while (dit.hasNext()) {
            BusDrop drop = (BusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            ArrayList<TrackPos> ptsToRoot = new ArrayList<TrackPos>();
            String linkID = drop.getTargetRef();
            if (!links.contains(linkID)) continue;
            List segIDs = bp.getSegmentIDsToRootForEndDrop(drop);
            boolean haveEmerged = false;
            Iterator sit = segIDs.iterator();
            while (sit.hasNext()) {
                UiUtil.PointAndSide[] pasIntersect;
                Point2D start;
                Point2D end;
                LinkSegmentID lsid = (LinkSegmentID)sit.next();
                if (lsid.isForEndDrop()) {
                    LinkSegment fakeSeg = (LinkSegment)segGeoms.get(lsid);
                    end = fakeSeg.getEnd();
                    start = fakeSeg.getStart();
                    if (chopRect.contains(end) && chopRect.contains(start) || (pasIntersect = UiUtil.rectIntersections(chopRect, start, end)) == null) continue;
                    ptsToRoot.add(new TrackPos(pasIntersect[pasIntersect.length - 1].point));
                    haveEmerged = true;
                    this.chopPtToBoundary_.put(pasIntersect[pasIntersect.length - 1].point.clone(), new Integer(SpecialtyLayoutLinkData.rectSideToOurBorder(pasIntersect[pasIntersect.length - 1].side)));
                    continue;
                }
                if (lsid.isForStartDrop()) {
                    UiUtil.PointAndSide[] pasIntersect2;
                    LinkSegmentID rootID = bp.getRootSegmentID();
                    seenSegs.add(rootID);
                    LinkSegment fakeSeg = (LinkSegment)segGeoms.get(lsid);
                    start = fakeSeg.getStart();
                    Point2D end2 = fakeSeg.getEnd();
                    if (!chopRect.contains(end2)) {
                        ptsToRoot.add(new TrackPos((Point2D)end2.clone()));
                    }
                    if ((pasIntersect2 = UiUtil.rectIntersections(chopRect, start, end2)) != null) {
                        ptsToRoot.add(new TrackPos(pasIntersect2[pasIntersect2.length - 1].point));
                        this.chopPtToBoundary_.put(pasIntersect2[pasIntersect2.length - 1].point.clone(), new Integer(SpecialtyLayoutLinkData.rectSideToOurBorder(pasIntersect2[pasIntersect2.length - 1].side)));
                    }
                    this.needsExitGlue_.add(linkID);
                    break;
                }
                if (lsid.isDirect()) {
                    return;
                }
                LinkSegment seg = bp.getSegment(lsid);
                end = seg.getEnd();
                start = seg.getStart();
                if (chopRect.contains(end) && chopRect.contains(start)) {
                    if (!haveEmerged) continue;
                    haveEmerged = false;
                    ptsToRoot.clear();
                    continue;
                }
                pasIntersect = UiUtil.rectIntersections(chopRect, start, end);
                if (pasIntersect != null) {
                    if (haveEmerged) {
                        haveEmerged = false;
                        ptsToRoot.clear();
                    }
                    ptsToRoot.add(new TrackPos(pasIntersect[pasIntersect.length - 1].point));
                    haveEmerged = true;
                    this.chopPtToBoundary_.put(pasIntersect[pasIntersect.length - 1].point.clone(), new Integer(SpecialtyLayoutLinkData.rectSideToOurBorder(pasIntersect[pasIntersect.length - 1].side)));
                    continue;
                }
                if (!haveEmerged) continue;
                ptsToRoot.add(new TrackPos((Point2D)end.clone()));
                if (seenSegs.contains(lsid)) break;
                seenSegs.add(lsid);
            }
            linkIDCandidates.add(linkID);
            NoZeroList ptsPerLink = new NoZeroList();
            candPointsPerLink.put(linkID, ptsPerLink);
            Collections.reverse(ptsToRoot);
            ((ArrayList)ptsPerLink).addAll(ptsToRoot);
            LayoutFailureTracker.recordTreeTrunk(this, linkID, ptsPerLink);
        }
        this.linkIDs_.addAll(linkIDCandidates);
        if (new HashSet(this.linkIDs_).size() != this.linkIDs_.size()) {
            throw new IllegalStateException();
        }
        this.pointsPerLink_.putAll(candPointsPerLink);
    }

    public void extractTreeLeafRemains(BusProperties bp, Rectangle chopRect, Map segGeoms, Set ignoreLinks, boolean regionChopped) {
        Iterator dit = bp.getDrops();
        HashSet<LinkSegmentID> seenSegs = new HashSet<LinkSegmentID>();
        while (dit.hasNext()) {
            BusDrop drop = (BusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            ArrayList<TrackPos> ptsToRoot = new ArrayList<TrackPos>();
            String linkID = drop.getTargetRef();
            if (ignoreLinks != null && ignoreLinks.contains(linkID)) continue;
            List segIDs = bp.getSegmentIDsToRootForEndDrop(drop);
            Iterator sit = segIDs.iterator();
            while (sit.hasNext()) {
                LinkSegmentID lsid = (LinkSegmentID)sit.next();
                if (lsid.isForEndDrop()) {
                    boolean intersected = this.leafChopper(lsid, segGeoms, ptsToRoot, regionChopped, chopRect);
                    if (!intersected) continue;
                    this.needsExitGlue_.add(linkID);
                    break;
                }
                if (lsid.isForStartDrop()) {
                    LinkSegmentID rootID = bp.getRootSegmentID();
                    seenSegs.add(rootID);
                    this.leafChopper(lsid, segGeoms, ptsToRoot, regionChopped, chopRect);
                    this.needsExitGlue_.add(linkID);
                    break;
                }
                if (lsid.isDirect()) {
                    return;
                }
                LinkSegment seg = bp.getSegment(lsid);
                Point2D end = seg.getEnd();
                ptsToRoot.add(new TrackPos((Point2D)end.clone()));
                if (seenSegs.contains(lsid)) break;
                seenSegs.add(lsid);
                boolean intersected = this.leafChopper(lsid, segGeoms, ptsToRoot, regionChopped, chopRect);
                if (!intersected) continue;
                this.needsExitGlue_.add(linkID);
                break;
            }
            if (this.linkIDs_.contains(linkID)) {
                throw new IllegalStateException();
            }
            this.linkIDs_.add(linkID);
            NoZeroList ptsPerLink = new NoZeroList();
            this.pointsPerLink_.put(linkID, ptsPerLink);
            Collections.reverse(ptsToRoot);
            ((ArrayList)ptsPerLink).addAll(ptsToRoot);
            LayoutFailureTracker.recordTreeLeaf(this, linkID, ptsPerLink);
        }
    }

    private boolean leafChopper(LinkSegmentID lsid, Map segGeoms, List ptsToRoot, boolean regionChopped, Rectangle chopRect) {
        boolean retval;
        LinkSegment fakeSeg = (LinkSegment)segGeoms.get(lsid);
        Point2D start = fakeSeg.getStart();
        Point2D end = fakeSeg.getEnd();
        ptsToRoot.add(new TrackPos((Point2D)end.clone()));
        UiUtil.PointAndSide[] pasIntersect = UiUtil.rectIntersections(chopRect, start, end);
        boolean bl = retval = pasIntersect != null;
        if (retval) {
            Point2D usePt = regionChopped ? (Point2D)end.clone() : pasIntersect[pasIntersect.length - 1].point;
            ptsToRoot.add(new TrackPos(usePt));
            int useSideIndex = regionChopped ? 0 : pasIntersect.length - 1;
            this.chopPtToBoundary_.put(usePt.clone(), new Integer(SpecialtyLayoutLinkData.rectSideToOurBorder(pasIntersect[useSideIndex].side)));
        }
        return retval;
    }

    public void normalizeLinks() {
        int i;
        if (this.normalized_) {
            return;
        }
        int numLink = this.linkIDs_.size();
        for (i = 0; i < numLink; ++i) {
            String linkID = (String)this.linkIDs_.get(i);
            NoZeroList nzl = (NoZeroList)this.pointsPerLink_.get(linkID);
            nzl.clean();
        }
        this.linkIDs_ = new ArrayList(this.recalculateOrder());
        if (this.linkIDs_.size() != numLink) {
            throw new IllegalStateException();
        }
        for (i = 0; i < numLink; ++i) {
            String masterLink = (String)this.linkIDs_.get(i);
            List masterPts = (List)this.pointsPerLink_.get(masterLink);
            int numMaster = masterPts.size();
            for (int j = i + 1; j < numLink; ++j) {
                String checkLink = (String)this.linkIDs_.get(j);
                List checkPts = (List)this.pointsPerLink_.get(checkLink);
                int n = 0;
                boolean runStarted = false;
                block3: for (int k = 0; k < numMaster; ++k) {
                    Point2D pt = ((TrackPos)masterPts.get(k)).getPoint();
                    if (!runStarted) {
                        n = 0;
                    }
                    while (n < checkPts.size()) {
                        Point2D chkPt = ((TrackPos)checkPts.get(n)).getPoint();
                        if (chkPt.equals(pt)) {
                            if (runStarted) {
                                checkPts.remove(n - 1);
                                continue block3;
                            }
                            runStarted = true;
                            ++n;
                            continue block3;
                        }
                        runStarted = false;
                        ++n;
                    }
                }
            }
        }
        this.normalized_ = true;
    }

    private List recalculateOrder() {
        HashSet nodes = new HashSet(this.linkIDs_);
        HashSet<Link> links = new HashSet<Link>();
        int numLink = this.linkIDs_.size();
        for (int i = numLink - 1; i >= 0; --i) {
            String linkID = (String)this.linkIDs_.get(i);
            List linkPts = (List)this.pointsPerLink_.get(linkID);
            if (linkPts.isEmpty()) {
                throw new IllegalStateException();
            }
            Point2D firstPt = ((TrackPos)linkPts.get(0)).getPoint();
            boolean lookingForParent = true;
            int j = numLink - 1;
            block1: while (lookingForParent && j >= 0) {
                String testID;
                if ((testID = (String)this.linkIDs_.get(j--)).equals(linkID)) continue;
                List testPts = (List)this.pointsPerLink_.get(testID);
                if (testPts.isEmpty()) {
                    throw new IllegalStateException();
                }
                int numTest = testPts.size();
                for (int k = 1; k < numTest; ++k) {
                    Point2D testPt = ((TrackPos)testPts.get(k)).getPoint();
                    if (!firstPt.equals(testPt)) continue;
                    HashSet testLinks = (HashSet)links.clone();
                    Link toAdd = new Link(linkID, testID);
                    testLinks.add(toAdd);
                    CycleFinder cf = new CycleFinder(nodes, (Set)testLinks);
                    if (cf.hasACycle()) continue;
                    links.add(toAdd);
                    lookingForParent = false;
                    continue block1;
                }
            }
        }
        GraphSearcher gs = new GraphSearcher(nodes, links);
        List linkList = gs.topoSortToPartialOrdering(gs.topoSort(false));
        Collections.reverse(linkList);
        return linkList;
    }

    public Map buildNeededExitRoutes(List needs, Map solnPerBorder) {
        HashMap<String, RouteNeeds> retval = new HashMap<String, RouteNeeds>();
        int numNeeds = needs.size();
        for (int i = 0; i < numNeeds; ++i) {
            RouteNeeds rn = (RouteNeeds)needs.get(i);
            this.buildNeededExitRoute(rn, solnPerBorder);
            retval.put(rn.linkID, rn);
        }
        return retval;
    }

    private void buildNeededExitRoute(RouteNeeds rn, Map solnPerBorder) {
        Point2D lex;
        PlacedPoint pps;
        PlacedPoint ppl;
        LinkBundleSplicer.SpliceSolution soln = solnPerBorder == null ? null : (LinkBundleSplicer.SpliceSolution)solnPerBorder.get(rn.border);
        rn.path = new NoZeroList();
        PlacedPoint ppi = (PlacedPoint)this.exitFramework_.get(new Integer(0));
        if (ppi != null && !ppi.placed) {
            rn.path.addAll(this.initRoute_);
            ppi.placed = true;
        }
        if (rn.border == 2) {
            ppl = (PlacedPoint)this.exitFramework_.get(new Integer(2));
            if (ppl != null) {
                if (!ppl.placed) {
                    throw new IllegalStateException();
                }
                rn.path.add(new TrackPos(ppl.point));
            }
            if ((pps = (PlacedPoint)this.exitFramework_.get(new Integer(3))) != null && !pps.placed) {
                rn.path.add(new TrackPos(pps.point));
                pps.placed = true;
            }
            Point2D lex2 = (Point2D)this.borderPoints_.get(new Integer(2));
            rn.path.add(new TrackPos(lex2));
        }
        if (rn.border == 3) {
            PlacedPoint ppr = (PlacedPoint)this.exitFramework_.get(new Integer(1));
            if (ppr != null && !ppr.placed) {
                rn.path.add(new TrackPos(ppr.point));
                ppr.placed = true;
            }
            Point2D lex3 = (Point2D)this.borderPoints_.get(new Integer(3));
            rn.path.add(new TrackPos(lex3));
        }
        if (rn.border == 0) {
            PlacedPoint ppn;
            ppl = (PlacedPoint)this.exitFramework_.get(new Integer(2));
            if (ppl != null) {
                if (!ppl.placed) {
                    throw new IllegalStateException();
                }
                rn.path.add(new TrackPos(ppl.point));
            }
            if ((pps = (PlacedPoint)this.exitFramework_.get(new Integer(3))) != null && !pps.placed) {
                rn.path.add(new TrackPos(pps.point));
                pps.placed = true;
            }
            if ((ppn = (PlacedPoint)this.exitFramework_.get(new Integer(4))) != null) {
                if (!ppn.placed) {
                    throw new IllegalStateException();
                }
                rn.path.add(new TrackPos(ppn.point));
            }
            lex = (Point2D)this.borderPoints_.get(new Integer(0));
            rn.path.add(new TrackPos(lex));
        }
        if (rn.border == 1) {
            PlacedPoint ppx;
            ppl = (PlacedPoint)this.exitFramework_.get(new Integer(2));
            if (ppl != null) {
                if (!ppl.placed) {
                    throw new IllegalStateException();
                }
                rn.path.add(new TrackPos(ppl.point));
            }
            if ((pps = (PlacedPoint)this.exitFramework_.get(new Integer(3))) != null && !pps.placed) {
                rn.path.add(new TrackPos(pps.point));
                pps.placed = true;
            }
            if ((ppx = (PlacedPoint)this.exitFramework_.get(new Integer(5))) != null) {
                if (!ppx.placed) {
                    throw new IllegalStateException();
                }
                rn.path.add(new TrackPos(ppx.point));
            }
            lex = (Point2D)this.borderPoints_.get(new Integer(1));
            rn.path.add(new TrackPos(lex));
        }
        if (soln != null) {
            Map perExit = soln.getPaths(this.srcID_);
            if (perExit == null) {
                System.err.println("buildNeededExitRoute: Unexpected null perExit");
                return;
            }
            List ptList = perExit.size() == 1 ? (List)perExit.values().iterator().next() : (List)perExit.get(new Integer((int)(rn.coord / 10.0)));
            if (ptList != null) {
                int pathLen = ptList.size();
                for (int i = 0; i < pathLen; ++i) {
                    Point2D pt = (Point2D)ptList.get(i);
                    Point2D.Double scaled = new Point2D.Double(pt.getX() * 10.0, pt.getY() * 10.0);
                    rn.path.add(new TrackPos(scaled));
                }
            } else {
                System.err.println("buildNeededExitRoute: Unexpected null ptList");
            }
        }
        LayoutFailureTracker.trackRouteNeeds(this, rn);
    }

    private void buildNeededEntryRoute(RouteNeeds rn, Map spliceSolutionsPerBorder) {
        Point2D lex;
        LinkBundleSplicer.SpliceSolution soln = spliceSolutionsPerBorder == null ? null : (LinkBundleSplicer.SpliceSolution)spliceSolutionsPerBorder.get(rn.border);
        rn.path = new NoZeroList();
        if (soln != null) {
            Map perExit = soln.getPaths(this.srcID_);
            if (perExit != null) {
                List ptList = perExit.size() == 1 ? (List)perExit.values().iterator().next() : (List)perExit.get(new Integer((int)(rn.coord / 10.0)));
                if (ptList != null) {
                    int pathLen = ptList.size();
                    for (int i = pathLen - 1; i >= 0; --i) {
                        Point2D pt = (Point2D)ptList.get(i);
                        Point2D.Double scaled = new Point2D.Double(pt.getX() * 10.0, pt.getY() * 10.0);
                        rn.path.add(new TrackPos(scaled));
                    }
                }
            } else {
                System.err.println("buildNeededEntryRoute: Unexpected null perExit");
            }
        }
        if (rn.border == 2) {
            lex = (Point2D)this.borderPoints_.get(new Integer(2));
            rn.path.add(new TrackPos(lex));
        } else if (rn.border == 3) {
            lex = (Point2D)this.borderPoints_.get(new Integer(3));
            rn.path.add(new TrackPos(lex));
            lex = (Point2D)this.borderPoints_.get(new Integer(2));
            rn.path.add(new TrackPos(lex));
        } else if (rn.border == 0) {
            lex = (Point2D)this.borderPoints_.get(new Integer(0));
            rn.path.add(new TrackPos(lex));
            lex = (Point2D)this.borderPoints_.get(new Integer(2));
            rn.path.add(new TrackPos(lex));
        } else if (rn.border == 1) {
            lex = (Point2D)this.borderPoints_.get(new Integer(1));
            rn.path.add(new TrackPos(lex));
            lex = (Point2D)this.borderPoints_.get(new Integer(2));
            rn.path.add(new TrackPos(lex));
        }
    }

    public void setBorderPosition(int direction, Point2D position) {
        this.borderPoints_.put(new Integer(direction), position.clone());
    }

    public Point2D getBorderPosition(int direction) {
        return (Point2D)this.borderPoints_.get(new Integer(direction));
    }

    public List getLeftBorderAlignedPositions() {
        Point2D lbp = (Point2D)this.borderPoints_.get(new Integer(2));
        ArrayList<Object> retval = new ArrayList<Object>();
        if (lbp == null) {
            PlacedPoint pps = (PlacedPoint)this.exitFramework_.get(new Integer(3));
            if (pps != null) {
                lbp = pps.point;
            } else {
                return retval;
            }
        }
        double lbpx = lbp.getX();
        Iterator pplit = this.pointsPerLink_.values().iterator();
        while (pplit.hasNext()) {
            ArrayList ptsList = (ArrayList)pplit.next();
            int numL = ptsList.size();
            for (int i = 0; i < numL; ++i) {
                Point2D segPt;
                TrackPos tp = (TrackPos)ptsList.get(i);
                if (tp.needsConversion() || (segPt = tp.getPoint()).getX() != lbpx) continue;
                retval.add(segPt.clone());
            }
        }
        return retval;
    }

    public void addPositionToLink(String linkID, TrackPos nextLoc) {
        this.normalized_ = false;
        if (linkID == null) {
            if (this.initRoute_ == null) {
                throw new IllegalStateException();
            }
            this.initRoute_.add(nextLoc);
            return;
        }
        if (!this.linkIDs_.contains(linkID)) {
            throw new IllegalStateException();
        }
        NoZeroList nzl = (NoZeroList)this.pointsPerLink_.get(linkID);
        nzl.add(nextLoc);
    }

    public void addPositionListToLink(String linkID, List nextLocs) {
        this.normalized_ = false;
        if (linkID == null) {
            if (this.initRoute_ == null) {
                throw new IllegalStateException();
            }
            this.initRoute_.addAll(nextLocs);
            return;
        }
        if (!this.linkIDs_.contains(linkID)) {
            throw new IllegalStateException();
        }
        NoZeroList nzl = (NoZeroList)this.pointsPerLink_.get(linkID);
        nzl.addAll((Collection)nextLocs);
    }

    public void startInitRoute() {
        this.normalized_ = false;
        this.initRoute_ = new NoZeroList();
    }

    public List getInitRoute() {
        return this.initRoute_;
    }

    public void startNewLink(String linkID) {
        this.normalized_ = false;
        if (this.linkIDs_.contains(linkID)) {
            throw new IllegalStateException();
        }
        this.linkIDs_.add(linkID);
        NoZeroList ptsPerLink = new NoZeroList();
        this.pointsPerLink_.put(linkID, ptsPerLink);
    }

    public void merge(SpecialtyLayoutLinkData other) {
        this.normalized_ = false;
        this.linkIDs_.addAll(other.linkIDs_);
        if (new HashSet(this.linkIDs_).size() != this.linkIDs_.size()) {
            throw new IllegalStateException();
        }
        this.pointsPerLink_.putAll(other.pointsPerLink_);
    }

    public List exitRouteNeeds(SpecialtyLayoutLinkData other, Map solnPerBorder) {
        ArrayList<RouteNeeds> needs = new ArrayList<RouteNeeds>();
        if (this.linkIDs_.isEmpty()) {
            return needs;
        }
        Iterator negit = this.needsExitGlue_.iterator();
        while (negit.hasNext()) {
            String linkID = (String)negit.next();
            boolean gotIt = false;
            ArrayList need = (ArrayList)this.pointsPerLink_.get(linkID);
            TrackPos tp = (TrackPos)need.get(0);
            Integer boundary = (Integer)this.chopPtToBoundary_.get(tp.getPoint());
            if (solnPerBorder != null && !solnPerBorder.isEmpty()) {
                Iterator spbit = solnPerBorder.keySet().iterator();
                while (spbit.hasNext()) {
                    Integer border = (Integer)spbit.next();
                    LinkBundleSplicer.SpliceSolution soln = (LinkBundleSplicer.SpliceSolution)solnPerBorder.get(border);
                    if (soln.getPaths(this.srcID_) == null || !boundary.equals(border)) continue;
                    needs.add(new RouteNeeds(linkID, border, null));
                    gotIt = true;
                    break;
                }
            }
            if (gotIt) continue;
            RouteNeeds rn = other.posToNeed(linkID, tp.getPoint());
            needs.add(rn);
        }
        return needs;
    }

    private RouteNeeds exitRouteNeeded(SpecialtyLayoutLinkData other, Point2D startPoint, Vector2D dir, Map solnPerBorder) {
        Set sbpk;
        String linkID = (String)other.needsExitGlue_.iterator().next();
        if (solnPerBorder != null && (sbpk = solnPerBorder.keySet()).size() == 1) {
            return new RouteNeeds(linkID, (Integer)sbpk.iterator().next(), null);
        }
        RouteNeeds rn = SpecialtyLayoutLinkData.vecToNeed(linkID, dir, startPoint);
        if (rn != null) {
            return rn;
        }
        rn = this.posToNeed(linkID, startPoint);
        return rn;
    }

    private static RouteNeeds vecToNeed(String linkID, Vector2D dir, Point2D termPoint) {
        if (dir != null) {
            int canonical = dir.canonicalDir();
            switch (canonical) {
                case 1: {
                    return new RouteNeeds(linkID, new Integer(2), new Double(termPoint.getY()));
                }
                case 3: {
                    return new RouteNeeds(linkID, new Integer(3), new Double(termPoint.getY()));
                }
                case 2: {
                    return new RouteNeeds(linkID, new Integer(0), new Double(termPoint.getX()));
                }
                case 0: {
                    return new RouteNeeds(linkID, new Integer(1), new Double(termPoint.getX()));
                }
                case -1: {
                    return null;
                }
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    private RouteNeeds posToNeed(String linkID, Point2D pos) {
        double min = Double.POSITIVE_INFINITY;
        Integer minPos = null;
        for (int i = 0; i < 4; ++i) {
            Point2D pt = this.getBorderPosition(i);
            double dSq = pt.distanceSq(pos);
            if (!(dSq < min)) continue;
            min = dSq;
            minPos = new Integer(i);
        }
        return new RouteNeeds(linkID, minPos, null);
    }

    private RouteNeeds entryRouteNeeded(SpecialtyLayoutLinkData other, List need, Vector2D dir, Map solnPerBorder) {
        TrackPos tp;
        Point2D terminalPoint;
        RouteNeeds rn;
        int numOther = other.linkIDs_.size();
        if (numOther == 0) {
            return null;
        }
        String linkID = (String)other.linkIDs_.get(0);
        int numInNeed = need.size();
        if (numInNeed == 0) {
            return null;
        }
        if (solnPerBorder != null && !solnPerBorder.isEmpty()) {
            Iterator spbit = solnPerBorder.keySet().iterator();
            while (spbit.hasNext()) {
                Integer border = (Integer)spbit.next();
                LinkBundleSplicer.SpliceSolution soln = (LinkBundleSplicer.SpliceSolution)solnPerBorder.get(border);
                if (soln.getPaths(this.srcID_) == null) continue;
                return new RouteNeeds(linkID, border, null);
            }
        }
        if ((rn = SpecialtyLayoutLinkData.vecToNeed(linkID, dir, terminalPoint = (tp = (TrackPos)need.get(numInNeed - 1)).getPoint())) != null) {
            return rn;
        }
        rn = other.posToNeed(linkID, terminalPoint);
        return rn;
    }

    public Point2D extractForAlienSplice(SpecialtyLayoutLinkData other, int border) {
        int numMe = this.linkIDs_.size();
        for (int i = 0; i < numMe; ++i) {
            TrackPos lastPos;
            Point2D pt;
            Integer ptBorder;
            ArrayList myPts;
            String linkID = (String)this.linkIDs_.get(i);
            if (!other.linkIDs_.contains(linkID) || (myPts = (ArrayList)this.pointsPerLink_.get(linkID)).isEmpty() || (ptBorder = (Integer)this.chopPtToBoundary_.get(pt = (lastPos = (TrackPos)myPts.get(myPts.size() - 1)).getPoint())) == null || ptBorder != border) continue;
            return pt;
        }
        return null;
    }

    public Point2D extractForNonSubSplice(SpecialtyLayoutLinkData other, int border) {
        int numOther = other.linkIDs_.size();
        for (int i = 0; i < numOther; ++i) {
            String linkID = (String)other.linkIDs_.get(i);
            if (!this.linkIDs_.contains(linkID)) {
                throw new IllegalStateException();
            }
            ArrayList otherPts = (ArrayList)other.pointsPerLink_.get(linkID);
            TrackPos firstPos = (TrackPos)otherPts.get(0);
            Point2D pt = firstPos.getPoint();
            Integer ptBorder = (Integer)other.chopPtToBoundary_.get(pt);
            if (ptBorder == null || ptBorder != border) continue;
            return pt;
        }
        return null;
    }

    public void mergeToAlienStub(SpecialtyLayoutLinkData other, Map solnPerBorder) {
        LayoutFailureTracker.recordPreMergeOperation(this, other, "mergeToAlienStub");
        int numMe = this.linkIDs_.size();
        NoZeroList saveData = new NoZeroList();
        for (int i = 0; i < numMe; ++i) {
            String linkID = (String)this.linkIDs_.get(i);
            if (!other.linkIDs_.contains(linkID)) continue;
            saveData.addAll((Collection)((ArrayList)this.pointsPerLink_.get(linkID)));
            break;
        }
        int numOther = other.linkIDs_.size();
        for (int i = 0; i < numOther; ++i) {
            String linkID = (String)other.linkIDs_.get(i);
            if (!this.linkIDs_.contains(linkID)) {
                System.err.println("Unexpected linkID mismatch: " + linkID + " in " + this.linkIDs_);
                continue;
            }
            ArrayList exists = (ArrayList)this.pointsPerLink_.get(linkID);
            ArrayList merging = (ArrayList)other.pointsPerLink_.get(linkID);
            RouteNeeds rn = i == 0 ? this.entryRouteNeeded(other, saveData, null, solnPerBorder) : null;
            exists.clear();
            if (i == 0) {
                exists.addAll(saveData);
                if (rn != null) {
                    other.buildNeededEntryRoute(rn, solnPerBorder);
                    exists.addAll(rn.path);
                }
            }
            exists.addAll(merging);
        }
        LayoutFailureTracker.recordMergeOperation(this, "mergeToAlienStub");
    }

    public void mergeToStubs(SpecialtyLayoutLinkData other, Map solnPerBorder) {
        LayoutFailureTracker.recordPreMergeOperation(this, other, "mergeToStubs");
        List needs = other.exitRouteNeeds(this, solnPerBorder);
        Map builtRoutes = this.buildNeededExitRoutes(needs, solnPerBorder);
        int numOther = other.linkIDs_.size();
        for (int i = 0; i < numOther; ++i) {
            String linkID = (String)other.linkIDs_.get(i);
            if (!this.linkIDs_.contains(linkID)) {
                throw new IllegalStateException();
            }
            ArrayList exists = (ArrayList)this.pointsPerLink_.get(linkID);
            ArrayList merging = (ArrayList)other.pointsPerLink_.get(linkID);
            RouteNeeds rn = (RouteNeeds)builtRoutes.get(linkID);
            exists.clear();
            if (rn != null) {
                exists.addAll(rn.path);
            }
            exists.addAll(merging);
        }
        LayoutFailureTracker.recordMergeOperation(this, "mergeToStubs");
    }

    public void mergeToStubsWithBetween(SpecialtyLayoutLinkData other, SpecialtyLayoutLinkData between, Map srcSpliceSolnPerBorder) {
        LayoutFailureTracker.recordPreMergeOperation(this, other, "mergeToStubsWithBetween");
        List betNeeds = between.exitRouteNeeds(this, srcSpliceSolnPerBorder);
        ArrayList<RouteNeeds> prunedNeeds = new ArrayList<RouteNeeds>();
        int numNeeds = betNeeds.size();
        for (int i = 0; i < numNeeds; ++i) {
            RouteNeeds rn = (RouteNeeds)betNeeds.get(i);
            if (!other.needsExitGlue_.contains(rn.linkID)) continue;
            prunedNeeds.add(rn);
            break;
        }
        if (prunedNeeds.isEmpty()) {
            prunedNeeds.addAll(other.exitRouteNeeds(this, srcSpliceSolnPerBorder));
        }
        Map builtRoutes = this.buildNeededExitRoutes(prunedNeeds, srcSpliceSolnPerBorder);
        int numOther = other.linkIDs_.size();
        for (int i = 0; i < numOther; ++i) {
            String linkID = (String)other.linkIDs_.get(i);
            if (!this.linkIDs_.contains(linkID)) {
                throw new IllegalStateException();
            }
            ArrayList exists = (ArrayList)this.pointsPerLink_.get(linkID);
            ArrayList merging = (ArrayList)other.pointsPerLink_.get(linkID);
            RouteNeeds rn = (RouteNeeds)builtRoutes.get(linkID);
            exists.clear();
            if (rn != null) {
                exists.addAll(rn.path);
                ArrayList betPts = (ArrayList)between.pointsPerLink_.get(linkID);
                if (betPts != null) {
                    exists.addAll(betPts);
                }
            }
            exists.addAll(merging);
        }
        LayoutFailureTracker.recordMergeOperation(this, "mergeToStubsWithBetween");
    }

    public void mergeToStubsWithPoints(String srcID, SpecialtyLayoutLinkData other, Map srcSpliceSolnPerBorder, Map trgSpliceSolnPerBorder, NetModuleLinkExtractor.ExtractResultForTarg eRes) {
        LayoutFailureTracker.recordPreMergeOperation(this, other, "mergeToStubsWithPoints");
        RouteNeeds rn = null;
        int numBet = eRes.size();
        if (numBet != 0) {
            Point2D firstPt = eRes.getPoint(srcID, 0);
            rn = this.exitRouteNeeded(other, firstPt, eRes.getStartDirection(), srcSpliceSolnPerBorder);
            this.buildNeededExitRoute(rn, srcSpliceSolnPerBorder);
        }
        ArrayList<TrackPos> erTpList = new ArrayList<TrackPos>();
        for (int j = 0; j < numBet; ++j) {
            erTpList.add(new TrackPos(eRes.getPoint(srcID, j)));
        }
        int numOther = other.linkIDs_.size();
        for (int i = 0; i < numOther; ++i) {
            RouteNeeds rnx;
            String linkID = (String)other.linkIDs_.get(i);
            if (!this.linkIDs_.contains(linkID)) {
                throw new IllegalStateException();
            }
            ArrayList exists = (ArrayList)this.pointsPerLink_.get(linkID);
            ArrayList merging = (ArrayList)other.pointsPerLink_.get(linkID);
            exists.clear();
            if (rn != null && rn.linkID.equals(linkID)) {
                exists.addAll(rn.path);
                exists.addAll(erTpList);
            }
            RouteNeeds routeNeeds = rnx = i == 0 ? this.entryRouteNeeded(other, erTpList, eRes.getTerminalDirection(), trgSpliceSolnPerBorder) : null;
            if (rnx != null) {
                other.buildNeededEntryRoute(rnx, trgSpliceSolnPerBorder);
                exists.addAll(rnx.path);
            }
            exists.addAll(merging);
        }
        LayoutFailureTracker.recordMergeOperation(this, "mergeToStubsWithPoints");
    }

    public Object clone() {
        try {
            SpecialtyLayoutLinkData retval = (SpecialtyLayoutLinkData)super.clone();
            retval.linkIDs_ = new ArrayList(this.linkIDs_);
            retval.needsExitGlue_ = new HashSet(this.needsExitGlue_);
            retval.pointsPerLink_ = new HashMap();
            retval.initRoute_ = this.initRoute_ != null ? new ArrayList() : null;
            retval.borderPoints_ = new HashMap();
            retval.exitFramework_ = new HashMap();
            retval.chopPtToBoundary_ = new HashMap();
            Iterator pplit = this.pointsPerLink_.keySet().iterator();
            while (pplit.hasNext()) {
                String linkID = (String)pplit.next();
                ArrayList thisPtsPerLink = (ArrayList)this.pointsPerLink_.get(linkID);
                NoZeroList retvalPtsPerLink = new NoZeroList();
                retval.pointsPerLink_.put(linkID, retvalPtsPerLink);
                int numL = thisPtsPerLink.size();
                for (int i = 0; i < numL; ++i) {
                    TrackPos tp = (TrackPos)thisPtsPerLink.get(i);
                    ((ArrayList)retvalPtsPerLink).add(tp.clone());
                }
            }
            if (retval.initRoute_ != null) {
                int numL = this.initRoute_.size();
                for (int i = 0; i < numL; ++i) {
                    TrackPos tp = (TrackPos)this.initRoute_.get(i);
                    retval.initRoute_.add(tp.clone());
                }
            }
            Iterator efkit = this.exitFramework_.keySet().iterator();
            while (efkit.hasNext()) {
                Integer role = (Integer)efkit.next();
                PlacedPoint thisPP = (PlacedPoint)this.exitFramework_.get(role);
                retval.exitFramework_.put(role, thisPP.clone());
            }
            Iterator epkit = this.borderPoints_.keySet().iterator();
            while (epkit.hasNext()) {
                Integer role = (Integer)epkit.next();
                Point2D thisPt = (Point2D)this.borderPoints_.get(role);
                retval.borderPoints_.put(role, thisPt.clone());
            }
            Iterator cpit = this.chopPtToBoundary_.keySet().iterator();
            while (cpit.hasNext()) {
                Point2D pt = (Point2D)cpit.next();
                Integer boundForChop = (Integer)this.chopPtToBoundary_.get(pt);
                Point2D ptCopy = (Point2D)pt.clone();
                retval.chopPtToBoundary_.put(ptCopy, boundForChop);
            }
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("links: ");
        buf.append(this.linkIDs_);
        buf.append("\n");
        buf.append("ptsPer: ");
        buf.append(this.pointsPerLink_);
        return buf.toString();
    }

    public static void mergeMaps(Map target, Map source) {
        Iterator skit = source.keySet().iterator();
        while (skit.hasNext()) {
            String srcID = (String)skit.next();
            SpecialtyLayoutLinkData sinSrc = (SpecialtyLayoutLinkData)source.get(srcID);
            if (target.containsKey(srcID)) {
                SpecialtyLayoutLinkData sinTrg = (SpecialtyLayoutLinkData)target.get(srcID);
                sinTrg.merge(sinSrc);
                continue;
            }
            target.put(srcID, sinSrc);
        }
    }

    public static int borderToSpSide(int border) {
        switch (border) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int rectSideToOurBorder(int rectSide) {
        switch (rectSide) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class PlacedPoint
    implements Cloneable {
        boolean placed;
        Point2D point;

        public PlacedPoint(Point2D point, boolean placed) {
            this.point = (Point2D)point.clone();
            this.placed = placed;
        }

        public String toString() {
            return "PlacedPoint: pt = " + this.point + " placed: " + this.placed;
        }

        public Object clone() {
            try {
                PlacedPoint retval = (PlacedPoint)super.clone();
                retval.point = (Point2D)this.point.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }

    public static class RouteNeeds {
        String linkID;
        Integer border;
        ArrayList path;
        Double coord;

        RouteNeeds(String linkID, Integer border, Double coord) {
            this.linkID = linkID;
            this.border = border;
            this.coord = coord;
        }

        public String toString() {
            return "RouteNeeds: linkID = " + this.linkID + " border: " + this.border + " coord: " + this.coord + " path: " + this.path;
        }
    }

    public static class NoZeroList
    extends ArrayList {
        public boolean add(Object elem) {
            boolean doPointCheck;
            int mySize = this.size();
            TrackPos lastElem = mySize == 0 ? null : (TrackPos)this.get(mySize - 1);
            TrackPos tpElem = (TrackPos)elem;
            boolean bl = doPointCheck = lastElem != null && lastElem.getPoint() != null && tpElem.getPoint() != null;
            if (doPointCheck && lastElem.getPoint().equals(tpElem.getPoint())) {
                return false;
            }
            if (doPointCheck && tpElem.getPoint().getX() == 0.0 && tpElem.getPoint().getY() == 0.0) {
                System.err.println("Seeing 0 point: " + tpElem.getPoint());
            }
            return super.add(elem);
        }

        public boolean addAll(Collection elems) {
            boolean retval = false;
            Iterator eit = elems.iterator();
            while (eit.hasNext()) {
                Object elem = eit.next();
                boolean result = this.add(elem);
                retval = retval || result;
            }
            return retval;
        }

        public void clean() {
            int currIndex = 0;
            TrackPos lastElem = null;
            while (currIndex < this.size()) {
                boolean doPointCheck;
                TrackPos currElem = (TrackPos)this.get(currIndex);
                boolean bl = doPointCheck = lastElem != null && lastElem.getPoint() != null && currElem.getPoint() != null;
                if (doPointCheck && lastElem.getPoint().equals(currElem.getPoint())) {
                    this.remove(currIndex);
                    continue;
                }
                lastElem = currElem;
                ++currIndex;
            }
        }
    }

    public static class TrackPos
    implements Cloneable {
        protected Point2D point;

        public TrackPos(Point2D point) {
            this.point = point == null ? null : (Point2D)point.clone();
        }

        public Object clone() {
            try {
                TrackPos retval = (TrackPos)super.clone();
                if (this.point != null) {
                    retval.point = (Point2D)this.point.clone();
                }
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public boolean needsConversion() {
            return this.point == null;
        }

        public String toString() {
            return "TrackPos: pt = " + this.point;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public static List convertPointList(List pointList) {
            ArrayList<TrackPos> retval = new ArrayList<TrackPos>();
            int plSize = pointList.size();
            for (int i = 0; i < plSize; ++i) {
                Point2D point = (Point2D)pointList.get(i);
                retval.add(new TrackPos(point));
            }
            return retval;
        }
    }
}

