/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.UiUtil;

public class StackGenerator {
    public SortedMap buildStackOrder(Set gascCores, Genome genome, Layout lo, FontRenderContext frc) {
        TreeMap rowUsage = new TreeMap();
        HashMap<String, Rectangle> coreBounds = new HashMap<String, Rectangle>();
        Iterator gcit = gascCores.iterator();
        int maxY = Integer.MIN_VALUE;
        while (gcit.hasNext()) {
            String gascCore = (String)gcit.next();
            NodeProperties np = lo.getNodeProperties(gascCore);
            INodeRenderer rend = np.getRenderer();
            Node node = genome.getNode(gascCore);
            Rectangle currRect = rend.getBounds(genome, node, lo, frc, null);
            coreBounds.put(gascCore, currRect);
            maxY = this.doRowAccounting(currRect, rowUsage, maxY);
        }
        SortedSet holes = this.findHoles(rowUsage, maxY);
        if (holes == null) {
            return null;
        }
        SortedMap rows = this.buildRows(holes, coreBounds);
        SortedMap retval = this.sortRows(rows, coreBounds);
        return retval;
    }

    private int doRowAccounting(Rectangle2D currRect, SortedMap rowUsage, int maxY) {
        int startY = (int)UiUtil.forceToGridValueMin(currRect.getMinY(), 10.0) / 10;
        int endY = (int)UiUtil.forceToGridValueMax(currRect.getMaxY(), 10.0) / 10;
        for (int i = startY; i <= endY; ++i) {
            Integer rowKey = new Integer(i);
            Integer count = (Integer)rowUsage.get(rowKey);
            count = count == null ? new Integer(1) : new Integer(count + 1);
            rowUsage.put(rowKey, count);
        }
        return endY > maxY ? endY : maxY;
    }

    private SortedSet findHoles(SortedMap rowUsage, int maxY) {
        TreeSet<Integer> retval = new TreeSet<Integer>();
        boolean first = true;
        int counter = 0;
        Iterator ruit = rowUsage.keySet().iterator();
        while (ruit.hasNext()) {
            Integer row = (Integer)ruit.next();
            int rowVal = row;
            if (first) {
                counter = rowVal;
                first = false;
                continue;
            }
            if (rowVal == ++counter) continue;
            retval.add(new Integer(rowVal - 1));
            counter = rowVal;
        }
        retval.add(new Integer(maxY));
        return retval;
    }

    private SortedMap buildRows(Set holes, Map coreBounds) {
        TreeMap<Integer, ArrayList<String>> retval = new TreeMap<Integer, ArrayList<String>>();
        Iterator cit = coreBounds.keySet().iterator();
        block0: while (cit.hasNext()) {
            String coreID = (String)cit.next();
            Rectangle2D bounds = (Rectangle2D)coreBounds.get(coreID);
            int coreY = (int)UiUtil.forceToGridValueMin(bounds.getMinY(), 10.0) / 10;
            Iterator hit = holes.iterator();
            while (hit.hasNext()) {
                Integer row = (Integer)hit.next();
                if (coreY >= row) continue;
                ArrayList<String> perRow = (ArrayList<String>)retval.get(row);
                if (perRow == null) {
                    perRow = new ArrayList<String>();
                    retval.put(row, perRow);
                }
                perRow.add(coreID);
                continue block0;
            }
        }
        return retval;
    }

    private SortedMap sortRows(SortedMap rows, Map coreBounds) {
        TreeMap holder = new TreeMap();
        int rowCount = 0;
        Iterator rit = rows.keySet().iterator();
        while (rit.hasNext()) {
            Integer rowVal = (Integer)rit.next();
            TreeMap<Integer, TreeSet<String>> sorted = new TreeMap<Integer, TreeSet<String>>();
            holder.put(new Integer(rowCount++), sorted);
            ArrayList perRow = (ArrayList)rows.get(rowVal);
            Iterator prit = perRow.iterator();
            while (prit.hasNext()) {
                String coreID = (String)prit.next();
                Rectangle2D bounds = (Rectangle2D)coreBounds.get(coreID);
                int coreX = (int)UiUtil.forceToGridValueMin(bounds.getMinX(), 10.0) / 10;
                Integer coreXObj = new Integer(coreX);
                TreeSet<String> perPos = (TreeSet<String>)sorted.get(coreXObj);
                if (perPos == null) {
                    perPos = new TreeSet<String>();
                    sorted.put(coreXObj, perPos);
                }
                perPos.add(coreID);
            }
        }
        TreeMap retval = new TreeMap();
        Iterator hit = holder.keySet().iterator();
        while (hit.hasNext()) {
            Integer rowVal = (Integer)hit.next();
            ArrayList perRow = new ArrayList();
            retval.put(rowVal, perRow);
            TreeMap sorted = (TreeMap)holder.get(rowVal);
            Iterator svit = sorted.values().iterator();
            while (svit.hasNext()) {
                TreeSet ppSet = (TreeSet)svit.next();
                perRow.addAll(ppSet);
            }
        }
        return retval;
    }
}

