/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import org.systemsbiology.biotapestry.analysis.CycleFinder;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.analysis.NodeGrouper;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.LayoutCompressionFramework;
import org.systemsbiology.biotapestry.ui.layouts.RowBuilder;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayout;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutData;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParamDialog;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.StackGenerator;
import org.systemsbiology.biotapestry.ui.layouts.StackedBlockLayoutSetupDialog;
import org.systemsbiology.biotapestry.ui.layouts.StackedClusterSeries;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class StackedBlockLayout
implements SpecialtyLayout {
    private static final int TARGS_BY_TIME_ = 0;
    private static final int TARGS_BY_ALPHA_ = 1;
    private static final int TARGS_BY_INPUTS_ = 2;
    private static final int NUM_TARG_TYPES_ = 3;
    private static final String TARGS_BY_TIME_TAG_ = "targByTime";
    private static final String TARGS_BY_ALPHA_TAG_ = "targByAlpha";
    private static final String TARGS_BY_INPUTS_TAG_ = "targByInputs";
    private static final int SRCS_BY_TIME_ = 0;
    private static final int SRCS_BY_SORT_ = 1;
    private static final int SRCS_BY_CURR_POSITION_ = 2;
    private static final int NUM_SRC_TYPES_ = 3;
    private static final String SRCS_BY_TIME_TAG_ = "srcsByTime";
    private static final String SRCS_BY_SORT_TAG_ = "srcsBySort";
    private static final String SRCS_BY_CURR_POSITION_TAG_ = "srcsByCurrPos";
    private static final int COMPRESS_PROVIDE_STRING_SPACE_ = 0;
    private static final int COMPRESS_NORMAL_ = 1;
    private static final int COMPRESS_NARROW_TRACES_ = 2;
    private static final int COMPRESS_FULL_SQUEEZE_ = 3;
    private static final int NUM_COMPRESS_TYPES_ = 4;
    private static final String COMPRESS_NORMAL_TAG_ = "compressNormal";
    private static final String COMPRESS_PROVIDE_STRING_SPACE_TAG_ = "compressStringWide";
    private static final String COMPRESS_NARROW_TRACES_TAG_ = "compressTrace";
    private static final String COMPRESS_FULL_SQUEEZE_TAG_ = "compressFull";
    private SpecialtyLayoutData sld_;
    private StackedClusterSeries stacked_;

    public SpecialtyLayout forkForSubset(SpecialtyLayoutData sld) {
        StackedBlockLayout retval = new StackedBlockLayout();
        retval.sld_ = sld;
        return retval;
    }

    public String getMenuName() {
        return ResourceManager.getManager().getString("command.StackedBlockLayout");
    }

    public char getMenuMnemonic() {
        return ResourceManager.getManager().getChar("command.StackedBlockLayoutMnem");
    }

    public boolean selectionIsValid(Genome genome, String selected) {
        return false;
    }

    public int topologyIsHandled(Genome genome) {
        return 0;
    }

    public String setUpIsOK() {
        StackedBlockLayoutParams wlp = (StackedBlockLayoutParams)this.sld_.param;
        if (wlp.grouping != 2) {
            return null;
        }
        GASCResults clustResults = this.prepClusters();
        if (clustResults == null) {
            return null;
        }
        ArrayList allClusters = new ArrayList(clustResults.srcClusters);
        allClusters.addAll(clustResults.trgClusters);
        HashSet<String> gascIDs = new HashSet<String>();
        int numAC = allClusters.size();
        for (int i = 0; i < numAC; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)allClusters.get(i);
            gascIDs.add(sc.getCoreID());
        }
        StackGenerator sg = new StackGenerator();
        SortedMap clust = sg.buildStackOrder(gascIDs, this.sld_.genome, this.sld_.lo, this.sld_.frc);
        if (clust == null) {
            return ResourceManager.getManager().getString("stackedLayout.ambiguousRows");
        }
        return null;
    }

    private GASCResults prepClusters() {
        Genome baseGenome = this.sld_.genome;
        GenomeItemInstance.DBAndInstanceConsistentComparator cc = new GenomeItemInstance.DBAndInstanceConsistentComparator();
        TreeSet nodeSet = new TreeSet(cc);
        nodeSet.addAll(DataUtil.setFromIterator(this.sld_.subset.getNodeIterator()));
        if (nodeSet.isEmpty()) {
            return null;
        }
        TreeSet<Link> linkSet = new TreeSet<Link>();
        TreeSet orderedLinkSet = new TreeSet(cc);
        orderedLinkSet.addAll(DataUtil.setFromIterator(this.sld_.subset.getLinkageIterator()));
        Iterator lit = orderedLinkSet.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String trg = link.getTarget();
            String src = link.getSource();
            Link cfl = new Link(src, trg);
            linkSet.add(cfl);
            CycleFinder cf = new CycleFinder(nodeSet, linkSet);
            if (!cf.hasACycle()) continue;
            linkSet.remove(cfl);
        }
        GraphSearcher gs = new GraphSearcher(nodeSet, linkSet);
        Map queue = gs.topoSort(false);
        List nodeRanking = gs.topoSortToPartialOrdering(queue);
        Collections.reverse(nodeRanking);
        NodeGrouper ng = new NodeGrouper(this.sld_.subset, nodeRanking);
        Map groups = ng.buildGroups();
        StackedBlockLayoutParams wlp = (StackedBlockLayoutParams)this.sld_.param;
        double traceOffset = 10.0 * (double)wlp.traceMult();
        List ttGroups = ng.findTerminalTargetsByGroups(groups);
        List termXClusters = GeneAndSatelliteCluster.fillTargetClustersByGroups(baseGenome, ttGroups, groups, this.sld_.lo, this.sld_.frc, traceOffset, false, wlp.spaceForText());
        ArrayList sClustList = new ArrayList();
        this.findSources(baseGenome, termXClusters, groups, sClustList, wlp.spaceForText(), traceOffset);
        return new GASCResults(sClustList, termXClusters, queue);
    }

    public void layoutNodes(BTProgressMonitor monitor, Map padChanges, SortedMap existingOrder) throws AsynchExitRequestException {
        SortedMap clustRows;
        this.sld_.results = new SpecialtyInstructions(padChanges);
        this.sld_.results.setOrigNodeBounds(this.sld_.subset.getOrigBounds());
        this.sld_.results.setOrigModuleRect(this.sld_.subset.getOrigModuleBounds());
        this.sld_.gASCs = new ArrayList();
        Map placement = this.sld_.results.nodeLocations;
        Map orientChanges = this.sld_.results.orientChanges;
        Genome baseGenome = this.sld_.genome;
        this.sld_.results.setModuleID(this.sld_.subset.getModuleID());
        StackedBlockLayoutParams wlp = (StackedBlockLayoutParams)this.sld_.param;
        int grouping = wlp.grouping;
        int rowSize = wlp.rowSize;
        double traceOffset = 10.0 * (double)wlp.traceMult();
        Set nodeSet = DataUtil.setFromIterator(this.sld_.subset.getNodeIterator());
        if (nodeSet.isEmpty()) {
            this.sld_.results = null;
            return;
        }
        GASCResults clustResults = this.prepClusters();
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        ArrayList allClusters = new ArrayList(clustResults.srcClusters);
        if (!wlp.targsBelow || grouping == 2) {
            allClusters.addAll(clustResults.trgClusters);
        }
        int numClust = allClusters.size();
        RowBuilder builder = new RowBuilder();
        if (grouping == 2) {
            HashSet<String> gascIDs = new HashSet<String>();
            int numAC = allClusters.size();
            for (int i = 0; i < numAC; ++i) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)allClusters.get(i);
                gascIDs.add(sc.getCoreID());
            }
            StackGenerator sg = new StackGenerator();
            SortedMap clust = sg.buildStackOrder(gascIDs, this.sld_.genome, this.sld_.lo, this.sld_.frc);
            if (clust == null) {
                throw new IllegalStateException();
            }
            clustRows = builder.buildRowsByAssignment(allClusters, clust);
        } else if (grouping == 0) {
            clustRows = builder.assignRowsByTime(allClusters, rowSize, null);
        } else if (grouping == 1) {
            clustRows = builder.buildClusterSeriesBySort(allClusters, clustResults.queue, rowSize, null);
        } else {
            throw new IllegalArgumentException();
        }
        if (wlp.targsBelow && grouping != 2) {
            Integer nextKey;
            int targGroups = wlp.targGrouping;
            Integer n = nextKey = clustRows.isEmpty() ? null : new Integer((Integer)clustRows.lastKey() + 1);
            if (targGroups == 0) {
                clustRows.putAll(builder.assignRowsByTime(clustResults.trgClusters, rowSize, nextKey));
            } else if (targGroups == 1) {
                clustRows.putAll(builder.assignRowsByAlpha(clustResults.trgClusters, baseGenome, rowSize, nextKey));
            } else if (targGroups == 2) {
                clustRows.putAll(builder.assignRowsByInputs(clustResults.trgClusters, baseGenome, rowSize, true, nextKey));
            } else {
                throw new IllegalArgumentException();
            }
            allClusters.addAll(clustResults.trgClusters);
            numClust = allClusters.size();
        }
        int numRows = clustRows.size();
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.stacked_ = new StackedClusterSeries(traceOffset);
        this.stacked_.prep(numRows, clustRows, this.sld_.subset, this.sld_.lo, this.sld_.frc, wlp.traceMult(), existingOrder);
        this.sld_.results.setSourceOrder(this.stacked_.getSourceOrder());
        Point2D center = (Point2D)this.sld_.subset.getPreferredCenter().clone();
        UiUtil.forceToGrid(center, 10.0);
        LayoutCompressionFramework lcf = wlp.compressPerRow() ? new LayoutCompressionFramework() : null;
        this.stacked_.locate(center, placement, baseGenome, this.sld_.lo, this.sld_.frc, lcf);
        this.sld_.results.lcf = lcf;
        this.sld_.results.setPlacedStackBounds(this.stacked_.getStackBounds());
        this.sld_.results.setPlacedStackNodeOnlyBounds(this.stacked_.getStackNodeOnlyBounds());
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)allClusters.get(i);
            tc.calcOrientChanges(baseGenome, this.sld_.lo, orientChanges);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.sld_.gASCs = allClusters;
    }

    public void routeLinks(SpecialtyLayoutEngine.GlobalSLEState gsles, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.sld_.results == null) {
            return;
        }
        this.stacked_.routeLinksForStack(this.sld_.subset, this.sld_.results, this.sld_.lo, this.sld_.frc, gsles, this.stacked_.getStackBounds());
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
    }

    public void assignColors(BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.sld_.results == null) {
            return;
        }
        this.sld_.results.assignColorsAfterLayout = ((StackedBlockLayoutParams)this.sld_.param).assignColors;
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
    }

    public SpecialtyLayoutEngineParamDialog getParameterDialog(JFrame parent, Genome genome, String selectedID, boolean forSubset) {
        return new StackedBlockLayoutSetupDialog(parent, genome, forSubset);
    }

    public String getUndoString() {
        return "undo.stackedBlockLayout";
    }

    public static String mapSrcTypes(int srcType) {
        switch (srcType) {
            case 0: {
                return SRCS_BY_TIME_TAG_;
            }
            case 1: {
                return SRCS_BY_SORT_TAG_;
            }
            case 2: {
                return SRCS_BY_CURR_POSITION_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapSrcTypeTag(String srcTypeTag) {
        if (srcTypeTag.equalsIgnoreCase(SRCS_BY_TIME_TAG_)) {
            return 0;
        }
        if (srcTypeTag.equalsIgnoreCase(SRCS_BY_SORT_TAG_)) {
            return 1;
        }
        if (srcTypeTag.equalsIgnoreCase(SRCS_BY_CURR_POSITION_TAG_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getSrcTypeChoices(boolean isForGlobal) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        boolean allowByTime = tcd.haveData();
        for (int i = 0; i < 3; ++i) {
            if (i == 0 && !allowByTime || i == 2 && isForGlobal) continue;
            retval.add(StackedBlockLayout.srcTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent srcTypeForCombo(int srcType) {
        return new ChoiceContent(ResourceManager.getManager().getString("worksheetLayout." + StackedBlockLayout.mapSrcTypes(srcType)), srcType);
    }

    public static String mapTargTypes(int targType) {
        switch (targType) {
            case 0: {
                return TARGS_BY_TIME_TAG_;
            }
            case 1: {
                return TARGS_BY_ALPHA_TAG_;
            }
            case 2: {
                return TARGS_BY_INPUTS_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapTargTypeTag(String targTypeTag) {
        if (targTypeTag.equalsIgnoreCase(TARGS_BY_TIME_TAG_)) {
            return 0;
        }
        if (targTypeTag.equalsIgnoreCase(TARGS_BY_ALPHA_TAG_)) {
            return 1;
        }
        if (targTypeTag.equalsIgnoreCase(TARGS_BY_INPUTS_TAG_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getTargTypeChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        boolean allowByTime = tcd.haveData();
        for (int i = 0; i < 3; ++i) {
            if (i == 0 && !allowByTime) continue;
            retval.add(StackedBlockLayout.targTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent targTypeForCombo(int targType) {
        return new ChoiceContent(ResourceManager.getManager().getString("worksheetLayout." + StackedBlockLayout.mapTargTypes(targType)), targType);
    }

    public static String mapCompressTypes(int targType) {
        switch (targType) {
            case 0: {
                return COMPRESS_PROVIDE_STRING_SPACE_TAG_;
            }
            case 1: {
                return COMPRESS_NORMAL_TAG_;
            }
            case 2: {
                return COMPRESS_NARROW_TRACES_TAG_;
            }
            case 3: {
                return COMPRESS_FULL_SQUEEZE_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapCompressTypeTag(String targTypeTag) {
        if (targTypeTag.equalsIgnoreCase(COMPRESS_PROVIDE_STRING_SPACE_TAG_)) {
            return 0;
        }
        if (targTypeTag.equalsIgnoreCase(COMPRESS_NORMAL_TAG_)) {
            return 1;
        }
        if (targTypeTag.equalsIgnoreCase(COMPRESS_NARROW_TRACES_TAG_)) {
            return 2;
        }
        if (targTypeTag.equalsIgnoreCase(COMPRESS_FULL_SQUEEZE_TAG_)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getCompressTypeChoices(boolean isForGlobal) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 4; ++i) {
            if (i == 3 && !isForGlobal) continue;
            retval.add(StackedBlockLayout.compressTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent compressTypeForCombo(int compType) {
        return new ChoiceContent(ResourceManager.getManager().getString("stackedLayout." + StackedBlockLayout.mapCompressTypes(compType)), compType);
    }

    public static StackedBlockLayoutParams getDefaultParams(boolean forSubset) {
        StackedBlockLayoutParams retval = new StackedBlockLayoutParams();
        retval.targsBelow = true;
        retval.grouping = 1;
        retval.targGrouping = 2;
        retval.rowSize = 10;
        retval.assignColors = !forSubset;
        retval.overlayOption = 1;
        retval.compressType = 1;
        return retval;
    }

    public static void forceParamsAsNeeded(StackedBlockLayoutParams params) {
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        boolean allowByTime = tcd.haveData();
        if (!allowByTime) {
            if (params.targGrouping == 0) {
                params.targGrouping = 2;
            }
            if (params.grouping == 0) {
                params.grouping = 1;
            }
        }
    }

    public static boolean srcPositioningOverrides(int srcType) {
        return srcType == 2;
    }

    private SortedSet findSources(Genome genome, List termClusters, Map groups, List sClustList, boolean textToo, double traceOffset) {
        HashSet<String> targets = new HashSet<String>();
        int numTerm = termClusters.size();
        for (int i = 0; i < numTerm; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)termClusters.get(i);
            targets.add(clust.getCoreID());
        }
        TreeSet<String> sources = new TreeSet<String>();
        Iterator gvit = groups.values().iterator();
        while (gvit.hasNext()) {
            NodeGrouper.GroupElement groupCore = (NodeGrouper.GroupElement)gvit.next();
            if (targets.contains(groupCore.group)) continue;
            sources.add(groupCore.group);
        }
        Iterator psit = sources.iterator();
        while (psit.hasNext()) {
            String srcID = (String)psit.next();
            GeneAndSatelliteCluster sc = new GeneAndSatelliteCluster(srcID, true, traceOffset, false, textToo);
            sc.prepFromGroupsPhaseOne(genome, groups);
            sClustList.add(sc);
        }
        return sources;
    }

    public static class StackedBlockLayoutParams
    implements SpecialtyLayoutEngineParams,
    Cloneable {
        public boolean targsBelow;
        public int grouping;
        public int targGrouping;
        public int rowSize;
        public boolean assignColors;
        public int overlayOption;
        public int compressType;

        public Object clone() {
            try {
                StackedBlockLayoutParams retval = (StackedBlockLayoutParams)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int getOverlayRelayoutOption() {
            return this.overlayOption;
        }

        public boolean spaceForText() {
            return this.compressType == 0;
        }

        public int traceMult() {
            if (this.compressType == 2 || this.compressType == 3) {
                return 1;
            }
            return 2;
        }

        public boolean compressPerRow() {
            return this.compressType == 3;
        }
    }

    private static class GASCResults {
        List srcClusters;
        List trgClusters;
        Map queue;

        GASCResults(List sClustList, List termXClusters, Map queue) {
            this.srcClusters = sClustList;
            this.trgClusters = termXClusters;
            this.queue = queue;
        }
    }
}

