/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.StackedBlockLayout;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class StackedBlockLayoutSetupPanel
extends JPanel {
    private boolean haveResult_ = false;
    private StackedBlockLayout.StackedBlockLayoutParams params_;
    private JComboBox targTypeCombo_;
    private JLabel targTypeLabel_;
    private JLabel targSizeLabel_;
    private JTextField targSizeField_;
    private JCheckBox doColorsBox_;
    private JComboBox overlayOptionCombo_;
    private JFrame parent_;
    private boolean forSubset_;
    private JComboBox compressTypeCombo_;
    private JComboBox srcTypeCombo_;
    private JCheckBox separateTargetsBox_;
    private boolean isForGlobal_;
    private boolean maxDisable_;
    private boolean partialDisable_;

    public StackedBlockLayoutSetupPanel(JFrame parent, Genome genome, boolean forSubset, StackedBlockLayout.StackedBlockLayoutParams params, boolean forGlobalManager) {
        this.forSubset_ = forSubset;
        this.parent_ = parent;
        this.params_ = (StackedBlockLayout.StackedBlockLayoutParams)params.clone();
        if (this.forSubset_) {
            this.params_.assignColors = false;
        }
        this.isForGlobal_ = forGlobalManager;
        this.maxDisable_ = false;
        this.partialDisable_ = false;
        this.buildParamPanel(genome);
    }

    public SpecialtyLayoutEngineParams getParams() {
        return this.params_;
    }

    public boolean haveResult() {
        return this.haveResult_;
    }

    public void resetDefaults() {
        this.params_ = StackedBlockLayout.getDefaultParams(this.forSubset_);
        this.displayProperties();
    }

    public void displayProperties() {
        StackedBlockLayout.StackedBlockLayoutParams defaultParams = StackedBlockLayout.getDefaultParams(this.forSubset_);
        this.srcTypeCombo_.setSelectedItem(StackedBlockLayout.srcTypeForCombo(this.params_.grouping));
        boolean srcOver = StackedBlockLayout.srcPositioningOverrides(this.params_.grouping);
        boolean trgOver = this.params_.targsBelow;
        boolean useTB = srcOver ? defaultParams.targsBelow : this.params_.targsBelow;
        this.separateTargetsBox_.setSelected(useTB);
        int useRS = srcOver ? defaultParams.rowSize : this.params_.rowSize;
        this.targSizeField_.setText(Integer.toString(useRS));
        int useTG = srcOver || trgOver ? defaultParams.targGrouping : this.params_.targGrouping;
        this.targTypeCombo_.setSelectedItem(StackedBlockLayout.targTypeForCombo(useTG));
        this.compressTypeCombo_.setSelectedItem(StackedBlockLayout.compressTypeForCombo(this.params_.compressType));
        if (this.doColorsBox_ != null) {
            this.doColorsBox_.setSelected(this.params_.assignColors);
        }
        this.overlayOptionCombo_.setSelectedItem(NetOverlayProperties.relayoutForCombo(this.params_.overlayOption));
    }

    public boolean stashResults(boolean ok) {
        if (ok) {
            StackedBlockLayout.StackedBlockLayoutParams defaultParams = StackedBlockLayout.getDefaultParams(this.forSubset_);
            boolean srcOver = StackedBlockLayout.srcPositioningOverrides(this.params_.grouping);
            boolean trgOver = this.params_.targsBelow;
            if (!srcOver) {
                String trgStr = this.targSizeField_.getText();
                boolean badVal = false;
                try {
                    this.params_.rowSize = Integer.parseInt(trgStr);
                    if (this.params_.rowSize <= 0) {
                        badVal = true;
                    }
                }
                catch (NumberFormatException ex) {
                    badVal = true;
                }
                if (badVal) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(this.parent_, rMan.getString("stackedBlockLayout.badSize"), rMan.getString("stackedBlockLayout.badSizeTitle"), 0);
                    this.haveResult_ = false;
                    return false;
                }
            } else {
                this.params_.rowSize = defaultParams.rowSize;
            }
            this.params_.grouping = ((ChoiceContent)this.srcTypeCombo_.getSelectedItem()).val;
            this.params_.targsBelow = srcOver ? defaultParams.targsBelow : this.separateTargetsBox_.isSelected();
            this.params_.targGrouping = srcOver || trgOver ? defaultParams.targGrouping : ((ChoiceContent)this.targTypeCombo_.getSelectedItem()).val;
            this.params_.assignColors = this.forSubset_ ? false : this.doColorsBox_.isSelected();
            this.params_.overlayOption = ((ChoiceContent)this.overlayOptionCombo_.getSelectedItem()).val;
            this.params_.compressType = ((ChoiceContent)this.compressTypeCombo_.getSelectedItem()).val;
            this.haveResult_ = true;
            return true;
        }
        this.params_ = null;
        this.haveResult_ = false;
        return true;
    }

    void handleEnabled() {
        this.separateTargetsBox_.setEnabled(!this.maxDisable_);
        this.targSizeLabel_.setEnabled(!this.maxDisable_);
        this.targSizeField_.setEnabled(!this.maxDisable_);
        this.targTypeCombo_.setEnabled(!this.maxDisable_ && !this.partialDisable_);
        this.targTypeLabel_.setEnabled(!this.maxDisable_ && !this.partialDisable_);
        this.repaint();
    }

    private void buildParamPanel(Genome genome) {
        boolean activate;
        ResourceManager rMan = ResourceManager.getManager();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        int rowNum = 0;
        JLabel srcTypeLabel = new JLabel(rMan.getString("stackedBlockLayout.srcType"));
        Vector srcTypeChoices = StackedBlockLayout.getSrcTypeChoices(this.isForGlobal_);
        this.srcTypeCombo_ = new JComboBox(srcTypeChoices);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)srcTypeLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.srcTypeCombo_, gbc);
        this.srcTypeCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ChoiceContent cc = (ChoiceContent)StackedBlockLayoutSetupPanel.this.srcTypeCombo_.getSelectedItem();
                    StackedBlockLayoutSetupPanel.this.maxDisable_ = StackedBlockLayout.srcPositioningOverrides(cc.val);
                    StackedBlockLayoutSetupPanel.this.handleEnabled();
                    return;
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                    return;
                }
            }
        });
        this.targSizeLabel_ = new JLabel(rMan.getString("stackedBlockLayout.targSize"));
        this.targSizeField_ = new JTextField();
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.targSizeLabel_, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.targSizeField_, gbc);
        this.separateTargetsBox_ = new JCheckBox(rMan.getString("stackedBlockLayout.separateTargets"));
        UiUtil.gbcSet(gbc, 0, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.separateTargetsBox_, gbc);
        this.separateTargetsBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    StackedBlockLayoutSetupPanel.this.partialDisable_ = !StackedBlockLayoutSetupPanel.this.separateTargetsBox_.isSelected();
                    StackedBlockLayoutSetupPanel.this.handleEnabled();
                    return;
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                    return;
                }
            }
        });
        this.targTypeLabel_ = new JLabel(rMan.getString("stackedBlockLayout.targType"));
        Vector targTypeChoices = StackedBlockLayout.getTargTypeChoices();
        this.targTypeCombo_ = new JComboBox(targTypeChoices);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.targTypeLabel_, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.targTypeCombo_, gbc);
        JLabel compressTypeLabel = new JLabel(rMan.getString("stackedBlockLayout.compressType"));
        Vector compressTypeChoices = StackedBlockLayout.getCompressTypeChoices(this.isForGlobal_);
        this.compressTypeCombo_ = new JComboBox(compressTypeChoices);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)compressTypeLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.compressTypeCombo_, gbc);
        JLabel overlayLabel = new JLabel(rMan.getString("stackedBlockLayout.overlayOptions"));
        Vector relayoutChoices = NetOverlayProperties.getRelayoutOptions();
        this.overlayOptionCombo_ = new JComboBox(relayoutChoices);
        boolean bl = activate = genome == null || genome.getNetworkOverlayCount() > 0;
        if (!activate) {
            overlayLabel.setEnabled(false);
            this.overlayOptionCombo_.setEnabled(false);
        }
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)overlayLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.overlayOptionCombo_, gbc);
        if (!this.forSubset_) {
            this.doColorsBox_ = new JCheckBox(rMan.getString("stackedBlockLayout.doColors"));
            UiUtil.gbcSet(gbc, 0, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)this.doColorsBox_, gbc);
        }
    }
}

