/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.layouts.ClusterSeries;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.LayoutCompressionFramework;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.SuperSrcRouterPointSource;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.UiUtil;

public class StackedClusterSeries {
    private ArrayList allSeries_ = new ArrayList();
    private ClusterSeries.GlobalTrackAssignment gta_;
    private HashMap stackedTraceStarts_;
    private HashMap srcToStack_;
    private double traceOffset_;
    private Rectangle stackBounds_;
    private Rectangle stackNodeOnlyBounds_;

    public StackedClusterSeries(double traceOffset) {
        this.traceOffset_ = traceOffset;
    }

    public Rectangle getStackBounds() {
        return this.stackBounds_;
    }

    public Rectangle getStackNodeOnlyBounds() {
        return this.stackNodeOnlyBounds_;
    }

    public SortedMap getSourceOrder() {
        return this.gta_.globalTrackToSrc;
    }

    public void prep(int rows, Map allClusters, GenomeSubset subset, Layout lo, FontRenderContext frc, int traceMult, SortedMap previousSrcToTrack) {
        ClusterSeries nextSeries;
        int i;
        Integer track;
        Genome baseGenome = subset.getBaseGenome();
        int currRow = 0;
        int currCol = 0;
        ClusterSeries currSeries = new ClusterSeries(true, traceMult);
        this.allSeries_.add(currSeries);
        Iterator acvit = allClusters.values().iterator();
        while (acvit.hasNext()) {
            List forRow = (List)acvit.next();
            for (int i2 = 0; i2 < forRow.size(); ++i2) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)forRow.get(i2);
                currSeries.addSourceCluster(currCol++, sc);
            }
            if (!acvit.hasNext()) continue;
            ++currRow;
            currCol = 0;
            currSeries = new ClusterSeries(true, traceMult);
            this.allSeries_.add(currSeries);
        }
        int numSeries = this.allSeries_.size();
        HashMap targets = new HashMap();
        HashMap sources = new HashMap();
        HashMap order = new HashMap();
        for (int i3 = 0; i3 < numSeries; ++i3) {
            ClusterSeries nextSeries2 = (ClusterSeries)this.allSeries_.get(i3);
            nextSeries2.preprocessForAnnotate(subset, targets, sources, order, i3);
        }
        this.srcToStack_ = new HashMap();
        Iterator skit = sources.keySet().iterator();
        while (skit.hasNext()) {
            String linkID = (String)skit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            Point pt = (Point)sources.get(linkID);
            String srcID = link.getSource();
            this.srcToStack_.put(srcID, new Integer(pt.y));
        }
        int fakecount = -1;
        Iterator tkit = targets.keySet().iterator();
        while (tkit.hasNext()) {
            String linkID = (String)tkit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String srcID = link.getSource();
            if (this.srcToStack_.get(srcID) != null) continue;
            this.srcToStack_.put(srcID, new Integer(fakecount--));
        }
        for (int i4 = 0; i4 < numSeries; ++i4) {
            ClusterSeries nextSeries3 = (ClusterSeries)this.allSeries_.get(i4);
            nextSeries3.prepForStackPass1(baseGenome, lo, frc, targets, sources, order, i4);
        }
        this.gta_ = new ClusterSeries.GlobalTrackAssignment();
        int externalTrack = 0;
        HashSet externalSources = new HashSet(subset.externalSourceOnly);
        externalSources.addAll(subset.externalBothSrcTarget);
        TreeSet stillToDo = new TreeSet(externalSources);
        Iterator pstit = previousSrcToTrack.keySet().iterator();
        while (pstit.hasNext()) {
            Integer trackNum = (Integer)pstit.next();
            String checkSrc = (String)previousSrcToTrack.get(trackNum);
            if (!externalSources.contains(checkSrc)) continue;
            track = new Integer(externalTrack++);
            this.gta_.globalSrcToTrack.put(checkSrc, track);
            this.gta_.globalTrackToSrc.put(track, checkSrc);
            ++this.gta_.currMaxTrack;
            stillToDo.remove(checkSrc);
        }
        Iterator stdit = stillToDo.iterator();
        while (stdit.hasNext()) {
            String srcID = (String)stdit.next();
            track = new Integer(externalTrack++);
            this.gta_.globalSrcToTrack.put(srcID, track);
            this.gta_.globalTrackToSrc.put(track, srcID);
            ++this.gta_.currMaxTrack;
        }
        for (i = 0; i < numSeries; ++i) {
            nextSeries = (ClusterSeries)this.allSeries_.get(i);
            nextSeries.calcGlobalTrackNumbers(baseGenome, this.gta_);
        }
        for (i = 0; i < numSeries; ++i) {
            nextSeries = (ClusterSeries)this.allSeries_.get(i);
            nextSeries.prepForStackPass2(baseGenome, lo, frc, targets, sources, order, i, this.gta_);
        }
    }

    public void locate(Point2D center, Map placement, Genome genome, Layout lo, FontRenderContext frc, LayoutCompressionFramework lcf) {
        Point2D gridCenter = (Point2D)center.clone();
        UiUtil.forceToGrid(gridCenter, 10.0);
        Point2D currentPlacement = (Point2D)gridCenter.clone();
        ArrayList<Rectangle> lcfVals = lcf == null ? null : new ArrayList<Rectangle>();
        ArrayList<Map> holdYTraces = new ArrayList<Map>();
        int numSeries = this.allSeries_.size();
        for (int i = 0; i < numSeries; ++i) {
            ClusterSeries nextSeries = (ClusterSeries)this.allSeries_.get(i);
            double traceTop = currentPlacement.getY();
            double traceBottom = nextSeries.setTrackPlacementForStacked(traceTop);
            holdYTraces.add(nextSeries.getDeferredSrcToTraceY());
            currentPlacement.setLocation(currentPlacement.getX(), traceBottom + nextSeries.getTraceOffset());
            double heightOfCluster = nextSeries.getMaximumHeight(genome, lo, frc);
            Point2D rightEnd = nextSeries.locate(currentPlacement, placement, genome, lo, frc, new Double(heightOfCluster));
            currentPlacement.setLocation(currentPlacement.getX(), currentPlacement.getY() + heightOfCluster);
            Rectangle csBounds = new Rectangle((int)currentPlacement.getX(), (int)traceTop, (int)(rightEnd.getX() - currentPlacement.getX()), (int)(heightOfCluster + (traceBottom - traceTop)));
            if (this.stackBounds_ == null) {
                this.stackBounds_ = (Rectangle)csBounds.clone();
            } else if (csBounds != null) {
                Bounds.tweakBounds(this.stackBounds_, csBounds);
            }
            if (lcf == null) continue;
            lcfVals.add(csBounds);
        }
        this.stackNodeOnlyBounds_ = this.getPlacedNodeOnlyBounds(placement, genome, lo, frc);
        double maxRight = Double.NEGATIVE_INFINITY;
        this.stackedTraceStarts_ = new HashMap();
        for (int i = 0; i < numSeries; ++i) {
            HashMap<String, Point2D.Double> tracesPerRow = new HashMap<String, Point2D.Double>();
            this.stackedTraceStarts_.put(new Integer(i), tracesPerRow);
            Map yTraces = (Map)holdYTraces.get(i);
            Iterator ytkit = yTraces.keySet().iterator();
            while (ytkit.hasNext()) {
                String srcID = (String)ytkit.next();
                Double yTrace = (Double)yTraces.get(srcID);
                Integer trackNum = (Integer)this.gta_.globalSrcToTrack.get(srcID);
                Point2D.Double rightForTrack = new Point2D.Double(ClusterSeries.trackXVal(currentPlacement.getX(), trackNum, this.gta_, this.traceOffset_), yTrace);
                tracesPerRow.put(srcID, rightForTrack);
                if (!(((Point2D)rightForTrack).getX() > maxRight)) continue;
                maxRight = ((Point2D)rightForTrack).getX();
            }
        }
        if (lcf != null) {
            lcf.initialize(lcfVals);
        }
    }

    private Rectangle getPlacedNodeOnlyBounds(Map placement, Genome genome, Layout lo, FontRenderContext frc) {
        Rectangle retval = null;
        int numSeries = this.allSeries_.size();
        for (int i = 0; i < numSeries; ++i) {
            ClusterSeries nextSeries = (ClusterSeries)this.allSeries_.get(i);
            Rectangle nsBounds = nextSeries.getNodeOnlyBounds(placement, genome, lo, frc);
            if (retval == null) {
                retval = (Rectangle)nsBounds.clone();
                continue;
            }
            if (nsBounds == null) continue;
            Bounds.tweakBounds(retval, nsBounds);
        }
        return retval;
    }

    private Set sourcesForRow(int sourceRow) {
        HashSet<String> onlySrcs = new HashSet<String>();
        Iterator s2sit = this.srcToStack_.keySet().iterator();
        while (s2sit.hasNext()) {
            String srcID = (String)s2sit.next();
            Integer stackForSrc = (Integer)this.srcToStack_.get(srcID);
            if (stackForSrc != sourceRow) continue;
            onlySrcs.add(srcID);
        }
        return onlySrcs;
    }

    public void routeLinksForStack(GenomeSubset subset, SpecialtyInstructions sp, Layout lo, FontRenderContext frc, SpecialtyLayoutEngine.GlobalSLEState gsles, Rectangle nodeBounds) {
        int i;
        Genome baseGenome = subset.getBaseGenome();
        HashMap<String, SuperSrcRouterPointSource> traceDefs = new HashMap<String, SuperSrcRouterPointSource>();
        Map placement = sp.nodeLocations;
        Map padChanges = sp.padChanges;
        Map extraGrowthChanges = sp.extraGrowthChanges;
        Map lengthChanges = sp.lengthChanges;
        int numSeries = this.allSeries_.size();
        if (this.srcToStack_.isEmpty()) {
            return;
        }
        TreeSet sorted = new TreeSet(this.srcToStack_.values());
        int lowest = (Integer)sorted.first();
        Iterator asit1 = subset.getSourcesHeadedIn().iterator();
        block0: while (asit1.hasNext()) {
            String srcID = (String)asit1.next();
            for (int i2 = 0; i2 < numSeries; ++i2) {
                ClusterSeries nextSeries = (ClusterSeries)this.allSeries_.get(i2);
                if (!nextSeries.hasTrackForSource(srcID)) continue;
                SuperSrcRouterPointSource corners = new SuperSrcRouterPointSource(srcID, true, true);
                traceDefs.put(srcID, corners);
                Integer trackNumObj = (Integer)this.gta_.globalSrcToTrack.get(srcID);
                Double trackVal = new Double(ClusterSeries.trackXVal(nextSeries.getBasePos().getX(), trackNumObj, this.gta_, this.traceOffset_));
                Double trackY = nextSeries.getTrackY(new Integer(nextSeries.getTrackForSource(srcID)));
                corners.initForExternal(trackVal, trackY, this.stackedTraceStarts_, i2);
                continue block0;
            }
        }
        for (i = 0; i < numSeries; ++i) {
            ClusterSeries nextSeries = (ClusterSeries)this.allSeries_.get(i);
            Set sources = this.sourcesForRow(i);
            nextSeries.routeLinksForStackPass1(subset, padChanges, lengthChanges, extraGrowthChanges, lo, frc, placement, sp, traceDefs, i, this.stackedTraceStarts_, this.srcToStack_, sources, this.gta_);
        }
        for (i = lowest; i < numSeries; ++i) {
            Set sources;
            ClusterSeries nextSeries;
            int jstrt;
            int j;
            for (j = jstrt = i < 0 ? 0 : i; j >= 0; --j) {
                nextSeries = (ClusterSeries)this.allSeries_.get(j);
                sources = this.sourcesForRow(i);
                nextSeries.routeLinksForStackPass2(baseGenome, padChanges, lengthChanges, extraGrowthChanges, lo, frc, placement, sp, traceDefs, j, i, sources);
            }
            for (j = jstrt + 1; j < numSeries; ++j) {
                nextSeries = (ClusterSeries)this.allSeries_.get(j);
                sources = this.sourcesForRow(i);
                nextSeries.routeLinksForStackPass2(baseGenome, padChanges, lengthChanges, extraGrowthChanges, lo, frc, placement, sp, traceDefs, j, i, sources);
            }
        }
        Set inSrcs = subset.getSourcesHeadedIn();
        Set outSrcs = subset.getSourcesHeadedOut();
        Iterator isit = inSrcs.iterator();
        while (isit.hasNext()) {
            String srcID = (String)isit.next();
            SuperSrcRouterPointSource inForSrc = (SuperSrcRouterPointSource)traceDefs.get(srcID);
            SpecialtyLayoutLinkData sin = sp.getLinkPointsForSrc(srcID);
            inForSrc.stackedSetupForInboundSources(sin, baseGenome, lo, frc, placement, padChanges, nodeBounds);
        }
        Iterator osit = outSrcs.iterator();
        while (osit.hasNext()) {
            String srcID = (String)osit.next();
            SuperSrcRouterPointSource outForSrc = (SuperSrcRouterPointSource)traceDefs.get(srcID);
            SpecialtyLayoutLinkData sin = sp.getOrStartLinkPointsForSrc(srcID);
            outForSrc.stackedSetupForOutboundSources(sin, baseGenome, lo, frc, placement, padChanges, nodeBounds);
            Set outLinks = subset.getLinksHeadedOutForSource(srcID);
            Iterator goit = outLinks.iterator();
            Point2D fakie = null;
            List usePoint = sin.getLinkList();
            fakie = usePoint.isEmpty() ? ((SpecialtyLayoutLinkData.TrackPos)sin.getInitRoute().get(0)).getPoint() : ((SpecialtyLayoutLinkData.TrackPos)sin.getPositionList((String)usePoint.get(0)).get(0)).getPoint();
            while (goit.hasNext()) {
                String linkID = (String)goit.next();
                if (sin.haveLink(linkID)) {
                    throw new IllegalStateException();
                }
                sin.startNewLink(linkID);
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)fakie.clone()));
            }
        }
        for (int i3 = 0; i3 < numSeries; ++i3) {
            Set sources = this.sourcesForRow(i3);
            Iterator sfrit = sources.iterator();
            while (sfrit.hasNext()) {
                String srcID = (String)sfrit.next();
                SuperSrcRouterPointSource outForSrc = (SuperSrcRouterPointSource)traceDefs.get(srcID);
                SpecialtyLayoutLinkData sin = sp.getOrStartLinkPointsForSrc(srcID);
                outForSrc.establishLeftPoints(sin);
            }
        }
    }
}

