/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.CycleFinder;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.LinkAnnotatedSuper;
import org.systemsbiology.biotapestry.ui.layouts.MetaClusterPointSource;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.SuperSrcRouterPointSource;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.UiUtil;

public class SuperSourceCluster {
    public static final int NEVER_FLIP_ORDER = 0;
    public static final int ALWAYS_FLIP_ORDER = 1;
    public static final int FLIP_IF_SOURCE_IS_FROM_LEFT = 2;
    private static final double RIGHT_X_PAD_PER_COL_ = 60.0;
    private static final double RIGHT_X_PAD_PER_STACKED_COL_ = 40.0;
    private static final double RIGHT_X_PAD_FOR_INTERNAL_TRACES_ = 60.0;
    private TreeMap memberClusters_ = new TreeMap();
    private HashSet inboundLinks_ = new HashSet();
    private HashSet outboundLinks_ = new HashSet();
    private HashSet intraClusterLinks_ = new HashSet();
    private HashSet interClusterLinks_ = new HashSet();
    private ArrayList stackOrder_;
    private ArrayList sourceOrderForPads_;
    private HashMap idToClust_ = new HashMap();
    private HashMap inboundTraces_ = new HashMap();
    private HashMap outboundTraces_ = new HashMap();
    private HashMap internalOrderPerColumn_ = new HashMap();
    private HashMap internalTraces_ = new HashMap();
    private Point2D base_;
    private boolean isPrepped_ = false;
    private GeneAndSatelliteCluster.DropDirectionOracle ddo_;
    private boolean isStacked_;
    private int stackedDirectOffset_;
    private double traceOffset_;

    public SuperSourceCluster(boolean isStacked, double traceOffset) {
        this.stackOrder_ = new ArrayList();
        this.sourceOrderForPads_ = new ArrayList();
        this.isStacked_ = isStacked;
        this.traceOffset_ = traceOffset;
    }

    public Rectangle getNodeOnlyBounds(Map placement, Genome genome, Layout lo, FontRenderContext frc) {
        Rectangle retval = null;
        int numStack = this.stackOrder_.size();
        for (int i = 0; i < numStack; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            Rectangle nsBounds = sc.getNodeOnlyBounds(placement, genome, lo, frc);
            if (retval == null) {
                retval = (Rectangle)nsBounds.clone();
                continue;
            }
            if (nsBounds == null) continue;
            Bounds.tweakBounds(retval, nsBounds);
        }
        return retval;
    }

    public void addSourceCluster(GeneAndSatelliteCluster newClust) {
        ArrayList currClust;
        if (this.isPrepped_) {
            throw new IllegalStateException();
        }
        if (this.memberClusters_.isEmpty()) {
            currClust = new ArrayList();
            this.memberClusters_.put(new Integer(0), currClust);
        } else {
            currClust = (ArrayList)this.memberClusters_.get(this.memberClusters_.firstKey());
        }
        currClust.add(newClust);
    }

    public void prep(GenomeSubset subset) {
        if (this.isPrepped_ || this.memberClusters_.isEmpty()) {
            throw new IllegalStateException();
        }
        Genome baseGenome = subset.getBaseGenome();
        HashSet<String> clustsForTopoSort = new HashSet<String>();
        HashMap<String, String> srcClusts = new HashMap<String, String>();
        HashMap<String, String> trgClusts = new HashMap<String, String>();
        HashSet<String> interFeeds = new HashSet<String>();
        ArrayList currClust = (ArrayList)this.memberClusters_.get(this.memberClusters_.firstKey());
        int numCC = currClust.size();
        for (int i = 0; i < numCC; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)currClust.get(i);
            this.idToClust_.put(sc.getCoreID(), sc);
            clustsForTopoSort.add(sc.getCoreID());
            Iterator lit = subset.getLinkageSuperSetIterator();
            while (lit.hasNext()) {
                String linkID = (String)lit.next();
                Linkage link = baseGenome.getLinkage(linkID);
                boolean isIn = sc.linkIsInbound(link);
                boolean isOut = sc.linkIsOutbound(link);
                if (isIn || isOut) {
                    if (isIn) {
                        this.inboundLinks_.add(linkID);
                        trgClusts.put(linkID, sc.getCoreID());
                    }
                    if (isOut) {
                        this.outboundLinks_.add(linkID);
                        srcClusts.put(linkID, sc.getCoreID());
                    }
                    if (!isIn || !isOut) continue;
                    interFeeds.add(linkID);
                    continue;
                }
                if (!sc.linkIsInternal(link)) continue;
                this.intraClusterLinks_.add(linkID);
            }
        }
        this.interClusterLinks_.addAll(this.inboundLinks_);
        this.interClusterLinks_.retainAll(this.outboundLinks_);
        this.inboundLinks_.removeAll(this.interClusterLinks_);
        this.outboundLinks_.removeAll(this.interClusterLinks_);
        HashSet<Link> links = new HashSet<Link>();
        Iterator icit = this.interClusterLinks_.iterator();
        while (icit.hasNext()) {
            String linkID = (String)icit.next();
            String src = (String)srcClusts.get(linkID);
            String trg = (String)trgClusts.get(linkID);
            Link cfl = new Link(src, trg);
            links.add(cfl);
            CycleFinder cf = new CycleFinder(clustsForTopoSort, links);
            if (!cf.hasACycle()) continue;
            links.remove(cfl);
            interFeeds.add(linkID);
        }
        this.interClusterLinks_.removeAll(interFeeds);
        this.inboundLinks_.addAll(interFeeds);
        this.outboundLinks_.addAll(interFeeds);
        GraphSearcher searcher = new GraphSearcher(clustsForTopoSort, links);
        Map topoSort = searcher.topoSort(false);
        TreeMap invert = new TreeMap();
        searcher.invertTopoSort(topoSort, invert);
        this.memberClusters_.clear();
        Iterator ivit = invert.keySet().iterator();
        while (ivit.hasNext()) {
            Integer key = (Integer)ivit.next();
            List perCol = (List)invert.get(key);
            ArrayList clustsForCol = new ArrayList();
            this.memberClusters_.put(key, clustsForCol);
            int numPer = perCol.size();
            for (int i = 0; i < numPer; ++i) {
                String scID = (String)perCol.get(i);
                clustsForCol.add(this.idToClust_.get(scID));
            }
        }
        TreeMap<String, ArrayList<GeneAndSatelliteCluster>> nameOrder = new TreeMap<String, ArrayList<GeneAndSatelliteCluster>>(String.CASE_INSENSITIVE_ORDER);
        Iterator mcit = this.memberClusters_.keySet().iterator();
        while (mcit.hasNext()) {
            Integer mcKey = (Integer)mcit.next();
            ArrayList clustList = (ArrayList)this.memberClusters_.get(mcKey);
            int clNum = clustList.size();
            for (int i = 0; i < clNum; ++i) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)clustList.get(i);
                String sid = sc.getCoreID();
                Node srcNode = baseGenome.getNode(sid);
                String srcName = srcNode.getName();
                ArrayList<GeneAndSatelliteCluster> srcs = (ArrayList<GeneAndSatelliteCluster>)nameOrder.get(srcName);
                if (srcs == null) {
                    srcs = new ArrayList<GeneAndSatelliteCluster>();
                    nameOrder.put(srcName, srcs);
                }
                srcs.add(sc);
            }
            Iterator noit = nameOrder.keySet().iterator();
            while (noit.hasNext()) {
                String noKey = (String)noit.next();
                ArrayList srcs = (ArrayList)nameOrder.get(noKey);
                int numSrc = srcs.size();
                for (int i = 0; i < numSrc; ++i) {
                    GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)srcs.get(i);
                    this.stackOrder_.add(sc);
                }
            }
            nameOrder.clear();
        }
        this.isPrepped_ = true;
    }

    public boolean linkIsInbound(Linkage link) {
        if (!this.isPrepped_) {
            throw new IllegalStateException();
        }
        String linkID = link.getID();
        return this.inboundLinks_.contains(linkID);
    }

    public boolean linkIsOutbound(Linkage link) {
        if (!this.isPrepped_) {
            throw new IllegalStateException();
        }
        String linkID = link.getID();
        return this.outboundLinks_.contains(linkID);
    }

    public int getOutboundLinkOrder(Linkage link) {
        if (!this.isPrepped_) {
            throw new IllegalStateException();
        }
        int count = 0;
        int numStack = this.stackOrder_.size();
        for (int i = 0; i < numStack; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            if (sc.linkIsOutbound(link)) {
                return count + sc.getOutboundLinkOrder(link);
            }
            count += sc.getOutboundLinkOrderMax();
        }
        throw new IllegalArgumentException();
    }

    public int getOutboundLinkOrderMax() {
        if (!this.isPrepped_) {
            throw new IllegalStateException();
        }
        int count = 0;
        int numStack = this.stackOrder_.size();
        for (int i = 0; i < numStack; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            count += sc.getOutboundLinkOrderMax();
        }
        return count;
    }

    public boolean linkIsInternal(Linkage link) {
        if (!this.isPrepped_) {
            throw new IllegalStateException();
        }
        String linkID = link.getID();
        return this.intraClusterLinks_.contains(linkID) || this.interClusterLinks_.contains(linkID);
    }

    public void orderInboundTraces(Genome genome, boolean baseAtTop, LinkAnnotatedSuper las, SortedMap topFeeds, SortedMap bottomFeeds, Map seriesTraces, LinkAnnotatedSuper prevLas) {
        String srcID;
        int useTrace;
        int currTrace = 0;
        HashSet<String> bottomSrcs = new HashSet<String>();
        if (!this.isStacked_) {
            Iterator bit = bottomFeeds.keySet().iterator();
            while (bit.hasNext()) {
                Integer bVal = (Integer)bit.next();
                String srcID2 = (String)bottomFeeds.get(bVal);
                if (!this.isASource(srcID2, genome, las.backwardInputs)) continue;
                this.inboundTraces_.put(srcID2, new Integer(currTrace--));
                bottomSrcs.add(srcID2);
            }
            Set tfk = topFeeds.keySet();
            ArrayList revList = new ArrayList(tfk);
            Collections.reverse(revList);
            Iterator tfit = revList.iterator();
            while (tfit.hasNext()) {
                Integer tVal = (Integer)tfit.next();
                String srcID3 = (String)topFeeds.get(tVal);
                if (!this.isASource(srcID3, genome, las.backwardInputs)) continue;
                this.inboundTraces_.put(srcID3, new Integer(currTrace--));
            }
        }
        TreeMap immedFeeds = new TreeMap(Collections.reverseOrder());
        int firstTrace = Integer.MAX_VALUE;
        if (prevLas != null) {
            if (this.isStacked_) {
                throw new IllegalArgumentException();
            }
            Map prevOutTraces = prevLas.ssc.outTraceOrder(genome, !baseAtTop, prevLas);
            TreeSet forMax = new TreeSet(prevOutTraces.values());
            firstTrace = forMax.isEmpty() ? Integer.MAX_VALUE : (Integer)forMax.last();
            Iterator iit = las.immediateInputs.iterator();
            while (iit.hasNext()) {
                String linkID = (String)iit.next();
                Linkage link = genome.getLinkage(linkID);
                String srcID4 = link.getSource();
                Integer prevOutTrace = (Integer)prevOutTraces.get(srcID4);
                immedFeeds.put(prevOutTrace, srcID4);
            }
        }
        int minUseTrace = useTrace = currTrace;
        Iterator ikit = immedFeeds.keySet().iterator();
        while (ikit.hasNext()) {
            Integer iVal = (Integer)ikit.next();
            String srcID5 = (String)immedFeeds.get(iVal);
            int immedTrace = iVal;
            useTrace = currTrace - Math.abs(firstTrace - immedTrace);
            this.inboundTraces_.put(srcID5, new Integer(useTrace--));
            if (useTrace >= minUseTrace) continue;
            minUseTrace = useTrace;
        }
        currTrace = minUseTrace;
        TreeMap past = new TreeMap();
        this.addToPastForSet(las.pastInputs, genome, seriesTraces, past);
        this.addToPastForSet(las.afterRowSources, genome, seriesTraces, past);
        this.addToPastForSet(las.beforeRowSources, genome, seriesTraces, past);
        if (this.isStacked_) {
            this.addToPastForSet(las.immediateInputs, genome, seriesTraces, past);
            this.addToPastForSet(las.backwardInputs, genome, seriesTraces, past);
        }
        if (!this.isStacked_) {
            Iterator pvit = past.values().iterator();
            while (pvit.hasNext()) {
                String srcID6 = (String)pvit.next();
                this.inboundTraces_.put(srcID6, new Integer(currTrace--));
            }
        } else {
            GeneAndSatelliteCluster gas = (GeneAndSatelliteCluster)this.stackOrder_.get(0);
            Set needForFan = gas.srcsToFanin(genome);
            Set needForCore = gas.srcsToCore(genome);
            Iterator pvit = past.values().iterator();
            HashMap<String, Integer> bogoOther = new HashMap<String, Integer>();
            HashMap<String, Integer> bogoIn = new HashMap<String, Integer>();
            int bogoOtherCount = 0;
            int bogoInCount = 0;
            while (pvit.hasNext()) {
                String srcID7 = (String)pvit.next();
                if (gas.useLeftDropsForStackedCore() && needForCore.contains(srcID7) || needForFan.contains(srcID7)) {
                    bogoIn.put(srcID7, new Integer(bogoInCount--));
                    continue;
                }
                bogoOther.put(srcID7, new Integer(bogoOtherCount--));
            }
            this.stackedDirectOffset_ = currTrace - bogoInCount;
            Iterator biit = bogoIn.keySet().iterator();
            while (biit.hasNext()) {
                String srcID8 = (String)biit.next();
                Integer bogoInVal = (Integer)bogoIn.get(srcID8);
                this.inboundTraces_.put(srcID8, new Integer(bogoInVal - bogoInCount));
            }
            Iterator bbit = bogoOther.keySet().iterator();
            while (bbit.hasNext()) {
                srcID = (String)bbit.next();
                Integer bogoOtherVal = (Integer)bogoOther.get(srcID);
                this.inboundTraces_.put(srcID, new Integer(this.stackedDirectOffset_ + (bogoOtherVal - bogoOtherCount)));
            }
            currTrace -= bogoInCount + bogoOtherCount;
        }
        TreeMap<Integer, String> invertMap = new TreeMap<Integer, String>();
        TreeMap<Integer, String> fromBelowInvertMap = new TreeMap<Integer, String>();
        Iterator itit = this.inboundTraces_.keySet().iterator();
        while (itit.hasNext()) {
            String srcID9 = (String)itit.next();
            Integer iVal = (Integer)this.inboundTraces_.get(srcID9);
            if (baseAtTop && bottomSrcs.contains(srcID9)) {
                fromBelowInvertMap.put(new Integer(-iVal.intValue()), srcID9);
                continue;
            }
            invertMap.put(iVal, srcID9);
        }
        ArrayList internalSrcOrder = new ArrayList();
        ArrayList mcks = new ArrayList(this.memberClusters_.keySet());
        if (!baseAtTop) {
            Collections.reverse(mcks);
        }
        Iterator mcit = mcks.iterator();
        while (mcit.hasNext()) {
            Integer mcKey = (Integer)mcit.next();
            Map perCol = (Map)this.internalOrderPerColumn_.get(mcKey);
            TreeMap<Integer, String> sortByOrder = new TreeMap<Integer, String>();
            Iterator pcit = perCol.keySet().iterator();
            while (pcit.hasNext()) {
                srcID = (String)pcit.next();
                Integer assign = (Integer)perCol.get(srcID);
                sortByOrder.put(assign, srcID);
            }
            ArrayList ioByCol = new ArrayList(sortByOrder.values());
            if (baseAtTop) {
                Collections.reverse(ioByCol);
            }
            internalSrcOrder.addAll(ioByCol);
        }
        HashSet imVals = new HashSet(invertMap.values());
        HashSet fbImVals = new HashSet(fromBelowInvertMap.values());
        ArrayList<String> allOuts = new ArrayList<String>();
        int outNum = internalSrcOrder.size();
        for (int j = 0; j < outNum; ++j) {
            String src = (String)internalSrcOrder.get(j);
            if (imVals.contains(src) || fbImVals.contains(src)) continue;
            allOuts.add(src);
        }
        this.sourceOrderForPads_ = new ArrayList();
        if (baseAtTop) {
            this.sourceOrderForPads_.addAll(fromBelowInvertMap.values());
            this.sourceOrderForPads_.addAll(invertMap.values());
            this.sourceOrderForPads_.addAll(allOuts);
        } else {
            this.sourceOrderForPads_.addAll(allOuts);
            this.sourceOrderForPads_.addAll(invertMap.values());
        }
    }

    public void addToPastForSet(Set inputSet, Genome genome, Map seriesTraces, SortedMap past) {
        Iterator pait = inputSet.iterator();
        while (pait.hasNext()) {
            String linkID = (String)pait.next();
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            Integer seriesTrace = (Integer)seriesTraces.get(srcID);
            if (seriesTrace == null) {
                seriesTrace = new Integer(-25);
            }
            past.put(seriesTrace, srcID);
        }
    }

    public Map outTraceOrder(Genome genome, boolean baseAtTop, LinkAnnotatedSuper las) {
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        ArrayList outSrcs = new ArrayList();
        int numStack = this.stackOrder_.size();
        for (int i = 0; i < numStack; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            outSrcs.addAll(sc.getOutboundSourceOrder());
        }
        if (!baseAtTop) {
            Collections.reverse(outSrcs);
        }
        int numSrc = outSrcs.size();
        int ocount = 0;
        for (int i = 0; i < numSrc; ++i) {
            String outSrc = (String)outSrcs.get(i);
            if (!this.needsOutboundDrop(outSrc, genome, las)) continue;
            retval.put(outSrc, new Integer(ocount++));
        }
        return retval;
    }

    public void orderFeedbackTraces(Genome genome, boolean baseAtTop, SortedMap upperFeeds, SortedMap lowerFeeds, LinkAnnotatedSuper las) {
        SortedMap dest;
        int feedKey;
        int sign;
        if (!this.isPrepped_) {
            throw new IllegalStateException();
        }
        int feedCount = 0;
        TreeMap<Integer, String> sortedFeeds = new TreeMap<Integer, String>();
        Iterator mcit = this.memberClusters_.keySet().iterator();
        while (mcit.hasNext()) {
            Integer mcKey = (Integer)mcit.next();
            ArrayList clustPerColumn = (ArrayList)this.memberClusters_.get(mcKey);
            ArrayList outSrcs = new ArrayList();
            List ordered = this.orderForColumn(this.stackOrder_, clustPerColumn);
            int num = ordered.size();
            for (int i = 0; i < num; ++i) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)ordered.get(i);
                outSrcs.addAll(sc.getOutboundSourceOrder());
            }
            int numSrc = outSrcs.size();
            HashMap<String, Integer> perCol = new HashMap<String, Integer>();
            this.internalOrderPerColumn_.put(mcKey, perCol);
            int icount = 0;
            for (int i = 0; i < numSrc; ++i) {
                String outSrc = (String)outSrcs.get(i);
                if (this.needsInterclusterDrop(outSrc, genome, las)) {
                    perCol.put(outSrc, new Integer(icount++));
                }
                if (this.isASource(outSrc, genome, las.backwardOutputs)) {
                    sortedFeeds.put(new Integer(feedCount++), outSrc);
                }
                if (this.isASource(outSrc, genome, las.beforeRowTargets)) {
                    sortedFeeds.put(new Integer(feedCount++), outSrc);
                }
                if (!this.isASource(outSrc, genome, las.afterRowTargets)) continue;
                sortedFeeds.put(new Integer(feedCount++), outSrc);
            }
        }
        if (baseAtTop) {
            sign = 1;
            feedKey = lowerFeeds.isEmpty() ? 0 : (Integer)lowerFeeds.lastKey();
            dest = lowerFeeds;
        } else {
            sign = -1;
            feedKey = upperFeeds.isEmpty() ? 0 : (Integer)upperFeeds.firstKey();
            dest = upperFeeds;
        }
        Iterator sfit = sortedFeeds.keySet().iterator();
        while (sfit.hasNext()) {
            Integer feed = (Integer)sfit.next();
            String feedSrc = (String)sortedFeeds.get(feed);
            dest.put(new Integer(feedKey += sign), feedSrc);
        }
    }

    private List orderForColumn(List allOrdered, List clustPerColumn) {
        ArrayList<GeneAndSatelliteCluster> retval = new ArrayList<GeneAndSatelliteCluster>();
        int numCpc = clustPerColumn.size();
        int numOrd = allOrdered.size();
        block0: for (int i = 0; i < numOrd; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)allOrdered.get(i);
            String srcID = sc.getCoreID();
            for (int j = 0; j < numCpc; ++j) {
                GeneAndSatelliteCluster sct = (GeneAndSatelliteCluster)clustPerColumn.get(j);
                if (!sct.getCoreID().equals(srcID)) continue;
                retval.add(sc);
                continue block0;
            }
        }
        return retval;
    }

    public double getHeight(Genome genome, Layout lo, FontRenderContext frc, double traceDistance) {
        int numOrd = this.stackOrder_.size();
        double rowY = 0.0;
        for (int i = 0; i < numOrd; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            GeneAndSatelliteCluster.ClusterDims oh = sc.getClusterDims(genome, lo, frc);
            rowY += oh.getFullHeightIncrement();
        }
        return rowY;
    }

    public Point2D locate(Point2D basePos, Map positions, Genome genome, Layout lo, FontRenderContext frc, boolean baseAtTop, Map isOnTop, double traceDistance, LinkAnnotatedSuper las, Map lastOutboundTraces, LinkAnnotatedSuper nextLas, double minSeparation, Double matchMax) {
        MinXAndLeftShift mals;
        if (!this.isPrepped_) {
            throw new IllegalStateException();
        }
        double colX = this.isStacked_ ? this.locateStackedLeftEdge(basePos, traceDistance) : this.locateLeftEdge(basePos, traceDistance, lastOutboundTraces, isOnTop, baseAtTop, las);
        HashMap<String, Integer> colPerSource = new HashMap<String, Integer>();
        HashMap<Integer, Double> xPosPerCol = new HashMap<Integer, Double>();
        HashMap<String, Double> prelimInternalTraces = new HashMap<String, Double>();
        int colCount = 0;
        Iterator mcit = this.memberClusters_.keySet().iterator();
        while (mcit.hasNext()) {
            Integer mcKey = (Integer)mcit.next();
            ArrayList clustPerColumn = (ArrayList)this.memberClusters_.get(mcKey);
            Integer colObj = new Integer(colCount++);
            ArrayList outSrcs = new ArrayList();
            double maxWidth = 0.0;
            List ordered = this.orderForColumn(this.stackOrder_, clustPerColumn);
            int num = ordered.size();
            for (int i = 0; i < num; ++i) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)ordered.get(i);
                colPerSource.put(sc.getCoreID(), colObj);
                double width = sc.getClusterDims((Genome)genome, (Layout)lo, (FontRenderContext)frc).width;
                if (width > maxWidth) {
                    maxWidth = width;
                }
                outSrcs.addAll(sc.getOutboundSourceOrder());
            }
            xPosPerCol.put(colObj, new Double(colX));
            colX += maxWidth + (this.isStacked_ ? 40.0 : 60.0);
            boolean stackedNeedsInterDrop = false;
            Map perCol = (Map)this.internalOrderPerColumn_.get(mcKey);
            int maxAssign = 0;
            Iterator pcit = perCol.keySet().iterator();
            while (pcit.hasNext()) {
                String srcID = (String)pcit.next();
                boolean bl = stackedNeedsInterDrop = stackedNeedsInterDrop || this.justIntraClusterDrop(srcID, genome, las);
                Integer assign = (Integer)perCol.get(srcID);
                int assignVal = assign;
                if (assignVal <= maxAssign) continue;
                maxAssign = assignVal;
            }
            if (this.isStacked_ && !stackedNeedsInterDrop) continue;
            double oldColX = colX;
            double rightColX = colX + (double)maxAssign * traceDistance;
            colX += (double)maxAssign * traceDistance + (this.isStacked_ ? 0.0 : 60.0);
            pcit = perCol.keySet().iterator();
            while (pcit.hasNext()) {
                String srcID = (String)pcit.next();
                Integer assign = (Integer)perCol.get(srcID);
                double traceX = baseAtTop ? oldColX + assign.doubleValue() * traceDistance : rightColX - assign.doubleValue() * traceDistance;
                prelimInternalTraces.put(srcID, new Double(traceX));
            }
        }
        int numOrd = this.stackOrder_.size();
        double totalHeight = 0.0;
        HashMap<String, Double> yPosPerRow = new HashMap<String, Double>();
        HashMap<String, Double> extraBumps = new HashMap<String, Double>();
        Double zeroD = new Double(0.0);
        for (int i = 0; i < numOrd; ++i) {
            Double extraBump;
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            String scCoreID = sc.getCoreID();
            GeneAndSatelliteCluster.ClusterDims oh = sc.getClusterDims(genome, lo, frc);
            double nextHeight = oh.getFullHeightIncrement();
            if (matchMax != null && matchMax > nextHeight) {
                totalHeight += matchMax.doubleValue();
                extraBump = new Double(matchMax - nextHeight);
            } else {
                totalHeight += nextHeight;
                extraBump = zeroD;
            }
            yPosPerRow.put(scCoreID, new Double(totalHeight));
            extraBumps.put(scCoreID, extraBump);
        }
        double baseY = this.base_.getY();
        double retval = !baseAtTop ? (baseY -= totalHeight) : baseY + totalHeight;
        double nextYPos = 0.0;
        HashMap<String, Point2D.Double> relativePos = new HashMap<String, Point2D.Double>();
        for (int i = 0; i < numOrd; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            String scCoreID = sc.getCoreID();
            Integer colAssignObj = (Integer)colPerSource.get(scCoreID);
            double xPos = (Double)xPosPerCol.get(colAssignObj);
            double extraBump = (Double)extraBumps.get(scCoreID);
            Point2D.Double pos = new Point2D.Double(xPos, baseY + nextYPos + extraBump);
            relativePos.put(scCoreID, pos);
            nextYPos = (Double)yPosPerRow.get(scCoreID);
        }
        Map outTraces = this.outTraceOrder(genome, baseAtTop, las);
        HashMap<String, Double> prelimTraces = new HashMap<String, Double>();
        double maxX = colX;
        Iterator otit = outTraces.keySet().iterator();
        while (otit.hasNext()) {
            String srcID = (String)otit.next();
            Integer count = (Integer)outTraces.get(srcID);
            double traceX = colX + count.doubleValue() * traceDistance;
            prelimTraces.put(srcID, new Double(traceX));
            if (!(traceX > maxX)) continue;
            maxX = traceX;
        }
        double offsetX = 0.0;
        if (nextLas != null && (mals = nextLas.ssc.minXAndShiftNeeded(traceDistance, prelimTraces, isOnTop, !baseAtTop, nextLas)) != null && mals.minX < basePos.getX() + minSeparation) {
            offsetX = basePos.getX() - mals.minX + traceDistance + minSeparation;
        }
        Iterator rpit = relativePos.keySet().iterator();
        while (rpit.hasNext()) {
            String scCoreID = (String)rpit.next();
            Point2D sscPos = (Point2D)relativePos.get(scCoreID);
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.idToClust_.get(scCoreID);
            Point2D.Double finalPos = new Point2D.Double(sscPos.getX() + offsetX, sscPos.getY());
            sc.locateAsSource(finalPos, positions, genome, lo, frc);
        }
        Iterator ptit = prelimTraces.keySet().iterator();
        while (ptit.hasNext()) {
            String outSrc = (String)ptit.next();
            Double traceXObj = (Double)prelimTraces.get(outSrc);
            Double finalTraceX = new Double(traceXObj + offsetX);
            this.outboundTraces_.put(outSrc, finalTraceX);
        }
        Iterator pitit = prelimInternalTraces.keySet().iterator();
        while (pitit.hasNext()) {
            String srcID = (String)pitit.next();
            Double traceXObj = (Double)prelimInternalTraces.get(srcID);
            Double finalTraceX = new Double(traceXObj + offsetX);
            this.internalTraces_.put(srcID, finalTraceX);
        }
        return new Point2D.Double(maxX += offsetX, retval);
    }

    public Map getOutboundTraces() {
        return this.outboundTraces_;
    }

    public int getInboundLinkCount() {
        return this.inboundLinks_.size();
    }

    public Set getAllSources() {
        HashSet retval = new HashSet();
        int numStack = this.stackOrder_.size();
        for (int i = 0; i < numStack; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            retval.addAll(sc.getAllSources());
        }
        return retval;
    }

    public Set getAllInputs() {
        HashSet retval = new HashSet();
        int numStack = this.stackOrder_.size();
        for (int i = 0; i < numStack; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            retval.addAll(sc.getInputs());
        }
        return retval;
    }

    public boolean isASource(String srcID, Genome genome, Set linkIDs) {
        Iterator icit = linkIDs.iterator();
        while (icit.hasNext()) {
            String linkID = (String)icit.next();
            Linkage link = genome.getLinkage(linkID);
            String chkSrcID = link.getSource();
            if (!chkSrcID.equals(srcID)) continue;
            return true;
        }
        return false;
    }

    public boolean justIntraClusterDrop(String srcID, Genome genome, LinkAnnotatedSuper las) {
        if (this.isASource(srcID, genome, las.afterRowTargets)) {
            return false;
        }
        if (this.isASource(srcID, genome, las.beforeRowTargets)) {
            return false;
        }
        if (this.isASource(srcID, genome, las.backwardOutputs)) {
            return true;
        }
        return this.isASource(srcID, genome, this.intraClusterLinks_);
    }

    public boolean needsInterclusterDrop(String srcID, Genome genome, LinkAnnotatedSuper las) {
        if (this.isASource(srcID, genome, this.interClusterLinks_)) {
            return true;
        }
        if (this.isASource(srcID, genome, las.backwardOutputs)) {
            return true;
        }
        if (this.isASource(srcID, genome, las.afterRowTargets)) {
            return true;
        }
        return this.isASource(srcID, genome, las.beforeRowTargets);
    }

    public boolean needsOutboundDrop(String srcID, Genome genome, LinkAnnotatedSuper las) {
        if (this.isASource(srcID, genome, las.forwardOutputs)) {
            return true;
        }
        if (this.isASource(srcID, genome, las.immediateOutputs)) {
            return true;
        }
        if (this.isASource(srcID, genome, las.afterRowTargets)) {
            return true;
        }
        return this.isASource(srcID, genome, las.beforeRowTargets);
    }

    public void startOutboundLinks(Genome genome, Map padChanges, Layout lo, FontRenderContext frc, Map placement, SpecialtyInstructions si, Map trackToY, Map srcToTrack, Map srcToFeedbackY, boolean baseAtTop, Map traceDefs, LinkAnnotatedSuper las, boolean forStackedClusters) {
        HashSet seenSrcs = new HashSet();
        int numOrd = this.stackOrder_.size();
        for (int i = 0; i < numOrd; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            Map sinMap = sc.routeInternalLinks(genome, padChanges, lo, frc, placement);
            Iterator smit = sinMap.keySet().iterator();
            while (smit.hasNext()) {
                String srcID = (String)smit.next();
                SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)sinMap.get(srcID);
                if (si.hasLinkPointsForSrc(srcID)) {
                    SpecialtyLayoutLinkData sinlp = si.getLinkPointsForSrc(srcID);
                    sinlp.merge(sin);
                    continue;
                }
                si.setLinkPointsForSrc(srcID, sin);
            }
            Iterator asi = sc.getAllSourceIterator();
            while (asi.hasNext()) {
                seenSrcs.add(asi.next());
            }
            sc.routeOutboundLinks(genome, padChanges, lo, frc, placement, this.internalTraces_, this.outboundTraces_, traceDefs, baseAtTop, srcToTrack, trackToY, srcToFeedbackY, forStackedClusters);
        }
        Map perSrc = this.targetsPerSourceInStackOrder(genome);
        Iterator psit = perSrc.keySet().iterator();
        while (psit.hasNext()) {
            String srcID = (String)psit.next();
            if (!seenSrcs.contains(srcID)) continue;
            SuperSrcRouterPointSource outForSrc = (SuperSrcRouterPointSource)traceDefs.get(srcID);
            SpecialtyLayoutLinkData sin = si.getOrStartLinkPointsForSrc(srcID);
            MetaClusterPointSource lps = new MetaClusterPointSource(srcID, outForSrc, 2);
            lps.setIntraParams(this.traceOffset_);
            List trgs = (List)perSrc.get(srcID);
            int numT = trgs.size();
            for (int i = 0; i < numT; ++i) {
                String scCoreID = (String)trgs.get(i);
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.idToClust_.get(scCoreID);
                boolean topGASC = (GeneAndSatelliteCluster)this.stackOrder_.get(0) == sc;
                sc.inboundLinkRouting(srcID, genome, lo, frc, placement, padChanges, sin, lps, topGASC);
            }
        }
    }

    public Map targetsPerSourceInStackOrder(Genome genome) {
        TreeMap<Integer, String> tm;
        String srcID;
        HashMap prepMap = new HashMap();
        int numOrd = this.stackOrder_.size();
        Iterator icit = this.interClusterLinks_.iterator();
        block0: while (icit.hasNext()) {
            String linkID = (String)icit.next();
            Linkage link = genome.getLinkage(linkID);
            srcID = link.getSource();
            tm = (TreeMap<Integer, String>)prepMap.get(srcID);
            if (tm == null) {
                tm = new TreeMap<Integer, String>();
                prepMap.put(srcID, tm);
            }
            boolean seenSrc = false;
            for (int i = 0; i < numOrd; ++i) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
                if (!seenSrc) {
                    if (!sc.linkIsOutbound(link)) continue;
                    seenSrc = true;
                    continue;
                }
                String clustSrcID = sc.getCoreID();
                if (!sc.linkIsInbound(link)) continue;
                tm.put(new Integer(i), clustSrcID);
                continue block0;
            }
        }
        HashMap retval = new HashMap();
        Iterator pmkit = prepMap.keySet().iterator();
        while (pmkit.hasNext()) {
            srcID = (String)pmkit.next();
            tm = (TreeMap)prepMap.get(srcID);
            ArrayList trgList = new ArrayList(tm.values());
            retval.put(srcID, trgList);
        }
        return retval;
    }

    public void finishClusterPrep(Genome genome, Layout lo, FontRenderContext frc, boolean baseAtTop, Map isOnTop, Map srcToCol, int myColumn) {
        int numOrd = this.stackOrder_.size();
        Set allMySources = this.getAllSources();
        this.ddo_ = new GeneAndSatelliteCluster.DropDirectionOracle(isOnTop, srcToCol, baseAtTop, this.stackOrder_, allMySources, myColumn);
        for (int i = 0; i < numOrd; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)this.stackOrder_.get(i);
            sc.prepPhaseTwo(genome, lo, frc, this.ddo_);
        }
    }

    public void routeInboundLinks(GenomeSubset subset, Map padChanges, Map lengthChanges, Map extraGrowthChanges, Layout lo, FontRenderContext frc, Map placement, SpecialtyInstructions si, Map allOutsPerSource, Map deferredPerSource, boolean baseAtTop, Map isOnTop, Map deferredSrcToTraceY, int stackRow, Map srcToStack) {
        Genome baseGenome = subset.getBaseGenome();
        ArrayList useList = this.stackOrder_;
        ArrayList soList = this.sourceOrderForPads_;
        if (!baseAtTop) {
            useList = new ArrayList(this.stackOrder_);
            Collections.reverse(useList);
        } else {
            soList = new ArrayList(this.sourceOrderForPads_);
            Collections.reverse(soList);
        }
        ArrayList antiSenseUseList = new ArrayList(useList);
        Collections.reverse(antiSenseUseList);
        int numOrd = useList.size();
        for (int i = 0; i < numOrd; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)useList.get(i);
            sc.calcPadChanges(subset, soList, padChanges, lengthChanges, extraGrowthChanges);
        }
        HashSet allSrcs = new HashSet();
        for (int i = 0; i < numOrd; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)useList.get(i);
            allSrcs.addAll(sc.getInputs());
        }
        Iterator asit = allSrcs.iterator();
        while (asit.hasNext()) {
            MetaClusterPointSource lps;
            SpecialtyLayoutLinkData sin;
            Map deferredTerminalPaths;
            Integer srcRow;
            String srcID = (String)asit.next();
            SuperSrcRouterPointSource outForSrc = srcToStack == null ? (SuperSrcRouterPointSource)allOutsPerSource.get(srcID) : ((srcRow = (Integer)srcToStack.get(srcID)) == stackRow ? (SuperSrcRouterPointSource)allOutsPerSource.get(srcID) : null);
            if (this.isStacked_) {
                deferredTerminalPaths = deferredPerSource;
                sin = null;
            } else if (outForSrc == null) {
                deferredTerminalPaths = deferredPerSource;
                sin = null;
            } else {
                deferredTerminalPaths = null;
                sin = si.getOrStartLinkPointsForSrc(srcID);
            }
            if (this.isStacked_) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)useList.get(0);
                if (sc.linkIDsPerCluster(srcID, baseGenome).isEmpty()) continue;
                lps = new MetaClusterPointSource(srcID, outForSrc, 3);
                Double defTraceY = (Double)deferredSrcToTraceY.get(srcID);
                lps.setTargetTraceY(defTraceY);
                lps.setForDeferredPlacementOnly(true);
                lps.setStackedParams(this.traceOffset_, this.base_, deferredTerminalPaths, this.inboundTraces_);
            } else {
                lps = new MetaClusterPointSource(srcID, outForSrc, 1);
                lps.setInboundParams(this.traceOffset_, this.inboundTraces_, this.base_, deferredTerminalPaths);
                lps.setForDeferredPlacementOnly(outForSrc == null);
            }
            boolean linkFromTop = this.ddo_.comingFromTop(srcID, null);
            ArrayList useForSource = linkFromTop == baseAtTop ? useList : antiSenseUseList;
            for (int i = 0; i < numOrd; ++i) {
                GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)useForSource.get(i);
                boolean doIt = false;
                Iterator ilit = this.inboundLinks_.iterator();
                while (ilit.hasNext()) {
                    Linkage link = baseGenome.getLinkage((String)ilit.next());
                    if (!link.getSource().equals(srcID) || !sc.linkIsInbound(link)) continue;
                    doIt = true;
                    break;
                }
                if (!doIt) continue;
                boolean topGASC = (GeneAndSatelliteCluster)this.stackOrder_.get(0) == sc;
                sc.inboundLinkRouting(srcID, baseGenome, lo, frc, placement, padChanges, sin, lps, topGASC);
            }
        }
    }

    public void finishInboundDeferredLinks(Genome genome, SpecialtyInstructions si, Map inboundsPerSrc, Map allOutsPerSource, double traceDistance, boolean baseAtTop, LinkAnnotatedSuper las, Map positions, Map padChanges, Layout lo, FontRenderContext frc, int currStackedClustRow, Set onlySrcs, int flipOrder) {
        HashSet skipLinks = new HashSet();
        skipLinks.addAll(this.interClusterLinks_);
        skipLinks.addAll(this.intraClusterLinks_);
        Iterator ipsit = inboundsPerSrc.keySet().iterator();
        while (ipsit.hasNext()) {
            boolean sourceIsLeft;
            String srcID = (String)ipsit.next();
            if (onlySrcs != null && !onlySrcs.contains(srcID) || !this.isStacked_ && !this.isASource(srcID, genome, las.backwardInputs) && !this.isASource(srcID, genome, las.afterRowSources) && !this.isASource(srcID, genome, las.beforeRowSources)) continue;
            SuperSrcRouterPointSource outForSrc = (SuperSrcRouterPointSource)allOutsPerSource.get(srcID);
            boolean needMainDrop = true;
            Point2D.Double lastDrop = new Point2D.Double();
            if (outForSrc.isForStackedCluster()) {
                outForSrc.setCurrStackRow(currStackedClustRow);
            }
            SpecialtyLayoutLinkData sin = si.getOrStartLinkPointsForSrc(srcID);
            List inbounds = (List)inboundsPerSrc.get(srcID);
            ArrayList useList = new ArrayList(inbounds);
            boolean bl = sourceIsLeft = !las.backwardSources(genome).contains(srcID);
            if (flipOrder == 1 || flipOrder == 2 && sourceIsLeft) {
                Collections.reverse(useList);
            }
            Iterator ibsit = useList.iterator();
            while (ibsit.hasNext()) {
                GeneAndSatelliteCluster.TagAnnotatedList perClust = (GeneAndSatelliteCluster.TagAnnotatedList)ibsit.next();
                if (this.isStacked_) {
                    outForSrc.finishDeferredStackedInbounds(srcID, perClust, genome, lo, frc, positions, padChanges, skipLinks, sin, this.inboundTraces_, traceDistance, this.base_, needMainDrop, lastDrop);
                    continue;
                }
                needMainDrop = outForSrc.finishDeferredInbounds(srcID, perClust, genome, lo, frc, positions, padChanges, skipLinks, sin, this.inboundTraces_, traceDistance, this.base_, needMainDrop, lastDrop);
            }
        }
    }

    public InboundOffsets calcTraceOffsets(Map lastOutboundTraces) {
        Set inboundSrcs = this.inboundTraces_.keySet();
        InboundOffsets retval = new InboundOffsets();
        retval.lowestPrevious = null;
        retval.lowestPreviousX = null;
        retval.highestPrevious = null;
        retval.highestPreviousX = null;
        retval.highestInbound = null;
        retval.highestInboundX = null;
        if (lastOutboundTraces != null) {
            Iterator lobit = lastOutboundTraces.keySet().iterator();
            while (lobit.hasNext()) {
                String traceSrc = (String)lobit.next();
                Double xForTrace = (Double)lastOutboundTraces.get(traceSrc);
                if (retval.lowestPreviousX == null || retval.lowestPreviousX > xForTrace) {
                    retval.lowestPreviousX = xForTrace;
                    retval.lowestPrevious = traceSrc;
                }
                if (retval.highestPreviousX == null || retval.highestPreviousX < xForTrace) {
                    retval.highestPreviousX = xForTrace;
                    retval.highestPrevious = traceSrc;
                }
                if (!inboundSrcs.contains(traceSrc) || retval.highestInboundX != null && !(retval.highestInboundX < xForTrace)) continue;
                retval.highestInboundX = xForTrace;
                retval.highestInbound = traceSrc;
            }
        }
        return retval;
    }

    private MinXAndLeftShift minXAndShiftNeeded(double traceDistance, Map lastOutboundTraces, Map isOnTop, boolean baseAtTop, LinkAnnotatedSuper las) {
        Set inboundSrcs = this.inboundTraces_.keySet();
        InboundOffsets inOffs = this.calcTraceOffsets(lastOutboundTraces);
        Iterator itit = this.inboundTraces_.values().iterator();
        Integer highest = null;
        Integer lowest = null;
        while (itit.hasNext()) {
            Integer traceNum = (Integer)itit.next();
            if (highest == null || highest < traceNum) {
                highest = traceNum;
            }
            if (lowest != null && lowest <= traceNum) continue;
            lowest = traceNum;
        }
        MinXAndLeftShift retval = new MinXAndLeftShift();
        double inboundCol = highest != null ? highest.doubleValue() : 0.0;
        retval.leftShift = this.isStacked_ ? 0.0 : inboundCol * traceDistance;
        MinMax allFeedGap = new MinMax().init();
        int allFeeds = 0;
        int feedbacksFromBottom = 0;
        if (!this.isStacked_) {
            int feedbacksFromTop = 0;
            Iterator isit = inboundSrcs.iterator();
            while (isit.hasNext()) {
                String srcID = (String)isit.next();
                boolean isFeedback = las.backwardSources.contains(srcID);
                if (!isFeedback) continue;
                boolean srcOnTop = (Boolean)isOnTop.get(srcID);
                if (srcOnTop) {
                    ++feedbacksFromTop;
                } else {
                    ++feedbacksFromBottom;
                }
                Integer its = (Integer)this.inboundTraces_.get(srcID);
                allFeedGap.update(its);
            }
            allFeeds = feedbacksFromTop + feedbacksFromBottom;
        }
        if (inOffs.highestInbound != null) {
            Integer highestInboundTrace = (Integer)this.inboundTraces_.get(inOffs.highestInbound);
            double baseDelta = traceDistance * highestInboundTrace.doubleValue();
            retval.baseX = inOffs.highestInboundX - baseDelta;
        } else if (inOffs.highestPrevious != null && allFeeds > 0) {
            double feedShift = baseAtTop ? (double)(allFeedGap.max - allFeedGap.min + 1) * traceDistance : (double)feedbacksFromBottom * traceDistance;
            retval.baseX = inOffs.highestPreviousX - retval.leftShift + feedShift;
        } else if (inOffs.lowestPrevious != null && !this.inboundTraces_.isEmpty()) {
            retval.baseX = inOffs.lowestPreviousX - retval.leftShift - traceDistance;
        } else {
            return null;
        }
        retval.minX = retval.baseX + traceDistance * lowest.doubleValue();
        return retval;
    }

    private double locateStackedLeftEdge(Point2D basePos, double traceDistance) {
        this.base_ = (Point2D)basePos.clone();
        if (this.stackedDirectOffset_ != 0) {
            this.base_.setLocation(this.base_.getX() + 2.0 * traceDistance, this.base_.getY());
        }
        return this.base_.getX() + (double)this.stackedDirectOffset_ * traceDistance + 40.0;
    }

    private double locateLeftEdge(Point2D basePos, double traceDistance, Map lastOutboundTraces, Map isOnTop, boolean baseAtTop, LinkAnnotatedSuper las) {
        MinXAndLeftShift mxs = this.minXAndShiftNeeded(traceDistance, lastOutboundTraces, isOnTop, baseAtTop, las);
        double leftShift = 0.0;
        if (mxs != null) {
            this.base_ = new Point2D.Double(mxs.baseX, basePos.getY());
            leftShift = mxs.leftShift;
        } else {
            this.base_ = (Point2D)basePos.clone();
        }
        if (UiUtil.forceToGridValue(this.base_.getX(), 10.0) != this.base_.getX()) {
            throw new IllegalArgumentException();
        }
        return this.base_.getX() + leftShift + (this.isStacked_ ? 40.0 : 60.0);
    }

    public static class MinXAndLeftShift {
        public double minX;
        public double baseX;
        public double leftShift;
    }

    public static class InboundOffsets {
        public String lowestPrevious;
        public Double lowestPreviousX;
        public String highestPrevious;
        public Double highestPreviousX;
        public String highestInbound;
        public Double highestInboundX;
    }
}

