/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.LayoutFailureTracker;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.TrackedGrid;
import org.systemsbiology.biotapestry.util.UiUtil;

public class SuperSrcRouterPointSource {
    private String srcID_;
    private Point2D root_;
    private boolean rootPlaced_;
    private SpecialtyLayoutLinkData.TrackPos internalBranch_;
    private boolean internalBranchPlaced_;
    private SpecialtyLayoutLinkData.TrackPos outCorner_;
    private boolean outCornerPlaced_;
    private Point2D trace_;
    private boolean tracePlaced_;
    private Point2D feedTrace_;
    private boolean feedTracePlaced_;
    private Point2D mainHotTip_;
    private Point2D feedbackHotTip_;
    private boolean baseAtTop_;
    private boolean prePointsPlaced_;
    private List prePoints_;
    private GeneAndSatelliteCluster departureGaS_;
    private boolean forStackedClusters_;
    private int currStackRow_;
    private int stackOriginRow_;
    private TreeMap stackTraces_;
    private Map globalTraceFrame_;
    private Integer hotStackRow_;

    SuperSrcRouterPointSource(String srcID, boolean baseAtTop, boolean forStackedClusters) {
        this.srcID_ = srcID;
        this.baseAtTop_ = baseAtTop;
        this.prePointsPlaced_ = false;
        this.rootPlaced_ = false;
        this.internalBranchPlaced_ = false;
        this.outCornerPlaced_ = false;
        this.tracePlaced_ = false;
        this.forStackedClusters_ = forStackedClusters;
        if (this.forStackedClusters_) {
            this.stackTraces_ = new TreeMap();
        }
    }

    public void init(GeneAndSatelliteCluster sc, Genome genome, Layout lo, FontRenderContext frc, Map placement, Double traceX, Double track, Map padChanges, Map srcToTrack, Map trackToY, Map srcToFeedbackY, SpecialtyLayoutLinkData sin, TrackedGrid grid) {
        Double feedY;
        Double trackY;
        Integer trackNum;
        this.departureGaS_ = sc;
        if (sin != null) {
            List links = sin.getLinkList();
            List positions = sin.getPositionList((String)links.get(0));
            this.prePoints_ = new ArrayList(positions);
        }
        if (sin == null && this.srcID_.equals(sc.getCoreID())) {
            this.root_ = sc.linkTreeRoot(genome, lo, frc, placement, padChanges);
            if (traceX != null) {
                Point2D.Double ibp = new Point2D.Double(traceX, this.root_.getY());
                this.internalBranch_ = new SpecialtyLayoutLinkData.TrackPos(ibp);
            }
            if (track != null) {
                Point2D.Double ocp = new Point2D.Double(track, this.root_.getY());
                this.outCorner_ = new SpecialtyLayoutLinkData.TrackPos(ocp);
            }
        } else {
            this.root_ = null;
            if (sin == null) {
                Point2D srcLoc = (Point2D)placement.get(this.srcID_);
                if (traceX != null) {
                    Point2D.Double ibp = new Point2D.Double(traceX, srcLoc.getY());
                    this.internalBranch_ = new SpecialtyLayoutLinkData.TrackPos(ibp);
                }
                if (track != null) {
                    Point2D.Double ocp = new Point2D.Double(track, srcLoc.getY());
                    this.outCorner_ = new SpecialtyLayoutLinkData.TrackPos(ocp);
                }
            } else {
                TrackedGrid.TrackPosRC lastPt = (TrackedGrid.TrackPosRC)this.prePoints_.get(this.prePoints_.size() - 1);
                TrackedGrid.RCTrack tprc = lastPt.getRCTrack();
                if (traceX != null) {
                    this.internalBranch_ = new TrackedGrid.TrackPosRC(grid.buildRCTrack(tprc, 2, traceX));
                }
                if (track != null) {
                    this.outCorner_ = new TrackedGrid.TrackPosRC(grid.buildRCTrack(tprc, 2, track));
                }
            }
        }
        if (track != null && (trackNum = (Integer)srcToTrack.get(this.srcID_)) != null && (trackY = (Double)trackToY.get(trackNum)) != null) {
            this.trace_ = new Point2D.Double(track, trackY);
        }
        if ((feedY = (Double)srcToFeedbackY.get(this.srcID_)) != null) {
            double feedX = 0.0;
            if (this.internalBranch_ != null) {
                if (this.internalBranch_.needsConversion()) {
                    TrackedGrid.TrackPosRC ibrc = (TrackedGrid.TrackPosRC)this.internalBranch_;
                    feedX = ibrc.getRCTrack().getFixedValue(2);
                } else {
                    feedX = this.internalBranch_.getPoint().getX();
                }
            }
            this.feedTrace_ = new Point2D.Double(feedX, feedY);
        }
    }

    public void initForExternal(Double track, Double trackY, Map globalTraceFrame, int inRow) {
        this.trace_ = new Point2D.Double(track, trackY);
        Point2D ocp = (Point2D)this.trace_.clone();
        this.outCorner_ = new SpecialtyLayoutLinkData.TrackPos(ocp);
        if (this.forStackedClusters_) {
            this.stackOriginRow_ = inRow;
            this.currStackRow_ = inRow;
            this.globalTraceFrame_ = globalTraceFrame;
            this.hotStackRow_ = null;
            Integer key = new Integer(inRow);
            Point2D myTraceForTrg = (Point2D)this.trace_.clone();
            this.stackTraces_.put(key, myTraceForTrg);
        }
    }

    public Point2D startInternalBranch(SpecialtyLayoutLinkData sin, String linkID, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        Point2D hotTip = null;
        if (!this.prePointsPlaced_ && this.prePoints_ != null) {
            List conv = this.departureGaS_.convertDeparturePath(this.prePoints_, genome, padChanges, lo, frc, positions);
            sin.addPositionListToLink(linkID, conv);
            this.prePointsPlaced_ = true;
        }
        if (!this.rootPlaced_) {
            if (this.root_ != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.root_));
            }
            this.rootPlaced_ = true;
        } else if (this.root_ != null) {
            hotTip = this.root_;
        }
        if (!this.internalBranchPlaced_) {
            if (this.internalBranch_ != null) {
                Point2D ibp = this.convertToPoint(this.internalBranch_, positions, padChanges, genome, lo, frc);
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(ibp));
            }
            this.internalBranchPlaced_ = true;
        } else if (this.internalBranch_ != null) {
            hotTip = this.convertToPoint(this.internalBranch_, positions, padChanges, genome, lo, frc);
        }
        return hotTip;
    }

    public Point2D convertToPoint(SpecialtyLayoutLinkData.TrackPos tpos, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        Point2D convIB;
        if (tpos.needsConversion()) {
            TrackedGrid.TrackPosRC ibrc = (TrackedGrid.TrackPosRC)tpos;
            convIB = this.departureGaS_.convertDeparturePoint(ibrc, genome, padChanges, lo, frc, positions);
        } else {
            convIB = tpos.getPoint();
        }
        return (Point2D)convIB.clone();
    }

    public String getSrcID() {
        return this.srcID_;
    }

    public void updateMainHotTip(Point2D mainHotTip) {
        this.mainHotTip_ = mainHotTip;
    }

    public Point2D getMainHotTip() {
        return this.mainHotTip_;
    }

    public void setStackOriginRow(int stackOriginRow, Map globalTraceFrame) {
        if (!this.forStackedClusters_) {
            throw new IllegalStateException();
        }
        this.stackOriginRow_ = stackOriginRow;
        this.currStackRow_ = stackOriginRow;
        this.globalTraceFrame_ = globalTraceFrame;
        this.hotStackRow_ = null;
        this.initTraceForRow(stackOriginRow);
    }

    public int getCurrStackRow() {
        return this.currStackRow_;
    }

    public int getStackOriginRow() {
        return this.stackOriginRow_;
    }

    public boolean isForStackedCluster() {
        return this.forStackedClusters_;
    }

    public void setCurrStackRow(int currStackRow) {
        if (!this.forStackedClusters_) {
            throw new IllegalStateException();
        }
        this.currStackRow_ = currStackRow;
        this.initTraceForRow(currStackRow);
    }

    private void initTraceForRow(int stackRow) {
        Integer key = new Integer(stackRow);
        if (this.stackTraces_.get(key) != null) {
            return;
        }
        Map traceForTrgRow = (Map)this.globalTraceFrame_.get(key);
        Point2D traceForTrg = (Point2D)traceForTrgRow.get(this.srcID_);
        if (traceForTrg != null) {
            Point2D myTraceForTrg = (Point2D)traceForTrg.clone();
            this.stackTraces_.put(key, myTraceForTrg);
        }
    }

    public void updateHotStackRow() {
        this.hotStackRow_ = new Integer(this.currStackRow_);
    }

    public void resetHotStackRowToOrigin() {
        this.hotStackRow_ = new Integer(this.stackOriginRow_);
    }

    public Integer getHotStackRow() {
        return this.hotStackRow_;
    }

    public void updateFeedbackHotTip(Point2D feedbackHotTip) {
        this.feedbackHotTip_ = feedbackHotTip;
    }

    public Point2D getFeedbackHotTip() {
        return this.feedbackHotTip_;
    }

    public Point2D getInternalBranch(Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        return this.internalBranch_ == null ? null : this.convertToPoint(this.internalBranch_, positions, padChanges, genome, lo, frc);
    }

    public Point2D getTrace() {
        return this.trace_;
    }

    public Point2D getFeedTrace() {
        return this.feedTrace_;
    }

    public Point2D getCurrentStackedTrace() {
        Integer key = new Integer(this.currStackRow_);
        Point2D retval = (Point2D)this.stackTraces_.get(key);
        return retval;
    }

    public Point2D getMinStackedTrace() {
        Point2D retval = (Point2D)this.stackTraces_.get(this.stackTraces_.firstKey());
        return retval;
    }

    public Point2D getMaxStackedTrace() {
        Point2D retval = (Point2D)this.stackTraces_.get(this.stackTraces_.lastKey());
        return retval;
    }

    public Integer getMaxStackedTraceKey() {
        return (Integer)new TreeSet(this.globalTraceFrame_.keySet()).last();
    }

    public Point2D getInitialStackedTrace() {
        Integer key = new Integer(this.stackOriginRow_);
        Point2D retval = (Point2D)this.stackTraces_.get(key);
        return retval;
    }

    public Point2D getLastStackedTrace() {
        if (this.stackTraces_.isEmpty()) {
            return null;
        }
        return (Point2D)this.stackTraces_.get(this.hotStackRow_);
    }

    public boolean haveAStackedTrace() {
        return !this.stackTraces_.isEmpty();
    }

    public boolean isBaseAtTop() {
        return this.baseAtTop_;
    }

    public Point2D startOutboundBranch(SpecialtyLayoutLinkData sin, String linkID, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        Point2D hotTip = null;
        Point2D ppChk = null;
        if (!this.prePointsPlaced_ && this.prePoints_ != null) {
            List conv = this.departureGaS_.convertDeparturePath(this.prePoints_, genome, padChanges, lo, frc, positions);
            sin.addPositionListToLink(linkID, conv);
            ppChk = ((SpecialtyLayoutLinkData.TrackPos)conv.get(conv.size() - 1)).getPoint();
            this.prePointsPlaced_ = true;
        }
        if (!this.rootPlaced_) {
            if (this.root_ != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.root_));
            }
            this.rootPlaced_ = true;
        } else if (this.root_ != null) {
            hotTip = this.root_;
        }
        if (!this.internalBranchPlaced_) {
            if (hotTip != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                hotTip = null;
            }
            if (this.internalBranch_ != null) {
                Point2D ibp = this.convertToPoint(this.internalBranch_, positions, padChanges, genome, lo, frc);
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(ibp));
            }
            this.internalBranchPlaced_ = true;
        } else if (this.internalBranch_ != null) {
            hotTip = this.convertToPoint(this.internalBranch_, positions, padChanges, genome, lo, frc);
        }
        Point2D ocpChk = null;
        if (!this.outCornerPlaced_) {
            if (hotTip != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                hotTip = null;
            }
            if (this.outCorner_ != null) {
                Point2D ibp = this.convertToPoint(this.outCorner_, positions, padChanges, genome, lo, frc);
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(ibp));
                ocpChk = ibp;
            }
            this.outCornerPlaced_ = true;
        } else if (this.outCorner_ != null) {
            ocpChk = hotTip = this.convertToPoint(this.outCorner_, positions, padChanges, genome, lo, frc);
        }
        if (!this.tracePlaced_) {
            if (hotTip != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                hotTip = null;
            }
            if (this.trace_ != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.trace_));
            }
            this.tracePlaced_ = true;
        } else {
            if (this.trace_ != null) {
                hotTip = this.trace_;
            }
            if (hotTip != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
            }
        }
        return hotTip;
    }

    public Point2D startFeedbackBranch(SpecialtyLayoutLinkData sin, String linkID, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc) {
        Point2D hotTip = null;
        if (!this.prePointsPlaced_ && this.prePoints_ != null) {
            List conv = this.departureGaS_.convertDeparturePath(this.prePoints_, genome, padChanges, lo, frc, positions);
            sin.addPositionListToLink(linkID, conv);
            this.prePointsPlaced_ = true;
        }
        if (!this.rootPlaced_) {
            if (this.root_ != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.root_));
            }
            this.rootPlaced_ = true;
        } else if (this.root_ != null) {
            hotTip = this.root_;
        }
        if (!this.internalBranchPlaced_) {
            if (hotTip != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                hotTip = null;
            }
            if (this.internalBranch_ != null) {
                Point2D ibp = this.convertToPoint(this.internalBranch_, positions, padChanges, genome, lo, frc);
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(ibp));
            }
            this.internalBranchPlaced_ = true;
        } else if (this.internalBranch_ != null) {
            hotTip = this.convertToPoint(this.internalBranch_, positions, padChanges, genome, lo, frc);
        }
        if (!this.feedTracePlaced_) {
            if (hotTip != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                hotTip = null;
            }
            if (this.feedTrace_ != null) {
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(this.feedTrace_));
            }
            this.feedTracePlaced_ = true;
        } else if (this.feedTrace_ != null) {
            hotTip = this.feedTrace_;
        }
        return hotTip;
    }

    public void stackedSetupForOutboundSources(SpecialtyLayoutLinkData sin, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, Rectangle bounds) {
        Point2D initStack;
        Point2D backTip = this.getFeedbackHotTip();
        Integer hotRow = this.getHotStackRow();
        Point2D useForRight = null;
        int debugPath = -1;
        double borderTweak = 0.0;
        bounds = UiUtil.rectFromRect2D(UiUtil.padTheRect(bounds, 20.0));
        if (backTip == null) {
            debugPath = 0;
            sin.startInitRoute();
            this.startOutboundBranch(sin, null, placement, padChanges, genome, lo, frc);
            List initRoute = sin.getInitRoute();
            Point2D ob = ((SpecialtyLayoutLinkData.TrackPos)initRoute.get(initRoute.size() - 1)).getPoint();
            sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(ob, false), 0);
            Point2D initStack2 = (Point2D)this.getInitialStackedTrace().clone();
            sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(initStack2, false), 3);
            sin.setBorderPosition(2, initStack2);
            useForRight = ob;
            Point2D.Double bottomPt = new Point2D.Double(initStack2.getX(), bounds.getMaxY() + borderTweak);
            sin.setBorderPosition(1, bottomPt);
            Point2D.Double topPt = new Point2D.Double(initStack2.getX(), bounds.getMinY() - borderTweak);
            sin.setBorderPosition(0, topPt);
            if (this.haveAStackedTrace()) {
                Point2D topStack = (Point2D)this.getMinStackedTrace().clone();
                sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(topStack, true), 4);
                Point2D botStack = (Point2D)this.getMaxStackedTrace().clone();
                sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(botStack, true), 5);
            }
        } else if (hotRow != null) {
            debugPath = 1;
            initStack = (Point2D)this.getInitialStackedTrace().clone();
            sin.setBorderPosition(2, initStack);
            useForRight = initStack;
            Point2D topStack = (Point2D)this.getMinStackedTrace().clone();
            sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(topStack, true), 4);
            Point2D.Double topPt = new Point2D.Double(initStack.getX(), bounds.getMinY() - borderTweak);
            sin.setBorderPosition(0, topPt);
            Point2D botStack = (Point2D)this.getMaxStackedTrace().clone();
            sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(botStack, true), 5);
            Point2D.Double botPt = new Point2D.Double(initStack.getX(), bounds.getMaxY() + borderTweak);
            sin.setBorderPosition(1, botPt);
        } else {
            debugPath = 2;
            sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(backTip, true), 2);
            initStack = (Point2D)this.getInitialStackedTrace().clone();
            useForRight = (Point2D)this.getTrace().clone();
            sin.setBorderPosition(2, initStack);
            sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(initStack, false), 3);
            Point2D.Double topPt = new Point2D.Double(initStack.getX(), bounds.getMinY() - borderTweak);
            sin.setBorderPosition(0, topPt);
            Point2D.Double botPt = new Point2D.Double(initStack.getX(), bounds.getMaxY() + borderTweak);
            sin.setBorderPosition(1, botPt);
            if (this.haveAStackedTrace()) {
                Point2D topStack = (Point2D)this.getMinStackedTrace().clone();
                sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(topStack, true), 4);
                Point2D botStack = (Point2D)this.getMaxStackedTrace().clone();
                sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(botStack, true), 5);
            }
        }
        sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(useForRight, false), 1);
        Point2D.Double rightPt = new Point2D.Double(bounds.getMaxX() + borderTweak, useForRight.getY());
        sin.setBorderPosition(3, rightPt);
        LayoutFailureTracker.recordBordersAndExits(this, sin, debugPath);
    }

    public void stackedSetupForInboundSources(SpecialtyLayoutLinkData sin, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, Rectangle bounds) {
        double borderTweak = 0.0;
        bounds = UiUtil.rectFromRect2D(UiUtil.padTheRect(bounds, 20.0));
        Point2D initStack = (Point2D)this.getInitialStackedTrace().clone();
        sin.setBorderPosition(2, initStack);
        Point2D.Double rightPt = new Point2D.Double(bounds.getMaxX() + borderTweak, initStack.getY());
        sin.setBorderPosition(3, rightPt);
        Point2D.Double bottomPt = new Point2D.Double(initStack.getX(), bounds.getMaxY() + borderTweak);
        sin.setBorderPosition(1, bottomPt);
        Point2D.Double topPt = new Point2D.Double(initStack.getX(), bounds.getMinY() - borderTweak);
        sin.setBorderPosition(0, topPt);
    }

    public void establishLeftPoints(SpecialtyLayoutLinkData sin) {
        Integer hotRow = this.getHotStackRow();
        if (hotRow != null) {
            Point2D initStack = (Point2D)this.getInitialStackedTrace().clone();
            if (!sin.hasExitFramework(3)) {
                sin.setExitFramework(new SpecialtyLayoutLinkData.PlacedPoint(initStack, false), 3);
            }
        }
    }

    public boolean finishDeferredInbounds(String srcID, List perClust, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, Set skipLinks, SpecialtyLayoutLinkData sin, Map inboundTraces, double traceDistance, Point2D base, boolean needMainDrop, Point2D lastDrop) {
        int pcNum = perClust.size();
        for (int i = 0; i < pcNum; ++i) {
            GeneAndSatelliteCluster.InboundCorners ic = (GeneAndSatelliteCluster.InboundCorners)perClust.get(i);
            if (skipLinks.contains(ic.linkID)) continue;
            sin.startNewLink(ic.linkID);
            if (ic.needDrop) {
                if (needMainDrop) {
                    Integer inTrace = (Integer)inboundTraces.get(srcID);
                    double traceColVal = inTrace.doubleValue();
                    double dropX = base.getX() + traceColVal * traceDistance;
                    Point2D hotTip = this.getFeedbackHotTip();
                    if (hotTip == null) {
                        this.startFeedbackBranch(sin, ic.linkID, placement, padChanges, genome, lo, frc);
                    } else {
                        sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                    }
                    Point2D.Double topDrop = new Point2D.Double(dropX, this.getFeedTrace().getY());
                    lastDrop.setLocation(topDrop);
                    this.updateFeedbackHotTip((Point2D)topDrop.clone());
                    needMainDrop = false;
                }
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos((Point2D)lastDrop.clone()));
                Point2D.Double drop = new Point2D.Double(lastDrop.getX(), ic.dropY);
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(drop));
                lastDrop.setLocation(drop);
            } else if (ic.prevPoint != null) {
                sin.addPositionToLink(ic.linkID, ic.prevPoint);
            }
            sin.addPositionListToLink(ic.linkID, ic.finalPath);
        }
        return needMainDrop;
    }

    public void finishDeferredStackedInbounds(String srcID, List perClust, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, Set skipLinks, SpecialtyLayoutLinkData sin, Map inboundTraces, double traceDistance, Point2D base, boolean needMainDrop, Point2D lastDrop) {
        int pcNum = perClust.size();
        for (int i = 0; i < pcNum; ++i) {
            GeneAndSatelliteCluster.InboundCorners ic = (GeneAndSatelliteCluster.InboundCorners)perClust.get(i);
            if (skipLinks.contains(ic.linkID)) continue;
            sin.startNewLink(ic.linkID);
            if (ic.needDrop) {
                this.finishStackedDeferred(ic, sin, genome, lo, frc, placement, padChanges, lastDrop);
            }
            if (ic.prevPoint != null) {
                sin.addPositionToLink(ic.linkID, ic.prevPoint);
            }
            sin.addPositionListToLink(ic.linkID, ic.finalPath);
        }
    }

    private void finishStackedDeferred(GeneAndSatelliteCluster.InboundCorners ic, SpecialtyLayoutLinkData sin, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, Point2D lastDrop) {
        int cs = this.getCurrStackRow();
        int so = this.getStackOriginRow();
        double dropX = ((SpecialtyLayoutLinkData.TrackPos)ic.finalPath.get(0)).getPoint().getX();
        Point2D hotTip = this.getMainHotTip();
        Point2D feedHotTip = this.getFeedbackHotTip();
        if (hotTip == null && feedHotTip == null) {
            this.startOutboundBranch(sin, ic.linkID, placement, padChanges, genome, lo, frc);
            if (cs == so) {
                Point2D.Double startDrop;
                Point2D ft = this.getCurrentStackedTrace();
                Point2D out = this.getTrace();
                Point2D feed = this.getFeedTrace();
                if (out == null && feed != null) {
                    startDrop = new Point2D.Double(feed.getX(), ft.getY());
                    sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(startDrop));
                } else {
                    startDrop = new Point2D.Double(out.getX(), ft.getY());
                }
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(startDrop));
                Point2D.Double nextDrop = new Point2D.Double(dropX, ft.getY());
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(nextDrop));
                lastDrop.setLocation(nextDrop);
                if (dropX > ((Point2D)startDrop).getX()) {
                    this.updateFeedbackHotTip((Point2D)startDrop.clone());
                    this.updateMainHotTip((Point2D)lastDrop.clone());
                } else {
                    this.updateFeedbackHotTip((Point2D)lastDrop.clone());
                    this.updateMainHotTip((Point2D)startDrop.clone());
                }
                return;
            }
            Point2D currStack = this.getInitialStackedTrace();
            sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(currStack));
            this.updateHotStackRow();
            currStack = this.getCurrentStackedTrace();
            sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(currStack));
            Point2D.Double topDrop = new Point2D.Double(dropX, currStack.getY());
            sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(topDrop));
            lastDrop.setLocation(topDrop);
            this.updateMainHotTip((Point2D)topDrop.clone());
            return;
        }
        if (cs == so) {
            if (dropX > hotTip.getX()) {
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                Point2D.Double topDrop = new Point2D.Double(dropX, hotTip.getY());
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(topDrop));
                lastDrop.setLocation(topDrop);
                this.updateMainHotTip((Point2D)topDrop.clone());
            } else {
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(feedHotTip));
                Point2D.Double topDrop = new Point2D.Double(dropX, feedHotTip.getY());
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(topDrop));
                lastDrop.setLocation(topDrop);
                this.updateFeedbackHotTip((Point2D)topDrop.clone());
            }
            return;
        }
        Integer hotRow = this.getHotStackRow();
        if (hotRow != null) {
            if (hotRow == cs) {
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(hotTip));
                Point2D.Double topDrop = new Point2D.Double(dropX, hotTip.getY());
                sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(topDrop));
                lastDrop.setLocation(topDrop);
                this.updateFeedbackHotTip((Point2D)topDrop.clone());
                this.updateMainHotTip((Point2D)topDrop.clone());
                return;
            }
            Point2D initStack = this.getInitialStackedTrace();
            Point2D currStack = this.getCurrentStackedTrace();
            Point2D lastStack = this.getLastStackedTrace();
            if (currStack.getY() > initStack.getY() && lastStack.getY() < initStack.getY()) {
                this.resetHotStackRowToOrigin();
                lastStack = this.getLastStackedTrace();
            }
            sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(lastStack));
            sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(currStack));
            Point2D.Double topDrop = new Point2D.Double(dropX, currStack.getY());
            sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(topDrop));
            lastDrop.setLocation(topDrop);
            this.updateMainHotTip((Point2D)topDrop.clone());
            this.updateHotStackRow();
            return;
        }
        sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(feedHotTip));
        Point2D currStack = this.getInitialStackedTrace();
        sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(currStack));
        currStack = this.getCurrentStackedTrace();
        sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(currStack));
        Point2D.Double topDrop = new Point2D.Double(dropX, currStack.getY());
        sin.addPositionToLink(ic.linkID, new SpecialtyLayoutLinkData.TrackPos(topDrop));
        lastDrop.setLocation(topDrop);
        this.updateMainHotTip((Point2D)topDrop.clone());
        this.updateHotStackRow();
    }
}

