/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.Grid;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class TrackedGrid {
    private static final double FAN_GRID_PAD_Y_ = 40.0;
    private static final double FAN_GRID_PAD_X_ = 40.0;
    private Grid grid_;
    private double exactVerticalOffset_;
    private Dimension dims_;
    private HashMap widths_;
    private HashMap heights_;
    private HashMap colTracks_;
    private HashMap rowTracks_;
    private HashMap cellBounds_;

    public TrackedGrid(Grid grid, Genome genome, Layout lo, FontRenderContext frc, String coreID, boolean textToo) {
        this.grid_ = grid;
        this.widths_ = new HashMap();
        this.heights_ = new HashMap();
        this.cellBounds_ = new HashMap();
        this.dims_ = this.calcFanNodalDims(genome, lo, frc, coreID, textToo, this.cellBounds_);
        this.exactVerticalOffset_ = Double.NEGATIVE_INFINITY;
        this.colTracks_ = new HashMap();
        this.rowTracks_ = new HashMap();
    }

    public String getContents(int row, int col) {
        return this.grid_.getCellValue(row, col);
    }

    public String rightmostForRow(int rowNum, String ignoreID) {
        String retval = null;
        int colNum = this.grid_.getNumCols();
        for (int i = 0; i < colNum; ++i) {
            String nodeID = this.grid_.getCellValue(rowNum, i);
            if (nodeID == null || nodeID.equals(ignoreID)) continue;
            retval = nodeID;
        }
        return retval;
    }

    public boolean firstOnLeft(String trgID, String ignoreID) {
        Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(trgID);
        int colNum = this.grid_.getNumCols();
        for (int i = 0; i < colNum; ++i) {
            String nodeID = this.grid_.getCellValue(trgRC.row, i);
            if (nodeID == null) continue;
            if (nodeID.equals(trgID)) {
                return true;
            }
            if (ignoreID != null && nodeID.equals(ignoreID)) continue;
            return false;
        }
        throw new IllegalArgumentException();
    }

    public boolean canEnterOnLeft(String srcID, String trgID, Genome genome) {
        int startRow;
        int startCol;
        if (this.grid_.contains(srcID)) {
            Grid.RowAndColumn srcRC = this.grid_.findPositionRandC(srcID);
            startCol = srcRC.col + 1;
            startRow = srcRC.row;
        } else {
            startCol = 0;
            startRow = 0;
        }
        if (!this.grid_.contains(trgID)) {
            return false;
        }
        boolean maybeOK = false;
        Grid.RowAndColumn trgRC = this.grid_.findPositionRandC(trgID);
        int endRow = trgRC.row;
        int colNum = this.grid_.getNumCols();
        for (int i = startCol; i < colNum; ++i) {
            String nodeID = this.grid_.getCellValue(trgRC.row, i);
            if (nodeID != null && nodeID.equals(trgID)) {
                if (endRow == startRow || i == 0) {
                    return true;
                }
                maybeOK = true;
                break;
            }
            if (nodeID == null) continue;
            return false;
        }
        if (maybeOK) {
            String prevID = this.grid_.getCellValue(trgRC.row, trgRC.col - 1);
            return prevID == null || genome.getOutboundLinkCount(prevID) == 0;
        }
        return false;
    }

    public void convertToPoints(SpecialtyLayoutLinkData sin, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID, double fixVal) {
        Iterator vit = sin.getLinkList().iterator();
        while (vit.hasNext()) {
            String linkID = (String)vit.next();
            List pointList = sin.getPositionList(linkID);
            int numpts = pointList.size();
            for (int i = 0; i < numpts; ++i) {
                TrackPosRC rct = (TrackPosRC)pointList.get(i);
                this.convertRCTrack(rct, upperLeft, positions, padChanges, genome, lo, frc, coreID, fixVal);
            }
        }
    }

    public Point2D getLastConvertedPoint(SpecialtyLayoutLinkData sin) {
        Iterator vit = sin.getLinkList().iterator();
        Point2D retval = null;
        while (vit.hasNext()) {
            String linkID = (String)vit.next();
            List pointList = sin.getPositionList(linkID);
            int numpts = pointList.size();
            for (int i = 0; i < numpts; ++i) {
                TrackPosRC tprc = (TrackPosRC)pointList.get(i);
                if (tprc.needsConversion()) {
                    return retval;
                }
                retval = tprc.getPoint();
            }
        }
        return null;
    }

    public void convertPositionListToPoints(List pointList, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        int numpts = pointList.size();
        for (int i = 0; i < numpts; ++i) {
            SpecialtyLayoutLinkData.TrackPos rct = (SpecialtyLayoutLinkData.TrackPos)pointList.get(i);
            if (!rct.needsConversion()) continue;
            this.convertRCTrack((TrackPosRC)rct, upperLeft, positions, padChanges, genome, lo, frc, coreID, 0.0);
        }
    }

    public Point2D convertPositionToPoint(TrackPosRC tprc, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        if (tprc.needsConversion()) {
            tprc = (TrackPosRC)tprc.clone();
            this.convertRCTrack(tprc, upperLeft, positions, padChanges, genome, lo, frc, coreID, 0.0);
        }
        return tprc.getPoint();
    }

    public void convertRCTrack(TrackPosRC tprc, Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID, double fixVal) {
        if (tprc.needsConversion()) {
            RCTrack rct = tprc.rcTrack;
            if (!rct.isMyGrid(this)) {
                return;
            }
            tprc.fixLocation(rct.convert(upperLeft, positions, padChanges, genome, lo, frc, coreID, fixVal));
        }
    }

    public Grid.RowAndColumn findPositionRandC(String nodeID) {
        return this.grid_.findPositionRandC(nodeID);
    }

    public boolean contains(String nodeID) {
        return this.grid_.contains(nodeID);
    }

    public RCTrack buildRCTrack(RCTrack rct, TrackSpec spec, int whichSpec) {
        return new RCTrack(rct, spec, whichSpec);
    }

    public RCTrack buildRCTrack(RCTrack rowRct, RCTrack colRct) {
        return new RCTrack(rowRct, colRct);
    }

    public RCTrack buildRCTrack(TrackSpec rowSpec, TrackSpec colSpec) {
        return new RCTrack(rowSpec, colSpec);
    }

    public RCTrack buildRCTrack(RCTrack rct, int whichFixed, double fixValue) {
        return new RCTrack(rct, whichFixed, fixValue);
    }

    public RCTrack buildRCTrack(RCTrack rct, int whichFloats) {
        return new RCTrack(rct, whichFloats);
    }

    public RCTrack buildRCTrackForRowMidline(TrackSpec colSpec, int padNum, String nodeID, String linkID, boolean isLanding, int linkSign, int rowNum) {
        return new RCTrack(colSpec, 1, padNum, nodeID, linkID, isLanding, linkSign, rowNum);
    }

    public RCTrack buildRCTrackForColMidline(TrackSpec rowSpec, int padNum, String nodeID, String linkID, boolean isLanding, int linkSign, int colNum) {
        return new RCTrack(rowSpec, 0, padNum, nodeID, linkID, isLanding, linkSign, colNum);
    }

    public RCTrack buildRCTrackWithPadChange(RCTrack current, int padNum, String linkID) {
        return current.copyWithNewColPadNum(padNum, linkID);
    }

    public RCTrack buildRCTrackForDualMidline(int colPadNum, String colNodeID, boolean colIsLanding, int rowPadNum, String rowNodeID, boolean rowIsLanding, int linkSign, String linkID, int colNum, int rowNum) {
        return new RCTrack(colPadNum, colNodeID, colIsLanding, rowPadNum, rowNodeID, rowIsLanding, linkSign, linkID, colNum, rowNum);
    }

    public RCTrack inheritRCTrackNewRowMidline(RCTrack rct, int padNum, String nodeID, String linkID, boolean isLanding, int linkSign, int rowNum) {
        return new RCTrack(rct, 1, padNum, nodeID, linkID, isLanding, linkSign, rowNum);
    }

    public RCTrack inheritRCTrackNewColMidline(RCTrack rct, int padNum, String nodeID, String linkID, boolean isLanding, int linkSign, int colNum) {
        return new RCTrack(rct, 0, padNum, nodeID, linkID, isLanding, linkSign, colNum);
    }

    public int getNumCols() {
        return this.grid_.getNumCols();
    }

    public int getNumRows() {
        return this.grid_.getNumRows();
    }

    public TrackSpec reserveColumnTrack(int col, String srcID) {
        Integer colKey = new Integer(col);
        TreeMap<Integer, String> trackMap = (TreeMap<Integer, String>)this.colTracks_.get(colKey);
        boolean isNew = false;
        if (trackMap == null) {
            trackMap = new TreeMap<Integer, String>();
            this.colTracks_.put(colKey, trackMap);
            isNew = true;
        }
        if (isNew) {
            trackMap.put(new Integer(0), srcID);
            return new TrackSpec(col, 0);
        }
        Iterator tmkit = trackMap.keySet().iterator();
        while (tmkit.hasNext()) {
            Integer key = (Integer)tmkit.next();
            String chkSrcID = (String)trackMap.get(key);
            if (!chkSrcID.equals(srcID)) continue;
            return new TrackSpec(col, key);
        }
        Integer lastKey = (Integer)trackMap.lastKey();
        Set trackKeys = trackMap.keySet();
        int lastKeyVal = lastKey;
        Integer nextKey = null;
        for (int i = 0; i < lastKeyVal; ++i) {
            Integer testInt = new Integer(i);
            if (trackKeys.contains(testInt)) continue;
            nextKey = testInt;
            break;
        }
        if (nextKey == null) {
            nextKey = new Integer(lastKey + 1);
        }
        trackMap.put(nextKey, srcID);
        return new TrackSpec(col, nextKey);
    }

    public TrackSpec reserveSkippedColumnTrack(int col, String srcID, int srcSkip) {
        Integer colKey = new Integer(col);
        TreeMap<Integer, String> trackMap = (TreeMap<Integer, String>)this.colTracks_.get(colKey);
        boolean isNew = false;
        if (trackMap == null) {
            trackMap = new TreeMap<Integer, String>();
            this.colTracks_.put(colKey, trackMap);
            isNew = true;
        }
        if (isNew) {
            trackMap.put(new Integer(srcSkip), srcID);
            return new TrackSpec(col, srcSkip);
        }
        Iterator tmkit = trackMap.keySet().iterator();
        while (tmkit.hasNext()) {
            Integer key = (Integer)tmkit.next();
            String chkSrcID = (String)trackMap.get(key);
            if (!chkSrcID.equals(srcID)) continue;
            return new TrackSpec(col, key);
        }
        Integer lastKey = (Integer)trackMap.lastKey();
        Set trackKeys = trackMap.keySet();
        int lastKeyVal = lastKey;
        Integer nextKey = null;
        for (int i = 0; i < lastKeyVal; ++i) {
            Integer testInt = new Integer(i);
            if (trackKeys.contains(testInt)) continue;
            nextKey = testInt;
            break;
        }
        if (nextKey == null) {
            nextKey = new Integer(lastKey + 1);
        }
        trackMap.put(nextKey, srcID);
        return new TrackSpec(col, nextKey);
    }

    public TrackSpec reserveRowTrack(int row, String srcID) {
        Integer rowKey = new Integer(row);
        TreeMap<Integer, String> trackMap = (TreeMap<Integer, String>)this.rowTracks_.get(rowKey);
        boolean isNew = false;
        if (trackMap == null) {
            trackMap = new TreeMap<Integer, String>();
            this.rowTracks_.put(rowKey, trackMap);
            isNew = true;
        }
        if (isNew) {
            trackMap.put(new Integer(0), srcID);
            return new TrackSpec(row, 0);
        }
        Iterator tmkit = trackMap.keySet().iterator();
        while (tmkit.hasNext()) {
            Integer key = (Integer)tmkit.next();
            String chkSrcID = (String)trackMap.get(key);
            if (!chkSrcID.equals(srcID)) continue;
            return new TrackSpec(row, key);
        }
        Integer lastKey = (Integer)trackMap.lastKey();
        Integer nextKey = new Integer(lastKey + 1);
        trackMap.put(nextKey, srcID);
        return new TrackSpec(row, nextKey);
    }

    public double getWidth() {
        double width = this.dims_.getWidth();
        Iterator ctit = this.colTracks_.keySet().iterator();
        while (ctit.hasNext()) {
            Integer keyA = (Integer)ctit.next();
            TreeMap trackMap = (TreeMap)this.colTracks_.get(keyA);
            int minKey = Integer.MAX_VALUE;
            int maxKey = Integer.MIN_VALUE;
            Iterator tmkit = trackMap.keySet().iterator();
            while (tmkit.hasNext()) {
                Integer key = (Integer)tmkit.next();
                int keyVal = key;
                if (keyVal < minKey) {
                    minKey = keyVal;
                }
                if (keyVal <= maxKey) continue;
                maxKey = keyVal;
            }
            int numTracks = maxKey - minKey + 1;
            width += (double)numTracks * 10.0;
        }
        return width;
    }

    public int getTopReservations() {
        if (this.rowTracks_.isEmpty()) {
            return 0;
        }
        TreeMap topTrackMap = (TreeMap)this.rowTracks_.get(new Integer(0));
        if (topTrackMap == null) {
            return 0;
        }
        int minKey = Integer.MAX_VALUE;
        int maxKey = Integer.MIN_VALUE;
        Iterator tmkit = topTrackMap.keySet().iterator();
        while (tmkit.hasNext()) {
            Integer key = (Integer)tmkit.next();
            int keyVal = key;
            if (keyVal < minKey) {
                minKey = keyVal;
            }
            if (keyVal <= maxKey) continue;
            maxKey = keyVal;
        }
        return maxKey - minKey + 1;
    }

    public double getHeight() {
        double height = this.dims_.getHeight();
        Iterator rtit = this.rowTracks_.values().iterator();
        while (rtit.hasNext()) {
            TreeMap trackMap = (TreeMap)rtit.next();
            int numTracks = trackMap.size();
            height += (double)numTracks * 10.0;
        }
        return height;
    }

    public double getExactVerticalOffset(Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        if (this.exactVerticalOffset_ == Double.NEGATIVE_INFINITY) {
            this.exactVerticalOffset_ = this.calcExactVerticalOffset(genome, lo, frc, coreID);
        }
        return this.exactVerticalOffset_;
    }

    public void placeGrid(Point2D upperLeft, Map positions, Layout lo, String ignoreID) {
        double totalY;
        int colNum = this.grid_.getNumCols();
        if (colNum == 0) {
            return;
        }
        int rowNum = this.grid_.getNumRows();
        HashMap<Integer, Double> rowAllotment = new HashMap<Integer, Double>();
        Iterator rtit = this.rowTracks_.keySet().iterator();
        while (rtit.hasNext()) {
            Integer rowKey = (Integer)rtit.next();
            if (rowKey == 0) continue;
            TreeMap trackMap = (TreeMap)this.rowTracks_.get(rowKey);
            int numTracks = trackMap.size();
            double height = (double)numTracks * 10.0;
            rowAllotment.put(rowKey, new Double(height));
        }
        HashMap<Integer, Double> colAllotment = new HashMap<Integer, Double>();
        Iterator ctit = this.colTracks_.keySet().iterator();
        while (ctit.hasNext()) {
            Integer colKey = (Integer)ctit.next();
            TreeMap trackMap = (TreeMap)this.colTracks_.get(colKey);
            int numTracks = trackMap.size();
            double width = (double)numTracks * 10.0;
            colAllotment.put(colKey, new Double(width));
        }
        double upperLeftX = upperLeft.getX();
        double centerY = totalY = upperLeft.getY();
        for (int i = 0; i < rowNum; ++i) {
            double totalX;
            Integer rowKey = new Integer(i);
            double slotHeight = (Double)this.heights_.get(rowKey);
            Double rowHeightObj = (Double)rowAllotment.get(rowKey);
            double rowHeight = rowHeightObj == null ? 0.0 : rowHeightObj;
            centerY = totalY + rowHeight + slotHeight / 2.0;
            totalY += slotHeight + rowHeight;
            double centerX = totalX = upperLeftX;
            for (int j = 0; j < colNum; ++j) {
                Integer colKey = new Integer(j);
                double slotWidth = (Double)this.widths_.get(colKey);
                Double colWidthObj = (Double)colAllotment.get(colKey);
                double colWidth = colWidthObj == null ? 0.0 : colWidthObj;
                centerX = totalX + colWidth + slotWidth / 2.0;
                totalX += slotWidth + colWidth;
                String nodeID = this.grid_.getCellValue(i, j);
                if (nodeID == null || nodeID.equals(ignoreID)) continue;
                Rectangle2D forCell = (Rectangle2D)this.cellBounds_.get(nodeID);
                double cellCenterX = forCell.getCenterX();
                NodeProperties np = lo.getNodeProperties(nodeID);
                INodeRenderer rend = np.getRenderer();
                double yOffset = rend.getStraightThroughOffset();
                Point2D.Double loc = new Point2D.Double();
                UiUtil.forceToGrid(centerX - cellCenterX, centerY - yOffset, loc, 10.0);
                positions.put(nodeID, loc);
            }
        }
    }

    public static Vector2D launchPadToOffset(int padNum, Genome genome, Layout lo, FontRenderContext frc, String nodeID) {
        NodeProperties np = lo.getNodeProperties(nodeID);
        INodeRenderer rend = np.getRenderer();
        Node srcNode = genome.getNode(nodeID);
        Vector2D futureOff = rend.getLaunchPadOffsetForLayout(srcNode, lo, frc, 2, new Integer(genome.getInboundLinkCount(nodeID)));
        Vector2D currentOff = rend.getLaunchPadOffsetForLayout(srcNode, lo, frc, 2, null);
        Vector2D useOff = futureOff.lengthSq() > currentOff.lengthSq() ? futureOff : currentOff;
        return useOff;
    }

    public static Rectangle2D layoutBounds(Genome genome, Layout lo, FontRenderContext frc, String nodeID, boolean textToo) {
        NodeProperties np = lo.getNodeProperties(nodeID);
        INodeRenderer rend = np.getRenderer();
        Node node = genome.getNode(nodeID);
        Rectangle2D rectFuture = rend.getBoundsForLayout(genome, node, lo, frc, 2, textToo, new Integer(genome.getInboundLinkCount(nodeID)));
        Rectangle2D rectCurrent = rend.getBoundsForLayout(genome, node, lo, frc, 2, textToo, null);
        Rectangle2D useRect = rectFuture.getWidth() > rectCurrent.getWidth() ? rectFuture : rectCurrent;
        return useRect;
    }

    public static int launchForGrid(String nodeID, Genome genome) {
        Node node = genome.getNode(nodeID);
        int type = node.getNodeType();
        if (type == 2 || type == 1 || type == 3 || type == 7) {
            return 1;
        }
        if (type == 6) {
            return 0;
        }
        return 0;
    }

    public static Vector2D landingPadToOffset(int padNum, Genome genome, Layout lo, FontRenderContext frc, String nodeID, int sign) {
        NodeProperties np = lo.getNodeProperties(nodeID);
        INodeRenderer rend = np.getRenderer();
        Node srcNode = genome.getNode(nodeID);
        int currOrient = np.getOrientation();
        if (currOrient == 2) {
            Vector2D offset = rend.getLandingPadOffset(padNum, srcNode, sign, lo, frc);
            return offset;
        }
        Layout bogus = new Layout("bogus", genome.getID());
        NodeProperties newProp = (NodeProperties)np.clone();
        newProp.setOrientation(2);
        bogus.setNodeProperties(nodeID, newProp);
        Vector2D offset = rend.getLandingPadOffset(padNum, srcNode, sign, bogus, frc);
        return offset;
    }

    private Dimension calcFanNodalDims(Genome genome, Layout lo, FontRenderContext frc, String ignoreID, boolean textToo, Map holdBounds) {
        int i;
        Dimension retval = new Dimension();
        int colNum = this.grid_.getNumCols();
        if (colNum == 0) {
            retval.setSize(0.0, 0.0);
            return retval;
        }
        int rowNum = this.grid_.getNumRows();
        for (i = 0; i < rowNum; ++i) {
            this.heights_.put(new Integer(i), new Double(0.0));
        }
        for (int j = 0; j < colNum; ++j) {
            this.widths_.put(new Integer(j), new Double(0.0));
        }
        for (i = 0; i < rowNum; ++i) {
            double maxHeight = (Double)this.heights_.get(new Integer(i));
            for (int j = 0; j < colNum; ++j) {
                String nodeID = this.grid_.getCellValue(i, j);
                if (nodeID == null || nodeID.equals(ignoreID)) continue;
                Node node = genome.getNode(nodeID);
                NodeProperties np = lo.getNodeProperties(nodeID);
                INodeRenderer rend = np.getRenderer();
                Rectangle2D useRect = TrackedGrid.layoutBounds(genome, lo, frc, nodeID, textToo);
                holdBounds.put(node.getID(), useRect);
                double width = useRect.getWidth();
                width += 40.0;
                double height = rend.getGlyphHeightForLayout(genome, node, lo, frc);
                height += 40.0;
                width = UiUtil.forceToGridValueMax(width, 10.0);
                height = UiUtil.forceToGridValueMax(height, 10.0);
                double maxWidth = (Double)this.widths_.get(new Integer(j));
                if (width > maxWidth) {
                    this.widths_.put(new Integer(j), new Double(width));
                }
                if (!(height > maxHeight)) continue;
                maxHeight = height;
                this.heights_.put(new Integer(i), new Double(height));
            }
        }
        double totalHeight = 0.0;
        double totalWidth = 0.0;
        for (int i2 = 0; i2 < rowNum; ++i2) {
            totalHeight += ((Double)this.heights_.get(new Integer(i2))).doubleValue();
        }
        for (int j = 0; j < colNum; ++j) {
            totalWidth += ((Double)this.widths_.get(new Integer(j))).doubleValue();
        }
        retval.setSize(totalWidth, totalHeight);
        return retval;
    }

    private double calcExactVerticalOffset(Genome genome, Layout lo, FontRenderContext frc, String coreID) {
        if (!this.grid_.contains(coreID)) {
            return 0.0;
        }
        HashMap<Integer, Double> rowAllotment = new HashMap<Integer, Double>();
        Iterator rtit = this.rowTracks_.keySet().iterator();
        while (rtit.hasNext()) {
            Integer rowKey = (Integer)rtit.next();
            if (rowKey == 0) continue;
            TreeMap trackMap = (TreeMap)this.rowTracks_.get(rowKey);
            int numTracks = trackMap.size();
            double height = (double)numTracks * 10.0;
            rowAllotment.put(rowKey, new Double(height));
        }
        Grid.RowAndColumn coreRC = this.grid_.findPositionRandC(coreID);
        double nodeTotal = 0.0;
        for (int i = 0; i < coreRC.row; ++i) {
            double rowHeight = (Double)this.heights_.get(new Integer(i));
            nodeTotal += rowHeight;
            Double rowHeightObj = (Double)rowAllotment.get(new Integer(i));
            double rowHeightTracks = rowHeightObj == null ? 0.0 : rowHeightObj;
            nodeTotal += rowHeightTracks;
        }
        double halfHeight = (Double)this.heights_.get(new Integer(coreRC.row)) / 2.0;
        Double rowHeightObj = (Double)rowAllotment.get(new Integer(coreRC.row));
        double rowHeightTracks = rowHeightObj == null ? 0.0 : rowHeightObj;
        halfHeight += rowHeightTracks;
        halfHeight = UiUtil.forceToGridValue(halfHeight, 10.0);
        nodeTotal += halfHeight;
        INodeRenderer rend = lo.getNodeProperties(coreID).getRenderer();
        Node srcNode = genome.getNode(coreID);
        int launch = TrackedGrid.launchForGrid(coreID, genome);
        Vector2D lpOffset = rend.getLaunchPadOffset(launch, srcNode, lo, frc);
        double stOffset = rend.getStraightThroughOffset();
        return nodeTotal - lpOffset.getY() - stOffset;
    }

    public class RCTrack
    implements Cloneable {
        public static final int NO_TRACK = Integer.MIN_VALUE;
        public static final int COLUMN_MIDLINE = 0;
        public static final int ROW_MIDLINE = 1;
        public static final int NONE_FIXED = 0;
        public static final int Y_FIXED = 1;
        public static final int X_FIXED = 2;
        public static final int Y_FLOATS = 3;
        public static final int X_FLOATS = 4;
        public static final int COL_SPEC = 0;
        public static final int ROW_SPEC = 1;
        private static final int COPY_COL_ = 0;
        private static final int COPY_ROW_ = 1;
        private static final int COPY_BOTH_ = 2;
        private TrackSpec row_;
        private TrackSpec col_;
        private int colPadNum_;
        private String colNodeID_;
        private String colLinkID_;
        private boolean colIsLanding_;
        private int rowNum_;
        private int rowPadNum_;
        private String rowNodeID_;
        private String rowLinkID_;
        private boolean rowIsLanding_;
        private int colNum_;
        private int linkSign_;
        private double fixedX_;
        private double fixedY_;
        private int whichFixed_;

        public RCTrack(RCTrack other, TrackSpec spec, int whichSpec) {
            this.copyGuts(other, 2);
            if (whichSpec == 0) {
                this.col_ = spec;
            } else if (whichSpec == 1) {
                this.row_ = spec;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public RCTrack(TrackSpec row, TrackSpec col) {
            this.row_ = row;
            this.col_ = col;
            this.whichFixed_ = 0;
            this.rowNum_ = Integer.MIN_VALUE;
            this.colNum_ = Integer.MIN_VALUE;
        }

        public RCTrack(RCTrack other, int whichFixed, double fixValue) {
            this.copyGuts(other, 2);
            if (this.whichFixed_ != 0) {
                throw new IllegalArgumentException();
            }
            this.whichFixed_ = whichFixed;
            if (whichFixed == 2) {
                this.col_ = null;
                this.fixedX_ = fixValue;
                this.fixedY_ = Double.NaN;
            } else if (whichFixed == 1) {
                this.row_ = null;
                this.fixedX_ = Double.NaN;
                this.fixedY_ = fixValue;
            } else {
                throw new IllegalArgumentException();
            }
            this.rowNum_ = Integer.MIN_VALUE;
            this.colNum_ = Integer.MIN_VALUE;
        }

        public RCTrack(RCTrack other, int whichFixed) {
            this.copyGuts(other, 2);
            if (this.whichFixed_ != 0) {
                throw new IllegalArgumentException();
            }
            this.whichFixed_ = whichFixed;
            if (whichFixed == 4) {
                this.col_ = null;
                this.fixedX_ = Double.NEGATIVE_INFINITY;
                this.fixedY_ = Double.NaN;
            } else if (whichFixed == 3) {
                this.row_ = null;
                this.fixedX_ = Double.NaN;
                this.fixedY_ = Double.NEGATIVE_INFINITY;
            } else {
                throw new IllegalArgumentException();
            }
            this.rowNum_ = Integer.MIN_VALUE;
            this.colNum_ = Integer.MIN_VALUE;
        }

        public RCTrack(RCTrack rowOther, RCTrack colOther) {
            this.copyGuts(rowOther, 1);
            this.copyGuts(colOther, 0);
        }

        public RCTrack copyWithNewColPadNum(int padNum, String linkID) {
            RCTrack retval = (RCTrack)this.clone();
            retval.colPadNum_ = padNum;
            retval.colLinkID_ = linkID;
            return retval;
        }

        public RCTrack(TrackSpec spec, int whichMidline, int padNum, String nodeID, String linkID, boolean isLanding, int linkSign, int trackNum) {
            this.whichFixed_ = 0;
            if (whichMidline == 0) {
                this.row_ = spec;
                this.col_ = null;
                this.colPadNum_ = padNum;
                this.colNodeID_ = nodeID;
                this.colLinkID_ = linkID;
                this.colIsLanding_ = isLanding;
                this.colNum_ = trackNum;
                this.rowNum_ = Integer.MIN_VALUE;
            } else if (whichMidline == 1) {
                this.row_ = null;
                this.col_ = spec;
                this.rowPadNum_ = padNum;
                this.rowLinkID_ = linkID;
                this.rowNodeID_ = nodeID;
                this.rowIsLanding_ = isLanding;
                this.rowNum_ = trackNum;
                this.colNum_ = Integer.MIN_VALUE;
            } else {
                throw new IllegalArgumentException();
            }
            this.linkSign_ = linkSign;
        }

        public RCTrack(RCTrack other, int whichMidline, int padNum, String nodeID, String linkID, boolean isLanding, int linkSign, int trackNum) {
            this.copyGuts(other, 2);
            if (whichMidline == 0) {
                if (this.whichFixed_ == 2 || this.whichFixed_ == 4) {
                    this.whichFixed_ = 0;
                }
                this.col_ = null;
                this.colPadNum_ = padNum;
                this.colNodeID_ = nodeID;
                this.colLinkID_ = linkID;
                this.colIsLanding_ = isLanding;
                this.colNum_ = trackNum;
                this.rowNum_ = Integer.MIN_VALUE;
            } else if (whichMidline == 1) {
                if (this.whichFixed_ == 1 || this.whichFixed_ == 3) {
                    this.whichFixed_ = 0;
                }
                this.row_ = null;
                this.rowPadNum_ = padNum;
                this.rowLinkID_ = linkID;
                this.rowNodeID_ = nodeID;
                this.rowIsLanding_ = isLanding;
                this.rowNum_ = trackNum;
                this.colNum_ = Integer.MIN_VALUE;
            } else {
                throw new IllegalArgumentException();
            }
            this.linkSign_ = linkSign;
        }

        public RCTrack(int colPadNum, String colNodeID, boolean colIsLanding, int rowPadNum, String rowNodeID, boolean rowIsLanding, int linkSign, String linkID, int colNum, int rowNum) {
            this.whichFixed_ = 0;
            this.colPadNum_ = colPadNum;
            this.colNodeID_ = colNodeID;
            this.colLinkID_ = linkID;
            this.colIsLanding_ = colIsLanding;
            this.rowPadNum_ = rowPadNum;
            this.rowNodeID_ = rowNodeID;
            this.rowLinkID_ = linkID;
            this.rowIsLanding_ = rowIsLanding;
            this.linkSign_ = linkSign;
            this.colNum_ = colNum;
            this.rowNum_ = rowNum;
        }

        private void copyGuts(RCTrack other, int which) {
            this.whichFixed_ = other.whichFixed_;
            this.linkSign_ = other.linkSign_;
            if (which == 2 || which == 1) {
                this.row_ = other.row_ == null ? null : (TrackSpec)other.row_.clone();
                this.fixedY_ = other.fixedY_;
                this.rowPadNum_ = other.rowPadNum_;
                this.rowNodeID_ = other.rowNodeID_;
                this.rowLinkID_ = other.rowLinkID_;
                this.rowIsLanding_ = other.rowIsLanding_;
                this.rowNum_ = other.rowNum_;
            }
            if (which == 2 || which == 0) {
                this.col_ = other.col_ == null ? null : (TrackSpec)other.col_.clone();
                this.fixedX_ = other.fixedX_;
                this.colPadNum_ = other.colPadNum_;
                this.colNodeID_ = other.colNodeID_;
                this.colLinkID_ = other.colLinkID_;
                this.colIsLanding_ = other.colIsLanding_;
                this.colNum_ = other.colNum_;
            }
        }

        public int rowCompare(RCTrack other) {
            if (this.row_ != null) {
                if (other.row_ != null) {
                    return this.row_.compareTo(other.row_);
                }
                if (other.rowNum_ != Integer.MIN_VALUE) {
                    int diff = this.row_.major - other.rowNum_;
                    if (diff != 0) {
                        return diff;
                    }
                    return -1;
                }
                throw new IllegalStateException();
            }
            if (this.rowNum_ != Integer.MIN_VALUE) {
                if (other.row_ != null) {
                    int diff = this.rowNum_ - other.row_.major;
                    if (diff != 0) {
                        return diff;
                    }
                    return 1;
                }
                if (other.rowNum_ != Integer.MIN_VALUE) {
                    return this.rowNum_ - other.rowNum_;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return "RCTrack: r=" + this.row_ + " c=" + this.col_ + " which= " + this.whichFixed_ + " colNum = " + this.colNum_ + " rowNum = " + this.rowNum_ + " colPadNum = " + this.colPadNum_ + " rowPadNum = " + this.rowPadNum_;
        }

        public int whichFixed() {
            return this.whichFixed_;
        }

        public double getFixedValue(int whichFixed) {
            if (whichFixed != this.whichFixed_) {
                throw new IllegalArgumentException();
            }
            if (whichFixed == 2) {
                return this.fixedX_;
            }
            if (whichFixed == 1) {
                return this.fixedY_;
            }
            throw new IllegalArgumentException();
        }

        public TrackSpec getRow() {
            if (this.row_ == null) {
                throw new IllegalStateException();
            }
            return this.row_;
        }

        public TrackSpec getCol() {
            if (this.col_ == null) {
                throw new IllegalStateException();
            }
            return this.col_;
        }

        public int getColPadNum() {
            return this.colPadNum_;
        }

        public int getRowPadNum() {
            return this.rowPadNum_;
        }

        public Object clone() {
            try {
                RCTrack retval = (RCTrack)super.clone();
                retval.row_ = this.row_ == null ? null : (TrackSpec)this.row_.clone();
                retval.col_ = this.col_ == null ? null : (TrackSpec)this.col_.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public boolean isMyGrid(TrackedGrid grid) {
            return TrackedGrid.this == grid;
        }

        public Point2D convert(Point2D upperLeft, Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, String coreID, double fixFloating) {
            Point2D padPt;
            int colNum = TrackedGrid.this.grid_.getNumCols();
            if (colNum == 0) {
                return (Point2D)upperLeft.clone();
            }
            int rowNum = TrackedGrid.this.grid_.getNumRows();
            if (this.col_ != null && this.col_.major > colNum) {
                throw new IllegalArgumentException();
            }
            if (this.row_ != null && this.row_.major > rowNum) {
                throw new IllegalArgumentException();
            }
            Point2D trackRoot = this.getTrackRoot(upperLeft, positions, lo, coreID);
            double trackX = trackRoot.getX();
            double trackY = trackRoot.getY();
            if (this.row_ != null) {
                trackY += (double)this.row_.minor * 10.0;
            }
            if (this.col_ != null) {
                trackX += (double)this.col_.minor * 10.0;
            }
            Point2D.Double retval = new Point2D.Double(trackX, trackY);
            if (this.row_ == null) {
                double yVal;
                if (this.whichFixed_ == 1) {
                    yVal = this.fixedY_;
                } else if (this.whichFixed_ == 3) {
                    yVal = fixFloating;
                } else {
                    padPt = this.padPoint(positions, padChanges, genome, lo, frc, 1);
                    yVal = padPt.getY();
                }
                ((Point2D)retval).setLocation(((Point2D)retval).getX(), yVal);
            }
            if (this.col_ == null) {
                double xVal;
                if (this.whichFixed_ == 2) {
                    xVal = this.fixedX_;
                } else if (this.whichFixed_ == 4) {
                    if (this.colPadNum_ != 0) {
                        throw new IllegalArgumentException();
                    }
                    xVal = fixFloating;
                } else {
                    padPt = this.padPoint(positions, padChanges, genome, lo, frc, 0);
                    xVal = padPt.getX();
                }
                ((Point2D)retval).setLocation(xVal, ((Point2D)retval).getY());
            }
            UiUtil.forceToGrid(retval, 10.0);
            return retval;
        }

        private Point2D padPoint(Map positions, Map padChanges, Genome genome, Layout lo, FontRenderContext frc, int whichMidline) {
            boolean isLanding;
            int padNum;
            String linkID;
            String nodeID;
            if (whichMidline == 1) {
                nodeID = this.rowNodeID_;
                linkID = this.rowLinkID_;
                padNum = this.rowPadNum_;
                isLanding = this.rowIsLanding_;
            } else if (whichMidline == 0) {
                nodeID = this.colNodeID_;
                linkID = this.colLinkID_;
                padNum = this.colPadNum_;
                isLanding = this.colIsLanding_;
            } else {
                throw new IllegalArgumentException();
            }
            padNum = isLanding ? this.getCurrentLandingPad(linkID, padNum, padChanges) : this.getCurrentLaunchPad(linkID, padNum, padChanges);
            Point2D nodeLoc = (Point2D)positions.get(nodeID);
            Vector2D offset = isLanding ? TrackedGrid.landingPadToOffset(padNum, genome, lo, frc, nodeID, this.linkSign_) : TrackedGrid.launchPadToOffset(padNum, genome, lo, frc, nodeID);
            return offset.add(nodeLoc);
        }

        private int getCurrentLandingPad(String linkID, int oldPad, Map padChanges) {
            PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)padChanges.get(linkID);
            return pres == null ? oldPad : pres.landing;
        }

        private int getCurrentLaunchPad(String linkID, int oldPad, Map padChanges) {
            PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)padChanges.get(linkID);
            return pres == null ? oldPad : pres.launch;
        }

        private Point2D getTrackRoot(Point2D upperLeft, Map positions, Layout lo, String coreID) {
            NodeProperties np;
            Point2D pos;
            String nodeID;
            int j;
            double xVal = upperLeft.getX();
            double yVal = upperLeft.getY();
            if (this.row_ != null) {
                if (this.row_.major == 0) {
                    yVal = upperLeft.getY();
                    Integer key = new Integer(0);
                    TreeMap trackMap = (TreeMap)TrackedGrid.this.rowTracks_.get(key);
                    int numTracks = trackMap.size();
                    yVal -= (double)numTracks * 10.0;
                } else {
                    int prevRow = this.row_.major - 1;
                    int maxCol = TrackedGrid.this.grid_.getNumCols();
                    for (j = 0; j < maxCol; ++j) {
                        nodeID = TrackedGrid.this.grid_.getCellValue(prevRow, j);
                        if (nodeID == null || nodeID.equals(coreID)) continue;
                        pos = (Point2D)positions.get(nodeID);
                        np = lo.getNodeProperties(nodeID);
                        INodeRenderer rend = np.getRenderer();
                        double yOffset = rend.getStraightThroughOffset();
                        double centerY = pos.getY() - yOffset;
                        double rowHeight = (Double)TrackedGrid.this.heights_.get(new Integer(prevRow));
                        yVal = centerY + (rowHeight -= 40.0) / 2.0 + 10.0;
                        yVal = UiUtil.forceToGridValueMax(yVal, 10.0);
                        break;
                    }
                }
            }
            if (this.col_ != null) {
                if (this.col_.major == 0) {
                    xVal = upperLeft.getX();
                } else {
                    int prevCol = this.col_.major - 1;
                    int maxRow = TrackedGrid.this.grid_.getNumRows();
                    for (j = 0; j < maxRow; ++j) {
                        nodeID = TrackedGrid.this.grid_.getCellValue(j, prevCol);
                        if (nodeID == null || nodeID.equals(coreID)) continue;
                        pos = (Point2D)positions.get(nodeID);
                        np = lo.getNodeProperties(nodeID);
                        Rectangle2D forCell = (Rectangle2D)TrackedGrid.this.cellBounds_.get(nodeID);
                        INodeRenderer rend = np.getRenderer();
                        double xOffset = rend.getVerticalOffset();
                        double centerX = pos.getX() - xOffset;
                        double colWidth = (Double)TrackedGrid.this.widths_.get(new Integer(prevCol));
                        xVal = centerX + forCell.getCenterX() + (colWidth -= 40.0) / 2.0 + 10.0;
                        xVal = UiUtil.forceToGridValueMax(xVal, 10.0);
                        break;
                    }
                }
            }
            return new Point2D.Double(xVal, yVal);
        }
    }

    public static class TrackSpec
    implements Cloneable,
    Comparable {
        public int major;
        public int minor;

        public TrackSpec(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            return "TrackSpec: maj=" + this.major + " min=" + this.minor;
        }

        public Object clone() {
            try {
                return (TrackSpec)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int compareTo(Object o) {
            TrackSpec other = (TrackSpec)o;
            if (this.major > other.major) {
                return 1;
            }
            if (this.major < other.major) {
                return -1;
            }
            if (this.minor > other.minor) {
                return 1;
            }
            if (this.minor < other.minor) {
                return -1;
            }
            return 0;
        }
    }

    public static class TrackPosRC
    extends SpecialtyLayoutLinkData.TrackPos {
        private RCTrack rcTrack;

        public TrackPosRC(RCTrack rcTrack) {
            super(null);
            this.rcTrack = (RCTrack)rcTrack.clone();
        }

        public Object clone() {
            TrackPosRC retval = (TrackPosRC)super.clone();
            retval.rcTrack = (RCTrack)this.rcTrack.clone();
            return retval;
        }

        public RCTrack getRCTrack() {
            return this.rcTrack;
        }

        public void fixLocation(Point2D point) {
            this.point = (Point2D)point.clone();
        }

        public String toString() {
            return super.toString() + " rcTrack = " + this.rcTrack;
        }
    }
}

