/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import org.systemsbiology.biotapestry.analysis.CycleFinder;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.analysis.NodeGrouper;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.layouts.ClusterSeries;
import org.systemsbiology.biotapestry.ui.layouts.GeneAndSatelliteCluster;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.MetaClusterPointSource;
import org.systemsbiology.biotapestry.ui.layouts.RowBuilder;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayout;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutData;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParamDialog;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.ui.layouts.SuperSrcRouterPointSource;
import org.systemsbiology.biotapestry.ui.layouts.WorksheetLayoutSetupDialog;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class WorksheetLayout
implements SpecialtyLayout {
    private static final double INTER_TARGET_PAD_ = 100.0;
    private static final double LAST_TRACK_TO_TARGET_PAD_ = 200.0;
    private static final double LAST_CLUST_TO_TRACK_PAD_ = 20.0;
    private static final int TARGS_BY_TIME_ = 0;
    private static final int TARGS_BY_ALPHA_ = 1;
    private static final int TARGS_BY_INPUTS_ = 2;
    private static final int NUM_TARG_TYPES_ = 3;
    private static final String TARGS_BY_TIME_TAG_ = "targByTime";
    private static final String TARGS_BY_ALPHA_TAG_ = "targByAlpha";
    private static final String TARGS_BY_INPUTS_TAG_ = "targByInputs";
    private static final int SRCS_BY_TIME_ = 0;
    private static final int SRCS_BY_SORT_ = 1;
    private static final int SRCS_BY_SINGLE_ = 2;
    private static final int NUM_SRC_TYPES_ = 3;
    private static final String SRCS_BY_TIME_TAG_ = "srcsByTime";
    private static final String SRCS_BY_SORT_TAG_ = "srcsBySort";
    private static final String SRCS_BY_SINGLE_TAG_ = "srcsBySingle";
    public static final int SINGLE_CLUSTER_MODE = 2;
    private boolean forDiagonal_;
    private SpecialtyLayoutData sld_;
    private ClusterSeries series_;
    private TreeMap tracesPerRow_;
    private HashMap basePerRow_;
    private int numRows_;
    private List termClusters_;
    private double rightBound_;
    private TreeMap clustPerRow_;
    private double rightmostTrack_;

    public WorksheetLayout(boolean forDiagonal) {
        this.forDiagonal_ = forDiagonal;
    }

    public SpecialtyLayout forkForSubset(SpecialtyLayoutData sld) {
        WorksheetLayout retval = new WorksheetLayout(this.forDiagonal_);
        retval.sld_ = sld;
        return retval;
    }

    public String setUpIsOK() {
        return null;
    }

    public String getMenuName() {
        return ResourceManager.getManager().getString(this.forDiagonal_ ? "command.WorksheetDiagLayout" : "command.WorksheetLayout");
    }

    public char getMenuMnemonic() {
        return ResourceManager.getManager().getChar(this.forDiagonal_ ? "command.WorksheetDiagLayoutMnem" : "command.WorksheetLayoutMnem");
    }

    public boolean selectionIsValid(Genome genome, String selected) {
        return false;
    }

    public int topologyIsHandled(Genome genome) {
        return 0;
    }

    public void layoutNodes(BTProgressMonitor monitor, Map padChanges, SortedMap existingOrder) throws AsynchExitRequestException {
        GeneAndSatelliteCluster tc;
        int i;
        SortedMap tClustRows;
        this.sld_.results = new SpecialtyInstructions(padChanges);
        this.sld_.gASCs = new ArrayList();
        Map placement = this.sld_.results.nodeLocations;
        Map orientChanges = this.sld_.results.orientChanges;
        Map extraGrowthChanges = this.sld_.results.extraGrowthChanges;
        Map lengthChanges = this.sld_.results.lengthChanges;
        Genome baseGenome = this.sld_.genome;
        WorksheetLayoutParams wlp = (WorksheetLayoutParams)this.sld_.param;
        int targGroups = wlp.targGroups;
        int targSize = wlp.targSize;
        int srcGroups = wlp.srcGroups;
        int srcSize = wlp.srcSize;
        double traceOffset = (double)wlp.traceMult * 10.0;
        Set nodeSet = DataUtil.setFromIterator(this.sld_.subset.getNodeIterator());
        if (nodeSet.isEmpty()) {
            this.sld_.results = null;
            return;
        }
        HashSet<Link> linkSet = new HashSet<Link>();
        Iterator lit = this.sld_.subset.getLinkageIterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage link = baseGenome.getLinkage(linkID);
            String trg = link.getTarget();
            String src = link.getSource();
            Link cfl = new Link(src, trg);
            linkSet.add(cfl);
            CycleFinder cf = new CycleFinder(nodeSet, linkSet);
            if (!cf.hasACycle()) continue;
            linkSet.remove(cfl);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        GraphSearcher gs = new GraphSearcher(nodeSet, linkSet);
        Map queue = gs.topoSort(false);
        List nodeRanking = gs.topoSortToPartialOrdering(queue);
        Collections.reverse(nodeRanking);
        NodeGrouper ng = new NodeGrouper(this.sld_.subset, nodeRanking);
        Map groups = ng.buildGroups();
        List ttGroups = ng.findTerminalTargetsByGroups(groups);
        int numTClust = ttGroups.size();
        this.termClusters_ = GeneAndSatelliteCluster.fillTargetClustersByGroups(baseGenome, ttGroups, groups, this.sld_.lo, this.sld_.frc, traceOffset, true, false);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        RowBuilder builder = new RowBuilder();
        if (targGroups == 0) {
            tClustRows = builder.assignRowsByTime(this.termClusters_, targSize, null);
        } else if (targGroups == 1) {
            tClustRows = builder.assignRowsByAlpha(this.termClusters_, baseGenome, targSize, null);
        } else if (targGroups == 2) {
            tClustRows = builder.assignRowsByInputs(this.termClusters_, baseGenome, targSize, true, null);
        } else {
            throw new IllegalArgumentException();
        }
        ArrayList sClustList = new ArrayList();
        this.findSources(baseGenome, this.termClusters_, groups, sClustList, traceOffset, wlp.textToo);
        int numSClust = sClustList.size();
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.series_ = new ClusterSeries(false, wlp.traceMult);
        if (srcGroups == 0) {
            this.series_ = this.buildClusterSeriesByTime(sClustList, wlp.traceMult);
        } else if (srcGroups == 1) {
            this.series_ = this.buildClusterSeriesBySort(sClustList, queue, srcSize, wlp.traceMult);
        } else if (srcGroups == 2) {
            this.series_ = this.buildClusterSeriesBySingle(sClustList, wlp.traceMult);
        }
        this.series_.addPreAndPost(this.sld_.subset);
        this.series_.prepForSingle(this.sld_.subset, this.sld_.lo, this.sld_.frc);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        Point2D center = (Point2D)this.sld_.subset.getPreferredCenter().clone();
        UiUtil.forceToGrid(center, 10.0);
        Point2D rightEnd = this.series_.locate(center, placement, baseGenome, this.sld_.lo, this.sld_.frc, null);
        this.numRows_ = tClustRows.size();
        double rightX = rightEnd.getX();
        int trackCount = this.series_.trackCount();
        this.rightmostTrack_ = rightX + 20.0;
        if (this.numRows_ > 1) {
            this.rightmostTrack_ += (double)trackCount * 20.0;
        } else {
            int rmlo = this.series_.getRightmostOutboundLinkOrderMax();
            this.rightmostTrack_ += (double)rmlo * 20.0;
        }
        this.clustPerRow_ = new TreeMap();
        this.tracesPerRow_ = new TreeMap();
        this.basePerRow_ = new HashMap();
        this.rightBound_ = this.placeTargetClusterNodes(this.sld_.subset, this.series_, baseGenome, this.sld_.lo, this.sld_.frc, tClustRows, this.clustPerRow_, this.tracesPerRow_, this.basePerRow_, placement, traceOffset, this.rightmostTrack_, monitor);
        List srcOrder = this.series_.getSourceTrackOrder();
        for (i = 0; i < numTClust; ++i) {
            tc = (GeneAndSatelliteCluster)this.termClusters_.get(i);
            tc.calcPadChanges(this.sld_.subset, srcOrder, padChanges, lengthChanges, extraGrowthChanges);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        for (i = 0; i < numTClust; ++i) {
            tc = (GeneAndSatelliteCluster)this.termClusters_.get(i);
            tc.calcOrientChanges(baseGenome, this.sld_.lo, orientChanges);
        }
        for (i = 0; i < numSClust; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            sc.calcOrientChanges(baseGenome, this.sld_.lo, orientChanges);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.sld_.gASCs.addAll(this.termClusters_);
        this.sld_.gASCs.addAll(sClustList);
    }

    public void routeLinks(SpecialtyLayoutEngine.GlobalSLEState gsles, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.sld_.results == null) {
            return;
        }
        Map traceOrderPerRow = this.calcTracesPerRow(this.series_, this.tracesPerRow_, this.basePerRow_, this.numRows_, monitor);
        HashMap traceDefs = new HashMap();
        this.series_.routeLinks(this.sld_.subset, this.sld_.results.padChanges, this.sld_.results.lengthChanges, this.sld_.results.extraGrowthChanges, this.sld_.lo, this.sld_.frc, this.sld_.results.nodeLocations, this.sld_.results, traceDefs);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.targetInternalRouting(this.sld_.genome, this.sld_.lo, this.sld_.frc, this.termClusters_, this.sld_.results.nodeLocations, this.sld_.results.padChanges, this.sld_.results, monitor);
        this.layoutTargetLinks(this.sld_.genome, this.sld_.subset, this.sld_.lo, this.sld_.frc, this.series_, traceDefs, this.sld_.results.nodeLocations, this.sld_.results.padChanges, this.sld_.results, this.clustPerRow_, traceOrderPerRow, this.numRows_, this.rightmostTrack_, this.rightBound_, monitor);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
    }

    public void assignColors(BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.sld_.results == null) {
            return;
        }
        this.sld_.results.assignColorsAfterLayout = ((WorksheetLayoutParams)this.sld_.param).assignColors;
    }

    private void layoutTargetLinks(Genome genome, GenomeSubset subset, Layout lo, FontRenderContext frc, ClusterSeries series, Map traceDefs, Map placement, Map padChanges, SpecialtyInstructions si, SortedMap clustPerRow, Map traceOrderPerRow, int numRows, double rightmostTrack, double rightBound, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Iterator lmpkit = traceDefs.keySet().iterator();
        while (lmpkit.hasNext()) {
            String srcID = (String)lmpkit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            SuperSrcRouterPointSource lmp = (SuperSrcRouterPointSource)traceDefs.get(srcID);
            if (lmp.getTrace() == null) continue;
            SpecialtyLayoutLinkData sin = si.getLinkPointsForSrc(srcID);
            if (sin == null) {
                sin = new SpecialtyLayoutLinkData(srcID);
                si.setLinkPointsForSrc(srcID, sin);
            }
            MetaClusterPointSource lps = new MetaClusterPointSource(srcID, lmp, 0);
            int tracknum = series.getTrackIndexForSource(srcID);
            double tdrX = numRows > 1 ? rightmostTrack - (double)tracknum * 20.0 : rightmostTrack;
            lps.initializeTargetDropRoot(new Point2D.Double(tdrX, lmp.getTrace().getY()));
            Iterator cphit = clustPerRow.keySet().iterator();
            if (clustPerRow.isEmpty()) {
                double yVal = lmp.getTrace().getY();
                lps.initTargetDropRow(yVal, numRows == 1);
                lps.setTargetTraceY(yVal);
                Set outLinks = subset.getLinksHeadedOutForSource(srcID);
                if (outLinks.isEmpty()) continue;
                this.handleExternalTargetLinks(outLinks, sin, lps, genome, lo, frc, placement, padChanges, rightBound);
                continue;
            }
            while (cphit.hasNext()) {
                Set outLinks;
                Integer rowNum = (Integer)cphit.next();
                double yVal = 0.0;
                if (numRows > 1) {
                    Double srcY;
                    Map srcToY = (Map)traceOrderPerRow.get(rowNum);
                    if (srcToY == null || (srcY = (Double)srcToY.get(srcID)) == null) continue;
                    yVal = srcY;
                } else {
                    yVal = lmp.getTrace().getY();
                }
                lps.initTargetDropRow(yVal, numRows == 1);
                lps.setTargetTraceY(yVal);
                List perRow = (List)clustPerRow.get(rowNum);
                int numPerRow = perRow.size();
                for (int i = 0; i < numPerRow; ++i) {
                    if (monitor != null && !monitor.keepGoing()) {
                        throw new AsynchExitRequestException();
                    }
                    GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)perRow.get(i);
                    tc.inboundLinkRouting(srcID, genome, lo, frc, placement, padChanges, sin, lps, false);
                }
                if (rowNum == 0 && !(outLinks = subset.getLinksHeadedOutForSource(srcID)).isEmpty()) {
                    this.handleExternalTargetLinks(outLinks, sin, lps, genome, lo, frc, placement, padChanges, rightBound);
                }
                lps.closeOutTargetDropRow();
            }
        }
    }

    private void handleExternalTargetLinks(Set outLinks, SpecialtyLayoutLinkData sin, MetaClusterPointSource lps, Genome genome, Layout lo, FontRenderContext frc, Map placement, Map padChanges, double rightBound) {
        boolean dontCare = false;
        Iterator goit = outLinks.iterator();
        boolean isFirst = true;
        while (goit.hasNext()) {
            String linkID = (String)goit.next();
            if (sin.haveLink(linkID)) {
                throw new IllegalStateException();
            }
            sin.startNewLink(linkID);
            if (isFirst) {
                lps.buildPrePath(sin, linkID, lps.getTargetDropRoot(), dontCare, placement, padChanges, genome, lo, frc, dontCare, dontCare);
                sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(lps.getLastLeftPoint()));
                isFirst = false;
            }
            Point2D.Double launch = new Point2D.Double(rightBound, lps.getLastLeftPoint().getY());
            sin.addPositionToLink(linkID, new SpecialtyLayoutLinkData.TrackPos(launch));
            sin.setBorderPosition(0, (Point2D)launch.clone());
            sin.setBorderPosition(1, (Point2D)launch.clone());
            sin.setBorderPosition(2, (Point2D)launch.clone());
            sin.setBorderPosition(3, (Point2D)launch.clone());
        }
    }

    private void targetInternalRouting(Genome genome, Layout lo, FontRenderContext frc, List termClusters, Map placement, Map padChanges, SpecialtyInstructions si, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int numTClust = termClusters.size();
        for (int i = 0; i < numTClust; ++i) {
            GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)termClusters.get(i);
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            Map sinMap = tc.internalLinkRoutingForTarget(genome, lo, frc, placement, padChanges);
            Iterator smit = sinMap.keySet().iterator();
            while (smit.hasNext()) {
                String srcID = (String)smit.next();
                SpecialtyLayoutLinkData sin = (SpecialtyLayoutLinkData)sinMap.get(srcID);
                if (si.hasLinkPointsForSrc(srcID)) {
                    SpecialtyLayoutLinkData sinlp = si.getLinkPointsForSrc(srcID);
                    sinlp.merge(sin);
                    continue;
                }
                si.setLinkPointsForSrc(srcID, sin);
            }
        }
    }

    private Map calcTracesPerRow(ClusterSeries series, SortedMap tracesPerRow, Map basePerRow, int numRows, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Iterator tprkit = tracesPerRow.keySet().iterator();
        HashMap traceOrderPerRow = new HashMap();
        while (tprkit.hasNext()) {
            Integer row = (Integer)tprkit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            Set traces = (Set)tracesPerRow.get(row);
            Double baseForThisRow = (Double)basePerRow.get(row);
            TreeMap sortByTrace = new TreeMap(Collections.reverseOrder());
            Iterator trit = traces.iterator();
            while (trit.hasNext()) {
                String srcID = (String)trit.next();
                if (!series.hasTrackForSource(srcID)) continue;
                int tracknum = series.getTrackForSource(srcID);
                sortByTrace.put(new Integer(tracknum), srcID);
            }
            if (numRows <= 1) continue;
            HashMap<String, Double> srcToY = new HashMap<String, Double>();
            traceOrderPerRow.put(row, srcToY);
            Iterator sbit = sortByTrace.keySet().iterator();
            int currTrace = 0;
            while (sbit.hasNext()) {
                Integer traceNum = (Integer)sbit.next();
                String srcID = (String)sortByTrace.get(traceNum);
                Double yObj = new Double(baseForThisRow - (double)currTrace++ * 20.0);
                srcToY.put(srcID, yObj);
            }
        }
        return traceOrderPerRow;
    }

    private double placeTargetClusterNodes(GenomeSubset subset, ClusterSeries series, Genome genome, Layout lo, FontRenderContext frc, SortedMap tClustRows, SortedMap clustPerRow, SortedMap tracesPerRow, Map basePerRow, Map placement, double traceOffset, double rightmostTrack, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Set allSrcs = series.getAllSources();
        int numRows = tClustRows.size();
        double rightY = series.getLowestTraceY();
        Point2D.Double base = new Point2D.Double(rightmostTrack + 200.0, rightY);
        double currY = rightY;
        double maxXVal = ((Point2D)base).getX();
        Iterator hit = tClustRows.keySet().iterator();
        int currRowNum = 0;
        while (hit.hasNext()) {
            Integer rowKey = (Integer)hit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            List perRow = (List)tClustRows.get(rowKey);
            int numPerRow = perRow.size();
            Integer currRowNumObj = new Integer(currRowNum);
            clustPerRow.put(currRowNumObj, perRow);
            HashSet<String> traces = (HashSet<String>)tracesPerRow.get(currRowNumObj);
            if (traces == null) {
                traces = new HashSet<String>();
                tracesPerRow.put(currRowNumObj, traces);
            }
            for (int i = 0; i < numPerRow; ++i) {
                GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)perRow.get(i);
                Iterator asit = allSrcs.iterator();
                while (asit.hasNext()) {
                    String srcID = (String)asit.next();
                    if (!tc.isATarget(srcID)) continue;
                    traces.add(srcID);
                }
            }
            if (currRowNum == 0) {
                traces.addAll(subset.getSourcesHeadedOut());
            }
            TreeMap sortByTrace = new TreeMap(Collections.reverseOrder());
            Iterator trit = traces.iterator();
            while (trit.hasNext()) {
                String srcID = (String)trit.next();
                if (!series.hasTrackForSource(srcID)) continue;
                int tracknum = series.getTrackForSource(srcID);
                sortByTrace.put(new Integer(tracknum), srcID);
            }
            ArrayList traceOrder = new ArrayList(sortByTrace.values());
            double maxTargetHeightForRow = 0.0;
            for (int i = 0; i < numPerRow; ++i) {
                GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)perRow.get(i);
                tc.orderByTraceOrder(traceOrder, genome);
                GeneAndSatelliteCluster.ClusterDims oh = tc.getClusterDims(genome, lo, frc);
                double needs = oh.getFullHeightIncrement();
                if (!(needs > maxTargetHeightForRow)) continue;
                maxTargetHeightForRow = needs;
            }
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            Double maxTargetHeightForRowObj = new Double(maxTargetHeightForRow);
            double allTraceOffset = (double)traces.size() * traceOffset;
            double bphBase = numRows > 1 ? currY + allTraceOffset : currY;
            currY += allTraceOffset;
            double xVal = ((Point2D)base).getX();
            basePerRow.put(currRowNumObj, new Double(bphBase));
            for (int i = 0; i < numPerRow; ++i) {
                GeneAndSatelliteCluster tc = (GeneAndSatelliteCluster)perRow.get(i);
                Point2D.Double tcbase = new Point2D.Double(xVal, currY);
                tc.locateAsTarget(tcbase, placement, genome, lo, frc, maxTargetHeightForRowObj);
                double width = tc.getClusterDims((Genome)genome, (Layout)lo, (FontRenderContext)frc).width + 100.0;
                xVal += width;
            }
            currY += maxTargetHeightForRow;
            if (xVal > maxXVal) {
                maxXVal = xVal;
            }
            ++currRowNum;
        }
        return maxXVal;
    }

    public SpecialtyLayoutEngineParamDialog getParameterDialog(JFrame parent, Genome genome, String selectedID, boolean forSubset) {
        return new WorksheetLayoutSetupDialog(parent, genome, forSubset, this.forDiagonal_);
    }

    public String getUndoString() {
        return this.forDiagonal_ ? "undo.worksheetDiagLayout" : "undo.worksheetLayout";
    }

    public static String mapTargTypes(int targType) {
        switch (targType) {
            case 0: {
                return TARGS_BY_TIME_TAG_;
            }
            case 1: {
                return TARGS_BY_ALPHA_TAG_;
            }
            case 2: {
                return TARGS_BY_INPUTS_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapTargTypeTag(String targTypeTag) {
        if (targTypeTag.equalsIgnoreCase(TARGS_BY_TIME_TAG_)) {
            return 0;
        }
        if (targTypeTag.equalsIgnoreCase(TARGS_BY_ALPHA_TAG_)) {
            return 1;
        }
        if (targTypeTag.equalsIgnoreCase(TARGS_BY_INPUTS_TAG_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getTargTypeChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        boolean allowByTime = tcd.haveData();
        for (int i = 0; i < 3; ++i) {
            if (i == 0 && !allowByTime) continue;
            retval.add(WorksheetLayout.targTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent targTypeForCombo(int targType) {
        return new ChoiceContent(ResourceManager.getManager().getString("worksheetLayout." + WorksheetLayout.mapTargTypes(targType)), targType);
    }

    public static String mapSrcTypes(int srcType) {
        switch (srcType) {
            case 0: {
                return SRCS_BY_TIME_TAG_;
            }
            case 1: {
                return SRCS_BY_SORT_TAG_;
            }
            case 2: {
                return SRCS_BY_SINGLE_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapSrcTypeTag(String srcTypeTag) {
        if (srcTypeTag.equalsIgnoreCase(SRCS_BY_TIME_TAG_)) {
            return 0;
        }
        if (srcTypeTag.equalsIgnoreCase(SRCS_BY_SORT_TAG_)) {
            return 1;
        }
        if (srcTypeTag.equalsIgnoreCase(SRCS_BY_SINGLE_TAG_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getSrcTypeChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        boolean allowByTime = tcd.haveData();
        for (int i = 0; i < 3; ++i) {
            if (i == 0 && !allowByTime || i == 2) continue;
            retval.add(WorksheetLayout.srcTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent srcTypeForCombo(int srcType) {
        return new ChoiceContent(ResourceManager.getManager().getString("worksheetLayout." + WorksheetLayout.mapSrcTypes(srcType)), srcType);
    }

    public static WorksheetLayoutParams getDefaultParams(boolean forSubset, boolean forDiagonal) {
        WorksheetLayoutParams retval = new WorksheetLayoutParams();
        retval.targGroups = 2;
        retval.targSize = 30;
        retval.srcGroups = forDiagonal ? 2 : 1;
        retval.srcSize = forDiagonal ? 1 : 25;
        retval.assignColors = !forSubset;
        retval.overlayOption = 1;
        retval.traceMult = 2;
        retval.textToo = true;
        return retval;
    }

    public static void forceParamsAsNeeded(WorksheetLayoutParams params) {
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        boolean allowByTime = tcd.haveData();
        if (!allowByTime) {
            if (params.targGroups == 0) {
                params.targGroups = 2;
            }
            if (params.srcGroups == 0) {
                params.srcGroups = 1;
            }
        }
    }

    private SortedSet findSources(Genome genome, List termClusters, Map groups, List sClustList, double traceOffset, boolean textToo) {
        HashSet<String> targets = new HashSet<String>();
        int numTerm = termClusters.size();
        for (int i = 0; i < numTerm; ++i) {
            GeneAndSatelliteCluster clust = (GeneAndSatelliteCluster)termClusters.get(i);
            targets.add(clust.getCoreID());
        }
        TreeSet<String> sources = new TreeSet<String>();
        Iterator gvit = groups.values().iterator();
        while (gvit.hasNext()) {
            NodeGrouper.GroupElement groupCore = (NodeGrouper.GroupElement)gvit.next();
            if (targets.contains(groupCore.group)) continue;
            sources.add(groupCore.group);
        }
        Iterator psit = sources.iterator();
        while (psit.hasNext()) {
            String srcID = (String)psit.next();
            GeneAndSatelliteCluster sc = new GeneAndSatelliteCluster(srcID, false, traceOffset, false, textToo);
            sc.prepFromGroupsPhaseOne(genome, groups);
            sClustList.add(sc);
        }
        return sources;
    }

    private ClusterSeries buildClusterSeriesByTime(List sClustList, int traceMult) {
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        ClusterSeries series = new ClusterSeries(false, traceMult);
        int numClust = sClustList.size();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            String srcID = sc.getCoreID();
            int firstTime = tcd.getFirstExpressionTime(srcID);
            series.addSourceCluster(firstTime, sc);
        }
        return series;
    }

    private ClusterSeries buildClusterSeriesBySingle(List sClustList, int traceMult) {
        ClusterSeries series = new ClusterSeries(false, traceMult);
        int numClust = sClustList.size();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            series.addSourceCluster(0, sc);
        }
        return series;
    }

    private ClusterSeries buildClusterSeriesBySort(List sClustList, Map topoSort, int maxSize, int traceMult) {
        Integer depth;
        int numClust = sClustList.size();
        TreeMap<Integer, Integer> numPerDepth = new TreeMap<Integer, Integer>();
        for (int i = 0; i < numClust; ++i) {
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            String srcID = sc.getCoreID();
            depth = (Integer)topoSort.get(srcID);
            Integer perDepth = (Integer)numPerDepth.get(depth);
            if (perDepth == null) {
                numPerDepth.put(depth, new Integer(1));
                continue;
            }
            int newPerDepth = perDepth + 1;
            numPerDepth.put(depth, new Integer(newPerDepth));
        }
        HashMap<Integer, Integer> baseKeys = new HashMap<Integer, Integer>();
        int currKey = 0;
        Iterator kit = numPerDepth.keySet().iterator();
        while (kit.hasNext()) {
            depth = (Integer)kit.next();
            Integer max = (Integer)numPerDepth.get(depth);
            baseKeys.put(depth, new Integer(currKey));
            int numKeys = max / maxSize + 1;
            currKey += numKeys;
        }
        ClusterSeries series = new ClusterSeries(false, traceMult);
        HashMap<Integer, Integer> seenPerDepth = new HashMap<Integer, Integer>();
        for (int i = 0; i < numClust; ++i) {
            int keyOffset;
            GeneAndSatelliteCluster sc = (GeneAndSatelliteCluster)sClustList.get(i);
            String srcID = sc.getCoreID();
            Integer depth2 = (Integer)topoSort.get(srcID);
            Integer perDepth = (Integer)seenPerDepth.get(depth2);
            if (perDepth == null) {
                seenPerDepth.put(depth2, new Integer(1));
                keyOffset = 0;
            } else {
                int newPerDepth = perDepth + 1;
                seenPerDepth.put(depth2, new Integer(newPerDepth));
                keyOffset = newPerDepth / maxSize;
            }
            Integer keyBase = (Integer)baseKeys.get(depth2);
            int keyValue = keyBase + keyOffset;
            series.addSourceCluster(keyValue, sc);
        }
        return series;
    }

    public static class WorksheetLayoutParams
    implements SpecialtyLayoutEngineParams,
    Cloneable {
        public int targGroups;
        public int targSize;
        public int srcGroups;
        public int srcSize;
        public boolean assignColors;
        public int overlayOption;
        public boolean textToo;
        public int traceMult;

        public Object clone() {
            try {
                WorksheetLayoutParams retval = (WorksheetLayoutParams)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int getOverlayRelayoutOption() {
            return this.overlayOption;
        }
    }
}

