/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParamDialog;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.WorksheetLayout;
import org.systemsbiology.biotapestry.ui.layouts.WorksheetLayoutSetupPanel;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class WorksheetLayoutSetupDialog
extends SpecialtyLayoutEngineParamDialog {
    private WorksheetLayoutSetupPanel paramPanel_;

    public WorksheetLayoutSetupDialog(JFrame parent, Genome genome, boolean forSubset, boolean forDiagonal) {
        super(parent, ResourceManager.getManager().getString(forDiagonal ? "worksheetDiagonalLayout.title" : "worksheetLayout.title"), true);
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(700, 300);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        LayoutOptionsManager lom = LayoutOptionsManager.getMgr();
        WorksheetLayout.WorksheetLayoutParams params = forDiagonal ? lom.getDiagLayoutParams() : lom.getWorksheetLayoutParams();
        this.paramPanel_ = new WorksheetLayoutSetupPanel(parent, genome, forSubset, forDiagonal, params);
        UiUtil.gbcSet(gbc, 0, 0, 2, 4, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.paramPanel_, gbc);
        FixedJButton buttonO = new FixedJButton(rMan.getString("dialogs.ok"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (WorksheetLayoutSetupDialog.this.paramPanel_.stashResults(true)) {
                        WorksheetLayoutSetupDialog.this.setVisible(false);
                        WorksheetLayoutSetupDialog.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.cancel"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    WorksheetLayoutSetupDialog.this.paramPanel_.stashResults(false);
                    WorksheetLayoutSetupDialog.this.setVisible(false);
                    WorksheetLayoutSetupDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        UiUtil.gbcSet(gbc, 0, 6, 2, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
        this.paramPanel_.displayProperties();
    }

    public SpecialtyLayoutEngineParams getParams() {
        return this.paramPanel_.getParams();
    }

    public boolean haveResult() {
        return this.paramPanel_.haveResult();
    }
}

