/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.WorksheetLayout;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class WorksheetLayoutSetupPanel
extends JPanel {
    private boolean haveResult_ = false;
    private WorksheetLayout.WorksheetLayoutParams params_;
    private JComboBox targTypeCombo_;
    private JComboBox srcTypeCombo_;
    private JTextField targSizeField_;
    private JTextField srcSizeField_;
    private JCheckBox doColorsBox_;
    private JComboBox overlayOptionCombo_;
    private JFrame parent_;
    private boolean forSubset_;
    private boolean forDiagonal_;

    public WorksheetLayoutSetupPanel(JFrame parent, Genome genome, boolean forSubset, boolean forDiagonal, WorksheetLayout.WorksheetLayoutParams params) {
        this.parent_ = parent;
        this.forSubset_ = forSubset;
        this.forDiagonal_ = forDiagonal;
        this.params_ = (WorksheetLayout.WorksheetLayoutParams)params.clone();
        if (this.forSubset_) {
            this.params_.assignColors = false;
        }
        this.buildParamPanel(genome);
    }

    public SpecialtyLayoutEngineParams getParams() {
        return this.params_;
    }

    public boolean haveResult() {
        return this.haveResult_;
    }

    public void resetDefaults() {
        this.params_ = WorksheetLayout.getDefaultParams(this.forSubset_, this.forDiagonal_);
        this.displayProperties();
    }

    public void displayProperties() {
        if (this.srcTypeCombo_ != null) {
            this.srcTypeCombo_.setSelectedItem(WorksheetLayout.srcTypeForCombo(this.params_.srcGroups));
            this.srcSizeField_.setText(Integer.toString(this.params_.srcSize));
        }
        this.targTypeCombo_.setSelectedItem(WorksheetLayout.targTypeForCombo(this.params_.targGroups));
        this.targSizeField_.setText(Integer.toString(this.params_.targSize));
        if (this.doColorsBox_ != null) {
            this.doColorsBox_.setSelected(this.params_.assignColors);
        }
        this.overlayOptionCombo_.setSelectedItem(NetOverlayProperties.relayoutForCombo(this.params_.overlayOption));
    }

    public boolean stashResults(boolean ok) {
        if (ok) {
            String srcStr = !this.forDiagonal_ ? this.srcSizeField_.getText() : null;
            String trgStr = this.targSizeField_.getText();
            boolean badVal = false;
            try {
                if (!this.forDiagonal_) {
                    this.params_.srcSize = Integer.parseInt(srcStr);
                }
                this.params_.targSize = Integer.parseInt(trgStr);
                if (this.params_.srcSize <= 0 || this.params_.targSize <= 0) {
                    badVal = true;
                }
            }
            catch (NumberFormatException ex) {
                badVal = true;
            }
            if (badVal) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(this.parent_, rMan.getString("worksheetLayout.badSize"), rMan.getString("worksheetLayout.badSizeTitle"), 0);
                this.haveResult_ = false;
                return false;
            }
            this.params_.targGroups = ((ChoiceContent)this.targTypeCombo_.getSelectedItem()).val;
            if (!this.forDiagonal_) {
                this.params_.srcGroups = ((ChoiceContent)this.srcTypeCombo_.getSelectedItem()).val;
            }
            if (!this.forSubset_) {
                this.params_.assignColors = this.doColorsBox_.isSelected();
            }
            this.params_.overlayOption = ((ChoiceContent)this.overlayOptionCombo_.getSelectedItem()).val;
            this.haveResult_ = true;
            return true;
        }
        this.params_ = null;
        this.haveResult_ = false;
        return true;
    }

    private void buildParamPanel(Genome genome) {
        boolean activate;
        ResourceManager rMan = ResourceManager.getManager();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        int rowNum = 0;
        if (!this.forDiagonal_) {
            JLabel srcTypeLabel = new JLabel(rMan.getString("worksheetLayout.srcType"));
            Vector srcTypeChoices = WorksheetLayout.getSrcTypeChoices();
            this.srcTypeCombo_ = new JComboBox(srcTypeChoices);
            UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)srcTypeLabel, gbc);
            UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)this.srcTypeCombo_, gbc);
            JLabel srcSizeLabel = new JLabel(rMan.getString("worksheetLayout.srcSize"));
            this.srcSizeField_ = new JTextField();
            UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)srcSizeLabel, gbc);
            UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)this.srcSizeField_, gbc);
        }
        JLabel targTypeLabel = new JLabel(rMan.getString("worksheetLayout.targType"));
        Vector targTypeChoices = WorksheetLayout.getTargTypeChoices();
        this.targTypeCombo_ = new JComboBox(targTypeChoices);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)targTypeLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.targTypeCombo_, gbc);
        JLabel targSizeLabel = new JLabel(rMan.getString("worksheetLayout.targSize"));
        this.targSizeField_ = new JTextField();
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)targSizeLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.targSizeField_, gbc);
        JLabel overlayLabel = new JLabel(rMan.getString("worksheetLayout.overlayOptions"));
        Vector relayoutChoices = NetOverlayProperties.getRelayoutOptions();
        this.overlayOptionCombo_ = new JComboBox(relayoutChoices);
        boolean bl = activate = genome == null || genome.getNetworkOverlayCount() > 0;
        if (!activate) {
            overlayLabel.setEnabled(false);
            this.overlayOptionCombo_.setEnabled(false);
        }
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)overlayLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.overlayOptionCombo_, gbc);
        if (!this.forSubset_) {
            this.doColorsBox_ = new JCheckBox(rMan.getString("worksheetLayout.doColors"));
            UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)this.doColorsBox_, gbc);
        }
    }
}

