/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts.ortho;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.util.MinMax;

public class DegreeOfFreedom
implements Cloneable {
    public static final int UNDEF_AXIS = -1;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int UNCONDITIONAL = 0;
    public static final int CONDITIONAL = 1;
    public static final int FIXED = 2;
    private int axis_;
    private int type_;
    private MinMax range_;
    private ArrayList dependencies_;

    public DegreeOfFreedom(int axis, int type, MinMax range, List dependencies) {
        this.axis_ = axis;
        this.type_ = type;
        MinMax minMax = this.range_ = range == null ? null : (MinMax)range.clone();
        if (dependencies != null) {
            this.dependencies_ = new ArrayList(dependencies);
        }
    }

    public Object clone() {
        try {
            DegreeOfFreedom retval = (DegreeOfFreedom)super.clone();
            MinMax minMax = retval.range_ = this.range_ != null ? (MinMax)this.range_.clone() : null;
            if (this.dependencies_ != null) {
                retval.dependencies_ = new ArrayList();
                int numPl = this.dependencies_.size();
                for (int i = 0; i < numPl; ++i) {
                    LinkSegmentID lsid = (LinkSegmentID)this.dependencies_.get(i);
                    retval.dependencies_.add(lsid.clone());
                }
            }
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int getAxis() {
        return this.axis_;
    }

    public int getType() {
        return this.type_;
    }

    public Iterator getDependencies() {
        return this.dependencies_ == null ? null : this.dependencies_.iterator();
    }
}

