/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts.ortho;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.layouts.ortho.DegreeOfFreedom;
import org.systemsbiology.biotapestry.ui.layouts.ortho.LinkSegStrategy;
import org.systemsbiology.biotapestry.ui.layouts.ortho.PointDegreesOfFreedom;
import org.systemsbiology.biotapestry.ui.layouts.ortho.TreeStrategy;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Vector2D;

public class FixOrthoOptions {
    private static final int STOP_RECURSION_ = -1;
    private static final int NO_RECURSION_ = 0;
    private static final int IS_RECURSION_ = 1;
    private static final int UP_RECURSION_ = 2;
    private static final int DOWN_RECURSION_ = 3;
    private static final int STRATEGY_LIMIT_ = 200;
    private ArrayList strats_ = new ArrayList();
    private FixOrthoTreeInfo foti_;

    public FixOrthoOptions(LinkSegmentID segID, FixOrthoTreeInfo foti) {
        Vector2D overall;
        double dot;
        this.foti_ = foti;
        PointDOFsPerSeg pdps = (PointDOFsPerSeg)foti.ptDofs.get(segID);
        if (pdps == null || pdps.p0d == null) {
            return;
        }
        PointDegreesOfFreedom p0d = pdps.p0d;
        PointDegreesOfFreedom p1d = pdps.p1d;
        if (p0d.requiredDir != null && (dot = (overall = new Vector2D(p0d.point, p1d.point)).dot(p0d.requiredDir)) < 0.0) {
            return;
        }
        if (p1d.requiredDir != null && (dot = (overall = new Vector2D(p0d.point, p1d.point)).dot(p1d.requiredDir)) < 0.0) {
            return;
        }
        this.buildRecursiveStrategy(segID, this.strats_, -1);
        this.buildRecursiveStrategy(segID, this.strats_, 0);
    }

    public Iterator getStrategies() {
        return this.strats_.iterator();
    }

    private boolean buildRecursiveStrategy(LinkSegmentID segID, List strats, int recursionType) {
        PointDOFsPerSeg pdps = (PointDOFsPerSeg)this.foti_.ptDofs.get(segID);
        if (pdps == null || pdps.p0d == null || pdps.p1d == null) {
            return false;
        }
        if (strats.size() > 200) {
            return false;
        }
        PointDegreesOfFreedom p0d = pdps.p0d;
        PointDegreesOfFreedom p1d = pdps.p1d;
        boolean inRecursion = recursionType != 0 && recursionType != -1;
        boolean retval = false;
        boolean canDo = this.generateSingleMoveStrategies(segID, p0d, p1d, strats, recursionType);
        boolean bl = retval = retval || canDo;
        if (!inRecursion) {
            canDo = this.generateDoubleMoveStrategies(segID, p0d, p1d, strats, recursionType);
            retval = retval || canDo;
        }
        canDo = this.generateSingleSplitStrategies(segID, p0d, p1d, strats);
        retval = retval || canDo;
        canDo = this.generateSingleSplitAndMoveStrategies(segID, p0d, p1d, strats, recursionType);
        retval = retval || canDo;
        canDo = this.generateDoubleSplitStrategies(segID, p0d, p1d, strats, recursionType);
        retval = retval || canDo;
        return retval;
    }

    private boolean nonMoveSatisfied(Vector2D nonMoveRequiredVec, int axis) {
        boolean nonMoveSatisfiedAlongY = true;
        boolean nonMoveSatisfiedAlongX = true;
        if (nonMoveRequiredVec != null) {
            int canon = nonMoveRequiredVec.canonicalDir();
            nonMoveSatisfiedAlongY = canon == 0 || canon == 2;
            nonMoveSatisfiedAlongX = canon == 1 || canon == 3;
        }
        return axis == 0 ? nonMoveSatisfiedAlongY : nonMoveSatisfiedAlongX;
    }

    private boolean buildAMove(LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, Vector2D nonMoveRequiredVec, DegreeOfFreedom moveDOF, int reqArg1, int reqArg2, int stratMove, List strats, int recursionType) {
        if (moveDOF.getType() == 2 || !this.nonMoveSatisfied(nonMoveRequiredVec, moveDOF.getAxis())) {
            return false;
        }
        ArrayList<TreeStrategy> allMyStrats = new ArrayList<TreeStrategy>();
        TreeStrategy useStrat = new TreeStrategy();
        ArrayList<LinkSegStrategy.Requirement> reqs = new ArrayList<LinkSegStrategy.Requirement>();
        if (recursionType != -1 || moveDOF.getType() != 1) {
            reqs.add(new LinkSegStrategy.Requirement(reqArg1, 0, reqArg2));
            useStrat.addSegStrategy(new LinkSegStrategy(segID, stratMove, reqs, p0d, p1d, false));
            allMyStrats.add(useStrat);
        }
        if (recursionType != -1 && moveDOF.getType() == 1) {
            LinkSegmentID plisd = (LinkSegmentID)this.foti_.parentIDs.get(segID);
            Iterator dit = moveDOF.getDependencies();
            while (dit.hasNext()) {
                int recursion;
                ArrayList recursionStrats;
                LinkSegmentID depend = (LinkSegmentID)dit.next();
                boolean canDo = this.buildRecursiveStrategy(depend, recursionStrats = new ArrayList(), recursion = plisd == null || plisd.equals(depend) ? 2 : 3);
                if (!canDo) {
                    return false;
                }
                if (this.mergeConditionals(allMyStrats, recursionStrats)) continue;
                return false;
            }
        }
        if (strats.size() + allMyStrats.size() > 200) {
            return false;
        }
        strats.addAll(allMyStrats);
        return true;
    }

    private boolean mergeConditionals(List conditionalStrats, List recursionStrats) {
        int numRS;
        ArrayList<TreeStrategy> nextCStrats = new ArrayList<TreeStrategy>();
        int numCS = conditionalStrats.size();
        if (numCS * (numRS = recursionStrats.size()) > 200) {
            return false;
        }
        for (int i = 0; i < numCS; ++i) {
            TreeStrategy cStrat = (TreeStrategy)conditionalStrats.get(i);
            for (int j = 0; j < numRS; ++j) {
                TreeStrategy rStrat = (TreeStrategy)recursionStrats.get(j);
                TreeStrategy augCStrat = (TreeStrategy)cStrat.clone();
                augCStrat.mergeSegStrategies(rStrat);
                nextCStrats.add(augCStrat);
            }
        }
        conditionalStrats.clear();
        conditionalStrats.addAll(nextCStrats);
        return true;
    }

    private boolean generateSingleMoveStrategies(LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, List strats, int recursionType) {
        boolean canDo;
        if (recursionType == 1) {
            throw new IllegalArgumentException();
        }
        boolean retval = false;
        if (recursionType == -1 || recursionType == 0 || recursionType == 2) {
            canDo = this.buildAMove(segID, p0d, p1d, p1d.requiredDir, p0d.xDOF, 2, 5, 1, strats, recursionType);
            retval = retval || canDo;
            canDo = this.buildAMove(segID, p0d, p1d, p1d.requiredDir, p0d.yDOF, 4, 7, 2, strats, recursionType);
            boolean bl = retval = retval || canDo;
        }
        if (recursionType == -1 || recursionType == 0 || recursionType == 3) {
            canDo = this.buildAMove(segID, p0d, p1d, p0d.requiredDir, p1d.xDOF, 6, 1, 4, strats, recursionType);
            retval = retval || canDo;
            canDo = this.buildAMove(segID, p0d, p1d, p0d.requiredDir, p1d.yDOF, 8, 3, 8, strats, recursionType);
            retval = retval || canDo;
        }
        return retval;
    }

    private boolean buildDoubleMove(LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, DegreeOfFreedom move0DOF, DegreeOfFreedom move1DOF, int reqArg1, int reqArg2, int stratMove, List strats, int recursionType) {
        if (move0DOF.getType() == 2 || move1DOF.getType() == 2) {
            return false;
        }
        ArrayList<TreeStrategy> allMyStrats = new ArrayList<TreeStrategy>();
        TreeStrategy useStrat = new TreeStrategy();
        ArrayList<LinkSegStrategy.Requirement> reqs = new ArrayList<LinkSegStrategy.Requirement>();
        if (recursionType != -1 || move0DOF.getType() != 1 && move1DOF.getType() != 1) {
            reqs.add(new LinkSegStrategy.Requirement(reqArg1, 0, reqArg2));
            useStrat.addSegStrategy(new LinkSegStrategy(segID, stratMove, reqs, p0d, p1d, false));
            allMyStrats.add(useStrat);
        }
        if (recursionType != -1) {
            if (move0DOF.getType() == 1) {
                LinkSegmentID parentID = (LinkSegmentID)this.foti_.parentIDs.get(segID);
                Iterator dit = move0DOF.getDependencies();
                while (dit.hasNext()) {
                    int useRec;
                    ArrayList recursionStrats;
                    LinkSegmentID depend = (LinkSegmentID)dit.next();
                    boolean canDo = this.buildRecursiveStrategy(depend, recursionStrats = new ArrayList(), useRec = depend.equals(parentID) ? 2 : 3);
                    if (!canDo) {
                        return false;
                    }
                    this.mergeConditionals(allMyStrats, recursionStrats);
                }
            }
            if (move1DOF.getType() == 1) {
                Iterator dit = move1DOF.getDependencies();
                while (dit.hasNext()) {
                    ArrayList recursionStrats;
                    LinkSegmentID depend = (LinkSegmentID)dit.next();
                    boolean canDo = this.buildRecursiveStrategy(depend, recursionStrats = new ArrayList(), 3);
                    if (!canDo) {
                        return false;
                    }
                    this.mergeConditionals(allMyStrats, recursionStrats);
                }
            }
            if (strats.size() + allMyStrats.size() > 200) {
                return false;
            }
        }
        strats.addAll(allMyStrats);
        return true;
    }

    private boolean generateDoubleMoveStrategies(LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, List strats, int recursionType) {
        boolean retval = false;
        boolean canDo = this.buildDoubleMove(segID, p0d, p1d, p0d.xDOF, p1d.xDOF, 2, 6, 5, strats, recursionType);
        retval = retval || canDo;
        canDo = this.buildDoubleMove(segID, p0d, p1d, p0d.yDOF, p1d.yDOF, 4, 8, 10, strats, recursionType);
        retval = retval || canDo;
        return retval;
    }

    private boolean generateSingleSplitStrategies(LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, List strats) {
        ArrayList<LinkSegStrategy.Requirement> reqs;
        TreeStrategy useStrat;
        boolean retval = false;
        ArrayList<TreeStrategy> allMyStrats = new ArrayList<TreeStrategy>();
        if (this.nonMoveSatisfied(p0d.requiredDir, 0) && this.nonMoveSatisfied(p1d.requiredDir, 1)) {
            useStrat = new TreeStrategy();
            reqs = new ArrayList<LinkSegStrategy.Requirement>();
            reqs.add(new LinkSegStrategy.Requirement(9, 0, 1));
            reqs.add(new LinkSegStrategy.Requirement(10, 0, 7));
            useStrat.addSegStrategy(new LinkSegStrategy(segID, 16, reqs, p0d, p1d, false));
            retval = true;
            allMyStrats.add(useStrat);
        }
        if (this.nonMoveSatisfied(p0d.requiredDir, 1) && this.nonMoveSatisfied(p1d.requiredDir, 0)) {
            useStrat = new TreeStrategy();
            reqs = new ArrayList();
            reqs.add(new LinkSegStrategy.Requirement(9, 0, 5));
            reqs.add(new LinkSegStrategy.Requirement(10, 0, 3));
            useStrat.addSegStrategy(new LinkSegStrategy(segID, 16, reqs, p0d, p1d, false));
            retval = true;
            allMyStrats.add(useStrat);
        }
        if (strats.size() + allMyStrats.size() > 200) {
            return false;
        }
        strats.addAll(allMyStrats);
        return retval;
    }

    private void bundleSplitAndMove(TreeStrategy treeStrat, LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, int req1A, int req1B, int req2A, int req2B, int strat) {
        ArrayList<LinkSegStrategy.Requirement> reqs = new ArrayList<LinkSegStrategy.Requirement>();
        reqs.add(new LinkSegStrategy.Requirement(req1A, 0, req1B));
        reqs.add(new LinkSegStrategy.Requirement(req2A, 0, req2B));
        treeStrat.addSegStrategy(new LinkSegStrategy(segID, strat, reqs, p0d, p1d, false));
    }

    private boolean generateSingleSplitAndMoveStrategies(LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, List strats, int recursionType) {
        TreeStrategy useStrat;
        boolean inRecursion;
        boolean bl = inRecursion = recursionType != 0 && recursionType != -1;
        if (inRecursion) {
            return false;
        }
        boolean retval = false;
        ArrayList<TreeStrategy> allMyStrats = new ArrayList<TreeStrategy>();
        if (p1d.yDOF.getType() != 2 && p1d.yDOF.getType() != 1 && this.nonMoveSatisfied(p0d.requiredDir, 0)) {
            retval = true;
            useStrat = new TreeStrategy();
            this.bundleSplitAndMove(useStrat, segID, p0d, p1d, 9, 1, 10, 8, 24);
            allMyStrats.add(useStrat);
        }
        if (p0d.yDOF.getType() != 2 && p0d.yDOF.getType() != 1 && this.nonMoveSatisfied(p1d.requiredDir, 0)) {
            retval = true;
            useStrat = new TreeStrategy();
            this.bundleSplitAndMove(useStrat, segID, p0d, p1d, 9, 5, 10, 4, 18);
            allMyStrats.add(useStrat);
        }
        if (p1d.xDOF.getType() != 2 && p1d.xDOF.getType() != 1 && this.nonMoveSatisfied(p0d.requiredDir, 1)) {
            retval = true;
            useStrat = new TreeStrategy();
            this.bundleSplitAndMove(useStrat, segID, p0d, p1d, 9, 6, 10, 3, 20);
            allMyStrats.add(useStrat);
        }
        if (p0d.xDOF.getType() != 2 && p0d.xDOF.getType() != 1 && this.nonMoveSatisfied(p1d.requiredDir, 1)) {
            retval = true;
            useStrat = new TreeStrategy();
            this.bundleSplitAndMove(useStrat, segID, p0d, p1d, 9, 2, 10, 7, 17);
            allMyStrats.add(useStrat);
        }
        if (strats.size() + allMyStrats.size() > 200) {
            return false;
        }
        strats.addAll(allMyStrats);
        return retval;
    }

    private boolean generateDoubleSplitStrategies(LinkSegmentID segID, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, List strats, int recursionType) {
        ArrayList<LinkSegStrategy.Requirement> reqs;
        TreeStrategy useStrat;
        boolean varyMoves;
        boolean retval = false;
        ArrayList<TreeStrategy> allMyStrats = new ArrayList<TreeStrategy>();
        boolean bl = varyMoves = recursionType == -1;
        if (this.nonMoveSatisfied(p0d.requiredDir, 0) && this.nonMoveSatisfied(p1d.requiredDir, 0)) {
            useStrat = new TreeStrategy();
            reqs = new ArrayList<LinkSegStrategy.Requirement>();
            reqs.add(new LinkSegStrategy.Requirement(9, 0, 1));
            reqs.add(new LinkSegStrategy.Requirement(10, 0, 12));
            reqs.add(new LinkSegStrategy.Requirement(11, 0, 5));
            useStrat.addSegStrategy(new LinkSegStrategy(segID, 48, reqs, p0d, p1d, varyMoves));
            retval = true;
            allMyStrats.add(useStrat);
        }
        if (this.nonMoveSatisfied(p0d.requiredDir, 1) && this.nonMoveSatisfied(p1d.requiredDir, 1)) {
            useStrat = new TreeStrategy();
            reqs = new ArrayList();
            reqs.add(new LinkSegStrategy.Requirement(10, 0, 3));
            reqs.add(new LinkSegStrategy.Requirement(9, 0, 11));
            reqs.add(new LinkSegStrategy.Requirement(12, 0, 7));
            useStrat.addSegStrategy(new LinkSegStrategy(segID, 48, reqs, p0d, p1d, varyMoves));
            retval = true;
            allMyStrats.add(useStrat);
        }
        if (strats.size() + allMyStrats.size() > 200) {
            return false;
        }
        strats.addAll(allMyStrats);
        return retval;
    }

    public static class FixOrthoTreeInfo {
        public HashSet allSegIDs = new HashSet();
        public HashMap cornerDofs = new HashMap();
        public HashMap parentIDs = new HashMap();
        public HashMap forceDirs = new HashMap();
        public HashMap segGeoms = new HashMap();
        public HashMap ptDofs = new HashMap();

        public void prepare(LinkProperties bp) {
            Iterator aidit = this.allSegIDs.iterator();
            while (aidit.hasNext()) {
                ForceDirsAndMatches fdam;
                LinkProperties.CornerDoF p0Dof;
                LinkSegmentID lsid = (LinkSegmentID)aidit.next();
                LinkProperties.CornerDoF p1Dof = (LinkProperties.CornerDoF)this.cornerDofs.get(lsid);
                LinkSegmentID psid = (LinkSegmentID)this.parentIDs.get(lsid);
                if (psid == null) {
                    if (lsid.isDirect()) {
                        p0Dof = null;
                        fdam = (ForceDirsAndMatches)this.forceDirs.get(lsid);
                    } else {
                        p0Dof = null;
                        fdam = (ForceDirsAndMatches)this.forceDirs.get(LinkSegmentID.buildIDForStartDrop());
                    }
                } else if (psid.isForSegment() && bp.getSegment(psid).isDegenerate()) {
                    p0Dof = (LinkProperties.CornerDoF)this.cornerDofs.get(LinkSegmentID.buildIDForStartDrop());
                    fdam = (ForceDirsAndMatches)this.forceDirs.get(lsid);
                } else if (lsid.isForSegment() && bp.getSegment(lsid).isDegenerate()) {
                    p0Dof = null;
                    fdam = null;
                } else {
                    p0Dof = (LinkProperties.CornerDoF)this.cornerDofs.get(psid);
                    fdam = (ForceDirsAndMatches)this.forceDirs.get(lsid);
                }
                LinkSegment noSeg = (LinkSegment)this.segGeoms.get(lsid);
                PointDOFsPerSeg pdps = new PointDOFsPerSeg();
                pdps.p0d = this.dofAnalyze(noSeg.getStart(), p0Dof, p1Dof, bp, true, fdam);
                pdps.p1d = this.dofAnalyze(noSeg.getEnd(), p1Dof, null, bp, false, fdam);
                this.ptDofs.put(lsid, pdps);
            }
        }

        private PointDegreesOfFreedom dofAnalyze(Point2D point, LinkProperties.CornerDoF cdof, LinkProperties.CornerDoF p1dof, LinkProperties bp, boolean isForZero, ForceDirsAndMatches fdam) {
            AxesAndCanonicals aac;
            Vector2D forceDir;
            DegreeOfFreedom fixY = new DegreeOfFreedom(1, 2, null, null);
            DegreeOfFreedom fixX = new DegreeOfFreedom(0, 2, null, null);
            if (fdam == null) {
                return new PointDegreesOfFreedom(point, fixX, fixY, null);
            }
            Vector2D vector2D = forceDir = isForZero ? fdam.forceDirs[0] : fdam.forceDirs[1];
            if (fdam.type == 0) {
                return new PointDegreesOfFreedom(point, fixX, fixY, forceDir);
            }
            if (fdam.type == 1) {
                if (isForZero) {
                    return new PointDegreesOfFreedom(point, fixX, fixY, fdam.forceDirs[0]);
                }
                AxesAndCanonicals aac2 = new AxesAndCanonicals(fdam);
                return this.genP1DoFForStartDrop(bp, point, fdam.forceDirs[0], aac2.runAxis, aac2.normAxis);
            }
            if (fdam.type == 2 && !isForZero) {
                return new PointDegreesOfFreedom(point, fixX, fixY, fdam.forceDirs[1]);
            }
            if (isForZero && p1dof == null) {
                if (cdof == null || fdam.forceDirs[1] == null) {
                    return new PointDegreesOfFreedom(point, fixX, fixY, null);
                }
                aac = new AxesAndCanonicals(cdof, fdam);
            } else {
                if (cdof == null) {
                    return new PointDegreesOfFreedom(point, fixX, fixY, null);
                }
                aac = new AxesAndCanonicals(cdof, p1dof, isForZero, fdam);
            }
            if (aac.isForZero) {
                if (aac.inboundCanonicalDrop) {
                    return this.genP0DoFCanonDropIn(cdof, point, forceDir, aac);
                }
                if (aac.inboundCanonicalDrop || aac.inboundCanonical) {
                    return this.genP0DoFCanonIn(cdof, point, forceDir, aac.inboundAxis, aac.inboundNorm, aac.lsid0, aac.lsid1);
                }
                return this.genP0DoF(cdof, point, forceDir, aac.runAxis, aac.normAxis, 0, null);
            }
            if (aac.outboundCanonicalDrop) {
                return this.genP1DoF(cdof, point, forceDir, aac.runAxis, aac.normAxis, 2, null);
            }
            if (aac.outboundCanonical) {
                return this.genP1DoF(cdof, point, forceDir, aac.runAxis, aac.normAxis, 1, aac.outboundCanonicalPoint);
            }
            return this.genP1DoF(cdof, point, forceDir, aac.runAxis, aac.normAxis, 0, null);
        }

        private PointDegreesOfFreedom genP0DoFCanonIn(LinkProperties.CornerDoF cdof, Point2D point, Vector2D forceDir, int inboundAxis, int inboundNorm, LinkSegmentID normCond, LinkSegmentID mySeg) {
            DegreeOfFreedom dofInboundRun;
            ArrayList<Object> depend = new ArrayList<Object>();
            depend.add(normCond.clone());
            if (cdof.runPoint != null && !cdof.runPoint.equals(mySeg)) {
                depend.add(cdof.runPoint.clone());
            }
            DegreeOfFreedom dofInboundNorm = new DegreeOfFreedom(inboundNorm, 1, null, depend);
            if (cdof.antiDrop || cdof.normDrop) {
                dofInboundRun = new DegreeOfFreedom(inboundAxis, 2, null, null);
            } else {
                depend = new ArrayList();
                if (cdof.antiNormPoint != null && !cdof.antiNormPoint.equals(mySeg)) {
                    depend.add(cdof.antiNormPoint.clone());
                }
                if (cdof.normPoint != null && !cdof.normPoint.equals(mySeg)) {
                    depend.add(cdof.normPoint.clone());
                }
                dofInboundRun = !depend.isEmpty() ? new DegreeOfFreedom(inboundAxis, 1, null, depend) : new DegreeOfFreedom(inboundAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null);
            }
            DegreeOfFreedom dofx = inboundAxis == 0 ? dofInboundRun : dofInboundNorm;
            DegreeOfFreedom dofy = inboundAxis == 0 ? dofInboundNorm : dofInboundRun;
            return new PointDegreesOfFreedom(point, dofx, dofy, forceDir);
        }

        private PointDegreesOfFreedom genP0DoFCanonDropIn(LinkProperties.CornerDoF cdof, Point2D point, Vector2D forceDir, AxesAndCanonicals aac) {
            DegreeOfFreedom dofRun;
            DegreeOfFreedom dofNorm;
            if (aac.inboundAxis == aac.runAxis) {
                dofNorm = new DegreeOfFreedom(aac.normAxis, 2, null, null);
            } else {
                ArrayList<Object> depend = new ArrayList<Object>();
                if (cdof.antiNormPoint != null && !cdof.antiNormPoint.equals(aac.lsid1)) {
                    depend.add(cdof.antiNormPoint.clone());
                }
                if (cdof.normPoint != null && !cdof.normPoint.equals(aac.lsid1)) {
                    depend.add(cdof.normPoint.clone());
                }
                dofNorm = depend.isEmpty() ? new DegreeOfFreedom(aac.normAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null) : new DegreeOfFreedom(aac.normAxis, 1, null, depend);
            }
            if (aac.inboundAxis != aac.runAxis) {
                dofRun = new DegreeOfFreedom(aac.runAxis, 2, null, null);
            } else {
                ArrayList<Object> depend = new ArrayList<Object>();
                if (cdof.antiNormPoint != null && !cdof.antiNormPoint.equals(aac.lsid1)) {
                    depend.add(cdof.antiNormPoint.clone());
                }
                if (cdof.normPoint != null && !cdof.normPoint.equals(aac.lsid1)) {
                    depend.add(cdof.normPoint.clone());
                }
                dofRun = depend.isEmpty() ? new DegreeOfFreedom(aac.runAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null) : new DegreeOfFreedom(aac.runAxis, 1, null, depend);
            }
            DegreeOfFreedom dofx = aac.runAxis == 0 ? dofRun : dofNorm;
            DegreeOfFreedom dofy = aac.runAxis == 0 ? dofNorm : dofRun;
            return new PointDegreesOfFreedom(point, dofx, dofy, forceDir);
        }

        private PointDegreesOfFreedom genP0DoF(LinkProperties.CornerDoF cdof, Point2D point, Vector2D forceDir, int runAxis, int normAxis, int normDOF, LinkSegmentID normCond) {
            DegreeOfFreedom dofR;
            DegreeOfFreedom dofN;
            switch (normDOF) {
                case 2: {
                    dofN = new DegreeOfFreedom(normAxis, 2, null, null);
                    break;
                }
                case 1: {
                    ArrayList<Object> depend = new ArrayList<Object>();
                    depend.add(normCond.clone());
                    dofN = new DegreeOfFreedom(normAxis, 1, null, depend);
                    break;
                }
                case 0: {
                    dofN = new DegreeOfFreedom(normAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (cdof.antiDrop || cdof.normDrop) {
                dofR = new DegreeOfFreedom(runAxis, 2, null, null);
            } else {
                ArrayList<Object> depend = new ArrayList<Object>();
                if (cdof.antiNormPoint != null) {
                    depend.add(cdof.antiNormPoint.clone());
                }
                if (cdof.normPoint != null) {
                    depend.add(cdof.normPoint.clone());
                }
                dofR = !depend.isEmpty() ? new DegreeOfFreedom(runAxis, 1, null, depend) : new DegreeOfFreedom(runAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null);
            }
            DegreeOfFreedom dofx = runAxis == 0 ? dofR : dofN;
            DegreeOfFreedom dofy = runAxis == 0 ? dofN : dofR;
            return new PointDegreesOfFreedom(point, dofx, dofy, forceDir);
        }

        private PointDegreesOfFreedom genP1DoF(LinkProperties.CornerDoF cdof, Point2D point, Vector2D forceDir, int runAxis, int normAxis, int normDOF, LinkSegmentID normCond) {
            DegreeOfFreedom dofR;
            DegreeOfFreedom dofN;
            switch (normDOF) {
                case 2: {
                    dofN = new DegreeOfFreedom(normAxis, 2, null, null);
                    break;
                }
                case 1: {
                    ArrayList<Object> depend = new ArrayList<Object>();
                    depend.add(normCond.clone());
                    dofN = new DegreeOfFreedom(normAxis, 1, null, depend);
                    break;
                }
                case 0: {
                    dofN = new DegreeOfFreedom(normAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (cdof.antiDrop || cdof.normDrop) {
                dofR = new DegreeOfFreedom(runAxis, 2, null, null);
            } else {
                ArrayList<Object> depend = new ArrayList<Object>();
                if (cdof.antiNormPoint != null) {
                    depend.add(cdof.antiNormPoint.clone());
                }
                if (cdof.normPoint != null) {
                    depend.add(cdof.normPoint.clone());
                }
                dofR = !depend.isEmpty() ? new DegreeOfFreedom(runAxis, 1, null, depend) : new DegreeOfFreedom(runAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null);
            }
            DegreeOfFreedom dofx = runAxis == 0 ? dofR : dofN;
            DegreeOfFreedom dofy = runAxis == 0 ? dofN : dofR;
            return new PointDegreesOfFreedom(point, dofx, dofy, forceDir);
        }

        private PointDegreesOfFreedom genP1DoFForStartDrop(LinkProperties lp, Point2D point, Vector2D forceDir, int runAxis, int normAxis) {
            DegreeOfFreedom dofR;
            DegreeOfFreedom dofN;
            LinkSegment startGeom = (LinkSegment)this.segGeoms.get(LinkSegmentID.buildIDForStartDrop());
            List csegs = lp.getChildSegs(lp.getRootSegmentID());
            int normDOF = startGeom.isOrthogonal() ? 2 : 0;
            int runDOF = 0;
            LinkSegmentID normCond = null;
            ArrayList<Object> runConds = new ArrayList<Object>();
            Vector2D negForceDir = forceDir.scaled(-1.0);
            Iterator csit = csegs.iterator();
            while (csit.hasNext()) {
                LinkSegmentID lsid = (LinkSegmentID)csit.next();
                LinkSegment geom = (LinkSegment)this.segGeoms.get(lsid);
                if (!geom.isOrthogonal()) continue;
                Vector2D run = geom.getRun();
                Vector2D norm = geom.getNormal();
                if (normDOF != 2 && run.equals(forceDir)) {
                    normCond = lsid;
                    normDOF = 1;
                    continue;
                }
                if (!norm.equals(forceDir) && !norm.equals(negForceDir)) continue;
                runConds.add(lsid.clone());
                runDOF = 1;
            }
            switch (normDOF) {
                case 2: {
                    dofN = new DegreeOfFreedom(normAxis, 2, null, null);
                    break;
                }
                case 1: {
                    ArrayList<Object> depend = new ArrayList<Object>();
                    depend.add(normCond.clone());
                    dofN = new DegreeOfFreedom(normAxis, 1, null, depend);
                    break;
                }
                case 0: {
                    dofN = new DegreeOfFreedom(normAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (runDOF) {
                case 2: {
                    dofR = new DegreeOfFreedom(runAxis, 2, null, null);
                    break;
                }
                case 1: {
                    dofR = new DegreeOfFreedom(runAxis, 1, null, runConds);
                    break;
                }
                case 0: {
                    dofR = new DegreeOfFreedom(runAxis, 0, new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            DegreeOfFreedom dofx = runAxis == 0 ? dofR : dofN;
            DegreeOfFreedom dofy = runAxis == 0 ? dofN : dofR;
            return new PointDegreesOfFreedom(point, dofx, dofy, forceDir);
        }
    }

    static class AxesAndCanonicals {
        boolean isForZero;
        int runAxis;
        int normAxis;
        int inboundAxis;
        int inboundNorm;
        boolean inboundCanonical;
        boolean inboundCanonicalDrop;
        boolean outboundCanonicalDrop;
        boolean outboundCanonical;
        LinkSegmentID outboundCanonicalPoint;
        LinkSegmentID lsid0;
        LinkSegmentID lsid1;

        AxesAndCanonicals(LinkProperties.CornerDoF cdof, LinkProperties.CornerDoF p1dof, boolean isForZero, ForceDirsAndMatches fdam) {
            this.isForZero = isForZero;
            this.inboundAxis = -1;
            this.inboundNorm = -1;
            this.inboundCanonical = false;
            this.lsid0 = cdof.myID;
            LinkSegmentID linkSegmentID = this.lsid1 = p1dof == null ? fdam.segID : p1dof.myID;
            if (isForZero) {
                int inboundDir = cdof.runVector.canonicalDir();
                this.inboundCanonical = cdof.inboundIsCanonical;
                this.inboundCanonicalDrop = cdof.backDrop;
                if (inboundDir == 1 || inboundDir == 3) {
                    this.inboundAxis = 0;
                    this.inboundNorm = 1;
                } else {
                    this.inboundAxis = 1;
                    this.inboundNorm = 0;
                }
                int runDir = p1dof.runVector.canonicalDir();
                if (runDir == 1 || runDir == 3) {
                    this.runAxis = 0;
                    this.normAxis = 1;
                } else {
                    this.runAxis = 1;
                    this.normAxis = 0;
                }
            } else {
                this.outboundCanonicalDrop = cdof.runDrop;
                this.outboundCanonical = false;
                if (cdof.runPoint != null) {
                    this.outboundCanonical = true;
                    this.outboundCanonicalPoint = cdof.runPoint;
                } else if (!cdof.inboundIsCanonical && cdof.backupPoint != null) {
                    this.outboundCanonical = true;
                    this.outboundCanonicalPoint = cdof.backupPoint;
                }
                int runDir = cdof.runVector.canonicalDir();
                if (runDir == 1 || runDir == 3) {
                    this.runAxis = 0;
                    this.normAxis = 1;
                } else {
                    this.runAxis = 1;
                    this.normAxis = 0;
                }
            }
        }

        AxesAndCanonicals(LinkProperties.CornerDoF cdof, ForceDirsAndMatches fdam) {
            this.isForZero = true;
            this.lsid0 = cdof.myID;
            this.lsid1 = fdam.segID;
            int inboundDir = cdof.runVector.canonicalDir();
            this.inboundCanonical = cdof.inboundIsCanonical;
            this.inboundCanonicalDrop = cdof.backDrop;
            if (inboundDir == 1 || inboundDir == 3) {
                this.inboundAxis = 0;
                this.inboundNorm = 1;
            } else {
                this.inboundAxis = 1;
                this.inboundNorm = 0;
            }
            int runDir = fdam.forceDirs[1].canonicalDir();
            if (runDir == 1 || runDir == 3) {
                this.runAxis = 0;
                this.normAxis = 1;
            } else {
                this.runAxis = 1;
                this.normAxis = 0;
            }
        }

        AxesAndCanonicals(ForceDirsAndMatches fdam) {
            this.isForZero = false;
            int runDir = fdam.forceDirs[0].canonicalDir();
            if (runDir == 1 || runDir == 3) {
                this.runAxis = 0;
                this.normAxis = 1;
            } else {
                this.runAxis = 1;
                this.normAxis = 0;
            }
        }
    }

    public static class ForceDirsAndMatches {
        public static final int NONE = -1;
        public static final int DIRECT = 0;
        public static final int START_DROP = 1;
        public static final int END_DROP = 2;
        public Vector2D[] forceDirs;
        public boolean[] matches;
        public int type;
        public LinkSegmentID segID;

        public ForceDirsAndMatches(int type, LinkSegmentID segID) {
            this.type = type;
            this.segID = segID;
            this.forceDirs = new Vector2D[2];
            this.matches = new boolean[2];
        }
    }

    public static class PointDOFsPerSeg {
        public PointDegreesOfFreedom p0d;
        public PointDegreesOfFreedom p1d;
    }
}

