/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts.ortho;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;

public class FixOrthoPlan
implements Cloneable {
    private List commandList_ = new ArrayList();

    public Object clone() {
        try {
            FixOrthoPlan retval = (FixOrthoPlan)super.clone();
            retval.commandList_ = new ArrayList();
            int numSS = this.commandList_.size();
            for (int i = 0; i < numSS; ++i) {
                OrthoCommand oc = (OrthoCommand)this.commandList_.get(i);
                retval.commandList_.add(oc.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public void addCommand(OrthoCommand cmd) {
        this.commandList_.add(cmd);
    }

    public Iterator getCommands() {
        return this.commandList_.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FixOrthoPlan:\n");
        int numCmd = this.commandList_.size();
        for (int i = 0; i < numCmd; ++i) {
            OrthoCommand oc = (OrthoCommand)this.commandList_.get(i);
            buf.append("  ");
            buf.append(oc.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public static class SplitSeg
    implements Cloneable {
        public LinkSegmentID start;
        public LinkSegmentID middle;
        public LinkSegmentID end;

        public SplitSeg(LinkSegmentID start) {
            this.start = start;
        }

        public String toString() {
            return "SplitSeg start = [ " + this.start + " ] middle = [ " + this.middle + " ] end = [ " + this.end;
        }

        public void split(LinkSegmentID[] splits) {
            if (this.end == null) {
                this.start = splits[0];
                this.end = splits[1];
            } else {
                this.middle = splits[0];
                this.end = splits[1];
            }
        }

        public int splitCount() {
            if (this.end == null) {
                return 0;
            }
            if (this.middle == null) {
                return 1;
            }
            return 2;
        }

        public LinkSegmentID forMoveOp(int op) {
            if (op == 0) {
                return this.start;
            }
            if (op == 1) {
                if (this.end == null) {
                    return this.start;
                }
                return this.end;
            }
            throw new IllegalArgumentException();
        }

        public LinkSegmentID forSplitOp(int op) {
            if (op == 2) {
                return this.start;
            }
            if (op == 3) {
                if (this.end == null) {
                    return this.start;
                }
                return this.end;
            }
            throw new IllegalArgumentException();
        }

        public Object clone() {
            try {
                SplitSeg retval = (SplitSeg)super.clone();
                retval.start = this.start == null ? null : (LinkSegmentID)this.start.clone();
                retval.middle = this.middle == null ? null : (LinkSegmentID)this.middle.clone();
                retval.end = this.end == null ? null : (LinkSegmentID)this.end.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }

    public static class OrthoCommand {
        public static final int POINT_0 = 0;
        public static final int POINT_1 = 1;
        public static final int MAKE_SPLIT_0 = 2;
        public static final int MAKE_SPLIT_1 = 3;
        public static final int UNDEF = 0;
        public static final int MOVE_X = 1;
        public static final int MOVE_Y = 2;
        public int op;
        public int what;
        public double val0;
        public double val1;

        public OrthoCommand(int op, int what, double howMuch) {
            this.op = op;
            this.what = what;
            this.val0 = howMuch;
        }

        public OrthoCommand(int op, double val0, double val1) {
            this.op = op;
            this.val0 = val0;
            this.val1 = val1;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("OrthoCommand: ");
            if (this.op == 0 || this.op == 1) {
                buf.append(this.op == 0 ? "Point 0: " : "Point 1: ");
                buf.append(this.what == 1 ? "Move X " : "Move Y ");
                buf.append(this.val0);
            } else if (this.op == 2 || this.op == 3) {
                buf.append(this.op == 2 ? "Split 0: " : "Split 1: ");
                buf.append("New Point (");
                buf.append(this.val0);
                buf.append(", ");
                buf.append(this.val1);
                buf.append(")");
            }
            return buf.toString();
        }

        public void apply(LinkProperties lp, SplitSeg split, LinkSegment geom) {
            if (this.op == 0 || this.op == 1) {
                Point2D start;
                LinkSegmentID[] lsid = new LinkSegmentID[1];
                LinkSegmentID toTag = split.forMoveOp(this.op);
                LinkSegmentID tagged = (LinkSegmentID)toTag.clone();
                tagged.tagIDWithEndpoint(this.op == 0 ? "S" : "E");
                lsid[0] = tagged;
                Point2D point2D = start = this.op == 0 ? geom.getStart() : geom.getEnd();
                if (this.what == 1) {
                    lp.moveBusLinkSegments(lsid, start, this.val0, 0.0);
                } else {
                    lp.moveBusLinkSegments(lsid, start, 0.0, this.val0);
                }
                return;
            }
            if (this.op == 2 || this.op == 3) {
                Point2D.Double pt = new Point2D.Double(this.val0, this.val1);
                LinkSegmentID toTag = split.forSplitOp(this.op);
                LinkSegmentID tagged = (LinkSegmentID)toTag.clone();
                LinkSegmentID[] lsid = lp.linkSplitSupport(tagged, pt);
                if (lsid != null) {
                    LinkSegmentID root = lp.getRootSegmentID();
                    if (lsid[1].equals(root)) {
                        if (lp.getSegmentCount() == 1) {
                            lsid[1] = LinkSegmentID.buildIDForEndDrop(lp.getSingleLinkage());
                        } else {
                            List cseg = lp.getChildSegs(root);
                            if (cseg.size() != 1) {
                                throw new IllegalStateException();
                            }
                            lsid[1] = (LinkSegmentID)cseg.get(0);
                        }
                    }
                    split.split(lsid);
                }
                return;
            }
            throw new IllegalStateException();
        }

        public Object clone() {
            try {
                OrthoCommand retval = (OrthoCommand)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }
}

