/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts.ortho;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.layouts.ortho.FixOrthoPlan;
import org.systemsbiology.biotapestry.ui.layouts.ortho.PointDegreesOfFreedom;
import org.systemsbiology.biotapestry.util.UiUtil;

public class LinkSegStrategy
implements Cloneable {
    public static final int POINT_0_MOVE_X = 1;
    public static final int POINT_0_MOVE_Y = 2;
    public static final int POINT_1_MOVE_X = 4;
    public static final int POINT_1_MOVE_Y = 8;
    public static final int MOVE_A_POINT = 15;
    public static final int CREATE_SPLIT_0 = 16;
    public static final int CREATE_SPLIT_1 = 32;
    public static final int NO_GOAL = 0;
    public static final int P_0_X = 1;
    public static final int P_0_X_NEW = 2;
    public static final int P_0_Y = 3;
    public static final int P_0_Y_NEW = 4;
    public static final int P_1_X = 5;
    public static final int P_1_X_NEW = 6;
    public static final int P_1_Y = 7;
    public static final int P_1_Y_NEW = 8;
    public static final int S_0_X = 9;
    public static final int S_0_Y = 10;
    public static final int S_1_X = 11;
    public static final int S_1_Y = 12;
    public static final double ZERO_TOL_ = 0.1;
    private LinkSegmentID segID_;
    private int operations_;
    private List suchThat_;
    private boolean varyMoves_;
    private PointDegreesOfFreedom p0d_;
    private PointDegreesOfFreedom p1d_;

    public LinkSegStrategy(LinkSegmentID segID, int operations, List requirements, PointDegreesOfFreedom p0d, PointDegreesOfFreedom p1d, boolean varyMoves) {
        this.segID_ = segID;
        this.operations_ = operations;
        this.suchThat_ = requirements;
        this.p0d_ = p0d;
        this.p1d_ = p1d;
        this.varyMoves_ = varyMoves;
    }

    public boolean haveVariations() {
        return this.varyMoves_;
    }

    public int getVariations() {
        return this.varyMoves_ ? 3 : 1;
    }

    public String toString() {
        return this.segID_ + " " + this.operations_;
    }

    public Object clone() {
        try {
            LinkSegStrategy retval = (LinkSegStrategy)super.clone();
            retval.segID_ = (LinkSegmentID)this.segID_.clone();
            retval.p0d_ = (PointDegreesOfFreedom)this.p0d_.clone();
            retval.p1d_ = (PointDegreesOfFreedom)this.p1d_.clone();
            retval.suchThat_ = new ArrayList();
            int numSS = this.suchThat_.size();
            for (int i = 0; i < numSS; ++i) {
                Requirement req = (Requirement)this.suchThat_.get(i);
                retval.suchThat_.add(req.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public LinkSegmentID getSegID() {
        return this.segID_;
    }

    public FixOrthoPlan getPlan(Point2D pt1, Point2D pt2, int varNum, int totVar) {
        if ((this.operations_ & 0x10) != 0) {
            if ((this.operations_ & 0x20) != 0) {
                return this.doDoubleSplit(pt1, pt2, varNum, totVar);
            }
            return this.doSingleSplit(pt1, pt2);
        }
        return this.doMoves(pt1, pt2);
    }

    public int getVarNum(Point2D pt1, Point2D pt2) {
        if (!this.varyMoves_) {
            throw new IllegalArgumentException();
        }
        int xCount = Math.abs((int)((pt2.getX() - pt1.getX()) / 10.0));
        int yCount = Math.abs((int)((pt2.getY() - pt1.getY()) / 10.0));
        int varCount = 1;
        Iterator rit = this.suchThat_.iterator();
        while (rit.hasNext()) {
            Requirement req = (Requirement)rit.next();
            if (req.op != 0) {
                throw new IllegalStateException();
            }
            if (req.first == 10 && req.second == 12) {
                varCount = yCount;
                break;
            }
            if (req.first != 9 || req.second != 11) continue;
            varCount = xCount;
            break;
        }
        return varCount;
    }

    private FixOrthoPlan doDoubleSplit(Point2D pt1, Point2D pt2, int varNum, int totVar) {
        if (!this.varyMoves_ && varNum != 0) {
            throw new IllegalArgumentException();
        }
        int midPoint = totVar / 2;
        int useVar = varNum == 0 ? midPoint : (varNum < midPoint ? varNum - 1 : varNum);
        double split1X = pt1.getX();
        double split1Y = pt1.getY();
        double split2X = pt2.getX();
        double split2Y = pt2.getY();
        FixOrthoPlan fop = new FixOrthoPlan();
        double midRawX = pt1.getX() + (double)useVar * 10.0 * (pt2.getX() > pt1.getX() ? 1.0 : -1.0);
        double midRawY = pt1.getY() + (double)useVar * 10.0 * (pt2.getY() > pt1.getY() ? 1.0 : -1.0);
        double midX = UiUtil.forceToGridValue(midRawX, 10.0);
        double midY = UiUtil.forceToGridValue(midRawY, 10.0);
        Iterator rit = this.suchThat_.iterator();
        while (rit.hasNext()) {
            Requirement req = (Requirement)rit.next();
            if (req.op != 0) {
                throw new IllegalStateException();
            }
            if (req.first == 9 && req.second == 1) {
                split1X = pt1.getX();
                continue;
            }
            if (req.first == 10 && req.second == 12) {
                split1Y = midY;
                split2Y = midY;
                continue;
            }
            if (req.first == 11 && req.second == 5) {
                split2X = pt2.getX();
                continue;
            }
            if (req.first == 10 && req.second == 3) {
                split1Y = pt1.getY();
                continue;
            }
            if (req.first == 9 && req.second == 11) {
                split1X = midX;
                split2X = midX;
                continue;
            }
            if (req.first != 12 || req.second != 7) continue;
            split2Y = pt2.getY();
        }
        fop.addCommand(new FixOrthoPlan.OrthoCommand(2, split1X, split1Y));
        fop.addCommand(new FixOrthoPlan.OrthoCommand(3, split2X, split2Y));
        if (!fop.getCommands().hasNext()) {
            // empty if block
        }
        return fop;
    }

    private FixOrthoPlan doSingleSplit(Point2D pt1, Point2D pt2) {
        FixOrthoPlan fop = new FixOrthoPlan();
        double splitX = 0.0;
        double splitY = 0.0;
        double deltaX = 0.0;
        double deltaY = 0.0;
        Iterator rit = this.suchThat_.iterator();
        while (rit.hasNext()) {
            Requirement req = (Requirement)rit.next();
            if (req.op != 0) {
                throw new IllegalStateException();
            }
            if (req.first == 9) {
                if (req.second == 1) {
                    splitX = pt1.getX();
                    continue;
                }
                if (req.second == 5) {
                    splitX = pt2.getX();
                    continue;
                }
                if (req.second != 2 && req.second != 6) continue;
                deltaX = UiUtil.forceToGridValue((pt2.getX() - pt1.getX()) / 2.0, 10.0);
                if (req.second == 2) {
                    splitX = pt1.getX() + deltaX;
                    continue;
                }
                splitX = pt2.getX() - deltaX;
                continue;
            }
            if (req.first != 10) continue;
            if (req.second == 3) {
                splitY = pt1.getY();
                continue;
            }
            if (req.second == 7) {
                splitY = pt2.getY();
                continue;
            }
            if (req.second != 4 && req.second != 8) continue;
            deltaY = UiUtil.forceToGridValue((pt2.getY() - pt1.getY()) / 2.0, 10.0);
            if (req.second == 4) {
                splitY = pt1.getY() + deltaY;
                continue;
            }
            splitY = pt2.getY() - deltaY;
        }
        fop.addCommand(new FixOrthoPlan.OrthoCommand(2, splitX, splitY));
        if ((this.operations_ & 0xF) != 0) {
            if ((this.operations_ & 1) != 0) {
                if (Math.abs(deltaX) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(0, 1, deltaX));
                }
            } else if ((this.operations_ & 2) != 0) {
                if (Math.abs(deltaY) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(0, 2, deltaY));
                }
            } else if ((this.operations_ & 4) != 0) {
                if (Math.abs(deltaX) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(1, 1, -deltaX));
                }
            } else if ((this.operations_ & 8) != 0) {
                if (Math.abs(deltaY) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(1, 2, -deltaY));
                }
            } else {
                throw new IllegalStateException();
            }
        }
        if (!fop.getCommands().hasNext()) {
            // empty if block
        }
        return fop;
    }

    private FixOrthoPlan doMoves(Point2D pt1, Point2D pt2) {
        double deltaY;
        double deltaX;
        FixOrthoPlan fop = new FixOrthoPlan();
        if (this.suchThat_.size() != 1) {
            throw new IllegalStateException();
        }
        Requirement req = (Requirement)this.suchThat_.get(0);
        if (req.op != 0) {
            throw new IllegalStateException();
        }
        if ((this.operations_ & 1) != 0) {
            if (req.first == 2 && req.second == 5) {
                deltaX = pt2.getX() - pt1.getX();
                if (Math.abs(deltaX) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(0, 1, deltaX));
                }
            } else if (req.first == 2 && req.second == 6 && Math.abs(deltaX = UiUtil.forceToGridValue((pt2.getX() - pt1.getX()) / 2.0, 10.0)) > 0.1) {
                fop.addCommand(new FixOrthoPlan.OrthoCommand(0, 1, deltaX));
            }
        }
        if ((this.operations_ & 2) != 0) {
            if (req.first == 4 && req.second == 7) {
                deltaY = pt2.getY() - pt1.getY();
                if (Math.abs(deltaY) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(0, 2, deltaY));
                }
            } else if (req.first == 4 && req.second == 8 && Math.abs(deltaY = UiUtil.forceToGridValue((pt2.getY() - pt1.getY()) / 2.0, 10.0)) > 0.1) {
                fop.addCommand(new FixOrthoPlan.OrthoCommand(0, 2, deltaY));
            }
        }
        if ((this.operations_ & 4) != 0) {
            if (req.first == 6 && req.second == 1) {
                deltaX = pt2.getX() - pt1.getX();
                if (Math.abs(deltaX) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(1, 1, -deltaX));
                }
            } else if (req.first == 2 && req.second == 6) {
                deltaX = UiUtil.forceToGridValue((pt2.getX() - pt1.getX()) / 2.0, 10.0);
                double midX = pt1.getX() + deltaX;
                if (Math.abs(midX - pt2.getX()) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(1, 1, midX - pt2.getX()));
                }
            }
        }
        if ((this.operations_ & 8) != 0) {
            if (req.first == 8 && req.second == 3) {
                deltaY = pt2.getY() - pt1.getY();
                if (Math.abs(deltaY) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(1, 2, -deltaY));
                }
            } else if (req.first == 4 && req.second == 8) {
                deltaY = UiUtil.forceToGridValue((pt2.getY() - pt1.getY()) / 2.0, 10.0);
                double midY = pt1.getY() + deltaY;
                if (Math.abs(midY - pt2.getY()) > 0.1) {
                    fop.addCommand(new FixOrthoPlan.OrthoCommand(1, 2, midY - pt2.getY()));
                }
            }
        }
        if (!fop.getCommands().hasNext()) {
            // empty if block
        }
        return fop;
    }

    public static class Requirement
    implements Cloneable {
        public static final int EQUALS = 0;
        public int first;
        public int op;
        public int second;

        public Requirement(int first, int op, int second) {
            this.first = first;
            this.op = op;
            this.second = second;
        }

        public Object clone() {
            try {
                Requirement retval = (Requirement)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }
}

