/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.layouts.ortho;

import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.layouts.ortho.FixOrthoOptions;
import org.systemsbiology.biotapestry.ui.layouts.ortho.FixOrthoPlan;
import org.systemsbiology.biotapestry.ui.layouts.ortho.LinkSegStrategy;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class TreeStrategy
implements Cloneable {
    private ArrayList segStrategies_ = new ArrayList();
    private ArrayList variations_ = new ArrayList();

    public Object clone() {
        try {
            TreeStrategy retval = (TreeStrategy)super.clone();
            retval.segStrategies_ = new ArrayList();
            int numSS = this.segStrategies_.size();
            for (int i = 0; i < numSS; ++i) {
                LinkSegStrategy strat = (LinkSegStrategy)this.segStrategies_.get(i);
                retval.segStrategies_.add(strat.clone());
            }
            retval.variations_ = new ArrayList();
            int numPl = this.variations_.size();
            for (int i = 0; i < numPl; ++i) {
                StrategyVariation sv = (StrategyVariation)this.variations_.get(i);
                retval.variations_.add(sv.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public void addSegStrategy(LinkSegStrategy strat) {
        this.segStrategies_.add(strat);
    }

    public void mergeSegStrategies(TreeStrategy other) {
        this.segStrategies_.addAll(other.segStrategies_);
    }

    public int generatePlans(Genome genome, Layout lo, FontRenderContext frc, LinkProperties lp, FixOrthoOptions.FixOrthoTreeInfo foti) {
        boolean needCount = false;
        Iterator tsit = this.segStrategies_.iterator();
        while (tsit.hasNext()) {
            LinkSegStrategy str = (LinkSegStrategy)tsit.next();
            if (!str.haveVariations()) continue;
            needCount = true;
            break;
        }
        int count = 1;
        if (needCount) {
            LinkProperties countingCopy = (LinkProperties)lp.clone();
            HashMap<LinkSegmentID, FixOrthoPlan.SplitSeg> countingSplitMap = new HashMap<LinkSegmentID, FixOrthoPlan.SplitSeg>();
            StrategyVariation countingSv = new StrategyVariation();
            tsit = this.segStrategies_.iterator();
            while (tsit.hasNext()) {
                LinkSegStrategy str = (LinkSegStrategy)tsit.next();
                LinkSegmentID lsid = str.getSegID();
                countingSv.segIDs.add(lsid);
                FixOrthoPlan.SplitSeg split = (FixOrthoPlan.SplitSeg)countingSplitMap.get(lsid);
                if (split == null) {
                    split = new FixOrthoPlan.SplitSeg(lsid);
                    countingSplitMap.put(lsid, split);
                }
                LinkSegmentID useForGeom = split.end == null ? split.start : split.end;
                LinkSegment planSeg = countingCopy.getSegmentGeometryForID(useForGeom, genome, lo, frc, false);
                if (str.haveVariations()) {
                    int nextCount = str.getVarNum(planSeg.getStart(), planSeg.getEnd());
                    if (count > 1) {
                        throw new IllegalStateException();
                    }
                    count = nextCount;
                }
                FixOrthoPlan fop = str.getPlan(planSeg.getStart(), planSeg.getEnd(), 0, 2);
                countingSv.plans.add(fop);
                countingSv.splits.add(split.clone());
                countingSv.applyFOP(fop, lsid, split, countingCopy, foti);
            }
        }
        for (int i = 0; i < count; ++i) {
            LinkProperties workingCopy = (LinkProperties)lp.clone();
            HashMap<LinkSegmentID, FixOrthoPlan.SplitSeg> splitMap = new HashMap<LinkSegmentID, FixOrthoPlan.SplitSeg>();
            StrategyVariation sv = new StrategyVariation();
            tsit = this.segStrategies_.iterator();
            while (tsit.hasNext()) {
                LinkSegStrategy str = (LinkSegStrategy)tsit.next();
                LinkSegmentID lsid = str.getSegID();
                sv.segIDs.add(lsid);
                FixOrthoPlan.SplitSeg split = (FixOrthoPlan.SplitSeg)splitMap.get(lsid);
                if (split == null) {
                    split = new FixOrthoPlan.SplitSeg(lsid);
                    splitMap.put(lsid, split);
                }
                LinkSegmentID useForGeom = split.end == null ? split.start : split.end;
                LinkSegment planSeg = workingCopy.getSegmentGeometryForID(useForGeom, genome, lo, frc, false);
                FixOrthoPlan fop = str.getPlan(planSeg.getStart(), planSeg.getEnd(), i, count - 1);
                sv.plans.add(fop);
                sv.splits.add(split.clone());
                sv.applyFOP(fop, lsid, split, workingCopy, foti);
            }
            this.variations_.add(sv);
        }
        return count;
    }

    public boolean canApply(int varNum, LinkPlacementGrid grid, Genome genome, Layout layout, FontRenderContext frc, LinkProperties lp, FixOrthoOptions.FixOrthoTreeInfo foti, String overID) {
        Set skipThese = this.crappySegments(grid, genome, layout, frc, lp, null, false, overID);
        LinkProperties workingCopy = (LinkProperties)lp.clone();
        StrategyVariation sv = (StrategyVariation)this.variations_.get(varNum);
        sv.applyPlanGuts(workingCopy, foti);
        Set killerSeg = this.crappySegments(grid, genome, layout, frc, workingCopy, skipThese, true, overID);
        return killerSeg.isEmpty();
    }

    private Set crappySegments(LinkPlacementGrid grid, Genome genome, Layout layout, FontRenderContext frc, LinkProperties lp, Set skipSegs, boolean returnOnFirst, String overID) {
        HashSet<Line2D.Double> retval = new HashSet<Line2D.Double>();
        String src = lp.getSourceTag();
        Map segGeoms = lp.getAllSegmentGeometries(genome, layout, frc, true);
        Iterator sgkit = segGeoms.keySet().iterator();
        while (sgkit.hasNext()) {
            LinkSegmentID segID = (LinkSegmentID)sgkit.next();
            LinkSegment geom = (LinkSegment)segGeoms.get(segID);
            Vector2D run = geom.getRun();
            if (run == null || run.isZero() || !run.isCanonical()) continue;
            boolean isStart = segID.isForStartDrop() || segID.isDirect();
            boolean isEnd = segID.isForEndDrop() || segID.isDirect();
            Set throughLinks = lp.resolveLinkagesThroughSegment(segID, genome);
            String trg = null;
            HashSet<String> okGroups = null;
            if (isStart) {
                String aLink = (String)throughLinks.iterator().next();
                if (overID == null && this.crappyStart(genome, layout, src, geom, skipSegs, aLink, retval)) continue;
            }
            if (throughLinks.size() == 1) {
                String trgLinkID = (String)throughLinks.iterator().next();
                if (overID == null && genome instanceof GenomeInstance) {
                    okGroups = new HashSet<String>();
                    GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(trgLinkID);
                    okGroups.add(tup.getSourceGroup());
                    okGroups.add(tup.getTargetGroup());
                }
                if (overID == null) {
                    Linkage trgLink = genome.getLinkage(trgLinkID);
                    trg = trgLink.getTarget();
                    LinkSegment modGeom = this.crappyTarg(genome, layout, geom, trgLinkID, segGeoms, segID);
                    if (modGeom == null) continue;
                    geom = modGeom;
                }
                if (overID != null) {
                    okGroups = new HashSet();
                }
            }
            Line2D.Double equivLine = new Line2D.Double((Point2D)geom.getStart().clone(), (Point2D)geom.getEnd().clone());
            if (skipSegs != null && UiUtil.lineInSet(equivLine, skipSegs) || grid.orthoPlanAllowed(src, geom, trg, okGroups, isStart, isEnd)) continue;
            retval.add(equivLine);
            if (!returnOnFirst) continue;
            return retval;
        }
        return retval;
    }

    private boolean crappyStart(Genome genome, Layout layout, String src, LinkSegment geom, Set skipSegs, String aLink, Set crappySegs) {
        Node srcNode = genome.getNode(src);
        NodeProperties np = layout.getNodeProperties(src);
        INodeRenderer render = np.getRenderer();
        Linkage link = genome.getLinkage(aLink);
        Vector2D launchDir = render.getDepartureDirection(link.getLaunchPad(), srcNode, layout);
        Vector2D run = geom.getRun();
        if (!run.equals(launchDir)) {
            Line2D.Double equivLine = new Line2D.Double((Point2D)geom.getStart().clone(), (Point2D)geom.getEnd().clone());
            if (skipSegs != null) {
                if (!UiUtil.lineInSet(equivLine, skipSegs)) {
                    crappySegs.add(equivLine);
                    return true;
                }
            } else {
                crappySegs.add(equivLine);
                return true;
            }
        }
        return false;
    }

    private LinkSegment crappyTarg(Genome genome, Layout layout, LinkSegment geom, String trgLinkID, Map segGeoms, LinkSegmentID segID) {
        Linkage link = genome.getLinkage(trgLinkID);
        String trgID = link.getTarget();
        Node trgNode = genome.getNode(trgID);
        NodeProperties np = layout.getNodeProperties(trgID);
        INodeRenderer render = np.getRenderer();
        Vector2D terminalDir = render.getArrivalDirection(link.getLandingPad(), trgNode, layout);
        LinkSegmentID termID = segID.isDirect() ? LinkSegmentID.buildIDForDirect(trgLinkID) : LinkSegmentID.buildIDForEndDrop(trgLinkID);
        LinkSegment termGeom = (LinkSegment)segGeoms.get(termID);
        Point2D terminalPt = termGeom.getEnd();
        double length = termGeom.getLength();
        double offGrid = length - UiUtil.forceToGridValueMin(length, 10.0);
        if (segID.equals(termID) && length < offGrid + 10.0) {
            return null;
        }
        Point2D lastGrid = terminalDir.scaled(-offGrid).add(terminalPt);
        Point2D lastSafe = terminalDir.scaled(-10.0).add(lastGrid);
        UiUtil.forceToGrid(lastSafe, 10.0);
        LinkSegment retGeom = (LinkSegment)geom.clone();
        if (geom.getRun().equals(terminalDir) && geom.intersects(lastSafe, 1.0E-6) != null) {
            retGeom.setEnd(lastSafe);
        }
        return retGeom;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TreeStrategy:\n");
        int numVar = this.variations_.size();
        for (int i = 0; i < numVar; ++i) {
            StrategyVariation sv = (StrategyVariation)this.variations_.get(i);
            buf.append("*************************");
            buf.append(this.variations_.toString());
            buf.append("\n");
        }
        if (numVar == 0) {
            Iterator tsit = this.segStrategies_.iterator();
            while (tsit.hasNext()) {
                LinkSegStrategy str = (LinkSegStrategy)tsit.next();
                buf.append("------------");
                buf.append(str.toString());
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public PlanRanking getRanking(int varNum, boolean minCorners, LinkProperties lp, Genome genome, Layout lo, FontRenderContext frc, FixOrthoOptions.FixOrthoTreeInfo foti) {
        LinkProperties lpc = (LinkProperties)lp.clone();
        StrategyVariation sv = (StrategyVariation)this.variations_.get(varNum);
        List splitList = sv.applyPlanGuts(lpc, foti);
        HashMap<LinkSegmentID, FixOrthoPlan.SplitSeg> segToSplit = new HashMap<LinkSegmentID, FixOrthoPlan.SplitSeg>();
        int numSeg = sv.segIDs.size();
        for (int i = 0; i < numSeg; ++i) {
            LinkSegmentID lsid = (LinkSegmentID)sv.segIDs.get(i);
            FixOrthoPlan.SplitSeg ss = (FixOrthoPlan.SplitSeg)splitList.get(i);
            segToSplit.put(lsid, ss);
        }
        int splitCount = 0;
        int numSP = splitList.size();
        for (int i = 0; i < numSP; ++i) {
            FixOrthoPlan.SplitSeg sps = (FixOrthoPlan.SplitSeg)splitList.get(i);
            splitCount += sps.splitCount();
        }
        Map origGeoms = lp.getAllSegmentGeometries(genome, lo, frc, false);
        Map modGeoms = lpc.getAllSegmentGeometries(genome, lo, frc, false);
        double nonOrthoArea = LinkProperties.getNonOrthogonalArea(modGeoms);
        double distanceDiff = 0.0;
        Iterator stskit = segToSplit.keySet().iterator();
        while (stskit.hasNext()) {
            LinkSegment modSegGeom;
            LinkSegmentID lsid = (LinkSegmentID)stskit.next();
            FixOrthoPlan.SplitSeg ss = (FixOrthoPlan.SplitSeg)segToSplit.get(lsid);
            int nextCount = ss.splitCount();
            LinkSegment origSegGeom = (LinkSegment)origGeoms.get(lsid);
            if (nextCount == 0) {
                modSegGeom = (LinkSegment)modGeoms.get(ss.start);
                distanceDiff += origSegGeom.getEndpointDistanceSum(modSegGeom);
                continue;
            }
            if (nextCount == 1) {
                LinkSegment modSegGeomSt = (LinkSegment)modGeoms.get(ss.start);
                double startDiff = origSegGeom.getEndpointDistanceSum(modSegGeomSt);
                LinkSegment modSegGeomEnd = (LinkSegment)modGeoms.get(ss.end);
                double endDiff = origSegGeom.getEndpointDistanceSum(modSegGeomEnd);
                distanceDiff += Math.min(startDiff, endDiff);
                continue;
            }
            modSegGeom = (LinkSegment)modGeoms.get(ss.middle);
            distanceDiff += origSegGeom.getEndpointDistanceSum(modSegGeom);
        }
        PlanRanking retval = new PlanRanking(minCorners, splitCount, distanceDiff, nonOrthoArea);
        return retval;
    }

    public void applyPlan(int varNum, LinkProperties lp, FixOrthoOptions.FixOrthoTreeInfo foti) {
        StrategyVariation sv = (StrategyVariation)this.variations_.get(varNum);
        sv.applyPlanGuts(lp, foti);
    }

    private static class StrategyVariation
    implements Cloneable {
        ArrayList plans = new ArrayList();
        ArrayList segIDs = new ArrayList();
        ArrayList splits = new ArrayList();

        public Object clone() {
            try {
                StrategyVariation retval = (StrategyVariation)super.clone();
                retval.plans = new ArrayList();
                int numPl = this.plans.size();
                for (int i = 0; i < numPl; ++i) {
                    FixOrthoPlan fop = (FixOrthoPlan)this.plans.get(i);
                    retval.plans.add(fop.clone());
                }
                retval.segIDs = new ArrayList();
                int numSID = this.segIDs.size();
                for (int i = 0; i < numSID; ++i) {
                    LinkSegmentID lsid = (LinkSegmentID)this.segIDs.get(i);
                    retval.segIDs.add(lsid.clone());
                }
                retval.splits = new ArrayList();
                int numSP = this.splits.size();
                for (int i = 0; i < numSP; ++i) {
                    FixOrthoPlan.SplitSeg sps = (FixOrthoPlan.SplitSeg)this.splits.get(i);
                    retval.splits.add(sps.clone());
                }
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        List applyPlanGuts(LinkProperties lp, FixOrthoOptions.FixOrthoTreeInfo foti) {
            ArrayList<Object> workingList = new ArrayList<Object>();
            int numSP = this.splits.size();
            for (int i = 0; i < numSP; ++i) {
                FixOrthoPlan.SplitSeg sps = (FixOrthoPlan.SplitSeg)this.splits.get(i);
                workingList.add(sps.clone());
            }
            int numPlan = this.plans.size();
            for (int i = 0; i < numPlan; ++i) {
                FixOrthoPlan fop = (FixOrthoPlan)this.plans.get(i);
                LinkSegmentID segID = (LinkSegmentID)this.segIDs.get(i);
                FixOrthoPlan.SplitSeg split = (FixOrthoPlan.SplitSeg)workingList.get(i);
                this.applyFOP(fop, segID, split, lp, foti);
            }
            return workingList;
        }

        void applyFOP(FixOrthoPlan fop, LinkSegmentID segID, FixOrthoPlan.SplitSeg split, LinkProperties lp, FixOrthoOptions.FixOrthoTreeInfo foti) {
            Iterator cmdit = fop.getCommands();
            while (cmdit.hasNext()) {
                FixOrthoPlan.OrthoCommand oc = (FixOrthoPlan.OrthoCommand)cmdit.next();
                LinkSegment geom = (LinkSegment)foti.segGeoms.get(segID);
                oc.apply(lp, split, geom);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("StrategyVariation:\n");
            int numCmd = this.plans.size();
            for (int i = 0; i < numCmd; ++i) {
                FixOrthoPlan fop = (FixOrthoPlan)this.plans.get(i);
                buf.append("------------");
                buf.append(this.segIDs.get(i).toString());
                buf.append("\n");
                buf.append(fop.toString());
            }
            return buf.toString();
        }
    }

    public static class PlanRanking
    implements Comparable {
        public int splitCount;
        public boolean minCorners;
        public double distRank;
        public double nonOrthoArea;

        public PlanRanking(boolean minCorners, int splitCount, double distRank, double nonOrthoArea) {
            this.minCorners = minCorners;
            this.splitCount = splitCount;
            this.distRank = distRank;
            this.nonOrthoArea = nonOrthoArea;
        }

        public int hashCode() {
            return new Boolean(this.minCorners).hashCode() + this.splitCount + (int)Math.round(this.distRank) + (int)Math.round(this.nonOrthoArea);
        }

        public String toString() {
            return "PlanRanking: splits = " + this.splitCount + " distRank = " + this.distRank + " nonOrthoArea = " + this.nonOrthoArea;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof PlanRanking)) {
                return false;
            }
            return this.compareTo(other) == 0;
        }

        public int compareTo(Object o) {
            PlanRanking other = (PlanRanking)o;
            if (this.nonOrthoArea != other.nonOrthoArea) {
                return this.nonOrthoArea < other.nonOrthoArea ? -1 : 1;
            }
            if (this.minCorners && this.splitCount != other.splitCount) {
                return this.splitCount < other.splitCount ? -1 : 1;
            }
            if (this.distRank == 0.0 && other.distRank != 0.0) {
                System.err.println("Bogus distance rank " + this);
                return 100;
            }
            if (other.distRank == 0.0 && this.distRank != 0.0) {
                System.err.println("Bogus distance rank " + other);
                return -100;
            }
            if (this.distRank != other.distRank) {
                return this.distRank < other.distRank ? -1 : 1;
            }
            if (!this.minCorners && this.splitCount != other.splitCount) {
                return this.splitCount < other.splitCount ? -1 : 1;
            }
            return 0;
        }
    }

    public static class StratAndVar {
        public int varNum;
        public TreeStrategy strat;

        public StratAndVar(TreeStrategy strat, int varNum) {
            this.strat = strat;
            this.varNum = varNum;
        }
    }
}

