/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Abbreviator {
    public Map abbreviate(Set strings, int maxLen) {
        return this.abbreviateAppend(new HashMap(), strings, maxLen);
    }

    public Map abbreviateAppend(Map existing, Set strings, int maxLen) {
        HashMap<String, HashSet<String>> starter = new HashMap<String, HashSet<String>>();
        HashMap<String, String> invExisting = new HashMap<String, String>();
        Iterator eit = existing.keySet().iterator();
        while (eit.hasNext()) {
            String ex = (String)eit.next();
            String oabb = (String)existing.get(ex);
            invExisting.put(oabb.toUpperCase(), ex.toUpperCase());
        }
        HashSet<String> empties = new HashSet<String>();
        Iterator sit = strings.iterator();
        while (sit.hasNext()) {
            String str = ((String)sit.next()).toUpperCase();
            if (str.trim().equals("")) {
                empties.add(str);
                continue;
            }
            String pref = str.substring(0, 1);
            HashSet<String> minSet = (HashSet<String>)starter.get(pref);
            if (minSet == null) {
                minSet = new HashSet<String>();
                starter.put(pref, minSet);
            }
            minSet.add(str);
        }
        HashSet disasters = new HashSet(empties);
        Iterator stit = starter.keySet().iterator();
        while (stit.hasNext()) {
            String pref = (String)stit.next();
            Set elemsForPref = (Set)starter.get(pref);
            HashMap useful = new HashMap();
            this.findUniqChars(1, elemsForPref, useful);
            List order = this.orderByCandidateCount(useful);
            HashMap results = new HashMap();
            char check = pref.charAt(0);
            this.findUniqueAbbrevs(check, useful, order, results);
            this.forceUnique(results, invExisting, disasters);
        }
        Iterator dit = disasters.iterator();
        while (dit.hasNext()) {
            String disaster = (String)dit.next();
            Set faSet = invExisting.keySet();
            String utag = this.getUniqueTag(faSet, maxLen);
            if (utag == null) {
                throw new IllegalArgumentException();
            }
            invExisting.put(utag, disaster);
        }
        HashMap<String, String> preRetval = new HashMap<String, String>();
        Iterator fit = invExisting.keySet().iterator();
        while (fit.hasNext()) {
            String abb = (String)fit.next();
            String orig = (String)invExisting.get(abb);
            preRetval.put(orig, abb);
        }
        HashMap<String, String> retval = new HashMap<String, String>();
        HashSet allStrs = new HashSet(strings);
        allStrs.addAll(existing.keySet());
        Iterator fit2 = allStrs.iterator();
        while (fit2.hasNext()) {
            String origStr = (String)fit2.next();
            String abb = (String)preRetval.get(origStr.toUpperCase());
            retval.put(origStr, abb);
        }
        return retval;
    }

    private void findUniqChars(int checkPos, Set elems, Map results) {
        String diffStr;
        HashSet<String> survivingElems = new HashSet<String>();
        HashMap<String, HashSet<String>> diffs = new HashMap<String, HashSet<String>>();
        Iterator eit = elems.iterator();
        while (eit.hasNext()) {
            String elem = (String)eit.next();
            if (elem.length() <= checkPos) {
                TreeSet<CharPos> cpsForElem = (TreeSet<CharPos>)results.get(elem);
                if (cpsForElem == null) {
                    cpsForElem = new TreeSet<CharPos>();
                    results.put(elem, cpsForElem);
                }
                cpsForElem.add(new CharPos("", checkPos));
                continue;
            }
            survivingElems.add(elem);
            diffStr = new String(elem.substring(checkPos, checkPos + 1));
            HashSet<String> elemsForChar = (HashSet<String>)diffs.get(diffStr);
            if (elemsForChar == null) {
                elemsForChar = new HashSet<String>();
                diffs.put(diffStr, elemsForChar);
            }
            elemsForChar.add(elem);
        }
        Iterator bit = diffs.keySet().iterator();
        while (bit.hasNext()) {
            diffStr = (String)bit.next();
            Set dbs = (Set)diffs.get(diffStr);
            if (dbs.size() != 1) continue;
            String elem = (String)dbs.iterator().next();
            TreeSet<CharPos> cpsForElem = (TreeSet<CharPos>)results.get(elem);
            if (cpsForElem == null) {
                cpsForElem = new TreeSet<CharPos>();
                results.put(elem, cpsForElem);
            }
            cpsForElem.add(new CharPos(diffStr, checkPos));
        }
        if (!survivingElems.isEmpty()) {
            this.findUniqChars(checkPos + 1, survivingElems, results);
        }
    }

    private List orderByCandidateCount(Map cands) {
        Integer sizeObj;
        TreeMap<Integer, ArrayList<String>> sortBins = new TreeMap<Integer, ArrayList<String>>();
        Iterator kit = cands.keySet().iterator();
        while (kit.hasNext()) {
            String cand = (String)kit.next();
            SortedSet cps = (SortedSet)cands.get(cand);
            sizeObj = new Integer(cps.size());
            ArrayList<String> candsForSize = (ArrayList<String>)sortBins.get(sizeObj);
            if (candsForSize == null) {
                candsForSize = new ArrayList<String>();
                sortBins.put(sizeObj, candsForSize);
            }
            candsForSize.add(cand);
        }
        ArrayList retval = new ArrayList();
        Iterator sbit = sortBins.keySet().iterator();
        while (sbit.hasNext()) {
            sizeObj = (Integer)sbit.next();
            ArrayList sbg = (ArrayList)sortBins.get(sizeObj);
            Collections.sort(sbg, new LengthComparator());
            retval.addAll(sbg);
        }
        return retval;
    }

    private void findUniqueAbbrevs(char firstChar, Map cands, List checkOrder, Map results) {
        int num = checkOrder.size();
        StringBuffer buf = new StringBuffer();
        block0: for (int i = 0; i < num; ++i) {
            String cand = (String)checkOrder.get(i);
            SortedSet diffs = (SortedSet)cands.get(cand);
            Iterator dit = diffs.iterator();
            while (dit.hasNext()) {
                CharPos cp = (CharPos)dit.next();
                buf.setLength(0);
                buf.append(firstChar);
                buf.append(cp.character);
                String abbrev = buf.toString();
                HashSet<String> rset = (HashSet<String>)results.get(abbrev);
                if (rset == null) {
                    rset = new HashSet<String>();
                    results.put(abbrev, rset);
                    rset.add(cand);
                    continue block0;
                }
                if (dit.hasNext()) continue;
                rset.add(cand);
            }
        }
    }

    private void forceUnique(Map results, Map fullAbbrev, Set disasters) {
        Iterator kit = results.keySet().iterator();
        while (kit.hasNext()) {
            String abbrev = (String)kit.next();
            Set rset = (Set)results.get(abbrev);
            if (rset.size() == 0) {
                throw new IllegalStateException();
            }
            if (rset.size() == 1) {
                String forAbbrev = (String)fullAbbrev.get(abbrev);
                if (forAbbrev != null) {
                    this.addThirdForUnique(abbrev, rset, fullAbbrev, disasters);
                    continue;
                }
                fullAbbrev.put(abbrev, rset.iterator().next());
                continue;
            }
            this.addThirdForUnique(abbrev, rset, fullAbbrev, disasters);
        }
    }

    private void addThirdForUnique(String abbrev, Set rset, Map fullAbbrev, Set disasters) {
        StringBuffer buf = new StringBuffer();
        Iterator rsit = rset.iterator();
        while (rsit.hasNext()) {
            String cand = (String)rsit.next();
            Character nextChar = new Character(this.getFirstCharacter());
            while (nextChar != null) {
                buf.setLength(0);
                buf.append(abbrev);
                buf.append(nextChar);
                String testAbbrev = (String)fullAbbrev.get(buf.toString());
                if (testAbbrev == null) {
                    fullAbbrev.put(buf.toString(), cand);
                    break;
                }
                nextChar = this.getNextCharacter(nextChar.charValue());
            }
            if (nextChar != null) continue;
            disasters.add(cand);
        }
    }

    private void dumpset(Map bins) {
        Iterator rit = bins.keySet().iterator();
        while (rit.hasNext()) {
            String key = (String)rit.next();
            Set abbrev = (Set)bins.get(key);
            System.out.println(key + " -> " + abbrev);
        }
    }

    private String getUniqueTag(Set existing, int maxLen) {
        if (maxLen < 1) {
            throw new IllegalArgumentException();
        }
        StringBuffer buf = new StringBuffer();
        char first = this.getFirstCharacter();
        buf.append(first);
        while (existing.contains(buf.toString())) {
            int lastPos = buf.length() - 1;
            char lastChar = buf.charAt(lastPos);
            buf.deleteCharAt(lastPos);
            Character next = this.getNextCharacter(lastChar);
            if (next == null) {
                if (lastPos == maxLen - 1) {
                    return null;
                }
                buf.append(lastChar);
                buf.append(this.getFirstCharacter());
                continue;
            }
            buf.append(next);
        }
        return buf.toString();
    }

    private char getFirstCharacter() {
        return '0';
    }

    private Character getNextCharacter(char lastChar) {
        if (lastChar == '9') {
            return new Character('_');
        }
        if (lastChar == '_') {
            return new Character('A');
        }
        if (lastChar == 'Z') {
            return null;
        }
        return new Character((char)(lastChar + '\u0001'));
    }

    public static void main(String[] argv) {
        Abbreviator abv = new Abbreviator();
        HashSet<String> inputs = new HashSet<String>();
        inputs.add("aaaa");
        inputs.add("aaab");
        inputs.add("aaaac");
        inputs.add("aaaaaaaad");
        inputs.add("cdefg");
        inputs.add("cdefga");
        inputs.add("ee1");
        inputs.add("eee");
        inputs.add("x");
        inputs.add("eee1");
        inputs.add("g12345");
        inputs.add("0");
        inputs.add("1");
        inputs.add("2");
        inputs.add("");
        inputs.add("    ");
        inputs.add("     ");
        Map results = abv.abbreviate(inputs, 3);
        Iterator rit = results.keySet().iterator();
        while (rit.hasNext()) {
            String str = (String)rit.next();
            String abbrev = (String)results.get(str);
            System.out.println(str + " ->(" + abbrev + ")");
        }
        HashSet<String> testSet = new HashSet<String>();
        testSet.add("EC");
        testSet.add("P");
        testSet.add("EM");
        results = abv.abbreviateAppend(new HashMap(), testSet, 3);
        rit = results.keySet().iterator();
        while (rit.hasNext()) {
            String str = (String)rit.next();
            String abbrev = (String)results.get(str);
            System.out.println(str + " -> " + abbrev);
        }
    }

    private static class CharPos
    implements Comparable {
        String character;
        int pos;

        CharPos(String character, int pos) {
            this.character = character;
            this.pos = pos;
        }

        public int hashCode() {
            return this.pos + this.character.hashCode();
        }

        public String toString() {
            return this.character + ": " + this.pos;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof CharPos)) {
                return false;
            }
            return this.compareTo(other) == 0;
        }

        public int compareTo(Object o) {
            CharPos other = (CharPos)o;
            int posDiff = this.pos - other.pos;
            if (posDiff != 0) {
                return posDiff;
            }
            return this.character.compareTo(other.character);
        }
    }

    private static class LengthComparator
    implements Comparator {
        private LengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.length() - s2.length();
        }
    }
}

