/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.util.Vector2D;

public class AffineCombination {
    private static final int MAXIMUM = 0;
    private static final int AVERAGE = 1;

    public static Point2D combination(Set points, double gridVal) {
        int num = points.size();
        if (num == 0) {
            throw new IllegalArgumentException();
        }
        Iterator pint = points.iterator();
        double xSum = 0.0;
        double ySum = 0.0;
        while (pint.hasNext()) {
            Point2D pt = (Point2D)pint.next();
            xSum += pt.getX();
            ySum += pt.getY();
        }
        double newX = xSum / (double)num;
        double newY = ySum / (double)num;
        if (gridVal > 0.0) {
            newX = (double)Math.round(newX / gridVal) * gridVal;
            newY = (double)Math.round(newY / gridVal) * gridVal;
        }
        return new Point2D.Double(newX, newY);
    }

    public static Point2D combination(List points, double[] weights, double gridVal) {
        int wNum = weights.length;
        int num = points.size();
        if (wNum != num) {
            throw new IllegalArgumentException();
        }
        double xSum = 0.0;
        double ySum = 0.0;
        double wSum = 0.0;
        for (int i = 0; i < num; ++i) {
            Point2D pt = (Point2D)points.get(i);
            double weight = weights[i];
            xSum += pt.getX() * weight;
            ySum += pt.getY() * weight;
            wSum += weight;
        }
        double newX = xSum / wSum;
        double newY = ySum / wSum;
        if (gridVal > 0.0) {
            newX = (double)Math.round(newX / gridVal) * gridVal;
            newY = (double)Math.round(newY / gridVal) * gridVal;
        }
        return new Point2D.Double(newX, newY);
    }

    public static boolean getWeights(double val1, double val2, double calcForVal, double[] toFill) {
        if (val1 == val2) {
            return false;
        }
        toFill[0] = (calcForVal - val2) / (val1 - val2);
        toFill[1] = 1.0 - toFill[0];
        return true;
    }

    public static boolean getWeights(Point2D point, Point2D[] pointSet, double[] toFill) {
        Frame frame;
        if (pointSet.length != 3 || toFill.length != 3) {
            throw new IllegalArgumentException();
        }
        try {
            frame = new Frame(pointSet[0], pointSet[1], pointSet[2]);
        }
        catch (NoninvertibleTransformException nte) {
            return false;
        }
        frame.coords(point, toFill);
        toFill[2] = toFill[1];
        toFill[1] = toFill[0];
        toFill[0] = 1.0 - toFill[2] - toFill[1];
        return true;
    }

    public static Frame buildAFrame(Point2D origin, Point2D positiveX) {
        Vector2D posXVec = new Vector2D(origin, positiveX).normalized();
        Vector2D posYVec = posXVec.normal();
        if (posYVec == null) {
            return null;
        }
        try {
            return new Frame(origin, posXVec, posYVec);
        }
        catch (NoninvertibleTransformException nte) {
            return null;
        }
    }

    public static List getWeights(List points, Point2D point) {
        Map indexMap = AffineCombination.createIndexMap(points);
        ArrayList working = new ArrayList(indexMap.keySet());
        List ordered = AffineCombination.orderPoints(working, point);
        if (ordered == null) {
            return null;
        }
        int size = ordered.size();
        ArrayList[] weights = new ArrayList[size];
        for (int i = 0; i < size; ++i) {
            weights[i] = new ArrayList();
        }
        int[] indices = new int[3];
        double[] toFill = new double[3];
        double sum = 0.0;
        Point2D[] pointSet = new Point2D[3];
        for (int i = 0; i < size; ++i) {
            AffineCombination.chooseBasisIndices(ordered, i, indices);
            pointSet[0] = (Point2D)ordered.get(indices[0]);
            pointSet[1] = (Point2D)ordered.get(indices[1]);
            pointSet[2] = (Point2D)ordered.get(indices[2]);
            if (!AffineCombination.getWeights(point, pointSet, toFill)) continue;
            weights[indices[0]].add(new Double(toFill[0]));
            weights[indices[1]].add(new Double(toFill[1]));
            weights[indices[2]].add(new Double(toFill[2]));
            sum += toFill[0] + toFill[1] + toFill[2];
        }
        if (sum == 0.0) {
            return null;
        }
        return AffineCombination.distributeWeights(indexMap, ordered, weights, sum, points.size());
    }

    public static Point2D radialPointPosition(Set oldPoints, Point2D oldPoint, Set newPoints) {
        Point2D oldCentroid = AffineCombination.combination(oldPoints, 0.0);
        Point2D newCentroid = AffineCombination.combination(newPoints, 0.0);
        double oldRadius = AffineCombination.getCloudDistance(oldPoints, oldCentroid, 1);
        double newRadius = AffineCombination.getCloudDistance(newPoints, newCentroid, 1);
        double oldDistance = oldCentroid.distance(oldPoint);
        double newDistance = oldRadius != 0.0 ? oldDistance * (newRadius / oldRadius) : oldDistance;
        double angle = 0.0;
        if (oldDistance > 0.01) {
            Vector2D xAxis = new Vector2D(1.0, 0.0);
            Vector2D yAxis = new Vector2D(0.0, 1.0);
            try {
                Frame frame = new Frame(oldCentroid, xAxis, yAxis);
                angle = frame.getAngle(oldPoint);
            }
            catch (NoninvertibleTransformException ntex) {
                throw new IllegalStateException();
            }
        }
        Point2D newPt = AffineCombination.generatePointWithPolarCoords(newCentroid, newDistance, angle);
        return newPt;
    }

    public static Point2D generatePointWithPolarCoords(Point2D origin, double radius, double angle) {
        double vecX = Math.cos(angle);
        double vecY = Math.sin(angle);
        double originX = origin.getX();
        double originY = origin.getY();
        double newX = originX + vecX * radius;
        double newY = originY + vecY * radius;
        return new Point2D.Double(newX, newY);
    }

    private AffineCombination() {
    }

    private static double getCloudDistance(Set points, Point2D point, int mode) {
        Iterator pit = points.iterator();
        double sum = 0.0;
        double max = Double.NEGATIVE_INFINITY;
        int count = 0;
        while (pit.hasNext()) {
            Point2D pt = (Point2D)pit.next();
            double dist = point.distance(pt);
            sum += dist;
            if (dist > max) {
                max = dist;
            }
            ++count;
        }
        return mode == 1 ? sum / (double)count : max;
    }

    private static Map createIndexMap(List points) {
        HashMap<Point2D, ArrayList<Integer>> retval = new HashMap<Point2D, ArrayList<Integer>>();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            Point2D point = (Point2D)points.get(i);
            ArrayList<Integer> indices = (ArrayList<Integer>)retval.get(point);
            if (indices == null) {
                indices = new ArrayList<Integer>();
                retval.put(point, indices);
            }
            indices.add(new Integer(i));
        }
        return retval;
    }

    private static List distributeWeights(Map indexMap, List ordered, ArrayList[] weights, double sum, int origSize) {
        double[] preRetval = new double[origSize];
        int size = ordered.size();
        for (int i = 0; i < size; ++i) {
            Point2D point = (Point2D)ordered.get(i);
            ArrayList weightList = weights[i];
            int numWeights = weightList.size();
            double wSum = 0.0;
            for (int j = 0; j < numWeights; ++j) {
                Double weight = (Double)weightList.get(j);
                wSum += weight.doubleValue();
            }
            double fullWeight = wSum / sum;
            List indices = (List)indexMap.get(point);
            int shareSize = indices.size();
            double finalWeight = fullWeight / (double)shareSize;
            for (int j = 0; j < shareSize; ++j) {
                Integer index = (Integer)indices.get(j);
                preRetval[index.intValue()] = finalWeight;
            }
        }
        ArrayList<Double> retval = new ArrayList<Double>();
        for (int i = 0; i < origSize; ++i) {
            retval.add(new Double(preRetval[i]));
        }
        return retval;
    }

    private static List orderPoints(List points, Point2D ref) {
        ArrayList<OrderedPoint> working = new ArrayList<OrderedPoint>();
        int size = points.size();
        double maxDist = Double.NEGATIVE_INFINITY;
        Point2D maxPoint = null;
        for (int i = 0; i < size; ++i) {
            Point2D point = (Point2D)points.get(i);
            double dist = point.distance(ref);
            working.add(new OrderedPoint(point, dist, 0.0));
            if (!(dist > maxDist)) continue;
            maxPoint = point;
            maxDist = dist;
        }
        if (maxPoint == null || maxDist == 0.0) {
            return null;
        }
        Frame angleFrame = AffineCombination.buildAFrame(ref, maxPoint);
        if (angleFrame == null) {
            return null;
        }
        TreeSet<OrderedPoint> sorted = new TreeSet<OrderedPoint>();
        for (int i = 0; i < size; ++i) {
            OrderedPoint oPoint = (OrderedPoint)working.get(i);
            oPoint.angle = angleFrame.getAngle(oPoint.point);
            sorted.add(oPoint);
        }
        ArrayList<Point2D> retval = new ArrayList<Point2D>();
        Iterator sit = sorted.iterator();
        while (sit.hasNext()) {
            OrderedPoint oPoint = (OrderedPoint)sit.next();
            retval.add(oPoint.point);
        }
        return retval;
    }

    private static void chooseBasisIndices(List points, int startIndex, int[] indices) {
        int size = points.size();
        if (size < 3) {
            throw new IllegalArgumentException();
        }
        double oneThird = (double)size / 3.0;
        int oneThirdDelta = (int)Math.round(oneThird);
        int twoThirdDelta = (int)Math.round(2.0 * oneThird);
        indices[0] = startIndex;
        indices[1] = (startIndex + oneThirdDelta) % size;
        indices[2] = (startIndex + twoThirdDelta) % size;
    }

    public static void main(String[] argv) {
        double[] weights = new double[3];
        Point2D[] pointSet = new Point2D[3];
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        pointSet[0] = new Point2D.Double(10.0, 40.0);
        points.add(pointSet[0]);
        pointSet[1] = new Point2D.Double(80.0, 50.0);
        points.add(pointSet[1]);
        pointSet[2] = new Point2D.Double(60.0, 90.0);
        points.add(pointSet[2]);
        Point2D.Double testPt = new Point2D.Double(100.0, 120.0);
        System.out.println("Original Point = " + testPt);
        AffineCombination.getWeights(testPt, pointSet, weights);
        System.out.println("Weights = ");
        for (int i = 0; i < 3; ++i) {
            System.out.println(weights[i]);
        }
        Point2D newPoint = AffineCombination.combination(points, weights, 0.0);
        System.out.println("Derived point = " + newPoint);
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        pointList.add(new Point2D.Double(10.0, 40.0));
        pointList.add(new Point2D.Double(80.0, 50.0));
        pointList.add(new Point2D.Double(60.0, 90.0));
        pointList.add(new Point2D.Double(40.0, 200.0));
        pointList.add(new Point2D.Double(70.0, 150.0));
        pointList.add(new Point2D.Double(60.0, 90.0));
        Point2D.Double origPoint = new Point2D.Double(100.0, 120.0);
        List weightList = AffineCombination.getWeights(pointList, origPoint);
        int numWeights = weightList.size();
        double[] weightArray = new double[numWeights];
        for (int i = 0; i < numWeights; ++i) {
            weightArray[i] = (Double)weightList.get(i);
            System.out.println("wei" + weightArray[i]);
        }
        Point2D newPoint2 = AffineCombination.combination(pointList, weightArray, 0.0);
        System.out.println("Derived point = " + newPoint2);
    }

    private static class OrderedPoint
    implements Comparable {
        Point2D point;
        double distance;
        double angle;

        public OrderedPoint(Point2D point, double distance, double angle) {
            this.point = point;
            this.distance = distance;
            this.angle = angle;
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public String toString() {
            return "OrderedPoint: " + this.point + " distance = " + this.distance + " angle = " + this.angle;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof OrderedPoint)) {
                return false;
            }
            return this.compareTo(other) == 0;
        }

        public int compareTo(Object o) {
            OrderedPoint other = (OrderedPoint)o;
            if (this.distance != other.distance) {
                return this.distance < other.distance ? -1 : 1;
            }
            if (this.angle != other.angle) {
                return this.angle < other.angle ? -1 : 1;
            }
            return 0;
        }
    }

    public static class Frame {
        private AffineTransform toStd_;
        private AffineTransform fromStd_;
        private Point2D origin_;
        private Vector2D xAxis_;
        private Vector2D yAxis_;
        private static Frame stdFrame_;

        public Frame() {
            this.toStd_ = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            try {
                this.fromStd_ = this.toStd_.createInverse();
            }
            catch (NoninvertibleTransformException ntex) {
                throw new IllegalStateException();
            }
            this.origin_ = new Point2D.Double(0.0, 0.0);
            this.xAxis_ = new Vector2D(1.0, 0.0);
            this.yAxis_ = new Vector2D(0.0, 1.0);
        }

        public Frame(Point2D point, Vector2D vec1, Vector2D vec2) throws NoninvertibleTransformException {
            this.toStd_ = new AffineTransform(vec1.getX(), vec1.getY(), vec2.getX(), vec2.getY(), point.getX(), point.getY());
            this.fromStd_ = this.toStd_.createInverse();
            this.origin_ = (Point2D)point.clone();
            this.xAxis_ = new Vector2D(vec1);
            this.yAxis_ = new Vector2D(vec2);
        }

        public Frame(Point2D origin, Point2D ptX, Point2D ptY) throws NoninvertibleTransformException {
            this.toStd_ = new AffineTransform(ptX.getX() - origin.getX(), ptX.getY() - origin.getY(), ptY.getX() - origin.getX(), ptY.getY() - origin.getY(), origin.getX(), origin.getY());
            this.fromStd_ = this.toStd_.createInverse();
            this.origin_ = (Point2D)origin.clone();
            this.xAxis_ = new Vector2D(origin, ptX).normalized();
            this.yAxis_ = new Vector2D(origin, ptY).normalized();
        }

        public static Frame getStdFrame() {
            if (stdFrame_ == null) {
                stdFrame_ = new Frame();
            }
            return stdFrame_;
        }

        private double[] coords(Point2D point, double[] toFill) {
            toFill[0] = point.getX();
            toFill[1] = point.getY();
            this.fromStd_.transform(toFill, 0, toFill, 0, 1);
            return toFill;
        }

        public double getAngle(Point2D point) {
            Vector2D toPoint = new Vector2D(this.origin_, point).normalized();
            double dotX = toPoint.dot(this.xAxis_);
            double dotY = toPoint.dot(this.yAxis_);
            double retval = Math.acos(dotX);
            return dotY >= 0.0 ? retval : Math.PI * 2 - retval;
        }
    }
}

