/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.util.AnimatedSplitPaneLayoutManager;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class AnimatedSplitPane
extends JPanel
implements ActionListener {
    private static final double USE_INC_ = 0.075;
    private double currSplit_;
    private double inc_;
    private boolean doFollowOn_;
    private Timer zoomTimer_;
    private AnimatedSplitListener asl_;
    private AnimatedSplitPaneLayoutManager.PanelForSplit myTop_;
    private AnimatedSplitPaneLayoutManager.PanelForSplit myBottom_;
    private JPanel barPanel_;
    private JPanel emptyPanel_;
    private double midFrac_;
    private AnimatedSplitPaneLayoutManager asplLM_ = new AnimatedSplitPaneLayoutManager();

    public AnimatedSplitPane(AnimatedSplitPaneLayoutManager.PanelForSplit newTopComponent, AnimatedSplitPaneLayoutManager.PanelForSplit newBottomComponent, AnimatedSplitListener asl) {
        this.setLayout(this.asplLM_);
        this.myTop_ = newTopComponent;
        this.myBottom_ = newBottomComponent;
        this.myBottom_.setToHide(true);
        this.barPanel_ = new JPanel();
        this.barPanel_.setBackground(Color.LIGHT_GRAY.darker());
        this.emptyPanel_ = new JPanel();
        ResourceManager rMan = ResourceManager.getManager();
        this.emptyPanel_.setLayout(new GridLayout(1, 1));
        JLabel warning = new JLabel(rMan.getString("asp.tooSmallToDisplay"), 0);
        warning.setFont(FontManager.getMgr().getFixedFont(3));
        this.emptyPanel_.add(warning);
        this.add((Component)this.myTop_, new AnimatedSplitPaneLayoutManager.ASPRole(0));
        this.add((Component)this.barPanel_, new AnimatedSplitPaneLayoutManager.ASPRole(1));
        this.add((Component)this.myBottom_, new AnimatedSplitPaneLayoutManager.ASPRole(2));
        this.add((Component)this.emptyPanel_, new AnimatedSplitPaneLayoutManager.ASPRole(3));
        this.midFrac_ = 0.5;
        this.asplLM_.setState(new AnimatedSplitPaneLayoutManager.ASPState(false, 1.0));
        this.currSplit_ = 1.0;
        this.inc_ = 0.075;
        this.doFollowOn_ = false;
        this.zoomTimer_ = new Timer(42, this);
        this.asl_ = asl;
        this.setEnabled(false);
    }

    public void expand() {
        this.currSplit_ = 1.0;
        this.inc_ = -0.075;
        this.doFollowOn_ = false;
        this.zoomTimer_.start();
    }

    public void collapse() {
        this.currSplit_ = this.midFrac_;
        this.inc_ = 0.075;
        this.doFollowOn_ = false;
        this.zoomTimer_.start();
    }

    public void collapseThenExpand() {
        this.currSplit_ = this.midFrac_;
        this.inc_ = 0.075;
        this.doFollowOn_ = true;
        this.zoomTimer_.start();
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            if (this.currSplit_ > 1.0) {
                this.currSplit_ = 1.0;
            }
            if (this.currSplit_ < this.midFrac_) {
                this.currSplit_ = this.midFrac_;
            }
            this.asplLM_.setState(new AnimatedSplitPaneLayoutManager.ASPState(true, this.currSplit_));
            if (this.inc_ > 0.0) {
                if (this.currSplit_ == 1.0) {
                    if (this.doFollowOn_) {
                        if (this.asl_ != null) {
                            this.asl_.midBounce();
                        }
                        this.inc_ = -0.075;
                        this.doFollowOn_ = false;
                    } else {
                        this.zoomTimer_.stop();
                        if (this.asl_ != null) {
                            this.asl_.finished();
                        }
                        this.asplLM_.setState(new AnimatedSplitPaneLayoutManager.ASPState(false, this.currSplit_));
                        this.myBottom_.setToHide(true);
                    }
                }
            } else if (this.inc_ < 0.0 && this.currSplit_ == this.midFrac_) {
                this.zoomTimer_.stop();
                if (this.asl_ != null) {
                    this.asl_.finished();
                }
                this.asplLM_.setState(new AnimatedSplitPaneLayoutManager.ASPState(false, this.currSplit_));
                this.myBottom_.setToHide(false);
            }
            this.currSplit_ += this.inc_;
            this.revalidate();
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void doFixie() {
        Dimension size = this.getSize();
        Dimension rmin = this.myBottom_.getTrueMinimumSize();
        double useHeight = (double)rmin.height * 1.2;
        this.midFrac_ = 1.0 - useHeight / (double)size.height;
        if (this.midFrac_ < 0.33) {
            this.midFrac_ = 0.33;
        }
        this.asplLM_.setState(new AnimatedSplitPaneLayoutManager.ASPState(false, 1.0));
    }

    public static interface AnimatedSplitListener {
        public void midBounce();

        public void finished();
    }
}

