/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JPanel;

public class AnimatedSplitPaneLayoutManager
implements LayoutManager2 {
    public static final int IS_TOP = 0;
    public static final int IS_BAR = 1;
    public static final int IS_BOTTOM = 2;
    public static final int IS_CARD = 3;
    private static final int BAR_HEIGHT_ = 5;
    private int height_ = 0;
    private int minHeight_ = 0;
    private int minWidth_ = 0;
    private boolean haveCalc_ = false;
    private ASPState currState_;
    private Component[] comps_ = new Component[4];

    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    public void addLayoutComponent(Component comp, Object constraint) {
        if (!(constraint instanceof ASPRole)) {
            throw new IllegalArgumentException();
        }
        this.haveCalc_ = false;
        this.comps_[((ASPRole)constraint).role] = comp;
    }

    public void removeLayoutComponent(Component comp) {
        throw new UnsupportedOperationException();
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.sizeCalcs(parent);
        Dimension dim = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        dim.width = this.minWidth_ + insets.left + insets.right;
        dim.height = this.height_ + insets.top + insets.bottom;
        return dim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.sizeCalcs(parent);
        Dimension dim = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        dim.width = this.minWidth_ + insets.left + insets.right;
        dim.height = this.minHeight_ + insets.top + insets.bottom;
        return dim;
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void setState(ASPState asps) {
        this.currState_ = asps;
        this.haveCalc_ = false;
    }

    public void layoutContainer(Container parent) {
        int div;
        int bottomMin;
        int sum;
        Insets insets = parent.getInsets();
        Dimension pDim = parent.getSize();
        int useWidth = pDim.width - (insets.left + insets.right);
        int useHeight = pDim.height - (insets.top + insets.bottom);
        this.sizeCalcs(parent);
        int topMin = this.comps_[0].getMinimumSize().height + 22;
        boolean needFull = ((PanelForSplit)this.comps_[2]).isHiding();
        if (needFull) {
            topMin = ((PanelForSplit)this.comps_[0]).getFullMinimumSize().height + 22;
        }
        if ((sum = topMin + (bottomMin = this.comps_[2].getMinimumSize().height) + 5) > useHeight) {
            this.comps_[0].setVisible(false);
            this.comps_[1].setVisible(false);
            this.comps_[2].setVisible(false);
            this.comps_[3].setVisible(true);
            this.comps_[3].setBounds(insets.left, insets.top, useWidth, useHeight);
            this.haveCalc_ = false;
            return;
        }
        this.comps_[0].setVisible(true);
        this.comps_[1].setVisible(true);
        this.comps_[2].setVisible(this.currState_.frac != 1.0);
        this.comps_[3].setVisible(false);
        if (this.currState_.frac == 1.0) {
            div = useHeight - 5;
        } else if (this.currState_.isAnimating) {
            div = (int)((double)useHeight * this.currState_.frac);
        } else {
            div = (int)((double)useHeight * this.currState_.frac);
            if (topMin > div) {
                div = topMin;
            } else if (bottomMin > useHeight - div - 5) {
                div = useHeight - 5 - bottomMin;
            }
        }
        this.comps_[0].setBounds(insets.left, insets.top, useWidth, div);
        this.comps_[1].setBounds(insets.left, div, useWidth, 5);
        if (this.currState_.frac != 1.0) {
            this.comps_[2].setBounds(insets.left, div + 5, useWidth, useHeight - div - 5);
        }
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container parent) {
        this.haveCalc_ = false;
    }

    private void sizeCalcs(Container parent) {
        if (this.haveCalc_) {
            return;
        }
        this.height_ = 0;
        this.minWidth_ = 0;
        this.minHeight_ = 0;
        Dimension d = this.comps_[0].getPreferredSize();
        Dimension dMin = this.comps_[0].getMinimumSize();
        boolean needFull = ((PanelForSplit)this.comps_[2]).isHiding();
        if (needFull) {
            dMin = ((PanelForSplit)this.comps_[0]).getFullMinimumSize();
        }
        this.height_ += d.height;
        if (dMin.width > this.minWidth_) {
            this.minWidth_ = dMin.width;
        }
        this.minHeight_ += dMin.height + 22;
        this.height_ += 5;
        this.minHeight_ += 5;
        if (this.currState_.frac != 1.0) {
            d = this.comps_[2].getPreferredSize();
            dMin = this.comps_[2].getMinimumSize();
            this.height_ += d.height;
            if (dMin.width > this.minWidth_) {
                this.minWidth_ = dMin.width;
            }
            this.minHeight_ += dMin.height + 22;
        }
        this.haveCalc_ = true;
    }

    public static class PanelForSplit
    extends JPanel {
        private JPanel useMe_;
        private boolean hideIt_ = false;
        private Dimension hideDim_ = new Dimension(0, 0);

        public void countOnlyMe(JPanel useMe) {
            this.useMe_ = useMe;
        }

        public void setToHide(boolean setToHide) {
            this.hideIt_ = setToHide;
        }

        public boolean isHiding() {
            return this.hideIt_;
        }

        public Dimension getFullMinimumSize() {
            return super.getMinimumSize();
        }

        public Dimension getTrueMinimumSize() {
            if (this.useMe_ == null) {
                return super.getMinimumSize();
            }
            return this.useMe_.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            if (this.hideIt_) {
                return this.hideDim_;
            }
            if (this.useMe_ == null) {
                return super.getMinimumSize();
            }
            return this.useMe_.getMinimumSize();
        }

        public Dimension getPreferredSize() {
            if (this.hideIt_) {
                return this.hideDim_;
            }
            return super.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            if (this.hideIt_) {
                return this.hideDim_;
            }
            return super.getMaximumSize();
        }
    }

    public static class ASPState {
        public boolean isAnimating;
        public double frac;

        public ASPState(boolean isAnimating, double frac) {
            this.isAnimating = isAnimating;
            this.frac = frac;
        }
    }

    public static class ASPRole {
        public static final int IS_TOP = 0;
        public static final int IS_BAR = 1;
        public static final int IS_BOTTOM = 2;
        public static final int IS_CARD = 3;
        public int role;

        public ASPRole(int role) {
            this.role = role;
        }
    }
}

