/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.BackgroundWorkerClient;

public abstract class BackgroundWorker
implements Runnable,
BTProgressMonitor {
    protected Object myResult_;
    protected Object earlyResult_;
    protected Exception caughtException_;
    protected OutOfMemoryError memError_;
    protected int total_;
    protected int done_;
    protected boolean cancelRequested_;
    protected BackgroundWorkerClient client_;
    protected Timer checkCancelTimer_;
    protected boolean isForeground_;

    public BackgroundWorker(Object earlyResult) {
        this(earlyResult, false);
    }

    public BackgroundWorker(Object earlyResult, boolean isForeground) {
        this.earlyResult_ = earlyResult;
        this.myResult_ = earlyResult;
        this.caughtException_ = null;
        this.memError_ = null;
        this.cancelRequested_ = false;
        this.isForeground_ = isForeground;
    }

    public void setClient(BackgroundWorkerClient client) {
        this.client_ = client;
    }

    public void run() {
        if (this.isForeground_) {
            this.runForeground();
        } else {
            this.runBackground();
        }
    }

    public void runBackground() {
        try {
            try {
                int delay = 1000;
                this.checkCancelTimer_ = new Timer(delay, new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        BackgroundWorker.this.cancelRequested_ = !BackgroundWorker.this.client_.keepGoing();
                    }
                });
                this.checkCancelTimer_.start();
                this.myResult_ = this.runCore();
                this.checkCancelTimer_.stop();
            }
            catch (AsynchExitRequestException ex) {
                this.checkCancelTimer_.stop();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BackgroundWorker.this.client_.workCancelled();
                    }
                });
                return;
            }
            if (this.caughtException_ == null) {
                this.updateProgress(this.total_);
                this.postRunCore();
            } else {
                this.myResult_ = this.earlyResult_;
            }
        }
        catch (Exception ex) {
            this.checkCancelTimer_.stop();
            this.caughtException_ = ex;
        }
        catch (OutOfMemoryError oom) {
            this.checkCancelTimer_.stop();
            this.memError_ = oom;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BackgroundWorker.this.client_.finishedWork(BackgroundWorker.this.myResult_, BackgroundWorker.this.caughtException_, BackgroundWorker.this.memError_);
            }
        });
    }

    public void runForeground() {
        try {
            try {
                this.myResult_ = this.runCore();
            }
            catch (AsynchExitRequestException ex) {
                throw new IllegalStateException();
            }
            if (this.caughtException_ == null) {
                this.postRunCore();
            } else {
                this.myResult_ = this.earlyResult_;
            }
        }
        catch (Exception ex) {
            this.caughtException_ = ex;
        }
        catch (OutOfMemoryError oom) {
            this.memError_ = oom;
        }
        this.client_.finishedWork(this.myResult_, this.caughtException_, this.memError_);
    }

    public abstract Object runCore() throws AsynchExitRequestException;

    public abstract Object postRunCore();

    protected void stashException(Exception ex) {
        this.caughtException_ = ex;
    }

    public void setTotal(int total) {
        this.total_ = total;
    }

    public int getTotal() {
        return this.total_;
    }

    public int getProgress() {
        return this.done_;
    }

    public boolean keepGoing() {
        return !this.cancelRequested_;
    }

    public boolean updateRankings(SortedMap rankings) {
        RankProgresso prog = new RankProgresso(rankings);
        SwingUtilities.invokeLater(prog);
        return !this.cancelRequested_;
    }

    public boolean updateProgress(int done) {
        this.done_ = done;
        int percent = (int)((double)done / (double)this.total_ * 100.0);
        Progresso prog = new Progresso(percent);
        SwingUtilities.invokeLater(prog);
        return !this.cancelRequested_;
    }

    private class RankProgresso
    implements Runnable {
        TreeMap ranks_;

        RankProgresso(SortedMap ranks) {
            this.ranks_ = new TreeMap(ranks);
        }

        public void run() {
            BackgroundWorker.this.cancelRequested_ = !BackgroundWorker.this.client_.updateRankings(this.ranks_);
        }
    }

    private class Progresso
    implements Runnable {
        int percent_;

        Progresso(int percent) {
            this.percent_ = percent;
        }

        public void run() {
            BackgroundWorker.this.cancelRequested_ = !BackgroundWorker.this.client_.updateProgress(this.percent_);
        }
    }
}

