/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.HashMap;
import java.util.Set;

public class Base64Util {
    private static char[] encodeChars_ = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static HashMap decodeMap_ = new HashMap();

    public String encode(byte[] input) {
        StringBuffer retval = new StringBuffer();
        int diffCount = input.length % 3;
        String padString = "";
        if (diffCount != 0) {
            StringBuffer padBuffer = new StringBuffer();
            int padCount = 3 - diffCount;
            byte[] paddedInput = new byte[input.length + padCount];
            System.arraycopy(input, 0, paddedInput, 0, input.length);
            for (int i = 0; i < padCount; ++i) {
                paddedInput[input.length + i] = 0;
                padBuffer.append('=');
            }
            input = paddedInput;
            padString = padBuffer.toString();
        }
        int paddedLength = input.length;
        for (int i = 0; i < paddedLength; i += 3) {
            if (i > 0 && i / 3 * 4 % 76 == 0) {
                retval.append('\n');
            }
            int val1 = input[i] & 0xFF;
            int val2 = input[i + 1] & 0xFF;
            int val3 = input[i + 2] & 0xFF;
            int tfbit = (val1 << 16) + (val2 << 8) + val3;
            int sixbit0 = tfbit >> 18 & 0x3F;
            int sixbit1 = tfbit >> 12 & 0x3F;
            int sixbit2 = tfbit >> 6 & 0x3F;
            int sixbit3 = tfbit & 0x3F;
            retval.append(encodeChars_[sixbit0]);
            retval.append(encodeChars_[sixbit1]);
            retval.append(encodeChars_[sixbit2]);
            retval.append(encodeChars_[sixbit3]);
        }
        int retSize = retval.length();
        retval.delete(retSize - padString.length(), retSize);
        retval.append(padString);
        return retval.toString();
    }

    public byte[] decode(String input) {
        int padCount;
        if (input == null || input.equals("")) {
            return new byte[0];
        }
        int inlen = input.length();
        int n = padCount = input.charAt(inlen - 1) == '=' ? 1 : 0;
        if (padCount == 1 && input.charAt(inlen - 2) == '=') {
            padCount = 2;
        }
        MutChar checkChar = new MutChar();
        Set goodChars = decodeMap_.keySet();
        StringBuffer workbuf = new StringBuffer();
        int lastGood = inlen - padCount;
        for (int i = 0; i < lastGood; ++i) {
            char val = input.charAt(i);
            if (!goodChars.contains(checkChar.setVal(val))) continue;
            workbuf.append(val);
        }
        if (padCount > 0) {
            workbuf.append(padCount == 1 ? "A" : "AA");
        }
        int paddedLength = workbuf.length();
        int targLen = paddedLength / 4 * 3 - padCount;
        byte[] target = new byte[targLen];
        int targIndex = 0;
        for (int i = 0; i < paddedLength; i += 4) {
            int val0 = (Integer)decodeMap_.get(checkChar.setVal(workbuf.charAt(i)));
            int val1 = (Integer)decodeMap_.get(checkChar.setVal(workbuf.charAt(i + 1)));
            int val2 = (Integer)decodeMap_.get(checkChar.setVal(workbuf.charAt(i + 2)));
            int val3 = (Integer)decodeMap_.get(checkChar.setVal(workbuf.charAt(i + 3)));
            int tfbit = (val0 << 18) + (val1 << 12) + (val2 << 6) + val3;
            target[targIndex++] = (byte)(tfbit >>> 16 & 0xFF);
            if (targIndex < targLen) {
                target[targIndex++] = (byte)(tfbit >>> 8 & 0xFF);
            }
            if (targIndex >= targLen) continue;
            target[targIndex++] = (byte)(tfbit & 0xFF);
        }
        return target;
    }

    public static void main(String[] argv) {
        try {
            Base64Util.simpleTest();
        }
        catch (Exception ex) {
            System.out.println("Exception " + ex.getMessage());
        }
    }

    public static void simpleTest() {
        Base64Util bu = new Base64Util();
        String test = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        try {
            String encoded = bu.encode(test.getBytes("US-ASCII"));
            System.out.print(encoded);
            System.out.println();
            byte[] decoded = bu.decode(encoded);
            for (int i = 0; i < decoded.length; ++i) {
                System.out.print((char)decoded[i]);
            }
            System.out.println();
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }

    static {
        for (int i = 0; i < 64; ++i) {
            char keyVal = encodeChars_[i];
            MutChar key = new MutChar(keyVal);
            decodeMap_.put(key, new Integer(i));
        }
    }

    private static class MutChar {
        private char val_;

        MutChar() {
            this.val_ = '\u0000';
        }

        MutChar(char val) {
            this.val_ = val;
        }

        MutChar setVal(char val) {
            this.val_ = val;
            return this;
        }

        char getVal() {
            return this.val_;
        }

        public int hashCode() {
            return this.val_;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof MutChar)) {
                return false;
            }
            MutChar otherMS = (MutChar)other;
            return this.val_ == otherMS.val_;
        }
    }
}

