/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

public class BoundedDoubMinMax
implements Cloneable {
    public double min;
    public boolean includeMin;
    public double max;
    public boolean includeMax;

    public BoundedDoubMinMax() {
        this(0.0);
    }

    public BoundedDoubMinMax(double val) {
        this(val, val);
    }

    public BoundedDoubMinMax(double min, double max) {
        this(min, max, true, true);
    }

    public BoundedDoubMinMax(double min, double max, boolean includeMin, boolean includeMax) {
        this.min = min;
        this.max = max;
        this.includeMin = includeMin;
        this.includeMax = includeMax;
    }

    public BoundedDoubMinMax(BoundedDoubMinMax other) {
        this.min = other.min;
        this.max = other.max;
        this.includeMin = other.includeMin;
        this.includeMax = other.includeMax;
    }

    public boolean contained(double val) {
        boolean gtMin;
        boolean bl = this.includeMin ? val >= this.min : (gtMin = val > this.min);
        boolean ltMax = this.includeMax ? val <= this.max : val < this.max;
        return gtMin && ltMax;
    }

    public Object clone() {
        try {
            BoundedDoubMinMax newVal = (BoundedDoubMinMax)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        return (int)Math.round(this.min + this.max) + (this.includeMin ? 0 : 1) + (this.includeMax ? 0 : 1);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof BoundedDoubMinMax)) {
            return false;
        }
        BoundedDoubMinMax otherMM = (BoundedDoubMinMax)other;
        return this.min == otherMM.min && this.max == otherMM.max && this.includeMin == otherMM.includeMin && this.includeMax == otherMM.includeMax;
    }

    public String toString() {
        String open = this.includeMin ? "[" : "(";
        String close = this.includeMax ? "]" : ")";
        return open + this.min + ", " + this.max + close;
    }
}

