/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Bounds {
    public static Rectangle2D initBoundsWithPoint(Point2D point) {
        Rectangle2D.Double retval = new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0);
        return retval;
    }

    public static void tweakBoundsWithPoint(Rectangle2D currBounds, Point2D point) {
        currBounds.add(point);
    }

    public static void tweakBounds(Rectangle currBounds, Rectangle newBounds) {
        if (currBounds.width == 0 && currBounds.height == 0) {
            currBounds.x = newBounds.x;
            currBounds.y = newBounds.y;
            currBounds.width = newBounds.width;
            currBounds.height = newBounds.height;
            return;
        }
        Bounds.tweakBoundsCore(currBounds, newBounds);
    }

    private static void tweakBoundsCore(Rectangle currBounds, Rectangle newBounds) {
        int currMaxX = currBounds.width + currBounds.x;
        int currMaxY = currBounds.height + currBounds.y;
        int newMaxX = newBounds.width + newBounds.x;
        int newMaxY = newBounds.height + newBounds.y;
        if (newBounds.x < currBounds.x) {
            currBounds.x = newBounds.x;
        }
        if (newBounds.y < currBounds.y) {
            currBounds.y = newBounds.y;
        }
        currBounds.width = newMaxX > currMaxX ? newMaxX - currBounds.x : currMaxX - currBounds.x;
        currBounds.height = newMaxY > currMaxY ? newMaxY - currBounds.y : currMaxY - currBounds.y;
    }

    public static void padBounds(Rectangle currBounds, int xPad, int yPad) {
        currBounds.x -= xPad;
        currBounds.y -= yPad;
        currBounds.width += 2 * xPad;
        currBounds.height += 2 * yPad;
    }

    public static void padBounds(Rectangle currBounds, int tPad, int bPad, int lPad, int rPad) {
        currBounds.x -= lPad;
        currBounds.y -= tPad;
        currBounds.width += lPad + rPad;
        currBounds.height += tPad + bPad;
    }

    public static boolean intersects(Rectangle bounds, int x, int y) {
        int maxX = bounds.width + bounds.x;
        int maxY = bounds.height + bounds.y;
        return x >= bounds.x && y >= bounds.y && x <= maxX && y <= maxY;
    }

    public static boolean intersects(Rectangle2D bounds, double x, double y) {
        return bounds.outcode(x, y) == 0;
    }

    public static boolean intersects(double minX, double minY, double maxX, double maxY, double x, double y) {
        return x >= minX && y >= minY && x <= maxX && y <= maxY;
    }
}

