/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVParser {
    private Pattern pat_ = Pattern.compile("\\G(?:^|,) (?: \" ( (?> [^\"]*+ ) (?> \"\" [^\"]*+ )*+ ) \" | ( [^\",]*+ ) )", 4);
    private Pattern doubq_ = Pattern.compile("\"\"");
    private Matcher mainMatch_ = this.pat_.matcher("");
    private Matcher doubMatch_ = this.doubq_.matcher("");
    private boolean dropTrailing_;

    public CSVParser(boolean dropTrailing) {
        this.dropTrailing_ = dropTrailing;
    }

    public List processCSVLine(String line) {
        ArrayList<String> argList = new ArrayList<String>();
        this.mainMatch_.reset(line);
        while (this.mainMatch_.find()) {
            String group = this.mainMatch_.group(2);
            if (group != null) {
                argList.add(group.trim());
                continue;
            }
            this.doubMatch_.reset(this.mainMatch_.group(1));
            argList.add(this.doubMatch_.replaceAll("\"").trim());
        }
        if (this.dropTrailing_) {
            ArrayList<String> retval = new ArrayList<String>();
            int alnum = argList.size();
            boolean chopping = true;
            for (int i = alnum - 1; i >= 0; --i) {
                String tok = (String)argList.get(i);
                if (chopping) {
                    if (tok.trim().equals("")) continue;
                    chopping = false;
                }
                if (chopping) continue;
                retval.add(0, tok);
            }
            return retval;
        }
        return argList;
    }
}

