/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.UiUtil;

public class CheckBoxList
extends JList {
    private static final int BOX_WIDTH_ = 10;
    private static final int BOX_MARGIN_ = 5;
    private static final int INTER_BOX_MARGIN_ = 3;
    private static final int MAIN_BOX_MAX_ = 15;
    private static final int SUB_BOX_MIN_ = 17;
    private static final int SUB_BOX_MAX_ = 29;
    private boolean myEnabled_;
    private boolean showSubChecks_;
    private boolean enableSubChecks_;
    private CheckBoxListListener listen_;
    private CheckBoxCellRenderer renderer_;
    private MouseHandler mHandler_;
    private boolean doTips_;
    private String mainTip_;
    private String subTip_;

    public CheckBoxList(CheckBoxListListener listen, boolean doSubSelection, boolean doTips) {
        this.listen_ = listen;
        this.myEnabled_ = true;
        this.getSelectionModel().setSelectionMode(0);
        this.mHandler_ = new MouseHandler(doSubSelection, doSubSelection);
        this.addMouseListener(this.mHandler_);
        this.showSubChecks_ = doSubSelection;
        this.enableSubChecks_ = doSubSelection;
        this.renderer_ = new CheckBoxCellRenderer(doSubSelection, doSubSelection);
        this.setCellRenderer(this.renderer_);
        this.doTips_ = doTips;
        if (this.doTips_) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    public CheckBoxList(CheckBoxListListener listen, boolean doSubSelection) {
        this.listen_ = listen;
        this.myEnabled_ = true;
        this.getSelectionModel().setSelectionMode(0);
        this.mHandler_ = new MouseHandler(doSubSelection, doSubSelection);
        this.addMouseListener(this.mHandler_);
        this.showSubChecks_ = doSubSelection;
        this.enableSubChecks_ = doSubSelection;
        this.renderer_ = new CheckBoxCellRenderer(doSubSelection, doSubSelection);
        this.setCellRenderer(this.renderer_);
        this.doTips_ = false;
    }

    public CheckBoxList(Vector items) {
        super(items);
        this.myEnabled_ = true;
        this.showSubChecks_ = false;
        this.enableSubChecks_ = false;
        this.getSelectionModel().setSelectionMode(0);
        this.mHandler_ = new MouseHandler(false, false);
        this.addMouseListener(this.mHandler_);
        this.renderer_ = new CheckBoxCellRenderer(false, false);
        this.setCellRenderer(this.renderer_);
        this.doTips_ = false;
    }

    public void setToolTipText(String mainTip, String subTip) {
        this.mainTip_ = mainTip;
        this.subTip_ = subTip;
    }

    public void unregister() {
        if (this.doTips_) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent event) {
        try {
            if (!this.doTips_) {
                return null;
            }
            Point pt = event.getPoint();
            int clickIndex = this.locationToIndex(pt);
            if (clickIndex < 0) {
                return null;
            }
            Rectangle rect = this.getCellBounds(clickIndex, clickIndex);
            if (rect == null || rect.getMaxY() < pt.getY()) {
                return null;
            }
            int x = (int)pt.getX();
            if (this.showSubChecks_) {
                if (x <= 15 || x > 29) {
                    return this.mainTip_;
                }
                if (x >= 17 && x <= 29) {
                    return this.subTip_;
                }
                return this.mainTip_;
            }
            return this.mainTip_;
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
            return null;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myEnabled_ = enabled;
    }

    public void showAndEnableSubSelection(boolean show, boolean enable) {
        this.renderer_.allowSubChecks(show, enable);
        this.mHandler_.allowSubChecks(enable, show);
        this.showSubChecks_ = show;
        this.enableSubChecks_ = enable;
    }

    public static void main(String[] argv) {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            JFrame testWindow = new JFrame();
            testWindow.setSize(640, 480);
            Dimension frameSize = testWindow.getSize();
            int x = (screenSize.width - frameSize.width) / 2;
            int y = (screenSize.height - frameSize.height) / 2;
            testWindow.setLocation(x, y);
            JPanel cp = (JPanel)testWindow.getContentPane();
            cp.setBorder(new EmptyBorder(20, 20, 20, 20));
            cp.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            Vector<ListChoice> vec = new Vector<ListChoice>();
            vec.add(new ListChoice("1", "fie", Color.yellow, false));
            vec.add(new ListChoice("2", "fi", Color.orange, false));
            vec.add(new ListChoice("3", "fo", Color.blue, false));
            vec.add(new ListChoice("4", "fum", Color.green, false));
            CheckBoxList cbt = new CheckBoxList(vec);
            UiUtil.gbcSet(gbc, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
            cp.add((Component)cbt, gbc);
            testWindow.setVisible(true);
        }
        catch (Exception ioex) {
            System.err.println(ioex);
        }
    }

    public static interface CheckBoxListListener {
        public void checkIsClicked();
    }

    public static class DotBox
    extends JPanel {
        private boolean isChecked_ = false;
        private Color boxColor_ = Color.black;

        public DotBox() {
            this.setBackground(Color.white);
        }

        public void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                Dimension size = this.getSize();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2.setPaint(this.boxColor_);
                g2.setStroke(new BasicStroke(1.0f, 0, 2));
                Ellipse2D.Double circ = new Ellipse2D.Double(1.0, 1.0, size.getWidth() - 2.0, size.getHeight() - 2.0);
                g2.draw(circ);
                if (this.isChecked_) {
                    Ellipse2D.Double circ2 = new Ellipse2D.Double(3.0, 3.0, 5.0, 5.0);
                    g2.fill(circ2);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayPaintException(ex);
            }
        }

        public void setChecked(boolean isChecked) {
            this.isChecked_ = isChecked;
        }

        public void setBoxColor(Color boxColor) {
            this.boxColor_ = boxColor;
        }
    }

    public static class CheckBox
    extends JPanel {
        private boolean isChecked_ = false;
        private Color boxColor_ = Color.black;
        private boolean isLocked_ = false;

        public CheckBox() {
            this.setBackground(Color.white);
        }

        public void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                Dimension size = this.getSize();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size.getWidth() - 1.0, size.getHeight() - 1.0);
                g2.setPaint(this.isLocked_ ? Color.gray : this.boxColor_);
                g2.draw(rect);
                if (this.isChecked_) {
                    GeneralPath currPath = new GeneralPath();
                    currPath.moveTo(0.0f, 0.0f);
                    currPath.lineTo((float)size.getWidth() - 1.0f, (float)size.getHeight() - 1.0f);
                    currPath.moveTo(0.0f, (float)size.getHeight() - 1.0f);
                    currPath.lineTo((float)size.getWidth() - 1.0f, 0.0f);
                    g2.draw(currPath);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayPaintException(ex);
            }
        }

        public void setChecked(boolean isChecked) {
            this.isChecked_ = isChecked;
        }

        public void setBoxColor(Color boxColor) {
            this.boxColor_ = boxColor;
        }

        public void setLocked(boolean isLocked) {
            this.isLocked_ = isLocked;
        }
    }

    public static class ListChoice {
        public boolean isSelected;
        public boolean isSubSelected;
        public boolean isLocked;
        private Object myObj_;
        public String display;
        public Color myColor;

        public ListChoice(Object obj, String display, Color myColor, boolean isSelected) {
            this(obj, display, myColor, isSelected, false);
        }

        public ListChoice(Object obj, String display, Color myColor, boolean isSelected, boolean isSubSelected) {
            this(obj, display, myColor, isSelected, isSubSelected, false);
        }

        public ListChoice(Object obj, String display, Color myColor, boolean isSelected, boolean isSubSelected, boolean isLocked) {
            this.isSelected = isSelected;
            this.isSubSelected = isSubSelected;
            this.myObj_ = obj;
            this.display = display;
            this.myColor = myColor;
            this.isLocked = isLocked;
        }

        public Object getObject() {
            return this.myObj_;
        }

        public String toString() {
            return this.display;
        }
    }

    public class CheckBoxItem
    extends JPanel {
        private boolean isChecked_ = false;
        private boolean isSubChecked_ = false;
        private boolean isLocked_;
        private Color myColor_ = Color.white;
        private String myName_ = "";
        private JLabel myLabel_;
        private CheckBox myCheckbox_;
        private DotBox mySubCheckbox_;

        public CheckBoxItem(boolean doSubAlso) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.myCheckbox_ = new CheckBox();
            this.myCheckbox_.setPreferredSize(new Dimension(10, 10));
            if (doSubAlso) {
                this.mySubCheckbox_ = new DotBox();
                this.mySubCheckbox_.setPreferredSize(new Dimension(10, 10));
            }
            this.myLabel_ = new JLabel(this.myName_);
            int colNum = 0;
            UiUtil.gbcSet(gbc, colNum++, 0, 1, 1, 0, 0, 0, 0, 5, 0, 0, 10, 0.0, 0.0);
            this.add((Component)this.myCheckbox_, gbc);
            if (doSubAlso) {
                UiUtil.gbcSet(gbc, colNum++, 0, 1, 1, 0, 0, 0, 0, 3, 0, 0, 10, 0.0, 0.0);
                this.add((Component)this.mySubCheckbox_, gbc);
            }
            UiUtil.gbcSet(gbc, colNum, 0, 5, 1, 2, 0, 0, 0, 5, 0, 5, 10, 1.0, 0.0);
            this.add((Component)this.myLabel_, gbc);
            this.setBackground(this.myColor_);
        }

        public void setLeafName(String name) {
            this.myName_ = name;
            this.myLabel_.setText(this.myName_);
        }

        public void setColor(Color color) {
            this.myColor_ = color;
            this.setBackground(this.myColor_);
        }

        public void setTextColor(Color color, Color subColor) {
            this.myLabel_.setForeground(color);
            this.myCheckbox_.setBoxColor(color);
            if (this.mySubCheckbox_ != null) {
                this.mySubCheckbox_.setBoxColor(subColor);
            }
        }

        public void setChecked(boolean isChecked) {
            this.isChecked_ = isChecked;
            this.myCheckbox_.setChecked(isChecked);
        }

        public void setLocked(boolean isLocked) {
            this.isLocked_ = isLocked;
            this.myCheckbox_.setLocked(isLocked);
        }

        public void setSubChecked(boolean isSubChecked) {
            if (this.mySubCheckbox_ == null) {
                throw new IllegalStateException();
            }
            this.isSubChecked_ = isSubChecked;
            this.mySubCheckbox_.setChecked(isSubChecked);
        }
    }

    public class CheckBoxCellRenderer
    extends DefaultListCellRenderer {
        private CheckBoxItem myItem_;
        private boolean showSubChecks_;
        private boolean enableSubChecks_;

        public CheckBoxCellRenderer(boolean showSubChecks, boolean enableSubChecks) {
            this.myItem_ = new CheckBoxItem(showSubChecks);
            this.showSubChecks_ = showSubChecks;
            this.enableSubChecks_ = enableSubChecks;
        }

        public void allowSubChecks(boolean showSubChecks, boolean enableSubChecks) {
            this.myItem_ = new CheckBoxItem(showSubChecks);
            this.showSubChecks_ = showSubChecks;
            this.enableSubChecks_ = enableSubChecks;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            try {
                ListChoice choice = (ListChoice)value;
                this.myItem_.setLeafName(choice.display);
                this.myItem_.setColor(choice.myColor);
                this.myItem_.setChecked(choice.isSelected);
                this.myItem_.setLocked(choice.isLocked);
                Color mainColor = !CheckBoxList.this.myEnabled_ ? Color.lightGray : Color.black;
                Color subColor = null;
                if (this.showSubChecks_) {
                    this.myItem_.setSubChecked(choice.isSubSelected);
                    subColor = this.enableSubChecks_ ? (choice.isSelected ? mainColor : Color.lightGray) : Color.lightGray;
                }
                this.myItem_.setTextColor(mainColor, subColor);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.myItem_;
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private boolean allowSubChecks_;
        private boolean showSubChecks_;

        MouseHandler(boolean allowSubChecks, boolean showSubChecks) {
            this.allowSubChecks_ = allowSubChecks;
            this.showSubChecks_ = showSubChecks;
        }

        public void allowSubChecks(boolean allowSubChecks, boolean showSubChecks) {
            this.allowSubChecks_ = allowSubChecks;
            this.showSubChecks_ = showSubChecks;
        }

        public void mousePressed(MouseEvent me) {
        }

        public void mouseClicked(MouseEvent me) {
        }

        public void mouseReleased(MouseEvent me) {
            this.handleClick(me.getX(), me.getY());
        }

        private void handleClick(int x, int y) {
            try {
                if (!CheckBoxList.this.myEnabled_) {
                    return;
                }
                int clickIndex = CheckBoxList.this.locationToIndex(new Point(x, y));
                if (clickIndex == -1) {
                    return;
                }
                Rectangle rect = CheckBoxList.this.getCellBounds(clickIndex, clickIndex);
                if (rect.getMaxY() < (double)y) {
                    return;
                }
                ListChoice choice = (ListChoice)CheckBoxList.this.getModel().getElementAt(clickIndex);
                if (choice.isLocked) {
                    return;
                }
                if (this.showSubChecks_) {
                    if (x <= 15 || x > 29) {
                        choice.isSelected = !choice.isSelected;
                    } else if (x >= 17 && x <= 29) {
                        if (this.allowSubChecks_ && choice.isSelected) {
                            choice.isSubSelected = !choice.isSubSelected;
                        }
                    } else {
                        choice.isSelected = !choice.isSelected;
                    }
                } else {
                    choice.isSelected = !choice.isSelected;
                }
                CheckBoxList.this.repaint();
                if (CheckBoxList.this.listen_ != null) {
                    CheckBoxList.this.listen_.checkIsClicked();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }
}

