/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.systemsbiology.biotapestry.util.CheckBoxTreeLeaf;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.UiUtil;

public class CheckBoxTree
extends JTree {
    public CheckBoxTree(DefaultTreeModel dtm) {
        super(dtm);
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseHandler());
        this.setCellRenderer(new CheckBoxCellRenderer());
    }

    public static void main(String[] argv) {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            JFrame testWindow = new JFrame();
            testWindow.setSize(640, 480);
            Dimension frameSize = testWindow.getSize();
            int x = (screenSize.width - frameSize.width) / 2;
            int y = (screenSize.height - frameSize.height) / 2;
            testWindow.setLocation(x, y);
            JPanel cp = (JPanel)testWindow.getContentPane();
            cp.setBorder(new EmptyBorder(20, 20, 20, 20));
            cp.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            root.setUserObject("I am rootie");
            DefaultTreeModel dfm = new DefaultTreeModel(root);
            DefaultMutableTreeNode n1 = new DefaultMutableTreeNode();
            n1.setUserObject("world");
            dfm.insertNodeInto(n1, root, 0);
            DefaultMutableTreeNode n2 = new DefaultMutableTreeNode();
            dfm.insertNodeInto(n2, root, 0);
            DefaultMutableTreeNode n3 = new DefaultMutableTreeNode();
            dfm.insertNodeInto(n3, n1, 0);
            DefaultMutableTreeNode n4 = new DefaultMutableTreeNode();
            dfm.insertNodeInto(n4, n1, 0);
            CheckBoxTree cbt = new CheckBoxTree(dfm);
            UiUtil.gbcSet(gbc, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
            cp.add((Component)cbt, gbc);
            testWindow.setVisible(true);
        }
        catch (Exception ioex) {
            System.err.println(ioex);
        }
    }

    public class CheckBox
    extends JPanel {
        private boolean isChecked_ = false;
        private boolean isLocked_ = false;

        public CheckBox() {
            this.setBackground(Color.white);
        }

        public void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                Dimension size = this.getSize();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
                g2.setPaint(this.isLocked_ ? Color.gray : Color.black);
                g2.draw(rect);
                if (this.isChecked_) {
                    GeneralPath currPath = new GeneralPath();
                    currPath.moveTo(0.0f, 0.0f);
                    currPath.lineTo((float)size.getWidth(), (float)size.getHeight());
                    currPath.moveTo(0.0f, (float)size.getHeight());
                    currPath.lineTo((float)size.getWidth(), 0.0f);
                    g2.draw(currPath);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayPaintException(ex);
            }
        }

        public void setChecked(boolean isChecked) {
            this.isChecked_ = isChecked;
        }

        public void setLocked(boolean isLocked) {
            this.isLocked_ = isLocked;
        }
    }

    public class CheckBoxLeaf
    extends JPanel {
        private boolean isChecked_ = false;
        private boolean isLocked_ = false;
        private Color myColor_ = Color.white;
        private String myName_ = "";
        private JLabel myLabel_;
        private CheckBox myCheckbox_;

        public CheckBoxLeaf() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.myCheckbox_ = new CheckBox();
            this.myCheckbox_.setPreferredSize(new Dimension(10, 10));
            this.myLabel_ = new JLabel(this.myName_);
            UiUtil.gbcSet(gbc, 0, 0, 1, 1, 0, 0, 0, 0, 5, 0, 5, 10, 0.0, 0.0);
            this.add((Component)this.myCheckbox_, gbc);
            UiUtil.gbcSet(gbc, 1, 0, 5, 1, 2, 0, 0, 0, 0, 0, 5, 10, 1.0, 0.0);
            this.add((Component)this.myLabel_, gbc);
            this.setBackground(this.myColor_);
        }

        public void setLeafName(String name) {
            this.myName_ = name;
            this.myLabel_.setText(this.myName_);
        }

        public void setColor(Color color) {
            this.myColor_ = color;
            this.setBackground(this.myColor_);
        }

        public void setChecked(boolean isChecked) {
            this.isChecked_ = isChecked;
            this.myCheckbox_.setChecked(isChecked);
        }

        public void setLocked(boolean isLocked) {
            this.isLocked_ = isLocked;
            this.myCheckbox_.setLocked(isLocked);
        }
    }

    public class CheckBoxCellRenderer
    extends DefaultTreeCellRenderer {
        private CheckBoxLeaf myLeaf_;

        public CheckBoxCellRenderer() {
            this.myLeaf_ = new CheckBoxLeaf();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            try {
                DefaultMutableTreeNode node;
                CheckBoxTreeLeaf leafNode;
                if (leaf && !(leafNode = (CheckBoxTreeLeaf)(node = (DefaultMutableTreeNode)value).getUserObject()).isDisplayOnly()) {
                    this.myLeaf_.setLeafName(leafNode.getName());
                    this.myLeaf_.setColor(leafNode.getColor());
                    this.myLeaf_.setChecked(leafNode.isSelected());
                    this.myLeaf_.setLocked(leafNode.isLocked());
                    return this.myLeaf_;
                }
                return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
        }

        public void mouseClicked(MouseEvent me) {
        }

        public void mouseReleased(MouseEvent me) {
            this.handleClick(me.getX(), me.getY());
        }

        private void handleClick(int x, int y) {
            try {
                TreePath tp = CheckBoxTree.this.getPathForLocation(x, y);
                if (tp == null) {
                    return;
                }
                TreeNode targetNode = (TreeNode)tp.getLastPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)targetNode;
                CheckBoxTreeLeaf leafNode = (CheckBoxTreeLeaf)node.getUserObject();
                if (!leafNode.isLocked()) {
                    leafNode.setSelected(!leafNode.isSelected());
                }
                CheckBoxTree.this.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }
}

