/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.systemsbiology.biotapestry.util.ColorLabel;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class ColorListRenderer
extends ColorLabel
implements ListCellRenderer {
    private List values_;

    public ColorListRenderer(List values) {
        super(Color.white, "");
        this.values_ = values;
    }

    public void setValues(List values) {
        this.values_ = values;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        try {
            if (value == null) {
                return this;
            }
            if (index == -1 && (index = list.getSelectedIndex()) == -1) {
                return this;
            }
            ColorSource currCol = (ColorSource)this.values_.get(index);
            this.setColorValues(currCol.getColor(), currCol.getDescription());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return this;
    }

    public static interface ColorSource {
        public Color getColor();

        public String getDescription();
    }
}

