/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.ui.NamedColor;
import org.systemsbiology.biotapestry.ui.dialogs.ColorEditorDialog;
import org.systemsbiology.biotapestry.util.ColorDeletionListener;
import org.systemsbiology.biotapestry.util.ColorLabelToo;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class ColorSelectionWidget
extends JPanel
implements ColorDeletionListener {
    public static final String VARIOUS_TAG = "__BT_WJRL_UNCHANGED_VARIOUS__";
    private JComboBox colorCombo_;
    private JFrame parent_;
    private UndoManager undo_;
    private HashMap changedColors_;
    private ColorListRenderer renderer_;
    private JButton editLaunch_;
    private List colorDeletionListeners_;
    private boolean addVarious_;
    private NamedColor variousChoice_;

    public ColorSelectionWidget(JFrame parent, UndoManager undo, List colorDeletionListeners, boolean showLabel, String altTag, boolean showButton, boolean addVarious) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ResourceManager rMan = ResourceManager.getManager();
        this.parent_ = parent;
        this.undo_ = undo;
        this.addVarious_ = addVarious;
        if (addVarious) {
            this.variousChoice_ = new NamedColor(VARIOUS_TAG, new Color(225, 225, 225), rMan.getString("colorSelector.unchanged"));
        }
        this.changedColors_ = new HashMap();
        this.colorDeletionListeners_ = colorDeletionListeners == null ? new ArrayList() : new ArrayList(colorDeletionListeners);
        this.colorDeletionListeners_.add(this);
        JLabel label = null;
        if (showLabel) {
            String tag = altTag == null ? "colorSelector.color" : altTag;
            label = new JLabel(rMan.getString(tag));
        }
        Vector choices = new Vector();
        ArrayList colorList = new ArrayList();
        this.stockColorLists(choices, colorList);
        this.colorCombo_ = new JComboBox(choices);
        this.renderer_ = new ColorListRenderer(colorList, this.colorCombo_);
        this.colorCombo_.setRenderer(this.renderer_);
        this.colorCombo_.addActionListener(this.renderer_);
        JLabel dummyLabel = null;
        if (showButton) {
            this.editLaunch_ = new JButton(rMan.getString("colorSelector.colorNew"));
            this.editLaunch_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        ColorSelectionWidget.this.changedColors_.clear();
                        ColorEditorDialog ced = new ColorEditorDialog(ColorSelectionWidget.this.parent_, ColorSelectionWidget.this.undo_, ColorSelectionWidget.this.colorDeletionListeners_);
                        ced.setVisible(true);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
        } else {
            String replacement = rMan.getString("colorSelector.colorNew");
            int dummyLength = replacement.length() + 20;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < dummyLength; ++i) {
                buf.append(' ');
            }
            dummyLabel = new JLabel(buf.toString());
        }
        int rowNum = 0;
        int colNum = 0;
        if (label != null) {
            UiUtil.gbcSet(gbc, colNum++, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
            this.add((Component)label, gbc);
        }
        UiUtil.gbcSet(gbc, colNum, rowNum, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.5, 1.0);
        this.add((Component)this.colorCombo_, gbc);
        UiUtil.gbcSet(gbc, colNum += 2, rowNum, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        if (this.editLaunch_ != null) {
            this.add((Component)this.editLaunch_, gbc);
        } else {
            this.add((Component)dummyLabel, gbc);
        }
    }

    public void colorReplacement(Map oldToNew) {
        this.changedColors_ = new HashMap(oldToNew);
        this.installColorChange();
        this.repaint();
    }

    public void setCurrentColor(String colorKey) {
        Database db = Database.getDB();
        NamedColor nc = this.addVarious_ && colorKey.equals(VARIOUS_TAG) ? this.variousChoice_ : db.getNamedColor(colorKey);
        this.colorCombo_.setSelectedItem(new ObjChoiceContent(nc.name, nc.key));
    }

    public String getCurrentColor() {
        ObjChoiceContent colName = (ObjChoiceContent)this.colorCombo_.getSelectedItem();
        return colName.val;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.colorCombo_.setEnabled(enabled);
        if (this.editLaunch_ != null) {
            this.editLaunch_.setEnabled(enabled);
        }
        this.renderer_.setGhosted(!enabled);
    }

    private void installColorChange() {
        Vector choices = new Vector();
        ArrayList colorList = new ArrayList();
        this.stockColorLists(choices, colorList);
        Database db = Database.getDB();
        this.renderer_.setValues(colorList);
        ObjChoiceContent selected = (ObjChoiceContent)this.colorCombo_.getSelectedItem();
        this.colorCombo_.setModel(new DefaultComboBoxModel(choices));
        if (choices.contains(selected)) {
            this.colorCombo_.setSelectedItem(selected);
        } else {
            String newColor = (String)this.changedColors_.get(selected.val);
            NamedColor nc = db.getNamedColor(newColor);
            this.colorCombo_.setSelectedItem(new ObjChoiceContent(nc.name, nc.key));
        }
    }

    private void stockColorLists(Vector comboChoices, List renderList) {
        NamedColor nc;
        Database db = Database.getDB();
        Iterator ckit = db.getColorKeys();
        while (ckit.hasNext()) {
            String colorKey = (String)ckit.next();
            nc = db.getNamedColor(colorKey);
            renderList.add(new NamedColor(nc));
        }
        Collections.sort(renderList);
        if (this.addVarious_) {
            renderList.add(0, this.variousChoice_);
        }
        Iterator rlit = renderList.iterator();
        while (rlit.hasNext()) {
            nc = (NamedColor)rlit.next();
            comboChoices.add(new ObjChoiceContent(nc.name, nc.key));
        }
    }

    class ColorListRenderer
    extends ColorLabelToo
    implements ListCellRenderer,
    ActionListener {
        private List values_;
        private int selIndex_;
        private boolean ghosted_;
        private JComboBox localColorCombo_;

        ColorListRenderer(List values, JComboBox colorCombo) {
            super(Color.white, "");
            this.values_ = values;
            this.selIndex_ = -1;
            this.localColorCombo_ = colorCombo;
            this.ghosted_ = false;
        }

        void setValues(List values) {
            this.values_ = values;
        }

        void setGhosted(boolean ghosted) {
            this.ghosted_ = ghosted;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                this.selIndex_ = this.localColorCombo_.getSelectedIndex();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            try {
                if (value == null) {
                    return this;
                }
                if (index == -1 && (index = this.selIndex_) == -1) {
                    return this;
                }
                NamedColor currCol = (NamedColor)this.values_.get(index);
                Color showColor = this.ghosted_ ? currCol.color.darker() : currCol.color;
                this.setColorValues(showColor, currCol.name);
                this.setEnabled(!this.ghosted_);
                this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this;
        }
    }
}

